# Тіло - Декілька параметрів { #body-multiple-parameters }

Тепер, коли ми побачили, як використовувати `Path` і `Query`, розгляньмо більш просунуті варіанти оголошення тіла запиту.

## Змішування `Path`, `Query` та параметрів тіла { #mix-path-query-and-body-parameters }

По-перше, звісно, ви можете вільно змішувати оголошення параметрів `Path`, `Query` та тіла запиту, і **FastAPI** знатиме, що робити.

Також ви можете оголошувати параметри тіла як необов’язкові, встановивши для них значення за замовчуванням `None`:

{* ../../docs_src/body_multiple_params/tutorial001_an_py310.py hl[18:20] *}

/// note | Примітка

Зверніть увагу, що в цьому випадку параметр `item`, який береться з тіла, є необов'язковим. Оскільки має значення за замовчуванням `None`.

///

## Декілька параметрів тіла { #multiple-body-parameters }

У попередньому прикладі *операції шляху* очікували б JSON-тіло з атрибутами `Item`, наприклад:

```JSON
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2
}
```

Але ви також можете оголосити декілька параметрів тіла, наприклад `item` та `user`:

{* ../../docs_src/body_multiple_params/tutorial002_py310.py hl[20] *}


У цьому випадку **FastAPI** помітить, що у функції є більше ніж один параметр тіла (є два параметри, які є моделями Pydantic).

Тож він використає назви параметрів як ключі (назви полів) у тілі та очікуватиме тіло такого вигляду:

```JSON
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    },
    "user": {
        "username": "dave",
        "full_name": "Dave Grohl"
    }
}
```

/// note | Примітка

Зверніть увагу, що хоча `item` оголошено так само, як і раніше, тепер він очікується всередині тіла з ключем `item`.

///

**FastAPI** виконає автоматичне перетворення із запиту, щоб параметр `item` отримав свій конкретний вміст, і те ж саме для `user`.

Він виконає валідацію складених даних і задокументує це таким чином у схемі OpenAPI та в автоматичній документації.

## Одиничні значення в тілі { #singular-values-in-body }

Так само як є `Query` і `Path` для визначення додаткових даних для параметрів запиту та шляху, **FastAPI** надає еквівалентний `Body`.

Наприклад, розширивши попередню модель, ви можете вирішити додати ще один ключ `importance` у те саме тіло, окрім `item` і `user`.

Якщо оголосити його як є, оскільки це одиничне значення, **FastAPI** припустить, що це параметр запиту.

Але ви можете вказати **FastAPI** обробляти його як інший ключ тіла, використовуючи `Body`:

{* ../../docs_src/body_multiple_params/tutorial003_an_py310.py hl[23] *}


У цьому випадку **FastAPI** очікуватиме тіло такого вигляду:

```JSON
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    },
    "user": {
        "username": "dave",
        "full_name": "Dave Grohl"
    },
    "importance": 5
}
```

Знову ж таки, він перетворюватиме типи даних, перевірятиме, документуватиме тощо.

## Декілька параметрів тіла та query { #multiple-body-params-and-query }

Звісно, ви також можете оголошувати додаткові query параметри щоразу, коли це потрібно, додатково до будь-яких параметрів тіла.

Оскільки за замовчуванням одиничні значення інтерпретуються як параметри запиту, вам не потрібно явно додавати `Query`, ви можете просто зробити:

```Python
q: Union[str, None] = None
```

Або в Python 3.10 і вище:

```Python
q: str | None = None
```

Наприклад:

{* ../../docs_src/body_multiple_params/tutorial004_an_py310.py hl[28] *}


/// info | Інформація

`Body` також має всі ті самі додаткові параметри валідації та метаданих, що й `Query`, `Path` та інші, які ви побачите пізніше.

///

## Вбудувати один параметр тіла { #embed-a-single-body-parameter }

Скажімо, у вас є лише один параметр тіла `item` з моделі Pydantic `Item`.

За замовчуванням **FastAPI** очікуватиме його тіло безпосередньо.

Але якщо ви хочете, щоб він очікував JSON з ключем `item`, а всередині нього — вміст моделі, як це відбувається, коли ви оголошуєте додаткові параметри тіла, ви можете використати спеціальний параметр `Body` — `embed`:

```Python
item: Item = Body(embed=True)
```

як у прикладі:

{* ../../docs_src/body_multiple_params/tutorial005_an_py310.py hl[17] *}


У цьому випадку **FastAPI** очікуватиме тіло такого вигляду:

```JSON hl_lines="2"
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    }
}
```

замість:

```JSON
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2
}
```

## Підсумок { #recap }

Ви можете додавати кілька параметрів тіла до вашої *функції операції шляху*, навіть якщо запит може мати лише одне тіло.

Але **FastAPI** обробить це, надасть вам правильні дані у функції та перевірить і задокументує правильну схему в *операції шляху*.

Також ви можете оголошувати одиничні значення, щоб отримувати їх як частину тіла.

І ви можете вказати **FastAPI** вбудовувати тіло в ключ, навіть коли оголошено лише один параметр.
