# FastAPI helfen – Hilfe erhalten

Gefällt Ihnen **FastAPI**?

Möchten Sie FastAPI, anderen Benutzern und dem Autor helfen?

Oder möchten Sie Hilfe zu **FastAPI** erhalten?

Es gibt sehr einfache Möglichkeiten zu helfen (manche erfordern nur ein oder zwei Klicks).

Und es gibt auch viele Möglichkeiten, Hilfe zu bekommen.

## Newsletter abonnieren

Sie können den (unregelmäßig erscheinenden) [**FastAPI and Friends**-Newsletter](newsletter.md){.internal-link target=_blank} abonnieren, um auf dem Laufenden zu bleiben:

* Neuigkeiten über FastAPI and Friends 🚀
* Anleitungen 📝
* Funktionen ✨
* Breaking Changes 🚨
* Tipps und Tricks ✅
## FastAPI auf Twitter folgen

<a href="https://twitter.com/fastapi" class="external-link" target="_blank">Folgen Sie @fastapi auf **Twitter**</a>, um die neuesten Nachrichten über **FastAPI** zu erhalten. 🐦

## **FastAPI** auf GitHub einen Stern geben

Sie können FastAPI auf GitHub „starren“ (durch Klicken auf den Stern-Button oben rechts): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Durch das Hinzufügen eines Sterns können andere Benutzer es leichter finden und sehen, dass es für andere bereits nützlich war.

## Das GitHub-Repository auf Releases beobachten

Sie können FastAPI in GitHub beobachten (Klicken Sie oben rechts auf den Button „watch“): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Dort können Sie „Releases only“ auswählen.

Auf diese Weise erhalten Sie Benachrichtigungen (per E-Mail), wenn es einen neuen Release (eine neue Version) von **FastAPI** mit Fehlerbehebungen und neuen Funktionen gibt.

## Mit dem Autor vernetzen

Sie können sich mit <a href="https://tiangolo.com" class="external-link" target="_blank">mir (Sebastián Ramírez / `tiangolo`)</a>, dem Autor, verbinden.

Insbesondere:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank"> Folgen Sie mir auf **GitHub**</a>.
    * Finden Sie andere Open-Source-Projekte, die ich erstellt habe und die Ihnen helfen könnten.
    * Folgen Sie mir, um mitzubekommen, wenn ich ein neues Open-Source-Projekt erstelle.
* <a href="https://twitter.com/tiangolo" class="external-link" target="_blank">Folgen Sie mir auf **Twitter**</a> oder <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Berichten Sie mir, wie Sie FastAPI verwenden (das höre ich gerne).
    * Bekommen Sie mit, wenn ich Ankündigungen mache oder neue Tools veröffentliche.
    * Sie können auch <a href="https://twitter.com/fastapi" class="external-link" target="_blank">@fastapi auf Twitter folgen</a> (ein separates Konto).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Folgen Sie mir auf **LinkedIn**</a>.
    * Bekommen Sie mit, wenn ich Ankündigungen mache oder neue Tools veröffentliche (obwohl ich Twitter häufiger verwende 🤷‍♂).
* Lesen Sie, was ich schreibe (oder folgen Sie mir) auf <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> oder <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Lesen Sie andere Ideen, Artikel, und erfahren Sie mehr über die von mir erstellten Tools.
    * Folgen Sie mir, um zu lesen, wenn ich etwas Neues veröffentliche.

## Über **FastAPI** tweeten

<a href="https://twitter.com/compose/tweet?text=Ich liebe @fastapi, weil ... https://github.com/fastapi/fastapi" class="external-link" target= "_blank">Tweeten Sie über **FastAPI**</a> und teilen Sie mir und anderen mit, warum es Ihnen gefällt. 🎉

Ich höre gerne, wie **FastAPI** verwendet wird, was Ihnen daran gefallen hat, in welchem Projekt/Unternehmen Sie es verwenden, usw.

## Für FastAPI abstimmen

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Stimmen Sie für **FastAPI** auf Slant</a >.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Stimmen Sie für **FastAPI** auf AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Berichten Sie auf StackShare, dass Sie **FastAPI** verwenden</a>.

## Anderen bei Fragen auf GitHub helfen

Sie können versuchen, anderen bei ihren Fragen zu helfen:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub-Diskussionen</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub-Issues</a>

In vielen Fällen kennen Sie möglicherweise bereits die Antwort auf diese Fragen. 🤓

Wenn Sie vielen Menschen bei ihren Fragen helfen, werden Sie offizieller [FastAPI-Experte](fastapi-people.md#experten){.internal-link target=_blank}. 🎉

Denken Sie aber daran, der wichtigste Punkt ist: Versuchen Sie, freundlich zu sein. Die Leute bringen ihre Frustrationen mit und fragen in vielen Fällen nicht auf die beste Art und Weise, aber versuchen Sie dennoch so gut wie möglich, freundlich zu sein. 🤗

Die **FastAPI**-Community soll freundlich und einladend sein. Und auch kein Mobbing oder respektloses Verhalten gegenüber anderen akzeptieren. Wir müssen uns umeinander kümmern.

---

So helfen Sie anderen bei Fragen (in Diskussionen oder Problemen):

### Die Frage verstehen

* Fragen Sie sich, ob Sie verstehen, was das **Ziel** und der Anwendungsfall der fragenden Person ist.

* Überprüfen Sie dann, ob die Frage (die überwiegende Mehrheit sind Fragen) **klar** ist.

* In vielen Fällen handelt es sich bei der gestellten Frage um eine Lösung, die der Benutzer sich vorstellt, aber es könnte eine **bessere** Lösung geben. Wenn Sie das Problem und den Anwendungsfall besser verstehen, können Sie eine bessere **Alternativlösung** vorschlagen.

* Wenn Sie die Frage nicht verstehen können, fragen Sie nach weiteren **Details**.

### Das Problem reproduzieren

In den meisten Fällen und bei den meisten Fragen ist etwas mit dem von der Person erstellten **eigenen Quellcode** los.

In vielen Fällen wird nur ein Fragment des Codes gepostet, aber das reicht nicht aus, um **das Problem zu reproduzieren**.

* Sie können die Person darum bitten, ein <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">minimales, reproduzierbares Beispiel</a> bereitzustellen, welches Sie **kopieren, einfügen** und lokal ausführen können, um den gleichen Fehler oder das gleiche Verhalten zu sehen, das die Person sieht, oder um ihren Anwendungsfall besser zu verstehen.

* Wenn Sie in Geberlaune sind, können Sie versuchen, selbst ein solches Beispiel zu erstellen, nur basierend auf der Beschreibung des Problems. Denken Sie jedoch daran, dass dies viel Zeit in Anspruch nehmen kann und dass es besser sein kann, zunächst um eine Klärung des Problems zu bitten.

### Lösungen vorschlagen

* Nachdem Sie die Frage verstanden haben, können Sie eine mögliche **Antwort** geben.

* In vielen Fällen ist es besser, das **zugrunde liegende Problem oder den Anwendungsfall** zu verstehen, da es möglicherweise einen besseren Weg zur Lösung gibt als das, was die Person versucht.

### Um Schließung bitten

Wenn die Person antwortet, besteht eine hohe Chance, dass Sie ihr Problem gelöst haben. Herzlichen Glückwunsch, **Sie sind ein Held**! 🦸

* Wenn es tatsächlich das Problem gelöst hat, können Sie sie darum bitten:

    * In GitHub-Diskussionen: den Kommentar als **Antwort** zu markieren.
    * In GitHub-Issues: Das Issue zu **schließen**.

## Das GitHub-Repository beobachten

Sie können FastAPI auf GitHub „beobachten“ (Klicken Sie oben rechts auf die Schaltfläche „watch“): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank" >https://github.com/fastapi/fastapi</a>. 👀

Wenn Sie dann „Watching“ statt „Releases only“ auswählen, erhalten Sie Benachrichtigungen, wenn jemand ein neues Issue eröffnet oder eine neue Frage stellt. Sie können auch spezifizieren, dass Sie nur über neue Issues, Diskussionen, PRs, usw. benachrichtigt werden möchten.

Dann können Sie versuchen, bei der Lösung solcher Fragen zu helfen.

## Fragen stellen

Sie können im GitHub-Repository <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">eine neue Frage erstellen</a>, zum Beispiel:

* Stellen Sie eine **Frage** oder bitten Sie um Hilfe mit einem **Problem**.
* Schlagen Sie eine neue **Funktionalität** vor.

**Hinweis**: Wenn Sie das tun, bitte ich Sie, auch anderen zu helfen. 😉

## Pull Requests prüfen

Sie können mir helfen, Pull Requests von anderen zu überprüfen (Review).

Noch einmal, bitte versuchen Sie Ihr Bestes, freundlich zu sein. 🤗

---

Hier ist, was Sie beachten sollten und wie Sie einen Pull Request überprüfen:

### Das Problem verstehen

* Stellen Sie zunächst sicher, dass Sie **das Problem verstehen**, welches der Pull Request zu lösen versucht. Möglicherweise gibt es eine längere Diskussion dazu in einer GitHub-Diskussion oder einem GitHub-Issue.

* Es besteht auch eine gute Chance, dass der Pull Request nicht wirklich benötigt wird, da das Problem auf **andere Weise** gelöst werden kann. Dann können Sie das vorschlagen oder danach fragen.

### Der Stil ist nicht so wichtig

* Machen Sie sich nicht zu viele Gedanken über Dinge wie den Stil von Commit-Nachrichten, ich werde den Commit manuell zusammenführen und anpassen.

* Machen Sie sich auch keine Sorgen über Stilregeln, es gibt bereits automatisierte Tools, die das überprüfen.

Und wenn es irgendeinen anderen Stil- oder Konsistenz-Bedarf gibt, bitte ich direkt darum oder füge zusätzliche Commits mit den erforderlichen Änderungen hinzu.

### Den Code überprüfen

* Prüfen und lesen Sie den Code, fragen Sie sich, ob er Sinn macht, **führen Sie ihn lokal aus** und testen Sie, ob er das Problem tatsächlich löst.

* Schreiben Sie dann einen **Kommentar** und berichten, dass Sie das getan haben. So weiß ich, dass Sie ihn wirklich überprüft haben.

/// info

Leider kann ich PRs, nur weil sie von Mehreren gutgeheißen wurden, nicht einfach vertrauen.

Es ist mehrmals passiert, dass es PRs mit drei, fünf oder mehr Zustimmungen gibt, wahrscheinlich weil die Beschreibung ansprechend ist, aber wenn ich die PRs überprüfe, sind sie tatsächlich fehlerhaft, haben einen Bug, oder lösen das Problem nicht, welches sie behaupten, zu lösen. 😅

Daher ist es wirklich wichtig, dass Sie den Code tatsächlich lesen und ausführen und mir in den Kommentaren mitteilen, dass Sie dies getan haben. 🤓

///

* Wenn der PR irgendwie vereinfacht werden kann, fragen Sie ruhig danach, aber seien Sie nicht zu wählerisch, es gibt viele subjektive Standpunkte (und ich habe auch meinen eigenen 🙈), also ist es besser, wenn man sich auf die wesentlichen Dinge konzentriert.

### Tests

* Helfen Sie mir zu überprüfen, dass der PR **Tests** hat.

* Überprüfen Sie, dass diese Tests vor dem PR **fehlschlagen**. 🚨

* Überprüfen Sie, dass diese Tests nach dem PR **bestanden** werden. ✅

* Viele PRs haben keine Tests. Sie können den Autor daran **erinnern**, Tests hinzuzufügen, oder Sie können sogar selbst einige Tests **vorschlagen**. Das ist eines der Dinge, die die meiste Zeit in Anspruch nehmen, und dabei können Sie viel helfen.

* Kommentieren Sie auch hier anschließend, was Sie versucht haben, sodass ich weiß, dass Sie es überprüft haben. 🤓

## Einen Pull Request erstellen

Sie können zum Quellcode mit Pull Requests [beitragen](contributing.md){.internal-link target=_blank}, zum Beispiel:

* Um einen Tippfehler zu beheben, den Sie in der Dokumentation gefunden haben.
* Um einen Artikel, ein Video oder einen Podcast über FastAPI zu teilen, den Sie erstellt oder gefunden haben, indem Sie <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">diese Datei bearbeiten</a>.
    * Stellen Sie sicher, dass Sie Ihren Link am Anfang des entsprechenden Abschnitts einfügen.
* Um zu helfen, [die Dokumentation in Ihre Sprache zu übersetzen](contributing.md#ubersetzungen){.internal-link target=_blank}.
    * Sie können auch dabei helfen, die von anderen erstellten Übersetzungen zu überprüfen (Review).
* Um neue Dokumentationsabschnitte vorzuschlagen.
* Um ein bestehendes Problem / einen bestehenden Bug zu beheben.
    * Stellen Sie sicher, dass Sie Tests hinzufügen.
* Um eine neue Funktionalität hinzuzufügen.
    * Stellen Sie sicher, dass Sie Tests hinzufügen.
    * Stellen Sie sicher, dass Sie Dokumentation hinzufügen, falls das notwendig ist.

## FastAPI pflegen

Helfen Sie mir, **FastAPI** instand zu halten! 🤓

Es gibt viel zu tun, und das meiste davon können **SIE** tun.

Die Hauptaufgaben, die Sie jetzt erledigen können, sind:

* [Helfen Sie anderen bei Fragen auf GitHub](#anderen-bei-fragen-auf-github-helfen){.internal-link target=_blank} (siehe Abschnitt oben).
* [Prüfen Sie Pull Requests](#pull-requests-prufen){.internal-link target=_blank} (siehe Abschnitt oben).

Diese beiden Dinge sind es, die **die meiste Zeit in Anspruch nehmen**. Das ist die Hauptarbeit bei der Wartung von FastAPI.

Wenn Sie mir dabei helfen können, **helfen Sie mir, FastAPI am Laufen zu erhalten** und sorgen dafür, dass es weiterhin **schneller und besser voranschreitet**. 🚀

## Beim Chat mitmachen

Treten Sie dem 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord-Chatserver</a> 👥 bei und treffen Sie sich mit anderen Mitgliedern der FastAPI-Community.

/// tip | "Tipp"

Wenn Sie Fragen haben, stellen Sie sie bei <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Diskussionen</a>, es besteht eine viel bessere Chance, dass Sie hier Hilfe von den [FastAPI-Experten](fastapi-people.md#experten){.internal-link target=_blank} erhalten.

Nutzen Sie den Chat nur für andere allgemeine Gespräche.

///

### Den Chat nicht für Fragen verwenden

Bedenken Sie, da Chats mehr „freie Konversation“ ermöglichen, dass es verlockend ist, Fragen zu stellen, die zu allgemein und schwierig zu beantworten sind, sodass Sie möglicherweise keine Antworten erhalten.

Auf GitHub hilft Ihnen die Vorlage dabei, die richtige Frage zu schreiben, sodass Sie leichter eine gute Antwort erhalten oder das Problem sogar selbst lösen können, noch bevor Sie fragen. Und auf GitHub kann ich sicherstellen, dass ich immer alles beantworte, auch wenn es einige Zeit dauert. Ich persönlich kann das mit den Chat-Systemen nicht machen. 😅

Unterhaltungen in den Chat-Systemen sind außerdem nicht so leicht durchsuchbar wie auf GitHub, sodass Fragen und Antworten möglicherweise im Gespräch verloren gehen. Und nur die auf GitHub machen einen [FastAPI-Experten](fastapi-people.md#experten){.internal-link target=_blank}, Sie werden also höchstwahrscheinlich mehr Aufmerksamkeit auf GitHub erhalten.

Auf der anderen Seite gibt es Tausende von Benutzern in den Chat-Systemen, sodass die Wahrscheinlichkeit hoch ist, dass Sie dort fast immer jemanden zum Reden finden. 😄

## Den Autor sponsern

Sie können den Autor (mich) auch über <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub-Sponsoren</a> finanziell unterstützen.

Dort könnten Sie mir als Dankeschön einen Kaffee spendieren ☕️. 😄

Und Sie können auch Silber- oder Gold-Sponsor für FastAPI werden. 🏅🎉

## Die Tools sponsern, die FastAPI unterstützen

Wie Sie in der Dokumentation gesehen haben, steht FastAPI auf den Schultern von Giganten, Starlette und Pydantic.

Sie können auch sponsern:

* <a href="https://github.com/sponsors/samuelcolvin" class="external-link" target="_blank">Samuel Colvin (Pydantic)</a>
* <a href="https://github.com/sponsors/encode" class="external-link" target="_blank">Encode (Starlette, Uvicorn)</a>

---

Danke! 🚀
