// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ImagePluginInfo.C
// ****************************************************************************

#include <ImagePluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Image,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Image,General)

// ****************************************************************************
//  Method: ImageGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ImageGeneralPluginInfo::GetName() const
{
    return "Image";
}

// ****************************************************************************
//  Method: ImageGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ImageGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ImageGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ImageGeneralPluginInfo::GetID() const
{
    return "Image_1.0";
}
// ****************************************************************************
//  Method: ImageGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ImageGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ImageGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ImageGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  ImageGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Image database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ImageGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.pnm");
    defaultPatterns.push_back("*.ppm");
    defaultPatterns.push_back("*.png");
    defaultPatterns.push_back("*.tiff");
    defaultPatterns.push_back("*.jpeg");
    defaultPatterns.push_back("*.jpg");
    defaultPatterns.push_back("*.tif");
    defaultPatterns.push_back("*.bmp");
    defaultPatterns.push_back("*.sdt");
    defaultPatterns.push_back("*.spr");
    defaultPatterns.push_back("*.imgvol");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ImageGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Image database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ImageGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return true;
}

// ****************************************************************************
//  Method:  ImageGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Image plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ImageGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
