# Notes on the API and ABI stability checking

Outcome is a header only library with a very simple data type layout designed
for strong ABI. Therefore, your shared library with functions which consume
and return Outcomes ought to be perfectly binary stable in the pure sense of
that Outcome's core `result<T, E>` and `outcome<T, E, P>` object layout will
not change, no matter what changes occur in Outcome in the future.

That is, however, in the pure sense, and it only applies to shared libraries
which do not export any Outcome implementation (i.e. `-fvisibility=hidden` etc
on ELF). Where implementation is exported e.g. in a static library, one may
also wish to ensure that the API as well as ABI is compatible. Another example
of use case are precompiled C++ Modules which tend to leak a lot of implementation
detail.

This directory contains dumps of both Outcome's API and ABI for the v2.2 library
for selected compilers and configuration, which can be useful for verifying
stability. These are what are checked per CI commit:

<dl>
  <dt>2.2-gcc7-cxx14</dt>
  <dd>This is when compiled under the C++ 14 standard by GCC 7.5.</dd>
  <dt>2.2-gcc9-cxx17</dt>
  <dd>This is when compiled under the C++ 17 standard by GCC 9.3.</dd>
</dl>

## Prerequisites for using this directory:

1. GCC 7.5 with libstdc++.
2. GCC 9.3 with libstdc++.
3. Ubuntu 20.04 LTS.

### Prerequisites if you want to check only ABI (abi-dumper):

1. `abi-dumper`
2. `abi-compliance-checker`

Run `./check-abi.sh 2.2` to check that
the current Outcome's ABI is compatible with the stored ABI. A HTML report
will be generated by the `abi-compliance-checker` tool useful for displaying
in CI servers and/or emailing to team members.

If you see breakage in this tool, please do report such ABI breakages
to https://github.com/ned14/outcome/issues.

### Prerequisites if you want to check only ABI (libabigail):

1. `abigail-tools`

Run `./check-abigail.sh 2.2` to check that
the current Outcome's ABI is compatible with the stored ABI.

If you see breakage in this tool, please do report such ABI breakages
to https://github.com/ned14/outcome/issues.

### Prerequisites if you want to check ABI and API:

1. `abi-dumper`
2. `abi-compliance-checker`

Run `./check-api-abi.sh 2.2` to check that the current Outcome's ABI and API
is compatible with the stored ABI. A HTML report
will be generated by the `abi-compliance-checker` tool useful for displaying
in CI servers and/or emailing to team members.

As users familiar with this tool will know, this form of the tool is
somewhat prone to false positives. Every failure needs to be carefully
studied to determine if it is actually a problem or not.

