<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

Mar 11, 2019

Host: Michael Dolan

Rotating Secretary: Carl Rand

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Thanh Ha - Academy Software Foundation / Linux Foundation
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [X] Bernard Lefebvre - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore

# **OCIO TSC Meeting Notes**

* Prerequisites to moving the repository to ASWF
    - Resolve "ext/" dependencies prior to the move.
    - What are we going to do with the "ext/" directory?
    - Do we maintain or replace?
    - How will this affect CI?
    - Platform specifics
        - Linux isn't so much a problem, however Windows and MacOS are another story.
        - Some of the major DCCs using OCIO are on Windows and MacOS which could prove problematic.
        - Do we need to build all the dependencies first, and then build OCIO against them.
    - It should be of the style
        - Pull the dependencies, rather than using the archive files found in the "ext/" directory.
        - Maybe also have a flag to say use my local build of the library.
        - Run CMake and build.
    - What is the motivation behind doing this?
        - This maybe a good opportunity to address the technical debt.
        - John: Happy to help connecting with the other project coordinators.
        - Mark: Uncertain that it is actually technical debt and more of a purest point of view in that we don’t want code from other sources checked into the OCIO repository?
    - It would be good to at least gain a better understanding of the dependencies.
    - Some of the current dependencies have raised red flags.
    - The LCMS color management repository has been abandoned. Is currently only used for baking ICC profiles.
    - Mark: Happy to go away and fix up what he can.
    - Larry: Raised that it may lead to security issues if we don’t do this. Old versions can cause problems. OpenEXR had this problem in the past.
    - John: Mavin solved the dependency fetch for Java a while ago. We should look to solutions like this.
    - Concerns we raised in that CMake is not the best at pulling in dependencies from the internet.
    - Patrick: We are not just able to download binaries, but we will also need to download the source of specific versions and build locally on the machine building OCIO. We will also have to be careful about static libraries and symbols. We will have to look at name-spacing things carefully.
    - We will need to make the TAC aware of any external code that is needed when we ship with the library.

* CLA/DCO requirements
    - Needs them signed before doing merges into the new repository.
    - John: Resolving issues with the initial setup. Team is currently backlogged on other projects but hoping to get something done in the next couple of days.
    - DCO when we are ready to DCO sign off with commits.
    - Every commit will have DCO sign off.
    - John: Some info can be pulled or referenced from the TAC guidelines.
    - Larry: Who needs to sign off the work?
        - John: We can refer to ​https://developercertificate.org/
    - Michael: This isn’t required until we move to the new account. Not to worry about it for now.
    - Want to have the Linux foundation CLA system up and running first, pre-sign all the CLAs, and do one commit to flick the switch.
    - Larry: Have agreed on the CLA but not on all the surrounding areas e.g. signature blocks etc.
    - **TODO**: Document DCO sign off practices in CONTRIBUTING.md.

* Googlegroup archiving & updated gh-pages deployment
    - Announced we will pull down the group in a week.
    - A script will be run to get old content and re-import it into the new lists.
    - John: Test run will done first to see how it works.
    - The OCIO website will be updated accordingly.
    - The new website has been updated but is yet to be deployed.

* Fixed functions in the repository
    - Sean asked if there has been any more follow up conversations about this.
    - Kevin thought that this wasn't a show stopper for him.
    - Kevin raised the camera log transform and whether or not the goal is being set from the ACES requirements.
    - May require to change the camera op to support ARRI.
    - **TODO**: Post a review as it's been up for a couple of weeks now.

* Next 1.1.x release
    - There are a small number of commits that will need to be signed off before the release is made.
    - Agreed to call it the 1.1.1 release.
    - It will be the first release of the year.
    - **TODO**: Michael to finalize things to push it forward.
    - **TODO**: Will need to update the change log for the new version.
