# New and Noteworthy in OGRE 1.12

This is only a high level overview. For detailed changes, see the git changelog.

## Core changes

### Component Media files

Previously all of our bundled Media files lived in the `Samples/Media` subdirectory - including the `RTShaderLib`.
However the latter is not a sample, but required to use the RTSS component.
Therefore, we now put media files that are required by a component into `Media/*` and install them independent of the Sample Media.
This allows you to merely reference these locations instead of having to copy them into your project.

Consequently, this allowed us to move various embedded resources to the filesystem for easier editing.

**ACTION REQUIRED** you must add the `Media/ShadowVolume` resource location to use the build-in algorithms.

### NEON intrinsics on all ARM platforms

We converted our SSE based OptimisedMath using SSE2NEON. While the gains are not as substantial as on x86, you can expect an speedup of about 30% for e.g. CPU skeletal animation.

### Automatic Plugin discovery for Windows Debug builds 

Ogre now automatically append the `_d` suffix to plugin library names on windows.
Consequently it does not need a `plugins_d.cfg` any more. Therefore you can now use the same config files for release and debug with the same content.

### Separate UV skyboxes removed

Ogre no longer supports `cubic_texture .. separateUV` textures. Previously it was possible to create a "fake" cubic texture unit which would actually contain 6 individual 2d textures. These could be used to render skyboxes. Only skyboxes that is.
For everything else you would need real hardware cubic textures. 
Ogre will ignore the `separateUV` part now, and create a real cubic texture anyway.
The advantage is that ogre renders the skybox with only one draw call.

**ACTION REQUIRED** If you use custom shaders on such materials, you will have to update them to cope with real cubic textures.

### RenderSystem - unified API for fixed-function and shaders

The `RenderSystem` API was modernized and streamlined for programmable pipeline usage. Consequently most of the legacy fixed function API calls were removed (e.g. `_setProjectionMatrix`, `_setSurfaceParams`).

Instead these parameters are now passed through the `GpuProgramParameters` structure to the fixed function unifying the API between fixed and programmable pipeline.

RenderSystems supporting `RSC_FIXED_FUNCTION`, now export the respective parameters through `getFixedFunctionParams`.
You can query and modify those and then apply them using `applyFixedFunctionParams`.

If you bypass the SceneManager and use the RenderSystem directly, e.g. `_setProjectionMatrix` becomes

```cpp
    auto params = rs->getFixedFunctionParams(TVC_NONE, FOG_NONE);
    params->setConstant(8, Matrix4()); // the "magic" 8 is defined in getFixedFunctionParams
    rs->applyFixedFunctionParams(params, GPV_GLOBAL);
```

### Improved Profiling

The instrumentation code inside Ogre was improved to be less costy compared to the measured code. At this we also improved the labels to be more readable (camera name vs. "_renderScene") - see [the updated Profiling tutorial](https://codedocs.xyz/OGRECave/ogre/profiler.html#profRead).

Additionally the Profiler class can now use [Remotery](https://github.com/Celtoys/Remotery) as its backend. Again see the tutorial for more details.

### Multi-language GPU Programs (since 1.12.9)

Basic programs, are compatible with GLSL and GLSLES. To avoid duplicating the whole program declaration, you can simply specify all the language types the program is compatible with as:

```cpp
fragment_program myFragmentShader glsl glsles
{
    source example.frag
}
```

### Cubemap support in compositors (since 1.12.12)

Compositors render targets can now be cubemaps by adding the `cubic` keyword to the `texture` declaration - just like with `texture_units` in materials.

To really take advantage of this, you can now also specify the camera to use when doing `render_scene` passes. This way any camera in your scene can be used as an environment-probe for cube mapping.

Additionally, there is now the `align_to_face` keyword which automatically orients the given camera to point to the targeted cubemap face.

### Breaking non-API changes

These changes require unit testing on your side as compilation will succeed, but the rendering result may vary compared to 1.11.

* `fog_override` semantics changed: previously it would only affect fixed function fog and shader autoparams would still get the global scene fog. Now both autparams and fixed function settings are affected.

* `SubMesh::setMaterialName` now immediately queries the `MaterialManager` instead of merely storing the name. This means that if you do not load any `.material` files and do an import/ export cycle of a `.mesh`, the material names will be lost. This is a common use case for offline processing of mesh files. Register a `MeshSerializerListener` to create dummy materials in this case.

* `Ogre::any_cast` now throws a `std::bad_cast` exception instead of a `Ogre::InvalidParametersException` for compatibility with `std::any_cast`. Both derive from `std::exception`, in case you want to preserve legacy compatibility.

* The `OGRE_BUILD_*` defines moved to a separate `OgreComponents.h` header. As those were typically checked with `#ifdef`, these check will silently fail. Migrate to the `Ogre.h` header instead of including headers form OgreMain directly.

* compute shaders are no longer automatically dispatched when the according material is used during rendering. You now have to explicitly reference the respective material in a [*compute* compisitor pass](https://ogrecave.github.io/ogre/api/latest/_compositor-_scripts.html#Compositor-Passes).

## Samples

As a side-effect of the stable media files effort, the Sample media files were refactored as well.
Now all GL rendersystems share a common GLSL shader codebase - likewise the D3D rendersystems and the Cg plugin use the same Cg shaders (which is just HLSL9 really).

Additionally we took advantage of the RTSS improvements and replaced any custom depth shadow code by the unified RTSS solution.

Since 1.12.7, the PBR sample additionally showcases the usage of [Filament PBR shaders](https://google.github.io/filament/Materials.html).

## Bites

The `ApplicationContext` class was split into `ApplicationContextBase` and `ApplicationContextSDL`. This allows additional implementations (like Qt) and eases consumption in projects that do not use SDL.

### Qt Integration (since 1.12.6)

There is now an glue code for Ogre-Qt interop, that builds upon the ApplicationContext abstraction.

The API exposed through the `ApplicationContextQt` class is `QWindow` based making it lightweight - only the `QtGui` module is required.
Also, this should allow extending it for QtQuick in the future, which is also `QWindow` based.

The implementation lives in a separate `OgreBitesQt` library which is only created when Qt is detected when building - so if you do not use it, you do not have to care about any Qt dependencies.

### Relocatable Install (since 1.12.9)

You can now control the lookup of Plugins and Resources with the following environment variables
- `OGRE_PLUGIN_DIR` override the `PluginFolder` setting in `plugins.cfg` at runtime
- `OGRE_CONFIG_DIR` sets a custom directory where ogre looks for `resources.cfg` and `plugins.cfg`.

Furthermore, relative locations inside `resources.cfg` are now correctly resolved in respect to that cfg file.

### Gamepad Support (since 1.12.11)

When using `ApplicationContextSDL`, you will now also get Input events for any attached gamepads.

## Real Time Shader System 3.0

The RTSS API was overhauled and is now more flexible and easy to use. You can now directly acquire shaders for an arbitrary Pass using `TargetRenderState` - without having to go through any Viewport Scheme juggling. This means that `TargetRenderState` can now replace any ad-hoc shader generator that you might have in place to leverage the Ogre maintained RTSS shader snippets.

The RTSS now defaults to Per-Pixel lighting, consequently making it the default for GL3+/ GLES2 and D3D11.

### Depth Shadowmap Support
The PSSM3 shadow stage now supports hardware PCF and automatically uses it if your shadow textures are compatible (i.e. of type `PF_DEPTH`).

Furthermore you can now use it generally for depth based textures by not calling `setSplitPoints` - it will use only the first depth shadow texture then.

### Merged Lighting calculations
The Fixed Function, Per-Pixel and Normal map sub-render states now all share the same shader code.

**ACTION REQUIRED** you must update your `RTShaderLib` for the 1.12 shaders.

## Terrain

To allow usage `PF_DEPTH` shadow textures, the "linear" depth code was dropped from the `SM2Profile`.  
Where previously you were expected to write an interpolated value of `(gl_Position.z - depthRange.x) * depthRange.w` in the fragment shader, it is now enough to just write `gl_FragCoord.z`.  
This enables early-z optimizations by the hardware and generally eases the workflow.
Refer to the Terrain Sample for the updated depth shadow scene setup.

Furthermore it is now possible to load legacy 1.7 style Terrains (aka "terrain.cfg") using `TerrainGroup::loadLegacyTerrain`.

**ACTION REQUIRED** you have to add the `Media/Terrain` resource location to use the SM2Profile Shader Generator.

## D3D9 RenderSystem

Direct3D9 feature level 9.1 is now required.

## GL/ GLES2/ GL3+

`#include` directives in GLSL shaders are now resolved by OGRE. The lookup is performed by filename using the Resource System. (based on the existing code of the Cg plugin)

Monolithic shaders are used instead of separable shader objects (SSO) by default again due to better performance and better driver support.

Since 1.12.2, the GL3+ RenderSystem supports loading SPIRV shaders. This requires SSO to be enabled though.

Starting with 1.12.10, the GLES2 RenderSystem is usable on Windows with drivers providing the `WGL_EXT_create_context_es2_profile` extension (only NVidia and Intel at the time of writing).

## DotScene Plugin (since 1.12.2)

The DotScene (aka .scene) Plugin was merged into the main repository. This format stores the scene hierarchy and is supported by the `blender2ogre` and `EasyOgreExporter` (3DS Max) exporters.

## Reversed Depth Support (since 1.12.3)

On D3D11 & GL3+, Ogre allows you to use a reversed floating-point Z-Buffer, that results in an approximately linear depth value distribution. To use this, enable the "Reversed Z-Buffer" RenderSystem option.

This will make Ogre use the `[1; 0]` range for depth values instead of the standard `[0; 1]` range. To handle this in your shaders, there is now a `OGRE_REVERSED_Z` define if revered depth is used.

## Metal RenderSystem Preview (since 1.12.7)

The implementation pretends to have Fixed Function capabilities leveraging the unified FFP API. This allows operating with a single shader, which only supports one 2D texture without lighting.

Proper lighting and texturing support, would require a Metal Shader Language support in the RTSS, which is not there yet. Therefore, the RenderSystem is tagged as EXPERIMENTAL.
However, if you only want to custom shaders on OSX, you can start experimenting with Metal now.

## Assimp Plugin (since 1.12.9)

The separate `ogre-assimp` project was merged into the main repository as the `Codec_Assimp` Plugin, which allows loading arbitrary meshes and runtime and the `OgreAssimpConverter` Tool for converting meshes to the `.mesh` format offline (which improves loading time).

Especially the introduction of `Codec_Assimp` is notable, as mesh loading now goes through the same Codec dispatching as image formats.

On the application side, you can now simply
```cpp
sceneManager->createEntity("Bike.obj")
```

## Native MovableText (since 1.12.10)

The Font class can be used to create 3D text billboards. No more snippets from the Wiki needed and everything integrates with the existing API as:

```cpp
auto font = FontManager::getSingleton().getByName("SdkTrays/Caption");
auto bbs = mSceneMgr->createBillboardSet();

font->putText(bbs, "OGRE\n ...", 10);
```