/* Copyright (c) <2003-2016> <Newton Game Dynamics>
* 
* This software is provided 'as-is', without any express or implied
* warranty. In no event will the authors be held liable for any damages
* arising from the use of this software.
* 
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely
*/


//
//Auto generated Lexical Analyzer class: dNewtonLuaLex.h
//

#ifndef __dNewtonLuaLex_h__
#define __dNewtonLuaLex_h__

#include "dString.h"

class dNewtonLuaLex
{
	public:
	dNewtonLuaLex(const char* const data);
	virtual ~dNewtonLuaLex();

	virtual int NextToken ();

	const char* GetTokenString() const
	{
		return m_tokenString.GetStr();
	}

	const char* GetData() const
	{
		return m_data;
	}

	const char* GetNextBuffer() const
	{
		return &m_data[m_index];
	}

	int GetIndex() const
	{
		return m_index;
	}

	int GetLineNumber () const
	{
		return m_lineNumber;
	}

	protected:
	void SetIndex(int index)
	{
		m_index = index;
		m_startIndex = index;
		m_tokenString = "";
	}

	char NextChar ()
	{
		char ch = m_data[m_index];
		m_index ++;
		if (ch == '\n') {
			m_lineNumber ++;
		}
		return ch;
	}

	void UnGetChar ()
	{
		m_index--;
		if (m_data[m_index] == '\n') {
			m_lineNumber --;
		}
		
	}

	void ReadBalancedExpression (char open, char close);

	void GetLexString ();
	int GetNextStateIndex (char symbol, int count, const char* const characterSet) const;

	// local lexical variables
	dString m_tokenString;
	const char* m_data;
	int m_index;
	int m_startIndex;
	int m_lineNumber;
};
#endif
