#ifndef _flextgl_h_
#define _flextgl_h_
/*
    This file is part of Magnum.

    Copyright © 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,
                2020 Vladimír Vondruš <mosra@centrum.cz>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

#include <Corrade/Utility/VisibilityMacros.h>

#include "Magnum/configure.h"
#include "Magnum/GL/GL.h"
#include "MagnumExternal/OpenGL/KHR/khrplatform.h"

/* Defensive include guards */

#if defined(__gl_h_) || defined(__gl2_h_) || defined(__gl3_h_) || defined(__gl31_h_)
#error Attempt to include auto-generated header after including gl3.h
#endif
#if defined(__gl2ext_h_) || defined(__gl3ext_h_)
#error Attempt to include auto-generated header after including gl3ext.h
#endif
#if defined(__gl2platform_h_) || defined(__gl3platform_h_)
#error Attempt to include auto-generated header after including gl3platform.h
#endif

#define __gl_h_
#define __gl2_h_
#define __gl3_h_
#define __gl31_h_
#define __gl2ext_h_
#define __gl3ext_h_
#define __gl2platform_h_
#define __gl3platform_h_

#ifdef __cplusplus
extern "C" {
#endif

void flextGLInit(Magnum::GL::Context& context);

/* Function declaration macros */

#ifndef MAGNUM_BUILD_STATIC
    #ifdef FlextGL_EXPORTS
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_EXPORT
    #else
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_IMPORT
    #endif
#else
    #define FLEXTGL_EXPORT CORRADE_VISIBILITY_STATIC
#endif

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__)
#define WIN32_LEAN_AND_MEAN 1
#ifndef WINAPI
#define WINAPI __stdcall
#endif
#define APIENTRY WINAPI
#endif

#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef GLAPI
#define GLAPI extern
#endif

/* GL version defines. Needs to be done to avoid conflicting definitions with
   other GL headers (such as qopengl.h in Qt, which has different definition
   for GLsizei and GLintptr on Windows) */
#define GL_ES_VERSION_2_0 1
#define GL_ES_VERSION_3_0 1
#define GL_ES_VERSION_3_1 1
#define GL_ES_VERSION_3_2 1

/* Data types */

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef void GLvoid;
typedef khronos_uint8_t GLubyte;
typedef int GLint;
typedef unsigned int GLuint;
typedef int GLsizei;
typedef khronos_float_t GLfloat;
typedef char GLchar;
typedef khronos_uint16_t GLhalf;
typedef khronos_intptr_t GLintptr;
typedef khronos_ssize_t GLsizeiptr;
typedef khronos_int64_t GLint64;
typedef khronos_uint64_t GLuint64;
typedef struct __GLsync *GLsync;
typedef void (APIENTRY *GLDEBUGPROC)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);
typedef void (APIENTRY *GLDEBUGPROCKHR)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);

/* Enums */

/* GL_ES_VERSION_2_0 */

#define GL_DEPTH_BUFFER_BIT 0x00000100
#define GL_STENCIL_BUFFER_BIT 0x00000400
#define GL_COLOR_BUFFER_BIT 0x00004000
#define GL_FALSE 0
#define GL_TRUE 1
#define GL_POINTS 0x0000
#define GL_LINES 0x0001
#define GL_LINE_LOOP 0x0002
#define GL_LINE_STRIP 0x0003
#define GL_TRIANGLES 0x0004
#define GL_TRIANGLE_STRIP 0x0005
#define GL_TRIANGLE_FAN 0x0006
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA_SATURATE 0x0308
#define GL_FUNC_ADD 0x8006
#define GL_BLEND_EQUATION 0x8009
#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004
#define GL_BLEND_COLOR 0x8005
#define GL_ARRAY_BUFFER 0x8892
#define GL_ELEMENT_ARRAY_BUFFER 0x8893
#define GL_ARRAY_BUFFER_BINDING 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING 0x8895
#define GL_STREAM_DRAW 0x88E0
#define GL_STATIC_DRAW 0x88E4
#define GL_DYNAMIC_DRAW 0x88E8
#define GL_BUFFER_SIZE 0x8764
#define GL_BUFFER_USAGE 0x8765
#define GL_CURRENT_VERTEX_ATTRIB 0x8626
#define GL_FRONT 0x0404
#define GL_BACK 0x0405
#define GL_FRONT_AND_BACK 0x0408
#define GL_TEXTURE_2D 0x0DE1
#define GL_CULL_FACE 0x0B44
#define GL_BLEND 0x0BE2
#define GL_DITHER 0x0BD0
#define GL_STENCIL_TEST 0x0B90
#define GL_DEPTH_TEST 0x0B71
#define GL_SCISSOR_TEST 0x0C11
#define GL_POLYGON_OFFSET_FILL 0x8037
#define GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define GL_SAMPLE_COVERAGE 0x80A0
#define GL_NO_ERROR 0
#define GL_INVALID_ENUM 0x0500
#define GL_INVALID_VALUE 0x0501
#define GL_INVALID_OPERATION 0x0502
#define GL_OUT_OF_MEMORY 0x0505
#define GL_CW 0x0900
#define GL_CCW 0x0901
#define GL_LINE_WIDTH 0x0B21
#define GL_ALIASED_POINT_SIZE_RANGE 0x846D
#define GL_ALIASED_LINE_WIDTH_RANGE 0x846E
#define GL_CULL_FACE_MODE 0x0B45
#define GL_FRONT_FACE 0x0B46
#define GL_DEPTH_RANGE 0x0B70
#define GL_DEPTH_WRITEMASK 0x0B72
#define GL_DEPTH_CLEAR_VALUE 0x0B73
#define GL_DEPTH_FUNC 0x0B74
#define GL_STENCIL_CLEAR_VALUE 0x0B91
#define GL_STENCIL_FUNC 0x0B92
#define GL_STENCIL_FAIL 0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define GL_STENCIL_REF 0x0B97
#define GL_STENCIL_VALUE_MASK 0x0B93
#define GL_STENCIL_WRITEMASK 0x0B98
#define GL_STENCIL_BACK_FUNC 0x8800
#define GL_STENCIL_BACK_FAIL 0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 0x8803
#define GL_STENCIL_BACK_REF 0x8CA3
#define GL_STENCIL_BACK_VALUE_MASK 0x8CA4
#define GL_STENCIL_BACK_WRITEMASK 0x8CA5
#define GL_VIEWPORT 0x0BA2
#define GL_SCISSOR_BOX 0x0C10
#define GL_COLOR_CLEAR_VALUE 0x0C22
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_UNPACK_ALIGNMENT 0x0CF5
#define GL_PACK_ALIGNMENT 0x0D05
#define GL_MAX_TEXTURE_SIZE 0x0D33
#define GL_MAX_VIEWPORT_DIMS 0x0D3A
#define GL_SUBPIXEL_BITS 0x0D50
#define GL_RED_BITS 0x0D52
#define GL_GREEN_BITS 0x0D53
#define GL_BLUE_BITS 0x0D54
#define GL_ALPHA_BITS 0x0D55
#define GL_DEPTH_BITS 0x0D56
#define GL_STENCIL_BITS 0x0D57
#define GL_POLYGON_OFFSET_UNITS 0x2A00
#define GL_POLYGON_OFFSET_FACTOR 0x8038
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_SAMPLE_BUFFERS 0x80A8
#define GL_SAMPLES 0x80A9
#define GL_SAMPLE_COVERAGE_VALUE 0x80AA
#define GL_SAMPLE_COVERAGE_INVERT 0x80AB
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS 0x86A3
#define GL_DONT_CARE 0x1100
#define GL_FASTEST 0x1101
#define GL_NICEST 0x1102
#define GL_GENERATE_MIPMAP_HINT 0x8192
#define GL_BYTE 0x1400
#define GL_UNSIGNED_BYTE 0x1401
#define GL_SHORT 0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT 0x1404
#define GL_UNSIGNED_INT 0x1405
#define GL_FLOAT 0x1406
#define GL_FIXED 0x140C
#define GL_DEPTH_COMPONENT 0x1902
#define GL_ALPHA 0x1906
#define GL_RGB 0x1907
#define GL_RGBA 0x1908
#define GL_LUMINANCE 0x1909
#define GL_LUMINANCE_ALPHA 0x190A
#define GL_UNSIGNED_SHORT_4_4_4_4 0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1 0x8034
#define GL_UNSIGNED_SHORT_5_6_5 0x8363
#define GL_FRAGMENT_SHADER 0x8B30
#define GL_VERTEX_SHADER 0x8B31
#define GL_MAX_VERTEX_ATTRIBS 0x8869
#define GL_MAX_VERTEX_UNIFORM_VECTORS 0x8DFB
#define GL_MAX_VARYING_VECTORS 0x8DFC
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS 0x8DFD
#define GL_SHADER_TYPE 0x8B4F
#define GL_DELETE_STATUS 0x8B80
#define GL_LINK_STATUS 0x8B82
#define GL_VALIDATE_STATUS 0x8B83
#define GL_ATTACHED_SHADERS 0x8B85
#define GL_ACTIVE_UNIFORMS 0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_ACTIVE_ATTRIBUTES 0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A
#define GL_SHADING_LANGUAGE_VERSION 0x8B8C
#define GL_CURRENT_PROGRAM 0x8B8D
#define GL_NEVER 0x0200
#define GL_LESS 0x0201
#define GL_EQUAL 0x0202
#define GL_LEQUAL 0x0203
#define GL_GREATER 0x0204
#define GL_NOTEQUAL 0x0205
#define GL_GEQUAL 0x0206
#define GL_ALWAYS 0x0207
#define GL_KEEP 0x1E00
#define GL_REPLACE 0x1E01
#define GL_INCR 0x1E02
#define GL_DECR 0x1E03
#define GL_INVERT 0x150A
#define GL_INCR_WRAP 0x8507
#define GL_DECR_WRAP 0x8508
#define GL_VENDOR 0x1F00
#define GL_RENDERER 0x1F01
#define GL_VERSION 0x1F02
#define GL_EXTENSIONS 0x1F03
#define GL_NEAREST 0x2600
#define GL_LINEAR 0x2601
#define GL_NEAREST_MIPMAP_NEAREST 0x2700
#define GL_LINEAR_MIPMAP_NEAREST 0x2701
#define GL_NEAREST_MIPMAP_LINEAR 0x2702
#define GL_LINEAR_MIPMAP_LINEAR 0x2703
#define GL_TEXTURE_MAG_FILTER 0x2800
#define GL_TEXTURE_MIN_FILTER 0x2801
#define GL_TEXTURE_WRAP_S 0x2802
#define GL_TEXTURE_WRAP_T 0x2803
#define GL_TEXTURE 0x1702
#define GL_TEXTURE_CUBE_MAP 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x851A
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE 0x851C
#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF
#define GL_ACTIVE_TEXTURE 0x84E0
#define GL_REPEAT 0x2901
#define GL_CLAMP_TO_EDGE 0x812F
#define GL_MIRRORED_REPEAT 0x8370
#define GL_FLOAT_VEC2 0x8B50
#define GL_FLOAT_VEC3 0x8B51
#define GL_FLOAT_VEC4 0x8B52
#define GL_INT_VEC2 0x8B53
#define GL_INT_VEC3 0x8B54
#define GL_INT_VEC4 0x8B55
#define GL_BOOL 0x8B56
#define GL_BOOL_VEC2 0x8B57
#define GL_BOOL_VEC3 0x8B58
#define GL_BOOL_VEC4 0x8B59
#define GL_FLOAT_MAT2 0x8B5A
#define GL_FLOAT_MAT3 0x8B5B
#define GL_FLOAT_MAT4 0x8B5C
#define GL_SAMPLER_2D 0x8B5E
#define GL_SAMPLER_CUBE 0x8B60
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE 0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE 0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE 0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#define GL_VERTEX_ATTRIB_ARRAY_POINTER 0x8645
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_IMPLEMENTATION_COLOR_READ_TYPE 0x8B9A
#define GL_IMPLEMENTATION_COLOR_READ_FORMAT 0x8B9B
#define GL_COMPILE_STATUS 0x8B81
#define GL_INFO_LOG_LENGTH 0x8B84
#define GL_SHADER_SOURCE_LENGTH 0x8B88
#define GL_SHADER_COMPILER 0x8DFA
#define GL_SHADER_BINARY_FORMATS 0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS 0x8DF9
#define GL_LOW_FLOAT 0x8DF0
#define GL_MEDIUM_FLOAT 0x8DF1
#define GL_HIGH_FLOAT 0x8DF2
#define GL_LOW_INT 0x8DF3
#define GL_MEDIUM_INT 0x8DF4
#define GL_HIGH_INT 0x8DF5
#define GL_FRAMEBUFFER 0x8D40
#define GL_RENDERBUFFER 0x8D41
#define GL_RGBA4 0x8056
#define GL_RGB5_A1 0x8057
#define GL_RGB565 0x8D62
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_STENCIL_INDEX8 0x8D48
#define GL_RENDERBUFFER_WIDTH 0x8D42
#define GL_RENDERBUFFER_HEIGHT 0x8D43
#define GL_RENDERBUFFER_INTERNAL_FORMAT 0x8D44
#define GL_RENDERBUFFER_RED_SIZE 0x8D50
#define GL_RENDERBUFFER_GREEN_SIZE 0x8D51
#define GL_RENDERBUFFER_BLUE_SIZE 0x8D52
#define GL_RENDERBUFFER_ALPHA_SIZE 0x8D53
#define GL_RENDERBUFFER_DEPTH_SIZE 0x8D54
#define GL_RENDERBUFFER_STENCIL_SIZE 0x8D55
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE 0x8CD0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME 0x8CD1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL 0x8CD2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE 0x8CD3
#define GL_COLOR_ATTACHMENT0 0x8CE0
#define GL_DEPTH_ATTACHMENT 0x8D00
#define GL_STENCIL_ATTACHMENT 0x8D20
#define GL_NONE 0
#define GL_FRAMEBUFFER_COMPLETE 0x8CD5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT 0x8CD6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT 0x8CD7
#define GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS 0x8CD9
#define GL_FRAMEBUFFER_UNSUPPORTED 0x8CDD
#define GL_FRAMEBUFFER_BINDING 0x8CA6
#define GL_RENDERBUFFER_BINDING 0x8CA7
#define GL_MAX_RENDERBUFFER_SIZE 0x84E8
#define GL_INVALID_FRAMEBUFFER_OPERATION 0x0506

/* GL_ES_VERSION_3_0 */

#define GL_READ_BUFFER 0x0C02
#define GL_UNPACK_ROW_LENGTH 0x0CF2
#define GL_UNPACK_SKIP_ROWS 0x0CF3
#define GL_UNPACK_SKIP_PIXELS 0x0CF4
#define GL_PACK_ROW_LENGTH 0x0D02
#define GL_PACK_SKIP_ROWS 0x0D03
#define GL_PACK_SKIP_PIXELS 0x0D04
#define GL_COLOR 0x1800
#define GL_DEPTH 0x1801
#define GL_STENCIL 0x1802
#define GL_RED 0x1903
#define GL_RGB8 0x8051
#define GL_RGBA8 0x8058
#define GL_RGB10_A2 0x8059
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_UNPACK_SKIP_IMAGES 0x806D
#define GL_UNPACK_IMAGE_HEIGHT 0x806E
#define GL_TEXTURE_3D 0x806F
#define GL_TEXTURE_WRAP_R 0x8072
#define GL_MAX_3D_TEXTURE_SIZE 0x8073
#define GL_UNSIGNED_INT_2_10_10_10_REV 0x8368
#define GL_MAX_ELEMENTS_VERTICES 0x80E8
#define GL_MAX_ELEMENTS_INDICES 0x80E9
#define GL_TEXTURE_MIN_LOD 0x813A
#define GL_TEXTURE_MAX_LOD 0x813B
#define GL_TEXTURE_BASE_LEVEL 0x813C
#define GL_TEXTURE_MAX_LEVEL 0x813D
#define GL_MIN 0x8007
#define GL_MAX 0x8008
#define GL_DEPTH_COMPONENT24 0x81A6
#define GL_MAX_TEXTURE_LOD_BIAS 0x84FD
#define GL_TEXTURE_COMPARE_MODE 0x884C
#define GL_TEXTURE_COMPARE_FUNC 0x884D
#define GL_CURRENT_QUERY 0x8865
#define GL_QUERY_RESULT 0x8866
#define GL_QUERY_RESULT_AVAILABLE 0x8867
#define GL_BUFFER_MAPPED 0x88BC
#define GL_BUFFER_MAP_POINTER 0x88BD
#define GL_STREAM_READ 0x88E1
#define GL_STREAM_COPY 0x88E2
#define GL_STATIC_READ 0x88E5
#define GL_STATIC_COPY 0x88E6
#define GL_DYNAMIC_READ 0x88E9
#define GL_DYNAMIC_COPY 0x88EA
#define GL_MAX_DRAW_BUFFERS 0x8824
#define GL_DRAW_BUFFER0 0x8825
#define GL_DRAW_BUFFER1 0x8826
#define GL_DRAW_BUFFER2 0x8827
#define GL_DRAW_BUFFER3 0x8828
#define GL_DRAW_BUFFER4 0x8829
#define GL_DRAW_BUFFER5 0x882A
#define GL_DRAW_BUFFER6 0x882B
#define GL_DRAW_BUFFER7 0x882C
#define GL_DRAW_BUFFER8 0x882D
#define GL_DRAW_BUFFER9 0x882E
#define GL_DRAW_BUFFER10 0x882F
#define GL_DRAW_BUFFER11 0x8830
#define GL_DRAW_BUFFER12 0x8831
#define GL_DRAW_BUFFER13 0x8832
#define GL_DRAW_BUFFER14 0x8833
#define GL_DRAW_BUFFER15 0x8834
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS 0x8B4A
#define GL_SAMPLER_3D 0x8B5F
#define GL_SAMPLER_2D_SHADOW 0x8B62
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT 0x8B8B
#define GL_PIXEL_PACK_BUFFER 0x88EB
#define GL_PIXEL_UNPACK_BUFFER 0x88EC
#define GL_PIXEL_PACK_BUFFER_BINDING 0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING 0x88EF
#define GL_FLOAT_MAT2x3 0x8B65
#define GL_FLOAT_MAT2x4 0x8B66
#define GL_FLOAT_MAT3x2 0x8B67
#define GL_FLOAT_MAT3x4 0x8B68
#define GL_FLOAT_MAT4x2 0x8B69
#define GL_FLOAT_MAT4x3 0x8B6A
#define GL_SRGB 0x8C40
#define GL_SRGB8 0x8C41
#define GL_SRGB8_ALPHA8 0x8C43
#define GL_COMPARE_REF_TO_TEXTURE 0x884E
#define GL_MAJOR_VERSION 0x821B
#define GL_MINOR_VERSION 0x821C
#define GL_NUM_EXTENSIONS 0x821D
#define GL_RGBA32F 0x8814
#define GL_RGB32F 0x8815
#define GL_RGBA16F 0x881A
#define GL_RGB16F 0x881B
#define GL_VERTEX_ATTRIB_ARRAY_INTEGER 0x88FD
#define GL_MAX_ARRAY_TEXTURE_LAYERS 0x88FF
#define GL_MIN_PROGRAM_TEXEL_OFFSET 0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET 0x8905
#define GL_MAX_VARYING_COMPONENTS 0x8B4B
#define GL_TEXTURE_2D_ARRAY 0x8C1A
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_R11F_G11F_B10F 0x8C3A
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B
#define GL_RGB9_E5 0x8C3D
#define GL_UNSIGNED_INT_5_9_9_9_REV 0x8C3E
#define GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH 0x8C76
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE 0x8C7F
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS 0x8C80
#define GL_TRANSFORM_FEEDBACK_VARYINGS 0x8C83
#define GL_TRANSFORM_FEEDBACK_BUFFER_START 0x8C84
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE 0x8C85
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN 0x8C88
#define GL_RASTERIZER_DISCARD 0x8C89
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS 0x8C8A
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS 0x8C8B
#define GL_INTERLEAVED_ATTRIBS 0x8C8C
#define GL_SEPARATE_ATTRIBS 0x8C8D
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING 0x8C8F
#define GL_RGBA32UI 0x8D70
#define GL_RGB32UI 0x8D71
#define GL_RGBA16UI 0x8D76
#define GL_RGB16UI 0x8D77
#define GL_RGBA8UI 0x8D7C
#define GL_RGB8UI 0x8D7D
#define GL_RGBA32I 0x8D82
#define GL_RGB32I 0x8D83
#define GL_RGBA16I 0x8D88
#define GL_RGB16I 0x8D89
#define GL_RGBA8I 0x8D8E
#define GL_RGB8I 0x8D8F
#define GL_RED_INTEGER 0x8D94
#define GL_RGB_INTEGER 0x8D98
#define GL_RGBA_INTEGER 0x8D99
#define GL_SAMPLER_2D_ARRAY 0x8DC1
#define GL_SAMPLER_2D_ARRAY_SHADOW 0x8DC4
#define GL_SAMPLER_CUBE_SHADOW 0x8DC5
#define GL_UNSIGNED_INT_VEC2 0x8DC6
#define GL_UNSIGNED_INT_VEC3 0x8DC7
#define GL_UNSIGNED_INT_VEC4 0x8DC8
#define GL_INT_SAMPLER_2D 0x8DCA
#define GL_INT_SAMPLER_3D 0x8DCB
#define GL_INT_SAMPLER_CUBE 0x8DCC
#define GL_INT_SAMPLER_2D_ARRAY 0x8DCF
#define GL_UNSIGNED_INT_SAMPLER_2D 0x8DD2
#define GL_UNSIGNED_INT_SAMPLER_3D 0x8DD3
#define GL_UNSIGNED_INT_SAMPLER_CUBE 0x8DD4
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY 0x8DD7
#define GL_BUFFER_ACCESS_FLAGS 0x911F
#define GL_BUFFER_MAP_LENGTH 0x9120
#define GL_BUFFER_MAP_OFFSET 0x9121
#define GL_DEPTH_COMPONENT32F 0x8CAC
#define GL_DEPTH32F_STENCIL8 0x8CAD
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV 0x8DAD
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING 0x8210
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE 0x8211
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE 0x8212
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE 0x8213
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE 0x8214
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE 0x8215
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE 0x8216
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE 0x8217
#define GL_FRAMEBUFFER_DEFAULT 0x8218
#define GL_FRAMEBUFFER_UNDEFINED 0x8219
#define GL_DEPTH_STENCIL_ATTACHMENT 0x821A
#define GL_DEPTH_STENCIL 0x84F9
#define GL_UNSIGNED_INT_24_8 0x84FA
#define GL_DEPTH24_STENCIL8 0x88F0
#define GL_UNSIGNED_NORMALIZED 0x8C17
#define GL_DRAW_FRAMEBUFFER_BINDING 0x8CA6
#define GL_READ_FRAMEBUFFER 0x8CA8
#define GL_DRAW_FRAMEBUFFER 0x8CA9
#define GL_READ_FRAMEBUFFER_BINDING 0x8CAA
#define GL_RENDERBUFFER_SAMPLES 0x8CAB
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER 0x8CD4
#define GL_MAX_COLOR_ATTACHMENTS 0x8CDF
#define GL_COLOR_ATTACHMENT1 0x8CE1
#define GL_COLOR_ATTACHMENT2 0x8CE2
#define GL_COLOR_ATTACHMENT3 0x8CE3
#define GL_COLOR_ATTACHMENT4 0x8CE4
#define GL_COLOR_ATTACHMENT5 0x8CE5
#define GL_COLOR_ATTACHMENT6 0x8CE6
#define GL_COLOR_ATTACHMENT7 0x8CE7
#define GL_COLOR_ATTACHMENT8 0x8CE8
#define GL_COLOR_ATTACHMENT9 0x8CE9
#define GL_COLOR_ATTACHMENT10 0x8CEA
#define GL_COLOR_ATTACHMENT11 0x8CEB
#define GL_COLOR_ATTACHMENT12 0x8CEC
#define GL_COLOR_ATTACHMENT13 0x8CED
#define GL_COLOR_ATTACHMENT14 0x8CEE
#define GL_COLOR_ATTACHMENT15 0x8CEF
#define GL_COLOR_ATTACHMENT16 0x8CF0
#define GL_COLOR_ATTACHMENT17 0x8CF1
#define GL_COLOR_ATTACHMENT18 0x8CF2
#define GL_COLOR_ATTACHMENT19 0x8CF3
#define GL_COLOR_ATTACHMENT20 0x8CF4
#define GL_COLOR_ATTACHMENT21 0x8CF5
#define GL_COLOR_ATTACHMENT22 0x8CF6
#define GL_COLOR_ATTACHMENT23 0x8CF7
#define GL_COLOR_ATTACHMENT24 0x8CF8
#define GL_COLOR_ATTACHMENT25 0x8CF9
#define GL_COLOR_ATTACHMENT26 0x8CFA
#define GL_COLOR_ATTACHMENT27 0x8CFB
#define GL_COLOR_ATTACHMENT28 0x8CFC
#define GL_COLOR_ATTACHMENT29 0x8CFD
#define GL_COLOR_ATTACHMENT30 0x8CFE
#define GL_COLOR_ATTACHMENT31 0x8CFF
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE 0x8D56
#define GL_MAX_SAMPLES 0x8D57
#define GL_HALF_FLOAT 0x140B
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT 0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT 0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT 0x0020
#define GL_RG 0x8227
#define GL_RG_INTEGER 0x8228
#define GL_R8 0x8229
#define GL_RG8 0x822B
#define GL_R16F 0x822D
#define GL_R32F 0x822E
#define GL_RG16F 0x822F
#define GL_RG32F 0x8230
#define GL_R8I 0x8231
#define GL_R8UI 0x8232
#define GL_R16I 0x8233
#define GL_R16UI 0x8234
#define GL_R32I 0x8235
#define GL_R32UI 0x8236
#define GL_RG8I 0x8237
#define GL_RG8UI 0x8238
#define GL_RG16I 0x8239
#define GL_RG16UI 0x823A
#define GL_RG32I 0x823B
#define GL_RG32UI 0x823C
#define GL_VERTEX_ARRAY_BINDING 0x85B5
#define GL_R8_SNORM 0x8F94
#define GL_RG8_SNORM 0x8F95
#define GL_RGB8_SNORM 0x8F96
#define GL_RGBA8_SNORM 0x8F97
#define GL_SIGNED_NORMALIZED 0x8F9C
#define GL_PRIMITIVE_RESTART_FIXED_INDEX 0x8D69
#define GL_COPY_READ_BUFFER 0x8F36
#define GL_COPY_WRITE_BUFFER 0x8F37
#define GL_COPY_READ_BUFFER_BINDING 0x8F36
#define GL_COPY_WRITE_BUFFER_BINDING 0x8F37
#define GL_UNIFORM_BUFFER 0x8A11
#define GL_UNIFORM_BUFFER_BINDING 0x8A28
#define GL_UNIFORM_BUFFER_START 0x8A29
#define GL_UNIFORM_BUFFER_SIZE 0x8A2A
#define GL_MAX_VERTEX_UNIFORM_BLOCKS 0x8A2B
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS 0x8A2D
#define GL_MAX_COMBINED_UNIFORM_BLOCKS 0x8A2E
#define GL_MAX_UNIFORM_BUFFER_BINDINGS 0x8A2F
#define GL_MAX_UNIFORM_BLOCK_SIZE 0x8A30
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS 0x8A31
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS 0x8A33
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT 0x8A34
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH 0x8A35
#define GL_ACTIVE_UNIFORM_BLOCKS 0x8A36
#define GL_UNIFORM_TYPE 0x8A37
#define GL_UNIFORM_SIZE 0x8A38
#define GL_UNIFORM_NAME_LENGTH 0x8A39
#define GL_UNIFORM_BLOCK_INDEX 0x8A3A
#define GL_UNIFORM_OFFSET 0x8A3B
#define GL_UNIFORM_ARRAY_STRIDE 0x8A3C
#define GL_UNIFORM_MATRIX_STRIDE 0x8A3D
#define GL_UNIFORM_IS_ROW_MAJOR 0x8A3E
#define GL_UNIFORM_BLOCK_BINDING 0x8A3F
#define GL_UNIFORM_BLOCK_DATA_SIZE 0x8A40
#define GL_UNIFORM_BLOCK_NAME_LENGTH 0x8A41
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS 0x8A42
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES 0x8A43
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER 0x8A44
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER 0x8A46
#define GL_INVALID_INDEX 0xFFFFFFFFu
#define GL_MAX_VERTEX_OUTPUT_COMPONENTS 0x9122
#define GL_MAX_FRAGMENT_INPUT_COMPONENTS 0x9125
#define GL_MAX_SERVER_WAIT_TIMEOUT 0x9111
#define GL_OBJECT_TYPE 0x9112
#define GL_SYNC_CONDITION 0x9113
#define GL_SYNC_STATUS 0x9114
#define GL_SYNC_FLAGS 0x9115
#define GL_SYNC_FENCE 0x9116
#define GL_SYNC_GPU_COMMANDS_COMPLETE 0x9117
#define GL_UNSIGNALED 0x9118
#define GL_SIGNALED 0x9119
#define GL_ALREADY_SIGNALED 0x911A
#define GL_TIMEOUT_EXPIRED 0x911B
#define GL_CONDITION_SATISFIED 0x911C
#define GL_WAIT_FAILED 0x911D
#define GL_SYNC_FLUSH_COMMANDS_BIT 0x00000001
#define GL_TIMEOUT_IGNORED 0xFFFFFFFFFFFFFFFFull
#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR 0x88FE
#define GL_ANY_SAMPLES_PASSED 0x8C2F
#define GL_ANY_SAMPLES_PASSED_CONSERVATIVE 0x8D6A
#define GL_SAMPLER_BINDING 0x8919
#define GL_RGB10_A2UI 0x906F
#define GL_TEXTURE_SWIZZLE_R 0x8E42
#define GL_TEXTURE_SWIZZLE_G 0x8E43
#define GL_TEXTURE_SWIZZLE_B 0x8E44
#define GL_TEXTURE_SWIZZLE_A 0x8E45
#define GL_GREEN 0x1904
#define GL_BLUE 0x1905
#define GL_INT_2_10_10_10_REV 0x8D9F
#define GL_TRANSFORM_FEEDBACK 0x8E22
#define GL_TRANSFORM_FEEDBACK_PAUSED 0x8E23
#define GL_TRANSFORM_FEEDBACK_ACTIVE 0x8E24
#define GL_TRANSFORM_FEEDBACK_BINDING 0x8E25
#define GL_PROGRAM_BINARY_RETRIEVABLE_HINT 0x8257
#define GL_PROGRAM_BINARY_LENGTH 0x8741
#define GL_NUM_PROGRAM_BINARY_FORMATS 0x87FE
#define GL_PROGRAM_BINARY_FORMATS 0x87FF
#define GL_COMPRESSED_R11_EAC 0x9270
#define GL_COMPRESSED_SIGNED_R11_EAC 0x9271
#define GL_COMPRESSED_RG11_EAC 0x9272
#define GL_COMPRESSED_SIGNED_RG11_EAC 0x9273
#define GL_COMPRESSED_RGB8_ETC2 0x9274
#define GL_COMPRESSED_SRGB8_ETC2 0x9275
#define GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9276
#define GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9277
#define GL_COMPRESSED_RGBA8_ETC2_EAC 0x9278
#define GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC 0x9279
#define GL_TEXTURE_IMMUTABLE_FORMAT 0x912F
#define GL_MAX_ELEMENT_INDEX 0x8D6B
#define GL_NUM_SAMPLE_COUNTS 0x9380
#define GL_TEXTURE_IMMUTABLE_LEVELS 0x82DF

/* GL_ES_VERSION_3_1 */

#define GL_COMPUTE_SHADER 0x91B9
#define GL_MAX_COMPUTE_UNIFORM_BLOCKS 0x91BB
#define GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS 0x91BC
#define GL_MAX_COMPUTE_IMAGE_UNIFORMS 0x91BD
#define GL_MAX_COMPUTE_SHARED_MEMORY_SIZE 0x8262
#define GL_MAX_COMPUTE_UNIFORM_COMPONENTS 0x8263
#define GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS 0x8264
#define GL_MAX_COMPUTE_ATOMIC_COUNTERS 0x8265
#define GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS 0x8266
#define GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS 0x90EB
#define GL_MAX_COMPUTE_WORK_GROUP_COUNT 0x91BE
#define GL_MAX_COMPUTE_WORK_GROUP_SIZE 0x91BF
#define GL_COMPUTE_WORK_GROUP_SIZE 0x8267
#define GL_DISPATCH_INDIRECT_BUFFER 0x90EE
#define GL_DISPATCH_INDIRECT_BUFFER_BINDING 0x90EF
#define GL_COMPUTE_SHADER_BIT 0x00000020
#define GL_DRAW_INDIRECT_BUFFER 0x8F3F
#define GL_DRAW_INDIRECT_BUFFER_BINDING 0x8F43
#define GL_MAX_UNIFORM_LOCATIONS 0x826E
#define GL_FRAMEBUFFER_DEFAULT_WIDTH 0x9310
#define GL_FRAMEBUFFER_DEFAULT_HEIGHT 0x9311
#define GL_FRAMEBUFFER_DEFAULT_SAMPLES 0x9313
#define GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS 0x9314
#define GL_MAX_FRAMEBUFFER_WIDTH 0x9315
#define GL_MAX_FRAMEBUFFER_HEIGHT 0x9316
#define GL_MAX_FRAMEBUFFER_SAMPLES 0x9318
#define GL_UNIFORM 0x92E1
#define GL_UNIFORM_BLOCK 0x92E2
#define GL_PROGRAM_INPUT 0x92E3
#define GL_PROGRAM_OUTPUT 0x92E4
#define GL_BUFFER_VARIABLE 0x92E5
#define GL_SHADER_STORAGE_BLOCK 0x92E6
#define GL_ATOMIC_COUNTER_BUFFER 0x92C0
#define GL_TRANSFORM_FEEDBACK_VARYING 0x92F4
#define GL_ACTIVE_RESOURCES 0x92F5
#define GL_MAX_NAME_LENGTH 0x92F6
#define GL_MAX_NUM_ACTIVE_VARIABLES 0x92F7
#define GL_NAME_LENGTH 0x92F9
#define GL_TYPE 0x92FA
#define GL_ARRAY_SIZE 0x92FB
#define GL_OFFSET 0x92FC
#define GL_BLOCK_INDEX 0x92FD
#define GL_ARRAY_STRIDE 0x92FE
#define GL_MATRIX_STRIDE 0x92FF
#define GL_IS_ROW_MAJOR 0x9300
#define GL_ATOMIC_COUNTER_BUFFER_INDEX 0x9301
#define GL_BUFFER_BINDING 0x9302
#define GL_BUFFER_DATA_SIZE 0x9303
#define GL_NUM_ACTIVE_VARIABLES 0x9304
#define GL_ACTIVE_VARIABLES 0x9305
#define GL_REFERENCED_BY_VERTEX_SHADER 0x9306
#define GL_REFERENCED_BY_FRAGMENT_SHADER 0x930A
#define GL_REFERENCED_BY_COMPUTE_SHADER 0x930B
#define GL_TOP_LEVEL_ARRAY_SIZE 0x930C
#define GL_TOP_LEVEL_ARRAY_STRIDE 0x930D
#define GL_LOCATION 0x930E
#define GL_VERTEX_SHADER_BIT 0x00000001
#define GL_FRAGMENT_SHADER_BIT 0x00000002
#define GL_ALL_SHADER_BITS 0xFFFFFFFF
#define GL_PROGRAM_SEPARABLE 0x8258
#define GL_ACTIVE_PROGRAM 0x8259
#define GL_PROGRAM_PIPELINE_BINDING 0x825A
#define GL_ATOMIC_COUNTER_BUFFER 0x92C0
#define GL_ATOMIC_COUNTER_BUFFER_BINDING 0x92C1
#define GL_ATOMIC_COUNTER_BUFFER_START 0x92C2
#define GL_ATOMIC_COUNTER_BUFFER_SIZE 0x92C3
#define GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS 0x92CC
#define GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS 0x92D0
#define GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS 0x8264
#define GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS 0x92D1
#define GL_MAX_VERTEX_ATOMIC_COUNTERS 0x92D2
#define GL_MAX_FRAGMENT_ATOMIC_COUNTERS 0x92D6
#define GL_MAX_COMPUTE_ATOMIC_COUNTERS 0x8265
#define GL_MAX_COMBINED_ATOMIC_COUNTERS 0x92D7
#define GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE 0x92D8
#define GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS 0x92DC
#define GL_ACTIVE_ATOMIC_COUNTER_BUFFERS 0x92D9
#define GL_UNSIGNED_INT_ATOMIC_COUNTER 0x92DB
#define GL_MAX_IMAGE_UNITS 0x8F38
#define GL_MAX_VERTEX_IMAGE_UNIFORMS 0x90CA
#define GL_MAX_FRAGMENT_IMAGE_UNIFORMS 0x90CE
#define GL_MAX_COMPUTE_IMAGE_UNIFORMS 0x91BD
#define GL_MAX_COMBINED_IMAGE_UNIFORMS 0x90CF
#define GL_IMAGE_BINDING_NAME 0x8F3A
#define GL_IMAGE_BINDING_LEVEL 0x8F3B
#define GL_IMAGE_BINDING_LAYERED 0x8F3C
#define GL_IMAGE_BINDING_LAYER 0x8F3D
#define GL_IMAGE_BINDING_ACCESS 0x8F3E
#define GL_IMAGE_BINDING_FORMAT 0x906E
#define GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT 0x00000001
#define GL_ELEMENT_ARRAY_BARRIER_BIT 0x00000002
#define GL_UNIFORM_BARRIER_BIT 0x00000004
#define GL_TEXTURE_FETCH_BARRIER_BIT 0x00000008
#define GL_SHADER_IMAGE_ACCESS_BARRIER_BIT 0x00000020
#define GL_COMMAND_BARRIER_BIT 0x00000040
#define GL_PIXEL_BUFFER_BARRIER_BIT 0x00000080
#define GL_TEXTURE_UPDATE_BARRIER_BIT 0x00000100
#define GL_BUFFER_UPDATE_BARRIER_BIT 0x00000200
#define GL_FRAMEBUFFER_BARRIER_BIT 0x00000400
#define GL_TRANSFORM_FEEDBACK_BARRIER_BIT 0x00000800
#define GL_ATOMIC_COUNTER_BARRIER_BIT 0x00001000
#define GL_ALL_BARRIER_BITS 0xFFFFFFFF
#define GL_IMAGE_2D 0x904D
#define GL_IMAGE_3D 0x904E
#define GL_IMAGE_CUBE 0x9050
#define GL_IMAGE_2D_ARRAY 0x9053
#define GL_INT_IMAGE_2D 0x9058
#define GL_INT_IMAGE_3D 0x9059
#define GL_INT_IMAGE_CUBE 0x905B
#define GL_INT_IMAGE_2D_ARRAY 0x905E
#define GL_UNSIGNED_INT_IMAGE_2D 0x9063
#define GL_UNSIGNED_INT_IMAGE_3D 0x9064
#define GL_UNSIGNED_INT_IMAGE_CUBE 0x9066
#define GL_UNSIGNED_INT_IMAGE_2D_ARRAY 0x9069
#define GL_IMAGE_FORMAT_COMPATIBILITY_TYPE 0x90C7
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE 0x90C8
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS 0x90C9
#define GL_READ_ONLY 0x88B8
#define GL_WRITE_ONLY 0x88B9
#define GL_READ_WRITE 0x88BA
#define GL_SHADER_STORAGE_BUFFER 0x90D2
#define GL_SHADER_STORAGE_BUFFER_BINDING 0x90D3
#define GL_SHADER_STORAGE_BUFFER_START 0x90D4
#define GL_SHADER_STORAGE_BUFFER_SIZE 0x90D5
#define GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS 0x90D6
#define GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS 0x90DA
#define GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS 0x90DB
#define GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS 0x90DC
#define GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS 0x90DD
#define GL_MAX_SHADER_STORAGE_BLOCK_SIZE 0x90DE
#define GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT 0x90DF
#define GL_SHADER_STORAGE_BARRIER_BIT 0x00002000
#define GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES 0x8F39
#define GL_DEPTH_STENCIL_TEXTURE_MODE 0x90EA
#define GL_STENCIL_INDEX 0x1901
#define GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5E
#define GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5F
#define GL_SAMPLE_POSITION 0x8E50
#define GL_SAMPLE_MASK 0x8E51
#define GL_SAMPLE_MASK_VALUE 0x8E52
#define GL_TEXTURE_2D_MULTISAMPLE 0x9100
#define GL_MAX_SAMPLE_MASK_WORDS 0x8E59
#define GL_MAX_COLOR_TEXTURE_SAMPLES 0x910E
#define GL_MAX_DEPTH_TEXTURE_SAMPLES 0x910F
#define GL_MAX_INTEGER_SAMPLES 0x9110
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_SAMPLES 0x9106
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS 0x9107
#define GL_TEXTURE_WIDTH 0x1000
#define GL_TEXTURE_HEIGHT 0x1001
#define GL_TEXTURE_DEPTH 0x8071
#define GL_TEXTURE_INTERNAL_FORMAT 0x1003
#define GL_TEXTURE_RED_SIZE 0x805C
#define GL_TEXTURE_GREEN_SIZE 0x805D
#define GL_TEXTURE_BLUE_SIZE 0x805E
#define GL_TEXTURE_ALPHA_SIZE 0x805F
#define GL_TEXTURE_DEPTH_SIZE 0x884A
#define GL_TEXTURE_STENCIL_SIZE 0x88F1
#define GL_TEXTURE_SHARED_SIZE 0x8C3F
#define GL_TEXTURE_RED_TYPE 0x8C10
#define GL_TEXTURE_GREEN_TYPE 0x8C11
#define GL_TEXTURE_BLUE_TYPE 0x8C12
#define GL_TEXTURE_ALPHA_TYPE 0x8C13
#define GL_TEXTURE_DEPTH_TYPE 0x8C16
#define GL_TEXTURE_COMPRESSED 0x86A1
#define GL_SAMPLER_2D_MULTISAMPLE 0x9108
#define GL_INT_SAMPLER_2D_MULTISAMPLE 0x9109
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE 0x910A
#define GL_VERTEX_ATTRIB_BINDING 0x82D4
#define GL_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D5
#define GL_VERTEX_BINDING_DIVISOR 0x82D6
#define GL_VERTEX_BINDING_OFFSET 0x82D7
#define GL_VERTEX_BINDING_STRIDE 0x82D8
#define GL_VERTEX_BINDING_BUFFER 0x8F4F
#define GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D9
#define GL_MAX_VERTEX_ATTRIB_BINDINGS 0x82DA
#define GL_MAX_VERTEX_ATTRIB_STRIDE 0x82E5

/* GL_ES_VERSION_3_2 */

#define GL_MULTISAMPLE_LINE_WIDTH_RANGE 0x9381
#define GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY 0x9382
#define GL_MULTIPLY 0x9294
#define GL_SCREEN 0x9295
#define GL_OVERLAY 0x9296
#define GL_DARKEN 0x9297
#define GL_LIGHTEN 0x9298
#define GL_COLORDODGE 0x9299
#define GL_COLORBURN 0x929A
#define GL_HARDLIGHT 0x929B
#define GL_SOFTLIGHT 0x929C
#define GL_DIFFERENCE 0x929E
#define GL_EXCLUSION 0x92A0
#define GL_HSL_HUE 0x92AD
#define GL_HSL_SATURATION 0x92AE
#define GL_HSL_COLOR 0x92AF
#define GL_HSL_LUMINOSITY 0x92B0
#define GL_DEBUG_OUTPUT_SYNCHRONOUS 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM 0x8245
#define GL_DEBUG_SOURCE_API 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY 0x8249
#define GL_DEBUG_SOURCE_APPLICATION 0x824A
#define GL_DEBUG_SOURCE_OTHER 0x824B
#define GL_DEBUG_TYPE_ERROR 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR 0x824E
#define GL_DEBUG_TYPE_PORTABILITY 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE 0x8250
#define GL_DEBUG_TYPE_OTHER 0x8251
#define GL_DEBUG_TYPE_MARKER 0x8268
#define GL_DEBUG_TYPE_PUSH_GROUP 0x8269
#define GL_DEBUG_TYPE_POP_GROUP 0x826A
#define GL_DEBUG_SEVERITY_NOTIFICATION 0x826B
#define GL_MAX_DEBUG_GROUP_STACK_DEPTH 0x826C
#define GL_DEBUG_GROUP_STACK_DEPTH 0x826D
#define GL_BUFFER 0x82E0
#define GL_SHADER 0x82E1
#define GL_PROGRAM 0x82E2
#define GL_VERTEX_ARRAY 0x8074
#define GL_QUERY 0x82E3
#define GL_PROGRAM_PIPELINE 0x82E4
#define GL_SAMPLER 0x82E6
#define GL_MAX_LABEL_LENGTH 0x82E8
#define GL_MAX_DEBUG_MESSAGE_LENGTH 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES 0x9144
#define GL_DEBUG_LOGGED_MESSAGES 0x9145
#define GL_DEBUG_SEVERITY_HIGH 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM 0x9147
#define GL_DEBUG_SEVERITY_LOW 0x9148
#define GL_DEBUG_OUTPUT 0x92E0
#define GL_CONTEXT_FLAG_DEBUG_BIT 0x00000002
#define GL_STACK_OVERFLOW 0x0503
#define GL_STACK_UNDERFLOW 0x0504
#define GL_GEOMETRY_SHADER 0x8DD9
#define GL_GEOMETRY_SHADER_BIT 0x00000004
#define GL_GEOMETRY_VERTICES_OUT 0x8916
#define GL_GEOMETRY_INPUT_TYPE 0x8917
#define GL_GEOMETRY_OUTPUT_TYPE 0x8918
#define GL_GEOMETRY_SHADER_INVOCATIONS 0x887F
#define GL_LAYER_PROVOKING_VERTEX 0x825E
#define GL_LINES_ADJACENCY 0x000A
#define GL_LINE_STRIP_ADJACENCY 0x000B
#define GL_TRIANGLES_ADJACENCY 0x000C
#define GL_TRIANGLE_STRIP_ADJACENCY 0x000D
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS 0x8DDF
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS 0x8A2C
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS 0x8A32
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS 0x9123
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS 0x9124
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES 0x8DE0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS 0x8DE1
#define GL_MAX_GEOMETRY_SHADER_INVOCATIONS 0x8E5A
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS 0x8C29
#define GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS 0x92CF
#define GL_MAX_GEOMETRY_ATOMIC_COUNTERS 0x92D5
#define GL_MAX_GEOMETRY_IMAGE_UNIFORMS 0x90CD
#define GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS 0x90D7
#define GL_FIRST_VERTEX_CONVENTION 0x8E4D
#define GL_LAST_VERTEX_CONVENTION 0x8E4E
#define GL_UNDEFINED_VERTEX 0x8260
#define GL_PRIMITIVES_GENERATED 0x8C87
#define GL_FRAMEBUFFER_DEFAULT_LAYERS 0x9312
#define GL_MAX_FRAMEBUFFER_LAYERS 0x9317
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS 0x8DA8
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED 0x8DA7
#define GL_REFERENCED_BY_GEOMETRY_SHADER 0x9309
#define GL_PRIMITIVE_BOUNDING_BOX 0x92BE
#define GL_NO_ERROR 0
#define GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT 0x00000004
#define GL_CONTEXT_FLAGS 0x821E
#define GL_LOSE_CONTEXT_ON_RESET 0x8252
#define GL_GUILTY_CONTEXT_RESET 0x8253
#define GL_INNOCENT_CONTEXT_RESET 0x8254
#define GL_UNKNOWN_CONTEXT_RESET 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY 0x8256
#define GL_NO_RESET_NOTIFICATION 0x8261
#define GL_CONTEXT_LOST 0x0507
#define GL_SAMPLE_SHADING 0x8C36
#define GL_MIN_SAMPLE_SHADING_VALUE 0x8C37
#define GL_MIN_FRAGMENT_INTERPOLATION_OFFSET 0x8E5B
#define GL_MAX_FRAGMENT_INTERPOLATION_OFFSET 0x8E5C
#define GL_FRAGMENT_INTERPOLATION_OFFSET_BITS 0x8E5D
#define GL_PATCHES 0x000E
#define GL_PATCH_VERTICES 0x8E72
#define GL_TESS_CONTROL_OUTPUT_VERTICES 0x8E75
#define GL_TESS_GEN_MODE 0x8E76
#define GL_TESS_GEN_SPACING 0x8E77
#define GL_TESS_GEN_VERTEX_ORDER 0x8E78
#define GL_TESS_GEN_POINT_MODE 0x8E79
#define GL_TRIANGLES 0x0004
#define GL_ISOLINES 0x8E7A
#define GL_QUADS 0x0007
#define GL_EQUAL 0x0202
#define GL_FRACTIONAL_ODD 0x8E7B
#define GL_FRACTIONAL_EVEN 0x8E7C
#define GL_CCW 0x0901
#define GL_CW 0x0900
#define GL_MAX_PATCH_VERTICES 0x8E7D
#define GL_MAX_TESS_GEN_LEVEL 0x8E7E
#define GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E7F
#define GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E80
#define GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS 0x8E81
#define GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS 0x8E82
#define GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS 0x8E83
#define GL_MAX_TESS_PATCH_COMPONENTS 0x8E84
#define GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS 0x8E85
#define GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS 0x8E86
#define GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS 0x8E89
#define GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS 0x8E8A
#define GL_MAX_TESS_CONTROL_INPUT_COMPONENTS 0x886C
#define GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS 0x886D
#define GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E1E
#define GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E1F
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS 0x92CD
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS 0x92CE
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS 0x92D3
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS 0x92D4
#define GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS 0x90CB
#define GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS 0x90CC
#define GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS 0x90D8
#define GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS 0x90D9
#define GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED 0x8221
#define GL_IS_PER_PATCH 0x92E7
#define GL_REFERENCED_BY_TESS_CONTROL_SHADER 0x9307
#define GL_REFERENCED_BY_TESS_EVALUATION_SHADER 0x9308
#define GL_TESS_CONTROL_SHADER 0x8E88
#define GL_TESS_EVALUATION_SHADER 0x8E87
#define GL_TESS_CONTROL_SHADER_BIT 0x00000008
#define GL_TESS_EVALUATION_SHADER_BIT 0x00000010
#define GL_TEXTURE_BORDER_COLOR 0x1004
#define GL_CLAMP_TO_BORDER 0x812D
#define GL_TEXTURE_BUFFER 0x8C2A
#define GL_TEXTURE_BUFFER_BINDING 0x8C2A
#define GL_MAX_TEXTURE_BUFFER_SIZE 0x8C2B
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING 0x8C2D
#define GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT 0x919F
#define GL_SAMPLER_BUFFER 0x8DC2
#define GL_INT_SAMPLER_BUFFER 0x8DD0
#define GL_UNSIGNED_INT_SAMPLER_BUFFER 0x8DD8
#define GL_IMAGE_BUFFER 0x9051
#define GL_INT_IMAGE_BUFFER 0x905C
#define GL_UNSIGNED_INT_IMAGE_BUFFER 0x9067
#define GL_TEXTURE_BUFFER_OFFSET 0x919D
#define GL_TEXTURE_BUFFER_SIZE 0x919E
#define GL_COMPRESSED_RGBA_ASTC_4x4 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 0x93DD
#define GL_TEXTURE_CUBE_MAP_ARRAY 0x9009
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY 0x900A
#define GL_SAMPLER_CUBE_MAP_ARRAY 0x900C
#define GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW 0x900D
#define GL_INT_SAMPLER_CUBE_MAP_ARRAY 0x900E
#define GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY 0x900F
#define GL_IMAGE_CUBE_MAP_ARRAY 0x9054
#define GL_INT_IMAGE_CUBE_MAP_ARRAY 0x905F
#define GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY 0x906A
#define GL_STENCIL_INDEX 0x1901
#define GL_STENCIL_INDEX8 0x8D48
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9102
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910B
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910C
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910D

/* GL_EXT_color_buffer_half_float */

#define GL_RGBA16F_EXT 0x881A
#define GL_RGB16F_EXT 0x881B
#define GL_RG16F_EXT 0x822F
#define GL_R16F_EXT 0x822D
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT 0x8211
#define GL_UNSIGNED_NORMALIZED_EXT 0x8C17

/* GL_EXT_draw_buffers_indexed */

#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_BLEND 0x0BE2
#define GL_FUNC_ADD 0x8006
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_MIN 0x8007
#define GL_MAX 0x8008
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004
#define GL_SRC_ALPHA_SATURATE 0x0308

/* GL_EXT_geometry_shader */

#define GL_GEOMETRY_SHADER_EXT 0x8DD9
#define GL_GEOMETRY_SHADER_BIT_EXT 0x00000004
#define GL_GEOMETRY_LINKED_VERTICES_OUT_EXT 0x8916
#define GL_GEOMETRY_LINKED_INPUT_TYPE_EXT 0x8917
#define GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT 0x8918
#define GL_GEOMETRY_SHADER_INVOCATIONS_EXT 0x887F
#define GL_LAYER_PROVOKING_VERTEX_EXT 0x825E
#define GL_LINES_ADJACENCY_EXT 0x000A
#define GL_LINE_STRIP_ADJACENCY_EXT 0x000B
#define GL_TRIANGLES_ADJACENCY_EXT 0x000C
#define GL_TRIANGLE_STRIP_ADJACENCY_EXT 0x000D
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT 0x8DDF
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT 0x8A2C
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT 0x8A32
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT 0x9123
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT 0x9124
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT 0x8DE0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT 0x8DE1
#define GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT 0x8E5A
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT 0x8C29
#define GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT 0x92CF
#define GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT 0x92D5
#define GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT 0x90CD
#define GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT 0x90D7
#define GL_FIRST_VERTEX_CONVENTION_EXT 0x8E4D
#define GL_LAST_VERTEX_CONVENTION_EXT 0x8E4E
#define GL_UNDEFINED_VERTEX_EXT 0x8260
#define GL_PRIMITIVES_GENERATED_EXT 0x8C87
#define GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT 0x9312
#define GL_MAX_FRAMEBUFFER_LAYERS_EXT 0x9317
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT 0x8DA8
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT 0x8DA7
#define GL_REFERENCED_BY_GEOMETRY_SHADER_EXT 0x9309

/* GL_EXT_tessellation_shader */

#define GL_PATCHES_EXT 0x000E
#define GL_PATCH_VERTICES_EXT 0x8E72
#define GL_TESS_CONTROL_OUTPUT_VERTICES_EXT 0x8E75
#define GL_TESS_GEN_MODE_EXT 0x8E76
#define GL_TESS_GEN_SPACING_EXT 0x8E77
#define GL_TESS_GEN_VERTEX_ORDER_EXT 0x8E78
#define GL_TESS_GEN_POINT_MODE_EXT 0x8E79
#define GL_TRIANGLES 0x0004
#define GL_ISOLINES_EXT 0x8E7A
#define GL_QUADS_EXT 0x0007
#define GL_EQUAL 0x0202
#define GL_FRACTIONAL_ODD_EXT 0x8E7B
#define GL_FRACTIONAL_EVEN_EXT 0x8E7C
#define GL_CCW 0x0901
#define GL_CW 0x0900
#define GL_MAX_PATCH_VERTICES_EXT 0x8E7D
#define GL_MAX_TESS_GEN_LEVEL_EXT 0x8E7E
#define GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT 0x8E7F
#define GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT 0x8E80
#define GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT 0x8E81
#define GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT 0x8E82
#define GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT 0x8E83
#define GL_MAX_TESS_PATCH_COMPONENTS_EXT 0x8E84
#define GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT 0x8E85
#define GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT 0x8E86
#define GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT 0x8E89
#define GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT 0x8E8A
#define GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT 0x886C
#define GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT 0x886D
#define GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT 0x8E1E
#define GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT 0x8E1F
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT 0x92CD
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT 0x92CE
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT 0x92D3
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT 0x92D4
#define GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT 0x90CB
#define GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT 0x90CC
#define GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT 0x90D8
#define GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT 0x90D9
#define GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED 0x8221
#define GL_IS_PER_PATCH_EXT 0x92E7
#define GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT 0x9307
#define GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT 0x9308
#define GL_TESS_CONTROL_SHADER_EXT 0x8E88
#define GL_TESS_EVALUATION_SHADER_EXT 0x8E87
#define GL_TESS_CONTROL_SHADER_BIT_EXT 0x00000008
#define GL_TESS_EVALUATION_SHADER_BIT_EXT 0x00000010

/* GL_EXT_texture_border_clamp */

#define GL_TEXTURE_BORDER_COLOR_EXT 0x1004
#define GL_CLAMP_TO_BORDER_EXT 0x812D

/* GL_EXT_texture_buffer */

#define GL_TEXTURE_BUFFER_EXT 0x8C2A
#define GL_TEXTURE_BUFFER_BINDING_EXT 0x8C2A
#define GL_MAX_TEXTURE_BUFFER_SIZE_EXT 0x8C2B
#define GL_TEXTURE_BINDING_BUFFER_EXT 0x8C2C
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT 0x8C2D
#define GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT 0x919F
#define GL_SAMPLER_BUFFER_EXT 0x8DC2
#define GL_INT_SAMPLER_BUFFER_EXT 0x8DD0
#define GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT 0x8DD8
#define GL_IMAGE_BUFFER_EXT 0x9051
#define GL_INT_IMAGE_BUFFER_EXT 0x905C
#define GL_UNSIGNED_INT_IMAGE_BUFFER_EXT 0x9067
#define GL_TEXTURE_BUFFER_OFFSET_EXT 0x919D
#define GL_TEXTURE_BUFFER_SIZE_EXT 0x919E

/* GL_EXT_texture_cube_map_array */

#define GL_TEXTURE_CUBE_MAP_ARRAY_EXT 0x9009
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT 0x900A
#define GL_SAMPLER_CUBE_MAP_ARRAY_EXT 0x900C
#define GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT 0x900D
#define GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT 0x900E
#define GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT 0x900F
#define GL_IMAGE_CUBE_MAP_ARRAY_EXT 0x9054
#define GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT 0x905F
#define GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT 0x906A

/* GL_EXT_primitive_bounding_box */

#define GL_PRIMITIVE_BOUNDING_BOX_EXT 0x92BE

/* GL_KHR_debug */

#define GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION_KHR 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM_KHR 0x8245
#define GL_DEBUG_SOURCE_API_KHR 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER_KHR 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY_KHR 0x8249
#define GL_DEBUG_SOURCE_APPLICATION_KHR 0x824A
#define GL_DEBUG_SOURCE_OTHER_KHR 0x824B
#define GL_DEBUG_TYPE_ERROR_KHR 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR 0x824E
#define GL_DEBUG_TYPE_PORTABILITY_KHR 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE_KHR 0x8250
#define GL_DEBUG_TYPE_OTHER_KHR 0x8251
#define GL_DEBUG_TYPE_MARKER_KHR 0x8268
#define GL_DEBUG_TYPE_PUSH_GROUP_KHR 0x8269
#define GL_DEBUG_TYPE_POP_GROUP_KHR 0x826A
#define GL_DEBUG_SEVERITY_NOTIFICATION_KHR 0x826B
#define GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR 0x826C
#define GL_DEBUG_GROUP_STACK_DEPTH_KHR 0x826D
#define GL_BUFFER_KHR 0x82E0
#define GL_SHADER_KHR 0x82E1
#define GL_PROGRAM_KHR 0x82E2
#define GL_VERTEX_ARRAY_KHR 0x8074
#define GL_QUERY_KHR 0x82E3
#define GL_PROGRAM_PIPELINE_KHR 0x82E4
#define GL_SAMPLER_KHR 0x82E6
#define GL_MAX_LABEL_LENGTH_KHR 0x82E8
#define GL_MAX_DEBUG_MESSAGE_LENGTH_KHR 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES_KHR 0x9144
#define GL_DEBUG_LOGGED_MESSAGES_KHR 0x9145
#define GL_DEBUG_SEVERITY_HIGH_KHR 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM_KHR 0x9147
#define GL_DEBUG_SEVERITY_LOW_KHR 0x9148
#define GL_DEBUG_OUTPUT_KHR 0x92E0
#define GL_CONTEXT_FLAG_DEBUG_BIT_KHR 0x00000002
#define GL_STACK_OVERFLOW_KHR 0x0503
#define GL_STACK_UNDERFLOW_KHR 0x0504

/* GL_KHR_blend_equation_advanced */

#define GL_MULTIPLY_KHR 0x9294
#define GL_SCREEN_KHR 0x9295
#define GL_OVERLAY_KHR 0x9296
#define GL_DARKEN_KHR 0x9297
#define GL_LIGHTEN_KHR 0x9298
#define GL_COLORDODGE_KHR 0x9299
#define GL_COLORBURN_KHR 0x929A
#define GL_HARDLIGHT_KHR 0x929B
#define GL_SOFTLIGHT_KHR 0x929C
#define GL_DIFFERENCE_KHR 0x929E
#define GL_EXCLUSION_KHR 0x92A0
#define GL_HSL_HUE_KHR 0x92AD
#define GL_HSL_SATURATION_KHR 0x92AE
#define GL_HSL_COLOR_KHR 0x92AF
#define GL_HSL_LUMINOSITY_KHR 0x92B0

/* GL_KHR_robustness */

#define GL_NO_ERROR 0
#define GL_CONTEXT_ROBUST_ACCESS_KHR 0x90F3
#define GL_LOSE_CONTEXT_ON_RESET_KHR 0x8252
#define GL_GUILTY_CONTEXT_RESET_KHR 0x8253
#define GL_INNOCENT_CONTEXT_RESET_KHR 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_KHR 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY_KHR 0x8256
#define GL_NO_RESET_NOTIFICATION_KHR 0x8261
#define GL_CONTEXT_LOST_KHR 0x0507

/* GL_OES_texture_compression_astc */

#define GL_COMPRESSED_RGBA_ASTC_4x4_KHR 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4_KHR 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5_KHR 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5_KHR 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6_KHR 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5_KHR 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6_KHR 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8_KHR 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5_KHR 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6_KHR 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8_KHR 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10_KHR 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10_KHR 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12_KHR 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR 0x93DD
#define GL_COMPRESSED_RGBA_ASTC_3x3x3_OES 0x93C0
#define GL_COMPRESSED_RGBA_ASTC_4x3x3_OES 0x93C1
#define GL_COMPRESSED_RGBA_ASTC_4x4x3_OES 0x93C2
#define GL_COMPRESSED_RGBA_ASTC_4x4x4_OES 0x93C3
#define GL_COMPRESSED_RGBA_ASTC_5x4x4_OES 0x93C4
#define GL_COMPRESSED_RGBA_ASTC_5x5x4_OES 0x93C5
#define GL_COMPRESSED_RGBA_ASTC_5x5x5_OES 0x93C6
#define GL_COMPRESSED_RGBA_ASTC_6x5x5_OES 0x93C7
#define GL_COMPRESSED_RGBA_ASTC_6x6x5_OES 0x93C8
#define GL_COMPRESSED_RGBA_ASTC_6x6x6_OES 0x93C9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES 0x93E0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES 0x93E1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES 0x93E2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES 0x93E3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES 0x93E4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES 0x93E5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES 0x93E6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES 0x93E7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES 0x93E8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES 0x93E9

/* GL_OES_sample_shading */

#define GL_SAMPLE_SHADING_OES 0x8C36
#define GL_MIN_SAMPLE_SHADING_VALUE_OES 0x8C37

/* GL_OES_shader_multisample_interpolation */

#define GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES 0x8E5B
#define GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES 0x8E5C
#define GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES 0x8E5D

/* GL_OES_texture_stencil8 */

#define GL_STENCIL_INDEX_OES 0x1901
#define GL_STENCIL_INDEX8_OES 0x8D48

/* GL_OES_texture_storage_multisample_2d_array */

#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES 0x9102
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES 0x9105
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES 0x910B
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES 0x910C
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES 0x910D

/* GL_APPLE_texture_format_BGRA8888 */

#define GL_BGRA_EXT 0x80E1
#define GL_BGRA8_EXT 0x93A1

/* GL_ARM_shader_framebuffer_fetch */

#define GL_FETCH_PER_SAMPLE_ARM 0x8F65
#define GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM 0x8F66

/* GL_EXT_texture_filter_anisotropic */

#define GL_TEXTURE_MAX_ANISOTROPY_EXT 0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF

/* GL_EXT_texture_format_BGRA8888 */

#define GL_BGRA_EXT 0x80E1

/* GL_EXT_read_format_bgra */

#define GL_BGRA_EXT 0x80E1
#define GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT 0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT 0x8366

/* GL_EXT_debug_label */

#define GL_PROGRAM_PIPELINE_OBJECT_EXT 0x8A4F
#define GL_PROGRAM_OBJECT_EXT 0x8B40
#define GL_SHADER_OBJECT_EXT 0x8B48
#define GL_BUFFER_OBJECT_EXT 0x9151
#define GL_QUERY_OBJECT_EXT 0x9153
#define GL_VERTEX_ARRAY_OBJECT_EXT 0x9154
#define GL_SAMPLER 0x82E6
#define GL_TRANSFORM_FEEDBACK 0x8E22

/* GL_EXT_separate_shader_objects */

#define GL_VERTEX_SHADER_BIT_EXT 0x00000001
#define GL_FRAGMENT_SHADER_BIT_EXT 0x00000002
#define GL_ALL_SHADER_BITS_EXT 0xFFFFFFFF
#define GL_PROGRAM_SEPARABLE_EXT 0x8258
#define GL_ACTIVE_PROGRAM_EXT 0x8259
#define GL_PROGRAM_PIPELINE_BINDING_EXT 0x825A

/* GL_EXT_multisampled_render_to_texture */

#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT 0x8D6C
#define GL_RENDERBUFFER_SAMPLES_EXT 0x8CAB
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT 0x8D56
#define GL_MAX_SAMPLES_EXT 0x8D57

/* GL_EXT_robustness */

#define GL_NO_ERROR 0
#define GL_GUILTY_CONTEXT_RESET_EXT 0x8253
#define GL_INNOCENT_CONTEXT_RESET_EXT 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_EXT 0x8255
#define GL_CONTEXT_ROBUST_ACCESS_EXT 0x90F3
#define GL_RESET_NOTIFICATION_STRATEGY_EXT 0x8256
#define GL_LOSE_CONTEXT_ON_RESET_EXT 0x8252
#define GL_NO_RESET_NOTIFICATION_EXT 0x8261

/* GL_EXT_shader_framebuffer_fetch */

#define GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT 0x8A52

/* GL_EXT_disjoint_timer_query */

#define GL_QUERY_COUNTER_BITS_EXT 0x8864
#define GL_CURRENT_QUERY_EXT 0x8865
#define GL_QUERY_RESULT_EXT 0x8866
#define GL_QUERY_RESULT_AVAILABLE_EXT 0x8867
#define GL_TIME_ELAPSED_EXT 0x88BF
#define GL_TIMESTAMP_EXT 0x8E28
#define GL_GPU_DISJOINT_EXT 0x8FBB

/* GL_EXT_texture_sRGB_decode */

#define GL_TEXTURE_SRGB_DECODE_EXT 0x8A48
#define GL_DECODE_EXT 0x8A49
#define GL_SKIP_DECODE_EXT 0x8A4A

/* GL_EXT_sRGB_write_control */

#define GL_FRAMEBUFFER_SRGB_EXT 0x8DB9

/* GL_EXT_texture_compression_s3tc */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

/* GL_EXT_pvrtc_sRGB */

#define GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT 0x8A54
#define GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT 0x8A55
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT 0x8A56
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT 0x8A57
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG 0x93F0
#define GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG 0x93F1

/* GL_EXT_texture_sRGB_R8 */

#define GL_SR8_EXT 0x8FBD

/* GL_EXT_texture_sRGB_RG8 */

#define GL_SRG8_EXT 0x8FBE

/* GL_EXT_polygon_offset_clamp */

#define GL_POLYGON_OFFSET_CLAMP_EXT 0x8E1B

/* GL_EXT_clip_cull_distance */

#define GL_MAX_CLIP_DISTANCES_EXT 0x0D32
#define GL_MAX_CULL_DISTANCES_EXT 0x82F9
#define GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT 0x82FA
#define GL_CLIP_DISTANCE0_EXT 0x3000
#define GL_CLIP_DISTANCE1_EXT 0x3001
#define GL_CLIP_DISTANCE2_EXT 0x3002
#define GL_CLIP_DISTANCE3_EXT 0x3003
#define GL_CLIP_DISTANCE4_EXT 0x3004
#define GL_CLIP_DISTANCE5_EXT 0x3005
#define GL_CLIP_DISTANCE6_EXT 0x3006
#define GL_CLIP_DISTANCE7_EXT 0x3007

/* GL_EXT_texture_compression_rgtc */

#define GL_COMPRESSED_RED_RGTC1_EXT 0x8DBB
#define GL_COMPRESSED_SIGNED_RED_RGTC1_EXT 0x8DBC
#define GL_COMPRESSED_RED_GREEN_RGTC2_EXT 0x8DBD
#define GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT 0x8DBE

/* GL_EXT_texture_compression_bptc */

#define GL_COMPRESSED_RGBA_BPTC_UNORM_EXT 0x8E8C
#define GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT 0x8E8D
#define GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT 0x8E8E
#define GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT 0x8E8F

/* GL_EXT_texture_compression_s3tc_srgb */

#define GL_COMPRESSED_SRGB_S3TC_DXT1_EXT 0x8C4C
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT 0x8C4D
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT 0x8C4E
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT 0x8C4F

/* GL_IMG_texture_compression_pvrtc */

#define GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG 0x8C00
#define GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG 0x8C01
#define GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG 0x8C02
#define GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG 0x8C03

/* GL_KHR_blend_equation_advanced_coherent */

#define GL_BLEND_ADVANCED_COHERENT_KHR 0x9285

/* GL_KHR_context_flush_control */

#define GL_CONTEXT_RELEASE_BEHAVIOR_KHR 0x82FB
#define GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR 0x82FC
#define GL_NONE 0

/* GL_KHR_no_error */

#define GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR 0x00000008

/* GL_NV_texture_border_clamp */

#define GL_TEXTURE_BORDER_COLOR_NV 0x1004
#define GL_CLAMP_TO_BORDER_NV 0x812D

/* GL_NV_sample_locations */

#define GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV 0x933D
#define GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV 0x933E
#define GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV 0x933F
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV 0x9340
#define GL_SAMPLE_LOCATION_NV 0x8E50
#define GL_PROGRAMMABLE_SAMPLE_LOCATION_NV 0x9341
#define GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV 0x9342
#define GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV 0x9343

/* GL_NV_polygon_mode */

#define GL_POLYGON_MODE_NV 0x0B40
#define GL_POLYGON_OFFSET_POINT_NV 0x2A01
#define GL_POLYGON_OFFSET_LINE_NV 0x2A02
#define GL_POINT_NV 0x1B00
#define GL_LINE_NV 0x1B01
#define GL_FILL_NV 0x1B02

/* GL_OES_depth32 */

#define GL_DEPTH_COMPONENT32_OES 0x81A7

/* GL_OES_mapbuffer */

#define GL_WRITE_ONLY_OES 0x88B9
#define GL_BUFFER_ACCESS_OES 0x88BB
#define GL_BUFFER_MAPPED_OES 0x88BC
#define GL_BUFFER_MAP_POINTER_OES 0x88BD

/* GL_OES_stencil1 */

#define GL_STENCIL_INDEX1_OES 0x8D46

/* GL_OES_stencil4 */

#define GL_STENCIL_INDEX4_OES 0x8D47

/* GL_OVR_multiview */

#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR 0x9630
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR 0x9632
#define GL_MAX_VIEWS_OVR 0x9631
#define GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR 0x9633

/* Function prototypes */

/* GL_ES_VERSION_2_0 */

GLAPI FLEXTGL_EXPORT void APIENTRY glActiveTexture(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glAttachShader(GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindAttribLocation(GLuint, GLuint, const GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindBuffer(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindFramebuffer(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindRenderbuffer(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindTexture(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendColor(GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendEquation(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendEquationSeparate(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendFunc(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlendFuncSeparate(GLenum, GLenum, GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBufferData(GLenum, GLsizeiptr, const void *, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBufferSubData(GLenum, GLintptr, GLsizeiptr, const void *);
GLAPI FLEXTGL_EXPORT GLenum APIENTRY glCheckFramebufferStatus(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glClear(GLbitfield);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearColor(GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearDepthf(GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearStencil(GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glColorMask(GLboolean, GLboolean, GLboolean, GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glCompileShader(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCompressedTexImage2D(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glCompressedTexSubImage2D(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexImage2D(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexSubImage2D(GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT GLuint APIENTRY glCreateProgram(void);
GLAPI FLEXTGL_EXPORT GLuint APIENTRY glCreateShader(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glCullFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteBuffers(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteFramebuffers(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteProgram(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteRenderbuffers(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteShader(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteTextures(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthFunc(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthMask(GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthRangef(GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glDetachShader(GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glDisable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDisableVertexAttribArray(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawArrays(GLenum, GLint, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawElements(GLenum, GLsizei, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glEnable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glEnableVertexAttribArray(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glFinish(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFlush(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFramebufferRenderbuffer(GLenum, GLenum, GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glFramebufferTexture2D(GLenum, GLenum, GLenum, GLuint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glFrontFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenBuffers(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenFramebuffers(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenRenderbuffers(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenTextures(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenerateMipmap(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetActiveAttrib(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetActiveUniform(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetAttachedShaders(GLuint, GLsizei, GLsizei *, GLuint *);
GLAPI FLEXTGL_EXPORT GLint APIENTRY glGetAttribLocation(GLuint, const GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBooleanv(GLenum, GLboolean *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBufferParameteriv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT GLenum APIENTRY glGetError(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetFloatv(GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetFramebufferAttachmentParameteriv(GLenum, GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetIntegerv(GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetProgramInfoLog(GLuint, GLsizei, GLsizei *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetProgramiv(GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetRenderbufferParameteriv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetShaderInfoLog(GLuint, GLsizei, GLsizei *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetShaderPrecisionFormat(GLenum, GLenum, GLint *, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetShaderSource(GLuint, GLsizei, GLsizei *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetShaderiv(GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT const GLubyte * APIENTRY glGetString(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameterfv(GLenum, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameteriv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT GLint APIENTRY glGetUniformLocation(GLuint, const GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetUniformfv(GLuint, GLint, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetUniformiv(GLuint, GLint, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetVertexAttribPointerv(GLuint, GLenum, void **);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetVertexAttribfv(GLuint, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetVertexAttribiv(GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glHint(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsBuffer(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsEnabled(GLenum);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsFramebuffer(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsProgram(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsRenderbuffer(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsShader(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsTexture(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glLineWidth(GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glLinkProgram(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glPixelStorei(GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glPolygonOffset(GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glReadPixels(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glReleaseShaderCompiler(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glRenderbufferStorage(GLenum, GLenum, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glSampleCoverage(GLfloat, GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glScissor(GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glShaderBinary(GLsizei, const GLuint *, GLenum, const void *, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glShaderSource(GLuint, GLsizei, const GLchar *const*, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilFunc(GLenum, GLint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilFuncSeparate(GLenum, GLenum, GLint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilMask(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilMaskSeparate(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilOp(GLenum, GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilOpSeparate(GLenum, GLenum, GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexImage2D(GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterf(GLenum, GLenum, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterfv(GLenum, GLenum, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteri(GLenum, GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteriv(GLenum, GLenum, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexSubImage2D(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1f(GLint, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1fv(GLint, GLsizei, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1i(GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1iv(GLint, GLsizei, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2f(GLint, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2fv(GLint, GLsizei, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2i(GLint, GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2iv(GLint, GLsizei, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3f(GLint, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3fv(GLint, GLsizei, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3i(GLint, GLint, GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3iv(GLint, GLsizei, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4f(GLint, GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4fv(GLint, GLsizei, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4i(GLint, GLint, GLint, GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4iv(GLint, GLsizei, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix2fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix3fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix4fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUseProgram(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glValidateProgram(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib1f(GLuint, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib1fv(GLuint, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib2f(GLuint, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib2fv(GLuint, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib3f(GLuint, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib3fv(GLuint, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib4f(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttrib4fv(GLuint, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribPointer(GLuint, GLint, GLenum, GLboolean, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glViewport(GLint, GLint, GLsizei, GLsizei);

/* GL_ES_VERSION_3_0 */

GLAPI FLEXTGL_EXPORT void APIENTRY glBeginQuery(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBeginTransformFeedback(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindBufferBase(GLenum, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindBufferRange(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindSampler(GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindTransformFeedback(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBindVertexArray(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glBlitFramebuffer(GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearBufferfi(GLenum, GLint, GLfloat, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearBufferfv(GLenum, GLint, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearBufferiv(GLenum, GLint, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearBufferuiv(GLenum, GLint, const GLuint *);
GLAPI FLEXTGL_EXPORT GLenum APIENTRY glClientWaitSync(GLsync, GLbitfield, GLuint64);
GLAPI FLEXTGL_EXPORT void APIENTRY glCompressedTexImage3D(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glCompressedTexSubImage3D(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyBufferSubData(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexSubImage3D(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteQueries(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteSamplers(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteSync(GLsync);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteTransformFeedbacks(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteVertexArrays(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawArraysInstanced(GLenum, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawBuffers(GLsizei, const GLenum *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawElementsInstanced(GLenum, GLsizei, GLenum, const void *, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawRangeElements(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glEndQuery(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glEndTransformFeedback(void);
GLAPI FLEXTGL_EXPORT GLsync APIENTRY glFenceSync(GLenum, GLbitfield);
GLAPI FLEXTGL_EXPORT void APIENTRY glFlushMappedBufferRange(GLenum, GLintptr, GLsizeiptr);
GLAPI FLEXTGL_EXPORT void APIENTRY glFramebufferTextureLayer(GLenum, GLenum, GLuint, GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenQueries(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenSamplers(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenTransformFeedbacks(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenVertexArrays(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetActiveUniformBlockName(GLuint, GLuint, GLsizei, GLsizei *, GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetActiveUniformBlockiv(GLuint, GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetActiveUniformsiv(GLuint, GLsizei, const GLuint *, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBufferParameteri64v(GLenum, GLenum, GLint64 *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBufferPointerv(GLenum, GLenum, void **);
GLAPI FLEXTGL_EXPORT GLint APIENTRY glGetFragDataLocation(GLuint, const GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetInteger64i_v(GLenum, GLuint, GLint64 *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetInteger64v(GLenum, GLint64 *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetIntegeri_v(GLenum, GLuint, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetInternalformativ(GLenum, GLenum, GLenum, GLsizei, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetProgramBinary(GLuint, GLsizei, GLsizei *, GLenum *, void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetQueryObjectuiv(GLuint, GLenum, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetQueryiv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetSamplerParameterfv(GLuint, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetSamplerParameteriv(GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT const GLubyte * APIENTRY glGetStringi(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetSynciv(GLsync, GLenum, GLsizei, GLsizei *, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTransformFeedbackVarying(GLuint, GLuint, GLsizei, GLsizei *, GLsizei *, GLenum *, GLchar *);
GLAPI FLEXTGL_EXPORT GLuint APIENTRY glGetUniformBlockIndex(GLuint, const GLchar *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetUniformIndices(GLuint, GLsizei, const GLchar *const*, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetUniformuiv(GLuint, GLint, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetVertexAttribIiv(GLuint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetVertexAttribIuiv(GLuint, GLenum, GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glInvalidateFramebuffer(GLenum, GLsizei, const GLenum *);
GLAPI FLEXTGL_EXPORT void APIENTRY glInvalidateSubFramebuffer(GLenum, GLsizei, const GLenum *, GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsQuery(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsSampler(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsSync(GLsync);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsTransformFeedback(GLuint);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsVertexArray(GLuint);
GLAPI FLEXTGL_EXPORT void * APIENTRY glMapBufferRange(GLenum, GLintptr, GLsizeiptr, GLbitfield);
GLAPI FLEXTGL_EXPORT void APIENTRY glPauseTransformFeedback(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glProgramBinary(GLuint, GLenum, const void *, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glProgramParameteri(GLuint, GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glReadBuffer(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glRenderbufferStorageMultisample(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glResumeTransformFeedback(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glSamplerParameterf(GLuint, GLenum, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glSamplerParameterfv(GLuint, GLenum, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glSamplerParameteri(GLuint, GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glSamplerParameteriv(GLuint, GLenum, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexImage3D(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexStorage2D(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexStorage3D(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexSubImage3D(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTransformFeedbackVaryings(GLuint, GLsizei, const GLchar *const*, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1ui(GLint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform1uiv(GLint, GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2ui(GLint, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform2uiv(GLint, GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3ui(GLint, GLuint, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform3uiv(GLint, GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4ui(GLint, GLuint, GLuint, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniform4uiv(GLint, GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformBlockBinding(GLuint, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix2x3fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix2x4fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix3x2fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix3x4fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix4x2fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glUniformMatrix4x3fv(GLint, GLsizei, GLboolean, const GLfloat *);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glUnmapBuffer(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribDivisor(GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribI4i(GLuint, GLint, GLint, GLint, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribI4iv(GLuint, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribI4ui(GLuint, GLuint, GLuint, GLuint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribI4uiv(GLuint, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glVertexAttribIPointer(GLuint, GLint, GLenum, GLsizei, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glWaitSync(GLsync, GLbitfield, GLuint64);

/* Dynamically-loaded function prototypes put into a struct in order to handle
   thread-localness and globals unique across shared libs, this also means way
   less symbols is exported, saving on binary size. */
struct FlextGL {

    /* GL_ES_VERSION_3_1 */

    void(APIENTRY *ActiveShaderProgram)(GLuint, GLuint);
    void(APIENTRY *BindImageTexture)(GLuint, GLuint, GLint, GLboolean, GLint, GLenum, GLenum);
    void(APIENTRY *BindProgramPipeline)(GLuint);
    void(APIENTRY *BindVertexBuffer)(GLuint, GLuint, GLintptr, GLsizei);
    GLuint(APIENTRY *CreateShaderProgramv)(GLenum, GLsizei, const GLchar *const*);
    void(APIENTRY *DeleteProgramPipelines)(GLsizei, const GLuint *);
    void(APIENTRY *DispatchCompute)(GLuint, GLuint, GLuint);
    void(APIENTRY *DispatchComputeIndirect)(GLintptr);
    void(APIENTRY *DrawArraysIndirect)(GLenum, const void *);
    void(APIENTRY *DrawElementsIndirect)(GLenum, GLenum, const void *);
    void(APIENTRY *FramebufferParameteri)(GLenum, GLenum, GLint);
    void(APIENTRY *GenProgramPipelines)(GLsizei, GLuint *);
    void(APIENTRY *GetBooleani_v)(GLenum, GLuint, GLboolean *);
    void(APIENTRY *GetFramebufferParameteriv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetMultisamplefv)(GLenum, GLuint, GLfloat *);
    void(APIENTRY *GetProgramInterfaceiv)(GLuint, GLenum, GLenum, GLint *);
    void(APIENTRY *GetProgramPipelineInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramPipelineiv)(GLuint, GLenum, GLint *);
    GLuint(APIENTRY *GetProgramResourceIndex)(GLuint, GLenum, const GLchar *);
    GLint(APIENTRY *GetProgramResourceLocation)(GLuint, GLenum, const GLchar *);
    void(APIENTRY *GetProgramResourceName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramResourceiv)(GLuint, GLenum, GLuint, GLsizei, const GLenum *, GLsizei, GLsizei *, GLint *);
    void(APIENTRY *GetTexLevelParameterfv)(GLenum, GLint, GLenum, GLfloat *);
    void(APIENTRY *GetTexLevelParameteriv)(GLenum, GLint, GLenum, GLint *);
    GLboolean(APIENTRY *IsProgramPipeline)(GLuint);
    void(APIENTRY *MemoryBarrier)(GLbitfield);
    void(APIENTRY *MemoryBarrierByRegion)(GLbitfield);
    void(APIENTRY *ProgramUniform1f)(GLuint, GLint, GLfloat);
    void(APIENTRY *ProgramUniform1fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform1i)(GLuint, GLint, GLint);
    void(APIENTRY *ProgramUniform1iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform1ui)(GLuint, GLint, GLuint);
    void(APIENTRY *ProgramUniform1uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform2f)(GLuint, GLint, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform2fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform2i)(GLuint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform2iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform2ui)(GLuint, GLint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform2uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform3f)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform3fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform3i)(GLuint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform3iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform3ui)(GLuint, GLint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform3uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform4f)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform4fv)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform4i)(GLuint, GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform4iv)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform4ui)(GLuint, GLint, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform4uiv)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniformMatrix2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *SampleMaski)(GLuint, GLbitfield);
    void(APIENTRY *TexStorage2DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
    void(APIENTRY *UseProgramStages)(GLuint, GLbitfield, GLuint);
    void(APIENTRY *ValidateProgramPipeline)(GLuint);
    void(APIENTRY *VertexAttribBinding)(GLuint, GLuint);
    void(APIENTRY *VertexAttribFormat)(GLuint, GLint, GLenum, GLboolean, GLuint);
    void(APIENTRY *VertexAttribIFormat)(GLuint, GLint, GLenum, GLuint);
    void(APIENTRY *VertexBindingDivisor)(GLuint, GLuint);

    /* GL_ES_VERSION_3_2 */

    void(APIENTRY *BlendBarrier)(void);
    void(APIENTRY *BlendEquationSeparatei)(GLuint, GLenum, GLenum);
    void(APIENTRY *BlendEquationi)(GLuint, GLenum);
    void(APIENTRY *BlendFuncSeparatei)(GLuint, GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *BlendFunci)(GLuint, GLenum, GLenum);
    void(APIENTRY *ColorMaski)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
    void(APIENTRY *CopyImageSubData)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
    void(APIENTRY *DebugMessageCallback)(GLDEBUGPROC, const void *);
    void(APIENTRY *DebugMessageControl)(GLenum, GLenum, GLenum, GLsizei, const GLuint *, GLboolean);
    void(APIENTRY *DebugMessageInsert)(GLenum, GLenum, GLuint, GLenum, GLsizei, const GLchar *);
    void(APIENTRY *Disablei)(GLenum, GLuint);
    void(APIENTRY *DrawElementsBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLint);
    void(APIENTRY *DrawElementsInstancedBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLint);
    void(APIENTRY *DrawRangeElementsBaseVertex)(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *, GLint);
    void(APIENTRY *Enablei)(GLenum, GLuint);
    void(APIENTRY *FramebufferTexture)(GLenum, GLenum, GLuint, GLint);
    GLuint(APIENTRY *GetDebugMessageLog)(GLuint, GLsizei, GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *);
    GLenum(APIENTRY *GetGraphicsResetStatus)(void);
    void(APIENTRY *GetObjectLabel)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectPtrLabel)(const void *, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetPointerv)(GLenum, void **);
    void(APIENTRY *GetSamplerParameterIiv)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetSamplerParameterIuiv)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetTexParameterIiv)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetTexParameterIuiv)(GLenum, GLenum, GLuint *);
    void(APIENTRY *GetnUniformfv)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformiv)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *GetnUniformuiv)(GLuint, GLint, GLsizei, GLuint *);
    GLboolean(APIENTRY *IsEnabledi)(GLenum, GLuint);
    void(APIENTRY *MinSampleShading)(GLfloat);
    void(APIENTRY *ObjectLabel)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ObjectPtrLabel)(const void *, GLsizei, const GLchar *);
    void(APIENTRY *PatchParameteri)(GLenum, GLint);
    void(APIENTRY *PopDebugGroup)(void);
    void(APIENTRY *PrimitiveBoundingBox)(GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *PushDebugGroup)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ReadnPixels)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
    void(APIENTRY *SamplerParameterIiv)(GLuint, GLenum, const GLint *);
    void(APIENTRY *SamplerParameterIuiv)(GLuint, GLenum, const GLuint *);
    void(APIENTRY *TexBuffer)(GLenum, GLenum, GLuint);
    void(APIENTRY *TexBufferRange)(GLenum, GLenum, GLuint, GLintptr, GLsizeiptr);
    void(APIENTRY *TexParameterIiv)(GLenum, GLenum, const GLint *);
    void(APIENTRY *TexParameterIuiv)(GLenum, GLenum, const GLuint *);
    void(APIENTRY *TexStorage3DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);

    /* GL_EXT_copy_image */

    void(APIENTRY *CopyImageSubDataEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);

    /* GL_EXT_debug_label */

    void(APIENTRY *GetObjectLabelEXT)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *LabelObjectEXT)(GLenum, GLuint, GLsizei, const GLchar *);

    /* GL_EXT_debug_marker */

    void(APIENTRY *InsertEventMarkerEXT)(GLsizei, const GLchar *);
    void(APIENTRY *PopGroupMarkerEXT)(void);
    void(APIENTRY *PushGroupMarkerEXT)(GLsizei, const GLchar *);

    /* GL_EXT_disjoint_timer_query */

    void(APIENTRY *BeginQueryEXT)(GLenum, GLuint);
    void(APIENTRY *DeleteQueriesEXT)(GLsizei, const GLuint *);
    void(APIENTRY *EndQueryEXT)(GLenum);
    void(APIENTRY *GenQueriesEXT)(GLsizei, GLuint *);
    void(APIENTRY *GetInteger64vEXT)(GLenum, GLint64 *);
    void(APIENTRY *GetQueryObjecti64vEXT)(GLuint, GLenum, GLint64 *);
    void(APIENTRY *GetQueryObjectivEXT)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetQueryObjectui64vEXT)(GLuint, GLenum, GLuint64 *);
    void(APIENTRY *GetQueryObjectuivEXT)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetQueryivEXT)(GLenum, GLenum, GLint *);
    GLboolean(APIENTRY *IsQueryEXT)(GLuint);
    void(APIENTRY *QueryCounterEXT)(GLuint, GLenum);

    /* GL_EXT_draw_buffers_indexed */

    void(APIENTRY *BlendEquationSeparateiEXT)(GLuint, GLenum, GLenum);
    void(APIENTRY *BlendEquationiEXT)(GLuint, GLenum);
    void(APIENTRY *BlendFuncSeparateiEXT)(GLuint, GLenum, GLenum, GLenum, GLenum);
    void(APIENTRY *BlendFunciEXT)(GLuint, GLenum, GLenum);
    void(APIENTRY *ColorMaskiEXT)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
    void(APIENTRY *DisableiEXT)(GLenum, GLuint);
    void(APIENTRY *EnableiEXT)(GLenum, GLuint);
    GLboolean(APIENTRY *IsEnablediEXT)(GLenum, GLuint);

    /* GL_EXT_geometry_shader */

    void(APIENTRY *FramebufferTextureEXT)(GLenum, GLenum, GLuint, GLint);

    /* GL_EXT_multi_draw_arrays */

    void(APIENTRY *MultiDrawArraysEXT)(GLenum, const GLint *, const GLsizei *, GLsizei);
    void(APIENTRY *MultiDrawElementsEXT)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei);

    /* GL_EXT_multisampled_render_to_texture */

    void(APIENTRY *FramebufferTexture2DMultisampleEXT)(GLenum, GLenum, GLenum, GLuint, GLint, GLsizei);
    void(APIENTRY *RenderbufferStorageMultisampleEXT)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);

    /* GL_EXT_polygon_offset_clamp */

    void(APIENTRY *PolygonOffsetClampEXT)(GLfloat, GLfloat, GLfloat);

    /* GL_EXT_primitive_bounding_box */

    void(APIENTRY *PrimitiveBoundingBoxEXT)(GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, GLfloat);

    /* GL_EXT_robustness */

    GLenum(APIENTRY *GetGraphicsResetStatusEXT)(void);
    void(APIENTRY *GetnUniformfvEXT)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformivEXT)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *ReadnPixelsEXT)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);

    /* GL_EXT_separate_shader_objects */

    void(APIENTRY *ActiveShaderProgramEXT)(GLuint, GLuint);
    void(APIENTRY *BindProgramPipelineEXT)(GLuint);
    GLuint(APIENTRY *CreateShaderProgramvEXT)(GLenum, GLsizei, const GLchar **);
    void(APIENTRY *DeleteProgramPipelinesEXT)(GLsizei, const GLuint *);
    void(APIENTRY *GenProgramPipelinesEXT)(GLsizei, GLuint *);
    void(APIENTRY *GetProgramPipelineInfoLogEXT)(GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetProgramPipelineivEXT)(GLuint, GLenum, GLint *);
    GLboolean(APIENTRY *IsProgramPipelineEXT)(GLuint);
    void(APIENTRY *ProgramParameteriEXT)(GLuint, GLenum, GLint);
    void(APIENTRY *ProgramUniform1fEXT)(GLuint, GLint, GLfloat);
    void(APIENTRY *ProgramUniform1fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform1iEXT)(GLuint, GLint, GLint);
    void(APIENTRY *ProgramUniform1ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform1uiEXT)(GLuint, GLint, GLuint);
    void(APIENTRY *ProgramUniform1uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform2fEXT)(GLuint, GLint, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform2fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform2iEXT)(GLuint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform2ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform2uiEXT)(GLuint, GLint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform2uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform3fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform3fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform3iEXT)(GLuint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform3ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform3uiEXT)(GLuint, GLint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform3uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniform4fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
    void(APIENTRY *ProgramUniform4fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
    void(APIENTRY *ProgramUniform4iEXT)(GLuint, GLint, GLint, GLint, GLint, GLint);
    void(APIENTRY *ProgramUniform4ivEXT)(GLuint, GLint, GLsizei, const GLint *);
    void(APIENTRY *ProgramUniform4uiEXT)(GLuint, GLint, GLuint, GLuint, GLuint, GLuint);
    void(APIENTRY *ProgramUniform4uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
    void(APIENTRY *ProgramUniformMatrix2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix2x4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix3x4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *ProgramUniformMatrix4x3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
    void(APIENTRY *UseProgramStagesEXT)(GLuint, GLbitfield, GLuint);
    void(APIENTRY *ValidateProgramPipelineEXT)(GLuint);

    /* GL_EXT_tessellation_shader */

    void(APIENTRY *PatchParameteriEXT)(GLenum, GLint);

    /* GL_EXT_texture_border_clamp */

    void(APIENTRY *GetSamplerParameterIivEXT)(GLuint, GLenum, GLint *);
    void(APIENTRY *GetSamplerParameterIuivEXT)(GLuint, GLenum, GLuint *);
    void(APIENTRY *GetTexParameterIivEXT)(GLenum, GLenum, GLint *);
    void(APIENTRY *GetTexParameterIuivEXT)(GLenum, GLenum, GLuint *);
    void(APIENTRY *SamplerParameterIivEXT)(GLuint, GLenum, const GLint *);
    void(APIENTRY *SamplerParameterIuivEXT)(GLuint, GLenum, const GLuint *);
    void(APIENTRY *TexParameterIivEXT)(GLenum, GLenum, const GLint *);
    void(APIENTRY *TexParameterIuivEXT)(GLenum, GLenum, const GLuint *);

    /* GL_EXT_texture_buffer */

    void(APIENTRY *TexBufferEXT)(GLenum, GLenum, GLuint);
    void(APIENTRY *TexBufferRangeEXT)(GLenum, GLenum, GLuint, GLintptr, GLsizeiptr);

    /* GL_KHR_blend_equation_advanced */

    void(APIENTRY *BlendBarrierKHR)(void);

    /* GL_KHR_debug */

    void(APIENTRY *DebugMessageCallbackKHR)(GLDEBUGPROCKHR, const void *);
    void(APIENTRY *DebugMessageControlKHR)(GLenum, GLenum, GLenum, GLsizei, const GLuint *, GLboolean);
    void(APIENTRY *DebugMessageInsertKHR)(GLenum, GLenum, GLuint, GLenum, GLsizei, const GLchar *);
    GLuint(APIENTRY *GetDebugMessageLogKHR)(GLuint, GLsizei, GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectLabelKHR)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetObjectPtrLabelKHR)(const void *, GLsizei, GLsizei *, GLchar *);
    void(APIENTRY *GetPointervKHR)(GLenum, void **);
    void(APIENTRY *ObjectLabelKHR)(GLenum, GLuint, GLsizei, const GLchar *);
    void(APIENTRY *ObjectPtrLabelKHR)(const void *, GLsizei, const GLchar *);
    void(APIENTRY *PopDebugGroupKHR)(void);
    void(APIENTRY *PushDebugGroupKHR)(GLenum, GLuint, GLsizei, const GLchar *);

    /* GL_KHR_robustness */

    GLenum(APIENTRY *GetGraphicsResetStatusKHR)(void);
    void(APIENTRY *GetnUniformfvKHR)(GLuint, GLint, GLsizei, GLfloat *);
    void(APIENTRY *GetnUniformivKHR)(GLuint, GLint, GLsizei, GLint *);
    void(APIENTRY *GetnUniformuivKHR)(GLuint, GLint, GLsizei, GLuint *);
    void(APIENTRY *ReadnPixelsKHR)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);

    /* GL_NV_polygon_mode */

    void(APIENTRY *PolygonModeNV)(GLenum, GLenum);

    /* GL_NV_sample_locations */

    void(APIENTRY *FramebufferSampleLocationsfvNV)(GLenum, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *NamedFramebufferSampleLocationsfvNV)(GLuint, GLuint, GLsizei, const GLfloat *);
    void(APIENTRY *ResolveDepthValuesNV)(void);

    /* GL_OES_mapbuffer */

    void(APIENTRY *GetBufferPointervOES)(GLenum, GLenum, void **);
    void *(APIENTRY *MapBufferOES)(GLenum, GLenum);
    GLboolean(APIENTRY *UnmapBufferOES)(GLenum);

    /* GL_OES_sample_shading */

    void(APIENTRY *MinSampleShadingOES)(GLfloat);

    /* GL_OES_texture_storage_multisample_2d_array */

    void(APIENTRY *TexStorage3DMultisampleOES)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);

    /* GL_OVR_multiview */

    void(APIENTRY *FramebufferTextureMultiviewOVR)(GLenum, GLenum, GLuint, GLint, GLint, GLsizei);
};

extern FLEXTGL_EXPORT FlextGL flextGL;

/* GL_ES_VERSION_3_1 */

#define glActiveShaderProgram flextGL.ActiveShaderProgram
#define glBindImageTexture flextGL.BindImageTexture
#define glBindProgramPipeline flextGL.BindProgramPipeline
#define glBindVertexBuffer flextGL.BindVertexBuffer
#define glCreateShaderProgramv flextGL.CreateShaderProgramv
#define glDeleteProgramPipelines flextGL.DeleteProgramPipelines
#define glDispatchCompute flextGL.DispatchCompute
#define glDispatchComputeIndirect flextGL.DispatchComputeIndirect
#define glDrawArraysIndirect flextGL.DrawArraysIndirect
#define glDrawElementsIndirect flextGL.DrawElementsIndirect
#define glFramebufferParameteri flextGL.FramebufferParameteri
#define glGenProgramPipelines flextGL.GenProgramPipelines
#define glGetBooleani_v flextGL.GetBooleani_v
#define glGetFramebufferParameteriv flextGL.GetFramebufferParameteriv
#define glGetMultisamplefv flextGL.GetMultisamplefv
#define glGetProgramInterfaceiv flextGL.GetProgramInterfaceiv
#define glGetProgramPipelineInfoLog flextGL.GetProgramPipelineInfoLog
#define glGetProgramPipelineiv flextGL.GetProgramPipelineiv
#define glGetProgramResourceIndex flextGL.GetProgramResourceIndex
#define glGetProgramResourceLocation flextGL.GetProgramResourceLocation
#define glGetProgramResourceName flextGL.GetProgramResourceName
#define glGetProgramResourceiv flextGL.GetProgramResourceiv
#define glGetTexLevelParameterfv flextGL.GetTexLevelParameterfv
#define glGetTexLevelParameteriv flextGL.GetTexLevelParameteriv
#define glIsProgramPipeline flextGL.IsProgramPipeline
#define glMemoryBarrier flextGL.MemoryBarrier
#define glMemoryBarrierByRegion flextGL.MemoryBarrierByRegion
#define glProgramUniform1f flextGL.ProgramUniform1f
#define glProgramUniform1fv flextGL.ProgramUniform1fv
#define glProgramUniform1i flextGL.ProgramUniform1i
#define glProgramUniform1iv flextGL.ProgramUniform1iv
#define glProgramUniform1ui flextGL.ProgramUniform1ui
#define glProgramUniform1uiv flextGL.ProgramUniform1uiv
#define glProgramUniform2f flextGL.ProgramUniform2f
#define glProgramUniform2fv flextGL.ProgramUniform2fv
#define glProgramUniform2i flextGL.ProgramUniform2i
#define glProgramUniform2iv flextGL.ProgramUniform2iv
#define glProgramUniform2ui flextGL.ProgramUniform2ui
#define glProgramUniform2uiv flextGL.ProgramUniform2uiv
#define glProgramUniform3f flextGL.ProgramUniform3f
#define glProgramUniform3fv flextGL.ProgramUniform3fv
#define glProgramUniform3i flextGL.ProgramUniform3i
#define glProgramUniform3iv flextGL.ProgramUniform3iv
#define glProgramUniform3ui flextGL.ProgramUniform3ui
#define glProgramUniform3uiv flextGL.ProgramUniform3uiv
#define glProgramUniform4f flextGL.ProgramUniform4f
#define glProgramUniform4fv flextGL.ProgramUniform4fv
#define glProgramUniform4i flextGL.ProgramUniform4i
#define glProgramUniform4iv flextGL.ProgramUniform4iv
#define glProgramUniform4ui flextGL.ProgramUniform4ui
#define glProgramUniform4uiv flextGL.ProgramUniform4uiv
#define glProgramUniformMatrix2fv flextGL.ProgramUniformMatrix2fv
#define glProgramUniformMatrix2x3fv flextGL.ProgramUniformMatrix2x3fv
#define glProgramUniformMatrix2x4fv flextGL.ProgramUniformMatrix2x4fv
#define glProgramUniformMatrix3fv flextGL.ProgramUniformMatrix3fv
#define glProgramUniformMatrix3x2fv flextGL.ProgramUniformMatrix3x2fv
#define glProgramUniformMatrix3x4fv flextGL.ProgramUniformMatrix3x4fv
#define glProgramUniformMatrix4fv flextGL.ProgramUniformMatrix4fv
#define glProgramUniformMatrix4x2fv flextGL.ProgramUniformMatrix4x2fv
#define glProgramUniformMatrix4x3fv flextGL.ProgramUniformMatrix4x3fv
#define glSampleMaski flextGL.SampleMaski
#define glTexStorage2DMultisample flextGL.TexStorage2DMultisample
#define glUseProgramStages flextGL.UseProgramStages
#define glValidateProgramPipeline flextGL.ValidateProgramPipeline
#define glVertexAttribBinding flextGL.VertexAttribBinding
#define glVertexAttribFormat flextGL.VertexAttribFormat
#define glVertexAttribIFormat flextGL.VertexAttribIFormat
#define glVertexBindingDivisor flextGL.VertexBindingDivisor

/* GL_ES_VERSION_3_2 */

#define glBlendBarrier flextGL.BlendBarrier
#define glBlendEquationSeparatei flextGL.BlendEquationSeparatei
#define glBlendEquationi flextGL.BlendEquationi
#define glBlendFuncSeparatei flextGL.BlendFuncSeparatei
#define glBlendFunci flextGL.BlendFunci
#define glColorMaski flextGL.ColorMaski
#define glCopyImageSubData flextGL.CopyImageSubData
#define glDebugMessageCallback flextGL.DebugMessageCallback
#define glDebugMessageControl flextGL.DebugMessageControl
#define glDebugMessageInsert flextGL.DebugMessageInsert
#define glDisablei flextGL.Disablei
#define glDrawElementsBaseVertex flextGL.DrawElementsBaseVertex
#define glDrawElementsInstancedBaseVertex flextGL.DrawElementsInstancedBaseVertex
#define glDrawRangeElementsBaseVertex flextGL.DrawRangeElementsBaseVertex
#define glEnablei flextGL.Enablei
#define glFramebufferTexture flextGL.FramebufferTexture
#define glGetDebugMessageLog flextGL.GetDebugMessageLog
#define glGetGraphicsResetStatus flextGL.GetGraphicsResetStatus
#define glGetObjectLabel flextGL.GetObjectLabel
#define glGetObjectPtrLabel flextGL.GetObjectPtrLabel
#define glGetPointerv flextGL.GetPointerv
#define glGetSamplerParameterIiv flextGL.GetSamplerParameterIiv
#define glGetSamplerParameterIuiv flextGL.GetSamplerParameterIuiv
#define glGetTexParameterIiv flextGL.GetTexParameterIiv
#define glGetTexParameterIuiv flextGL.GetTexParameterIuiv
#define glGetnUniformfv flextGL.GetnUniformfv
#define glGetnUniformiv flextGL.GetnUniformiv
#define glGetnUniformuiv flextGL.GetnUniformuiv
#define glIsEnabledi flextGL.IsEnabledi
#define glMinSampleShading flextGL.MinSampleShading
#define glObjectLabel flextGL.ObjectLabel
#define glObjectPtrLabel flextGL.ObjectPtrLabel
#define glPatchParameteri flextGL.PatchParameteri
#define glPopDebugGroup flextGL.PopDebugGroup
#define glPrimitiveBoundingBox flextGL.PrimitiveBoundingBox
#define glPushDebugGroup flextGL.PushDebugGroup
#define glReadnPixels flextGL.ReadnPixels
#define glSamplerParameterIiv flextGL.SamplerParameterIiv
#define glSamplerParameterIuiv flextGL.SamplerParameterIuiv
#define glTexBuffer flextGL.TexBuffer
#define glTexBufferRange flextGL.TexBufferRange
#define glTexParameterIiv flextGL.TexParameterIiv
#define glTexParameterIuiv flextGL.TexParameterIuiv
#define glTexStorage3DMultisample flextGL.TexStorage3DMultisample

/* GL_EXT_copy_image */

#define glCopyImageSubDataEXT flextGL.CopyImageSubDataEXT

/* GL_EXT_debug_label */

#define glGetObjectLabelEXT flextGL.GetObjectLabelEXT
#define glLabelObjectEXT flextGL.LabelObjectEXT

/* GL_EXT_debug_marker */

#define glInsertEventMarkerEXT flextGL.InsertEventMarkerEXT
#define glPopGroupMarkerEXT flextGL.PopGroupMarkerEXT
#define glPushGroupMarkerEXT flextGL.PushGroupMarkerEXT

/* GL_EXT_disjoint_timer_query */

#define glBeginQueryEXT flextGL.BeginQueryEXT
#define glDeleteQueriesEXT flextGL.DeleteQueriesEXT
#define glEndQueryEXT flextGL.EndQueryEXT
#define glGenQueriesEXT flextGL.GenQueriesEXT
#define glGetInteger64vEXT flextGL.GetInteger64vEXT
#define glGetQueryObjecti64vEXT flextGL.GetQueryObjecti64vEXT
#define glGetQueryObjectivEXT flextGL.GetQueryObjectivEXT
#define glGetQueryObjectui64vEXT flextGL.GetQueryObjectui64vEXT
#define glGetQueryObjectuivEXT flextGL.GetQueryObjectuivEXT
#define glGetQueryivEXT flextGL.GetQueryivEXT
#define glIsQueryEXT flextGL.IsQueryEXT
#define glQueryCounterEXT flextGL.QueryCounterEXT

/* GL_EXT_draw_buffers_indexed */

#define glBlendEquationSeparateiEXT flextGL.BlendEquationSeparateiEXT
#define glBlendEquationiEXT flextGL.BlendEquationiEXT
#define glBlendFuncSeparateiEXT flextGL.BlendFuncSeparateiEXT
#define glBlendFunciEXT flextGL.BlendFunciEXT
#define glColorMaskiEXT flextGL.ColorMaskiEXT
#define glDisableiEXT flextGL.DisableiEXT
#define glEnableiEXT flextGL.EnableiEXT
#define glIsEnablediEXT flextGL.IsEnablediEXT

/* GL_EXT_geometry_shader */

#define glFramebufferTextureEXT flextGL.FramebufferTextureEXT

/* GL_EXT_multi_draw_arrays */

#define glMultiDrawArraysEXT flextGL.MultiDrawArraysEXT
#define glMultiDrawElementsEXT flextGL.MultiDrawElementsEXT

/* GL_EXT_multisampled_render_to_texture */

#define glFramebufferTexture2DMultisampleEXT flextGL.FramebufferTexture2DMultisampleEXT
#define glRenderbufferStorageMultisampleEXT flextGL.RenderbufferStorageMultisampleEXT

/* GL_EXT_polygon_offset_clamp */

#define glPolygonOffsetClampEXT flextGL.PolygonOffsetClampEXT

/* GL_EXT_primitive_bounding_box */

#define glPrimitiveBoundingBoxEXT flextGL.PrimitiveBoundingBoxEXT

/* GL_EXT_robustness */

#define glGetGraphicsResetStatusEXT flextGL.GetGraphicsResetStatusEXT
#define glGetnUniformfvEXT flextGL.GetnUniformfvEXT
#define glGetnUniformivEXT flextGL.GetnUniformivEXT
#define glReadnPixelsEXT flextGL.ReadnPixelsEXT

/* GL_EXT_separate_shader_objects */

#define glActiveShaderProgramEXT flextGL.ActiveShaderProgramEXT
#define glBindProgramPipelineEXT flextGL.BindProgramPipelineEXT
#define glCreateShaderProgramvEXT flextGL.CreateShaderProgramvEXT
#define glDeleteProgramPipelinesEXT flextGL.DeleteProgramPipelinesEXT
#define glGenProgramPipelinesEXT flextGL.GenProgramPipelinesEXT
#define glGetProgramPipelineInfoLogEXT flextGL.GetProgramPipelineInfoLogEXT
#define glGetProgramPipelineivEXT flextGL.GetProgramPipelineivEXT
#define glIsProgramPipelineEXT flextGL.IsProgramPipelineEXT
#define glProgramParameteriEXT flextGL.ProgramParameteriEXT
#define glProgramUniform1fEXT flextGL.ProgramUniform1fEXT
#define glProgramUniform1fvEXT flextGL.ProgramUniform1fvEXT
#define glProgramUniform1iEXT flextGL.ProgramUniform1iEXT
#define glProgramUniform1ivEXT flextGL.ProgramUniform1ivEXT
#define glProgramUniform1uiEXT flextGL.ProgramUniform1uiEXT
#define glProgramUniform1uivEXT flextGL.ProgramUniform1uivEXT
#define glProgramUniform2fEXT flextGL.ProgramUniform2fEXT
#define glProgramUniform2fvEXT flextGL.ProgramUniform2fvEXT
#define glProgramUniform2iEXT flextGL.ProgramUniform2iEXT
#define glProgramUniform2ivEXT flextGL.ProgramUniform2ivEXT
#define glProgramUniform2uiEXT flextGL.ProgramUniform2uiEXT
#define glProgramUniform2uivEXT flextGL.ProgramUniform2uivEXT
#define glProgramUniform3fEXT flextGL.ProgramUniform3fEXT
#define glProgramUniform3fvEXT flextGL.ProgramUniform3fvEXT
#define glProgramUniform3iEXT flextGL.ProgramUniform3iEXT
#define glProgramUniform3ivEXT flextGL.ProgramUniform3ivEXT
#define glProgramUniform3uiEXT flextGL.ProgramUniform3uiEXT
#define glProgramUniform3uivEXT flextGL.ProgramUniform3uivEXT
#define glProgramUniform4fEXT flextGL.ProgramUniform4fEXT
#define glProgramUniform4fvEXT flextGL.ProgramUniform4fvEXT
#define glProgramUniform4iEXT flextGL.ProgramUniform4iEXT
#define glProgramUniform4ivEXT flextGL.ProgramUniform4ivEXT
#define glProgramUniform4uiEXT flextGL.ProgramUniform4uiEXT
#define glProgramUniform4uivEXT flextGL.ProgramUniform4uivEXT
#define glProgramUniformMatrix2fvEXT flextGL.ProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2x3fvEXT flextGL.ProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x4fvEXT flextGL.ProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix3fvEXT flextGL.ProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3x2fvEXT flextGL.ProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x4fvEXT flextGL.ProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix4fvEXT flextGL.ProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4x2fvEXT flextGL.ProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x3fvEXT flextGL.ProgramUniformMatrix4x3fvEXT
#define glUseProgramStagesEXT flextGL.UseProgramStagesEXT
#define glValidateProgramPipelineEXT flextGL.ValidateProgramPipelineEXT

/* GL_EXT_tessellation_shader */

#define glPatchParameteriEXT flextGL.PatchParameteriEXT

/* GL_EXT_texture_border_clamp */

#define glGetSamplerParameterIivEXT flextGL.GetSamplerParameterIivEXT
#define glGetSamplerParameterIuivEXT flextGL.GetSamplerParameterIuivEXT
#define glGetTexParameterIivEXT flextGL.GetTexParameterIivEXT
#define glGetTexParameterIuivEXT flextGL.GetTexParameterIuivEXT
#define glSamplerParameterIivEXT flextGL.SamplerParameterIivEXT
#define glSamplerParameterIuivEXT flextGL.SamplerParameterIuivEXT
#define glTexParameterIivEXT flextGL.TexParameterIivEXT
#define glTexParameterIuivEXT flextGL.TexParameterIuivEXT

/* GL_EXT_texture_buffer */

#define glTexBufferEXT flextGL.TexBufferEXT
#define glTexBufferRangeEXT flextGL.TexBufferRangeEXT

/* GL_KHR_blend_equation_advanced */

#define glBlendBarrierKHR flextGL.BlendBarrierKHR

/* GL_KHR_debug */

#define glDebugMessageCallbackKHR flextGL.DebugMessageCallbackKHR
#define glDebugMessageControlKHR flextGL.DebugMessageControlKHR
#define glDebugMessageInsertKHR flextGL.DebugMessageInsertKHR
#define glGetDebugMessageLogKHR flextGL.GetDebugMessageLogKHR
#define glGetObjectLabelKHR flextGL.GetObjectLabelKHR
#define glGetObjectPtrLabelKHR flextGL.GetObjectPtrLabelKHR
#define glGetPointervKHR flextGL.GetPointervKHR
#define glObjectLabelKHR flextGL.ObjectLabelKHR
#define glObjectPtrLabelKHR flextGL.ObjectPtrLabelKHR
#define glPopDebugGroupKHR flextGL.PopDebugGroupKHR
#define glPushDebugGroupKHR flextGL.PushDebugGroupKHR

/* GL_KHR_robustness */

#define glGetGraphicsResetStatusKHR flextGL.GetGraphicsResetStatusKHR
#define glGetnUniformfvKHR flextGL.GetnUniformfvKHR
#define glGetnUniformivKHR flextGL.GetnUniformivKHR
#define glGetnUniformuivKHR flextGL.GetnUniformuivKHR
#define glReadnPixelsKHR flextGL.ReadnPixelsKHR

/* GL_NV_polygon_mode */

#define glPolygonModeNV flextGL.PolygonModeNV

/* GL_NV_sample_locations */

#define glFramebufferSampleLocationsfvNV flextGL.FramebufferSampleLocationsfvNV
#define glNamedFramebufferSampleLocationsfvNV flextGL.NamedFramebufferSampleLocationsfvNV
#define glResolveDepthValuesNV flextGL.ResolveDepthValuesNV

/* GL_OES_mapbuffer */

#define glGetBufferPointervOES flextGL.GetBufferPointervOES
#define glMapBufferOES flextGL.MapBufferOES
#define glUnmapBufferOES flextGL.UnmapBufferOES

/* GL_OES_sample_shading */

#define glMinSampleShadingOES flextGL.MinSampleShadingOES

/* GL_OES_texture_storage_multisample_2d_array */

#define glTexStorage3DMultisampleOES flextGL.TexStorage3DMultisampleOES

/* GL_OVR_multiview */

#define glFramebufferTextureMultiviewOVR flextGL.FramebufferTextureMultiviewOVR

#ifdef __cplusplus
}
#endif

#endif
