; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=aarch64 --mattr=-fullfp16,-neon < %s | FileCheck %s --check-prefix=CHECK-NOFP16-NONEON
; RUN: llc --mtriple=aarch64 --mattr=+fullfp16,-neon < %s | FileCheck %s --check-prefix=CHECK-FP16-NONEON
; RUN: llc --mtriple=aarch64 --mattr=-fullfp16,+neon < %s | FileCheck %s --check-prefix=CHECK-NOFP16-NEON
; RUN: llc --mtriple=aarch64 --mattr=+fullfp16,+neon < %s | FileCheck %s --check-prefixes=CHECK-FP16-NEON

declare half @llvm.fcanonicalize.f16(half)
declare float @llvm.fcanonicalize.f32(float)
declare double @llvm.fcanonicalize.f64(double)

define half @fcanonicalize_f16(half %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f16:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f16:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f16:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f16:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call half @llvm.canonicalize.f16(half %x)
  ret half %z
}

define half @fcanonicalize_f16_nnan(half %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f16_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f16_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f16_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f16_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan half @llvm.canonicalize.f16(half %x)
  ret half %z
}

define <2 x half> @fcanonicalize_v2f16(<2 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f16:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f16:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f16:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f16:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %x)
  ret <2 x half> %z
}

define <2 x half> @fcanonicalize_v2f16_nnan(<2 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <2 x half> @llvm.canonicalize.v2f16(<2 x half> %x)
  ret <2 x half> %z
}

define <4 x half> @fcanonicalize_v4f16(<4 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v4f16:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fcvt s2, h2
; CHECK-NOFP16-NONEON-NEXT:    fcvt s3, h3
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h2, s2
; CHECK-NOFP16-NONEON-NEXT:    fcvt h3, s3
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v4f16:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    fminnm h2, h2, h2
; CHECK-FP16-NONEON-NEXT:    fminnm h3, h3, h3
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v4f16:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v4f16:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <4 x half> @llvm.canonicalize.v4f16(<4 x half> %x)
  ret <4 x half> %z
}

define <4 x half> @fcanonicalize_v4f16_nnan(<4 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fcvt s2, h2
; CHECK-NOFP16-NONEON-NEXT:    fcvt s3, h3
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h2, s2
; CHECK-NOFP16-NONEON-NEXT:    fcvt h3, s3
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    fminnm h2, h2, h2
; CHECK-FP16-NONEON-NEXT:    fminnm h3, h3, h3
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <4 x half> @llvm.canonicalize.v4f16(<4 x half> %x)
  ret <4 x half> %z
}

define <8 x half> @fcanonicalize_v8f16(<8 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v8f16:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fcvt s2, h2
; CHECK-NOFP16-NONEON-NEXT:    fcvt s3, h3
; CHECK-NOFP16-NONEON-NEXT:    fcvt s4, h4
; CHECK-NOFP16-NONEON-NEXT:    fcvt s5, h5
; CHECK-NOFP16-NONEON-NEXT:    fcvt s6, h6
; CHECK-NOFP16-NONEON-NEXT:    fcvt s7, h7
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    fminnm s4, s4, s4
; CHECK-NOFP16-NONEON-NEXT:    fminnm s5, s5, s5
; CHECK-NOFP16-NONEON-NEXT:    fminnm s6, s6, s6
; CHECK-NOFP16-NONEON-NEXT:    fminnm s7, s7, s7
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h2, s2
; CHECK-NOFP16-NONEON-NEXT:    fcvt h3, s3
; CHECK-NOFP16-NONEON-NEXT:    fcvt h4, s4
; CHECK-NOFP16-NONEON-NEXT:    fcvt h5, s5
; CHECK-NOFP16-NONEON-NEXT:    fcvt h6, s6
; CHECK-NOFP16-NONEON-NEXT:    fcvt h7, s7
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v8f16:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    fminnm h2, h2, h2
; CHECK-FP16-NONEON-NEXT:    fminnm h3, h3, h3
; CHECK-FP16-NONEON-NEXT:    fminnm h4, h4, h4
; CHECK-FP16-NONEON-NEXT:    fminnm h5, h5, h5
; CHECK-FP16-NONEON-NEXT:    fminnm h6, h6, h6
; CHECK-FP16-NONEON-NEXT:    fminnm h7, h7, h7
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v8f16:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-NOFP16-NEON-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-NOFP16-NEON-NEXT:    fminnm v1.4s, v2.4s, v2.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v8f16:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <8 x half> @llvm.canonicalize.v8f16(<8 x half> %x)
  ret <8 x half> %z
}

define <8 x half> @fcanonicalize_v8f16_nnan(<8 x half> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NONEON-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NONEON-NEXT:    fcvt s2, h2
; CHECK-NOFP16-NONEON-NEXT:    fcvt s3, h3
; CHECK-NOFP16-NONEON-NEXT:    fcvt s4, h4
; CHECK-NOFP16-NONEON-NEXT:    fcvt s5, h5
; CHECK-NOFP16-NONEON-NEXT:    fcvt s6, h6
; CHECK-NOFP16-NONEON-NEXT:    fcvt s7, h7
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    fminnm s4, s4, s4
; CHECK-NOFP16-NONEON-NEXT:    fminnm s5, s5, s5
; CHECK-NOFP16-NONEON-NEXT:    fminnm s6, s6, s6
; CHECK-NOFP16-NONEON-NEXT:    fminnm s7, s7, s7
; CHECK-NOFP16-NONEON-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NONEON-NEXT:    fcvt h1, s1
; CHECK-NOFP16-NONEON-NEXT:    fcvt h2, s2
; CHECK-NOFP16-NONEON-NEXT:    fcvt h3, s3
; CHECK-NOFP16-NONEON-NEXT:    fcvt h4, s4
; CHECK-NOFP16-NONEON-NEXT:    fcvt h5, s5
; CHECK-NOFP16-NONEON-NEXT:    fcvt h6, s6
; CHECK-NOFP16-NONEON-NEXT:    fcvt h7, s7
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm h0, h0, h0
; CHECK-FP16-NONEON-NEXT:    fminnm h1, h1, h1
; CHECK-FP16-NONEON-NEXT:    fminnm h2, h2, h2
; CHECK-FP16-NONEON-NEXT:    fminnm h3, h3, h3
; CHECK-FP16-NONEON-NEXT:    fminnm h4, h4, h4
; CHECK-FP16-NONEON-NEXT:    fminnm h5, h5, h5
; CHECK-FP16-NONEON-NEXT:    fminnm h6, h6, h6
; CHECK-FP16-NONEON-NEXT:    fminnm h7, h7, h7
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-NOFP16-NEON-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-NOFP16-NEON-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-NOFP16-NEON-NEXT:    fminnm v1.4s, v2.4s, v2.4s
; CHECK-NOFP16-NEON-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <8 x half> @llvm.canonicalize.v8f16(<8 x half> %x)
  ret <8 x half> %z
}

define float @fcanonicalize_f32(float %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f32:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f32:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f32:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f32:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call float @llvm.canonicalize.f32(float %x)
  ret float %z
}

define float @fcanonicalize_f32_nnan(float %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f32_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f32_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f32_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f32_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan float @llvm.canonicalize.f32(float %x)
  ret float %z
}

define <2 x float> @fcanonicalize_v2f32(<2 x float> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f32:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f32:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f32:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f32:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <2 x float> @llvm.canonicalize.v2f32(<2 x float> %x)
  ret <2 x float> %z
}

define <2 x float> @fcanonicalize_v2f32_nnan(<2 x float> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f32_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f32_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f32_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f32_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <2 x float> @llvm.canonicalize.v2f32(<2 x float> %x)
  ret <2 x float> %z
}

define <4 x float> @fcanonicalize_v4f32(<4 x float> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v4f32:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v4f32:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-FP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-FP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v4f32:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v4f32:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <4 x float> @llvm.canonicalize.v4f32(<4 x float> %x)
  ret <4 x float> %z
}

define <4 x float> @fcanonicalize_v4f32_nnan(<4 x float> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v4f32_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-NOFP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-NOFP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-NOFP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v4f32_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm s0, s0, s0
; CHECK-FP16-NONEON-NEXT:    fminnm s1, s1, s1
; CHECK-FP16-NONEON-NEXT:    fminnm s2, s2, s2
; CHECK-FP16-NONEON-NEXT:    fminnm s3, s3, s3
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v4f32_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v4f32_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <4 x float> @llvm.canonicalize.v4f32(<4 x float> %x)
  ret <4 x float> %z
}

define double @fcanonicalize_f64(double %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f64:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f64:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f64:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f64:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call double @llvm.canonicalize.f64(double %x)
  ret double %z
}

define double @fcanonicalize_f64_nnan(double %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_f64_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_f64_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_f64_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_f64_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan double @llvm.canonicalize.f64(double %x)
  ret double %z
}

define <2 x double> @fcanonicalize_v2f64(<2 x double> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f64:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NONEON-NEXT:    fminnm d1, d1, d1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f64:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NONEON-NEXT:    fminnm d1, d1, d1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f64:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f64:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; CHECK-FP16-NEON-NEXT:    ret
  %z = call <2 x double> @llvm.canonicalize.v2f64(<2 x double> %x)
  ret <2 x double> %z
}

define <2 x double> @fcanonicalize_v2f64_nnan(<2 x double> %x) {
; CHECK-NOFP16-NONEON-LABEL: fcanonicalize_v2f64_nnan:
; CHECK-NOFP16-NONEON:       // %bb.0:
; CHECK-NOFP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-NOFP16-NONEON-NEXT:    fminnm d1, d1, d1
; CHECK-NOFP16-NONEON-NEXT:    ret
;
; CHECK-FP16-NONEON-LABEL: fcanonicalize_v2f64_nnan:
; CHECK-FP16-NONEON:       // %bb.0:
; CHECK-FP16-NONEON-NEXT:    fminnm d0, d0, d0
; CHECK-FP16-NONEON-NEXT:    fminnm d1, d1, d1
; CHECK-FP16-NONEON-NEXT:    ret
;
; CHECK-NOFP16-NEON-LABEL: fcanonicalize_v2f64_nnan:
; CHECK-NOFP16-NEON:       // %bb.0:
; CHECK-NOFP16-NEON-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; CHECK-NOFP16-NEON-NEXT:    ret
;
; CHECK-FP16-NEON-LABEL: fcanonicalize_v2f64_nnan:
; CHECK-FP16-NEON:       // %bb.0:
; CHECK-FP16-NEON-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; CHECK-FP16-NEON-NEXT:    ret
  %z = call nnan <2 x double> @llvm.canonicalize.v2f64(<2 x double> %x)
  ret <2 x double> %z
}
