; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer,dce -slp-threshold=-999 -S -mtriple=x86_64-apple-macosx10.8.0 -mcpu=corei7-avx | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.8.0"

declare double @llvm.fabs.f64(double) nounwind readnone

define void @vec_fabs_f64(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: @vec_fabs_f64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x double>, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <2 x double>, ptr [[B:%.*]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = call <2 x double> @llvm.fabs.v2f64(<2 x double> [[TMP4]])
; CHECK-NEXT:    store <2 x double> [[TMP5]], ptr [[C:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load double, ptr %a, align 8
  %i1 = load double, ptr %b, align 8
  %mul = fmul double %i0, %i1
  %call = tail call double @llvm.fabs.f64(double %mul) nounwind readnone
  %arrayidx3 = getelementptr inbounds double, ptr %a, i64 1
  %i3 = load double, ptr %arrayidx3, align 8
  %arrayidx4 = getelementptr inbounds double, ptr %b, i64 1
  %i4 = load double, ptr %arrayidx4, align 8
  %mul5 = fmul double %i3, %i4
  %call5 = tail call double @llvm.fabs.f64(double %mul5) nounwind readnone
  store double %call, ptr %c, align 8
  %arrayidx5 = getelementptr inbounds double, ptr %c, i64 1
  store double %call5, ptr %arrayidx5, align 8
  ret void
}

declare float @llvm.copysign.f32(float, float) nounwind readnone

define void @vec_copysign_f32(ptr %a, ptr %b, ptr noalias %c) {
; CHECK-LABEL: @vec_copysign_f32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x float>, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load <4 x float>, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = call <4 x float> @llvm.copysign.v4f32(<4 x float> [[TMP1]], <4 x float> [[TMP3]])
; CHECK-NEXT:    store <4 x float> [[TMP4]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = load float, ptr %a, align 4
  %1 = load float, ptr %b, align 4
  %call0 = tail call float @llvm.copysign.f32(float %0, float %1) nounwind readnone
  store float %call0, ptr %c, align 4

  %ix2 = getelementptr inbounds float, ptr %a, i64 1
  %2 = load float, ptr %ix2, align 4
  %ix3 = getelementptr inbounds float, ptr %b, i64 1
  %3 = load float, ptr %ix3, align 4
  %call1 = tail call float @llvm.copysign.f32(float %2, float %3) nounwind readnone
  %c1 = getelementptr inbounds float, ptr %c, i64 1
  store float %call1, ptr %c1, align 4

  %ix4 = getelementptr inbounds float, ptr %a, i64 2
  %4 = load float, ptr %ix4, align 4
  %ix5 = getelementptr inbounds float, ptr %b, i64 2
  %5 = load float, ptr %ix5, align 4
  %call2 = tail call float @llvm.copysign.f32(float %4, float %5) nounwind readnone
  %c2 = getelementptr inbounds float, ptr %c, i64 2
  store float %call2, ptr %c2, align 4

  %ix6 = getelementptr inbounds float, ptr %a, i64 3
  %6 = load float, ptr %ix6, align 4
  %ix7 = getelementptr inbounds float, ptr %b, i64 3
  %7 = load float, ptr %ix7, align 4
  %call3 = tail call float @llvm.copysign.f32(float %6, float %7) nounwind readnone
  %c3 = getelementptr inbounds float, ptr %c, i64 3
  store float %call3, ptr %c3, align 4

  ret void
}

declare i32 @llvm.bswap.i32(i32) nounwind readnone

define void @vec_bswap_i32(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: @vec_bswap_i32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = load <4 x i32>, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = add <4 x i32> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> [[TMP4]])
; CHECK-NEXT:    store <4 x i32> [[TMP5]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load i32, ptr %a, align 4
  %i1 = load i32, ptr %b, align 4
  %add1 = add i32 %i0, %i1
  %call1 = tail call i32 @llvm.bswap.i32(i32 %add1) nounwind readnone

  %arrayidx2 = getelementptr inbounds i32, ptr %a, i32 1
  %i2 = load i32, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %b, i32 1
  %i3 = load i32, ptr %arrayidx3, align 4
  %add2 = add i32 %i2, %i3
  %call2 = tail call i32 @llvm.bswap.i32(i32 %add2) nounwind readnone

  %arrayidx4 = getelementptr inbounds i32, ptr %a, i32 2
  %i4 = load i32, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %b, i32 2
  %i5 = load i32, ptr %arrayidx5, align 4
  %add3 = add i32 %i4, %i5
  %call3 = tail call i32 @llvm.bswap.i32(i32 %add3) nounwind readnone

  %arrayidx6 = getelementptr inbounds i32, ptr %a, i32 3
  %i6 = load i32, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds i32, ptr %b, i32 3
  %i7 = load i32, ptr %arrayidx7, align 4
  %add4 = add i32 %i6, %i7
  %call4 = tail call i32 @llvm.bswap.i32(i32 %add4) nounwind readnone

  store i32 %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds i32, ptr %c, i32 1
  store i32 %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %c, i32 2
  store i32 %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds i32, ptr %c, i32 3
  store i32 %call4, ptr %arrayidx10, align 4
  ret void

}

declare i32 @llvm.ctlz.i32(i32,i1) nounwind readnone

define void @vec_ctlz_i32(ptr %a, ptr %b, ptr %c, i1) {
; CHECK-LABEL: @vec_ctlz_i32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load <4 x i32>, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = add <4 x i32> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> [[TMP5]], i1 true)
; CHECK-NEXT:    store <4 x i32> [[TMP6]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load i32, ptr %a, align 4
  %i1 = load i32, ptr %b, align 4
  %add1 = add i32 %i0, %i1
  %call1 = tail call i32 @llvm.ctlz.i32(i32 %add1,i1 true) nounwind readnone

  %arrayidx2 = getelementptr inbounds i32, ptr %a, i32 1
  %i2 = load i32, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %b, i32 1
  %i3 = load i32, ptr %arrayidx3, align 4
  %add2 = add i32 %i2, %i3
  %call2 = tail call i32 @llvm.ctlz.i32(i32 %add2,i1 true) nounwind readnone

  %arrayidx4 = getelementptr inbounds i32, ptr %a, i32 2
  %i4 = load i32, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %b, i32 2
  %i5 = load i32, ptr %arrayidx5, align 4
  %add3 = add i32 %i4, %i5
  %call3 = tail call i32 @llvm.ctlz.i32(i32 %add3,i1 true) nounwind readnone

  %arrayidx6 = getelementptr inbounds i32, ptr %a, i32 3
  %i6 = load i32, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds i32, ptr %b, i32 3
  %i7 = load i32, ptr %arrayidx7, align 4
  %add4 = add i32 %i6, %i7
  %call4 = tail call i32 @llvm.ctlz.i32(i32 %add4,i1 true) nounwind readnone

  store i32 %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds i32, ptr %c, i32 1
  store i32 %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %c, i32 2
  store i32 %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds i32, ptr %c, i32 3
  store i32 %call4, ptr %arrayidx10, align 4
  ret void

}

define void @vec_ctlz_i32_neg(ptr %a, ptr %b, ptr %c, i1) {
; CHECK-LABEL: @vec_ctlz_i32_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I0:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[I1:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[I0]], [[I1]]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @llvm.ctlz.i32(i32 [[ADD1]], i1 true) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 1
; CHECK-NEXT:    [[I2:%.*]] = load i32, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 1
; CHECK-NEXT:    [[I3:%.*]] = load i32, ptr [[ARRAYIDX3]], align 4
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[I2]], [[I3]]
; CHECK-NEXT:    [[CALL2:%.*]] = tail call i32 @llvm.ctlz.i32(i32 [[ADD2]], i1 false) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 2
; CHECK-NEXT:    [[I4:%.*]] = load i32, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 2
; CHECK-NEXT:    [[I5:%.*]] = load i32, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[ADD3:%.*]] = add i32 [[I4]], [[I5]]
; CHECK-NEXT:    [[CALL3:%.*]] = tail call i32 @llvm.ctlz.i32(i32 [[ADD3]], i1 true) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 3
; CHECK-NEXT:    [[I6:%.*]] = load i32, ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 3
; CHECK-NEXT:    [[I7:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
; CHECK-NEXT:    [[ADD4:%.*]] = add i32 [[I6]], [[I7]]
; CHECK-NEXT:    [[CALL4:%.*]] = tail call i32 @llvm.ctlz.i32(i32 [[ADD4]], i1 false) #[[ATTR3]]
; CHECK-NEXT:    store i32 [[CALL1]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 1
; CHECK-NEXT:    store i32 [[CALL2]], ptr [[ARRAYIDX8]], align 4
; CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 2
; CHECK-NEXT:    store i32 [[CALL3]], ptr [[ARRAYIDX9]], align 4
; CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 3
; CHECK-NEXT:    store i32 [[CALL4]], ptr [[ARRAYIDX10]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load i32, ptr %a, align 4
  %i1 = load i32, ptr %b, align 4
  %add1 = add i32 %i0, %i1
  %call1 = tail call i32 @llvm.ctlz.i32(i32 %add1,i1 true) nounwind readnone

  %arrayidx2 = getelementptr inbounds i32, ptr %a, i32 1
  %i2 = load i32, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %b, i32 1
  %i3 = load i32, ptr %arrayidx3, align 4
  %add2 = add i32 %i2, %i3
  %call2 = tail call i32 @llvm.ctlz.i32(i32 %add2,i1 false) nounwind readnone

  %arrayidx4 = getelementptr inbounds i32, ptr %a, i32 2
  %i4 = load i32, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %b, i32 2
  %i5 = load i32, ptr %arrayidx5, align 4
  %add3 = add i32 %i4, %i5
  %call3 = tail call i32 @llvm.ctlz.i32(i32 %add3,i1 true) nounwind readnone

  %arrayidx6 = getelementptr inbounds i32, ptr %a, i32 3
  %i6 = load i32, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds i32, ptr %b, i32 3
  %i7 = load i32, ptr %arrayidx7, align 4
  %add4 = add i32 %i6, %i7
  %call4 = tail call i32 @llvm.ctlz.i32(i32 %add4,i1 false) nounwind readnone

  store i32 %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds i32, ptr %c, i32 1
  store i32 %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %c, i32 2
  store i32 %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds i32, ptr %c, i32 3
  store i32 %call4, ptr %arrayidx10, align 4
  ret void


}


declare i32 @llvm.cttz.i32(i32,i1) nounwind readnone

define void @vec_cttz_i32(ptr %a, ptr %b, ptr %c, i1) {
; CHECK-LABEL: @vec_cttz_i32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[TMP4:%.*]] = load <4 x i32>, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[TMP5:%.*]] = add <4 x i32> [[TMP2]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> [[TMP5]], i1 true)
; CHECK-NEXT:    store <4 x i32> [[TMP6]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load i32, ptr %a, align 4
  %i1 = load i32, ptr %b, align 4
  %add1 = add i32 %i0, %i1
  %call1 = tail call i32 @llvm.cttz.i32(i32 %add1,i1 true) nounwind readnone

  %arrayidx2 = getelementptr inbounds i32, ptr %a, i32 1
  %i2 = load i32, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %b, i32 1
  %i3 = load i32, ptr %arrayidx3, align 4
  %add2 = add i32 %i2, %i3
  %call2 = tail call i32 @llvm.cttz.i32(i32 %add2,i1 true) nounwind readnone

  %arrayidx4 = getelementptr inbounds i32, ptr %a, i32 2
  %i4 = load i32, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %b, i32 2
  %i5 = load i32, ptr %arrayidx5, align 4
  %add3 = add i32 %i4, %i5
  %call3 = tail call i32 @llvm.cttz.i32(i32 %add3,i1 true) nounwind readnone

  %arrayidx6 = getelementptr inbounds i32, ptr %a, i32 3
  %i6 = load i32, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds i32, ptr %b, i32 3
  %i7 = load i32, ptr %arrayidx7, align 4
  %add4 = add i32 %i6, %i7
  %call4 = tail call i32 @llvm.cttz.i32(i32 %add4,i1 true) nounwind readnone

  store i32 %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds i32, ptr %c, i32 1
  store i32 %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %c, i32 2
  store i32 %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds i32, ptr %c, i32 3
  store i32 %call4, ptr %arrayidx10, align 4
  ret void

}

define void @vec_cttz_i32_neg(ptr %a, ptr %b, ptr %c, i1) {
; CHECK-LABEL: @vec_cttz_i32_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I0:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[I1:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[I0]], [[I1]]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @llvm.cttz.i32(i32 [[ADD1]], i1 true) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 1
; CHECK-NEXT:    [[I2:%.*]] = load i32, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 1
; CHECK-NEXT:    [[I3:%.*]] = load i32, ptr [[ARRAYIDX3]], align 4
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[I2]], [[I3]]
; CHECK-NEXT:    [[CALL2:%.*]] = tail call i32 @llvm.cttz.i32(i32 [[ADD2]], i1 false) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 2
; CHECK-NEXT:    [[I4:%.*]] = load i32, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 2
; CHECK-NEXT:    [[I5:%.*]] = load i32, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[ADD3:%.*]] = add i32 [[I4]], [[I5]]
; CHECK-NEXT:    [[CALL3:%.*]] = tail call i32 @llvm.cttz.i32(i32 [[ADD3]], i1 true) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[A]], i32 3
; CHECK-NEXT:    [[I6:%.*]] = load i32, ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[B]], i32 3
; CHECK-NEXT:    [[I7:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
; CHECK-NEXT:    [[ADD4:%.*]] = add i32 [[I6]], [[I7]]
; CHECK-NEXT:    [[CALL4:%.*]] = tail call i32 @llvm.cttz.i32(i32 [[ADD4]], i1 false) #[[ATTR3]]
; CHECK-NEXT:    store i32 [[CALL1]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 1
; CHECK-NEXT:    store i32 [[CALL2]], ptr [[ARRAYIDX8]], align 4
; CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 2
; CHECK-NEXT:    store i32 [[CALL3]], ptr [[ARRAYIDX9]], align 4
; CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[C]], i32 3
; CHECK-NEXT:    store i32 [[CALL4]], ptr [[ARRAYIDX10]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load i32, ptr %a, align 4
  %i1 = load i32, ptr %b, align 4
  %add1 = add i32 %i0, %i1
  %call1 = tail call i32 @llvm.cttz.i32(i32 %add1,i1 true) nounwind readnone

  %arrayidx2 = getelementptr inbounds i32, ptr %a, i32 1
  %i2 = load i32, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %b, i32 1
  %i3 = load i32, ptr %arrayidx3, align 4
  %add2 = add i32 %i2, %i3
  %call2 = tail call i32 @llvm.cttz.i32(i32 %add2,i1 false) nounwind readnone

  %arrayidx4 = getelementptr inbounds i32, ptr %a, i32 2
  %i4 = load i32, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %b, i32 2
  %i5 = load i32, ptr %arrayidx5, align 4
  %add3 = add i32 %i4, %i5
  %call3 = tail call i32 @llvm.cttz.i32(i32 %add3,i1 true) nounwind readnone

  %arrayidx6 = getelementptr inbounds i32, ptr %a, i32 3
  %i6 = load i32, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds i32, ptr %b, i32 3
  %i7 = load i32, ptr %arrayidx7, align 4
  %add4 = add i32 %i6, %i7
  %call4 = tail call i32 @llvm.cttz.i32(i32 %add4,i1 false) nounwind readnone

  store i32 %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds i32, ptr %c, i32 1
  store i32 %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds i32, ptr %c, i32 2
  store i32 %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds i32, ptr %c, i32 3
  store i32 %call4, ptr %arrayidx10, align 4
  ret void

}


declare float @llvm.powi.f32.i32(float, i32)
define void @vec_powi_f32(ptr %a, ptr %b, ptr %c, i32 %P) {
; CHECK-LABEL: @vec_powi_f32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I0:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[I1:%.*]] = load float, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[ADD1:%.*]] = fadd float [[I0]], [[I1]]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD1]], i32 [[P:%.*]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, ptr [[A]], i32 1
; CHECK-NEXT:    [[I2:%.*]] = load float, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, ptr [[B]], i32 1
; CHECK-NEXT:    [[I3:%.*]] = load float, ptr [[ARRAYIDX3]], align 4
; CHECK-NEXT:    [[ADD2:%.*]] = fadd float [[I2]], [[I3]]
; CHECK-NEXT:    [[CALL2:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD2]], i32 [[P]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, ptr [[A]], i32 2
; CHECK-NEXT:    [[I4:%.*]] = load float, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, ptr [[B]], i32 2
; CHECK-NEXT:    [[I5:%.*]] = load float, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[ADD3:%.*]] = fadd float [[I4]], [[I5]]
; CHECK-NEXT:    [[CALL3:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD3]], i32 [[P]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, ptr [[A]], i32 3
; CHECK-NEXT:    [[I6:%.*]] = load float, ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, ptr [[B]], i32 3
; CHECK-NEXT:    [[I7:%.*]] = load float, ptr [[ARRAYIDX7]], align 4
; CHECK-NEXT:    [[ADD4:%.*]] = fadd float [[I6]], [[I7]]
; CHECK-NEXT:    [[CALL4:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD4]], i32 [[P]]) #[[ATTR3]]
; CHECK-NEXT:    store float [[CALL1]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, ptr [[C]], i32 1
; CHECK-NEXT:    store float [[CALL2]], ptr [[ARRAYIDX8]], align 4
; CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, ptr [[C]], i32 2
; CHECK-NEXT:    store float [[CALL3]], ptr [[ARRAYIDX9]], align 4
; CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, ptr [[C]], i32 3
; CHECK-NEXT:    store float [[CALL4]], ptr [[ARRAYIDX10]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load float, ptr %a, align 4
  %i1 = load float, ptr %b, align 4
  %add1 = fadd float %i0, %i1
  %call1 = tail call float @llvm.powi.f32.i32(float %add1,i32 %P) nounwind readnone

  %arrayidx2 = getelementptr inbounds float, ptr %a, i32 1
  %i2 = load float, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds float, ptr %b, i32 1
  %i3 = load float, ptr %arrayidx3, align 4
  %add2 = fadd float %i2, %i3
  %call2 = tail call float @llvm.powi.f32.i32(float %add2,i32 %P) nounwind readnone

  %arrayidx4 = getelementptr inbounds float, ptr %a, i32 2
  %i4 = load float, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %b, i32 2
  %i5 = load float, ptr %arrayidx5, align 4
  %add3 = fadd float %i4, %i5
  %call3 = tail call float @llvm.powi.f32.i32(float %add3,i32 %P) nounwind readnone

  %arrayidx6 = getelementptr inbounds float, ptr %a, i32 3
  %i6 = load float, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds float, ptr %b, i32 3
  %i7 = load float, ptr %arrayidx7, align 4
  %add4 = fadd float %i6, %i7
  %call4 = tail call float @llvm.powi.f32.i32(float %add4,i32 %P) nounwind readnone

  store float %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds float, ptr %c, i32 1
  store float %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds float, ptr %c, i32 2
  store float %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds float, ptr %c, i32 3
  store float %call4, ptr %arrayidx10, align 4
  ret void

}


define void @vec_powi_f32_neg(ptr %a, ptr %b, ptr %c, i32 %P, i32 %Q) {
; CHECK-LABEL: @vec_powi_f32_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I0:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[I1:%.*]] = load float, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[ADD1:%.*]] = fadd float [[I0]], [[I1]]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD1]], i32 [[P:%.*]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds float, ptr [[A]], i32 1
; CHECK-NEXT:    [[I2:%.*]] = load float, ptr [[ARRAYIDX2]], align 4
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds float, ptr [[B]], i32 1
; CHECK-NEXT:    [[I3:%.*]] = load float, ptr [[ARRAYIDX3]], align 4
; CHECK-NEXT:    [[ADD2:%.*]] = fadd float [[I2]], [[I3]]
; CHECK-NEXT:    [[CALL2:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD2]], i32 [[Q:%.*]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds float, ptr [[A]], i32 2
; CHECK-NEXT:    [[I4:%.*]] = load float, ptr [[ARRAYIDX4]], align 4
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds float, ptr [[B]], i32 2
; CHECK-NEXT:    [[I5:%.*]] = load float, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[ADD3:%.*]] = fadd float [[I4]], [[I5]]
; CHECK-NEXT:    [[CALL3:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD3]], i32 [[P]]) #[[ATTR3]]
; CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds float, ptr [[A]], i32 3
; CHECK-NEXT:    [[I6:%.*]] = load float, ptr [[ARRAYIDX6]], align 4
; CHECK-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, ptr [[B]], i32 3
; CHECK-NEXT:    [[I7:%.*]] = load float, ptr [[ARRAYIDX7]], align 4
; CHECK-NEXT:    [[ADD4:%.*]] = fadd float [[I6]], [[I7]]
; CHECK-NEXT:    [[CALL4:%.*]] = tail call float @llvm.powi.f32.i32(float [[ADD4]], i32 [[Q]]) #[[ATTR3]]
; CHECK-NEXT:    store float [[CALL1]], ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, ptr [[C]], i32 1
; CHECK-NEXT:    store float [[CALL2]], ptr [[ARRAYIDX8]], align 4
; CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, ptr [[C]], i32 2
; CHECK-NEXT:    store float [[CALL3]], ptr [[ARRAYIDX9]], align 4
; CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, ptr [[C]], i32 3
; CHECK-NEXT:    store float [[CALL4]], ptr [[ARRAYIDX10]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %i0 = load float, ptr %a, align 4
  %i1 = load float, ptr %b, align 4
  %add1 = fadd float %i0, %i1
  %call1 = tail call float @llvm.powi.f32.i32(float %add1,i32 %P) nounwind readnone

  %arrayidx2 = getelementptr inbounds float, ptr %a, i32 1
  %i2 = load float, ptr %arrayidx2, align 4
  %arrayidx3 = getelementptr inbounds float, ptr %b, i32 1
  %i3 = load float, ptr %arrayidx3, align 4
  %add2 = fadd float %i2, %i3
  %call2 = tail call float @llvm.powi.f32.i32(float %add2,i32 %Q) nounwind readnone

  %arrayidx4 = getelementptr inbounds float, ptr %a, i32 2
  %i4 = load float, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %b, i32 2
  %i5 = load float, ptr %arrayidx5, align 4
  %add3 = fadd float %i4, %i5
  %call3 = tail call float @llvm.powi.f32.i32(float %add3,i32 %P) nounwind readnone

  %arrayidx6 = getelementptr inbounds float, ptr %a, i32 3
  %i6 = load float, ptr %arrayidx6, align 4
  %arrayidx7 = getelementptr inbounds float, ptr %b, i32 3
  %i7 = load float, ptr %arrayidx7, align 4
  %add4 = fadd float %i6, %i7
  %call4 = tail call float @llvm.powi.f32.i32(float %add4,i32 %Q) nounwind readnone

  store float %call1, ptr %c, align 4
  %arrayidx8 = getelementptr inbounds float, ptr %c, i32 1
  store float %call2, ptr %arrayidx8, align 4
  %arrayidx9 = getelementptr inbounds float, ptr %c, i32 2
  store float %call3, ptr %arrayidx9, align 4
  %arrayidx10 = getelementptr inbounds float, ptr %c, i32 3
  store float %call4, ptr %arrayidx10, align 4
  ret void

}
