; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -disable-lsr -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   -ppc-formprep-update-nonconst-inc -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s

; long long foo(char *p, int n, int count) {
;   int j = 0;
;   long long sum = 0;
;   for (int i = 0; i < n; i++) {
;     sum += *(unsigned long long *)(p + j + 5);
;     sum += *(unsigned long long *)(p + j + 9);
;     j += count;
;   }
;   return sum;
; }

define i64 @foo(ptr %p, i32 signext %n, i32 signext %count) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r4, 0
; CHECK-NEXT:    ble cr0, .LBB0_4
; CHECK-NEXT:  # %bb.1: # %for.body.preheader
; CHECK-NEXT:    addi r6, r3, 5
; CHECK-NEXT:    addi r3, r4, -1
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    addi r3, r3, 1
; CHECK-NEXT:    mtctr r3
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    .p2align 5
; CHECK-NEXT:  .LBB0_2: # %for.body
; CHECK-NEXT:    #
; CHECK-NEXT:    ld r4, 0(r6)
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    ld r4, 4(r6)
; CHECK-NEXT:    add r6, r6, r5
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    bdnz .LBB0_2
; CHECK-NEXT:  # %bb.3: # %for.cond.cleanup
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB0_4:
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
entry:
  %cmp16 = icmp sgt i32 %n, 0
  br i1 %cmp16, label %for.body.preheader, label %for.cond.cleanup

for.body.preheader:                               ; preds = %entry
  %0 = sext i32 %count to i64
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body, %entry
  %sum.0.lcssa = phi i64 [ 0, %entry ], [ %add5, %for.body ]
  ret i64 %sum.0.lcssa

for.body:                                         ; preds = %for.body.preheader, %for.body
  %indvars.iv = phi i64 [ 0, %for.body.preheader ], [ %indvars.iv.next, %for.body ]
  %i.019 = phi i32 [ 0, %for.body.preheader ], [ %inc, %for.body ]
  %sum.018 = phi i64 [ 0, %for.body.preheader ], [ %add5, %for.body ]
  %add.ptr = getelementptr inbounds i8, ptr %p, i64 %indvars.iv
  %add.ptr1 = getelementptr inbounds i8, ptr %add.ptr, i64 5
  %1 = load i64, ptr %add.ptr1, align 8
  %add = add i64 %1, %sum.018
  %add.ptr4 = getelementptr inbounds i8, ptr %add.ptr, i64 9
  %2 = load i64, ptr %add.ptr4, align 8
  %add5 = add i64 %add, %2
  %indvars.iv.next = add nsw i64 %indvars.iv, %0
  %inc = add nuw nsw i32 %i.019, 1
  %exitcond.not = icmp eq i32 %inc, %n
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}

; char foo1(char *p, int n, int count) {
;   int j = 0;
;   char sum = 0;
;   for (int i = 0; i < n; i++) {
;     sum += *(p + j + 1000);
;     j += count;
;    }
;   return sum;
; }

define zeroext i8 @foo1(ptr %p, i32 signext %n, i32 signext %count) {
; CHECK-LABEL: foo1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r4, 0
; CHECK-NEXT:    ble cr0, .LBB1_4
; CHECK-NEXT:  # %bb.1: # %for.body.preheader
; CHECK-NEXT:    sub r3, r3, r5
; CHECK-NEXT:    addi r6, r3, 1000
; CHECK-NEXT:    addi r3, r4, -1
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    addi r3, r3, 1
; CHECK-NEXT:    mtctr r3
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB1_2: # %for.body
; CHECK-NEXT:    #
; CHECK-NEXT:    lbzux r4, r6, r5
; CHECK-NEXT:    add r3, r4, r3
; CHECK-NEXT:    bdnz .LBB1_2
; CHECK-NEXT:  # %bb.3: # %for.cond.cleanup
; CHECK-NEXT:    clrldi r3, r3, 56
; CHECK-NEXT:    blr
; CHECK-NEXT:  .LBB1_4:
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
entry:
  %cmp10 = icmp sgt i32 %n, 0
  br i1 %cmp10, label %for.body.preheader, label %for.cond.cleanup

for.body.preheader:                               ; preds = %entry
  %0 = sext i32 %count to i64
  %add.ptr = getelementptr inbounds i8, ptr %p, i64 1000
  br label %for.body

for.cond.cleanup:                                 ; preds = %for.body, %entry
  %sum.0.lcssa = phi i8 [ 0, %entry ], [ %add, %for.body ]
  ret i8 %sum.0.lcssa

for.body:                                         ; preds = %for.body.preheader, %for.body
  %indvars.iv = phi i64 [ 0, %for.body.preheader ], [ %indvars.iv.next, %for.body ]
  %i.013 = phi i32 [ 0, %for.body.preheader ], [ %inc, %for.body ]
  %sum.012 = phi i8 [ 0, %for.body.preheader ], [ %add, %for.body ]
  %add.ptr1 = getelementptr inbounds i8, ptr %add.ptr, i64 %indvars.iv
  %1 = load i8, ptr %add.ptr1, align 1
  %add = add i8 %1, %sum.012
  %indvars.iv.next = add nsw i64 %indvars.iv, %0
  %inc = add nuw nsw i32 %i.013, 1
  %exitcond.not = icmp eq i32 %inc, %n
  br i1 %exitcond.not, label %for.cond.cleanup, label %for.body
}
