; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+m -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+m -verify-machineinstrs < %s | FileCheck %s

declare <2 x i8> @llvm.vp.fshr.v2i8(<2 x i8>, <2 x i8>, <2 x i8>, <2 x i1>, i32)
define <2 x i8> @fshr_v2i8(<2 x i8> %a, <2 x i8> %b, <2 x i8> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i8> @llvm.vp.fshr.v2i8(<2 x i8> %a, <2 x i8> %b, <2 x i8> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i8> %res
}

declare <2 x i8> @llvm.vp.fshl.v2i8(<2 x i8>, <2 x i8>, <2 x i8>, <2 x i1>, i32)
define <2 x i8> @fshl_v2i8(<2 x i8> %a, <2 x i8> %b, <2 x i8> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i8> @llvm.vp.fshl.v2i8(<2 x i8> %a, <2 x i8> %b, <2 x i8> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i8> %res
}

declare <4 x i8> @llvm.vp.fshr.v4i8(<4 x i8>, <4 x i8>, <4 x i8>, <4 x i1>, i32)
define <4 x i8> @fshr_v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i8> @llvm.vp.fshr.v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i8> %res
}

declare <4 x i8> @llvm.vp.fshl.v4i8(<4 x i8>, <4 x i8>, <4 x i8>, <4 x i1>, i32)
define <4 x i8> @fshl_v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i8> @llvm.vp.fshl.v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i8> %res
}

declare <8 x i8> @llvm.vp.fshr.v8i8(<8 x i8>, <8 x i8>, <8 x i8>, <8 x i1>, i32)
define <8 x i8> @fshr_v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i8> @llvm.vp.fshr.v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i8> %res
}

declare <8 x i8> @llvm.vp.fshl.v8i8(<8 x i8>, <8 x i8>, <8 x i8>, <8 x i1>, i32)
define <8 x i8> @fshl_v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i8> @llvm.vp.fshl.v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i8> %res
}

declare <16 x i8> @llvm.vp.fshr.v16i8(<16 x i8>, <16 x i8>, <16 x i8>, <16 x i1>, i32)
define <16 x i8> @fshr_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i8> @llvm.vp.fshr.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i8> %res
}

declare <16 x i8> @llvm.vp.fshl.v16i8(<16 x i8>, <16 x i8>, <16 x i8>, <16 x i1>, i32)
define <16 x i8> @fshl_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 7, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i8> @llvm.vp.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i8> %res
}

declare <32 x i8> @llvm.vp.fshr.v32i8(<32 x i8>, <32 x i8>, <32 x i8>, <32 x i1>, i32)
define <32 x i8> @fshr_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %c, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v14, v12, v0.t
; CHECK-NEXT:    vand.vi v14, v14, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v14, v0.t
; CHECK-NEXT:    vand.vi v12, v12, 7, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <32 x i8> @llvm.vp.fshr.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %c, <32 x i1> %m, i32 %evl)
  ret <32 x i8> %res
}

declare <32 x i8> @llvm.vp.fshl.v32i8(<32 x i8>, <32 x i8>, <32 x i8>, <32 x i1>, i32)
define <32 x i8> @fshl_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %c, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v10, 1, v0.t
; CHECK-NEXT:    vnot.v v14, v12, v0.t
; CHECK-NEXT:    vand.vi v14, v14, 7, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v14, v0.t
; CHECK-NEXT:    vand.vi v12, v12, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <32 x i8> @llvm.vp.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %c, <32 x i1> %m, i32 %evl)
  ret <32 x i8> %res
}

declare <64 x i8> @llvm.vp.fshr.v64i8(<64 x i8>, <64 x i8>, <64 x i8>, <64 x i1>, i32)
define <64 x i8> @fshr_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %c, <64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v20, v16, v0.t
; CHECK-NEXT:    vand.vi v20, v20, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v20, v0.t
; CHECK-NEXT:    vand.vi v16, v16, 7, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <64 x i8> @llvm.vp.fshr.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %c, <64 x i1> %m, i32 %evl)
  ret <64 x i8> %res
}

declare <64 x i8> @llvm.vp.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>, <64 x i1>, i32)
define <64 x i8> @fshl_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %c, <64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v12, 1, v0.t
; CHECK-NEXT:    vnot.v v20, v16, v0.t
; CHECK-NEXT:    vand.vi v20, v20, 7, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v20, v0.t
; CHECK-NEXT:    vand.vi v16, v16, 7, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <64 x i8> @llvm.vp.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %c, <64 x i1> %m, i32 %evl)
  ret <64 x i8> %res
}

declare <2 x i16> @llvm.vp.fshr.v2i16(<2 x i16>, <2 x i16>, <2 x i16>, <2 x i1>, i32)
define <2 x i16> @fshr_v2i16(<2 x i16> %a, <2 x i16> %b, <2 x i16> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i16> @llvm.vp.fshr.v2i16(<2 x i16> %a, <2 x i16> %b, <2 x i16> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i16> %res
}

declare <2 x i16> @llvm.vp.fshl.v2i16(<2 x i16>, <2 x i16>, <2 x i16>, <2 x i1>, i32)
define <2 x i16> @fshl_v2i16(<2 x i16> %a, <2 x i16> %b, <2 x i16> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i16> @llvm.vp.fshl.v2i16(<2 x i16> %a, <2 x i16> %b, <2 x i16> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i16> %res
}

declare <4 x i16> @llvm.vp.fshr.v4i16(<4 x i16>, <4 x i16>, <4 x i16>, <4 x i1>, i32)
define <4 x i16> @fshr_v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i16> @llvm.vp.fshr.v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i16> %res
}

declare <4 x i16> @llvm.vp.fshl.v4i16(<4 x i16>, <4 x i16>, <4 x i16>, <4 x i1>, i32)
define <4 x i16> @fshl_v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i16> @llvm.vp.fshl.v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i16> %res
}

declare <8 x i16> @llvm.vp.fshr.v8i16(<8 x i16>, <8 x i16>, <8 x i16>, <8 x i1>, i32)
define <8 x i16> @fshr_v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i16> @llvm.vp.fshr.v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i16> %res
}

declare <8 x i16> @llvm.vp.fshl.v8i16(<8 x i16>, <8 x i16>, <8 x i16>, <8 x i1>, i32)
define <8 x i16> @fshl_v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vnot.v v11, v10, v0.t
; CHECK-NEXT:    vand.vi v11, v11, 15, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vand.vi v10, v10, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i16> @llvm.vp.fshl.v8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i16> %res
}

declare <16 x i16> @llvm.vp.fshr.v16i16(<16 x i16>, <16 x i16>, <16 x i16>, <16 x i1>, i32)
define <16 x i16> @fshr_v16i16(<16 x i16> %a, <16 x i16> %b, <16 x i16> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v14, v12, v0.t
; CHECK-NEXT:    vand.vi v14, v14, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v14, v0.t
; CHECK-NEXT:    vand.vi v12, v12, 15, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i16> @llvm.vp.fshr.v16i16(<16 x i16> %a, <16 x i16> %b, <16 x i16> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i16> %res
}

declare <16 x i16> @llvm.vp.fshl.v16i16(<16 x i16>, <16 x i16>, <16 x i16>, <16 x i1>, i32)
define <16 x i16> @fshl_v16i16(<16 x i16> %a, <16 x i16> %b, <16 x i16> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v10, 1, v0.t
; CHECK-NEXT:    vnot.v v14, v12, v0.t
; CHECK-NEXT:    vand.vi v14, v14, 15, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v14, v0.t
; CHECK-NEXT:    vand.vi v12, v12, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i16> @llvm.vp.fshl.v16i16(<16 x i16> %a, <16 x i16> %b, <16 x i16> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i16> %res
}

declare <32 x i16> @llvm.vp.fshr.v32i16(<32 x i16>, <32 x i16>, <32 x i16>, <32 x i1>, i32)
define <32 x i16> @fshr_v32i16(<32 x i16> %a, <32 x i16> %b, <32 x i16> %c, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vnot.v v20, v16, v0.t
; CHECK-NEXT:    vand.vi v20, v20, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v20, v0.t
; CHECK-NEXT:    vand.vi v16, v16, 15, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <32 x i16> @llvm.vp.fshr.v32i16(<32 x i16> %a, <32 x i16> %b, <32 x i16> %c, <32 x i1> %m, i32 %evl)
  ret <32 x i16> %res
}

declare <32 x i16> @llvm.vp.fshl.v32i16(<32 x i16>, <32 x i16>, <32 x i16>, <32 x i1>, i32)
define <32 x i16> @fshl_v32i16(<32 x i16> %a, <32 x i16> %b, <32 x i16> %c, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v12, 1, v0.t
; CHECK-NEXT:    vnot.v v20, v16, v0.t
; CHECK-NEXT:    vand.vi v20, v20, 15, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v20, v0.t
; CHECK-NEXT:    vand.vi v16, v16, 15, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <32 x i16> @llvm.vp.fshl.v32i16(<32 x i16> %a, <32 x i16> %b, <32 x i16> %c, <32 x i1> %m, i32 %evl)
  ret <32 x i16> %res
}

declare <2 x i32> @llvm.vp.fshr.v2i32(<2 x i32>, <2 x i32>, <2 x i32>, <2 x i1>, i32)
define <2 x i32> @fshr_v2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i32> @llvm.vp.fshr.v2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i32> %res
}

declare <2 x i32> @llvm.vp.fshl.v2i32(<2 x i32>, <2 x i32>, <2 x i32>, <2 x i1>, i32)
define <2 x i32> @fshl_v2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i32> @llvm.vp.fshl.v2i32(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i32> %res
}

declare <4 x i32> @llvm.vp.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>, <4 x i1>, i32)
define <4 x i32> @fshr_v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i32> @llvm.vp.fshr.v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i32> %res
}

declare <4 x i32> @llvm.vp.fshl.v4i32(<4 x i32>, <4 x i32>, <4 x i32>, <4 x i1>, i32)
define <4 x i32> @fshl_v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i32> @llvm.vp.fshl.v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i32> %res
}

declare <8 x i32> @llvm.vp.fshr.v8i32(<8 x i32>, <8 x i32>, <8 x i32>, <8 x i1>, i32)
define <8 x i32> @fshr_v8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v14, v12, a1, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v14, v0.t
; CHECK-NEXT:    vnot.v v12, v12, v0.t
; CHECK-NEXT:    vand.vx v12, v12, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i32> @llvm.vp.fshr.v8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i32> %res
}

declare <8 x i32> @llvm.vp.fshl.v8i32(<8 x i32>, <8 x i32>, <8 x i32>, <8 x i1>, i32)
define <8 x i32> @fshl_v8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v14, v12, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v14, v0.t
; CHECK-NEXT:    vnot.v v12, v12, v0.t
; CHECK-NEXT:    vand.vx v12, v12, a1, v0.t
; CHECK-NEXT:    vsrl.vi v10, v10, 1, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i32> @llvm.vp.fshl.v8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i32> %res
}

declare <16 x i32> @llvm.vp.fshr.v16i32(<16 x i32>, <16 x i32>, <16 x i32>, <16 x i1>, i32)
define <16 x i32> @fshr_v16i32(<16 x i32> %a, <16 x i32> %b, <16 x i32> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i32> @llvm.vp.fshr.v16i32(<16 x i32> %a, <16 x i32> %b, <16 x i32> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i32> %res
}

declare <16 x i32> @llvm.vp.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>, <16 x i1>, i32)
define <16 x i32> @fshl_v16i32(<16 x i32> %a, <16 x i32> %b, <16 x i32> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 31
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vi v12, v12, 1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <16 x i32> @llvm.vp.fshl.v16i32(<16 x i32> %a, <16 x i32> %b, <16 x i32> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i32> %res
}

declare <2 x i64> @llvm.vp.fshr.v2i64(<2 x i64>, <2 x i64>, <2 x i64>, <2 x i1>, i32)
define <2 x i64> @fshr_v2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i64> @llvm.vp.fshr.v2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i64> %res
}

declare <2 x i64> @llvm.vp.fshl.v2i64(<2 x i64>, <2 x i64>, <2 x i64>, <2 x i1>, i32)
define <2 x i64> @fshl_v2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vand.vx v11, v10, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v11, v0.t
; CHECK-NEXT:    vnot.v v10, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v10, a1, v0.t
; CHECK-NEXT:    vsrl.vi v9, v9, 1, v0.t
; CHECK-NEXT:    vsrl.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
  %res = call <2 x i64> @llvm.vp.fshl.v2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i1> %m, i32 %evl)
  ret <2 x i64> %res
}

declare <4 x i64> @llvm.vp.fshr.v4i64(<4 x i64>, <4 x i64>, <4 x i64>, <4 x i1>, i32)
define <4 x i64> @fshr_v4i64(<4 x i64> %a, <4 x i64> %b, <4 x i64> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vand.vx v14, v12, a1, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v14, v0.t
; CHECK-NEXT:    vnot.v v12, v12, v0.t
; CHECK-NEXT:    vand.vx v12, v12, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i64> @llvm.vp.fshr.v4i64(<4 x i64> %a, <4 x i64> %b, <4 x i64> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i64> %res
}

declare <4 x i64> @llvm.vp.fshl.v4i64(<4 x i64>, <4 x i64>, <4 x i64>, <4 x i1>, i32)
define <4 x i64> @fshl_v4i64(<4 x i64> %a, <4 x i64> %b, <4 x i64> %c, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vand.vx v14, v12, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v14, v0.t
; CHECK-NEXT:    vnot.v v12, v12, v0.t
; CHECK-NEXT:    vand.vx v12, v12, a1, v0.t
; CHECK-NEXT:    vsrl.vi v10, v10, 1, v0.t
; CHECK-NEXT:    vsrl.vv v10, v10, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
  %res = call <4 x i64> @llvm.vp.fshl.v4i64(<4 x i64> %a, <4 x i64> %b, <4 x i64> %c, <4 x i1> %m, i32 %evl)
  ret <4 x i64> %res
}

declare <7 x i64> @llvm.vp.fshr.v7i64(<7 x i64>, <7 x i64>, <7 x i64>, <7 x i1>, i32)
define <7 x i64> @fshr_v7i64(<7 x i64> %a, <7 x i64> %b, <7 x i64> %c, <7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v7i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <7 x i64> @llvm.vp.fshr.v7i64(<7 x i64> %a, <7 x i64> %b, <7 x i64> %c, <7 x i1> %m, i32 %evl)
  ret <7 x i64> %res
}

declare <7 x i64> @llvm.vp.fshl.v7i64(<7 x i64>, <7 x i64>, <7 x i64>, <7 x i1>, i32)
define <7 x i64> @fshl_v7i64(<7 x i64> %a, <7 x i64> %b, <7 x i64> %c, <7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v7i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vi v12, v12, 1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <7 x i64> @llvm.vp.fshl.v7i64(<7 x i64> %a, <7 x i64> %b, <7 x i64> %c, <7 x i1> %m, i32 %evl)
  ret <7 x i64> %res
}

declare <8 x i64> @llvm.vp.fshr.v8i64(<8 x i64>, <8 x i64>, <8 x i64>, <8 x i1>, i32)
define <8 x i64> @fshr_v8i64(<8 x i64> %a, <8 x i64> %b, <8 x i64> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i64> @llvm.vp.fshr.v8i64(<8 x i64> %a, <8 x i64> %b, <8 x i64> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i64> %res
}

declare <8 x i64> @llvm.vp.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>, <8 x i1>, i32)
define <8 x i64> @fshl_v8i64(<8 x i64> %a, <8 x i64> %b, <8 x i64> %c, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 63
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vand.vx v20, v16, a1, v0.t
; CHECK-NEXT:    vsll.vv v8, v8, v20, v0.t
; CHECK-NEXT:    vnot.v v16, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vsrl.vi v12, v12, 1, v0.t
; CHECK-NEXT:    vsrl.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
  %res = call <8 x i64> @llvm.vp.fshl.v8i64(<8 x i64> %a, <8 x i64> %b, <8 x i64> %c, <8 x i1> %m, i32 %evl)
  ret <8 x i64> %res
}

declare <16 x i64> @llvm.vp.fshr.v16i64(<16 x i64>, <16 x i64>, <16 x i64>, <16 x i1>, i32)
define <16 x i64> @fshr_v16i64(<16 x i64> %a, <16 x i64> %b, <16 x i64> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshr_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 3
; CHECK-NEXT:    sub sp, sp, a2
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a2, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a2) # vscale x 64-byte Folded Spill
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v24, a0, v0.t
; CHECK-NEXT:    vsrl.vv v16, v16, v8, v0.t
; CHECK-NEXT:    vnot.v v8, v24, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # vscale x 64-byte Folded Reload
; CHECK-NEXT:    vsll.vi v24, v24, 1, v0.t
; CHECK-NEXT:    vsll.vv v8, v24, v8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  %res = call <16 x i64> @llvm.vp.fshr.v16i64(<16 x i64> %a, <16 x i64> %b, <16 x i64> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i64> %res
}

declare <16 x i64> @llvm.vp.fshl.v16i64(<16 x i64>, <16 x i64>, <16 x i64>, <16 x i1>, i32)
define <16 x i64> @fshl_v16i64(<16 x i64> %a, <16 x i64> %b, <16 x i64> %c, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fshl_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 3
; CHECK-NEXT:    sub sp, sp, a2
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a2, sp, 16
; CHECK-NEXT:    vs8r.v v16, (a2) # vscale x 64-byte Folded Spill
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vmv8r.v v16, v8
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    li a0, 63
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v24, a0, v0.t
; CHECK-NEXT:    vsll.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vnot.v v16, v24, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a0, v0.t
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # vscale x 64-byte Folded Reload
; CHECK-NEXT:    vsrl.vi v24, v24, 1, v0.t
; CHECK-NEXT:    vsrl.vv v16, v24, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    .cfi_def_cfa sp, 16
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
  %res = call <16 x i64> @llvm.vp.fshl.v16i64(<16 x i64> %a, <16 x i64> %b, <16 x i64> %c, <16 x i1> %m, i32 %evl)
  ret <16 x i64> %res
}
