; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=amdgcn -mcpu=tonga -global-isel=0 < %s | FileCheck  -check-prefixes=GFX8DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -global-isel=1 < %s | FileCheck  -check-prefixes=GFX8GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -global-isel=0 < %s | FileCheck  -check-prefixes=GFX9DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -global-isel=1 < %s | FileCheck  -check-prefixes=GFX9GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -global-isel=0 -mattr=+wavefrontsize64 < %s | FileCheck -check-prefixes=GFX10DAGISEL,GFX1064DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -global-isel=1 -mattr=+wavefrontsize64 < %s | FileCheck -check-prefixes=GFX10GISEL,GFX1064GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -global-isel=0 < %s | FileCheck -check-prefixes=GFX10DAGISEL,GFX1032DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -global-isel=1 < %s | FileCheck -check-prefixes=GFX10GISEL,GFX1032GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=0 -mattr=+wavefrontsize64 < %s | FileCheck -check-prefixes=GFX11DAGISEL,GFX1164DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=1 -mattr=+wavefrontsize64 < %s | FileCheck -check-prefixes=GFX11GISEL,GFX1164GISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=0 < %s | FileCheck -check-prefixes=GFX11DAGISEL,GFX1132DAGISEL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel=1 < %s | FileCheck -check-prefixes=GFX11GISEL,GFX1132GISEL %s

define amdgpu_kernel void @uniform_value(ptr addrspace(1) %out, i32 %in) {
; GFX8DAGISEL-LABEL: uniform_value:
; GFX8DAGISEL:       ; %bb.0: ; %entry
; GFX8DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX8DAGISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8DAGISEL-NEXT:    s_endpgm
;
; GFX8GISEL-LABEL: uniform_value:
; GFX8GISEL:       ; %bb.0: ; %entry
; GFX8GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX8GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX8GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8GISEL-NEXT:    s_endpgm
;
; GFX9DAGISEL-LABEL: uniform_value:
; GFX9DAGISEL:       ; %bb.0: ; %entry
; GFX9DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX9DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9DAGISEL-NEXT:    s_endpgm
;
; GFX9GISEL-LABEL: uniform_value:
; GFX9GISEL:       ; %bb.0: ; %entry
; GFX9GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX9GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9GISEL-NEXT:    s_endpgm
;
; GFX10DAGISEL-LABEL: uniform_value:
; GFX10DAGISEL:       ; %bb.0: ; %entry
; GFX10DAGISEL-NEXT:    s_clause 0x1
; GFX10DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX10DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX10DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10DAGISEL-NEXT:    s_endpgm
;
; GFX10GISEL-LABEL: uniform_value:
; GFX10GISEL:       ; %bb.0: ; %entry
; GFX10GISEL-NEXT:    s_clause 0x1
; GFX10GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX10GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10GISEL-NEXT:    s_endpgm
;
; GFX1164DAGISEL-LABEL: uniform_value:
; GFX1164DAGISEL:       ; %bb.0: ; %entry
; GFX1164DAGISEL-NEXT:    s_clause 0x1
; GFX1164DAGISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1164DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1164DAGISEL-NEXT:    s_endpgm
;
; GFX1164GISEL-LABEL: uniform_value:
; GFX1164GISEL:       ; %bb.0: ; %entry
; GFX1164GISEL-NEXT:    s_clause 0x1
; GFX1164GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1164GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1164GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1164GISEL-NEXT:    s_endpgm
;
; GFX1132DAGISEL-LABEL: uniform_value:
; GFX1132DAGISEL:       ; %bb.0: ; %entry
; GFX1132DAGISEL-NEXT:    s_clause 0x1
; GFX1132DAGISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1132DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132DAGISEL-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX1132DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1132DAGISEL-NEXT:    s_endpgm
;
; GFX1132GISEL-LABEL: uniform_value:
; GFX1132GISEL:       ; %bb.0: ; %entry
; GFX1132GISEL-NEXT:    s_clause 0x1
; GFX1132GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1132GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX1132GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1132GISEL-NEXT:    s_endpgm
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 %in, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @const_value(ptr addrspace(1) %out) {
; GFX8DAGISEL-LABEL: const_value:
; GFX8DAGISEL:       ; %bb.0: ; %entry
; GFX8DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v2, 0x7b
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8DAGISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8DAGISEL-NEXT:    s_endpgm
;
; GFX8GISEL-LABEL: const_value:
; GFX8GISEL:       ; %bb.0: ; %entry
; GFX8GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8GISEL-NEXT:    v_mov_b32_e32 v2, 0x7b
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8GISEL-NEXT:    s_endpgm
;
; GFX9DAGISEL-LABEL: const_value:
; GFX9DAGISEL:       ; %bb.0: ; %entry
; GFX9DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9DAGISEL-NEXT:    s_endpgm
;
; GFX9GISEL-LABEL: const_value:
; GFX9GISEL:       ; %bb.0: ; %entry
; GFX9GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9GISEL-NEXT:    s_endpgm
;
; GFX10DAGISEL-LABEL: const_value:
; GFX10DAGISEL:       ; %bb.0: ; %entry
; GFX10DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10DAGISEL-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX10DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10DAGISEL-NEXT:    s_endpgm
;
; GFX10GISEL-LABEL: const_value:
; GFX10GISEL:       ; %bb.0: ; %entry
; GFX10GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX10GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10GISEL-NEXT:    s_endpgm
;
; GFX1164DAGISEL-LABEL: const_value:
; GFX1164DAGISEL:       ; %bb.0: ; %entry
; GFX1164DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v1, 0x7b
; GFX1164DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1164DAGISEL-NEXT:    s_endpgm
;
; GFX1164GISEL-LABEL: const_value:
; GFX1164GISEL:       ; %bb.0: ; %entry
; GFX1164GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1164GISEL-NEXT:    s_endpgm
;
; GFX1132DAGISEL-LABEL: const_value:
; GFX1132DAGISEL:       ; %bb.0: ; %entry
; GFX1132DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132DAGISEL-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, 0x7b
; GFX1132DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1132DAGISEL-NEXT:    s_endpgm
;
; GFX1132GISEL-LABEL: const_value:
; GFX1132GISEL:       ; %bb.0: ; %entry
; GFX1132GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132GISEL-NEXT:    v_dual_mov_b32 v0, 0x7b :: v_dual_mov_b32 v1, 0
; GFX1132GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1132GISEL-NEXT:    s_endpgm
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 123, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @poison_value(ptr addrspace(1) %out, i32 %in) {
; GFX8DAGISEL-LABEL: poison_value:
; GFX8DAGISEL:       ; %bb.0: ; %entry
; GFX8DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8DAGISEL-NEXT:    flat_store_dword v[0:1], v0
; GFX8DAGISEL-NEXT:    s_endpgm
;
; GFX8GISEL-LABEL: poison_value:
; GFX8GISEL:       ; %bb.0: ; %entry
; GFX8GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8GISEL-NEXT:    flat_store_dword v[0:1], v0
; GFX8GISEL-NEXT:    s_endpgm
;
; GFX9DAGISEL-LABEL: poison_value:
; GFX9DAGISEL:       ; %bb.0: ; %entry
; GFX9DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX9DAGISEL-NEXT:    s_endpgm
;
; GFX9GISEL-LABEL: poison_value:
; GFX9GISEL:       ; %bb.0: ; %entry
; GFX9GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX9GISEL-NEXT:    s_endpgm
;
; GFX10DAGISEL-LABEL: poison_value:
; GFX10DAGISEL:       ; %bb.0: ; %entry
; GFX10DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10DAGISEL-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX10DAGISEL-NEXT:    s_endpgm
;
; GFX10GISEL-LABEL: poison_value:
; GFX10GISEL:       ; %bb.0: ; %entry
; GFX10GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10GISEL-NEXT:    global_store_dword v0, v0, s[0:1]
; GFX10GISEL-NEXT:    s_endpgm
;
; GFX11DAGISEL-LABEL: poison_value:
; GFX11DAGISEL:       ; %bb.0: ; %entry
; GFX11DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11DAGISEL-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11DAGISEL-NEXT:    s_endpgm
;
; GFX11GISEL-LABEL: poison_value:
; GFX11GISEL:       ; %bb.0: ; %entry
; GFX11GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11GISEL-NEXT:    global_store_b32 v0, v0, s[0:1]
; GFX11GISEL-NEXT:    s_endpgm
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 poison, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @divergent_value(ptr addrspace(1) %out) {
; GFX8DAGISEL-LABEL: divergent_value:
; GFX8DAGISEL:       ; %bb.0: ; %entry
; GFX8DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX8DAGISEL-NEXT:    s_brev_b32 s4, -2
; GFX8DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX8DAGISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX8DAGISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX8DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX8DAGISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX8DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX8DAGISEL-NEXT:  ; %bb.2:
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8DAGISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8DAGISEL-NEXT:    s_endpgm
;
; GFX8GISEL-LABEL: divergent_value:
; GFX8GISEL:       ; %bb.0: ; %entry
; GFX8GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX8GISEL-NEXT:    s_brev_b32 s4, -2
; GFX8GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX8GISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX8GISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX8GISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX8GISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX8GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX8GISEL-NEXT:  ; %bb.2:
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX8GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8GISEL-NEXT:    s_endpgm
;
; GFX9DAGISEL-LABEL: divergent_value:
; GFX9DAGISEL:       ; %bb.0: ; %entry
; GFX9DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX9DAGISEL-NEXT:    s_brev_b32 s4, -2
; GFX9DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX9DAGISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX9DAGISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX9DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX9DAGISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX9DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9DAGISEL-NEXT:  ; %bb.2:
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9DAGISEL-NEXT:    s_endpgm
;
; GFX9GISEL-LABEL: divergent_value:
; GFX9GISEL:       ; %bb.0: ; %entry
; GFX9GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX9GISEL-NEXT:    s_brev_b32 s4, -2
; GFX9GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX9GISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX9GISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX9GISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX9GISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX9GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX9GISEL-NEXT:  ; %bb.2:
; GFX9GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX9GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9GISEL-NEXT:    s_endpgm
;
; GFX1064DAGISEL-LABEL: divergent_value:
; GFX1064DAGISEL:       ; %bb.0: ; %entry
; GFX1064DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064DAGISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064DAGISEL-NEXT:    s_brev_b32 s4, -2
; GFX1064DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1064DAGISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX1064DAGISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX1064DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX1064DAGISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX1064DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1064DAGISEL-NEXT:  ; %bb.2:
; GFX1064DAGISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064DAGISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1064DAGISEL-NEXT:    s_endpgm
;
; GFX1064GISEL-LABEL: divergent_value:
; GFX1064GISEL:       ; %bb.0: ; %entry
; GFX1064GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064GISEL-NEXT:    s_brev_b32 s4, -2
; GFX1064GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1064GISEL-NEXT:    s_ff1_i32_b64 s5, s[2:3]
; GFX1064GISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX1064GISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX1064GISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX1064GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1064GISEL-NEXT:  ; %bb.2:
; GFX1064GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1064GISEL-NEXT:    s_endpgm
;
; GFX1032DAGISEL-LABEL: divergent_value:
; GFX1032DAGISEL:       ; %bb.0: ; %entry
; GFX1032DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032DAGISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032DAGISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032DAGISEL-NEXT:    s_brev_b32 s2, -2
; GFX1032DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1032DAGISEL-NEXT:    s_ff1_i32_b32 s4, s3
; GFX1032DAGISEL-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1032DAGISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX1032DAGISEL-NEXT:    s_min_i32 s2, s2, s5
; GFX1032DAGISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX1032DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1032DAGISEL-NEXT:  ; %bb.2:
; GFX1032DAGISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1032DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032DAGISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1032DAGISEL-NEXT:    s_endpgm
;
; GFX1032GISEL-LABEL: divergent_value:
; GFX1032GISEL:       ; %bb.0: ; %entry
; GFX1032GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032GISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX1032GISEL-NEXT:    s_brev_b32 s2, -2
; GFX1032GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1032GISEL-NEXT:    s_ff1_i32_b32 s4, s3
; GFX1032GISEL-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1032GISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX1032GISEL-NEXT:    s_min_i32 s2, s2, s5
; GFX1032GISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX1032GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1032GISEL-NEXT:  ; %bb.2:
; GFX1032GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1032GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1032GISEL-NEXT:    s_endpgm
;
; GFX1164DAGISEL-LABEL: divergent_value:
; GFX1164DAGISEL:       ; %bb.0: ; %entry
; GFX1164DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164DAGISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164DAGISEL-NEXT:    s_brev_b32 s4, -2
; GFX1164DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1164DAGISEL-NEXT:    s_ctz_i32_b64 s5, s[2:3]
; GFX1164DAGISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164DAGISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX1164DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX1164DAGISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX1164DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1164DAGISEL-NEXT:  ; %bb.2:
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164DAGISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1164DAGISEL-NEXT:    s_endpgm
;
; GFX1164GISEL-LABEL: divergent_value:
; GFX1164GISEL:       ; %bb.0: ; %entry
; GFX1164GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164GISEL-NEXT:    s_brev_b32 s4, -2
; GFX1164GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1164GISEL-NEXT:    s_ctz_i32_b64 s5, s[2:3]
; GFX1164GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164GISEL-NEXT:    v_readlane_b32 s6, v0, s5
; GFX1164GISEL-NEXT:    s_bitset0_b64 s[2:3], s5
; GFX1164GISEL-NEXT:    s_min_i32 s4, s4, s6
; GFX1164GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1164GISEL-NEXT:  ; %bb.2:
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1164GISEL-NEXT:    s_endpgm
;
; GFX1132DAGISEL-LABEL: divergent_value:
; GFX1132DAGISEL:       ; %bb.0: ; %entry
; GFX1132DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132DAGISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX1132DAGISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132DAGISEL-NEXT:    s_brev_b32 s2, -2
; GFX1132DAGISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1132DAGISEL-NEXT:    s_ctz_i32_b32 s4, s3
; GFX1132DAGISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132DAGISEL-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1132DAGISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX1132DAGISEL-NEXT:    s_min_i32 s2, s2, s5
; GFX1132DAGISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX1132DAGISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1132DAGISEL-NEXT:  ; %bb.2:
; GFX1132DAGISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1132DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132DAGISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1132DAGISEL-NEXT:    s_endpgm
;
; GFX1132GISEL-LABEL: divergent_value:
; GFX1132GISEL:       ; %bb.0: ; %entry
; GFX1132GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132GISEL-NEXT:    s_mov_b32 s3, exec_lo
; GFX1132GISEL-NEXT:    s_brev_b32 s2, -2
; GFX1132GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GFX1132GISEL-NEXT:    s_ctz_i32_b32 s4, s3
; GFX1132GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132GISEL-NEXT:    v_readlane_b32 s5, v0, s4
; GFX1132GISEL-NEXT:    s_bitset0_b32 s3, s4
; GFX1132GISEL-NEXT:    s_min_i32 s2, s2, s5
; GFX1132GISEL-NEXT:    s_cmp_lg_u32 s3, 0
; GFX1132GISEL-NEXT:    s_cbranch_scc1 .LBB3_1
; GFX1132GISEL-NEXT:  ; %bb.2:
; GFX1132GISEL-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, 0
; GFX1132GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1132GISEL-NEXT:    s_endpgm
entry:
  %id.x = call i32 @llvm.amdgcn.workitem.id.x()
  %result = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 %id.x, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @divergent_cfg(ptr addrspace(1) %out, i32 %in) {
; GFX8DAGISEL-LABEL: divergent_cfg:
; GFX8DAGISEL:       ; %bb.0: ; %entry
; GFX8DAGISEL-NEXT:    v_cmp_lt_u32_e32 vcc, 15, v0
; GFX8DAGISEL-NEXT:    ; implicit-def: $sgpr2
; GFX8DAGISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8DAGISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX8DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX8DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX8DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX8DAGISEL-NEXT:    s_or_saveexec_b64 s[0:1], s[0:1]
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX8DAGISEL-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX8DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX8DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX8DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX8DAGISEL-NEXT:    s_brev_b32 s6, -2
; GFX8DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX8DAGISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX8DAGISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX8DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX8DAGISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX8DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX8DAGISEL-NEXT:  ; %bb.5:
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX8DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX8DAGISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX8DAGISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX8DAGISEL-NEXT:    flat_store_dword v[2:3], v1
; GFX8DAGISEL-NEXT:    s_endpgm
;
; GFX8GISEL-LABEL: divergent_cfg:
; GFX8GISEL:       ; %bb.0: ; %entry
; GFX8GISEL-NEXT:    v_cmp_le_u32_e32 vcc, 16, v0
; GFX8GISEL-NEXT:    ; implicit-def: $sgpr6
; GFX8GISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX8GISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX8GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX8GISEL-NEXT:  ; %bb.1: ; %else
; GFX8GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX8GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    s_mov_b32 s6, s2
; GFX8GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX8GISEL-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX8GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX8GISEL-NEXT:  ; %bb.3: ; %if
; GFX8GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX8GISEL-NEXT:    s_brev_b32 s6, -2
; GFX8GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX8GISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX8GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX8GISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX8GISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX8GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX8GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX8GISEL-NEXT:  .LBB4_5: ; %endif
; GFX8GISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX8GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GFX8GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX8GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX8GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX8GISEL-NEXT:    s_endpgm
;
; GFX9DAGISEL-LABEL: divergent_cfg:
; GFX9DAGISEL:       ; %bb.0: ; %entry
; GFX9DAGISEL-NEXT:    v_cmp_lt_u32_e32 vcc, 15, v0
; GFX9DAGISEL-NEXT:    ; implicit-def: $sgpr2
; GFX9DAGISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9DAGISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX9DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX9DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX9DAGISEL-NEXT:    s_or_saveexec_b64 s[0:1], s[0:1]
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX9DAGISEL-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX9DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX9DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX9DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX9DAGISEL-NEXT:    s_brev_b32 s6, -2
; GFX9DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX9DAGISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX9DAGISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX9DAGISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX9DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX9DAGISEL-NEXT:  ; %bb.5:
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX9DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX9DAGISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9DAGISEL-NEXT:    s_endpgm
;
; GFX9GISEL-LABEL: divergent_cfg:
; GFX9GISEL:       ; %bb.0: ; %entry
; GFX9GISEL-NEXT:    v_cmp_le_u32_e32 vcc, 16, v0
; GFX9GISEL-NEXT:    ; implicit-def: $sgpr6
; GFX9GISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX9GISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX9GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX9GISEL-NEXT:  ; %bb.1: ; %else
; GFX9GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    s_mov_b32 s6, s2
; GFX9GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX9GISEL-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX9GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX9GISEL-NEXT:  ; %bb.3: ; %if
; GFX9GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX9GISEL-NEXT:    s_brev_b32 s6, -2
; GFX9GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX9GISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX9GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX9GISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX9GISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX9GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX9GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX9GISEL-NEXT:  .LBB4_5: ; %endif
; GFX9GISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX9GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9GISEL-NEXT:    v_mov_b32_e32 v0, s6
; GFX9GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9GISEL-NEXT:    s_endpgm
;
; GFX1064DAGISEL-LABEL: divergent_cfg:
; GFX1064DAGISEL:       ; %bb.0: ; %entry
; GFX1064DAGISEL-NEXT:    v_cmp_lt_u32_e32 vcc, 15, v0
; GFX1064DAGISEL-NEXT:    ; implicit-def: $sgpr2
; GFX1064DAGISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064DAGISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX1064DAGISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX1064DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1064DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX1064DAGISEL-NEXT:    s_or_saveexec_b64 s[0:1], s[0:1]
; GFX1064DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1064DAGISEL-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX1064DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX1064DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX1064DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064DAGISEL-NEXT:    s_brev_b32 s6, -2
; GFX1064DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1064DAGISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX1064DAGISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX1064DAGISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX1064DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1064DAGISEL-NEXT:  ; %bb.5:
; GFX1064DAGISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX1064DAGISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1064DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1064DAGISEL-NEXT:    s_endpgm
;
; GFX1064GISEL-LABEL: divergent_cfg:
; GFX1064GISEL:       ; %bb.0: ; %entry
; GFX1064GISEL-NEXT:    v_cmp_le_u32_e32 vcc, 16, v0
; GFX1064GISEL-NEXT:    ; implicit-def: $sgpr6
; GFX1064GISEL-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX1064GISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1064GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064GISEL-NEXT:  ; %bb.1: ; %else
; GFX1064GISEL-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX1064GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1064GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064GISEL-NEXT:    s_mov_b32 s6, s2
; GFX1064GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX1064GISEL-NEXT:    s_andn2_saveexec_b64 s[0:1], s[0:1]
; GFX1064GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX1064GISEL-NEXT:  ; %bb.3: ; %if
; GFX1064GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1064GISEL-NEXT:    s_brev_b32 s6, -2
; GFX1064GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1064GISEL-NEXT:    s_ff1_i32_b64 s7, s[2:3]
; GFX1064GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064GISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX1064GISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX1064GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1064GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1064GISEL-NEXT:  .LBB4_5: ; %endif
; GFX1064GISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1064GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1064GISEL-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1064GISEL-NEXT:    s_endpgm
;
; GFX1032DAGISEL-LABEL: divergent_cfg:
; GFX1032DAGISEL:       ; %bb.0: ; %entry
; GFX1032DAGISEL-NEXT:    v_cmp_lt_u32_e32 vcc_lo, 15, v0
; GFX1032DAGISEL-NEXT:    ; implicit-def: $sgpr1
; GFX1032DAGISEL-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX1032DAGISEL-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1032DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX1032DAGISEL-NEXT:    s_load_dword s1, s[4:5], 0x2c
; GFX1032DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1032DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX1032DAGISEL-NEXT:    s_or_saveexec_b32 s0, s0
; GFX1032DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032DAGISEL-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1032DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX1032DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX1032DAGISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032DAGISEL-NEXT:    s_brev_b32 s1, -2
; GFX1032DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1032DAGISEL-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032DAGISEL-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032DAGISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX1032DAGISEL-NEXT:    s_min_i32 s1, s1, s6
; GFX1032DAGISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1032DAGISEL-NEXT:  ; %bb.5:
; GFX1032DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1032DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX1032DAGISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1032DAGISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX1032DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1032DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032DAGISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1032DAGISEL-NEXT:    s_endpgm
;
; GFX1032GISEL-LABEL: divergent_cfg:
; GFX1032GISEL:       ; %bb.0: ; %entry
; GFX1032GISEL-NEXT:    v_cmp_le_u32_e32 vcc_lo, 16, v0
; GFX1032GISEL-NEXT:    ; implicit-def: $sgpr0
; GFX1032GISEL-NEXT:    s_and_saveexec_b32 s1, vcc_lo
; GFX1032GISEL-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1032GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032GISEL-NEXT:  ; %bb.1: ; %else
; GFX1032GISEL-NEXT:    s_load_dword s0, s[4:5], 0x2c
; GFX1032GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1032GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032GISEL-NEXT:    s_mov_b32 s0, s0
; GFX1032GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX1032GISEL-NEXT:    s_andn2_saveexec_b32 s1, s1
; GFX1032GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX1032GISEL-NEXT:  ; %bb.3: ; %if
; GFX1032GISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX1032GISEL-NEXT:    s_brev_b32 s0, -2
; GFX1032GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1032GISEL-NEXT:    s_ff1_i32_b32 s3, s2
; GFX1032GISEL-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1032GISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX1032GISEL-NEXT:    s_min_i32 s0, s0, s6
; GFX1032GISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1032GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1032GISEL-NEXT:  .LBB4_5: ; %endif
; GFX1032GISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032GISEL-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; GFX1032GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1032GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032GISEL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX1032GISEL-NEXT:    s_endpgm
;
; GFX1164DAGISEL-LABEL: divergent_cfg:
; GFX1164DAGISEL:       ; %bb.0: ; %entry
; GFX1164DAGISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164DAGISEL-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164DAGISEL-NEXT:    ; implicit-def: $sgpr2
; GFX1164DAGISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164DAGISEL-NEXT:    v_cmpx_lt_u32_e32 15, v0
; GFX1164DAGISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX1164DAGISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1164DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1164DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX1164DAGISEL-NEXT:    s_or_saveexec_b64 s[0:1], s[0:1]
; GFX1164DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1164DAGISEL-NEXT:    s_xor_b64 exec, exec, s[0:1]
; GFX1164DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX1164DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX1164DAGISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164DAGISEL-NEXT:    s_brev_b32 s6, -2
; GFX1164DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1164DAGISEL-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1164DAGISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164DAGISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1164DAGISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX1164DAGISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX1164DAGISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1164DAGISEL-NEXT:  ; %bb.5:
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX1164DAGISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1164DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1164DAGISEL-NEXT:    s_endpgm
;
; GFX1164GISEL-LABEL: divergent_cfg:
; GFX1164GISEL:       ; %bb.0: ; %entry
; GFX1164GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164GISEL-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164GISEL-NEXT:    ; implicit-def: $sgpr6
; GFX1164GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164GISEL-NEXT:    v_cmpx_le_u32_e32 16, v0
; GFX1164GISEL-NEXT:    s_xor_b64 s[0:1], exec, s[0:1]
; GFX1164GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164GISEL-NEXT:  ; %bb.1: ; %else
; GFX1164GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX1164GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1164GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164GISEL-NEXT:    s_mov_b32 s6, s2
; GFX1164GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX1164GISEL-NEXT:    s_and_not1_saveexec_b64 s[0:1], s[0:1]
; GFX1164GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX1164GISEL-NEXT:  ; %bb.3: ; %if
; GFX1164GISEL-NEXT:    s_mov_b64 s[2:3], exec
; GFX1164GISEL-NEXT:    s_brev_b32 s6, -2
; GFX1164GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1164GISEL-NEXT:    s_ctz_i32_b64 s7, s[2:3]
; GFX1164GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164GISEL-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1164GISEL-NEXT:    s_bitset0_b64 s[2:3], s7
; GFX1164GISEL-NEXT:    s_min_i32 s6, s6, s8
; GFX1164GISEL-NEXT:    s_cmp_lg_u64 s[2:3], 0
; GFX1164GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1164GISEL-NEXT:  .LBB4_5: ; %endif
; GFX1164GISEL-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX1164GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1164GISEL-NEXT:    s_endpgm
;
; GFX1132DAGISEL-LABEL: divergent_cfg:
; GFX1132DAGISEL:       ; %bb.0: ; %entry
; GFX1132DAGISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132DAGISEL-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132DAGISEL-NEXT:    ; implicit-def: $sgpr1
; GFX1132DAGISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132DAGISEL-NEXT:    v_cmpx_lt_u32_e32 15, v0
; GFX1132DAGISEL-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX1132DAGISEL-NEXT:  ; %bb.1: ; %else
; GFX1132DAGISEL-NEXT:    s_load_b32 s1, s[4:5], 0x2c
; GFX1132DAGISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1132DAGISEL-NEXT:  ; %bb.2: ; %Flow
; GFX1132DAGISEL-NEXT:    s_or_saveexec_b32 s0, s0
; GFX1132DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1132DAGISEL-NEXT:    s_xor_b32 exec_lo, exec_lo, s0
; GFX1132DAGISEL-NEXT:    s_cbranch_execz .LBB4_6
; GFX1132DAGISEL-NEXT:  ; %bb.3: ; %if
; GFX1132DAGISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132DAGISEL-NEXT:    s_brev_b32 s1, -2
; GFX1132DAGISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1132DAGISEL-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132DAGISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132DAGISEL-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1132DAGISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX1132DAGISEL-NEXT:    s_min_i32 s1, s1, s6
; GFX1132DAGISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132DAGISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1132DAGISEL-NEXT:  ; %bb.5:
; GFX1132DAGISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1132DAGISEL-NEXT:  .LBB4_6: ; %endif
; GFX1132DAGISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX1132DAGISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX1132DAGISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1132DAGISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132DAGISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1132DAGISEL-NEXT:    s_endpgm
;
; GFX1132GISEL-LABEL: divergent_cfg:
; GFX1132GISEL:       ; %bb.0: ; %entry
; GFX1132GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132GISEL-NEXT:    s_mov_b32 s1, exec_lo
; GFX1132GISEL-NEXT:    ; implicit-def: $sgpr0
; GFX1132GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132GISEL-NEXT:    v_cmpx_le_u32_e32 16, v0
; GFX1132GISEL-NEXT:    s_xor_b32 s1, exec_lo, s1
; GFX1132GISEL-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132GISEL-NEXT:  ; %bb.1: ; %else
; GFX1132GISEL-NEXT:    s_load_b32 s0, s[4:5], 0x2c
; GFX1132GISEL-NEXT:    ; implicit-def: $vgpr0
; GFX1132GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132GISEL-NEXT:    s_mov_b32 s0, s0
; GFX1132GISEL-NEXT:  .LBB4_2: ; %Flow
; GFX1132GISEL-NEXT:    s_and_not1_saveexec_b32 s1, s1
; GFX1132GISEL-NEXT:    s_cbranch_execz .LBB4_5
; GFX1132GISEL-NEXT:  ; %bb.3: ; %if
; GFX1132GISEL-NEXT:    s_mov_b32 s2, exec_lo
; GFX1132GISEL-NEXT:    s_brev_b32 s0, -2
; GFX1132GISEL-NEXT:  .LBB4_4: ; =>This Inner Loop Header: Depth=1
; GFX1132GISEL-NEXT:    s_ctz_i32_b32 s3, s2
; GFX1132GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132GISEL-NEXT:    v_readlane_b32 s6, v0, s3
; GFX1132GISEL-NEXT:    s_bitset0_b32 s2, s3
; GFX1132GISEL-NEXT:    s_min_i32 s0, s0, s6
; GFX1132GISEL-NEXT:    s_cmp_lg_u32 s2, 0
; GFX1132GISEL-NEXT:    s_cbranch_scc1 .LBB4_4
; GFX1132GISEL-NEXT:  .LBB4_5: ; %endif
; GFX1132GISEL-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132GISEL-NEXT:    s_load_b64 s[2:3], s[4:5], 0x24
; GFX1132GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, 0
; GFX1132GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132GISEL-NEXT:    global_store_b32 v1, v0, s[2:3]
; GFX1132GISEL-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %d_cmp = icmp ult i32 %tid, 16
  br i1 %d_cmp, label %if, label %else

if:
  %reducedValTid = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 %tid, i32 1)
  br label %endif

else:
  %reducedValIn = call i32 @llvm.amdgcn.wave.reduce.min.i32(i32 %in, i32 1)
  br label %endif

endif:
  %combine = phi i32 [%reducedValTid, %if], [%reducedValIn, %else]
  store i32 %combine, ptr addrspace(1) %out
  ret void
}
