; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test conversion of floating-point values to unsigned i32s (z10 only).
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z10 | FileCheck %s

; z10 doesn't have native support for unsigned fp-to-i32 conversions;
; they were added in z196 as the Convert to Logical family of instructions.
; Promoting to i64 doesn't generate an inexact condition for values that are
; outside the i32 range but in the i64 range, so use the default expansion.

; Test f16->i32. Converted to signed as the max float value is smaller than
; the signed integer range.
define i32 @f0(half %f) {
; CHECK-LABEL: f0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r14, %r15, 112(%r15)
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    brasl %r14, __extendhfsf2@PLT
; CHECK-NEXT:    cfebr %r2, 5, %f0
; CHECK-NEXT:    lmg %r14, %r15, 272(%r15)
; CHECK-NEXT:    br %r14
  %conv = fptoui half %f to i32
  ret i32 %conv
}

; Test f32->i32.
define i32 @f1(float %f) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI1_0
; CHECK-NEXT:    le %f1, 0(%r1)
; CHECK-NEXT:    cebr %f0, %f1
; CHECK-NEXT:    jnl .LBB1_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    cfebr %r2, 5, %f0
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    sebr %f0, %f1
; CHECK-NEXT:    cfebr %r2, 5, %f0
; CHECK-NEXT:    xilf %r2, 2147483648
; CHECK-NEXT:    br %r14
  %conv = fptoui float %f to i32
  ret i32 %conv
}

; Test f64->i32.
define i32 @f2(double %f) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI2_0
; CHECK-NEXT:    ld %f1, 0(%r1)
; CHECK-NEXT:    cdbr %f0, %f1
; CHECK-NEXT:    jnl .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    cfdbr %r2, 5, %f0
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    sdbr %f0, %f1
; CHECK-NEXT:    cfdbr %r2, 5, %f0
; CHECK-NEXT:    xilf %r2, 2147483648
; CHECK-NEXT:    br %r14
  %conv = fptoui double %f to i32
  ret i32 %conv
}

; Test f128->i32.
define i32 @f3(ptr %src) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld %f0, 0(%r2)
; CHECK-NEXT:    ld %f2, 8(%r2)
; CHECK-NEXT:    larl %r1, .LCPI3_0
; CHECK-NEXT:    lxeb %f1, 0(%r1)
; CHECK-NEXT:    cxbr %f0, %f1
; CHECK-NEXT:    jnl .LBB3_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    cfxbr %r2, 5, %f0
; CHECK-NEXT:    br %r14
; CHECK-NEXT:  .LBB3_2:
; CHECK-NEXT:    sxbr %f0, %f1
; CHECK-NEXT:    cfxbr %r2, 5, %f0
; CHECK-NEXT:    xilf %r2, 2147483648
; CHECK-NEXT:    br %r14
  %f = load fp128, ptr %src
  %conv = fptoui fp128 %f to i32
  ret i32 %conv
}
