; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=csky -verify-machineinstrs -csky-no-aliases -no-integrated-as -mattr=+e2 < %s \
; RUN:   | FileCheck -check-prefix=CSKY %s

; These test that we can use both the architectural names (r*) and the ABI names
; (a*, l* etc) to refer to registers in inline asm constraint lists. In each
; case, the named register should be used for the source register of the `addi`.
;
; The inline assembly will, by default, contain the ABI names for the registers.
;
; Parenthesised registers in comments are the other aliases for this register.

; NOTE: This test uses `r0` (`a0`) as an input, so it should be saved.
define i32 @explicit_register_r0(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r0:
; CSKY:       # %bb.0:
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r0}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r0` (`a0`) as an input, so it should be saved.
define i32 @explicit_register_a0(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_a0:
; CSKY:       # %bb.0:
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{a0}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r1` (`a1`) as an input, so it should be saved.
define i32 @explicit_register_r1(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r1:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r1}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_a1(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_a1:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{a1}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r2` (`a2`) as an input, so it should be saved.
define i32 @explicit_register_r2(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r2:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r2}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_a2(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_a2:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{a2}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r3` (`a3`) as an input, so it should be saved.
define i32 @explicit_register_r3(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r3:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r3}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_a3(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_a3:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 a3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, a3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{a3}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r4` (`l0`) as an input, so it should be saved.
define i32 @explicit_register_r4(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r4:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l0, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r4}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l0(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l0:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l0, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l0, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l0, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l0}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r5` (`l1`) as an input, so it should be saved.
define i32 @explicit_register_r5(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r5:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l1, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l1, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r5}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l1(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l1:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l1, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l1, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l1}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r6` (`l2`) as an input, so it should be saved.
define i32 @explicit_register_r6(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r6:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l2, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l2, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r6}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l2(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l2:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l2, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l2, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l2}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r7` (`l3`) as an input, so it should be saved.
define i32 @explicit_register_r7(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r7:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l3, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l3, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r7}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l3(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l3:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st16.w l3, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld16.w l3, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l3}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r8` (`l4`) as an input, so it should be saved.
define i32 @explicit_register_r8(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r8:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l4, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l4, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r8}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l4(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l4:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l4, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l4, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l4}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r9` (`l5`) as an input, so it should be saved.
define i32 @explicit_register_r9(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r9:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l5, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l5, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l5, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l5, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r9}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l5(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l5:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l5, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l5, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l5, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l5, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l5}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r10` (`l6`) as an input, so it should be saved.
define i32 @explicit_register_r10(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r10:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l6, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l6, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l6, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l6, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r10}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l6(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l6:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l6, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l6, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l6, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l6, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l6}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r11` (`l7`) as an input, so it should be saved.
define i32 @explicit_register_r11(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r11:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l7, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l7, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l7, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l7, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r11}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l7(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l7:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l7, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 l7, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l7, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l7, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l7}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r12` (`t0`) as an input, so it should be saved.
define i32 @explicit_register_r12(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r12:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 t0, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r12}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t0(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t0:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 t0, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t0, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t0}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r13` (`t1`) as an input, so it should be saved.
define i32 @explicit_register_r13(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r13:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 t1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r13}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t1(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t1:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 t1, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t1, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t1}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r14` (`sp`) as an input, so it should be saved.
define i32 @explicit_register_r14(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r14:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 sp, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, sp, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r14}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_sp(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_sp:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov16 sp, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, sp, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{sp}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r15` (`lr`) as an input, so it should be saved.
define i32 @explicit_register_r15(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r15:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 lr, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, lr, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r15}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_lr(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_lr:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov16 lr, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, lr, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{lr}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r16` (`l8`) as an input, so it should be saved.
define i32 @explicit_register_r16(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r16:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l8, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 l8, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l8, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l8, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r16}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l8(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l8:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l8, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 l8, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l8, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l8, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l8}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r17` (`l9`) as an input, so it should be saved.
define i32 @explicit_register_r17(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r17:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l9, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 l9, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l9, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l9, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r17}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_l9(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_l9:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w l9, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 l9, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, l9, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w l9, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{l9}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r18` (`t2`) as an input, so it should be saved.
define i32 @explicit_register_r18(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r18:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r18}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t2(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t2:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t2, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t2, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t2}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r19` (`t3`) as an input, so it should be saved.
define i32 @explicit_register_r19(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r19:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r19}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t3(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t3:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t3, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t3, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t3}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r20` (`t4`) as an input, so it should be saved.
define i32 @explicit_register_r20(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r20:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t4, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t4, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r20}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t4(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t4:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t4, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t4, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t4}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r21` (`t5`) as an input, so it should be saved.
define i32 @explicit_register_r21(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r21:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t5, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t5, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r21}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t5(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t5:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t5, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t5, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t5}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r22` (`t6`) as an input, so it should be saved.
define i32 @explicit_register_r22(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r22:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t6, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t6, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r22}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t6(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t6:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t6, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t6, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t6}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r23` (`t7`) as an input, so it should be saved.
define i32 @explicit_register_r23(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r23:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t7, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t7, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r23}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t7(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t7:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t7, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t7, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t7}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r24` (`t8`) as an input, so it should be saved.
define i32 @explicit_register_r24(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r24:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t8, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t8, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r24}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t8(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t8:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t8, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t8, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t8}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r25` (`t9`) as an input, so it should be saved.
define i32 @explicit_register_r25(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r25:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t9, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t9, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r25}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_t9(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_t9:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 t9, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, t9, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{t9}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r26` (`r26`) as an input, so it should be saved.
define i32 @explicit_register_r26(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r26:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 r26, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, r26, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r26}"(i32 %a)
  ret i32 %1
}


; NOTE: This test uses `r27` (`r27`) as an input, so it should be saved.
define i32 @explicit_register_r27(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r27:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 r27, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, r27, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r27}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r28` (`rgb`) as an input, so it should be saved.
define i32 @explicit_register_r28(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r28:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w rgb, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 rgb, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, rgb, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w rgb, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r28}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_rgb(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_rgb:
; CSKY:       # %bb.0:
; CSKY-NEXT:    subi16 sp, sp, 4
; CSKY-NEXT:    st32.w rgb, (sp, 0) # 4-byte Folded Spill
; CSKY-NEXT:    mov32 rgb, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, rgb, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    ld32.w rgb, (sp, 0) # 4-byte Folded Reload
; CSKY-NEXT:    addi16 sp, sp, 4
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{rgb}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r29` (`rtb`) as an input, so it should be saved.
define i32 @explicit_register_r29(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r29:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 rtb, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, rtb, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r29}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_rtb(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_rtb:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 rtb, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, rtb, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{rtb}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r30` (`svbr`) as an input, so it should be saved.
define i32 @explicit_register_r30(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r30:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 svbr, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, svbr, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r30}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_svbr(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_svbr:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 svbr, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, svbr, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{svbr}"(i32 %a)
  ret i32 %1
}

; NOTE: This test uses `r31` (`tls`) as an input, so it should be saved.
define i32 @explicit_register_r31(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_r31:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 tls, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, tls, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{r31}"(i32 %a)
  ret i32 %1
}

define i32 @explicit_register_tls(i32 %a) nounwind {
; CSKY-LABEL: explicit_register_tls:
; CSKY:       # %bb.0:
; CSKY-NEXT:    mov32 tls, a0
; CSKY-NEXT:    #APP
; CSKY-NEXT:    addi a0, tls, 1
; CSKY-NEXT:    #NO_APP
; CSKY-NEXT:    rts16
  %1 = tail call i32 asm "addi $0, $1, 1", "=r,{tls}"(i32 %a)
  ret i32 %1
}
