; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -passes=function-attrs -enable-nonnull-arg-prop %s | FileCheck %s --check-prefixes=COMMON,FNATTRS
; RUN: opt -S -passes=attributor-light %s | FileCheck %s --check-prefixes=COMMON,ATTRIBUTOR

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

declare nonnull ptr @ret_nonnull()

; Return a pointer trivially nonnull (call return attribute)
define ptr @test1() {
; COMMON-LABEL: define nonnull ptr @test1() {
; COMMON-NEXT:    [[RET:%.*]] = call ptr @ret_nonnull()
; COMMON-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @ret_nonnull()
  ret ptr %ret
}

; Return a pointer trivially nonnull (argument attribute)
define ptr @test2(ptr nonnull %p) {
; FNATTRS-LABEL: define nonnull ptr @test2(
; FNATTRS-SAME: ptr nonnull readnone returned [[P:%.*]]) #[[ATTR0:[0-9]+]] {
; FNATTRS-NEXT:    ret ptr [[P]]
;
; ATTRIBUTOR-LABEL: define nonnull ptr @test2(
; ATTRIBUTOR-SAME: ptr nofree nonnull readnone [[P:%.*]]) #[[ATTR0:[0-9]+]] {
; ATTRIBUTOR-NEXT:    ret ptr [[P]]
;
  ret ptr %p
}

; Given an SCC where one of the functions can not be marked nonnull,
; can we still mark the other one which is trivially nonnull
define ptr @scc_binder(i1 %c) {
; FNATTRS-LABEL: define noundef ptr @scc_binder(
; FNATTRS-SAME: i1 [[C:%.*]]) {
; FNATTRS-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; FNATTRS:       rec:
; FNATTRS-NEXT:    [[TMP1:%.*]] = call ptr @test3(i1 [[C]])
; FNATTRS-NEXT:    br label [[END]]
; FNATTRS:       end:
; FNATTRS-NEXT:    ret ptr null
;
; ATTRIBUTOR-LABEL: define ptr @scc_binder(
; ATTRIBUTOR-SAME: i1 [[C:%.*]]) {
; ATTRIBUTOR-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; ATTRIBUTOR:       rec:
; ATTRIBUTOR-NEXT:    [[TMP1:%.*]] = call ptr @test3(i1 [[C]])
; ATTRIBUTOR-NEXT:    br label [[END]]
; ATTRIBUTOR:       end:
; ATTRIBUTOR-NEXT:    ret ptr null
;
  br i1 %c, label %rec, label %end
rec:
  call ptr @test3(i1 %c)
  br label %end
end:
  ret ptr null
}

define ptr @test3(i1 %c) {
; COMMON-LABEL: define nonnull ptr @test3(
; COMMON-SAME: i1 [[C:%.*]]) {
; COMMON-NEXT:    [[TMP1:%.*]] = call ptr @scc_binder(i1 [[C]])
; COMMON-NEXT:    [[RET:%.*]] = call ptr @ret_nonnull()
; COMMON-NEXT:    ret ptr [[RET]]
;
  call ptr @scc_binder(i1 %c)
  %ret = call ptr @ret_nonnull()
  ret ptr %ret
}

; Given a mutual recursive set of functions, we can mark them
; nonnull if neither can ever return null.  (In this case, they
; just never return period.)
define ptr @test4_helper() {
; FNATTRS-LABEL: define noalias nonnull ptr @test4_helper(
; FNATTRS-SAME: ) #[[ATTR1:[0-9]+]] {
; FNATTRS-NEXT:    [[RET:%.*]] = call ptr @test4()
; FNATTRS-NEXT:    ret ptr [[RET]]
;
; ATTRIBUTOR-LABEL: define ptr @test4_helper(
; ATTRIBUTOR-SAME: ) #[[ATTR1:[0-9]+]] {
; ATTRIBUTOR-NEXT:    [[RET:%.*]] = call ptr @test4() #[[ATTR1]]
; ATTRIBUTOR-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @test4()
  ret ptr %ret
}

define ptr @test4() {
; FNATTRS-LABEL: define noalias nonnull ptr @test4(
; FNATTRS-SAME: ) #[[ATTR1]] {
; FNATTRS-NEXT:    [[RET:%.*]] = call ptr @test4_helper()
; FNATTRS-NEXT:    ret ptr [[RET]]
;
; ATTRIBUTOR-LABEL: define ptr @test4(
; ATTRIBUTOR-SAME: ) #[[ATTR1]] {
; ATTRIBUTOR-NEXT:    [[RET:%.*]] = call ptr @test4_helper() #[[ATTR1]]
; ATTRIBUTOR-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @test4_helper()
  ret ptr %ret
}

; Given a mutual recursive set of functions which *can* return null
; make sure we haven't marked them as nonnull.
define ptr @test5_helper(i1 %c) {
; FNATTRS-LABEL: define noalias noundef ptr @test5_helper(
; FNATTRS-SAME: i1 [[C:%.*]]) #[[ATTR1]] {
; FNATTRS-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; FNATTRS:       rec:
; FNATTRS-NEXT:    [[RET:%.*]] = call ptr @test5(i1 [[C]])
; FNATTRS-NEXT:    br label [[END]]
; FNATTRS:       end:
; FNATTRS-NEXT:    ret ptr null
;
; ATTRIBUTOR-LABEL: define ptr @test5_helper(
; ATTRIBUTOR-SAME: i1 [[C:%.*]]) #[[ATTR1]] {
; ATTRIBUTOR-NEXT:    br i1 [[C]], label [[REC:%.*]], label [[END:%.*]]
; ATTRIBUTOR:       rec:
; ATTRIBUTOR-NEXT:    [[RET:%.*]] = call ptr @test5(i1 [[C]]) #[[ATTR1]]
; ATTRIBUTOR-NEXT:    br label [[END]]
; ATTRIBUTOR:       end:
; ATTRIBUTOR-NEXT:    ret ptr null
;
  br i1 %c, label %rec, label %end
rec:
  %ret = call ptr @test5(i1 %c)
  br label %end
end:
  ret ptr null
}

define ptr @test5(i1 %c) {
; FNATTRS-LABEL: define noalias noundef ptr @test5(
; FNATTRS-SAME: i1 [[C:%.*]]) #[[ATTR1]] {
; FNATTRS-NEXT:    [[RET:%.*]] = call ptr @test5_helper(i1 [[C]])
; FNATTRS-NEXT:    ret ptr [[RET]]
;
; ATTRIBUTOR-LABEL: define ptr @test5(
; ATTRIBUTOR-SAME: i1 [[C:%.*]]) #[[ATTR1]] {
; ATTRIBUTOR-NEXT:    [[RET:%.*]] = call ptr @test5_helper(i1 [[C]]) #[[ATTR1]]
; ATTRIBUTOR-NEXT:    ret ptr [[RET]]
;
  %ret = call ptr @test5_helper(i1 %c)
  ret ptr %ret
}

; Local analysis, but going through a self recursive phi
define ptr @test6a(i1 %arg) {
; COMMON-LABEL: define nonnull ptr @test6a(
; COMMON-SAME: i1 [[ARG:%.*]]) {
; COMMON-NEXT:  entry:
; COMMON-NEXT:    [[RET:%.*]] = call ptr @ret_nonnull()
; COMMON-NEXT:    br label [[LOOP:%.*]]
; COMMON:       loop:
; COMMON-NEXT:    [[PHI:%.*]] = phi ptr [ [[RET]], [[ENTRY:%.*]] ], [ [[PHI]], [[LOOP]] ]
; COMMON-NEXT:    br i1 [[ARG]], label [[LOOP]], label [[EXIT:%.*]]
; COMMON:       exit:
; COMMON-NEXT:    ret ptr [[PHI]]
;
entry:
  %ret = call ptr @ret_nonnull()
  br label %loop
loop:
  %phi = phi ptr [%ret, %entry], [%phi, %loop]
  br i1 %arg, label %loop, label %exit
exit:
  ret ptr %phi
}

define ptr @test6b(i1 %c) {
; COMMON-LABEL: define nonnull ptr @test6b(
; COMMON-SAME: i1 [[C:%.*]]) {
; COMMON-NEXT:  entry:
; COMMON-NEXT:    [[RET:%.*]] = call ptr @ret_nonnull()
; COMMON-NEXT:    br label [[LOOP:%.*]]
; COMMON:       loop:
; COMMON-NEXT:    [[PHI:%.*]] = phi ptr [ [[RET]], [[ENTRY:%.*]] ], [ [[PHI]], [[LOOP]] ]
; COMMON-NEXT:    br i1 [[C]], label [[LOOP]], label [[EXIT:%.*]]
; COMMON:       exit:
; COMMON-NEXT:    ret ptr [[PHI]]
;
entry:
  %ret = call ptr @ret_nonnull()
  br label %loop
loop:
  %phi = phi ptr [%ret, %entry], [%phi, %loop]
  br i1 %c, label %loop, label %exit
exit:
  ret ptr %phi
}

define ptr @test7(ptr %a) {
; FNATTRS-LABEL: define ptr @test7(
; FNATTRS-SAME: ptr readnone returned [[A:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    ret ptr [[A]]
;
; ATTRIBUTOR-LABEL: define ptr @test7(
; ATTRIBUTOR-SAME: ptr nofree readnone [[A:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    ret ptr [[A]]
;
  ret ptr %a
}

define ptr @test8(ptr %a) {
; FNATTRS-LABEL: define nonnull ptr @test8(
; FNATTRS-SAME: ptr readnone [[A:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 1
; FNATTRS-NEXT:    ret ptr [[B]]
;
; ATTRIBUTOR-LABEL: define nonnull ptr @test8(
; ATTRIBUTOR-SAME: ptr nofree readnone [[A:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 1
; ATTRIBUTOR-NEXT:    ret ptr [[B]]
;
  %b = getelementptr inbounds i8, ptr %a, i64 1
  ret ptr %b
}

define ptr @test9(ptr %a, i64 %n) {
; FNATTRS-LABEL: define ptr @test9(
; FNATTRS-SAME: ptr readnone [[A:%.*]], i64 [[N:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[N]]
; FNATTRS-NEXT:    ret ptr [[B]]
;
; ATTRIBUTOR-LABEL: define ptr @test9(
; ATTRIBUTOR-SAME: ptr nofree readnone [[A:%.*]], i64 [[N:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[N]]
; ATTRIBUTOR-NEXT:    ret ptr [[B]]
;
  %b = getelementptr inbounds i8, ptr %a, i64 %n
  ret ptr %b
}

declare void @llvm.assume(i1)
; FIXME: missing nonnull
define ptr @test10(ptr %a, i64 %n) {
; FNATTRS-LABEL: define ptr @test10(
; FNATTRS-SAME: ptr readnone [[A:%.*]], i64 [[N:%.*]]) #[[ATTR3:[0-9]+]] {
; FNATTRS-NEXT:    [[CMP:%.*]] = icmp ne i64 [[N]], 0
; FNATTRS-NEXT:    call void @llvm.assume(i1 [[CMP]])
; FNATTRS-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[N]]
; FNATTRS-NEXT:    ret ptr [[B]]
;
; ATTRIBUTOR-LABEL: define ptr @test10(
; ATTRIBUTOR-SAME: ptr nofree readnone [[A:%.*]], i64 [[N:%.*]]) #[[ATTR3:[0-9]+]] {
; ATTRIBUTOR-NEXT:    [[CMP:%.*]] = icmp ne i64 [[N]], 0
; ATTRIBUTOR-NEXT:    call void @llvm.assume(i1 [[CMP]]) #[[ATTR13:[0-9]+]]
; ATTRIBUTOR-NEXT:    [[B:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[N]]
; ATTRIBUTOR-NEXT:    ret ptr [[B]]
;
  %cmp = icmp ne i64 %n, 0
  call void @llvm.assume(i1 %cmp)
  %b = getelementptr inbounds i8, ptr %a, i64 %n
  ret ptr %b
}

; TEST 11
; char* test11(char *p) {
;   return p? p: nonnull();
; }
define ptr @test11(ptr) local_unnamed_addr {
; FNATTRS-LABEL: define nonnull ptr @test11(
; FNATTRS-SAME: ptr readnone [[TMP0:%.*]]) local_unnamed_addr {
; FNATTRS-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP0]], null
; FNATTRS-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP5:%.*]]
; FNATTRS:       3:
; FNATTRS-NEXT:    [[TMP4:%.*]] = tail call ptr @ret_nonnull()
; FNATTRS-NEXT:    br label [[TMP5]]
; FNATTRS:       5:
; FNATTRS-NEXT:    [[TMP6:%.*]] = phi ptr [ [[TMP4]], [[TMP3]] ], [ [[TMP0]], [[TMP1:%.*]] ]
; FNATTRS-NEXT:    ret ptr [[TMP6]]
;
; ATTRIBUTOR-LABEL: define nonnull ptr @test11(
; ATTRIBUTOR-SAME: ptr [[TMP0:%.*]]) local_unnamed_addr {
; ATTRIBUTOR-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP0]], null
; ATTRIBUTOR-NEXT:    br i1 [[TMP2]], label [[TMP3:%.*]], label [[TMP5:%.*]]
; ATTRIBUTOR:       3:
; ATTRIBUTOR-NEXT:    [[TMP4:%.*]] = tail call ptr @ret_nonnull()
; ATTRIBUTOR-NEXT:    br label [[TMP5]]
; ATTRIBUTOR:       5:
; ATTRIBUTOR-NEXT:    [[TMP6:%.*]] = phi ptr [ [[TMP4]], [[TMP3]] ], [ [[TMP0]], [[TMP1:%.*]] ]
; ATTRIBUTOR-NEXT:    ret ptr [[TMP6]]
;
  %2 = icmp eq ptr %0, null
  br i1 %2, label %3, label %5

; <label>:3:                                      ; preds = %1
  %4 = tail call ptr @ret_nonnull()
  br label %5

; <label>:5:                                      ; preds = %3, %1
  %6 = phi ptr [ %4, %3 ], [ %0, %1 ]
  ret ptr %6
}

; TEST 12
; Simple CallSite Test
declare void @test12_helper(ptr)
define void @test12(ptr nonnull %a) {
; COMMON-LABEL: define void @test12(
; COMMON-SAME: ptr nonnull [[A:%.*]]) {
; COMMON-NEXT:    tail call void @test12_helper(ptr [[A]])
; COMMON-NEXT:    ret void
;
  tail call void @test12_helper(ptr %a)
  ret void
}

; TEST 13
; Simple Argument Tests
declare ptr @unknown()
define void @test13_helper() {
; FNATTRS-LABEL: define void @test13_helper() {
; FNATTRS-NEXT:    [[NONNULLPTR:%.*]] = tail call ptr @ret_nonnull()
; FNATTRS-NEXT:    [[MAYBENULLPTR:%.*]] = tail call ptr @unknown()
; FNATTRS-NEXT:    tail call void @test13(ptr [[NONNULLPTR]], ptr [[NONNULLPTR]], ptr [[MAYBENULLPTR]])
; FNATTRS-NEXT:    tail call void @test13(ptr [[NONNULLPTR]], ptr [[MAYBENULLPTR]], ptr [[NONNULLPTR]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @test13_helper() {
; ATTRIBUTOR-NEXT:    [[NONNULLPTR:%.*]] = tail call ptr @ret_nonnull()
; ATTRIBUTOR-NEXT:    [[MAYBENULLPTR:%.*]] = tail call ptr @unknown()
; ATTRIBUTOR-NEXT:    tail call void @test13(ptr nocapture nofree nonnull readnone [[NONNULLPTR]], ptr nocapture nofree nonnull readnone [[NONNULLPTR]], ptr nocapture nofree readnone [[MAYBENULLPTR]])
; ATTRIBUTOR-NEXT:    tail call void @test13(ptr nocapture nofree nonnull readnone [[NONNULLPTR]], ptr nocapture nofree readnone [[MAYBENULLPTR]], ptr nocapture nofree nonnull readnone [[NONNULLPTR]])
; ATTRIBUTOR-NEXT:    ret void
;
  %nonnullptr = tail call ptr @ret_nonnull()
  %maybenullptr = tail call ptr @unknown()
  tail call void @test13(ptr %nonnullptr, ptr %nonnullptr, ptr %maybenullptr)
  tail call void @test13(ptr %nonnullptr, ptr %maybenullptr, ptr %nonnullptr)
  ret void
}
define internal void @test13(ptr %a, ptr %b, ptr %c) {
; FNATTRS-LABEL: define internal void @test13(
; FNATTRS-SAME: ptr nocapture readnone [[A:%.*]], ptr nocapture readnone [[B:%.*]], ptr nocapture readnone [[C:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define internal void @test13(
; ATTRIBUTOR-SAME: ptr nocapture nofree nonnull readnone [[A:%.*]], ptr nocapture nofree readnone [[B:%.*]], ptr nocapture nofree readnone [[C:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    ret void
;
  ret void
}

declare nonnull ptr @nonnull()

; TEST 14
; Complex propagation
; Argument of f1, f2, f3 can be marked with nonnull.

; * Argument
; 1. In f1:bb6, %arg can be marked with nonnull because of the comparison in bb1
; 2. Because f2 is internal function, f2(ptr %arg) -> @f2(ptr nonnull %arg)
; 3. In f1:bb4 %tmp5 is nonnull and f3 is internal function.
;    Then, f3(ptr %arg) -> @f3(ptr nonnull %arg)
; 4. We get nonnull in whole f1 call sites so f1(ptr %arg) -> @f1(ptr nonnull %arg)


define internal ptr @f1(ptr %arg) {
; FIXME: missing nonnull It should be nonnull @f1(ptr nonnull readonly %arg)
; FNATTRS-LABEL: define internal nonnull ptr @f1(
; FNATTRS-SAME: ptr readonly [[ARG:%.*]]) #[[ATTR4:[0-9]+]] {
; FNATTRS-NEXT:  bb:
; FNATTRS-NEXT:    [[TMP:%.*]] = icmp eq ptr [[ARG]], null
; FNATTRS-NEXT:    br i1 [[TMP]], label [[BB9:%.*]], label [[BB1:%.*]]
; FNATTRS:       bb1:
; FNATTRS-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARG]], align 4
; FNATTRS-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[TMP2]], 0
; FNATTRS-NEXT:    br i1 [[TMP3]], label [[BB6:%.*]], label [[BB4:%.*]]
; FNATTRS:       bb4:
; FNATTRS-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i32, ptr [[ARG]], i64 1
; FNATTRS-NEXT:    [[TMP5B:%.*]] = tail call ptr @f3(ptr [[TMP5]])
; FNATTRS-NEXT:    [[TMP5C:%.*]] = getelementptr inbounds i32, ptr [[TMP5B]], i64 -1
; FNATTRS-NEXT:    br label [[BB9]]
; FNATTRS:       bb6:
; FNATTRS-NEXT:    [[TMP7:%.*]] = tail call ptr @f2(ptr [[ARG]])
; FNATTRS-NEXT:    ret ptr [[TMP7]]
; FNATTRS:       bb9:
; FNATTRS-NEXT:    [[TMP10:%.*]] = phi ptr [ [[TMP5C]], [[BB4]] ], [ inttoptr (i64 4 to ptr), [[BB:%.*]] ]
; FNATTRS-NEXT:    ret ptr [[TMP10]]
;
; ATTRIBUTOR-LABEL: define internal ptr @f1(
; ATTRIBUTOR-SAME: ptr nofree readonly [[ARG:%.*]]) #[[ATTR4:[0-9]+]] {
; ATTRIBUTOR-NEXT:  bb:
; ATTRIBUTOR-NEXT:    [[TMP:%.*]] = icmp eq ptr [[ARG]], null
; ATTRIBUTOR-NEXT:    br i1 [[TMP]], label [[BB9:%.*]], label [[BB1:%.*]]
; ATTRIBUTOR:       bb1:
; ATTRIBUTOR-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARG]], align 4
; ATTRIBUTOR-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[TMP2]], 0
; ATTRIBUTOR-NEXT:    br i1 [[TMP3]], label [[BB6:%.*]], label [[BB4:%.*]]
; ATTRIBUTOR:       bb4:
; ATTRIBUTOR-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i32, ptr [[ARG]], i64 1
; ATTRIBUTOR-NEXT:    [[TMP5B:%.*]] = tail call ptr @f3(ptr nofree nonnull readonly [[TMP5]]) #[[ATTR14:[0-9]+]]
; ATTRIBUTOR-NEXT:    [[TMP5C:%.*]] = getelementptr inbounds i32, ptr [[TMP5B]], i64 -1
; ATTRIBUTOR-NEXT:    br label [[BB9]]
; ATTRIBUTOR:       bb6:
; ATTRIBUTOR-NEXT:    [[TMP7:%.*]] = tail call ptr @f2(ptr nofree nonnull readonly [[ARG]]) #[[ATTR14]]
; ATTRIBUTOR-NEXT:    ret ptr [[TMP7]]
; ATTRIBUTOR:       bb9:
; ATTRIBUTOR-NEXT:    [[TMP10:%.*]] = phi ptr [ [[TMP5C]], [[BB4]] ], [ inttoptr (i64 4 to ptr), [[BB:%.*]] ]
; ATTRIBUTOR-NEXT:    ret ptr [[TMP10]]
;
bb:
  %tmp = icmp eq ptr %arg, null
  br i1 %tmp, label %bb9, label %bb1

bb1:                                              ; preds = %bb
  %tmp2 = load i32, ptr %arg, align 4
  %tmp3 = icmp eq i32 %tmp2, 0
  br i1 %tmp3, label %bb6, label %bb4

bb4:                                              ; preds = %bb1
  %tmp5 = getelementptr inbounds i32, ptr %arg, i64 1
  %tmp5b = tail call ptr @f3(ptr %tmp5)
  %tmp5c = getelementptr inbounds i32, ptr %tmp5b, i64 -1
  br label %bb9

bb6:                                              ; preds = %bb1
; FIXME: missing nonnull. It should be @f2(ptr nonnull %arg)
  %tmp7 = tail call ptr @f2(ptr %arg)
  ret ptr %tmp7

bb9:                                              ; preds = %bb4, %bb
  %tmp10 = phi ptr [ %tmp5c, %bb4 ], [ inttoptr (i64 4 to ptr), %bb ]
  ret ptr %tmp10
}

define internal ptr @f2(ptr %arg) {
; FIXME: missing nonnull. It should be nonnull @f2(ptr nonnull %arg)
; FNATTRS-LABEL: define internal nonnull ptr @f2(
; FNATTRS-SAME: ptr [[ARG:%.*]]) #[[ATTR4]] {
; FNATTRS-NEXT:  bb:
; FNATTRS-NEXT:    [[TMP:%.*]] = tail call ptr @f1(ptr [[ARG]])
; FNATTRS-NEXT:    ret ptr [[TMP]]
;
; ATTRIBUTOR-LABEL: define internal ptr @f2(
; ATTRIBUTOR-SAME: ptr nofree nonnull readonly [[ARG:%.*]]) #[[ATTR4]] {
; ATTRIBUTOR-NEXT:  bb:
; ATTRIBUTOR-NEXT:    [[TMP:%.*]] = tail call ptr @f1(ptr nofree nonnull readonly [[ARG]]) #[[ATTR14]]
; ATTRIBUTOR-NEXT:    ret ptr [[TMP]]
;
bb:

; FIXME: missing nonnull. It should be @f1(ptr nonnull readonly %arg)
  %tmp = tail call ptr @f1(ptr %arg)
  ret ptr %tmp
}

define dso_local noalias ptr @f3(ptr %arg) {
; FIXME: missing nonnull. It should be nonnull @f3(ptr nonnull readonly %arg)
; FNATTRS-LABEL: define dso_local noalias nonnull ptr @f3(
; FNATTRS-SAME: ptr [[ARG:%.*]]) #[[ATTR4]] {
; FNATTRS-NEXT:  bb:
; FNATTRS-NEXT:    [[TMP:%.*]] = call ptr @f1(ptr [[ARG]])
; FNATTRS-NEXT:    ret ptr [[TMP]]
;
; ATTRIBUTOR-LABEL: define dso_local noalias ptr @f3(
; ATTRIBUTOR-SAME: ptr nofree readonly [[ARG:%.*]]) #[[ATTR4]] {
; ATTRIBUTOR-NEXT:  bb:
; ATTRIBUTOR-NEXT:    [[TMP:%.*]] = call ptr @f1(ptr nofree readonly [[ARG]]) #[[ATTR14]]
; ATTRIBUTOR-NEXT:    ret ptr [[TMP]]
;
bb:
; FIXME: missing nonnull. It should be @f1(ptr nonnull readonly %arg)
  %tmp = call ptr @f1(ptr %arg)
  ret ptr %tmp
}

; TEST 15
define void @f15(ptr %arg) {
; FNATTRS-LABEL: define void @f15(
; FNATTRS-SAME: ptr [[ARG:%.*]]) {
; FNATTRS-NEXT:    tail call void @use1(ptr dereferenceable(4) [[ARG]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @f15(
; ATTRIBUTOR-SAME: ptr nonnull [[ARG:%.*]]) {
; ATTRIBUTOR-NEXT:    tail call void @use1(ptr nonnull dereferenceable(4) [[ARG]])
; ATTRIBUTOR-NEXT:    ret void
;
  tail call void @use1(ptr dereferenceable(4) %arg)
  ret void
}

declare void @fun0() #1
declare void @fun1(ptr) #1
declare void @fun2(ptr, ptr) #1
declare void @fun3(ptr, ptr, ptr) #1
; TEST 16 simple path test
; if(..)
;   fun2(nonnull %a, nonnull %b)
; else
;   fun2(nonnull %a, %b)
; We can say that %a is nonnull but %b is not.
define void @f16(ptr %a, ptr %b, i8 %c) {
; FIXME: missing nonnull on %a
; FNATTRS-LABEL: define void @f16(
; FNATTRS-SAME: ptr [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6:[0-9]+]] {
; FNATTRS-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; FNATTRS-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; FNATTRS:       if.then:
; FNATTRS-NEXT:    tail call void @fun2(ptr nonnull [[A]], ptr nonnull [[B]])
; FNATTRS-NEXT:    ret void
; FNATTRS:       if.else:
; FNATTRS-NEXT:    tail call void @fun2(ptr nonnull [[A]], ptr [[B]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @f16(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6:[0-9]+]] {
; ATTRIBUTOR-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; ATTRIBUTOR-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; ATTRIBUTOR:       if.then:
; ATTRIBUTOR-NEXT:    tail call void @fun2(ptr nonnull [[A]], ptr nonnull [[B]]) #[[ATTR15:[0-9]+]]
; ATTRIBUTOR-NEXT:    ret void
; ATTRIBUTOR:       if.else:
; ATTRIBUTOR-NEXT:    tail call void @fun2(ptr nonnull [[A]], ptr [[B]]) #[[ATTR15]]
; ATTRIBUTOR-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  br i1 %cmp, label %if.then, label %if.else
if.then:
  tail call void @fun2(ptr nonnull %a, ptr nonnull %b)
  ret void
if.else:
  tail call void @fun2(ptr nonnull %a, ptr %b)
  ret void
}
; TEST 17 explore child BB test
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; fun1(nonnull %a)
; We can say that %a is nonnull
define void @f17(ptr %a, i8 %c) {
; FNATTRS-LABEL: define void @f17(
; FNATTRS-SAME: ptr [[A:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; FNATTRS-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; FNATTRS-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; FNATTRS:       if.then:
; FNATTRS-NEXT:    tail call void @fun0()
; FNATTRS-NEXT:    br label [[CONT:%.*]]
; FNATTRS:       if.else:
; FNATTRS-NEXT:    tail call void @fun0()
; FNATTRS-NEXT:    br label [[CONT]]
; FNATTRS:       cont:
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @f17(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; ATTRIBUTOR-NEXT:    [[CMP:%.*]] = icmp eq i8 [[C]], 0
; ATTRIBUTOR-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; ATTRIBUTOR:       if.then:
; ATTRIBUTOR-NEXT:    tail call void @fun0() #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT:%.*]]
; ATTRIBUTOR:       if.else:
; ATTRIBUTOR-NEXT:    tail call void @fun0() #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT]]
; ATTRIBUTOR:       cont:
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[A]]) #[[ATTR15]]
; ATTRIBUTOR-NEXT:    ret void
;
  %cmp = icmp eq i8 %c, 0
  br i1 %cmp, label %if.then, label %if.else
if.then:
  tail call void @fun0()
  br label %cont
if.else:
  tail call void @fun0()
  br label %cont
cont:
  tail call void @fun1(ptr nonnull %a)
  ret void
}
; TEST 18 More complex test
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; if(..)
;    ... (willreturn & nounwind)
; else
;    ... (willreturn & nounwind)
; fun1(nonnull %a)

define void @f18(ptr %a, ptr %b, i8 %c) {
; FNATTRS-LABEL: define void @f18(
; FNATTRS-SAME: ptr [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; FNATTRS-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[C]], 0
; FNATTRS-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; FNATTRS:       if.then:
; FNATTRS-NEXT:    tail call void @fun0()
; FNATTRS-NEXT:    br label [[CONT:%.*]]
; FNATTRS:       if.else:
; FNATTRS-NEXT:    tail call void @fun0()
; FNATTRS-NEXT:    br label [[CONT]]
; FNATTRS:       cont:
; FNATTRS-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 1
; FNATTRS-NEXT:    br i1 [[CMP2]], label [[CONT_THEN:%.*]], label [[CONT_ELSE:%.*]]
; FNATTRS:       cont.then:
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[B]])
; FNATTRS-NEXT:    br label [[CONT2:%.*]]
; FNATTRS:       cont.else:
; FNATTRS-NEXT:    tail call void @fun0()
; FNATTRS-NEXT:    br label [[CONT2]]
; FNATTRS:       cont2:
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @f18(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR6]] {
; ATTRIBUTOR-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[C]], 0
; ATTRIBUTOR-NEXT:    br i1 [[CMP1]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; ATTRIBUTOR:       if.then:
; ATTRIBUTOR-NEXT:    tail call void @fun0() #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT:%.*]]
; ATTRIBUTOR:       if.else:
; ATTRIBUTOR-NEXT:    tail call void @fun0() #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT]]
; ATTRIBUTOR:       cont:
; ATTRIBUTOR-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 1
; ATTRIBUTOR-NEXT:    br i1 [[CMP2]], label [[CONT_THEN:%.*]], label [[CONT_ELSE:%.*]]
; ATTRIBUTOR:       cont.then:
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[B]]) #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT2:%.*]]
; ATTRIBUTOR:       cont.else:
; ATTRIBUTOR-NEXT:    tail call void @fun0() #[[ATTR15]]
; ATTRIBUTOR-NEXT:    br label [[CONT2]]
; ATTRIBUTOR:       cont2:
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[A]]) #[[ATTR15]]
; ATTRIBUTOR-NEXT:    ret void
;
  %cmp1 = icmp eq i8 %c, 0
  br i1 %cmp1, label %if.then, label %if.else
if.then:
  tail call void @fun0()
  br label %cont
if.else:
  tail call void @fun0()
  br label %cont
cont:
  %cmp2 = icmp eq i8 %c, 1
  br i1 %cmp2, label %cont.then, label %cont.else
cont.then:
  tail call void @fun1(ptr nonnull %b)
  br label %cont2
cont.else:
  tail call void @fun0()
  br label %cont2
cont2:
  tail call void @fun1(ptr nonnull %a)
  ret void
}

; TEST 19: Loop

define void @f19(ptr %a, ptr %b, i8 %c) {
; FIXME: missing nonnull on %b
; FNATTRS-LABEL: define void @f19(
; FNATTRS-SAME: ptr [[A:%.*]], ptr [[B:%.*]], i8 [[C:%.*]]) #[[ATTR7:[0-9]+]] {
; FNATTRS-NEXT:    br label [[LOOP_HEADER:%.*]]
; FNATTRS:       loop.header:
; FNATTRS-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 0
; FNATTRS-NEXT:    br i1 [[CMP2]], label [[LOOP_BODY:%.*]], label [[LOOP_EXIT:%.*]]
; FNATTRS:       loop.body:
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[B]])
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[A]])
; FNATTRS-NEXT:    br label [[LOOP_HEADER]]
; FNATTRS:       loop.exit:
; FNATTRS-NEXT:    tail call void @fun1(ptr nonnull [[B]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @f19(
; ATTRIBUTOR-SAME: ptr [[A:%.*]], ptr nonnull [[B:%.*]], i8 [[C:%.*]]) #[[ATTR7:[0-9]+]] {
; ATTRIBUTOR-NEXT:    br label [[LOOP_HEADER:%.*]]
; ATTRIBUTOR:       loop.header:
; ATTRIBUTOR-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[C]], 0
; ATTRIBUTOR-NEXT:    br i1 [[CMP2]], label [[LOOP_BODY:%.*]], label [[LOOP_EXIT:%.*]]
; ATTRIBUTOR:       loop.body:
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[B]])
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    br label [[LOOP_HEADER]]
; ATTRIBUTOR:       loop.exit:
; ATTRIBUTOR-NEXT:    tail call void @fun1(ptr nonnull [[B]])
; ATTRIBUTOR-NEXT:    ret void
;
  br label %loop.header
loop.header:
  %cmp2 = icmp eq i8 %c, 0
  br i1 %cmp2, label %loop.body, label %loop.exit
loop.body:
  tail call void @fun1(ptr nonnull %b)
  tail call void @fun1(ptr nonnull %a)
  br label %loop.header
loop.exit:
  tail call void @fun1(ptr nonnull %b)
  ret void
}

; Test propagation of nonnull callsite args back to caller.

declare void @use1(ptr %x)
declare void @use2(ptr %x, ptr %y);
declare void @use3(ptr %x, ptr %y, ptr %z);

declare void @use1nonnull(ptr nonnull noundef %x);
declare void @use1nonnull_without_noundef(ptr nonnull %x);
declare void @use2nonnull(ptr nonnull noundef %x, ptr nonnull noundef %y);
declare void @use3nonnull(ptr nonnull noundef %x, ptr nonnull noundef %y, ptr nonnull noundef %z);

declare i8 @use1safecall(ptr %x) nounwind willreturn ; nounwind+willreturn guarantees that execution continues to successor

; Without noundef, nonnull cannot be propagated to the parent

define void @parent_poison(ptr %a) {
; FNATTR-LABEL: @parent_poison(ptr %a)
; FNATTRS-LABEL: define void @parent_poison(
; FNATTRS-SAME: ptr [[A:%.*]]) {
; FNATTRS-NEXT:    call void @use1nonnull_without_noundef(ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @parent_poison(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @use1nonnull_without_noundef(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret void
;
  call void @use1nonnull_without_noundef(ptr %a)
  ret void
}

; Can't extend non-null to parent for any argument because the 2nd call is not guaranteed to execute.

define void @parent1(ptr %a, ptr %b, ptr %c) {
; COMMON-LABEL: define void @parent1(
; COMMON-SAME: ptr [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; COMMON-NEXT:    call void @use3(ptr [[C]], ptr [[A]], ptr [[B]])
; COMMON-NEXT:    call void @use3nonnull(ptr [[B]], ptr [[C]], ptr [[A]])
; COMMON-NEXT:    ret void
;
  call void @use3(ptr %c, ptr %a, ptr %b)
  call void @use3nonnull(ptr %b, ptr %c, ptr %a)
  ret void
}

; Extend non-null to parent for all arguments.

define void @parent2(ptr %a, ptr %b, ptr %c) {
; FNATTRS-LABEL: define void @parent2(
; FNATTRS-SAME: ptr nonnull [[A:%.*]], ptr nonnull [[B:%.*]], ptr nonnull [[C:%.*]]) {
; FNATTRS-NEXT:    call void @use3nonnull(ptr [[B]], ptr [[C]], ptr [[A]])
; FNATTRS-NEXT:    call void @use3(ptr [[C]], ptr [[A]], ptr [[B]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @parent2(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr nonnull [[B:%.*]], ptr nonnull [[C:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @use3nonnull(ptr nonnull [[B]], ptr nonnull [[C]], ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    call void @use3(ptr [[C]], ptr [[A]], ptr [[B]])
; ATTRIBUTOR-NEXT:    ret void
;


  call void @use3nonnull(ptr %b, ptr %c, ptr %a)
  call void @use3(ptr %c, ptr %a, ptr %b)
  ret void
}

; Extend non-null to parent for 1st argument.

define void @parent3(ptr %a, ptr %b, ptr %c) {
; FNATTRS-LABEL: define void @parent3(
; FNATTRS-SAME: ptr nonnull [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; FNATTRS-NEXT:    call void @use1nonnull(ptr [[A]])
; FNATTRS-NEXT:    call void @use3(ptr [[C]], ptr [[B]], ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @parent3(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr [[B:%.*]], ptr [[C:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @use1nonnull(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    call void @use3(ptr [[C]], ptr [[B]], ptr [[A]])
; ATTRIBUTOR-NEXT:    ret void
;



  call void @use1nonnull(ptr %a)
  call void @use3(ptr %c, ptr %b, ptr %a)
  ret void
}

; Extend non-null to parent for last 2 arguments.

define void @parent4(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: @parent4(ptr %a, ptr nonnull %b, ptr nonnull %c)
; CHECK-NEXT:    call void @use2nonnull(ptr %c, ptr %b)
; CHECK-NEXT:    call void @use2(ptr %a, ptr %c)
; CHECK-NEXT:    call void @use1(ptr %b)
; FNATTRS-LABEL: define void @parent4(
; FNATTRS-SAME: ptr [[A:%.*]], ptr nonnull [[B:%.*]], ptr nonnull [[C:%.*]]) {
; FNATTRS-NEXT:    call void @use2nonnull(ptr [[C]], ptr [[B]])
; FNATTRS-NEXT:    call void @use2(ptr [[A]], ptr [[C]])
; FNATTRS-NEXT:    call void @use1(ptr [[B]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @parent4(
; ATTRIBUTOR-SAME: ptr [[A:%.*]], ptr nonnull [[B:%.*]], ptr nonnull [[C:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @use2nonnull(ptr nonnull [[C]], ptr nonnull [[B]])
; ATTRIBUTOR-NEXT:    call void @use2(ptr [[A]], ptr [[C]])
; ATTRIBUTOR-NEXT:    call void @use1(ptr [[B]])
; ATTRIBUTOR-NEXT:    ret void
;

  call void @use2nonnull(ptr %c, ptr %b)
  call void @use2(ptr %a, ptr %c)
  call void @use1(ptr %b)
  ret void
}

; The callsite must execute in order for the attribute to transfer to the parent.
; It appears benign to extend non-null to the parent in this case, but we can't do that
; because it would incorrectly propagate the wrong information to its callers.

define void @parent5(ptr %a, i1 %a_is_notnull) {
; FNATTRS-LABEL: define void @parent5(
; FNATTRS-SAME: ptr [[A:%.*]], i1 [[A_IS_NOTNULL:%.*]]) {
; FNATTRS-NEXT:    br i1 [[A_IS_NOTNULL]], label [[T:%.*]], label [[F:%.*]]
; FNATTRS:       t:
; FNATTRS-NEXT:    call void @use1nonnull(ptr [[A]])
; FNATTRS-NEXT:    ret void
; FNATTRS:       f:
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @parent5(
; ATTRIBUTOR-SAME: ptr [[A:%.*]], i1 [[A_IS_NOTNULL:%.*]]) {
; ATTRIBUTOR-NEXT:    br i1 [[A_IS_NOTNULL]], label [[T:%.*]], label [[F:%.*]]
; ATTRIBUTOR:       t:
; ATTRIBUTOR-NEXT:    call void @use1nonnull(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret void
; ATTRIBUTOR:       f:
; ATTRIBUTOR-NEXT:    ret void
;

  br i1 %a_is_notnull, label %t, label %f
t:
  call void @use1nonnull(ptr %a)
  ret void
f:
  ret void
}

; The callsite must execute in order for the attribute to transfer to the parent.
; The volatile load can't trap, so we can guarantee that we'll get to the call.

define i8 @parent6(ptr %a, ptr %b) {
; FNATTRS-LABEL: define i8 @parent6(
; FNATTRS-SAME: ptr nonnull [[A:%.*]], ptr [[B:%.*]]) {
; FNATTRS-NEXT:    [[C:%.*]] = load volatile i8, ptr [[B]], align 1
; FNATTRS-NEXT:    call void @use1nonnull(ptr [[A]])
; FNATTRS-NEXT:    ret i8 [[C]]
;
; ATTRIBUTOR-LABEL: define i8 @parent6(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr nofree [[B:%.*]]) {
; ATTRIBUTOR-NEXT:    [[C:%.*]] = load volatile i8, ptr [[B]], align 1
; ATTRIBUTOR-NEXT:    call void @use1nonnull(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret i8 [[C]]
;

  %c = load volatile i8, ptr %b
  call void @use1nonnull(ptr %a)
  ret i8 %c
}

; The nonnull callsite is guaranteed to execute, so the argument must be nonnull throughout the parent.

define i8 @parent7(ptr %a) {
; FNATTRS-LABEL: define i8 @parent7(
; FNATTRS-SAME: ptr nonnull [[A:%.*]]) {
; FNATTRS-NEXT:    [[RET:%.*]] = call i8 @use1safecall(ptr [[A]])
; FNATTRS-NEXT:    call void @use1nonnull(ptr [[A]])
; FNATTRS-NEXT:    ret i8 [[RET]]
;
; ATTRIBUTOR-LABEL: define i8 @parent7(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]]) {
; ATTRIBUTOR-NEXT:    [[RET:%.*]] = call i8 @use1safecall(ptr nonnull [[A]]) #[[ATTR15]]
; ATTRIBUTOR-NEXT:    call void @use1nonnull(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret i8 [[RET]]
;




  %ret = call i8 @use1safecall(ptr %a)
  call void @use1nonnull(ptr %a)
  ret i8 %ret
}

; Make sure that an invoke works similarly to a call.

declare i32 @esfp(...)

define i1 @parent8(ptr %a, ptr %bogus1, ptr %b) personality ptr @esfp{
; FNATTRS-LABEL: define noundef i1 @parent8(
; FNATTRS-SAME: ptr nonnull [[A:%.*]], ptr nocapture readnone [[BOGUS1:%.*]], ptr nonnull [[B:%.*]]) #[[ATTR7]] personality ptr @esfp {
; FNATTRS-NEXT:  entry:
; FNATTRS-NEXT:    invoke void @use2nonnull(ptr [[A]], ptr [[B]])
; FNATTRS-NEXT:            to label [[CONT:%.*]] unwind label [[EXC:%.*]]
; FNATTRS:       cont:
; FNATTRS-NEXT:    [[NULL_CHECK:%.*]] = icmp eq ptr [[B]], null
; FNATTRS-NEXT:    ret i1 [[NULL_CHECK]]
; FNATTRS:       exc:
; FNATTRS-NEXT:    [[LP:%.*]] = landingpad { ptr, i32 }
; FNATTRS-NEXT:            filter [0 x ptr] zeroinitializer
; FNATTRS-NEXT:    unreachable
;
; ATTRIBUTOR-LABEL: define i1 @parent8(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], ptr nocapture nofree readnone [[BOGUS1:%.*]], ptr nonnull [[B:%.*]]) #[[ATTR7]] personality ptr @esfp {
; ATTRIBUTOR-NEXT:  entry:
; ATTRIBUTOR-NEXT:    invoke void @use2nonnull(ptr nonnull [[A]], ptr nonnull [[B]])
; ATTRIBUTOR-NEXT:            to label [[CONT:%.*]] unwind label [[EXC:%.*]]
; ATTRIBUTOR:       cont:
; ATTRIBUTOR-NEXT:    [[NULL_CHECK:%.*]] = icmp eq ptr [[B]], null
; ATTRIBUTOR-NEXT:    ret i1 [[NULL_CHECK]]
; ATTRIBUTOR:       exc:
; ATTRIBUTOR-NEXT:    [[LP:%.*]] = landingpad { ptr, i32 }
; ATTRIBUTOR-NEXT:            filter [0 x ptr] zeroinitializer
; ATTRIBUTOR-NEXT:    unreachable
;

entry:
  invoke void @use2nonnull(ptr %a, ptr %b)
  to label %cont unwind label %exc

cont:
  %null_check = icmp eq ptr %b, null
  ret i1 %null_check

exc:
  %lp = landingpad { ptr, i32 }
  filter [0 x ptr] zeroinitializer
  unreachable
}

define ptr @gep1(ptr %p) {
; FNATTRS-LABEL: define nonnull ptr @gep1(
; FNATTRS-SAME: ptr readnone [[P:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr [[P]], i32 1
; FNATTRS-NEXT:    ret ptr [[Q]]
;
; ATTRIBUTOR-LABEL: define nonnull ptr @gep1(
; ATTRIBUTOR-SAME: ptr nofree readnone [[P:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr [[P]], i32 1
; ATTRIBUTOR-NEXT:    ret ptr [[Q]]
;
  %q = getelementptr inbounds i32, ptr %p, i32 1
  ret ptr %q
}

define ptr @gep1_no_null_opt(ptr %p) #0 {
; Should't be able to derive nonnull based on gep.
; FNATTRS-LABEL: define ptr @gep1_no_null_opt(
; FNATTRS-SAME: ptr readnone [[P:%.*]]) #[[ATTR8:[0-9]+]] {
; FNATTRS-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr [[P]], i32 1
; FNATTRS-NEXT:    ret ptr [[Q]]
;
; ATTRIBUTOR-LABEL: define ptr @gep1_no_null_opt(
; ATTRIBUTOR-SAME: ptr nofree readnone [[P:%.*]]) #[[ATTR8:[0-9]+]] {
; ATTRIBUTOR-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr [[P]], i32 1
; ATTRIBUTOR-NEXT:    ret ptr [[Q]]
;
  %q = getelementptr inbounds i32, ptr %p, i32 1
  ret ptr %q
}

define ptr addrspace(3) @gep2(ptr addrspace(3) %p) {
; FNATTRS-LABEL: define ptr addrspace(3) @gep2(
; FNATTRS-SAME: ptr addrspace(3) readnone [[P:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr addrspace(3) [[P]], i32 1
; FNATTRS-NEXT:    ret ptr addrspace(3) [[Q]]
;
; ATTRIBUTOR-LABEL: define ptr addrspace(3) @gep2(
; ATTRIBUTOR-SAME: ptr addrspace(3) nofree readnone [[P:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[Q:%.*]] = getelementptr inbounds i32, ptr addrspace(3) [[P]], i32 1
; ATTRIBUTOR-NEXT:    ret ptr addrspace(3) [[Q]]
;
  %q = getelementptr inbounds i32, ptr addrspace(3) %p, i32 1
  ret ptr addrspace(3) %q
}

; FIXME: We should propagate dereferenceable here but *not* nonnull
define ptr addrspace(3) @as(ptr addrspace(3) dereferenceable(4) %p) {
; FNATTRS-LABEL: define noundef ptr addrspace(3) @as(
; FNATTRS-SAME: ptr addrspace(3) readnone returned dereferenceable(4) [[P:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    ret ptr addrspace(3) [[P]]
;
; ATTRIBUTOR-LABEL: define ptr addrspace(3) @as(
; ATTRIBUTOR-SAME: ptr addrspace(3) nofree readnone dereferenceable(4) [[P:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    ret ptr addrspace(3) [[P]]
;
  ret ptr addrspace(3) %p
}

define internal ptr @g2() {
; FNATTRS-LABEL: define internal noundef nonnull ptr @g2(
; FNATTRS-SAME: ) #[[ATTR0]] {
; FNATTRS-NEXT:    ret ptr inttoptr (i64 4 to ptr)
;
; ATTRIBUTOR-LABEL: define internal nonnull ptr @g2(
; ATTRIBUTOR-SAME: ) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    ret ptr inttoptr (i64 4 to ptr)
;
  ret ptr inttoptr (i64 4 to ptr)
}

define  ptr @g1() {
; FNATTRS-LABEL: define noundef nonnull ptr @g1(
; FNATTRS-SAME: ) #[[ATTR0]] {
; FNATTRS-NEXT:    [[C:%.*]] = call ptr @g2()
; FNATTRS-NEXT:    ret ptr [[C]]
;
; ATTRIBUTOR-LABEL: define ptr @g1(
; ATTRIBUTOR-SAME: ) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[C:%.*]] = call ptr @g2() #[[ATTR16:[0-9]+]]
; ATTRIBUTOR-NEXT:    ret ptr [[C]]
;
  %c = call ptr @g2()
  ret ptr %c
}

declare void @use_i32_ptr(ptr) readnone nounwind
define internal void @called_by_weak(ptr %a) {
; FNATTRS-LABEL: define internal void @called_by_weak(
; FNATTRS-SAME: ptr nocapture readnone [[A:%.*]]) #[[ATTR1]] {
; FNATTRS-NEXT:    call void @use_i32_ptr(ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define internal void @called_by_weak(
; ATTRIBUTOR-SAME: ptr nocapture nonnull readnone [[A:%.*]]) #[[ATTR10:[0-9]+]] {
; ATTRIBUTOR-NEXT:    call void @use_i32_ptr(ptr nonnull [[A]]) #[[ATTR17:[0-9]+]]
; ATTRIBUTOR-NEXT:    ret void
;
  call void @use_i32_ptr(ptr %a)
  ret void
}

; Check we do not annotate the function interface of this weak function.
define weak_odr void @weak_caller(ptr nonnull %a) {
; FNATTRS-LABEL: define weak_odr void @weak_caller(
; FNATTRS-SAME: ptr nonnull [[A:%.*]]) {
; FNATTRS-NEXT:    call void @called_by_weak(ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define weak_odr void @weak_caller(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @called_by_weak(ptr nocapture nonnull readnone [[A]])
; ATTRIBUTOR-NEXT:    ret void
;
  call void @called_by_weak(ptr %a)
  ret void
}

; Expect nonnull
define internal void @control(ptr dereferenceable(4) %a) {
; FNATTRS-LABEL: define internal void @control(
; FNATTRS-SAME: ptr nocapture readnone dereferenceable(4) [[A:%.*]]) #[[ATTR1]] {
; FNATTRS-NEXT:    call void @use_i32_ptr(ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define internal void @control(
; ATTRIBUTOR-SAME: ptr nocapture nonnull readnone dereferenceable(4) [[A:%.*]]) #[[ATTR10]] {
; ATTRIBUTOR-NEXT:    call void @use_i32_ptr(ptr [[A]]) #[[ATTR17]]
; ATTRIBUTOR-NEXT:    ret void
;
  call void @use_i32_ptr(ptr %a)
  ret void
}
; Avoid nonnull as we do not touch naked functions
define internal void @naked(ptr dereferenceable(4) %a) naked {
; FNATTRS-LABEL: define internal void @naked(
; FNATTRS-SAME: ptr dereferenceable(4) [[A:%.*]]) #[[ATTR10:[0-9]+]] {
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define internal void @naked(
; ATTRIBUTOR-SAME: ptr nonnull dereferenceable(4) [[A:%.*]]) #[[ATTR11:[0-9]+]] {
; ATTRIBUTOR-NEXT:    ret void
;
  ret void
}
; Avoid nonnull as we do not touch optnone
define internal void @optnone(ptr dereferenceable(4) %a) optnone noinline {
; FNATTRS-LABEL: define internal void @optnone(
; FNATTRS-SAME: ptr dereferenceable(4) [[A:%.*]]) #[[ATTR11:[0-9]+]] {
; FNATTRS-NEXT:    call void @use_i32_ptr(ptr [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define internal void @optnone(
; ATTRIBUTOR-SAME: ptr nonnull dereferenceable(4) [[A:%.*]]) #[[ATTR12:[0-9]+]] {
; ATTRIBUTOR-NEXT:    call void @use_i32_ptr(ptr [[A]])
; ATTRIBUTOR-NEXT:    ret void
;
  call void @use_i32_ptr(ptr %a)
  ret void
}
define void @make_live(ptr nonnull dereferenceable(8) %a) {
; FNATTRS-LABEL: define void @make_live(
; FNATTRS-SAME: ptr nonnull dereferenceable(8) [[A:%.*]]) {
; FNATTRS-NEXT:    call void @naked(ptr nonnull align 16 dereferenceable(8) [[A]])
; FNATTRS-NEXT:    call void @control(ptr nonnull align 16 dereferenceable(8) [[A]])
; FNATTRS-NEXT:    call void @optnone(ptr nonnull align 16 dereferenceable(8) [[A]])
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR-LABEL: define void @make_live(
; ATTRIBUTOR-SAME: ptr nonnull dereferenceable(8) [[A:%.*]]) {
; ATTRIBUTOR-NEXT:    call void @naked(ptr nonnull align 16 dereferenceable(8) [[A]])
; ATTRIBUTOR-NEXT:    call void @control(ptr nocapture nonnull readnone align 16 dereferenceable(8) [[A]])
; ATTRIBUTOR-NEXT:    call void @optnone(ptr nonnull align 16 dereferenceable(8) [[A]])
; ATTRIBUTOR-NEXT:    ret void
;
  call void @naked(ptr nonnull dereferenceable(8) align 16 %a)
  call void @control(ptr nonnull dereferenceable(8) align 16 %a)
  call void @optnone(ptr nonnull dereferenceable(8) align 16 %a)
  ret void
}

;int f(int *u, int n){
;  for(int i = 0;i<n;i++){
;    h(u);
;  }
;  return g(nonnull u);
;}
declare void @h(ptr) willreturn nounwind
declare i32 @g(ptr) willreturn nounwind
define i32 @nonnull_exec_ctx_1(ptr %a, i32 %b) {
; COMMON-LABEL: define i32 @nonnull_exec_ctx_1(
; COMMON-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7:[0-9]+]] {
; COMMON-NEXT:  en:
; COMMON-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; COMMON-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; COMMON:       ex:
; COMMON-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; COMMON-NEXT:    ret i32 [[TMP5]]
; COMMON:       hd:
; COMMON-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; COMMON-NEXT:    tail call void @h(ptr [[A]])
; COMMON-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; COMMON-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; COMMON-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(ptr nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd ], [ 0, %en ]
  tail call void @h(ptr %a)
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_1b(ptr %a, i32 %b) {
; COMMON-LABEL: define i32 @nonnull_exec_ctx_1b(
; COMMON-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) #[[ATTR7]] {
; COMMON-NEXT:  en:
; COMMON-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; COMMON-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; COMMON:       ex:
; COMMON-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; COMMON-NEXT:    ret i32 [[TMP5]]
; COMMON:       hd:
; COMMON-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; COMMON-NEXT:    tail call void @h(ptr [[A]])
; COMMON-NEXT:    br label [[HD2]]
; COMMON:       hd2:
; COMMON-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; COMMON-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; COMMON-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(ptr nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd2 ], [ 0, %en ]
  tail call void @h(ptr %a)
  br label %hd2

hd2:
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_2(ptr %a, i32 %b) willreturn nounwind {
; FNATTRS-LABEL: define i32 @nonnull_exec_ctx_2(
; FNATTRS-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; FNATTRS-NEXT:  en:
; FNATTRS-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; FNATTRS-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; FNATTRS:       ex:
; FNATTRS-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; FNATTRS-NEXT:    ret i32 [[TMP5]]
; FNATTRS:       hd:
; FNATTRS-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; FNATTRS-NEXT:    tail call void @h(ptr [[A]])
; FNATTRS-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; FNATTRS-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; FNATTRS-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; ATTRIBUTOR-LABEL: define i32 @nonnull_exec_ctx_2(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; ATTRIBUTOR-NEXT:  en:
; ATTRIBUTOR-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; ATTRIBUTOR-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; ATTRIBUTOR:       ex:
; ATTRIBUTOR-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret i32 [[TMP5]]
; ATTRIBUTOR:       hd:
; ATTRIBUTOR-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD]] ], [ 0, [[EN:%.*]] ]
; ATTRIBUTOR-NEXT:    tail call void @h(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; ATTRIBUTOR-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; ATTRIBUTOR-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(ptr nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd ], [ 0, %en ]
  tail call void @h(ptr %a)
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

define i32 @nonnull_exec_ctx_2b(ptr %a, i32 %b) willreturn nounwind {
; FNATTRS-LABEL: define i32 @nonnull_exec_ctx_2b(
; FNATTRS-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; FNATTRS-NEXT:  en:
; FNATTRS-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; FNATTRS-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; FNATTRS:       ex:
; FNATTRS-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; FNATTRS-NEXT:    ret i32 [[TMP5]]
; FNATTRS:       hd:
; FNATTRS-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; FNATTRS-NEXT:    tail call void @h(ptr [[A]])
; FNATTRS-NEXT:    br label [[HD2]]
; FNATTRS:       hd2:
; FNATTRS-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; FNATTRS-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; FNATTRS-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
; ATTRIBUTOR-LABEL: define i32 @nonnull_exec_ctx_2b(
; ATTRIBUTOR-SAME: ptr nonnull [[A:%.*]], i32 [[B:%.*]]) #[[ATTR6]] {
; ATTRIBUTOR-NEXT:  en:
; ATTRIBUTOR-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[B]], 0
; ATTRIBUTOR-NEXT:    br i1 [[TMP3]], label [[EX:%.*]], label [[HD:%.*]]
; ATTRIBUTOR:       ex:
; ATTRIBUTOR-NEXT:    [[TMP5:%.*]] = tail call i32 @g(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    ret i32 [[TMP5]]
; ATTRIBUTOR:       hd:
; ATTRIBUTOR-NEXT:    [[TMP7:%.*]] = phi i32 [ [[TMP8:%.*]], [[HD2:%.*]] ], [ 0, [[EN:%.*]] ]
; ATTRIBUTOR-NEXT:    tail call void @h(ptr nonnull [[A]])
; ATTRIBUTOR-NEXT:    br label [[HD2]]
; ATTRIBUTOR:       hd2:
; ATTRIBUTOR-NEXT:    [[TMP8]] = add nuw i32 [[TMP7]], 1
; ATTRIBUTOR-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], [[B]]
; ATTRIBUTOR-NEXT:    br i1 [[TMP9]], label [[EX]], label [[HD]]
;
en:
  %tmp3 = icmp eq i32 %b, 0
  br i1 %tmp3, label %ex, label %hd

ex:
  %tmp5 = tail call i32 @g(ptr nonnull %a)
  ret i32 %tmp5

hd:
  %tmp7 = phi i32 [ %tmp8, %hd2 ], [ 0, %en ]
  tail call void @h(ptr %a)
  br label %hd2

hd2:
  %tmp8 = add nuw i32 %tmp7, 1
  %tmp9 = icmp eq i32 %tmp8, %b
  br i1 %tmp9, label %ex, label %hd
}

; Original from PR43833
declare void @sink(ptr)

; FIXME: the sink argument should be marked nonnull as in @PR43833_simple.
define void @PR43833(ptr %0, i32 %1) {
; COMMON-LABEL: define void @PR43833(
; COMMON-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; COMMON-NEXT:    [[TMP3:%.*]] = icmp sgt i32 [[TMP1]], 1
; COMMON-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; COMMON:       4:
; COMMON-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; COMMON-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP5]]
; COMMON-NEXT:    br label [[TMP8:%.*]]
; COMMON:       7:
; COMMON-NEXT:    ret void
; COMMON:       8:
; COMMON-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; COMMON-NEXT:    tail call void @sink(ptr [[TMP6]])
; COMMON-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; COMMON-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; COMMON-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
  %3 = icmp sgt i32 %1, 1
  br i1 %3, label %4, label %7

4:                                                ; preds = %2
  %5 = zext i32 %1 to i64
  %6 = getelementptr inbounds i32, ptr %0, i64 %5
  br label %8

7:                                                ; preds = %8, %2
  ret void

8:                                                ; preds = %8, %4
  %9 = phi i32 [ 1, %4 ], [ %10, %8 ]
  tail call void @sink(ptr %6)
  %10 = add nuw nsw i32 %9, 1
  %11 = icmp eq i32 %10, %1
  br i1 %11, label %7, label %8
}

; Adjusted from PR43833
define void @PR43833_simple(ptr %0, i32 %1) {
; COMMON-LABEL: define void @PR43833_simple(
; COMMON-SAME: ptr [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; COMMON-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP1]], 0
; COMMON-NEXT:    br i1 [[TMP3]], label [[TMP4:%.*]], label [[TMP7:%.*]]
; COMMON:       4:
; COMMON-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP1]] to i64
; COMMON-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i32, ptr [[TMP0]], i64 [[TMP5]]
; COMMON-NEXT:    br label [[TMP8:%.*]]
; COMMON:       7:
; COMMON-NEXT:    ret void
; COMMON:       8:
; COMMON-NEXT:    [[TMP9:%.*]] = phi i32 [ 1, [[TMP4]] ], [ [[TMP10:%.*]], [[TMP8]] ]
; COMMON-NEXT:    tail call void @sink(ptr [[TMP6]])
; COMMON-NEXT:    [[TMP10]] = add nuw nsw i32 [[TMP9]], 1
; COMMON-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], [[TMP1]]
; COMMON-NEXT:    br i1 [[TMP11]], label [[TMP7]], label [[TMP8]]
;
  %3 = icmp ne i32 %1, 0
  br i1 %3, label %4, label %7

4:                                                ; preds = %2
  %5 = zext i32 %1 to i64
  %6 = getelementptr inbounds i32, ptr %0, i64 %5
  br label %8

7:                                                ; preds = %8, %2
  ret void

8:                                                ; preds = %8, %4
  %9 = phi i32 [ 1, %4 ], [ %10, %8 ]
  tail call void @sink(ptr %6)
  %10 = add nuw nsw i32 %9, 1
  %11 = icmp eq i32 %10, %1
  br i1 %11, label %7, label %8
}

define ptr @pr91177_non_inbounds_gep(ptr nonnull %arg) {
; FNATTRS-LABEL: define ptr @pr91177_non_inbounds_gep(
; FNATTRS-SAME: ptr nonnull readnone [[ARG:%.*]]) #[[ATTR0]] {
; FNATTRS-NEXT:    [[RES:%.*]] = getelementptr i8, ptr [[ARG]], i64 -8
; FNATTRS-NEXT:    ret ptr [[RES]]
;
; ATTRIBUTOR-LABEL: define ptr @pr91177_non_inbounds_gep(
; ATTRIBUTOR-SAME: ptr nofree nonnull readnone [[ARG:%.*]]) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[RES:%.*]] = getelementptr i8, ptr [[ARG]], i64 -8
; ATTRIBUTOR-NEXT:    ret ptr [[RES]]
;
  %res = getelementptr i8, ptr %arg, i64 -8
  ret ptr %res
}

attributes #0 = { null_pointer_is_valid }
attributes #1 = { nounwind willreturn}
