; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv64 < %s | FileCheck -check-prefixes=RV64,NO-ZBA %s
; RUN: llc -mtriple=riscv64 -mattr=+zba < %s | FileCheck -check-prefixes=RV64,ZBA %s

define void @add_sext_shl_moreOneUse_add(ptr %array1, i32 %a, i32 %b) {
; NO-ZBA-LABEL: add_sext_shl_moreOneUse_add:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a3, a1, 5
; NO-ZBA-NEXT:    sext.w a1, a1
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a1, a0
; NO-ZBA-NEXT:    sw a2, 20(a0)
; NO-ZBA-NEXT:    sw a2, 24(a0)
; NO-ZBA-NEXT:    sw a3, 140(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_sext_shl_moreOneUse_add:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a3, a1, 5
; ZBA-NEXT:    sext.w a1, a1
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    sw a2, 20(a0)
; ZBA-NEXT:    sw a2, 24(a0)
; ZBA-NEXT:    sw a3, 140(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i32 %a, 5
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %array1, i64 %idxprom
  store i32 %b, ptr %arrayidx
  %add3 = add nsw i32 %a, 6
  %idxprom4 = sext i32 %add3 to i64
  %arrayidx5 = getelementptr inbounds i32, ptr %array1, i64 %idxprom4
  store i32 %b, ptr %arrayidx5
  %add6 = add nsw i32 %a, 35
  %idxprom7 = sext i32 %add6 to i64
  %arrayidx8 = getelementptr inbounds i32, ptr %array1, i64 %idxprom7
  store i32 %add, ptr %arrayidx8
  ret void
}

define void @add_sext_shl_moreOneUse_addexceedsign12(ptr %array1, i32 %a, i32 %b) {
; NO-ZBA-LABEL: add_sext_shl_moreOneUse_addexceedsign12:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a3, a1, 2047
; NO-ZBA-NEXT:    lui a4, 2
; NO-ZBA-NEXT:    sext.w a1, a1
; NO-ZBA-NEXT:    addi a3, a3, 1
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a0, a4
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    sw a2, 0(a0)
; NO-ZBA-NEXT:    sw a3, 4(a0)
; NO-ZBA-NEXT:    sw a2, 120(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_sext_shl_moreOneUse_addexceedsign12:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a3, a1, 2047
; ZBA-NEXT:    lui a4, 2
; ZBA-NEXT:    sext.w a1, a1
; ZBA-NEXT:    addi a3, a3, 1
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    add a0, a0, a4
; ZBA-NEXT:    sw a2, 0(a0)
; ZBA-NEXT:    sw a3, 4(a0)
; ZBA-NEXT:    sw a2, 120(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i32 %a, 2048
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %array1, i64 %idxprom
  store i32 %b, ptr %arrayidx
  %0 = sext i32 %a to i64
  %1 = getelementptr i32, ptr %array1, i64 %0
  %arrayidx3 = getelementptr i8, ptr %1, i64 8196
  store i32 %add, ptr %arrayidx3
  %arrayidx6 = getelementptr i8, ptr %1, i64 8312
  store i32 %b, ptr %arrayidx6
  ret void
}

define void @add_sext_shl_moreOneUse_sext(ptr %array1, i32 %a, i32 %b) {
; NO-ZBA-LABEL: add_sext_shl_moreOneUse_sext:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    sext.w a1, a1
; NO-ZBA-NEXT:    addi a3, a1, 5
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a1, a0
; NO-ZBA-NEXT:    sw a2, 20(a0)
; NO-ZBA-NEXT:    sw a2, 24(a0)
; NO-ZBA-NEXT:    sd a3, 140(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_sext_shl_moreOneUse_sext:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    sext.w a1, a1
; ZBA-NEXT:    addi a3, a1, 5
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    sw a2, 20(a0)
; ZBA-NEXT:    sw a2, 24(a0)
; ZBA-NEXT:    sd a3, 140(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i32 %a, 5
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %array1, i64 %idxprom
  store i32 %b, ptr %arrayidx
  %add3 = add nsw i32 %a, 6
  %idxprom4 = sext i32 %add3 to i64
  %arrayidx5 = getelementptr inbounds i32, ptr %array1, i64 %idxprom4
  store i32 %b, ptr %arrayidx5
  %add6 = add nsw i32 %a, 35
  %idxprom7 = sext i32 %add6 to i64
  %arrayidx8 = getelementptr inbounds i32, ptr %array1, i64 %idxprom7
  store i64 %idxprom, ptr %arrayidx8
  ret void
}

; test of jumpping, find add's operand has one more use can simplified
define void @add_sext_shl_moreOneUse_add_inSelect(ptr %array1, i32 signext  %a, i32 %b, i32 signext %x) {
; NO-ZBA-LABEL: add_sext_shl_moreOneUse_add_inSelect:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a4, a1, 5
; NO-ZBA-NEXT:    mv a5, a4
; NO-ZBA-NEXT:    bgtz a3, .LBB3_2
; NO-ZBA-NEXT:  # %bb.1: # %entry
; NO-ZBA-NEXT:    mv a5, a2
; NO-ZBA-NEXT:  .LBB3_2: # %entry
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a1, a0
; NO-ZBA-NEXT:    sw a5, 20(a0)
; NO-ZBA-NEXT:    sw a5, 24(a0)
; NO-ZBA-NEXT:    sw a4, 140(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_sext_shl_moreOneUse_add_inSelect:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a4, a1, 5
; ZBA-NEXT:    mv a5, a4
; ZBA-NEXT:    bgtz a3, .LBB3_2
; ZBA-NEXT:  # %bb.1: # %entry
; ZBA-NEXT:    mv a5, a2
; ZBA-NEXT:  .LBB3_2: # %entry
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    sw a5, 20(a0)
; ZBA-NEXT:    sw a5, 24(a0)
; ZBA-NEXT:    sw a4, 140(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i32 %a, 5
  %cmp = icmp sgt i32 %x, 0
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %array1, i64 %idxprom
  %add.b = select i1 %cmp, i32 %add, i32 %b
  store i32 %add.b, ptr %arrayidx
  %add5 = add nsw i32 %a, 6
  %idxprom6 = sext i32 %add5 to i64
  %arrayidx7 = getelementptr inbounds i32, ptr %array1, i64 %idxprom6
  store i32 %add.b, ptr %arrayidx7
  %add8 = add nsw i32 %a, 35
  %idxprom9 = sext i32 %add8 to i64
  %arrayidx10 = getelementptr inbounds i32, ptr %array1, i64 %idxprom9
  store i32 %add, ptr %arrayidx10
  ret void
}

define void @add_sext_shl_moreOneUse_add_inSelect_addexceedsign12(ptr %array1, i32 signext  %a, i32 %b, i32 signext %x) {
; NO-ZBA-LABEL: add_sext_shl_moreOneUse_add_inSelect_addexceedsign12:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a4, a1, 2047
; NO-ZBA-NEXT:    lui a5, 2
; NO-ZBA-NEXT:    slli a6, a1, 2
; NO-ZBA-NEXT:    addi a1, a4, 1
; NO-ZBA-NEXT:    add a0, a0, a6
; NO-ZBA-NEXT:    add a0, a0, a5
; NO-ZBA-NEXT:    mv a4, a1
; NO-ZBA-NEXT:    bgtz a3, .LBB4_2
; NO-ZBA-NEXT:  # %bb.1: # %entry
; NO-ZBA-NEXT:    mv a4, a2
; NO-ZBA-NEXT:  .LBB4_2: # %entry
; NO-ZBA-NEXT:    sw a4, 0(a0)
; NO-ZBA-NEXT:    sw a4, 4(a0)
; NO-ZBA-NEXT:    sw a1, 120(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_sext_shl_moreOneUse_add_inSelect_addexceedsign12:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a4, a1, 2047
; ZBA-NEXT:    lui a5, 2
; ZBA-NEXT:    addi a4, a4, 1
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    add a0, a0, a5
; ZBA-NEXT:    mv a1, a4
; ZBA-NEXT:    bgtz a3, .LBB4_2
; ZBA-NEXT:  # %bb.1: # %entry
; ZBA-NEXT:    mv a1, a2
; ZBA-NEXT:  .LBB4_2: # %entry
; ZBA-NEXT:    sw a1, 0(a0)
; ZBA-NEXT:    sw a1, 4(a0)
; ZBA-NEXT:    sw a4, 120(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i32 %a, 2048
  %cmp = icmp sgt i32 %x, 0
  %idxprom = sext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %array1, i64 %idxprom
  %add.b = select i1 %cmp, i32 %add, i32 %b
  store i32 %add.b, ptr %arrayidx
  %0 = sext i32 %a to i64
  %1 = getelementptr i32, ptr %array1, i64 %0
  %arrayidx7 = getelementptr i8, ptr %1, i64 8196
  store i32 %add.b, ptr %arrayidx7
  %arrayidx10 = getelementptr i8, ptr %1, i64 8312
  store i32 %add, ptr %arrayidx10
  ret void
}

define void @add_shl_moreOneUse_inSelect(ptr %array1, i64 %a, i64 %b, i64 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_inSelect:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a4, a1, 5
; NO-ZBA-NEXT:    mv a5, a4
; NO-ZBA-NEXT:    bgtz a3, .LBB5_2
; NO-ZBA-NEXT:  # %bb.1: # %entry
; NO-ZBA-NEXT:    mv a5, a2
; NO-ZBA-NEXT:  .LBB5_2: # %entry
; NO-ZBA-NEXT:    slli a1, a1, 3
; NO-ZBA-NEXT:    add a0, a1, a0
; NO-ZBA-NEXT:    sd a5, 40(a0)
; NO-ZBA-NEXT:    sd a5, 48(a0)
; NO-ZBA-NEXT:    sd a4, 280(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_inSelect:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a4, a1, 5
; ZBA-NEXT:    mv a5, a4
; ZBA-NEXT:    bgtz a3, .LBB5_2
; ZBA-NEXT:  # %bb.1: # %entry
; ZBA-NEXT:    mv a5, a2
; ZBA-NEXT:  .LBB5_2: # %entry
; ZBA-NEXT:    sh3add a0, a1, a0
; ZBA-NEXT:    sd a5, 40(a0)
; ZBA-NEXT:    sd a5, 48(a0)
; ZBA-NEXT:    sd a4, 280(a0)
; ZBA-NEXT:    ret
entry:
  %add = add nsw i64 %a, 5
  %cmp = icmp sgt i64 %x, 0
  %spec.select = select i1 %cmp, i64 %add, i64 %b
  %0 = getelementptr inbounds i64, ptr %array1, i64 %add
  store i64 %spec.select, ptr %0
  %add3 = add nsw i64 %a, 6
  %arrayidx4 = getelementptr inbounds i64, ptr %array1, i64 %add3
  store i64 %spec.select, ptr %arrayidx4
  %add5 = add nsw i64 %a, 35
  %arrayidx6 = getelementptr inbounds i64, ptr %array1, i64 %add5
  store i64 %add, ptr %arrayidx6
  ret void
}

define i64 @add_shl_moreOneUse_sh1add(i64 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh1add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 1
; NO-ZBA-NEXT:    ori a0, a0, 2
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh1add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    ret
  %or = or i64 %x, 1
  %mul = shl i64 %or, 1
  %add = add i64 %mul, %or
  ret i64 %add
}

define i64 @add_shl_moreOneUse_sh2add(i64 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh2add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 2
; NO-ZBA-NEXT:    ori a0, a0, 4
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh2add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh2add a0, a0, a0
; ZBA-NEXT:    ret
  %or = or i64 %x, 1
  %mul = shl i64 %or, 2
  %add = add i64 %mul, %or
  ret i64 %add
}

define i64 @add_shl_moreOneUse_sh3add(i64 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh3add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 3
; NO-ZBA-NEXT:    ori a0, a0, 8
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh3add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh3add a0, a0, a0
; ZBA-NEXT:    ret
  %or = or i64 %x, 1
  %mul = shl i64 %or, 3
  %add = add i64 %mul, %or
  ret i64 %add
}

;; Covers a case which previously crashed (pr119527)
define i64 @add_shl_sext(i32 %1) {
; RV64-LABEL: add_shl_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, a0, 3
; RV64-NEXT:    sllw a0, a1, a0
; RV64-NEXT:    ret
  %3 = add i32 %1, 3
  %4 = shl i32 %3, %1
  %5 = sext i32 %4 to i64
  ret i64 %5
}

define i64 @add_shl_moreOneUse_sh4add(i64 %x) {
; RV64-LABEL: add_shl_moreOneUse_sh4add:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a1, a0, 1
; RV64-NEXT:    slli a0, a0, 4
; RV64-NEXT:    ori a0, a0, 16
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    ret
  %or = or i64 %x, 1
  %mul = shl i64 %or, 4
  %add = add i64 %mul, %or
  ret i64 %add
}

define i64 @add_shl_rhs_constant(i64 %x, i64 %y) {
; RV64-LABEL: add_shl_rhs_constant:
; RV64:       # %bb.0:
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    ret
  %a = add i64 %x, 1
  %b = add i64 %y, %a
  %c = shl i64 %b, 3
  %d = add i64 %c, -8
  ret i64 %d
}
