; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh -target-abi=lp64 \
; RUN:   -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

define void @spill_half(ptr) nounwind {
; CHECK-LABEL: spill_half:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    flh fa5, 0(a0)
; CHECK-NEXT:    fsh fa5, 14(sp) # 2-byte Folded Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    flh fa5, 14(sp) # 2-byte Folded Reload
; CHECK-NEXT:    fsh fa5, 0(a0)
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %2 = load volatile half, ptr %0
  call void asm sideeffect "", "~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"()
  store volatile half %2, ptr %0
  ret void
}

define void @spill_float(ptr) nounwind {
; CHECK-LABEL: spill_float:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    flw fa5, 0(a0)
; CHECK-NEXT:    fsw fa5, 12(sp) # 4-byte Folded Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    flw fa5, 12(sp) # 4-byte Folded Reload
; CHECK-NEXT:    fsw fa5, 0(a0)
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %2 = load volatile float, ptr %0
  call void asm sideeffect "", "~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"()
  store volatile float %2, ptr %0
  ret void
}

define void @spill_double(ptr) nounwind {
; CHECK-LABEL: spill_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    fld fa5, 0(a0)
; CHECK-NEXT:    fsd fa5, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    fld fa5, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    fsd fa5, 0(a0)
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %2 = load volatile double, ptr %0
  call void asm sideeffect "", "~{f0_d},~{f1_d},~{f2_d},~{f3_d},~{f4_d},~{f5_d},~{f6_d},~{f7_d},~{f8_d},~{f9_d},~{f10_d},~{f11_d},~{f12_d},~{f13_d},~{f14_d},~{f15_d},~{f16_d},~{f17_d},~{f18_d},~{f19_d},~{f20_d},~{f21_d},~{f22_d},~{f23_d},~{f24_d},~{f25_d},~{f26_d},~{f27_d},~{f28_d},~{f29_d},~{f30_d},~{f31_d}"()
  store volatile double %2, ptr %0
  ret void
}
