; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu -mattr=+sse2,-sse4.1 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse2,-sse4.1 | FileCheck %s --check-prefix=X64

define void @test1(ptr %F, ptr %f) nounwind {
; X86-LABEL: test1:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    addss %xmm0, %xmm0
; X86-NEXT:    movss %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: test1:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    addss %xmm0, %xmm0
; X64-NEXT:    movss %xmm0, (%rsi)
; X64-NEXT:    retq
entry:
  %tmp = load <4 x float>, ptr %F
  %tmp7 = fadd <4 x float> %tmp, %tmp
  %tmp2 = extractelement <4 x float> %tmp7, i32 0
  store float %tmp2, ptr %f
  ret void
}

define float @test2(ptr %F, ptr %f) nounwind {
; X86-LABEL: test2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movaps (%eax), %xmm0
; X86-NEXT:    addps %xmm0, %xmm0
; X86-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X86-NEXT:    movss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movaps (%rdi), %xmm0
; X64-NEXT:    addps %xmm0, %xmm0
; X64-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X64-NEXT:    retq
entry:
  %tmp = load <4 x float>, ptr %F
  %tmp7 = fadd <4 x float> %tmp, %tmp
  %tmp2 = extractelement <4 x float> %tmp7, i32 2
  ret float %tmp2
}

define void @test3(ptr %R, ptr %P1) nounwind {
; X86-LABEL: test3:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movaps (%ecx), %xmm0
; X86-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X86-NEXT:    movss %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: test3:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movaps (%rsi), %xmm0
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    movss %xmm0, (%rdi)
; X64-NEXT:    retq
entry:
  %X = load <4 x float>, ptr %P1
  %tmp = extractelement <4 x float> %X, i32 3
  store float %tmp, ptr %R
  ret void
}

define double @test4(double %A) nounwind {
; X86-LABEL: test4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    calll foo@PLT
; X86-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; X86-NEXT:    addsd {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; X64-LABEL: test4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    pushq %rax
; X64-NEXT:    movsd %xmm0, (%rsp) # 8-byte Spill
; X64-NEXT:    callq foo@PLT
; X64-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1,1]
; X64-NEXT:    addsd (%rsp), %xmm0 # 8-byte Folded Reload
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
entry:
  %tmp1 = call <2 x double> @foo( )
  %tmp2 = extractelement <2 x double> %tmp1, i32 1
  %tmp3 = fadd double %tmp2, %A
  ret double %tmp3
}
declare <2 x double> @foo()

; OSS-Fuzz #15662
; https://bugs.chromium.org/p/oss-fuzz/issues/detail?id=15662
define <4 x i32> @ossfuzz15662(ptr %in) {
; X86-LABEL: ossfuzz15662:
; X86:       # %bb.0:
; X86-NEXT:    xorps %xmm0, %xmm0
; X86-NEXT:    movaps %xmm0, (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: ossfuzz15662:
; X64:       # %bb.0:
; X64-NEXT:    xorps %xmm0, %xmm0
; X64-NEXT:    movaps %xmm0, (%rax)
; X64-NEXT:    retq
   %C10 = icmp ule i1 false, false
   %C3 = icmp ule i1 true, undef
   %B = sdiv i1 %C10, %C3
   %I = insertelement <4 x i32> zeroinitializer, i32 0, i1 %B
   store <4 x i32> %I, ptr undef
   ret <4 x i32> zeroinitializer
}
