; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=CHECK,X86

define <8 x half> @test_int_x86_avx10_vcvt2ps2phx128(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ps2phx128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ps2phx %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf2,0x7d,0x08,0x67,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.128(<4 x float> %A, <4 x float> %B, <8 x half> zeroinitializer, i8 -1)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_avx10_vcvt2ps2phx128_mask(<8 x half> %W, i8 %U, <4 x float> %A, <4 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx128_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x75,0x09,0x67,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx128_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x75,0x09,0x67,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.128(<4 x float> %A, <4 x float> %B, <8 x half> %W, i8 %U)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_avx10_vcvt2ps2phx128_maskz(i8 %U, <4 x float> %A, <4 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx128_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0x89,0x67,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx128_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7d,0x89,0x67,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.128(<4 x float> %A, <4 x float> %B, <8 x half> zeroinitializer, i8 %U)
  ret <8 x half> %ret
}

declare <8 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.128(<4 x float>, <4 x float>, <8 x half>, i8)

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256(<8 x float> %A, <8 x float> %B) {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ps2phx256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ps2phx %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf2,0x7d,0x28,0x67,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> zeroinitializer, i16 -1, i32 4)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256_mask(<16 x half> %W, i16 %U, <8 x float> %A, <8 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx256_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x75,0x29,0x67,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx256_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x75,0x29,0x67,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> %W, i16 %U, i32 4)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256_maskz(<16 x half> %W, i16 %U, <8 x float> %A, <8 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx256_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0xa9,0x67,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx256_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x75,0xa9,0x67,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> zeroinitializer, i16 %U, i32 4)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256_round(<8 x float> %A, <8 x float> %B) {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ps2phx256_round:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ps2phx {rz-sae}, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf2,0x79,0x78,0x67,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> zeroinitializer, i16 -1, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256_round_mask(<16 x half> %W, i16 %U, <8 x float> %A, <8 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx256_round_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx {rz-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x71,0x79,0x67,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx256_round_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx {rz-sae}, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x71,0x79,0x67,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> %W, i16 %U, i32 11)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvt2ps2phx256_round_maskz(i16 %U, <8 x float> %A, <8 x float> %B) {
; X64-LABEL: test_int_x86_avx10_vcvt2ps2phx256_round_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ps2phx {rz-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0xf9,0x67,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ps2phx256_round_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ps2phx {rz-sae}, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x79,0xf9,0x67,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float> %A, <8 x float> %B, <16 x half> zeroinitializer, i16 %U, i32 11)
  ret <16 x half> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vcvt2ps2phx.256(<8 x float>, <8 x float>, <16 x half>, i16, i32)

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2bf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2bf8 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf2,0x7c,0x08,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2bf8128(<16 x i8> %W, <16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x09,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7c,0x89,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7c,0x89,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> zeroinitializer, i8 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2bf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2bf8 %ymm1, %ymm0, %xmm0 # encoding: [0x62,0xf2,0x7c,0x28,0x74,0xc1]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2bf8256(<16 x i8> %W, <32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8 %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x74,0xc2]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8 %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x74,0x29,0x74,0xc2]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8 %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7c,0xa9,0x74,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8 %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7c,0xa9,0x74,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> zeroinitializer, i16 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2bf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2bf8s %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2bf8s128(<16 x i8> %W, <16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> zeroinitializer, i8 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2bf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2bf8s %ymm1, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x28,0x74,0xc1]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2bf8s256(<16 x i8> %W, <32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8s %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x74,0xc2]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2bf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8s %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x74,0xc2]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2bf8s %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x74,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2bf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2bf8s %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x74,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2bf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> zeroinitializer, i16 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2hf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2hf8 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x18,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2hf8128(<16 x i8> %W, <16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x18,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x18,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x18,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x18,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8128(<16 x i8> %A, <8 x half> %B, <16 x i8> zeroinitializer, i8 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2hf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2hf8 %ymm1, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x28,0x18,0xc1]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2hf8256(<16 x i8> %W, <32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8 %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x18,0xc2]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8 %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x18,0xc2]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8 %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x18,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8 %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x18,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8256(<32 x i8> %A, <16 x half> %B, <16 x i8> zeroinitializer, i16 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2hf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2hf8s %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x1b,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2hf8s128(<16 x i8> %W, <16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x1b,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x09,0x1b,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> %W, i8 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B, i8 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x1b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0x89,0x1b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s128(<16 x i8> %A, <8 x half> %B, <16 x i8> zeroinitializer, i8 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtbiasph2hf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtbiasph2hf8s %ymm1, %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x28,0x1b,0xc1]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtbiasph2hf8s256(<16 x i8> %W, <32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8s %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x1b,0xc2]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtbiasph2hf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8s %ymm2, %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x74,0x29,0x1b,0xc2]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> %W, i16 %U)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B, i16 %U) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtbiasph2hf8s %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x1b,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtbiasph2hf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtbiasph2hf8s %ymm1, %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7c,0xa9,0x1b,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtbiasph2hf8s256(<32 x i8> %A, <16 x half> %B, <16 x i8> zeroinitializer, i16 %U)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8128(<8 x half> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2bf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2bf8 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf2,0x7f,0x08,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8128(<8 x half> %A, <8 x half> %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8128_mask(<16 x i8> %C, i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8128_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x77,0x09,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8128_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x77,0x09,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> %C
  ret <16 x i8> %3
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8128_maskz(<16 x i8> %C, i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8128_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8 %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0x89,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8128_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8 %xmm2, %xmm1, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0x89,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %3
}

declare <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8128(<8 x half> %A, <8 x half> %B)

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2bf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2bf8 %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf2,0x7f,0x28,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8256(<16 x half> %A, <16 x half> %B)
  ret <32 x i8> %ret
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8256_mask(<32 x i8> %C, i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8256_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8 %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x77,0x29,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8256_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8 %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf2,0x77,0x29,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> %C
  ret <32 x i8> %3
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8256_maskz(<32 x i8> %C, i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8256_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8 %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0xa9,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8256_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8 %ymm2, %ymm1, %ymm0 {%k1} {z} # encoding: [0x62,0xf2,0x77,0xa9,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %3
}

declare <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8256(<16 x half> %A, <16 x half> %B)

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8s128(<8 x half> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2bf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2bf8s %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7f,0x08,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8s128(<8 x half> %A, <8 x half> %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8s128_mask(<16 x i8> %C, i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8s128_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8s128_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8s128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> %C
  ret <16 x i8> %3
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2bf8s128_maskz(i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8s128_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8s128_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8s128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %3
}

declare <16 x i8> @llvm.x86.avx10.vcvt2ph2bf8s128(<8 x half> %A, <8 x half> %B)

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8s256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2bf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2bf8s %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7f,0x28,0x74,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8s256(<16 x half> %A, <16 x half> %B)
  ret <32 x i8> %ret
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8s256_mask(<32 x i8> %C, i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8s256_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8s %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x74,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8s256_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8s %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x74,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8s256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> %C
  ret <32 x i8> %3
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2bf8s256_maskz(i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2bf8s256_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2bf8s %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2bf8s256_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2bf8s %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8s256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %3
}

declare <32 x i8> @llvm.x86.avx10.vcvt2ph2bf8s256(<16 x half> %A, <16 x half> %B)

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8128(<8 x half> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2hf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2hf8 %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7f,0x08,0x18,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8128(<8 x half> %A, <8 x half> %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8128_mask(<16 x i8> %C, i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8128_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x18,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8128_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8 %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x18,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> %C
  ret <16 x i8> %3
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8128_maskz(i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8128_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x18,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8128_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8 %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x18,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %3
}

declare <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8128(<8 x half> %A, <8 x half> %B)

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2hf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2hf8 %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7f,0x28,0x18,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8256(<16 x half> %A, <16 x half> %B)
  ret <32 x i8> %ret
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8256_mask(<32 x i8> %C, i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8256_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8 %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x18,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8256_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8 %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x18,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> %C
  ret <32 x i8> %3
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8256_maskz(i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8256_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x18,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8256_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8 %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x18,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %3
}

declare <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8256(<16 x half> %A, <16 x half> %B)

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8s128(<8 x half> %A, <8 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2hf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2hf8s %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7f,0x08,0x1b,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8s128(<8 x half> %A, <8 x half> %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8s128_mask(<16 x i8> %C, i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8s128_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x1b,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8s128_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8s %xmm2, %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x77,0x09,0x1b,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8s128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> %C
  ret <16 x i8> %3
}

define <16 x i8> @test_int_x86_avx10_vcvt2ph2hf8s128_maskz(i16 %U, <8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8s128_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x1b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8s128_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8s %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x1b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8s128(<8 x half> %A, <8 x half> %B)
  %2 = bitcast i16 %U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %3
}

declare <16 x i8> @llvm.x86.avx10.vcvt2ph2hf8s128(<8 x half> %A, <8 x half> %B)

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8s256(<16 x half> %A, <16 x half> %B) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvt2ph2hf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvt2ph2hf8s %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf5,0x7f,0x28,0x1b,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8s256(<16 x half> %A, <16 x half> %B)
  ret <32 x i8> %ret
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8s256_mask(<32 x i8> %C, i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8s256_mask:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8s %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x1b,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8s256_mask:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8s %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf5,0x77,0x29,0x1b,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8s256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> %C
  ret <32 x i8> %3
}

define <32 x i8> @test_int_x86_avx10_vcvt2ph2hf8s256_maskz(i32 %U, <16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vcvt2ph2hf8s256_maskz:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvt2ph2hf8s %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x1b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vcvt2ph2hf8s256_maskz:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvt2ph2hf8s %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x1b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %1 = call <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8s256(<16 x half> %A, <16 x half> %B)
  %2 = bitcast i32 %U to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %3
}

declare <32 x i8> @llvm.x86.avx10.vcvt2ph2hf8s256(<16 x half> %A, <16 x half> %B)

define <8 x half> @test_int_x86_avx10_vcvthf82ph128(<16 x i8> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvthf82ph128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvthf82ph %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7f,0x08,0x1e,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvthf82ph128(<16 x i8> %A, <8 x half> undef, i8 -1)
  ret <8 x half> %ret
}

define <8 x half> @test_int_x86_avx10_mask_vcvthf82ph128(<16 x i8> %A, <8 x half> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvthf82ph128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvthf82ph %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7f,0x09,0x1e,0xc8]
; X64-NEXT:    vmovdqa %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvthf82ph128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvthf82ph %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7f,0x09,0x1e,0xc8]
; X86-NEXT:    vmovdqa %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvthf82ph128(<16 x i8> %A, <8 x half> %B, i8 %C)
  ret <8 x half> %ret
}

declare <8 x half> @llvm.x86.avx10.mask.vcvthf82ph128(<16 x i8> %A, <8 x half> %B, i8 %C)

define <8 x half> @test_int_x86_avx10_maskz_vcvthf82ph128(<16 x i8> %A, i8 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvthf82ph128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvthf82ph %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x1e,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvthf82ph128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvthf82ph %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x1e,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vcvthf82ph128(<16 x i8> %A, <8 x half> zeroinitializer, i8 %B)
  ret <8 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vcvthf82ph256(<16 x i8> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvthf82ph256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvthf82ph %xmm0, %ymm0 # encoding: [0x62,0xf5,0x7f,0x28,0x1e,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvthf82ph256(<16 x i8> %A, <16 x half> undef, i16 -1)
  ret <16 x half> %ret
}

define <16 x half> @test_int_x86_avx10_mask_vcvthf82ph256(<16 x i8> %A, <16 x half> %B, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvthf82ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvthf82ph %xmm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7f,0x29,0x1e,0xc8]
; X64-NEXT:    vmovdqa %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvthf82ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvthf82ph %xmm0, %ymm1 {%k1} # encoding: [0x62,0xf5,0x7f,0x29,0x1e,0xc8]
; X86-NEXT:    vmovdqa %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvthf82ph256(<16 x i8> %A, <16 x half> %B, i16 %C)
  ret <16 x half> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vcvthf82ph256(<16 x i8> %A, <16 x half> %B, i16 %C)

define <16 x half> @test_int_x86_avx10_maskz_vcvthf82ph256(<16 x i8> %A, i16 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvthf82ph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvthf82ph %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x1e,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvthf82ph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvthf82ph %xmm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x1e,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vcvthf82ph256(<16 x i8> %A, <16 x half> zeroinitializer, i16 %B)
  ret <16 x half> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2bf8128(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2bf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2bf8 %xmm0, %xmm0 # encoding: [0x62,0xf2,0x7e,0x08,0x74,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8128(<8 x half> %A, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2bf8128(<16 x i8> %B, <8 x half> %A, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2bf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8 %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x7e,0x09,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2bf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8 %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x7e,0x09,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8128(<8 x half> %A, <16 x i8> %B, i8 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8128(<8 x half> %A, <16 x i8> %B, i8 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2bf8128(<8 x half> %A, i8 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7e,0x89,0x74,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7e,0x89,0x74,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8128(<8 x half> %A, <16 x i8> zeroinitializer, i8 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2bf8256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2bf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2bf8 %ymm0, %xmm0 # encoding: [0x62,0xf2,0x7e,0x28,0x74,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8256(<16 x half> %A, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2bf8256(<16 x i8> %B, <16 x half> %A, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2bf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8 %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x7e,0x29,0x74,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2bf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8 %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf2,0x7e,0x29,0x74,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8256(<16 x half> %A, <16 x i8> %B, i16 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8256(<16 x half> %A, <16 x i8> %B, i16 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2bf8256(<16 x half> %A, i16 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8 %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7e,0xa9,0x74,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8 %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf2,0x7e,0xa9,0x74,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8256(<16 x half> %A, <16 x i8> zeroinitializer, i16 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2bf8s128(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2bf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2bf8s %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x74,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s128(<8 x half> %A, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2bf8s128(<16 x i8> %B, <8 x half> %A, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2bf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8s %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x74,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2bf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8s %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x74,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s128(<8 x half> %A, <16 x i8> %B, i8 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s128(<8 x half> %A, <16 x i8> %B, i8 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2bf8s128(<8 x half> %A, i8 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8s %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x74,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8s %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x74,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s128(<8 x half> %A, <16 x i8> zeroinitializer, i8 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2bf8s256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2bf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2bf8s %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x28,0x74,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s256(<16 x half> %A, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2bf8s256(<16 x i8> %B, <16 x half> %A, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2bf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8s %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x74,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2bf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8s %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x74,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s256(<16 x half> %A, <16 x i8> %B, i16 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s256(<16 x half> %A, <16 x i8> %B, i16 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2bf8s256(<16 x half> %A, i16 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2bf8s %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x74,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2bf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2bf8s %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x74,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2bf8s256(<16 x half> %A, <16 x i8> zeroinitializer, i16 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2hf8128(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2hf8128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2hf8 %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x18,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8128(<8 x half> %A, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2hf8128(<16 x i8> %B, <8 x half> %A, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2hf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8 %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x18,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2hf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8 %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x18,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8128(<8 x half> %A, <16 x i8> %B, i8 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8128(<8 x half> %A, <16 x i8> %B, i8 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2hf8128(<8 x half> %A, i8 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x18,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8 %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x18,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8128(<8 x half> %A, <16 x i8> zeroinitializer, i8 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2hf8256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2hf8256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2hf8 %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x28,0x18,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8256(<16 x half> %A, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2hf8256(<16 x i8> %B, <16 x half> %A, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2hf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8 %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x18,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2hf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8 %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x18,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8256(<16 x half> %A, <16 x i8> %B, i16 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8256(<16 x half> %A, <16 x i8> %B, i16 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2hf8256(<16 x half> %A, i16 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8 %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x18,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8 %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x18,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8256(<16 x half> %A, <16 x i8> zeroinitializer, i16 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2hf8s128(<8 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2hf8s128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2hf8s %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x1b,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s128(<8 x half> %A, <16 x i8> undef, i8 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2hf8s128(<16 x i8> %B, <8 x half> %A, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2hf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8s %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x1b,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2hf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8s %xmm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x1b,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s128(<8 x half> %A, <16 x i8> %B, i8 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s128(<8 x half> %A, <16 x i8> %B, i8 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2hf8s128(<8 x half> %A, i8 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8s128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8s %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x1b,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8s128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8s %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x1b,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s128(<8 x half> %A, <16 x i8> zeroinitializer, i8 %B)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_vcvtph2hf8s256(<16 x half> %A) nounwind {
; CHECK-LABEL: test_int_x86_avx10_vcvtph2hf8s256:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2hf8s %ymm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x28,0x1b,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s256(<16 x half> %A, <16 x i8> undef, i16 -1)
  ret <16 x i8> %ret
}

define <16 x i8> @test_int_x86_avx10_mask_vcvtph2hf8s256(<16 x i8> %B, <16 x half> %A, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vcvtph2hf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8s %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x1b,0xc1]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vcvtph2hf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8s %ymm1, %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x1b,0xc1]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s256(<16 x half> %A, <16 x i8> %B, i16 %C)
  ret <16 x i8> %ret
}

declare <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s256(<16 x half> %A, <16 x i8> %B, i16 %C)

define <16 x i8> @test_int_x86_avx10_maskz_vcvtph2hf8s256(<16 x half> %A, i16 %B) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8s256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vcvtph2hf8s %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x1b,0xc0]
; X64-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vcvtph2hf8s256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vcvtph2hf8s %ymm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x1b,0xc0]
; X86-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x i8> @llvm.x86.avx10.mask.vcvtph2hf8s256(<16 x half> %A, <16 x i8> zeroinitializer, i16 %B)
  ret <16 x i8> %ret
}
