; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=hexagon < %s | FileCheck %s

define i16 @popcount_i16(i16 %a0) #0 {
; CHECK-LABEL: popcount_i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = #0
; CHECK-NEXT:     r0 = zxth(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = popcount(r1:0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i16 @llvm.ctpop.i16(i16 %a0) #1
  ret i16 %v0
}

define i32 @popcount_i32(i32 %a0) #0 {
; CHECK-LABEL: popcount_i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = #0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = popcount(r1:0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i32 @llvm.ctpop.i32(i32 %a0) #1
  ret i32 %v0
}

define i64 @popcount_i64(i64 %a0) #0 {
; CHECK-LABEL: popcount_i64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = popcount(r1:0)
; CHECK-NEXT:     r1 = #0
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i64 @llvm.ctpop.i64(i64 %a0) #1
  ret i64 %v0
}

define i16 @ctlz_i16(i16 %a0) #0 {
; CHECK-LABEL: ctlz_i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = aslh(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = cl0(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i16 @llvm.ctlz.i16(i16 %a0, i1 true) #1
  ret i16 %v0
}

define i32 @ctlz_i32(i32 %a0) #0 {
; CHECK-LABEL: ctlz_i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = cl0(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i32 @llvm.ctlz.i32(i32 %a0, i1 true) #1
  ret i32 %v0
}

define i64 @ctlz_i64(i64 %a0) #0 {
; CHECK-LABEL: ctlz_i64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = cl0(r1:0)
; CHECK-NEXT:     r1 = #0
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i64 @llvm.ctlz.i64(i64 %a0, i1 true) #1
  ret i64 %v0
}

define i16 @cttz_i16(i16 %a0) #0 {
; CHECK-LABEL: cttz_i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = ct0(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i16 @llvm.cttz.i16(i16 %a0, i1 true) #1
  ret i16 %v0
}

define i32 @cttz_i32(i32 %a0) #0 {
; CHECK-LABEL: cttz_i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = ct0(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i32 @llvm.cttz.i32(i32 %a0, i1 true) #1
  ret i32 %v0
}

define i64 @cttz_i64(i64 %a0) #0 {
; CHECK-LABEL: cttz_i64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = ct0(r1:0)
; CHECK-NEXT:     r1 = #0
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i64 @llvm.cttz.i64(i64 %a0, i1 true) #1
  ret i64 %v0
}

define i16 @bswap_i16(i16 %a0) #0 {
; CHECK-LABEL: bswap_i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = lsr(r0,#16)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i16 @llvm.bswap.i16(i16 %a0) #1
  ret i16 %v0
}

define i32 @bswap_i32(i32 %a0) #0 {
; CHECK-LABEL: bswap_i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i32 @llvm.bswap.i32(i32 %a0) #1
  ret i32 %v0
}

define i64 @bswap_i64(i64 %a0) #0 {
; CHECK-LABEL: bswap_i64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = swiz(r1)
; CHECK-NEXT:     r3 = swiz(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r3,r2)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i64 @llvm.bswap.i64(i64 %a0) #1
  ret i64 %v0
}

define <2 x i16> @bswap_v2i16(<2 x i16> %a0) #0 {
; CHECK-LABEL: bswap_v2i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = combine(r0.l,r0.h)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <2 x i16> @llvm.bswap.v2i16(<2 x i16> %a0)
  ret <2 x i16> %v0
}

define <4 x i16> @bswap_v4i16(<4 x i16> %a0) #0 {
; CHECK-LABEL: bswap_v4i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r3:2 = vlsrh(r1:0,#8)
; CHECK-NEXT:     r5:4 = vaslh(r1:0,#8)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = or(r3:2,r5:4)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <4 x i16> @llvm.bswap.v4i16(<4 x i16> %a0)
  ret <4 x i16> %v0
}

define <2 x i32> @bswap_v2i32(<2 x i32> %a0) #0 {
; CHECK-LABEL: bswap_v2i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r0)
; CHECK-NEXT:     r1 = swiz(r1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <2 x i32> @llvm.bswap.v2i32(<2 x i32> %a0)
  ret <2 x i32> %v0
}

define i16 @brev_i16(i16 %a0) #0 {
; CHECK-LABEL: brev_i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = brev(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = lsr(r0,#16)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i16 @llvm.bitreverse.i16(i16 %a0) #1
  ret i16 %v0
}

define i32 @brev_i32(i32 %a0) #0 {
; CHECK-LABEL: brev_i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = brev(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i32 @llvm.bitreverse.i32(i32 %a0) #1
  ret i32 %v0
}

define i64 @brev_i64(i64 %a0) #0 {
; CHECK-LABEL: brev_i64:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = brev(r1:0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call i64 @llvm.bitreverse.i64(i64 %a0) #1
  ret i64 %v0
}

define <4 x i8> @brev_v4i8(<4 x i8> %a0) #0 {
; CHECK-LABEL: brev_v4i8:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = brev(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r0)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <4 x i8> @llvm.bitreverse.v4i8(<4 x i8> %a0)
  ret <4 x i8> %v0
}

define <8 x i8> @brev_v8i8(<8 x i8> %a0) #0 {
; CHECK-LABEL: brev_v8i8:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r3:2 = brev(r1:0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = swiz(r3)
; CHECK-NEXT:     r1 = swiz(r2)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %a0)
  ret <8 x i8> %v0
}

define <2 x i16> @brev_v2i16(<2 x i16> %a0) #0 {
; CHECK-LABEL: brev_v2i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = brev(r0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = combine(r0.l,r0.h)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a0)
  ret <2 x i16> %v0
}

define <4 x i16> @brev_v4i16(<4 x i16> %a0) #0 {
; CHECK-LABEL: brev_v4i16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r3:2 = brev(r1:0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = combine(r3.l,r3.h)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:     r1 = combine(r2.l,r2.h)
; CHECK-NEXT:    }
  %v0 = tail call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %a0)
  ret <4 x i16> %v0
}

define <2 x i32> @brev_v2i32(<2 x i32> %a0) #0 {
; CHECK-LABEL: brev_v2i32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     r3:2 = brev(r1:0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = combine(r2,r3)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = tail call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a0)
  ret <2 x i32> %v0
}


declare i16 @llvm.ctpop.i16(i16) #1
declare i32 @llvm.ctpop.i32(i32) #1
declare i64 @llvm.ctpop.i64(i64) #1

declare i16 @llvm.ctlz.i16(i16, i1) #1
declare i32 @llvm.ctlz.i32(i32, i1) #1
declare i64 @llvm.ctlz.i64(i64, i1) #1

declare i16 @llvm.cttz.i16(i16, i1) #1
declare i32 @llvm.cttz.i32(i32, i1) #1
declare i64 @llvm.cttz.i64(i64, i1) #1

declare i16 @llvm.bswap.i16(i16) #1
declare i32 @llvm.bswap.i32(i32) #1
declare i64 @llvm.bswap.i64(i64) #1

declare <2 x i16> @llvm.bswap.v2i16(<2 x i16>) #1
declare <4 x i16> @llvm.bswap.v4i16(<4 x i16>) #1
declare <2 x i32> @llvm.bswap.v2i32(<2 x i32>) #1

declare i16 @llvm.bitreverse.i16(i16) #1
declare i32 @llvm.bitreverse.i32(i32) #1
declare i64 @llvm.bitreverse.i64(i64) #1

declare <4 x i8> @llvm.bitreverse.v4i8(<4 x i8>) #1
declare <8 x i8> @llvm.bitreverse.v8i8(<8 x i8>) #1

declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>) #1
declare <4 x i16> @llvm.bitreverse.v4i16(<4 x i16>) #1
declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>) #1


attributes #0 = { "target-features"="+v68,-long-calls" }
attributes #1 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }

