; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=kaveri -mattr=-flat-for-global,+max-private-element-size-16 < %s | FileCheck -enable-var-scope -check-prefixes=GCN,SI %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -mattr=-flat-for-global -mattr=+max-private-element-size-16 < %s | FileCheck -enable-var-scope -check-prefixes=GCN,VI %s

; FIXME: Broken on evergreen
; FIXME: For some reason the 8 and 16 vectors are being stored as
; individual elements instead of 128-bit stores.

define amdgpu_kernel void @insertelement_v2f32_0(ptr addrspace(1) %out, <2 x float> %a) nounwind {
; SI-LABEL: insertelement_v2f32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2f32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 0
  store <2 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2f32_1(ptr addrspace(1) %out, <2 x float> %a) nounwind {
; SI-LABEL: insertelement_v2f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 1
  store <2 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2i32_0(ptr addrspace(1) %out, <2 x i32> %a) nounwind {
; SI-LABEL: insertelement_v2i32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, 0x3e7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2i32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, 0x3e7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 999, i32 0
  store <2 x i32> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v2i32_1(ptr addrspace(1) %out, <2 x i32> %a) nounwind {
; SI-LABEL: insertelement_v2i32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x3e7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v2i32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x3e7
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 999, i32 1
  store <2 x i32> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

; FIXME: Why is the constant moved into the intermediate register and
; not just directly into the vector component?
define amdgpu_kernel void @insertelement_v4f32_0(ptr addrspace(1) %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s0, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 0
  store <4 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_1(ptr addrspace(1) %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s1, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s1, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 1
  store <4 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_2(ptr addrspace(1) %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s2, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s2, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 2
  store <4 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4f32_3(ptr addrspace(1) %out, <4 x float> %a) nounwind {
; SI-LABEL: insertelement_v4f32_3:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s3, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4f32_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s3, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 3
  store <4 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v4i32_0(ptr addrspace(1) %out, <4 x i32> %a) nounwind {
; SI-LABEL: insertelement_v4i32_0:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_movk_i32 s0, 0x3e7
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v4i32_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_movk_i32 s0, 0x3e7
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i32> %a, i32 999, i32 0
  store <4 x i32> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_1(ptr addrspace(1) %out, <3 x float> %a) nounwind {
; SI-LABEL: insertelement_v3f32_1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v3f32_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v1, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 1
  store <3 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_2(ptr addrspace(1) %out, <3 x float> %a) nounwind {
; SI-LABEL: insertelement_v3f32_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v2, 0x40a00000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: insertelement_v3f32_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    v_mov_b32_e32 v2, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 2
  store <3 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @insertelement_v3f32_3(ptr addrspace(1) %out, <3 x float> %a) nounwind {
; GCN-LABEL: insertelement_v3f32_3:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 3
  store <3 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define <4 x float> @insertelement_to_sgpr() nounwind {
; GCN-LABEL: insertelement_to_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, 0
; GCN-NEXT:    image_gather4_lz v[0:3], v[0:1], s[4:11], s[4:7] dmask:0x1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <4 x i32>, ptr addrspace(4) undef
  %tmp1 = insertelement <4 x i32> %tmp, i32 0, i32 0
  %tmp2 = call <4 x float> @llvm.amdgcn.image.gather4.lz.2d.v4f32.f32(i32 1, float undef, float undef, <8 x i32> undef, <4 x i32> %tmp1, i1 0, i32 0, i32 0)
  ret <4 x float> %tmp2
}

define <9 x float> @insertelement_to_v9f32_undef() nounwind {
; GCN-LABEL: insertelement_to_v9f32_undef:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx8 s[4:11], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; GCN-NEXT:    v_mov_b32_e32 v2, 0xc0a00000
; GCN-NEXT:    v_mov_b32_e32 v7, 0x41880000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dword s4, s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s8
; GCN-NEXT:    v_mov_b32_e32 v5, s9
; GCN-NEXT:    v_mov_b32_e32 v6, s10
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, s4
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <9 x float>, ptr addrspace(4) undef
  %tmp1 = insertelement <9 x float> %tmp, float 5.000, i32 0
  %tmp2 = insertelement <9 x float> %tmp1, float -5.000, i32 2
  %tmp3 = insertelement <9 x float> %tmp2, float 17.000, i32 7
  ret <9 x float> %tmp3
}

define <10 x float> @insertelement_to_v10f32_undef() nounwind {
; GCN-LABEL: insertelement_to_v10f32_undef:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx8 s[4:11], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, 2.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    v_mov_b32_e32 v2, s6
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s8
; GCN-NEXT:    v_mov_b32_e32 v5, s9
; GCN-NEXT:    v_mov_b32_e32 v6, s10
; GCN-NEXT:    v_mov_b32_e32 v7, s11
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, s12
; GCN-NEXT:    v_mov_b32_e32 v9, s13
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <10 x float>, ptr addrspace(4) undef
  %tmp1 = insertelement <10 x float> %tmp, float 2.0, i32 0
  ret <10 x float> %tmp1
}

define <11 x float> @insertelement_to_v11f32_undef() nounwind {
; GCN-LABEL: insertelement_to_v11f32_undef:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx8 s[4:11], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    v_mov_b32_e32 v2, s6
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s8
; GCN-NEXT:    v_mov_b32_e32 v5, s9
; GCN-NEXT:    v_mov_b32_e32 v6, s10
; GCN-NEXT:    v_mov_b32_e32 v7, s11
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, s12
; GCN-NEXT:    v_mov_b32_e32 v9, s13
; GCN-NEXT:    v_mov_b32_e32 v10, s14
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <11 x float>, ptr addrspace(4) undef
  %tmp1 = insertelement <11 x float> %tmp, float 1.000, i32 0
  ret <11 x float> %tmp1
}

define <12 x float> @insertelement_to_v12f32_undef() nounwind {
; GCN-LABEL: insertelement_to_v12f32_undef:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx8 s[4:11], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dwordx4 s[12:15], s[4:5], 0x0
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    v_mov_b32_e32 v2, s6
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s8
; GCN-NEXT:    v_mov_b32_e32 v5, s9
; GCN-NEXT:    v_mov_b32_e32 v6, s10
; GCN-NEXT:    v_mov_b32_e32 v7, s11
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v8, s12
; GCN-NEXT:    v_mov_b32_e32 v9, s13
; GCN-NEXT:    v_mov_b32_e32 v10, s14
; GCN-NEXT:    v_mov_b32_e32 v11, s15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %tmp = load <12 x float>, ptr addrspace(4) undef
  %tmp1 = insertelement <12 x float> %tmp, float 4.0, i32 0
  ret <12 x float> %tmp1
}

define amdgpu_kernel void @dynamic_insertelement_v2f32(ptr addrspace(1) %out, <2 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x2
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s2, 1
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s2, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v2, s0
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s2, 1
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s2, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x float> %a, float 5.000000e+00, i32 %b
  store <2 x float> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3f32(ptr addrspace(1) %out, <3 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x4
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s10, 2
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_cmp_lg_u32 s10, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s10, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v3, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x10
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s10, 2
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s6
; VI-NEXT:    s_cmp_lg_u32 s10, 1
; VI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s10, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x float> %a, float 5.000000e+00, i32 %b
  store <3 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4f32(ptr addrspace(1) %out, <4 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x4
; SI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s10, 3
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    s_cmp_lg_u32 s10, 2
; SI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s6
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s10, 1
; SI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_lg_u32 s10, 0
; SI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x10
; VI-NEXT:    v_mov_b32_e32 v0, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s10, 3
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    s_cmp_lg_u32 s10, 2
; VI-NEXT:    v_cndmask_b32_e32 v3, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s6
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s10, 1
; VI-NEXT:    v_cndmask_b32_e32 v2, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_lg_u32 s10, 0
; VI-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x float> %a, float 5.000000e+00, i32 %b
  store <4 x float> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8f32(ptr addrspace(1) %out, <8 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[12:13], s[8:9], 0x0
; SI-NEXT:    s_load_dword s8, s[8:9], 0x10
; SI-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; SI-NEXT:    s_mov_b32 s15, 0x100f000
; SI-NEXT:    s_mov_b32 s14, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    v_mov_b32_e32 v5, s5
; SI-NEXT:    v_mov_b32_e32 v6, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    s_mov_b32 m0, s8
; SI-NEXT:    v_movreld_b32_e32 v0, v8
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[12:15], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dword s4, s[8:9], 0x40
; VI-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, v8
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x float> %a, float 5.000000e+00, i32 %b
  store <8 x float> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v9f32(ptr addrspace(1) %out, <9 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v9f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dword s4, s[8:9], 0x18
; SI-NEXT:    s_load_dword s5, s[8:9], 0x20
; SI-NEXT:    v_mov_b32_e32 v9, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_mov_b32 m0, s5
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v0, v9
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v9f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dword s4, s[8:9], 0x60
; VI-NEXT:    s_load_dword s5, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_mov_b32_e32 v9, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    s_mov_b32 m0, s5
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, v9
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <9 x float> %a, float 5.000000e+00, i32 %b
  store <9 x float> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v10f32(ptr addrspace(1) %out, <10 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v10f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x18
; SI-NEXT:    s_load_dword s6, s[8:9], 0x20
; SI-NEXT:    v_mov_b32_e32 v10, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    s_mov_b32 m0, s6
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v0, v10
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v10f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x60
; VI-NEXT:    s_load_dword s6, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_mov_b32_e32 v10, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    s_mov_b32 m0, s6
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, v10
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <10 x float> %a, float 5.000000e+00, i32 %b
  store <10 x float> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v11f32(ptr addrspace(1) %out, <11 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v11f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x18
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s7, s[8:9], 0x20
; SI-NEXT:    v_mov_b32_e32 v11, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    v_mov_b32_e32 v10, s6
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 m0, s7
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v0, v11
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx3 v[8:10], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v11f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x60
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s7, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_mov_b32_e32 v11, 0x40a00000
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    v_mov_b32_e32 v10, s6
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 m0, s7
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, v11
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx3 v[8:10], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <11 x float> %a, float 5.000000e+00, i32 %b
  store <11 x float> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v12f32(ptr addrspace(1) %out, <12 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v12f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x18
; SI-NEXT:    s_load_dword s8, s[8:9], 0x20
; SI-NEXT:    v_mov_b32_e32 v12, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    v_mov_b32_e32 v10, s6
; SI-NEXT:    v_mov_b32_e32 v11, s7
; SI-NEXT:    s_mov_b32 m0, s8
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v0, v12
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v12f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x60
; VI-NEXT:    s_load_dword s8, s[8:9], 0x80
; VI-NEXT:    v_mov_b32_e32 v12, 0x40a00000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    v_mov_b32_e32 v10, s6
; VI-NEXT:    v_mov_b32_e32 v11, s7
; VI-NEXT:    s_mov_b32 m0, s8
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, v12
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <12 x float> %a, float 5.000000e+00, i32 %b
  store <12 x float> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16f32(ptr addrspace(1) %out, <16 x float> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x10
; SI-NEXT:    s_load_dword s4, s[8:9], 0x20
; SI-NEXT:    v_mov_b32_e32 v16, 0x40a00000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s21
; SI-NEXT:    v_mov_b32_e32 v10, s22
; SI-NEXT:    v_mov_b32_e32 v11, s23
; SI-NEXT:    v_mov_b32_e32 v12, s24
; SI-NEXT:    v_mov_b32_e32 v13, s25
; SI-NEXT:    v_mov_b32_e32 v14, s26
; SI-NEXT:    v_mov_b32_e32 v15, s27
; SI-NEXT:    s_mov_b32 m0, s4
; SI-NEXT:    v_movreld_b32_e32 v0, v16
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x40
; VI-NEXT:    s_load_dword s4, s[8:9], 0x80
; VI-NEXT:    v_mov_b32_e32 v16, 0x40a00000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s20
; VI-NEXT:    v_mov_b32_e32 v9, s21
; VI-NEXT:    v_mov_b32_e32 v10, s22
; VI-NEXT:    v_mov_b32_e32 v11, s23
; VI-NEXT:    v_mov_b32_e32 v12, s24
; VI-NEXT:    v_mov_b32_e32 v13, s25
; VI-NEXT:    v_mov_b32_e32 v14, s26
; VI-NEXT:    v_mov_b32_e32 v15, s27
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, v16
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x float> %a, float 5.000000e+00, i32 %b
  store <16 x float> %vecins, ptr addrspace(1) %out, align 64
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i32(ptr addrspace(1) %out, <2 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x2
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s2, 1
; SI-NEXT:    s_cselect_b32 s1, s1, 5
; SI-NEXT:    s_cmp_lg_u32 s2, 0
; SI-NEXT:    s_cselect_b32 s0, s0, 5
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s2, 1
; VI-NEXT:    s_cselect_b32 s1, s1, 5
; VI-NEXT:    s_cmp_lg_u32 s2, 0
; VI-NEXT:    s_cselect_b32 s0, s0, 5
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i32> %a, i32 5, i32 %b
  store <2 x i32> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i32(ptr addrspace(1) %out, <3 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s10, 2
; SI-NEXT:    s_cselect_b32 s2, s2, 5
; SI-NEXT:    s_cmp_lg_u32 s10, 1
; SI-NEXT:    s_cselect_b32 s1, s1, 5
; SI-NEXT:    s_cmp_lg_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s0, s0, 5
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s10, 2
; VI-NEXT:    s_cselect_b32 s2, s2, 5
; VI-NEXT:    s_cmp_lg_u32 s10, 1
; VI-NEXT:    s_cselect_b32 s1, s1, 5
; VI-NEXT:    s_cmp_lg_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s0, s0, 5
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i32> %a, i32 5, i32 %b
  store <3 x i32> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4i32(ptr addrspace(1) %out, <4 x i32> %a, i32 %b, [8 x i32], i32 %val) nounwind {
; SI-LABEL: dynamic_insertelement_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dword s11, s[8:9], 0x11
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s10, 3
; SI-NEXT:    s_cselect_b32 s3, s11, s3
; SI-NEXT:    s_cmp_eq_u32 s10, 2
; SI-NEXT:    s_cselect_b32 s2, s11, s2
; SI-NEXT:    s_cmp_eq_u32 s10, 1
; SI-NEXT:    s_cselect_b32 s1, s11, s1
; SI-NEXT:    s_cmp_eq_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s0, s11, s0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dword s11, s[8:9], 0x44
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s10, 3
; VI-NEXT:    s_cselect_b32 s3, s11, s3
; VI-NEXT:    s_cmp_eq_u32 s10, 2
; VI-NEXT:    s_cselect_b32 s2, s11, s2
; VI-NEXT:    s_cmp_eq_u32 s10, 1
; VI-NEXT:    s_cselect_b32 s1, s11, s1
; VI-NEXT:    s_cmp_eq_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s0, s11, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i32> %a, i32 %val, i32 %b
  store <4 x i32> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8i32(ptr addrspace(1) %out, <8 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[12:13], s[8:9], 0x0
; SI-NEXT:    s_load_dword s8, s[8:9], 0x10
; SI-NEXT:    s_mov_b32 s15, 0x100f000
; SI-NEXT:    s_mov_b32 s14, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    v_mov_b32_e32 v5, s5
; SI-NEXT:    v_mov_b32_e32 v6, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    s_mov_b32 m0, s8
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[12:15], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[12:15], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dword s4, s[8:9], 0x40
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x i32> %a, i32 5, i32 %b
  store <8 x i32> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v9i32(ptr addrspace(1) %out, <9 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v9i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dword s4, s[8:9], 0x18
; SI-NEXT:    s_load_dword s5, s[8:9], 0x20
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_mov_b32 m0, s5
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v9i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dword s4, s[8:9], 0x60
; VI-NEXT:    s_load_dword s5, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    s_mov_b32 m0, s5
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dword v8, off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <9 x i32> %a, i32 5, i32 %b
  store <9 x i32> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v10i32(ptr addrspace(1) %out, <10 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v10i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x18
; SI-NEXT:    s_load_dword s6, s[8:9], 0x20
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    s_mov_b32 m0, s6
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v10i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x60
; VI-NEXT:    s_load_dword s6, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    s_mov_b32 m0, s6
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <10 x i32> %a, i32 5, i32 %b
  store <10 x i32> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v11i32(ptr addrspace(1) %out, <11 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v11i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x18
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s7, s[8:9], 0x20
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    v_mov_b32_e32 v10, s6
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 m0, s7
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx3 v[8:10], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v11i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x60
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s7, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    v_mov_b32_e32 v10, s6
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 m0, s7
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx3 v[8:10], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <11 x i32> %a, i32 5, i32 %b
  store <11 x i32> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v12i32(ptr addrspace(1) %out, <12 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v12i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x18
; SI-NEXT:    s_load_dword s8, s[8:9], 0x20
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    v_mov_b32_e32 v9, s5
; SI-NEXT:    v_mov_b32_e32 v10, s6
; SI-NEXT:    v_mov_b32_e32 v11, s7
; SI-NEXT:    s_mov_b32 m0, s8
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v12i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx8 s[12:19], s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x60
; VI-NEXT:    s_load_dword s8, s[8:9], 0x80
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_mov_b32_e32 v9, s5
; VI-NEXT:    v_mov_b32_e32 v10, s6
; VI-NEXT:    v_mov_b32_e32 v11, s7
; VI-NEXT:    s_mov_b32 m0, s8
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
  %vecins = insertelement <12 x i32> %a, i32 5, i32 %b
  store <12 x i32> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16i32(ptr addrspace(1) %out, <16 x i32> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x10
; SI-NEXT:    s_load_dword s4, s[8:9], 0x20
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s21
; SI-NEXT:    v_mov_b32_e32 v10, s22
; SI-NEXT:    v_mov_b32_e32 v11, s23
; SI-NEXT:    v_mov_b32_e32 v12, s24
; SI-NEXT:    v_mov_b32_e32 v13, s25
; SI-NEXT:    v_mov_b32_e32 v14, s26
; SI-NEXT:    v_mov_b32_e32 v15, s27
; SI-NEXT:    s_mov_b32 m0, s4
; SI-NEXT:    v_movreld_b32_e32 v0, 5
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x40
; VI-NEXT:    s_load_dword s4, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s20
; VI-NEXT:    v_mov_b32_e32 v9, s21
; VI-NEXT:    v_mov_b32_e32 v10, s22
; VI-NEXT:    v_mov_b32_e32 v11, s23
; VI-NEXT:    v_mov_b32_e32 v12, s24
; VI-NEXT:    v_mov_b32_e32 v13, s25
; VI-NEXT:    v_mov_b32_e32 v14, s26
; VI-NEXT:    v_mov_b32_e32 v15, s27
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, 5
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x i32> %a, i32 5, i32 %b
  store <16 x i32> %vecins, ptr addrspace(1) %out, align 64
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i16(ptr addrspace(1) %out, <2 x i16> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_lshl_b32 s0, s3, 4
; SI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_andn2_b32 s1, s2, s0
; SI-NEXT:    s_and_b32 s0, s0, 0x50005
; SI-NEXT:    s_or_b32 s0, s0, s1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_lshl_b32 s0, s3, 4
; VI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_andn2_b32 s1, s2, s0
; VI-NEXT:    s_and_b32 s0, s0, 0x50005
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i16> %a, i16 5, i32 %b
  store <2 x i16> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i16(ptr addrspace(1) %out, <3 x i16> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_load_dword s8, s[8:9], 0x4
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_lshl_b32 s0, s8, 4
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_lshl_b64 s[0:1], 0xffff, s0
; SI-NEXT:    s_and_b32 s9, s1, 0x50005
; SI-NEXT:    s_and_b32 s8, s0, 0x50005
; SI-NEXT:    s_andn2_b64 s[0:1], s[2:3], s[0:1]
; SI-NEXT:    s_or_b64 s[0:1], s[8:9], s[0:1]
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:4
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_load_dword s8, s[8:9], 0x10
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_lshl_b32 s0, s8, 4
; VI-NEXT:    s_mov_b32 s8, 0x50005
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_lshl_b64 s[0:1], 0xffff, s0
; VI-NEXT:    s_mov_b32 s9, s8
; VI-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[0:1]
; VI-NEXT:    s_and_b64 s[0:1], s[0:1], s[8:9]
; VI-NEXT:    s_or_b64 s[0:1], s[0:1], s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i16> %a, i16 5, i32 %b
  store <3 x i16> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i8(ptr addrspace(1) %out, [8 x i32], <2 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[8:9], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dword s5, s[8:9], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 3
; SI-NEXT:    s_lshl_b32 s4, 0xff, s4
; SI-NEXT:    s_andn2_b32 s5, s5, s4
; SI-NEXT:    s_and_b32 s4, s4, 0x505
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[8:9], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dword s5, s[8:9], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s4, 3
; VI-NEXT:    s_lshl_b32 s4, 0xff, s4
; VI-NEXT:    s_and_b32 s6, s4, 0x505
; VI-NEXT:    s_xor_b32 s4, s4, 0xffff
; VI-NEXT:    s_and_b32 s4, s4, s5
; VI-NEXT:    s_or_b32 s4, s6, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i8> %a, i8 5, i32 %b
  store <2 x i8> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

; FIXME: post legalize i16 and i32 shifts aren't merged because of
; isTypeDesirableForOp in SimplifyDemandedBits
define amdgpu_kernel void @dynamic_insertelement_v3i8(ptr addrspace(1) %out, [8 x i32], <3 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[8:9], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dword s5, s[8:9], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 3
; SI-NEXT:    s_lshl_b32 s4, 0xff, s4
; SI-NEXT:    s_andn2_b32 s5, s5, s4
; SI-NEXT:    s_and_b32 s4, s4, 0x5050505
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshr_b32 s5, s4, 16
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    buffer_store_byte v0, off, s[0:3], 0 offset:2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[8:9], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dword s5, s[8:9], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s4, 3
; VI-NEXT:    s_lshl_b32 s4, 0xff, s4
; VI-NEXT:    s_andn2_b32 s5, s5, s4
; VI-NEXT:    s_and_b32 s4, s4, 0x5050505
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_lshr_b32 s5, s4, 16
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    v_mov_b32_e32 v0, s5
; VI-NEXT:    buffer_store_byte v0, off, s[0:3], 0 offset:2
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i8> %a, i8 5, i32 %b
  store <3 x i8> %vecins, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4i8(ptr addrspace(1) %out, [8 x i32], <4 x i8> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[8:9], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dword s5, s[8:9], 0xa
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 3
; SI-NEXT:    s_lshl_b32 s4, 0xff, s4
; SI-NEXT:    s_andn2_b32 s5, s5, s4
; SI-NEXT:    s_and_b32 s4, s4, 0x5050505
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[8:9], 0x4c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dword s5, s[8:9], 0x28
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s4, 3
; VI-NEXT:    s_lshl_b32 s4, 0xff, s4
; VI-NEXT:    s_andn2_b32 s5, s5, s4
; VI-NEXT:    s_and_b32 s4, s4, 0x5050505
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x i8> %a, i8 5, i32 %b
  store <4 x i8> %vecins, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @s_dynamic_insertelement_v8i8(ptr addrspace(1) %out, ptr addrspace(4) %a.ptr, i32 %b) nounwind {
; SI-LABEL: s_dynamic_insertelement_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_load_dword s8, s[8:9], 0x4
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_lshl_b32 s0, s8, 3
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_lshl_b64 s[0:1], 0xff, s0
; SI-NEXT:    s_and_b32 s9, s1, 0x5050505
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[0:1]
; SI-NEXT:    s_and_b32 s8, s0, 0x5050505
; SI-NEXT:    s_or_b64 s[0:1], s[8:9], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_dynamic_insertelement_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_load_dword s8, s[8:9], 0x10
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_lshl_b32 s0, s8, 3
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_lshl_b64 s[0:1], 0xff, s0
; VI-NEXT:    s_and_b32 s9, s1, 0x5050505
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_andn2_b64 s[2:3], s[2:3], s[0:1]
; VI-NEXT:    s_and_b32 s8, s0, 0x5050505
; VI-NEXT:    s_or_b64 s[0:1], s[8:9], s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %a = load <8 x i8>, ptr addrspace(4) %a.ptr, align 4
  %vecins = insertelement <8 x i8> %a, i8 5, i32 %b
  store <8 x i8> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v16i8(ptr addrspace(1) %out, <16 x i8> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v16i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x4
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s8, s7, 24
; SI-NEXT:    s_cmp_lg_u32 s10, 15
; SI-NEXT:    s_cselect_b32 s8, s8, 5
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_lshr_b32 s9, s7, 16
; SI-NEXT:    s_cmp_lg_u32 s10, 14
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_and_b32 s9, s9, 0xff
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshr_b32 s9, s7, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 13
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_lshl_b32 s9, s9, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 12
; SI-NEXT:    s_cselect_b32 s7, s7, 5
; SI-NEXT:    s_and_b32 s7, s7, 0xff
; SI-NEXT:    s_or_b32 s7, s7, s9
; SI-NEXT:    s_and_b32 s7, s7, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_lshr_b32 s8, s6, 24
; SI-NEXT:    s_cmp_lg_u32 s10, 11
; SI-NEXT:    s_cselect_b32 s8, s8, 5
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_lshr_b32 s9, s6, 16
; SI-NEXT:    s_cmp_lg_u32 s10, 10
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_and_b32 s9, s9, 0xff
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshr_b32 s9, s6, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 9
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_lshl_b32 s9, s9, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 8
; SI-NEXT:    s_cselect_b32 s6, s6, 5
; SI-NEXT:    s_and_b32 s6, s6, 0xff
; SI-NEXT:    s_or_b32 s6, s6, s9
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s8
; SI-NEXT:    s_lshr_b32 s8, s5, 24
; SI-NEXT:    s_cmp_lg_u32 s10, 7
; SI-NEXT:    s_cselect_b32 s8, s8, 5
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_lshr_b32 s9, s5, 16
; SI-NEXT:    s_cmp_lg_u32 s10, 6
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_and_b32 s9, s9, 0xff
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshr_b32 s9, s5, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 5
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_lshl_b32 s9, s9, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 4
; SI-NEXT:    s_cselect_b32 s5, s5, 5
; SI-NEXT:    s_and_b32 s5, s5, 0xff
; SI-NEXT:    s_or_b32 s5, s5, s9
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s8
; SI-NEXT:    s_lshr_b32 s8, s4, 24
; SI-NEXT:    s_cmp_lg_u32 s10, 3
; SI-NEXT:    s_cselect_b32 s8, s8, 5
; SI-NEXT:    s_lshl_b32 s8, s8, 24
; SI-NEXT:    s_lshr_b32 s9, s4, 16
; SI-NEXT:    s_cmp_lg_u32 s10, 2
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_and_b32 s9, s9, 0xff
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_lshr_b32 s9, s4, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 1
; SI-NEXT:    s_cselect_b32 s9, s9, 5
; SI-NEXT:    s_lshl_b32 s9, s9, 8
; SI-NEXT:    s_cmp_lg_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s4, s4, 5
; SI-NEXT:    s_and_b32 s4, s4, 0xff
; SI-NEXT:    s_or_b32 s4, s4, s9
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s4, s4, s8
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v16i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x10
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s8, s7, 24
; VI-NEXT:    s_cmp_lg_u32 s10, 15
; VI-NEXT:    s_cselect_b32 s8, s8, 5
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_lshr_b32 s9, s7, 16
; VI-NEXT:    s_cmp_lg_u32 s10, 14
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_and_b32 s9, s9, 0xff
; VI-NEXT:    s_or_b32 s8, s9, s8
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_lshr_b32 s9, s7, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 13
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 12
; VI-NEXT:    s_cselect_b32 s7, s7, 5
; VI-NEXT:    s_and_b32 s7, s7, 0xff
; VI-NEXT:    s_or_b32 s7, s7, s9
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_lshr_b32 s8, s6, 24
; VI-NEXT:    s_cmp_lg_u32 s10, 11
; VI-NEXT:    s_cselect_b32 s8, s8, 5
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_lshr_b32 s9, s6, 16
; VI-NEXT:    s_cmp_lg_u32 s10, 10
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_and_b32 s9, s9, 0xff
; VI-NEXT:    s_or_b32 s8, s9, s8
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_lshr_b32 s9, s6, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 9
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 8
; VI-NEXT:    s_cselect_b32 s6, s6, 5
; VI-NEXT:    s_and_b32 s6, s6, 0xff
; VI-NEXT:    s_or_b32 s6, s6, s9
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_or_b32 s6, s6, s8
; VI-NEXT:    s_lshr_b32 s8, s5, 24
; VI-NEXT:    s_cmp_lg_u32 s10, 7
; VI-NEXT:    s_cselect_b32 s8, s8, 5
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_lshr_b32 s9, s5, 16
; VI-NEXT:    s_cmp_lg_u32 s10, 6
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_and_b32 s9, s9, 0xff
; VI-NEXT:    s_or_b32 s8, s9, s8
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_lshr_b32 s9, s5, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 5
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 4
; VI-NEXT:    s_cselect_b32 s5, s5, 5
; VI-NEXT:    s_and_b32 s5, s5, 0xff
; VI-NEXT:    s_or_b32 s5, s5, s9
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s5, s5, s8
; VI-NEXT:    s_lshr_b32 s8, s4, 24
; VI-NEXT:    s_cmp_lg_u32 s10, 3
; VI-NEXT:    s_cselect_b32 s8, s8, 5
; VI-NEXT:    s_lshl_b32 s8, s8, 8
; VI-NEXT:    s_lshr_b32 s9, s4, 16
; VI-NEXT:    s_cmp_lg_u32 s10, 2
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_and_b32 s9, s9, 0xff
; VI-NEXT:    s_or_b32 s8, s9, s8
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_lshr_b32 s9, s4, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 1
; VI-NEXT:    s_cselect_b32 s9, s9, 5
; VI-NEXT:    s_lshl_b32 s9, s9, 8
; VI-NEXT:    s_cmp_lg_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s4, s4, 5
; VI-NEXT:    s_and_b32 s4, s4, 0xff
; VI-NEXT:    s_or_b32 s4, s4, s9
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s8
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <16 x i8> %a, i8 5, i32 %b
  store <16 x i8> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

; This test requires handling INSERT_SUBREG in SIFixSGPRCopies.  Check that
; the compiler doesn't crash.
define amdgpu_kernel void @insert_split_bb(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %a, i32 %b) {
; SI-LABEL: insert_split_bb:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dword s4, s[8:9], 0x4
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s4, 0
; SI-NEXT:    s_cbranch_scc0 .LBB42_4
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    s_load_dword s5, s[2:3], 0x1
; SI-NEXT:    s_mov_b64 s[6:7], 0
; SI-NEXT:    s_andn2_b64 vcc, exec, s[6:7]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 vcc, vcc
; SI-NEXT:    s_cbranch_vccnz .LBB42_3
; SI-NEXT:  .LBB42_2: ; %if
; SI-NEXT:    s_load_dword s5, s[2:3], 0x0
; SI-NEXT:  .LBB42_3: ; %endif
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
; SI-NEXT:  .LBB42_4:
; SI-NEXT:    s_branch .LBB42_2
;
; VI-LABEL: insert_split_bb:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dword s4, s[8:9], 0x10
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s4, 0
; VI-NEXT:    s_cbranch_scc0 .LBB42_4
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    s_load_dword s5, s[2:3], 0x4
; VI-NEXT:    s_cbranch_execnz .LBB42_3
; VI-NEXT:  .LBB42_2: ; %if
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s5, s[2:3], 0x0
; VI-NEXT:  .LBB42_3: ; %endif
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB42_4:
; VI-NEXT:    s_branch .LBB42_2
entry:
  %0 = insertelement <2 x i32> undef, i32 %a, i32 0
  %1 = icmp eq i32 %a, 0
  br i1 %1, label %if, label %else

if:
  %2 = load i32, ptr addrspace(1) %in
  %3 = insertelement <2 x i32> %0, i32 %2, i32 1
  br label %endif

else:
  %4 = getelementptr i32, ptr addrspace(1) %in, i32 1
  %5 = load i32, ptr addrspace(1) %4
  %6 = insertelement <2 x i32> %0, i32 %5, i32 1
  br label %endif

endif:
  %7 = phi <2 x i32> [%3, %if], [%6, %else]
  store <2 x i32> %7, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2f64(ptr addrspace(1) %out, [8 x i32], <2 x double> %a, [8 x i32], i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x18
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0xc
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s10, 1
; SI-NEXT:    s_cselect_b32 s3, 0x40200000, s3
; SI-NEXT:    s_cselect_b32 s2, 0, s2
; SI-NEXT:    s_cmp_eq_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s1, 0x40200000, s1
; SI-NEXT:    s_cselect_b32 s0, 0, s0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x60
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x30
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s10, 1
; VI-NEXT:    s_cselect_b32 s3, 0x40200000, s3
; VI-NEXT:    s_cselect_b32 s2, 0, s2
; VI-NEXT:    s_cmp_eq_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s1, 0x40200000, s1
; VI-NEXT:    s_cselect_b32 s0, 0, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x double> %a, double 8.0, i32 %b
  store <2 x double> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v2i64(ptr addrspace(1) %out, <2 x i64> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v2i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x8
; SI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x4
; SI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s7, 0x100f000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s10, 1
; SI-NEXT:    s_cselect_b32 s3, 0, s3
; SI-NEXT:    s_cselect_b32 s2, 5, s2
; SI-NEXT:    s_cmp_eq_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s1, 0, s1
; SI-NEXT:    s_cselect_b32 s0, 5, s0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v2i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x20
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x10
; VI-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s7, 0x1100f000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s10, 1
; VI-NEXT:    s_cselect_b32 s3, 0, s3
; VI-NEXT:    s_cselect_b32 s2, 5, s2
; VI-NEXT:    s_cmp_eq_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s1, 0, s1
; VI-NEXT:    s_cselect_b32 s0, 5, s0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <2 x i64> %a, i64 5, i32 %b
  store <2 x i64> %vecins, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v3i64(ptr addrspace(1) %out, <3 x i64> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v3i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s10, s[8:9], 0x10
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0xc
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s10, 1
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_cselect_b32 s7, 0, s7
; SI-NEXT:    s_cselect_b32 s6, 5, s6
; SI-NEXT:    s_cmp_eq_u32 s10, 0
; SI-NEXT:    s_cselect_b32 s5, 0, s5
; SI-NEXT:    s_cselect_b32 s4, 5, s4
; SI-NEXT:    s_cmp_eq_u32 s10, 2
; SI-NEXT:    s_cselect_b32 s9, 0, s9
; SI-NEXT:    s_cselect_b32 s8, 5, s8
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0 offset:16
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v3i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s10, s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx4 s[4:7], s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0x30
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s10, 1
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_cselect_b32 s7, 0, s7
; VI-NEXT:    s_cselect_b32 s6, 5, s6
; VI-NEXT:    s_cmp_eq_u32 s10, 0
; VI-NEXT:    s_cselect_b32 s5, 0, s5
; VI-NEXT:    s_cselect_b32 s4, 5, s4
; VI-NEXT:    s_cmp_eq_u32 s10, 2
; VI-NEXT:    s_cselect_b32 s9, 0, s9
; VI-NEXT:    s_cselect_b32 s8, 5, s8
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0 offset:16
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <3 x i64> %a, i64 5, i32 %b
  store <3 x i64> %vecins, ptr addrspace(1) %out, align 32
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v4f64(ptr addrspace(1) %out, <4 x double> %a, i32 %b) nounwind {
; SI-LABEL: dynamic_insertelement_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s12, s[8:9], 0x10
; SI-NEXT:    s_load_dwordx8 s[0:7], s[8:9], 0x8
; SI-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s11, 0x100f000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_eq_u32 s12, 1
; SI-NEXT:    s_cselect_b32 s3, 0x40200000, s3
; SI-NEXT:    s_cselect_b32 s2, 0, s2
; SI-NEXT:    s_cmp_eq_u32 s12, 0
; SI-NEXT:    s_cselect_b32 s1, 0x40200000, s1
; SI-NEXT:    s_cselect_b32 s0, 0, s0
; SI-NEXT:    s_cmp_eq_u32 s12, 3
; SI-NEXT:    s_cselect_b32 s7, 0x40200000, s7
; SI-NEXT:    s_cselect_b32 s6, 0, s6
; SI-NEXT:    s_cmp_eq_u32 s12, 2
; SI-NEXT:    s_cselect_b32 s5, 0x40200000, s5
; SI-NEXT:    s_cselect_b32 s4, 0, s4
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; SI-NEXT:    s_nop 0
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    v_mov_b32_e32 v2, s2
; SI-NEXT:    v_mov_b32_e32 v3, s3
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s12, s[8:9], 0x40
; VI-NEXT:    s_load_dwordx8 s[0:7], s[8:9], 0x20
; VI-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s11, 0x1100f000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_eq_u32 s12, 1
; VI-NEXT:    s_cselect_b32 s3, 0x40200000, s3
; VI-NEXT:    s_cselect_b32 s2, 0, s2
; VI-NEXT:    s_cmp_eq_u32 s12, 0
; VI-NEXT:    s_cselect_b32 s1, 0x40200000, s1
; VI-NEXT:    s_cselect_b32 s0, 0, s0
; VI-NEXT:    s_cmp_eq_u32 s12, 3
; VI-NEXT:    s_cselect_b32 s7, 0x40200000, s7
; VI-NEXT:    s_cselect_b32 s6, 0, s6
; VI-NEXT:    s_cmp_eq_u32 s12, 2
; VI-NEXT:    s_cselect_b32 s5, 0x40200000, s5
; VI-NEXT:    s_cselect_b32 s4, 0, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; VI-NEXT:    s_nop 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <4 x double> %a, double 8.0, i32 %b
  store <4 x double> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

define amdgpu_kernel void @dynamic_insertelement_v8f64(ptr addrspace(1) %out, <8 x double> %a, i32 %b) #0 {
; SI-LABEL: dynamic_insertelement_v8f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[8:9], 0x20
; SI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x10
; SI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; SI-NEXT:    v_mov_b32_e32 v16, 0x40200000
; SI-NEXT:    s_mov_b32 s3, 0x100f000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 1
; SI-NEXT:    v_mov_b32_e32 v0, s12
; SI-NEXT:    v_mov_b32_e32 v1, s13
; SI-NEXT:    v_mov_b32_e32 v2, s14
; SI-NEXT:    v_mov_b32_e32 v3, s15
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v6, s18
; SI-NEXT:    v_mov_b32_e32 v7, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s21
; SI-NEXT:    v_mov_b32_e32 v10, s22
; SI-NEXT:    v_mov_b32_e32 v11, s23
; SI-NEXT:    v_mov_b32_e32 v12, s24
; SI-NEXT:    v_mov_b32_e32 v13, s25
; SI-NEXT:    v_mov_b32_e32 v14, s26
; SI-NEXT:    v_mov_b32_e32 v15, s27
; SI-NEXT:    s_mov_b32 m0, s4
; SI-NEXT:    v_movreld_b32_e32 v0, 0
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_movreld_b32_e32 v1, v16
; SI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; SI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; SI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_insertelement_v8f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s4, s[8:9], 0x80
; VI-NEXT:    s_load_dwordx16 s[12:27], s[8:9], 0x40
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_mov_b32_e32 v16, 0x40200000
; VI-NEXT:    s_mov_b32 s3, 0x1100f000
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s4, s4, 1
; VI-NEXT:    v_mov_b32_e32 v0, s12
; VI-NEXT:    v_mov_b32_e32 v1, s13
; VI-NEXT:    v_mov_b32_e32 v2, s14
; VI-NEXT:    v_mov_b32_e32 v3, s15
; VI-NEXT:    v_mov_b32_e32 v4, s16
; VI-NEXT:    v_mov_b32_e32 v5, s17
; VI-NEXT:    v_mov_b32_e32 v6, s18
; VI-NEXT:    v_mov_b32_e32 v7, s19
; VI-NEXT:    v_mov_b32_e32 v8, s20
; VI-NEXT:    v_mov_b32_e32 v9, s21
; VI-NEXT:    v_mov_b32_e32 v10, s22
; VI-NEXT:    v_mov_b32_e32 v11, s23
; VI-NEXT:    v_mov_b32_e32 v12, s24
; VI-NEXT:    v_mov_b32_e32 v13, s25
; VI-NEXT:    v_mov_b32_e32 v14, s26
; VI-NEXT:    v_mov_b32_e32 v15, s27
; VI-NEXT:    s_mov_b32 m0, s4
; VI-NEXT:    v_movreld_b32_e32 v0, 0
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_movreld_b32_e32 v1, v16
; VI-NEXT:    buffer_store_dwordx4 v[12:15], off, s[0:3], 0 offset:48
; VI-NEXT:    buffer_store_dwordx4 v[8:11], off, s[0:3], 0 offset:32
; VI-NEXT:    buffer_store_dwordx4 v[4:7], off, s[0:3], 0 offset:16
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; VI-NEXT:    s_endpgm
  %vecins = insertelement <8 x double> %a, double 8.0, i32 %b
  store <8 x double> %vecins, ptr addrspace(1) %out, align 16
  ret void
}

declare <4 x float> @llvm.amdgcn.image.gather4.lz.2d.v4f32.f32(i32, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
