/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* X86 instruction mapping                                                    *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

struct X86TableEntry {
  uint16_t OldOpc;
  uint16_t NewOpc;
  bool operator<(const X86TableEntry &RHS) const {
    return OldOpc < RHS.OldOpc;
  }  friend bool operator<(const X86TableEntry &TE, unsigned Opc) {
    return TE.OldOpc < Opc;
  }
};


#ifdef GET_X86_COMPRESS_EVEX_TABLE
static const X86TableEntry X86CompressEVEXTable[] = {
  { X86::AADD32mr_EVEX, X86::AADD32mr },
  { X86::AADD64mr_EVEX, X86::AADD64mr },
  { X86::AAND32mr_EVEX, X86::AAND32mr },
  { X86::AAND64mr_EVEX, X86::AAND64mr },
  { X86::ADCX32rm_EVEX, X86::ADCX32rm },
  { X86::ADCX32rr_EVEX, X86::ADCX32rr },
  { X86::ADCX64rm_EVEX, X86::ADCX64rm },
  { X86::ADCX64rr_EVEX, X86::ADCX64rr },
  { X86::ADOX32rm_EVEX, X86::ADOX32rm },
  { X86::ADOX32rr_EVEX, X86::ADOX32rr },
  { X86::ADOX64rm_EVEX, X86::ADOX64rm },
  { X86::ADOX64rr_EVEX, X86::ADOX64rr },
  { X86::ANDN32rm_EVEX, X86::ANDN32rm },
  { X86::ANDN32rm_NF, X86::ANDN32rm },
  { X86::ANDN32rr_EVEX, X86::ANDN32rr },
  { X86::ANDN32rr_NF, X86::ANDN32rr },
  { X86::ANDN64rm_EVEX, X86::ANDN64rm },
  { X86::ANDN64rm_NF, X86::ANDN64rm },
  { X86::ANDN64rr_EVEX, X86::ANDN64rr },
  { X86::ANDN64rr_NF, X86::ANDN64rr },
  { X86::AOR32mr_EVEX, X86::AOR32mr },
  { X86::AOR64mr_EVEX, X86::AOR64mr },
  { X86::AXOR32mr_EVEX, X86::AXOR32mr },
  { X86::AXOR64mr_EVEX, X86::AXOR64mr },
  { X86::BEXTR32rm_EVEX, X86::BEXTR32rm },
  { X86::BEXTR32rm_NF, X86::BEXTR32rm },
  { X86::BEXTR32rr_EVEX, X86::BEXTR32rr },
  { X86::BEXTR32rr_NF, X86::BEXTR32rr },
  { X86::BEXTR64rm_EVEX, X86::BEXTR64rm },
  { X86::BEXTR64rm_NF, X86::BEXTR64rm },
  { X86::BEXTR64rr_EVEX, X86::BEXTR64rr },
  { X86::BEXTR64rr_NF, X86::BEXTR64rr },
  { X86::BLSI32rm_EVEX, X86::BLSI32rm },
  { X86::BLSI32rm_NF, X86::BLSI32rm },
  { X86::BLSI32rr_EVEX, X86::BLSI32rr },
  { X86::BLSI32rr_NF, X86::BLSI32rr },
  { X86::BLSI64rm_EVEX, X86::BLSI64rm },
  { X86::BLSI64rm_NF, X86::BLSI64rm },
  { X86::BLSI64rr_EVEX, X86::BLSI64rr },
  { X86::BLSI64rr_NF, X86::BLSI64rr },
  { X86::BLSMSK32rm_EVEX, X86::BLSMSK32rm },
  { X86::BLSMSK32rm_NF, X86::BLSMSK32rm },
  { X86::BLSMSK32rr_EVEX, X86::BLSMSK32rr },
  { X86::BLSMSK32rr_NF, X86::BLSMSK32rr },
  { X86::BLSMSK64rm_EVEX, X86::BLSMSK64rm },
  { X86::BLSMSK64rm_NF, X86::BLSMSK64rm },
  { X86::BLSMSK64rr_EVEX, X86::BLSMSK64rr },
  { X86::BLSMSK64rr_NF, X86::BLSMSK64rr },
  { X86::BLSR32rm_EVEX, X86::BLSR32rm },
  { X86::BLSR32rm_NF, X86::BLSR32rm },
  { X86::BLSR32rr_EVEX, X86::BLSR32rr },
  { X86::BLSR32rr_NF, X86::BLSR32rr },
  { X86::BLSR64rm_EVEX, X86::BLSR64rm },
  { X86::BLSR64rm_NF, X86::BLSR64rm },
  { X86::BLSR64rr_EVEX, X86::BLSR64rr },
  { X86::BLSR64rr_NF, X86::BLSR64rr },
  { X86::BZHI32rm_EVEX, X86::BZHI32rm },
  { X86::BZHI32rm_NF, X86::BZHI32rm },
  { X86::BZHI32rr_EVEX, X86::BZHI32rr },
  { X86::BZHI32rr_NF, X86::BZHI32rr },
  { X86::BZHI64rm_EVEX, X86::BZHI64rm },
  { X86::BZHI64rm_NF, X86::BZHI64rm },
  { X86::BZHI64rr_EVEX, X86::BZHI64rr },
  { X86::BZHI64rr_NF, X86::BZHI64rr },
  { X86::CMPCCXADDmr32_EVEX, X86::CMPCCXADDmr32 },
  { X86::CMPCCXADDmr64_EVEX, X86::CMPCCXADDmr64 },
  { X86::CRC32r32m16_EVEX, X86::CRC32r32m16 },
  { X86::CRC32r32m32_EVEX, X86::CRC32r32m32 },
  { X86::CRC32r32m8_EVEX, X86::CRC32r32m8 },
  { X86::CRC32r32r16_EVEX, X86::CRC32r32r16 },
  { X86::CRC32r32r32_EVEX, X86::CRC32r32r32 },
  { X86::CRC32r32r8_EVEX, X86::CRC32r32r8 },
  { X86::CRC32r64m64_EVEX, X86::CRC32r64m64 },
  { X86::CRC32r64m8_EVEX, X86::CRC32r64m8 },
  { X86::CRC32r64r64_EVEX, X86::CRC32r64r64 },
  { X86::CRC32r64r8_EVEX, X86::CRC32r64r8 },
  { X86::ENQCMD32_EVEX, X86::ENQCMD32 },
  { X86::ENQCMD64_EVEX, X86::ENQCMD64 },
  { X86::ENQCMDS32_EVEX, X86::ENQCMDS32 },
  { X86::ENQCMDS64_EVEX, X86::ENQCMDS64 },
  { X86::INVEPT64_EVEX, X86::INVEPT64 },
  { X86::INVPCID64_EVEX, X86::INVPCID64 },
  { X86::INVVPID64_EVEX, X86::INVVPID64 },
  { X86::KMOVBkk_EVEX, X86::KMOVBkk },
  { X86::KMOVBkm_EVEX, X86::KMOVBkm },
  { X86::KMOVBkr_EVEX, X86::KMOVBkr },
  { X86::KMOVBmk_EVEX, X86::KMOVBmk },
  { X86::KMOVBrk_EVEX, X86::KMOVBrk },
  { X86::KMOVDkk_EVEX, X86::KMOVDkk },
  { X86::KMOVDkm_EVEX, X86::KMOVDkm },
  { X86::KMOVDkr_EVEX, X86::KMOVDkr },
  { X86::KMOVDmk_EVEX, X86::KMOVDmk },
  { X86::KMOVDrk_EVEX, X86::KMOVDrk },
  { X86::KMOVQkk_EVEX, X86::KMOVQkk },
  { X86::KMOVQkm_EVEX, X86::KMOVQkm },
  { X86::KMOVQkr_EVEX, X86::KMOVQkr },
  { X86::KMOVQmk_EVEX, X86::KMOVQmk },
  { X86::KMOVQrk_EVEX, X86::KMOVQrk },
  { X86::KMOVWkk_EVEX, X86::KMOVWkk },
  { X86::KMOVWkm_EVEX, X86::KMOVWkm },
  { X86::KMOVWkr_EVEX, X86::KMOVWkr },
  { X86::KMOVWmk_EVEX, X86::KMOVWmk },
  { X86::KMOVWrk_EVEX, X86::KMOVWrk },
  { X86::LDTILECFG_EVEX, X86::LDTILECFG },
  { X86::MOVBE16mr_EVEX, X86::MOVBE16mr },
  { X86::MOVBE16rm_EVEX, X86::MOVBE16rm },
  { X86::MOVBE32mr_EVEX, X86::MOVBE32mr },
  { X86::MOVBE32rm_EVEX, X86::MOVBE32rm },
  { X86::MOVBE64mr_EVEX, X86::MOVBE64mr },
  { X86::MOVBE64rm_EVEX, X86::MOVBE64rm },
  { X86::MOVDIR64B32_EVEX, X86::MOVDIR64B32 },
  { X86::MOVDIR64B64_EVEX, X86::MOVDIR64B64 },
  { X86::MOVDIRI32_EVEX, X86::MOVDIRI32 },
  { X86::MOVDIRI64_EVEX, X86::MOVDIRI64 },
  { X86::MOVRS16rm_EVEX, X86::MOVRS16rm },
  { X86::MOVRS32rm_EVEX, X86::MOVRS32rm },
  { X86::MOVRS64rm_EVEX, X86::MOVRS64rm },
  { X86::MOVRS8rm_EVEX, X86::MOVRS8rm },
  { X86::MULX32rm_EVEX, X86::MULX32rm },
  { X86::MULX32rr_EVEX, X86::MULX32rr },
  { X86::MULX64rm_EVEX, X86::MULX64rm },
  { X86::MULX64rr_EVEX, X86::MULX64rr },
  { X86::PDEP32rm_EVEX, X86::PDEP32rm },
  { X86::PDEP32rr_EVEX, X86::PDEP32rr },
  { X86::PDEP64rm_EVEX, X86::PDEP64rm },
  { X86::PDEP64rr_EVEX, X86::PDEP64rr },
  { X86::PEXT32rm_EVEX, X86::PEXT32rm },
  { X86::PEXT32rr_EVEX, X86::PEXT32rr },
  { X86::PEXT64rm_EVEX, X86::PEXT64rm },
  { X86::PEXT64rr_EVEX, X86::PEXT64rr },
  { X86::RDMSRri_EVEX, X86::RDMSRri },
  { X86::RORX32mi_EVEX, X86::RORX32mi },
  { X86::RORX32ri_EVEX, X86::RORX32ri },
  { X86::RORX64mi_EVEX, X86::RORX64mi },
  { X86::RORX64ri_EVEX, X86::RORX64ri },
  { X86::SARX32rm_EVEX, X86::SARX32rm },
  { X86::SARX32rr_EVEX, X86::SARX32rr },
  { X86::SARX64rm_EVEX, X86::SARX64rm },
  { X86::SARX64rr_EVEX, X86::SARX64rr },
  { X86::SHLX32rm_EVEX, X86::SHLX32rm },
  { X86::SHLX32rr_EVEX, X86::SHLX32rr },
  { X86::SHLX64rm_EVEX, X86::SHLX64rm },
  { X86::SHLX64rr_EVEX, X86::SHLX64rr },
  { X86::SHRX32rm_EVEX, X86::SHRX32rm },
  { X86::SHRX32rr_EVEX, X86::SHRX32rr },
  { X86::SHRX64rm_EVEX, X86::SHRX64rm },
  { X86::SHRX64rr_EVEX, X86::SHRX64rr },
  { X86::STTILECFG_EVEX, X86::STTILECFG },
  { X86::T2RPNTLVWZ0RST1_EVEX, X86::T2RPNTLVWZ0RST1 },
  { X86::T2RPNTLVWZ0RS_EVEX, X86::T2RPNTLVWZ0RS },
  { X86::T2RPNTLVWZ0T1_EVEX, X86::T2RPNTLVWZ0T1 },
  { X86::T2RPNTLVWZ0_EVEX, X86::T2RPNTLVWZ0 },
  { X86::T2RPNTLVWZ1RST1_EVEX, X86::T2RPNTLVWZ1RST1 },
  { X86::T2RPNTLVWZ1RS_EVEX, X86::T2RPNTLVWZ1RS },
  { X86::T2RPNTLVWZ1T1_EVEX, X86::T2RPNTLVWZ1T1 },
  { X86::T2RPNTLVWZ1_EVEX, X86::T2RPNTLVWZ1 },
  { X86::TILELOADDRST1_EVEX, X86::TILELOADDRST1 },
  { X86::TILELOADDRS_EVEX, X86::TILELOADDRS },
  { X86::TILELOADDT1_EVEX, X86::TILELOADDT1 },
  { X86::TILELOADD_EVEX, X86::TILELOADD },
  { X86::TILESTORED_EVEX, X86::TILESTORED },
  { X86::URDMSRri_EVEX, X86::URDMSRri },
  { X86::URDMSRrr_EVEX, X86::URDMSRrr },
  { X86::UWRMSRir_EVEX, X86::UWRMSRir },
  { X86::UWRMSRrr_EVEX, X86::UWRMSRrr },
  { X86::VADDPDZ128rm, X86::VADDPDrm },
  { X86::VADDPDZ128rr, X86::VADDPDrr },
  { X86::VADDPDZ256rm, X86::VADDPDYrm },
  { X86::VADDPDZ256rr, X86::VADDPDYrr },
  { X86::VADDPSZ128rm, X86::VADDPSrm },
  { X86::VADDPSZ128rr, X86::VADDPSrr },
  { X86::VADDPSZ256rm, X86::VADDPSYrm },
  { X86::VADDPSZ256rr, X86::VADDPSYrr },
  { X86::VADDSDZrm, X86::VADDSDrm },
  { X86::VADDSDZrm_Int, X86::VADDSDrm_Int },
  { X86::VADDSDZrr, X86::VADDSDrr },
  { X86::VADDSDZrr_Int, X86::VADDSDrr_Int },
  { X86::VADDSSZrm, X86::VADDSSrm },
  { X86::VADDSSZrm_Int, X86::VADDSSrm_Int },
  { X86::VADDSSZrr, X86::VADDSSrr },
  { X86::VADDSSZrr_Int, X86::VADDSSrr_Int },
  { X86::VAESDECLASTZ128rm, X86::VAESDECLASTrm },
  { X86::VAESDECLASTZ128rr, X86::VAESDECLASTrr },
  { X86::VAESDECLASTZ256rm, X86::VAESDECLASTYrm },
  { X86::VAESDECLASTZ256rr, X86::VAESDECLASTYrr },
  { X86::VAESDECZ128rm, X86::VAESDECrm },
  { X86::VAESDECZ128rr, X86::VAESDECrr },
  { X86::VAESDECZ256rm, X86::VAESDECYrm },
  { X86::VAESDECZ256rr, X86::VAESDECYrr },
  { X86::VAESENCLASTZ128rm, X86::VAESENCLASTrm },
  { X86::VAESENCLASTZ128rr, X86::VAESENCLASTrr },
  { X86::VAESENCLASTZ256rm, X86::VAESENCLASTYrm },
  { X86::VAESENCLASTZ256rr, X86::VAESENCLASTYrr },
  { X86::VAESENCZ128rm, X86::VAESENCrm },
  { X86::VAESENCZ128rr, X86::VAESENCrr },
  { X86::VAESENCZ256rm, X86::VAESENCYrm },
  { X86::VAESENCZ256rr, X86::VAESENCYrr },
  { X86::VALIGNDZ128rmi, X86::VPALIGNRrmi },
  { X86::VALIGNDZ128rri, X86::VPALIGNRrri },
  { X86::VALIGNQZ128rmi, X86::VPALIGNRrmi },
  { X86::VALIGNQZ128rri, X86::VPALIGNRrri },
  { X86::VANDNPDZ128rm, X86::VANDNPDrm },
  { X86::VANDNPDZ128rr, X86::VANDNPDrr },
  { X86::VANDNPDZ256rm, X86::VANDNPDYrm },
  { X86::VANDNPDZ256rr, X86::VANDNPDYrr },
  { X86::VANDNPSZ128rm, X86::VANDNPSrm },
  { X86::VANDNPSZ128rr, X86::VANDNPSrr },
  { X86::VANDNPSZ256rm, X86::VANDNPSYrm },
  { X86::VANDNPSZ256rr, X86::VANDNPSYrr },
  { X86::VANDPDZ128rm, X86::VANDPDrm },
  { X86::VANDPDZ128rr, X86::VANDPDrr },
  { X86::VANDPDZ256rm, X86::VANDPDYrm },
  { X86::VANDPDZ256rr, X86::VANDPDYrr },
  { X86::VANDPSZ128rm, X86::VANDPSrm },
  { X86::VANDPSZ128rr, X86::VANDPSrr },
  { X86::VANDPSZ256rm, X86::VANDPSYrm },
  { X86::VANDPSZ256rr, X86::VANDPSYrr },
  { X86::VBROADCASTF32X2Z256rm, X86::VBROADCASTSDYrm },
  { X86::VBROADCASTF32X2Z256rr, X86::VBROADCASTSDYrr },
  { X86::VBROADCASTF32X4Z256rm, X86::VBROADCASTF128rm },
  { X86::VBROADCASTI32X2Z128rm, X86::VPBROADCASTQrm },
  { X86::VBROADCASTI32X2Z128rr, X86::VPBROADCASTQrr },
  { X86::VBROADCASTI32X2Z256rm, X86::VPBROADCASTQYrm },
  { X86::VBROADCASTI32X2Z256rr, X86::VPBROADCASTQYrr },
  { X86::VBROADCASTI32X4Z256rm, X86::VBROADCASTI128rm },
  { X86::VBROADCASTSDZ256rm, X86::VBROADCASTSDYrm },
  { X86::VBROADCASTSDZ256rr, X86::VBROADCASTSDYrr },
  { X86::VBROADCASTSSZ128rm, X86::VBROADCASTSSrm },
  { X86::VBROADCASTSSZ128rr, X86::VBROADCASTSSrr },
  { X86::VBROADCASTSSZ256rm, X86::VBROADCASTSSYrm },
  { X86::VBROADCASTSSZ256rr, X86::VBROADCASTSSYrr },
  { X86::VCOMISDZrm, X86::VCOMISDrm },
  { X86::VCOMISDZrm_Int, X86::VCOMISDrm_Int },
  { X86::VCOMISDZrr, X86::VCOMISDrr },
  { X86::VCOMISDZrr_Int, X86::VCOMISDrr_Int },
  { X86::VCOMISSZrm, X86::VCOMISSrm },
  { X86::VCOMISSZrm_Int, X86::VCOMISSrm_Int },
  { X86::VCOMISSZrr, X86::VCOMISSrr },
  { X86::VCOMISSZrr_Int, X86::VCOMISSrr_Int },
  { X86::VCVTDQ2PDZ128rm, X86::VCVTDQ2PDrm },
  { X86::VCVTDQ2PDZ128rr, X86::VCVTDQ2PDrr },
  { X86::VCVTDQ2PDZ256rm, X86::VCVTDQ2PDYrm },
  { X86::VCVTDQ2PDZ256rr, X86::VCVTDQ2PDYrr },
  { X86::VCVTDQ2PSZ128rm, X86::VCVTDQ2PSrm },
  { X86::VCVTDQ2PSZ128rr, X86::VCVTDQ2PSrr },
  { X86::VCVTDQ2PSZ256rm, X86::VCVTDQ2PSYrm },
  { X86::VCVTDQ2PSZ256rr, X86::VCVTDQ2PSYrr },
  { X86::VCVTNEPS2BF16Z128rm, X86::VCVTNEPS2BF16rm },
  { X86::VCVTNEPS2BF16Z128rr, X86::VCVTNEPS2BF16rr },
  { X86::VCVTNEPS2BF16Z256rm, X86::VCVTNEPS2BF16Yrm },
  { X86::VCVTNEPS2BF16Z256rr, X86::VCVTNEPS2BF16Yrr },
  { X86::VCVTPD2DQZ128rm, X86::VCVTPD2DQrm },
  { X86::VCVTPD2DQZ128rr, X86::VCVTPD2DQrr },
  { X86::VCVTPD2DQZ256rm, X86::VCVTPD2DQYrm },
  { X86::VCVTPD2DQZ256rr, X86::VCVTPD2DQYrr },
  { X86::VCVTPD2PSZ128rm, X86::VCVTPD2PSrm },
  { X86::VCVTPD2PSZ128rr, X86::VCVTPD2PSrr },
  { X86::VCVTPD2PSZ256rm, X86::VCVTPD2PSYrm },
  { X86::VCVTPD2PSZ256rr, X86::VCVTPD2PSYrr },
  { X86::VCVTPH2PSZ128rm, X86::VCVTPH2PSrm },
  { X86::VCVTPH2PSZ128rr, X86::VCVTPH2PSrr },
  { X86::VCVTPH2PSZ256rm, X86::VCVTPH2PSYrm },
  { X86::VCVTPH2PSZ256rr, X86::VCVTPH2PSYrr },
  { X86::VCVTPS2DQZ128rm, X86::VCVTPS2DQrm },
  { X86::VCVTPS2DQZ128rr, X86::VCVTPS2DQrr },
  { X86::VCVTPS2DQZ256rm, X86::VCVTPS2DQYrm },
  { X86::VCVTPS2DQZ256rr, X86::VCVTPS2DQYrr },
  { X86::VCVTPS2PDZ128rm, X86::VCVTPS2PDrm },
  { X86::VCVTPS2PDZ128rr, X86::VCVTPS2PDrr },
  { X86::VCVTPS2PDZ256rm, X86::VCVTPS2PDYrm },
  { X86::VCVTPS2PDZ256rr, X86::VCVTPS2PDYrr },
  { X86::VCVTPS2PHZ128mr, X86::VCVTPS2PHmr },
  { X86::VCVTPS2PHZ128rr, X86::VCVTPS2PHrr },
  { X86::VCVTPS2PHZ256mr, X86::VCVTPS2PHYmr },
  { X86::VCVTPS2PHZ256rr, X86::VCVTPS2PHYrr },
  { X86::VCVTSD2SI64Zrm, X86::VCVTSD2SI64rm },
  { X86::VCVTSD2SI64Zrm_Int, X86::VCVTSD2SI64rm_Int },
  { X86::VCVTSD2SI64Zrr, X86::VCVTSD2SI64rr },
  { X86::VCVTSD2SI64Zrr_Int, X86::VCVTSD2SI64rr_Int },
  { X86::VCVTSD2SIZrm, X86::VCVTSD2SIrm },
  { X86::VCVTSD2SIZrm_Int, X86::VCVTSD2SIrm_Int },
  { X86::VCVTSD2SIZrr, X86::VCVTSD2SIrr },
  { X86::VCVTSD2SIZrr_Int, X86::VCVTSD2SIrr_Int },
  { X86::VCVTSD2SSZrm, X86::VCVTSD2SSrm },
  { X86::VCVTSD2SSZrm_Int, X86::VCVTSD2SSrm_Int },
  { X86::VCVTSD2SSZrr, X86::VCVTSD2SSrr },
  { X86::VCVTSD2SSZrr_Int, X86::VCVTSD2SSrr_Int },
  { X86::VCVTSI2SDZrm, X86::VCVTSI2SDrm },
  { X86::VCVTSI2SDZrm_Int, X86::VCVTSI2SDrm_Int },
  { X86::VCVTSI2SDZrr, X86::VCVTSI2SDrr },
  { X86::VCVTSI2SDZrr_Int, X86::VCVTSI2SDrr_Int },
  { X86::VCVTSI2SSZrm, X86::VCVTSI2SSrm },
  { X86::VCVTSI2SSZrm_Int, X86::VCVTSI2SSrm_Int },
  { X86::VCVTSI2SSZrr, X86::VCVTSI2SSrr },
  { X86::VCVTSI2SSZrr_Int, X86::VCVTSI2SSrr_Int },
  { X86::VCVTSI642SDZrm, X86::VCVTSI642SDrm },
  { X86::VCVTSI642SDZrm_Int, X86::VCVTSI642SDrm_Int },
  { X86::VCVTSI642SDZrr, X86::VCVTSI642SDrr },
  { X86::VCVTSI642SDZrr_Int, X86::VCVTSI642SDrr_Int },
  { X86::VCVTSI642SSZrm, X86::VCVTSI642SSrm },
  { X86::VCVTSI642SSZrm_Int, X86::VCVTSI642SSrm_Int },
  { X86::VCVTSI642SSZrr, X86::VCVTSI642SSrr },
  { X86::VCVTSI642SSZrr_Int, X86::VCVTSI642SSrr_Int },
  { X86::VCVTSS2SDZrm, X86::VCVTSS2SDrm },
  { X86::VCVTSS2SDZrm_Int, X86::VCVTSS2SDrm_Int },
  { X86::VCVTSS2SDZrr, X86::VCVTSS2SDrr },
  { X86::VCVTSS2SDZrr_Int, X86::VCVTSS2SDrr_Int },
  { X86::VCVTSS2SI64Zrm, X86::VCVTSS2SI64rm },
  { X86::VCVTSS2SI64Zrm_Int, X86::VCVTSS2SI64rm_Int },
  { X86::VCVTSS2SI64Zrr, X86::VCVTSS2SI64rr },
  { X86::VCVTSS2SI64Zrr_Int, X86::VCVTSS2SI64rr_Int },
  { X86::VCVTSS2SIZrm, X86::VCVTSS2SIrm },
  { X86::VCVTSS2SIZrm_Int, X86::VCVTSS2SIrm_Int },
  { X86::VCVTSS2SIZrr, X86::VCVTSS2SIrr },
  { X86::VCVTSS2SIZrr_Int, X86::VCVTSS2SIrr_Int },
  { X86::VCVTTPD2DQZ128rm, X86::VCVTTPD2DQrm },
  { X86::VCVTTPD2DQZ128rr, X86::VCVTTPD2DQrr },
  { X86::VCVTTPD2DQZ256rm, X86::VCVTTPD2DQYrm },
  { X86::VCVTTPD2DQZ256rr, X86::VCVTTPD2DQYrr },
  { X86::VCVTTPS2DQZ128rm, X86::VCVTTPS2DQrm },
  { X86::VCVTTPS2DQZ128rr, X86::VCVTTPS2DQrr },
  { X86::VCVTTPS2DQZ256rm, X86::VCVTTPS2DQYrm },
  { X86::VCVTTPS2DQZ256rr, X86::VCVTTPS2DQYrr },
  { X86::VCVTTSD2SI64Zrm, X86::VCVTTSD2SI64rm },
  { X86::VCVTTSD2SI64Zrm_Int, X86::VCVTTSD2SI64rm_Int },
  { X86::VCVTTSD2SI64Zrr, X86::VCVTTSD2SI64rr },
  { X86::VCVTTSD2SI64Zrr_Int, X86::VCVTTSD2SI64rr_Int },
  { X86::VCVTTSD2SIZrm, X86::VCVTTSD2SIrm },
  { X86::VCVTTSD2SIZrm_Int, X86::VCVTTSD2SIrm_Int },
  { X86::VCVTTSD2SIZrr, X86::VCVTTSD2SIrr },
  { X86::VCVTTSD2SIZrr_Int, X86::VCVTTSD2SIrr_Int },
  { X86::VCVTTSS2SI64Zrm, X86::VCVTTSS2SI64rm },
  { X86::VCVTTSS2SI64Zrm_Int, X86::VCVTTSS2SI64rm_Int },
  { X86::VCVTTSS2SI64Zrr, X86::VCVTTSS2SI64rr },
  { X86::VCVTTSS2SI64Zrr_Int, X86::VCVTTSS2SI64rr_Int },
  { X86::VCVTTSS2SIZrm, X86::VCVTTSS2SIrm },
  { X86::VCVTTSS2SIZrm_Int, X86::VCVTTSS2SIrm_Int },
  { X86::VCVTTSS2SIZrr, X86::VCVTTSS2SIrr },
  { X86::VCVTTSS2SIZrr_Int, X86::VCVTTSS2SIrr_Int },
  { X86::VDIVPDZ128rm, X86::VDIVPDrm },
  { X86::VDIVPDZ128rr, X86::VDIVPDrr },
  { X86::VDIVPDZ256rm, X86::VDIVPDYrm },
  { X86::VDIVPDZ256rr, X86::VDIVPDYrr },
  { X86::VDIVPSZ128rm, X86::VDIVPSrm },
  { X86::VDIVPSZ128rr, X86::VDIVPSrr },
  { X86::VDIVPSZ256rm, X86::VDIVPSYrm },
  { X86::VDIVPSZ256rr, X86::VDIVPSYrr },
  { X86::VDIVSDZrm, X86::VDIVSDrm },
  { X86::VDIVSDZrm_Int, X86::VDIVSDrm_Int },
  { X86::VDIVSDZrr, X86::VDIVSDrr },
  { X86::VDIVSDZrr_Int, X86::VDIVSDrr_Int },
  { X86::VDIVSSZrm, X86::VDIVSSrm },
  { X86::VDIVSSZrm_Int, X86::VDIVSSrm_Int },
  { X86::VDIVSSZrr, X86::VDIVSSrr },
  { X86::VDIVSSZrr_Int, X86::VDIVSSrr_Int },
  { X86::VEXTRACTF32X4Z256mri, X86::VEXTRACTF128mri },
  { X86::VEXTRACTF32X4Z256rri, X86::VEXTRACTF128rri },
  { X86::VEXTRACTF64X2Z256mri, X86::VEXTRACTF128mri },
  { X86::VEXTRACTF64X2Z256rri, X86::VEXTRACTF128rri },
  { X86::VEXTRACTI32X4Z256mri, X86::VEXTRACTI128mri },
  { X86::VEXTRACTI32X4Z256rri, X86::VEXTRACTI128rri },
  { X86::VEXTRACTI64X2Z256mri, X86::VEXTRACTI128mri },
  { X86::VEXTRACTI64X2Z256rri, X86::VEXTRACTI128rri },
  { X86::VEXTRACTPSZmri, X86::VEXTRACTPSmri },
  { X86::VEXTRACTPSZrri, X86::VEXTRACTPSrri },
  { X86::VFMADD132PDZ128m, X86::VFMADD132PDm },
  { X86::VFMADD132PDZ128r, X86::VFMADD132PDr },
  { X86::VFMADD132PDZ256m, X86::VFMADD132PDYm },
  { X86::VFMADD132PDZ256r, X86::VFMADD132PDYr },
  { X86::VFMADD132PSZ128m, X86::VFMADD132PSm },
  { X86::VFMADD132PSZ128r, X86::VFMADD132PSr },
  { X86::VFMADD132PSZ256m, X86::VFMADD132PSYm },
  { X86::VFMADD132PSZ256r, X86::VFMADD132PSYr },
  { X86::VFMADD132SDZm, X86::VFMADD132SDm },
  { X86::VFMADD132SDZm_Int, X86::VFMADD132SDm_Int },
  { X86::VFMADD132SDZr, X86::VFMADD132SDr },
  { X86::VFMADD132SDZr_Int, X86::VFMADD132SDr_Int },
  { X86::VFMADD132SSZm, X86::VFMADD132SSm },
  { X86::VFMADD132SSZm_Int, X86::VFMADD132SSm_Int },
  { X86::VFMADD132SSZr, X86::VFMADD132SSr },
  { X86::VFMADD132SSZr_Int, X86::VFMADD132SSr_Int },
  { X86::VFMADD213PDZ128m, X86::VFMADD213PDm },
  { X86::VFMADD213PDZ128r, X86::VFMADD213PDr },
  { X86::VFMADD213PDZ256m, X86::VFMADD213PDYm },
  { X86::VFMADD213PDZ256r, X86::VFMADD213PDYr },
  { X86::VFMADD213PSZ128m, X86::VFMADD213PSm },
  { X86::VFMADD213PSZ128r, X86::VFMADD213PSr },
  { X86::VFMADD213PSZ256m, X86::VFMADD213PSYm },
  { X86::VFMADD213PSZ256r, X86::VFMADD213PSYr },
  { X86::VFMADD213SDZm, X86::VFMADD213SDm },
  { X86::VFMADD213SDZm_Int, X86::VFMADD213SDm_Int },
  { X86::VFMADD213SDZr, X86::VFMADD213SDr },
  { X86::VFMADD213SDZr_Int, X86::VFMADD213SDr_Int },
  { X86::VFMADD213SSZm, X86::VFMADD213SSm },
  { X86::VFMADD213SSZm_Int, X86::VFMADD213SSm_Int },
  { X86::VFMADD213SSZr, X86::VFMADD213SSr },
  { X86::VFMADD213SSZr_Int, X86::VFMADD213SSr_Int },
  { X86::VFMADD231PDZ128m, X86::VFMADD231PDm },
  { X86::VFMADD231PDZ128r, X86::VFMADD231PDr },
  { X86::VFMADD231PDZ256m, X86::VFMADD231PDYm },
  { X86::VFMADD231PDZ256r, X86::VFMADD231PDYr },
  { X86::VFMADD231PSZ128m, X86::VFMADD231PSm },
  { X86::VFMADD231PSZ128r, X86::VFMADD231PSr },
  { X86::VFMADD231PSZ256m, X86::VFMADD231PSYm },
  { X86::VFMADD231PSZ256r, X86::VFMADD231PSYr },
  { X86::VFMADD231SDZm, X86::VFMADD231SDm },
  { X86::VFMADD231SDZm_Int, X86::VFMADD231SDm_Int },
  { X86::VFMADD231SDZr, X86::VFMADD231SDr },
  { X86::VFMADD231SDZr_Int, X86::VFMADD231SDr_Int },
  { X86::VFMADD231SSZm, X86::VFMADD231SSm },
  { X86::VFMADD231SSZm_Int, X86::VFMADD231SSm_Int },
  { X86::VFMADD231SSZr, X86::VFMADD231SSr },
  { X86::VFMADD231SSZr_Int, X86::VFMADD231SSr_Int },
  { X86::VFMADDSUB132PDZ128m, X86::VFMADDSUB132PDm },
  { X86::VFMADDSUB132PDZ128r, X86::VFMADDSUB132PDr },
  { X86::VFMADDSUB132PDZ256m, X86::VFMADDSUB132PDYm },
  { X86::VFMADDSUB132PDZ256r, X86::VFMADDSUB132PDYr },
  { X86::VFMADDSUB132PSZ128m, X86::VFMADDSUB132PSm },
  { X86::VFMADDSUB132PSZ128r, X86::VFMADDSUB132PSr },
  { X86::VFMADDSUB132PSZ256m, X86::VFMADDSUB132PSYm },
  { X86::VFMADDSUB132PSZ256r, X86::VFMADDSUB132PSYr },
  { X86::VFMADDSUB213PDZ128m, X86::VFMADDSUB213PDm },
  { X86::VFMADDSUB213PDZ128r, X86::VFMADDSUB213PDr },
  { X86::VFMADDSUB213PDZ256m, X86::VFMADDSUB213PDYm },
  { X86::VFMADDSUB213PDZ256r, X86::VFMADDSUB213PDYr },
  { X86::VFMADDSUB213PSZ128m, X86::VFMADDSUB213PSm },
  { X86::VFMADDSUB213PSZ128r, X86::VFMADDSUB213PSr },
  { X86::VFMADDSUB213PSZ256m, X86::VFMADDSUB213PSYm },
  { X86::VFMADDSUB213PSZ256r, X86::VFMADDSUB213PSYr },
  { X86::VFMADDSUB231PDZ128m, X86::VFMADDSUB231PDm },
  { X86::VFMADDSUB231PDZ128r, X86::VFMADDSUB231PDr },
  { X86::VFMADDSUB231PDZ256m, X86::VFMADDSUB231PDYm },
  { X86::VFMADDSUB231PDZ256r, X86::VFMADDSUB231PDYr },
  { X86::VFMADDSUB231PSZ128m, X86::VFMADDSUB231PSm },
  { X86::VFMADDSUB231PSZ128r, X86::VFMADDSUB231PSr },
  { X86::VFMADDSUB231PSZ256m, X86::VFMADDSUB231PSYm },
  { X86::VFMADDSUB231PSZ256r, X86::VFMADDSUB231PSYr },
  { X86::VFMSUB132PDZ128m, X86::VFMSUB132PDm },
  { X86::VFMSUB132PDZ128r, X86::VFMSUB132PDr },
  { X86::VFMSUB132PDZ256m, X86::VFMSUB132PDYm },
  { X86::VFMSUB132PDZ256r, X86::VFMSUB132PDYr },
  { X86::VFMSUB132PSZ128m, X86::VFMSUB132PSm },
  { X86::VFMSUB132PSZ128r, X86::VFMSUB132PSr },
  { X86::VFMSUB132PSZ256m, X86::VFMSUB132PSYm },
  { X86::VFMSUB132PSZ256r, X86::VFMSUB132PSYr },
  { X86::VFMSUB132SDZm, X86::VFMSUB132SDm },
  { X86::VFMSUB132SDZm_Int, X86::VFMSUB132SDm_Int },
  { X86::VFMSUB132SDZr, X86::VFMSUB132SDr },
  { X86::VFMSUB132SDZr_Int, X86::VFMSUB132SDr_Int },
  { X86::VFMSUB132SSZm, X86::VFMSUB132SSm },
  { X86::VFMSUB132SSZm_Int, X86::VFMSUB132SSm_Int },
  { X86::VFMSUB132SSZr, X86::VFMSUB132SSr },
  { X86::VFMSUB132SSZr_Int, X86::VFMSUB132SSr_Int },
  { X86::VFMSUB213PDZ128m, X86::VFMSUB213PDm },
  { X86::VFMSUB213PDZ128r, X86::VFMSUB213PDr },
  { X86::VFMSUB213PDZ256m, X86::VFMSUB213PDYm },
  { X86::VFMSUB213PDZ256r, X86::VFMSUB213PDYr },
  { X86::VFMSUB213PSZ128m, X86::VFMSUB213PSm },
  { X86::VFMSUB213PSZ128r, X86::VFMSUB213PSr },
  { X86::VFMSUB213PSZ256m, X86::VFMSUB213PSYm },
  { X86::VFMSUB213PSZ256r, X86::VFMSUB213PSYr },
  { X86::VFMSUB213SDZm, X86::VFMSUB213SDm },
  { X86::VFMSUB213SDZm_Int, X86::VFMSUB213SDm_Int },
  { X86::VFMSUB213SDZr, X86::VFMSUB213SDr },
  { X86::VFMSUB213SDZr_Int, X86::VFMSUB213SDr_Int },
  { X86::VFMSUB213SSZm, X86::VFMSUB213SSm },
  { X86::VFMSUB213SSZm_Int, X86::VFMSUB213SSm_Int },
  { X86::VFMSUB213SSZr, X86::VFMSUB213SSr },
  { X86::VFMSUB213SSZr_Int, X86::VFMSUB213SSr_Int },
  { X86::VFMSUB231PDZ128m, X86::VFMSUB231PDm },
  { X86::VFMSUB231PDZ128r, X86::VFMSUB231PDr },
  { X86::VFMSUB231PDZ256m, X86::VFMSUB231PDYm },
  { X86::VFMSUB231PDZ256r, X86::VFMSUB231PDYr },
  { X86::VFMSUB231PSZ128m, X86::VFMSUB231PSm },
  { X86::VFMSUB231PSZ128r, X86::VFMSUB231PSr },
  { X86::VFMSUB231PSZ256m, X86::VFMSUB231PSYm },
  { X86::VFMSUB231PSZ256r, X86::VFMSUB231PSYr },
  { X86::VFMSUB231SDZm, X86::VFMSUB231SDm },
  { X86::VFMSUB231SDZm_Int, X86::VFMSUB231SDm_Int },
  { X86::VFMSUB231SDZr, X86::VFMSUB231SDr },
  { X86::VFMSUB231SDZr_Int, X86::VFMSUB231SDr_Int },
  { X86::VFMSUB231SSZm, X86::VFMSUB231SSm },
  { X86::VFMSUB231SSZm_Int, X86::VFMSUB231SSm_Int },
  { X86::VFMSUB231SSZr, X86::VFMSUB231SSr },
  { X86::VFMSUB231SSZr_Int, X86::VFMSUB231SSr_Int },
  { X86::VFMSUBADD132PDZ128m, X86::VFMSUBADD132PDm },
  { X86::VFMSUBADD132PDZ128r, X86::VFMSUBADD132PDr },
  { X86::VFMSUBADD132PDZ256m, X86::VFMSUBADD132PDYm },
  { X86::VFMSUBADD132PDZ256r, X86::VFMSUBADD132PDYr },
  { X86::VFMSUBADD132PSZ128m, X86::VFMSUBADD132PSm },
  { X86::VFMSUBADD132PSZ128r, X86::VFMSUBADD132PSr },
  { X86::VFMSUBADD132PSZ256m, X86::VFMSUBADD132PSYm },
  { X86::VFMSUBADD132PSZ256r, X86::VFMSUBADD132PSYr },
  { X86::VFMSUBADD213PDZ128m, X86::VFMSUBADD213PDm },
  { X86::VFMSUBADD213PDZ128r, X86::VFMSUBADD213PDr },
  { X86::VFMSUBADD213PDZ256m, X86::VFMSUBADD213PDYm },
  { X86::VFMSUBADD213PDZ256r, X86::VFMSUBADD213PDYr },
  { X86::VFMSUBADD213PSZ128m, X86::VFMSUBADD213PSm },
  { X86::VFMSUBADD213PSZ128r, X86::VFMSUBADD213PSr },
  { X86::VFMSUBADD213PSZ256m, X86::VFMSUBADD213PSYm },
  { X86::VFMSUBADD213PSZ256r, X86::VFMSUBADD213PSYr },
  { X86::VFMSUBADD231PDZ128m, X86::VFMSUBADD231PDm },
  { X86::VFMSUBADD231PDZ128r, X86::VFMSUBADD231PDr },
  { X86::VFMSUBADD231PDZ256m, X86::VFMSUBADD231PDYm },
  { X86::VFMSUBADD231PDZ256r, X86::VFMSUBADD231PDYr },
  { X86::VFMSUBADD231PSZ128m, X86::VFMSUBADD231PSm },
  { X86::VFMSUBADD231PSZ128r, X86::VFMSUBADD231PSr },
  { X86::VFMSUBADD231PSZ256m, X86::VFMSUBADD231PSYm },
  { X86::VFMSUBADD231PSZ256r, X86::VFMSUBADD231PSYr },
  { X86::VFNMADD132PDZ128m, X86::VFNMADD132PDm },
  { X86::VFNMADD132PDZ128r, X86::VFNMADD132PDr },
  { X86::VFNMADD132PDZ256m, X86::VFNMADD132PDYm },
  { X86::VFNMADD132PDZ256r, X86::VFNMADD132PDYr },
  { X86::VFNMADD132PSZ128m, X86::VFNMADD132PSm },
  { X86::VFNMADD132PSZ128r, X86::VFNMADD132PSr },
  { X86::VFNMADD132PSZ256m, X86::VFNMADD132PSYm },
  { X86::VFNMADD132PSZ256r, X86::VFNMADD132PSYr },
  { X86::VFNMADD132SDZm, X86::VFNMADD132SDm },
  { X86::VFNMADD132SDZm_Int, X86::VFNMADD132SDm_Int },
  { X86::VFNMADD132SDZr, X86::VFNMADD132SDr },
  { X86::VFNMADD132SDZr_Int, X86::VFNMADD132SDr_Int },
  { X86::VFNMADD132SSZm, X86::VFNMADD132SSm },
  { X86::VFNMADD132SSZm_Int, X86::VFNMADD132SSm_Int },
  { X86::VFNMADD132SSZr, X86::VFNMADD132SSr },
  { X86::VFNMADD132SSZr_Int, X86::VFNMADD132SSr_Int },
  { X86::VFNMADD213PDZ128m, X86::VFNMADD213PDm },
  { X86::VFNMADD213PDZ128r, X86::VFNMADD213PDr },
  { X86::VFNMADD213PDZ256m, X86::VFNMADD213PDYm },
  { X86::VFNMADD213PDZ256r, X86::VFNMADD213PDYr },
  { X86::VFNMADD213PSZ128m, X86::VFNMADD213PSm },
  { X86::VFNMADD213PSZ128r, X86::VFNMADD213PSr },
  { X86::VFNMADD213PSZ256m, X86::VFNMADD213PSYm },
  { X86::VFNMADD213PSZ256r, X86::VFNMADD213PSYr },
  { X86::VFNMADD213SDZm, X86::VFNMADD213SDm },
  { X86::VFNMADD213SDZm_Int, X86::VFNMADD213SDm_Int },
  { X86::VFNMADD213SDZr, X86::VFNMADD213SDr },
  { X86::VFNMADD213SDZr_Int, X86::VFNMADD213SDr_Int },
  { X86::VFNMADD213SSZm, X86::VFNMADD213SSm },
  { X86::VFNMADD213SSZm_Int, X86::VFNMADD213SSm_Int },
  { X86::VFNMADD213SSZr, X86::VFNMADD213SSr },
  { X86::VFNMADD213SSZr_Int, X86::VFNMADD213SSr_Int },
  { X86::VFNMADD231PDZ128m, X86::VFNMADD231PDm },
  { X86::VFNMADD231PDZ128r, X86::VFNMADD231PDr },
  { X86::VFNMADD231PDZ256m, X86::VFNMADD231PDYm },
  { X86::VFNMADD231PDZ256r, X86::VFNMADD231PDYr },
  { X86::VFNMADD231PSZ128m, X86::VFNMADD231PSm },
  { X86::VFNMADD231PSZ128r, X86::VFNMADD231PSr },
  { X86::VFNMADD231PSZ256m, X86::VFNMADD231PSYm },
  { X86::VFNMADD231PSZ256r, X86::VFNMADD231PSYr },
  { X86::VFNMADD231SDZm, X86::VFNMADD231SDm },
  { X86::VFNMADD231SDZm_Int, X86::VFNMADD231SDm_Int },
  { X86::VFNMADD231SDZr, X86::VFNMADD231SDr },
  { X86::VFNMADD231SDZr_Int, X86::VFNMADD231SDr_Int },
  { X86::VFNMADD231SSZm, X86::VFNMADD231SSm },
  { X86::VFNMADD231SSZm_Int, X86::VFNMADD231SSm_Int },
  { X86::VFNMADD231SSZr, X86::VFNMADD231SSr },
  { X86::VFNMADD231SSZr_Int, X86::VFNMADD231SSr_Int },
  { X86::VFNMSUB132PDZ128m, X86::VFNMSUB132PDm },
  { X86::VFNMSUB132PDZ128r, X86::VFNMSUB132PDr },
  { X86::VFNMSUB132PDZ256m, X86::VFNMSUB132PDYm },
  { X86::VFNMSUB132PDZ256r, X86::VFNMSUB132PDYr },
  { X86::VFNMSUB132PSZ128m, X86::VFNMSUB132PSm },
  { X86::VFNMSUB132PSZ128r, X86::VFNMSUB132PSr },
  { X86::VFNMSUB132PSZ256m, X86::VFNMSUB132PSYm },
  { X86::VFNMSUB132PSZ256r, X86::VFNMSUB132PSYr },
  { X86::VFNMSUB132SDZm, X86::VFNMSUB132SDm },
  { X86::VFNMSUB132SDZm_Int, X86::VFNMSUB132SDm_Int },
  { X86::VFNMSUB132SDZr, X86::VFNMSUB132SDr },
  { X86::VFNMSUB132SDZr_Int, X86::VFNMSUB132SDr_Int },
  { X86::VFNMSUB132SSZm, X86::VFNMSUB132SSm },
  { X86::VFNMSUB132SSZm_Int, X86::VFNMSUB132SSm_Int },
  { X86::VFNMSUB132SSZr, X86::VFNMSUB132SSr },
  { X86::VFNMSUB132SSZr_Int, X86::VFNMSUB132SSr_Int },
  { X86::VFNMSUB213PDZ128m, X86::VFNMSUB213PDm },
  { X86::VFNMSUB213PDZ128r, X86::VFNMSUB213PDr },
  { X86::VFNMSUB213PDZ256m, X86::VFNMSUB213PDYm },
  { X86::VFNMSUB213PDZ256r, X86::VFNMSUB213PDYr },
  { X86::VFNMSUB213PSZ128m, X86::VFNMSUB213PSm },
  { X86::VFNMSUB213PSZ128r, X86::VFNMSUB213PSr },
  { X86::VFNMSUB213PSZ256m, X86::VFNMSUB213PSYm },
  { X86::VFNMSUB213PSZ256r, X86::VFNMSUB213PSYr },
  { X86::VFNMSUB213SDZm, X86::VFNMSUB213SDm },
  { X86::VFNMSUB213SDZm_Int, X86::VFNMSUB213SDm_Int },
  { X86::VFNMSUB213SDZr, X86::VFNMSUB213SDr },
  { X86::VFNMSUB213SDZr_Int, X86::VFNMSUB213SDr_Int },
  { X86::VFNMSUB213SSZm, X86::VFNMSUB213SSm },
  { X86::VFNMSUB213SSZm_Int, X86::VFNMSUB213SSm_Int },
  { X86::VFNMSUB213SSZr, X86::VFNMSUB213SSr },
  { X86::VFNMSUB213SSZr_Int, X86::VFNMSUB213SSr_Int },
  { X86::VFNMSUB231PDZ128m, X86::VFNMSUB231PDm },
  { X86::VFNMSUB231PDZ128r, X86::VFNMSUB231PDr },
  { X86::VFNMSUB231PDZ256m, X86::VFNMSUB231PDYm },
  { X86::VFNMSUB231PDZ256r, X86::VFNMSUB231PDYr },
  { X86::VFNMSUB231PSZ128m, X86::VFNMSUB231PSm },
  { X86::VFNMSUB231PSZ128r, X86::VFNMSUB231PSr },
  { X86::VFNMSUB231PSZ256m, X86::VFNMSUB231PSYm },
  { X86::VFNMSUB231PSZ256r, X86::VFNMSUB231PSYr },
  { X86::VFNMSUB231SDZm, X86::VFNMSUB231SDm },
  { X86::VFNMSUB231SDZm_Int, X86::VFNMSUB231SDm_Int },
  { X86::VFNMSUB231SDZr, X86::VFNMSUB231SDr },
  { X86::VFNMSUB231SDZr_Int, X86::VFNMSUB231SDr_Int },
  { X86::VFNMSUB231SSZm, X86::VFNMSUB231SSm },
  { X86::VFNMSUB231SSZm_Int, X86::VFNMSUB231SSm_Int },
  { X86::VFNMSUB231SSZr, X86::VFNMSUB231SSr },
  { X86::VFNMSUB231SSZr_Int, X86::VFNMSUB231SSr_Int },
  { X86::VGF2P8AFFINEINVQBZ128rmi, X86::VGF2P8AFFINEINVQBrmi },
  { X86::VGF2P8AFFINEINVQBZ128rri, X86::VGF2P8AFFINEINVQBrri },
  { X86::VGF2P8AFFINEINVQBZ256rmi, X86::VGF2P8AFFINEINVQBYrmi },
  { X86::VGF2P8AFFINEINVQBZ256rri, X86::VGF2P8AFFINEINVQBYrri },
  { X86::VGF2P8AFFINEQBZ128rmi, X86::VGF2P8AFFINEQBrmi },
  { X86::VGF2P8AFFINEQBZ128rri, X86::VGF2P8AFFINEQBrri },
  { X86::VGF2P8AFFINEQBZ256rmi, X86::VGF2P8AFFINEQBYrmi },
  { X86::VGF2P8AFFINEQBZ256rri, X86::VGF2P8AFFINEQBYrri },
  { X86::VGF2P8MULBZ128rm, X86::VGF2P8MULBrm },
  { X86::VGF2P8MULBZ128rr, X86::VGF2P8MULBrr },
  { X86::VGF2P8MULBZ256rm, X86::VGF2P8MULBYrm },
  { X86::VGF2P8MULBZ256rr, X86::VGF2P8MULBYrr },
  { X86::VINSERTF32X4Z256rmi, X86::VINSERTF128rmi },
  { X86::VINSERTF32X4Z256rri, X86::VINSERTF128rri },
  { X86::VINSERTF64X2Z256rmi, X86::VINSERTF128rmi },
  { X86::VINSERTF64X2Z256rri, X86::VINSERTF128rri },
  { X86::VINSERTI32X4Z256rmi, X86::VINSERTI128rmi },
  { X86::VINSERTI32X4Z256rri, X86::VINSERTI128rri },
  { X86::VINSERTI64X2Z256rmi, X86::VINSERTI128rmi },
  { X86::VINSERTI64X2Z256rri, X86::VINSERTI128rri },
  { X86::VINSERTPSZrmi, X86::VINSERTPSrmi },
  { X86::VINSERTPSZrri, X86::VINSERTPSrri },
  { X86::VMAXCPDZ128rm, X86::VMAXCPDrm },
  { X86::VMAXCPDZ128rr, X86::VMAXCPDrr },
  { X86::VMAXCPDZ256rm, X86::VMAXCPDYrm },
  { X86::VMAXCPDZ256rr, X86::VMAXCPDYrr },
  { X86::VMAXCPSZ128rm, X86::VMAXCPSrm },
  { X86::VMAXCPSZ128rr, X86::VMAXCPSrr },
  { X86::VMAXCPSZ256rm, X86::VMAXCPSYrm },
  { X86::VMAXCPSZ256rr, X86::VMAXCPSYrr },
  { X86::VMAXCSDZrm, X86::VMAXCSDrm },
  { X86::VMAXCSDZrr, X86::VMAXCSDrr },
  { X86::VMAXCSSZrm, X86::VMAXCSSrm },
  { X86::VMAXCSSZrr, X86::VMAXCSSrr },
  { X86::VMAXPDZ128rm, X86::VMAXPDrm },
  { X86::VMAXPDZ128rr, X86::VMAXPDrr },
  { X86::VMAXPDZ256rm, X86::VMAXPDYrm },
  { X86::VMAXPDZ256rr, X86::VMAXPDYrr },
  { X86::VMAXPSZ128rm, X86::VMAXPSrm },
  { X86::VMAXPSZ128rr, X86::VMAXPSrr },
  { X86::VMAXPSZ256rm, X86::VMAXPSYrm },
  { X86::VMAXPSZ256rr, X86::VMAXPSYrr },
  { X86::VMAXSDZrm, X86::VMAXSDrm },
  { X86::VMAXSDZrm_Int, X86::VMAXSDrm_Int },
  { X86::VMAXSDZrr, X86::VMAXSDrr },
  { X86::VMAXSDZrr_Int, X86::VMAXSDrr_Int },
  { X86::VMAXSSZrm, X86::VMAXSSrm },
  { X86::VMAXSSZrm_Int, X86::VMAXSSrm_Int },
  { X86::VMAXSSZrr, X86::VMAXSSrr },
  { X86::VMAXSSZrr_Int, X86::VMAXSSrr_Int },
  { X86::VMINCPDZ128rm, X86::VMINCPDrm },
  { X86::VMINCPDZ128rr, X86::VMINCPDrr },
  { X86::VMINCPDZ256rm, X86::VMINCPDYrm },
  { X86::VMINCPDZ256rr, X86::VMINCPDYrr },
  { X86::VMINCPSZ128rm, X86::VMINCPSrm },
  { X86::VMINCPSZ128rr, X86::VMINCPSrr },
  { X86::VMINCPSZ256rm, X86::VMINCPSYrm },
  { X86::VMINCPSZ256rr, X86::VMINCPSYrr },
  { X86::VMINCSDZrm, X86::VMINCSDrm },
  { X86::VMINCSDZrr, X86::VMINCSDrr },
  { X86::VMINCSSZrm, X86::VMINCSSrm },
  { X86::VMINCSSZrr, X86::VMINCSSrr },
  { X86::VMINPDZ128rm, X86::VMINPDrm },
  { X86::VMINPDZ128rr, X86::VMINPDrr },
  { X86::VMINPDZ256rm, X86::VMINPDYrm },
  { X86::VMINPDZ256rr, X86::VMINPDYrr },
  { X86::VMINPSZ128rm, X86::VMINPSrm },
  { X86::VMINPSZ128rr, X86::VMINPSrr },
  { X86::VMINPSZ256rm, X86::VMINPSYrm },
  { X86::VMINPSZ256rr, X86::VMINPSYrr },
  { X86::VMINSDZrm, X86::VMINSDrm },
  { X86::VMINSDZrm_Int, X86::VMINSDrm_Int },
  { X86::VMINSDZrr, X86::VMINSDrr },
  { X86::VMINSDZrr_Int, X86::VMINSDrr_Int },
  { X86::VMINSSZrm, X86::VMINSSrm },
  { X86::VMINSSZrm_Int, X86::VMINSSrm_Int },
  { X86::VMINSSZrr, X86::VMINSSrr },
  { X86::VMINSSZrr_Int, X86::VMINSSrr_Int },
  { X86::VMOV64toPQIZrm, X86::VMOV64toPQIrm },
  { X86::VMOV64toPQIZrr, X86::VMOV64toPQIrr },
  { X86::VMOV64toSDZrr, X86::VMOV64toSDrr },
  { X86::VMOVAPDZ128mr, X86::VMOVAPDmr },
  { X86::VMOVAPDZ128rm, X86::VMOVAPDrm },
  { X86::VMOVAPDZ128rr, X86::VMOVAPDrr },
  { X86::VMOVAPDZ256mr, X86::VMOVAPDYmr },
  { X86::VMOVAPDZ256rm, X86::VMOVAPDYrm },
  { X86::VMOVAPDZ256rr, X86::VMOVAPDYrr },
  { X86::VMOVAPSZ128mr, X86::VMOVAPSmr },
  { X86::VMOVAPSZ128rm, X86::VMOVAPSrm },
  { X86::VMOVAPSZ128rr, X86::VMOVAPSrr },
  { X86::VMOVAPSZ256mr, X86::VMOVAPSYmr },
  { X86::VMOVAPSZ256rm, X86::VMOVAPSYrm },
  { X86::VMOVAPSZ256rr, X86::VMOVAPSYrr },
  { X86::VMOVDDUPZ128rm, X86::VMOVDDUPrm },
  { X86::VMOVDDUPZ128rr, X86::VMOVDDUPrr },
  { X86::VMOVDDUPZ256rm, X86::VMOVDDUPYrm },
  { X86::VMOVDDUPZ256rr, X86::VMOVDDUPYrr },
  { X86::VMOVDI2PDIZrm, X86::VMOVDI2PDIrm },
  { X86::VMOVDI2PDIZrr, X86::VMOVDI2PDIrr },
  { X86::VMOVDI2SSZrr, X86::VMOVDI2SSrr },
  { X86::VMOVDQA32Z128mr, X86::VMOVDQAmr },
  { X86::VMOVDQA32Z128rm, X86::VMOVDQArm },
  { X86::VMOVDQA32Z128rr, X86::VMOVDQArr },
  { X86::VMOVDQA32Z256mr, X86::VMOVDQAYmr },
  { X86::VMOVDQA32Z256rm, X86::VMOVDQAYrm },
  { X86::VMOVDQA32Z256rr, X86::VMOVDQAYrr },
  { X86::VMOVDQA64Z128mr, X86::VMOVDQAmr },
  { X86::VMOVDQA64Z128rm, X86::VMOVDQArm },
  { X86::VMOVDQA64Z128rr, X86::VMOVDQArr },
  { X86::VMOVDQA64Z256mr, X86::VMOVDQAYmr },
  { X86::VMOVDQA64Z256rm, X86::VMOVDQAYrm },
  { X86::VMOVDQA64Z256rr, X86::VMOVDQAYrr },
  { X86::VMOVDQU16Z128mr, X86::VMOVDQUmr },
  { X86::VMOVDQU16Z128rm, X86::VMOVDQUrm },
  { X86::VMOVDQU16Z128rr, X86::VMOVDQUrr },
  { X86::VMOVDQU16Z256mr, X86::VMOVDQUYmr },
  { X86::VMOVDQU16Z256rm, X86::VMOVDQUYrm },
  { X86::VMOVDQU16Z256rr, X86::VMOVDQUYrr },
  { X86::VMOVDQU32Z128mr, X86::VMOVDQUmr },
  { X86::VMOVDQU32Z128rm, X86::VMOVDQUrm },
  { X86::VMOVDQU32Z128rr, X86::VMOVDQUrr },
  { X86::VMOVDQU32Z256mr, X86::VMOVDQUYmr },
  { X86::VMOVDQU32Z256rm, X86::VMOVDQUYrm },
  { X86::VMOVDQU32Z256rr, X86::VMOVDQUYrr },
  { X86::VMOVDQU64Z128mr, X86::VMOVDQUmr },
  { X86::VMOVDQU64Z128rm, X86::VMOVDQUrm },
  { X86::VMOVDQU64Z128rr, X86::VMOVDQUrr },
  { X86::VMOVDQU64Z256mr, X86::VMOVDQUYmr },
  { X86::VMOVDQU64Z256rm, X86::VMOVDQUYrm },
  { X86::VMOVDQU64Z256rr, X86::VMOVDQUYrr },
  { X86::VMOVDQU8Z128mr, X86::VMOVDQUmr },
  { X86::VMOVDQU8Z128rm, X86::VMOVDQUrm },
  { X86::VMOVDQU8Z128rr, X86::VMOVDQUrr },
  { X86::VMOVDQU8Z256mr, X86::VMOVDQUYmr },
  { X86::VMOVDQU8Z256rm, X86::VMOVDQUYrm },
  { X86::VMOVDQU8Z256rr, X86::VMOVDQUYrr },
  { X86::VMOVHLPSZrr, X86::VMOVHLPSrr },
  { X86::VMOVHPDZ128mr, X86::VMOVHPDmr },
  { X86::VMOVHPDZ128rm, X86::VMOVHPDrm },
  { X86::VMOVHPSZ128mr, X86::VMOVHPSmr },
  { X86::VMOVHPSZ128rm, X86::VMOVHPSrm },
  { X86::VMOVLHPSZrr, X86::VMOVLHPSrr },
  { X86::VMOVLPDZ128mr, X86::VMOVLPDmr },
  { X86::VMOVLPDZ128rm, X86::VMOVLPDrm },
  { X86::VMOVLPSZ128mr, X86::VMOVLPSmr },
  { X86::VMOVLPSZ128rm, X86::VMOVLPSrm },
  { X86::VMOVNTDQAZ128rm, X86::VMOVNTDQArm },
  { X86::VMOVNTDQAZ256rm, X86::VMOVNTDQAYrm },
  { X86::VMOVNTDQZ128mr, X86::VMOVNTDQmr },
  { X86::VMOVNTDQZ256mr, X86::VMOVNTDQYmr },
  { X86::VMOVNTPDZ128mr, X86::VMOVNTPDmr },
  { X86::VMOVNTPDZ256mr, X86::VMOVNTPDYmr },
  { X86::VMOVNTPSZ128mr, X86::VMOVNTPSmr },
  { X86::VMOVNTPSZ256mr, X86::VMOVNTPSYmr },
  { X86::VMOVPDI2DIZmr, X86::VMOVPDI2DImr },
  { X86::VMOVPDI2DIZrr, X86::VMOVPDI2DIrr },
  { X86::VMOVPQI2QIZmr, X86::VMOVPQI2QImr },
  { X86::VMOVPQI2QIZrr, X86::VMOVPQI2QIrr },
  { X86::VMOVPQIto64Zmr, X86::VMOVPQIto64mr },
  { X86::VMOVPQIto64Zrr, X86::VMOVPQIto64rr },
  { X86::VMOVQI2PQIZrm, X86::VMOVQI2PQIrm },
  { X86::VMOVSDZmr, X86::VMOVSDmr },
  { X86::VMOVSDZrm, X86::VMOVSDrm },
  { X86::VMOVSDZrm_alt, X86::VMOVSDrm_alt },
  { X86::VMOVSDZrr, X86::VMOVSDrr },
  { X86::VMOVSDto64Zrr, X86::VMOVSDto64rr },
  { X86::VMOVSHDUPZ128rm, X86::VMOVSHDUPrm },
  { X86::VMOVSHDUPZ128rr, X86::VMOVSHDUPrr },
  { X86::VMOVSHDUPZ256rm, X86::VMOVSHDUPYrm },
  { X86::VMOVSHDUPZ256rr, X86::VMOVSHDUPYrr },
  { X86::VMOVSLDUPZ128rm, X86::VMOVSLDUPrm },
  { X86::VMOVSLDUPZ128rr, X86::VMOVSLDUPrr },
  { X86::VMOVSLDUPZ256rm, X86::VMOVSLDUPYrm },
  { X86::VMOVSLDUPZ256rr, X86::VMOVSLDUPYrr },
  { X86::VMOVSS2DIZrr, X86::VMOVSS2DIrr },
  { X86::VMOVSSZmr, X86::VMOVSSmr },
  { X86::VMOVSSZrm, X86::VMOVSSrm },
  { X86::VMOVSSZrm_alt, X86::VMOVSSrm_alt },
  { X86::VMOVSSZrr, X86::VMOVSSrr },
  { X86::VMOVUPDZ128mr, X86::VMOVUPDmr },
  { X86::VMOVUPDZ128rm, X86::VMOVUPDrm },
  { X86::VMOVUPDZ128rr, X86::VMOVUPDrr },
  { X86::VMOVUPDZ256mr, X86::VMOVUPDYmr },
  { X86::VMOVUPDZ256rm, X86::VMOVUPDYrm },
  { X86::VMOVUPDZ256rr, X86::VMOVUPDYrr },
  { X86::VMOVUPSZ128mr, X86::VMOVUPSmr },
  { X86::VMOVUPSZ128rm, X86::VMOVUPSrm },
  { X86::VMOVUPSZ128rr, X86::VMOVUPSrr },
  { X86::VMOVUPSZ256mr, X86::VMOVUPSYmr },
  { X86::VMOVUPSZ256rm, X86::VMOVUPSYrm },
  { X86::VMOVUPSZ256rr, X86::VMOVUPSYrr },
  { X86::VMOVZPQILo2PQIZrr, X86::VMOVZPQILo2PQIrr },
  { X86::VMPSADBWZ128rmi, X86::VMPSADBWrmi },
  { X86::VMPSADBWZ128rri, X86::VMPSADBWrri },
  { X86::VMPSADBWZ256rmi, X86::VMPSADBWYrmi },
  { X86::VMPSADBWZ256rri, X86::VMPSADBWYrri },
  { X86::VMULPDZ128rm, X86::VMULPDrm },
  { X86::VMULPDZ128rr, X86::VMULPDrr },
  { X86::VMULPDZ256rm, X86::VMULPDYrm },
  { X86::VMULPDZ256rr, X86::VMULPDYrr },
  { X86::VMULPSZ128rm, X86::VMULPSrm },
  { X86::VMULPSZ128rr, X86::VMULPSrr },
  { X86::VMULPSZ256rm, X86::VMULPSYrm },
  { X86::VMULPSZ256rr, X86::VMULPSYrr },
  { X86::VMULSDZrm, X86::VMULSDrm },
  { X86::VMULSDZrm_Int, X86::VMULSDrm_Int },
  { X86::VMULSDZrr, X86::VMULSDrr },
  { X86::VMULSDZrr_Int, X86::VMULSDrr_Int },
  { X86::VMULSSZrm, X86::VMULSSrm },
  { X86::VMULSSZrm_Int, X86::VMULSSrm_Int },
  { X86::VMULSSZrr, X86::VMULSSrr },
  { X86::VMULSSZrr_Int, X86::VMULSSrr_Int },
  { X86::VORPDZ128rm, X86::VORPDrm },
  { X86::VORPDZ128rr, X86::VORPDrr },
  { X86::VORPDZ256rm, X86::VORPDYrm },
  { X86::VORPDZ256rr, X86::VORPDYrr },
  { X86::VORPSZ128rm, X86::VORPSrm },
  { X86::VORPSZ128rr, X86::VORPSrr },
  { X86::VORPSZ256rm, X86::VORPSYrm },
  { X86::VORPSZ256rr, X86::VORPSYrr },
  { X86::VPABSBZ128rm, X86::VPABSBrm },
  { X86::VPABSBZ128rr, X86::VPABSBrr },
  { X86::VPABSBZ256rm, X86::VPABSBYrm },
  { X86::VPABSBZ256rr, X86::VPABSBYrr },
  { X86::VPABSDZ128rm, X86::VPABSDrm },
  { X86::VPABSDZ128rr, X86::VPABSDrr },
  { X86::VPABSDZ256rm, X86::VPABSDYrm },
  { X86::VPABSDZ256rr, X86::VPABSDYrr },
  { X86::VPABSWZ128rm, X86::VPABSWrm },
  { X86::VPABSWZ128rr, X86::VPABSWrr },
  { X86::VPABSWZ256rm, X86::VPABSWYrm },
  { X86::VPABSWZ256rr, X86::VPABSWYrr },
  { X86::VPACKSSDWZ128rm, X86::VPACKSSDWrm },
  { X86::VPACKSSDWZ128rr, X86::VPACKSSDWrr },
  { X86::VPACKSSDWZ256rm, X86::VPACKSSDWYrm },
  { X86::VPACKSSDWZ256rr, X86::VPACKSSDWYrr },
  { X86::VPACKSSWBZ128rm, X86::VPACKSSWBrm },
  { X86::VPACKSSWBZ128rr, X86::VPACKSSWBrr },
  { X86::VPACKSSWBZ256rm, X86::VPACKSSWBYrm },
  { X86::VPACKSSWBZ256rr, X86::VPACKSSWBYrr },
  { X86::VPACKUSDWZ128rm, X86::VPACKUSDWrm },
  { X86::VPACKUSDWZ128rr, X86::VPACKUSDWrr },
  { X86::VPACKUSDWZ256rm, X86::VPACKUSDWYrm },
  { X86::VPACKUSDWZ256rr, X86::VPACKUSDWYrr },
  { X86::VPACKUSWBZ128rm, X86::VPACKUSWBrm },
  { X86::VPACKUSWBZ128rr, X86::VPACKUSWBrr },
  { X86::VPACKUSWBZ256rm, X86::VPACKUSWBYrm },
  { X86::VPACKUSWBZ256rr, X86::VPACKUSWBYrr },
  { X86::VPADDBZ128rm, X86::VPADDBrm },
  { X86::VPADDBZ128rr, X86::VPADDBrr },
  { X86::VPADDBZ256rm, X86::VPADDBYrm },
  { X86::VPADDBZ256rr, X86::VPADDBYrr },
  { X86::VPADDDZ128rm, X86::VPADDDrm },
  { X86::VPADDDZ128rr, X86::VPADDDrr },
  { X86::VPADDDZ256rm, X86::VPADDDYrm },
  { X86::VPADDDZ256rr, X86::VPADDDYrr },
  { X86::VPADDQZ128rm, X86::VPADDQrm },
  { X86::VPADDQZ128rr, X86::VPADDQrr },
  { X86::VPADDQZ256rm, X86::VPADDQYrm },
  { X86::VPADDQZ256rr, X86::VPADDQYrr },
  { X86::VPADDSBZ128rm, X86::VPADDSBrm },
  { X86::VPADDSBZ128rr, X86::VPADDSBrr },
  { X86::VPADDSBZ256rm, X86::VPADDSBYrm },
  { X86::VPADDSBZ256rr, X86::VPADDSBYrr },
  { X86::VPADDSWZ128rm, X86::VPADDSWrm },
  { X86::VPADDSWZ128rr, X86::VPADDSWrr },
  { X86::VPADDSWZ256rm, X86::VPADDSWYrm },
  { X86::VPADDSWZ256rr, X86::VPADDSWYrr },
  { X86::VPADDUSBZ128rm, X86::VPADDUSBrm },
  { X86::VPADDUSBZ128rr, X86::VPADDUSBrr },
  { X86::VPADDUSBZ256rm, X86::VPADDUSBYrm },
  { X86::VPADDUSBZ256rr, X86::VPADDUSBYrr },
  { X86::VPADDUSWZ128rm, X86::VPADDUSWrm },
  { X86::VPADDUSWZ128rr, X86::VPADDUSWrr },
  { X86::VPADDUSWZ256rm, X86::VPADDUSWYrm },
  { X86::VPADDUSWZ256rr, X86::VPADDUSWYrr },
  { X86::VPADDWZ128rm, X86::VPADDWrm },
  { X86::VPADDWZ128rr, X86::VPADDWrr },
  { X86::VPADDWZ256rm, X86::VPADDWYrm },
  { X86::VPADDWZ256rr, X86::VPADDWYrr },
  { X86::VPALIGNRZ128rmi, X86::VPALIGNRrmi },
  { X86::VPALIGNRZ128rri, X86::VPALIGNRrri },
  { X86::VPALIGNRZ256rmi, X86::VPALIGNRYrmi },
  { X86::VPALIGNRZ256rri, X86::VPALIGNRYrri },
  { X86::VPANDDZ128rm, X86::VPANDrm },
  { X86::VPANDDZ128rr, X86::VPANDrr },
  { X86::VPANDDZ256rm, X86::VPANDYrm },
  { X86::VPANDDZ256rr, X86::VPANDYrr },
  { X86::VPANDNDZ128rm, X86::VPANDNrm },
  { X86::VPANDNDZ128rr, X86::VPANDNrr },
  { X86::VPANDNDZ256rm, X86::VPANDNYrm },
  { X86::VPANDNDZ256rr, X86::VPANDNYrr },
  { X86::VPANDNQZ128rm, X86::VPANDNrm },
  { X86::VPANDNQZ128rr, X86::VPANDNrr },
  { X86::VPANDNQZ256rm, X86::VPANDNYrm },
  { X86::VPANDNQZ256rr, X86::VPANDNYrr },
  { X86::VPANDQZ128rm, X86::VPANDrm },
  { X86::VPANDQZ128rr, X86::VPANDrr },
  { X86::VPANDQZ256rm, X86::VPANDYrm },
  { X86::VPANDQZ256rr, X86::VPANDYrr },
  { X86::VPAVGBZ128rm, X86::VPAVGBrm },
  { X86::VPAVGBZ128rr, X86::VPAVGBrr },
  { X86::VPAVGBZ256rm, X86::VPAVGBYrm },
  { X86::VPAVGBZ256rr, X86::VPAVGBYrr },
  { X86::VPAVGWZ128rm, X86::VPAVGWrm },
  { X86::VPAVGWZ128rr, X86::VPAVGWrr },
  { X86::VPAVGWZ256rm, X86::VPAVGWYrm },
  { X86::VPAVGWZ256rr, X86::VPAVGWYrr },
  { X86::VPBROADCASTBZ128rm, X86::VPBROADCASTBrm },
  { X86::VPBROADCASTBZ128rr, X86::VPBROADCASTBrr },
  { X86::VPBROADCASTBZ256rm, X86::VPBROADCASTBYrm },
  { X86::VPBROADCASTBZ256rr, X86::VPBROADCASTBYrr },
  { X86::VPBROADCASTDZ128rm, X86::VPBROADCASTDrm },
  { X86::VPBROADCASTDZ128rr, X86::VPBROADCASTDrr },
  { X86::VPBROADCASTDZ256rm, X86::VPBROADCASTDYrm },
  { X86::VPBROADCASTDZ256rr, X86::VPBROADCASTDYrr },
  { X86::VPBROADCASTQZ128rm, X86::VPBROADCASTQrm },
  { X86::VPBROADCASTQZ128rr, X86::VPBROADCASTQrr },
  { X86::VPBROADCASTQZ256rm, X86::VPBROADCASTQYrm },
  { X86::VPBROADCASTQZ256rr, X86::VPBROADCASTQYrr },
  { X86::VPBROADCASTWZ128rm, X86::VPBROADCASTWrm },
  { X86::VPBROADCASTWZ128rr, X86::VPBROADCASTWrr },
  { X86::VPBROADCASTWZ256rm, X86::VPBROADCASTWYrm },
  { X86::VPBROADCASTWZ256rr, X86::VPBROADCASTWYrr },
  { X86::VPCLMULQDQZ128rmi, X86::VPCLMULQDQrmi },
  { X86::VPCLMULQDQZ128rri, X86::VPCLMULQDQrri },
  { X86::VPCLMULQDQZ256rmi, X86::VPCLMULQDQYrmi },
  { X86::VPCLMULQDQZ256rri, X86::VPCLMULQDQYrri },
  { X86::VPDPBSSDSZ128m, X86::VPDPBSSDSrm },
  { X86::VPDPBSSDSZ128r, X86::VPDPBSSDSrr },
  { X86::VPDPBSSDSZ256m, X86::VPDPBSSDSYrm },
  { X86::VPDPBSSDSZ256r, X86::VPDPBSSDSYrr },
  { X86::VPDPBSSDZ128m, X86::VPDPBSSDrm },
  { X86::VPDPBSSDZ128r, X86::VPDPBSSDrr },
  { X86::VPDPBSSDZ256m, X86::VPDPBSSDYrm },
  { X86::VPDPBSSDZ256r, X86::VPDPBSSDYrr },
  { X86::VPDPBSUDSZ128m, X86::VPDPBSUDSrm },
  { X86::VPDPBSUDSZ128r, X86::VPDPBSUDSrr },
  { X86::VPDPBSUDSZ256m, X86::VPDPBSUDSYrm },
  { X86::VPDPBSUDSZ256r, X86::VPDPBSUDSYrr },
  { X86::VPDPBSUDZ128m, X86::VPDPBSUDrm },
  { X86::VPDPBSUDZ128r, X86::VPDPBSUDrr },
  { X86::VPDPBSUDZ256m, X86::VPDPBSUDYrm },
  { X86::VPDPBSUDZ256r, X86::VPDPBSUDYrr },
  { X86::VPDPBUSDSZ128m, X86::VPDPBUSDSrm },
  { X86::VPDPBUSDSZ128r, X86::VPDPBUSDSrr },
  { X86::VPDPBUSDSZ256m, X86::VPDPBUSDSYrm },
  { X86::VPDPBUSDSZ256r, X86::VPDPBUSDSYrr },
  { X86::VPDPBUSDZ128m, X86::VPDPBUSDrm },
  { X86::VPDPBUSDZ128r, X86::VPDPBUSDrr },
  { X86::VPDPBUSDZ256m, X86::VPDPBUSDYrm },
  { X86::VPDPBUSDZ256r, X86::VPDPBUSDYrr },
  { X86::VPDPBUUDSZ128m, X86::VPDPBUUDSrm },
  { X86::VPDPBUUDSZ128r, X86::VPDPBUUDSrr },
  { X86::VPDPBUUDSZ256m, X86::VPDPBUUDSYrm },
  { X86::VPDPBUUDSZ256r, X86::VPDPBUUDSYrr },
  { X86::VPDPBUUDZ128m, X86::VPDPBUUDrm },
  { X86::VPDPBUUDZ128r, X86::VPDPBUUDrr },
  { X86::VPDPBUUDZ256m, X86::VPDPBUUDYrm },
  { X86::VPDPBUUDZ256r, X86::VPDPBUUDYrr },
  { X86::VPDPWSSDSZ128m, X86::VPDPWSSDSrm },
  { X86::VPDPWSSDSZ128r, X86::VPDPWSSDSrr },
  { X86::VPDPWSSDSZ256m, X86::VPDPWSSDSYrm },
  { X86::VPDPWSSDSZ256r, X86::VPDPWSSDSYrr },
  { X86::VPDPWSSDZ128m, X86::VPDPWSSDrm },
  { X86::VPDPWSSDZ128r, X86::VPDPWSSDrr },
  { X86::VPDPWSSDZ256m, X86::VPDPWSSDYrm },
  { X86::VPDPWSSDZ256r, X86::VPDPWSSDYrr },
  { X86::VPDPWSUDSZ128m, X86::VPDPWSUDSrm },
  { X86::VPDPWSUDSZ128r, X86::VPDPWSUDSrr },
  { X86::VPDPWSUDSZ256m, X86::VPDPWSUDSYrm },
  { X86::VPDPWSUDSZ256r, X86::VPDPWSUDSYrr },
  { X86::VPDPWSUDZ128m, X86::VPDPWSUDrm },
  { X86::VPDPWSUDZ128r, X86::VPDPWSUDrr },
  { X86::VPDPWSUDZ256m, X86::VPDPWSUDYrm },
  { X86::VPDPWSUDZ256r, X86::VPDPWSUDYrr },
  { X86::VPDPWUSDSZ128m, X86::VPDPWUSDSrm },
  { X86::VPDPWUSDSZ128r, X86::VPDPWUSDSrr },
  { X86::VPDPWUSDSZ256m, X86::VPDPWUSDSYrm },
  { X86::VPDPWUSDSZ256r, X86::VPDPWUSDSYrr },
  { X86::VPDPWUSDZ128m, X86::VPDPWUSDrm },
  { X86::VPDPWUSDZ128r, X86::VPDPWUSDrr },
  { X86::VPDPWUSDZ256m, X86::VPDPWUSDYrm },
  { X86::VPDPWUSDZ256r, X86::VPDPWUSDYrr },
  { X86::VPDPWUUDSZ128m, X86::VPDPWUUDSrm },
  { X86::VPDPWUUDSZ128r, X86::VPDPWUUDSrr },
  { X86::VPDPWUUDSZ256m, X86::VPDPWUUDSYrm },
  { X86::VPDPWUUDSZ256r, X86::VPDPWUUDSYrr },
  { X86::VPDPWUUDZ128m, X86::VPDPWUUDrm },
  { X86::VPDPWUUDZ128r, X86::VPDPWUUDrr },
  { X86::VPDPWUUDZ256m, X86::VPDPWUUDYrm },
  { X86::VPDPWUUDZ256r, X86::VPDPWUUDYrr },
  { X86::VPERMDZ256rm, X86::VPERMDYrm },
  { X86::VPERMDZ256rr, X86::VPERMDYrr },
  { X86::VPERMILPDZ128mi, X86::VPERMILPDmi },
  { X86::VPERMILPDZ128ri, X86::VPERMILPDri },
  { X86::VPERMILPDZ128rm, X86::VPERMILPDrm },
  { X86::VPERMILPDZ128rr, X86::VPERMILPDrr },
  { X86::VPERMILPDZ256mi, X86::VPERMILPDYmi },
  { X86::VPERMILPDZ256ri, X86::VPERMILPDYri },
  { X86::VPERMILPDZ256rm, X86::VPERMILPDYrm },
  { X86::VPERMILPDZ256rr, X86::VPERMILPDYrr },
  { X86::VPERMILPSZ128mi, X86::VPERMILPSmi },
  { X86::VPERMILPSZ128ri, X86::VPERMILPSri },
  { X86::VPERMILPSZ128rm, X86::VPERMILPSrm },
  { X86::VPERMILPSZ128rr, X86::VPERMILPSrr },
  { X86::VPERMILPSZ256mi, X86::VPERMILPSYmi },
  { X86::VPERMILPSZ256ri, X86::VPERMILPSYri },
  { X86::VPERMILPSZ256rm, X86::VPERMILPSYrm },
  { X86::VPERMILPSZ256rr, X86::VPERMILPSYrr },
  { X86::VPERMPDZ256mi, X86::VPERMPDYmi },
  { X86::VPERMPDZ256ri, X86::VPERMPDYri },
  { X86::VPERMPSZ256rm, X86::VPERMPSYrm },
  { X86::VPERMPSZ256rr, X86::VPERMPSYrr },
  { X86::VPERMQZ256mi, X86::VPERMQYmi },
  { X86::VPERMQZ256ri, X86::VPERMQYri },
  { X86::VPEXTRBZmri, X86::VPEXTRBmri },
  { X86::VPEXTRBZrri, X86::VPEXTRBrri },
  { X86::VPEXTRDZmri, X86::VPEXTRDmri },
  { X86::VPEXTRDZrri, X86::VPEXTRDrri },
  { X86::VPEXTRQZmri, X86::VPEXTRQmri },
  { X86::VPEXTRQZrri, X86::VPEXTRQrri },
  { X86::VPEXTRWZmri, X86::VPEXTRWmri },
  { X86::VPEXTRWZrri, X86::VPEXTRWrri },
  { X86::VPINSRBZrmi, X86::VPINSRBrmi },
  { X86::VPINSRBZrri, X86::VPINSRBrri },
  { X86::VPINSRDZrmi, X86::VPINSRDrmi },
  { X86::VPINSRDZrri, X86::VPINSRDrri },
  { X86::VPINSRQZrmi, X86::VPINSRQrmi },
  { X86::VPINSRQZrri, X86::VPINSRQrri },
  { X86::VPINSRWZrmi, X86::VPINSRWrmi },
  { X86::VPINSRWZrri, X86::VPINSRWrri },
  { X86::VPMADD52HUQZ128m, X86::VPMADD52HUQrm },
  { X86::VPMADD52HUQZ128r, X86::VPMADD52HUQrr },
  { X86::VPMADD52HUQZ256m, X86::VPMADD52HUQYrm },
  { X86::VPMADD52HUQZ256r, X86::VPMADD52HUQYrr },
  { X86::VPMADD52LUQZ128m, X86::VPMADD52LUQrm },
  { X86::VPMADD52LUQZ128r, X86::VPMADD52LUQrr },
  { X86::VPMADD52LUQZ256m, X86::VPMADD52LUQYrm },
  { X86::VPMADD52LUQZ256r, X86::VPMADD52LUQYrr },
  { X86::VPMADDUBSWZ128rm, X86::VPMADDUBSWrm },
  { X86::VPMADDUBSWZ128rr, X86::VPMADDUBSWrr },
  { X86::VPMADDUBSWZ256rm, X86::VPMADDUBSWYrm },
  { X86::VPMADDUBSWZ256rr, X86::VPMADDUBSWYrr },
  { X86::VPMADDWDZ128rm, X86::VPMADDWDrm },
  { X86::VPMADDWDZ128rr, X86::VPMADDWDrr },
  { X86::VPMADDWDZ256rm, X86::VPMADDWDYrm },
  { X86::VPMADDWDZ256rr, X86::VPMADDWDYrr },
  { X86::VPMAXSBZ128rm, X86::VPMAXSBrm },
  { X86::VPMAXSBZ128rr, X86::VPMAXSBrr },
  { X86::VPMAXSBZ256rm, X86::VPMAXSBYrm },
  { X86::VPMAXSBZ256rr, X86::VPMAXSBYrr },
  { X86::VPMAXSDZ128rm, X86::VPMAXSDrm },
  { X86::VPMAXSDZ128rr, X86::VPMAXSDrr },
  { X86::VPMAXSDZ256rm, X86::VPMAXSDYrm },
  { X86::VPMAXSDZ256rr, X86::VPMAXSDYrr },
  { X86::VPMAXSWZ128rm, X86::VPMAXSWrm },
  { X86::VPMAXSWZ128rr, X86::VPMAXSWrr },
  { X86::VPMAXSWZ256rm, X86::VPMAXSWYrm },
  { X86::VPMAXSWZ256rr, X86::VPMAXSWYrr },
  { X86::VPMAXUBZ128rm, X86::VPMAXUBrm },
  { X86::VPMAXUBZ128rr, X86::VPMAXUBrr },
  { X86::VPMAXUBZ256rm, X86::VPMAXUBYrm },
  { X86::VPMAXUBZ256rr, X86::VPMAXUBYrr },
  { X86::VPMAXUDZ128rm, X86::VPMAXUDrm },
  { X86::VPMAXUDZ128rr, X86::VPMAXUDrr },
  { X86::VPMAXUDZ256rm, X86::VPMAXUDYrm },
  { X86::VPMAXUDZ256rr, X86::VPMAXUDYrr },
  { X86::VPMAXUWZ128rm, X86::VPMAXUWrm },
  { X86::VPMAXUWZ128rr, X86::VPMAXUWrr },
  { X86::VPMAXUWZ256rm, X86::VPMAXUWYrm },
  { X86::VPMAXUWZ256rr, X86::VPMAXUWYrr },
  { X86::VPMINSBZ128rm, X86::VPMINSBrm },
  { X86::VPMINSBZ128rr, X86::VPMINSBrr },
  { X86::VPMINSBZ256rm, X86::VPMINSBYrm },
  { X86::VPMINSBZ256rr, X86::VPMINSBYrr },
  { X86::VPMINSDZ128rm, X86::VPMINSDrm },
  { X86::VPMINSDZ128rr, X86::VPMINSDrr },
  { X86::VPMINSDZ256rm, X86::VPMINSDYrm },
  { X86::VPMINSDZ256rr, X86::VPMINSDYrr },
  { X86::VPMINSWZ128rm, X86::VPMINSWrm },
  { X86::VPMINSWZ128rr, X86::VPMINSWrr },
  { X86::VPMINSWZ256rm, X86::VPMINSWYrm },
  { X86::VPMINSWZ256rr, X86::VPMINSWYrr },
  { X86::VPMINUBZ128rm, X86::VPMINUBrm },
  { X86::VPMINUBZ128rr, X86::VPMINUBrr },
  { X86::VPMINUBZ256rm, X86::VPMINUBYrm },
  { X86::VPMINUBZ256rr, X86::VPMINUBYrr },
  { X86::VPMINUDZ128rm, X86::VPMINUDrm },
  { X86::VPMINUDZ128rr, X86::VPMINUDrr },
  { X86::VPMINUDZ256rm, X86::VPMINUDYrm },
  { X86::VPMINUDZ256rr, X86::VPMINUDYrr },
  { X86::VPMINUWZ128rm, X86::VPMINUWrm },
  { X86::VPMINUWZ128rr, X86::VPMINUWrr },
  { X86::VPMINUWZ256rm, X86::VPMINUWYrm },
  { X86::VPMINUWZ256rr, X86::VPMINUWYrr },
  { X86::VPMOVSXBDZ128rm, X86::VPMOVSXBDrm },
  { X86::VPMOVSXBDZ128rr, X86::VPMOVSXBDrr },
  { X86::VPMOVSXBDZ256rm, X86::VPMOVSXBDYrm },
  { X86::VPMOVSXBDZ256rr, X86::VPMOVSXBDYrr },
  { X86::VPMOVSXBQZ128rm, X86::VPMOVSXBQrm },
  { X86::VPMOVSXBQZ128rr, X86::VPMOVSXBQrr },
  { X86::VPMOVSXBQZ256rm, X86::VPMOVSXBQYrm },
  { X86::VPMOVSXBQZ256rr, X86::VPMOVSXBQYrr },
  { X86::VPMOVSXBWZ128rm, X86::VPMOVSXBWrm },
  { X86::VPMOVSXBWZ128rr, X86::VPMOVSXBWrr },
  { X86::VPMOVSXBWZ256rm, X86::VPMOVSXBWYrm },
  { X86::VPMOVSXBWZ256rr, X86::VPMOVSXBWYrr },
  { X86::VPMOVSXDQZ128rm, X86::VPMOVSXDQrm },
  { X86::VPMOVSXDQZ128rr, X86::VPMOVSXDQrr },
  { X86::VPMOVSXDQZ256rm, X86::VPMOVSXDQYrm },
  { X86::VPMOVSXDQZ256rr, X86::VPMOVSXDQYrr },
  { X86::VPMOVSXWDZ128rm, X86::VPMOVSXWDrm },
  { X86::VPMOVSXWDZ128rr, X86::VPMOVSXWDrr },
  { X86::VPMOVSXWDZ256rm, X86::VPMOVSXWDYrm },
  { X86::VPMOVSXWDZ256rr, X86::VPMOVSXWDYrr },
  { X86::VPMOVSXWQZ128rm, X86::VPMOVSXWQrm },
  { X86::VPMOVSXWQZ128rr, X86::VPMOVSXWQrr },
  { X86::VPMOVSXWQZ256rm, X86::VPMOVSXWQYrm },
  { X86::VPMOVSXWQZ256rr, X86::VPMOVSXWQYrr },
  { X86::VPMOVZXBDZ128rm, X86::VPMOVZXBDrm },
  { X86::VPMOVZXBDZ128rr, X86::VPMOVZXBDrr },
  { X86::VPMOVZXBDZ256rm, X86::VPMOVZXBDYrm },
  { X86::VPMOVZXBDZ256rr, X86::VPMOVZXBDYrr },
  { X86::VPMOVZXBQZ128rm, X86::VPMOVZXBQrm },
  { X86::VPMOVZXBQZ128rr, X86::VPMOVZXBQrr },
  { X86::VPMOVZXBQZ256rm, X86::VPMOVZXBQYrm },
  { X86::VPMOVZXBQZ256rr, X86::VPMOVZXBQYrr },
  { X86::VPMOVZXBWZ128rm, X86::VPMOVZXBWrm },
  { X86::VPMOVZXBWZ128rr, X86::VPMOVZXBWrr },
  { X86::VPMOVZXBWZ256rm, X86::VPMOVZXBWYrm },
  { X86::VPMOVZXBWZ256rr, X86::VPMOVZXBWYrr },
  { X86::VPMOVZXDQZ128rm, X86::VPMOVZXDQrm },
  { X86::VPMOVZXDQZ128rr, X86::VPMOVZXDQrr },
  { X86::VPMOVZXDQZ256rm, X86::VPMOVZXDQYrm },
  { X86::VPMOVZXDQZ256rr, X86::VPMOVZXDQYrr },
  { X86::VPMOVZXWDZ128rm, X86::VPMOVZXWDrm },
  { X86::VPMOVZXWDZ128rr, X86::VPMOVZXWDrr },
  { X86::VPMOVZXWDZ256rm, X86::VPMOVZXWDYrm },
  { X86::VPMOVZXWDZ256rr, X86::VPMOVZXWDYrr },
  { X86::VPMOVZXWQZ128rm, X86::VPMOVZXWQrm },
  { X86::VPMOVZXWQZ128rr, X86::VPMOVZXWQrr },
  { X86::VPMOVZXWQZ256rm, X86::VPMOVZXWQYrm },
  { X86::VPMOVZXWQZ256rr, X86::VPMOVZXWQYrr },
  { X86::VPMULDQZ128rm, X86::VPMULDQrm },
  { X86::VPMULDQZ128rr, X86::VPMULDQrr },
  { X86::VPMULDQZ256rm, X86::VPMULDQYrm },
  { X86::VPMULDQZ256rr, X86::VPMULDQYrr },
  { X86::VPMULHRSWZ128rm, X86::VPMULHRSWrm },
  { X86::VPMULHRSWZ128rr, X86::VPMULHRSWrr },
  { X86::VPMULHRSWZ256rm, X86::VPMULHRSWYrm },
  { X86::VPMULHRSWZ256rr, X86::VPMULHRSWYrr },
  { X86::VPMULHUWZ128rm, X86::VPMULHUWrm },
  { X86::VPMULHUWZ128rr, X86::VPMULHUWrr },
  { X86::VPMULHUWZ256rm, X86::VPMULHUWYrm },
  { X86::VPMULHUWZ256rr, X86::VPMULHUWYrr },
  { X86::VPMULHWZ128rm, X86::VPMULHWrm },
  { X86::VPMULHWZ128rr, X86::VPMULHWrr },
  { X86::VPMULHWZ256rm, X86::VPMULHWYrm },
  { X86::VPMULHWZ256rr, X86::VPMULHWYrr },
  { X86::VPMULLDZ128rm, X86::VPMULLDrm },
  { X86::VPMULLDZ128rr, X86::VPMULLDrr },
  { X86::VPMULLDZ256rm, X86::VPMULLDYrm },
  { X86::VPMULLDZ256rr, X86::VPMULLDYrr },
  { X86::VPMULLWZ128rm, X86::VPMULLWrm },
  { X86::VPMULLWZ128rr, X86::VPMULLWrr },
  { X86::VPMULLWZ256rm, X86::VPMULLWYrm },
  { X86::VPMULLWZ256rr, X86::VPMULLWYrr },
  { X86::VPMULUDQZ128rm, X86::VPMULUDQrm },
  { X86::VPMULUDQZ128rr, X86::VPMULUDQrr },
  { X86::VPMULUDQZ256rm, X86::VPMULUDQYrm },
  { X86::VPMULUDQZ256rr, X86::VPMULUDQYrr },
  { X86::VPORDZ128rm, X86::VPORrm },
  { X86::VPORDZ128rr, X86::VPORrr },
  { X86::VPORDZ256rm, X86::VPORYrm },
  { X86::VPORDZ256rr, X86::VPORYrr },
  { X86::VPORQZ128rm, X86::VPORrm },
  { X86::VPORQZ128rr, X86::VPORrr },
  { X86::VPORQZ256rm, X86::VPORYrm },
  { X86::VPORQZ256rr, X86::VPORYrr },
  { X86::VPSADBWZ128rm, X86::VPSADBWrm },
  { X86::VPSADBWZ128rr, X86::VPSADBWrr },
  { X86::VPSADBWZ256rm, X86::VPSADBWYrm },
  { X86::VPSADBWZ256rr, X86::VPSADBWYrr },
  { X86::VPSHUFBZ128rm, X86::VPSHUFBrm },
  { X86::VPSHUFBZ128rr, X86::VPSHUFBrr },
  { X86::VPSHUFBZ256rm, X86::VPSHUFBYrm },
  { X86::VPSHUFBZ256rr, X86::VPSHUFBYrr },
  { X86::VPSHUFDZ128mi, X86::VPSHUFDmi },
  { X86::VPSHUFDZ128ri, X86::VPSHUFDri },
  { X86::VPSHUFDZ256mi, X86::VPSHUFDYmi },
  { X86::VPSHUFDZ256ri, X86::VPSHUFDYri },
  { X86::VPSHUFHWZ128mi, X86::VPSHUFHWmi },
  { X86::VPSHUFHWZ128ri, X86::VPSHUFHWri },
  { X86::VPSHUFHWZ256mi, X86::VPSHUFHWYmi },
  { X86::VPSHUFHWZ256ri, X86::VPSHUFHWYri },
  { X86::VPSHUFLWZ128mi, X86::VPSHUFLWmi },
  { X86::VPSHUFLWZ128ri, X86::VPSHUFLWri },
  { X86::VPSHUFLWZ256mi, X86::VPSHUFLWYmi },
  { X86::VPSHUFLWZ256ri, X86::VPSHUFLWYri },
  { X86::VPSLLDQZ128ri, X86::VPSLLDQri },
  { X86::VPSLLDQZ256ri, X86::VPSLLDQYri },
  { X86::VPSLLDZ128ri, X86::VPSLLDri },
  { X86::VPSLLDZ128rm, X86::VPSLLDrm },
  { X86::VPSLLDZ128rr, X86::VPSLLDrr },
  { X86::VPSLLDZ256ri, X86::VPSLLDYri },
  { X86::VPSLLDZ256rm, X86::VPSLLDYrm },
  { X86::VPSLLDZ256rr, X86::VPSLLDYrr },
  { X86::VPSLLQZ128ri, X86::VPSLLQri },
  { X86::VPSLLQZ128rm, X86::VPSLLQrm },
  { X86::VPSLLQZ128rr, X86::VPSLLQrr },
  { X86::VPSLLQZ256ri, X86::VPSLLQYri },
  { X86::VPSLLQZ256rm, X86::VPSLLQYrm },
  { X86::VPSLLQZ256rr, X86::VPSLLQYrr },
  { X86::VPSLLVDZ128rm, X86::VPSLLVDrm },
  { X86::VPSLLVDZ128rr, X86::VPSLLVDrr },
  { X86::VPSLLVDZ256rm, X86::VPSLLVDYrm },
  { X86::VPSLLVDZ256rr, X86::VPSLLVDYrr },
  { X86::VPSLLVQZ128rm, X86::VPSLLVQrm },
  { X86::VPSLLVQZ128rr, X86::VPSLLVQrr },
  { X86::VPSLLVQZ256rm, X86::VPSLLVQYrm },
  { X86::VPSLLVQZ256rr, X86::VPSLLVQYrr },
  { X86::VPSLLWZ128ri, X86::VPSLLWri },
  { X86::VPSLLWZ128rm, X86::VPSLLWrm },
  { X86::VPSLLWZ128rr, X86::VPSLLWrr },
  { X86::VPSLLWZ256ri, X86::VPSLLWYri },
  { X86::VPSLLWZ256rm, X86::VPSLLWYrm },
  { X86::VPSLLWZ256rr, X86::VPSLLWYrr },
  { X86::VPSRADZ128ri, X86::VPSRADri },
  { X86::VPSRADZ128rm, X86::VPSRADrm },
  { X86::VPSRADZ128rr, X86::VPSRADrr },
  { X86::VPSRADZ256ri, X86::VPSRADYri },
  { X86::VPSRADZ256rm, X86::VPSRADYrm },
  { X86::VPSRADZ256rr, X86::VPSRADYrr },
  { X86::VPSRAVDZ128rm, X86::VPSRAVDrm },
  { X86::VPSRAVDZ128rr, X86::VPSRAVDrr },
  { X86::VPSRAVDZ256rm, X86::VPSRAVDYrm },
  { X86::VPSRAVDZ256rr, X86::VPSRAVDYrr },
  { X86::VPSRAWZ128ri, X86::VPSRAWri },
  { X86::VPSRAWZ128rm, X86::VPSRAWrm },
  { X86::VPSRAWZ128rr, X86::VPSRAWrr },
  { X86::VPSRAWZ256ri, X86::VPSRAWYri },
  { X86::VPSRAWZ256rm, X86::VPSRAWYrm },
  { X86::VPSRAWZ256rr, X86::VPSRAWYrr },
  { X86::VPSRLDQZ128ri, X86::VPSRLDQri },
  { X86::VPSRLDQZ256ri, X86::VPSRLDQYri },
  { X86::VPSRLDZ128ri, X86::VPSRLDri },
  { X86::VPSRLDZ128rm, X86::VPSRLDrm },
  { X86::VPSRLDZ128rr, X86::VPSRLDrr },
  { X86::VPSRLDZ256ri, X86::VPSRLDYri },
  { X86::VPSRLDZ256rm, X86::VPSRLDYrm },
  { X86::VPSRLDZ256rr, X86::VPSRLDYrr },
  { X86::VPSRLQZ128ri, X86::VPSRLQri },
  { X86::VPSRLQZ128rm, X86::VPSRLQrm },
  { X86::VPSRLQZ128rr, X86::VPSRLQrr },
  { X86::VPSRLQZ256ri, X86::VPSRLQYri },
  { X86::VPSRLQZ256rm, X86::VPSRLQYrm },
  { X86::VPSRLQZ256rr, X86::VPSRLQYrr },
  { X86::VPSRLVDZ128rm, X86::VPSRLVDrm },
  { X86::VPSRLVDZ128rr, X86::VPSRLVDrr },
  { X86::VPSRLVDZ256rm, X86::VPSRLVDYrm },
  { X86::VPSRLVDZ256rr, X86::VPSRLVDYrr },
  { X86::VPSRLVQZ128rm, X86::VPSRLVQrm },
  { X86::VPSRLVQZ128rr, X86::VPSRLVQrr },
  { X86::VPSRLVQZ256rm, X86::VPSRLVQYrm },
  { X86::VPSRLVQZ256rr, X86::VPSRLVQYrr },
  { X86::VPSRLWZ128ri, X86::VPSRLWri },
  { X86::VPSRLWZ128rm, X86::VPSRLWrm },
  { X86::VPSRLWZ128rr, X86::VPSRLWrr },
  { X86::VPSRLWZ256ri, X86::VPSRLWYri },
  { X86::VPSRLWZ256rm, X86::VPSRLWYrm },
  { X86::VPSRLWZ256rr, X86::VPSRLWYrr },
  { X86::VPSUBBZ128rm, X86::VPSUBBrm },
  { X86::VPSUBBZ128rr, X86::VPSUBBrr },
  { X86::VPSUBBZ256rm, X86::VPSUBBYrm },
  { X86::VPSUBBZ256rr, X86::VPSUBBYrr },
  { X86::VPSUBDZ128rm, X86::VPSUBDrm },
  { X86::VPSUBDZ128rr, X86::VPSUBDrr },
  { X86::VPSUBDZ256rm, X86::VPSUBDYrm },
  { X86::VPSUBDZ256rr, X86::VPSUBDYrr },
  { X86::VPSUBQZ128rm, X86::VPSUBQrm },
  { X86::VPSUBQZ128rr, X86::VPSUBQrr },
  { X86::VPSUBQZ256rm, X86::VPSUBQYrm },
  { X86::VPSUBQZ256rr, X86::VPSUBQYrr },
  { X86::VPSUBSBZ128rm, X86::VPSUBSBrm },
  { X86::VPSUBSBZ128rr, X86::VPSUBSBrr },
  { X86::VPSUBSBZ256rm, X86::VPSUBSBYrm },
  { X86::VPSUBSBZ256rr, X86::VPSUBSBYrr },
  { X86::VPSUBSWZ128rm, X86::VPSUBSWrm },
  { X86::VPSUBSWZ128rr, X86::VPSUBSWrr },
  { X86::VPSUBSWZ256rm, X86::VPSUBSWYrm },
  { X86::VPSUBSWZ256rr, X86::VPSUBSWYrr },
  { X86::VPSUBUSBZ128rm, X86::VPSUBUSBrm },
  { X86::VPSUBUSBZ128rr, X86::VPSUBUSBrr },
  { X86::VPSUBUSBZ256rm, X86::VPSUBUSBYrm },
  { X86::VPSUBUSBZ256rr, X86::VPSUBUSBYrr },
  { X86::VPSUBUSWZ128rm, X86::VPSUBUSWrm },
  { X86::VPSUBUSWZ128rr, X86::VPSUBUSWrr },
  { X86::VPSUBUSWZ256rm, X86::VPSUBUSWYrm },
  { X86::VPSUBUSWZ256rr, X86::VPSUBUSWYrr },
  { X86::VPSUBWZ128rm, X86::VPSUBWrm },
  { X86::VPSUBWZ128rr, X86::VPSUBWrr },
  { X86::VPSUBWZ256rm, X86::VPSUBWYrm },
  { X86::VPSUBWZ256rr, X86::VPSUBWYrr },
  { X86::VPUNPCKHBWZ128rm, X86::VPUNPCKHBWrm },
  { X86::VPUNPCKHBWZ128rr, X86::VPUNPCKHBWrr },
  { X86::VPUNPCKHBWZ256rm, X86::VPUNPCKHBWYrm },
  { X86::VPUNPCKHBWZ256rr, X86::VPUNPCKHBWYrr },
  { X86::VPUNPCKHDQZ128rm, X86::VPUNPCKHDQrm },
  { X86::VPUNPCKHDQZ128rr, X86::VPUNPCKHDQrr },
  { X86::VPUNPCKHDQZ256rm, X86::VPUNPCKHDQYrm },
  { X86::VPUNPCKHDQZ256rr, X86::VPUNPCKHDQYrr },
  { X86::VPUNPCKHQDQZ128rm, X86::VPUNPCKHQDQrm },
  { X86::VPUNPCKHQDQZ128rr, X86::VPUNPCKHQDQrr },
  { X86::VPUNPCKHQDQZ256rm, X86::VPUNPCKHQDQYrm },
  { X86::VPUNPCKHQDQZ256rr, X86::VPUNPCKHQDQYrr },
  { X86::VPUNPCKHWDZ128rm, X86::VPUNPCKHWDrm },
  { X86::VPUNPCKHWDZ128rr, X86::VPUNPCKHWDrr },
  { X86::VPUNPCKHWDZ256rm, X86::VPUNPCKHWDYrm },
  { X86::VPUNPCKHWDZ256rr, X86::VPUNPCKHWDYrr },
  { X86::VPUNPCKLBWZ128rm, X86::VPUNPCKLBWrm },
  { X86::VPUNPCKLBWZ128rr, X86::VPUNPCKLBWrr },
  { X86::VPUNPCKLBWZ256rm, X86::VPUNPCKLBWYrm },
  { X86::VPUNPCKLBWZ256rr, X86::VPUNPCKLBWYrr },
  { X86::VPUNPCKLDQZ128rm, X86::VPUNPCKLDQrm },
  { X86::VPUNPCKLDQZ128rr, X86::VPUNPCKLDQrr },
  { X86::VPUNPCKLDQZ256rm, X86::VPUNPCKLDQYrm },
  { X86::VPUNPCKLDQZ256rr, X86::VPUNPCKLDQYrr },
  { X86::VPUNPCKLQDQZ128rm, X86::VPUNPCKLQDQrm },
  { X86::VPUNPCKLQDQZ128rr, X86::VPUNPCKLQDQrr },
  { X86::VPUNPCKLQDQZ256rm, X86::VPUNPCKLQDQYrm },
  { X86::VPUNPCKLQDQZ256rr, X86::VPUNPCKLQDQYrr },
  { X86::VPUNPCKLWDZ128rm, X86::VPUNPCKLWDrm },
  { X86::VPUNPCKLWDZ128rr, X86::VPUNPCKLWDrr },
  { X86::VPUNPCKLWDZ256rm, X86::VPUNPCKLWDYrm },
  { X86::VPUNPCKLWDZ256rr, X86::VPUNPCKLWDYrr },
  { X86::VPXORDZ128rm, X86::VPXORrm },
  { X86::VPXORDZ128rr, X86::VPXORrr },
  { X86::VPXORDZ256rm, X86::VPXORYrm },
  { X86::VPXORDZ256rr, X86::VPXORYrr },
  { X86::VPXORQZ128rm, X86::VPXORrm },
  { X86::VPXORQZ128rr, X86::VPXORrr },
  { X86::VPXORQZ256rm, X86::VPXORYrm },
  { X86::VPXORQZ256rr, X86::VPXORYrr },
  { X86::VRNDSCALEPDZ128rmi, X86::VROUNDPDmi },
  { X86::VRNDSCALEPDZ128rri, X86::VROUNDPDri },
  { X86::VRNDSCALEPDZ256rmi, X86::VROUNDPDYmi },
  { X86::VRNDSCALEPDZ256rri, X86::VROUNDPDYri },
  { X86::VRNDSCALEPSZ128rmi, X86::VROUNDPSmi },
  { X86::VRNDSCALEPSZ128rri, X86::VROUNDPSri },
  { X86::VRNDSCALEPSZ256rmi, X86::VROUNDPSYmi },
  { X86::VRNDSCALEPSZ256rri, X86::VROUNDPSYri },
  { X86::VRNDSCALESDZrmi, X86::VROUNDSDmi },
  { X86::VRNDSCALESDZrmi_Int, X86::VROUNDSDmi_Int },
  { X86::VRNDSCALESDZrri, X86::VROUNDSDri },
  { X86::VRNDSCALESDZrri_Int, X86::VROUNDSDri_Int },
  { X86::VRNDSCALESSZrmi, X86::VROUNDSSmi },
  { X86::VRNDSCALESSZrmi_Int, X86::VROUNDSSmi_Int },
  { X86::VRNDSCALESSZrri, X86::VROUNDSSri },
  { X86::VRNDSCALESSZrri_Int, X86::VROUNDSSri_Int },
  { X86::VSHUFF32X4Z256rmi, X86::VPERM2F128rmi },
  { X86::VSHUFF32X4Z256rri, X86::VPERM2F128rri },
  { X86::VSHUFF64X2Z256rmi, X86::VPERM2F128rmi },
  { X86::VSHUFF64X2Z256rri, X86::VPERM2F128rri },
  { X86::VSHUFI32X4Z256rmi, X86::VPERM2I128rmi },
  { X86::VSHUFI32X4Z256rri, X86::VPERM2I128rri },
  { X86::VSHUFI64X2Z256rmi, X86::VPERM2I128rmi },
  { X86::VSHUFI64X2Z256rri, X86::VPERM2I128rri },
  { X86::VSHUFPDZ128rmi, X86::VSHUFPDrmi },
  { X86::VSHUFPDZ128rri, X86::VSHUFPDrri },
  { X86::VSHUFPDZ256rmi, X86::VSHUFPDYrmi },
  { X86::VSHUFPDZ256rri, X86::VSHUFPDYrri },
  { X86::VSHUFPSZ128rmi, X86::VSHUFPSrmi },
  { X86::VSHUFPSZ128rri, X86::VSHUFPSrri },
  { X86::VSHUFPSZ256rmi, X86::VSHUFPSYrmi },
  { X86::VSHUFPSZ256rri, X86::VSHUFPSYrri },
  { X86::VSM4KEY4Z128rm, X86::VSM4KEY4rm },
  { X86::VSM4KEY4Z128rr, X86::VSM4KEY4rr },
  { X86::VSM4KEY4Z256rm, X86::VSM4KEY4Yrm },
  { X86::VSM4KEY4Z256rr, X86::VSM4KEY4Yrr },
  { X86::VSM4RNDS4Z128rm, X86::VSM4RNDS4rm },
  { X86::VSM4RNDS4Z128rr, X86::VSM4RNDS4rr },
  { X86::VSM4RNDS4Z256rm, X86::VSM4RNDS4Yrm },
  { X86::VSM4RNDS4Z256rr, X86::VSM4RNDS4Yrr },
  { X86::VSQRTPDZ128m, X86::VSQRTPDm },
  { X86::VSQRTPDZ128r, X86::VSQRTPDr },
  { X86::VSQRTPDZ256m, X86::VSQRTPDYm },
  { X86::VSQRTPDZ256r, X86::VSQRTPDYr },
  { X86::VSQRTPSZ128m, X86::VSQRTPSm },
  { X86::VSQRTPSZ128r, X86::VSQRTPSr },
  { X86::VSQRTPSZ256m, X86::VSQRTPSYm },
  { X86::VSQRTPSZ256r, X86::VSQRTPSYr },
  { X86::VSQRTSDZm, X86::VSQRTSDm },
  { X86::VSQRTSDZm_Int, X86::VSQRTSDm_Int },
  { X86::VSQRTSDZr, X86::VSQRTSDr },
  { X86::VSQRTSDZr_Int, X86::VSQRTSDr_Int },
  { X86::VSQRTSSZm, X86::VSQRTSSm },
  { X86::VSQRTSSZm_Int, X86::VSQRTSSm_Int },
  { X86::VSQRTSSZr, X86::VSQRTSSr },
  { X86::VSQRTSSZr_Int, X86::VSQRTSSr_Int },
  { X86::VSUBPDZ128rm, X86::VSUBPDrm },
  { X86::VSUBPDZ128rr, X86::VSUBPDrr },
  { X86::VSUBPDZ256rm, X86::VSUBPDYrm },
  { X86::VSUBPDZ256rr, X86::VSUBPDYrr },
  { X86::VSUBPSZ128rm, X86::VSUBPSrm },
  { X86::VSUBPSZ128rr, X86::VSUBPSrr },
  { X86::VSUBPSZ256rm, X86::VSUBPSYrm },
  { X86::VSUBPSZ256rr, X86::VSUBPSYrr },
  { X86::VSUBSDZrm, X86::VSUBSDrm },
  { X86::VSUBSDZrm_Int, X86::VSUBSDrm_Int },
  { X86::VSUBSDZrr, X86::VSUBSDrr },
  { X86::VSUBSDZrr_Int, X86::VSUBSDrr_Int },
  { X86::VSUBSSZrm, X86::VSUBSSrm },
  { X86::VSUBSSZrm_Int, X86::VSUBSSrm_Int },
  { X86::VSUBSSZrr, X86::VSUBSSrr },
  { X86::VSUBSSZrr_Int, X86::VSUBSSrr_Int },
  { X86::VUCOMISDZrm, X86::VUCOMISDrm },
  { X86::VUCOMISDZrm_Int, X86::VUCOMISDrm_Int },
  { X86::VUCOMISDZrr, X86::VUCOMISDrr },
  { X86::VUCOMISDZrr_Int, X86::VUCOMISDrr_Int },
  { X86::VUCOMISSZrm, X86::VUCOMISSrm },
  { X86::VUCOMISSZrm_Int, X86::VUCOMISSrm_Int },
  { X86::VUCOMISSZrr, X86::VUCOMISSrr },
  { X86::VUCOMISSZrr_Int, X86::VUCOMISSrr_Int },
  { X86::VUNPCKHPDZ128rm, X86::VUNPCKHPDrm },
  { X86::VUNPCKHPDZ128rr, X86::VUNPCKHPDrr },
  { X86::VUNPCKHPDZ256rm, X86::VUNPCKHPDYrm },
  { X86::VUNPCKHPDZ256rr, X86::VUNPCKHPDYrr },
  { X86::VUNPCKHPSZ128rm, X86::VUNPCKHPSrm },
  { X86::VUNPCKHPSZ128rr, X86::VUNPCKHPSrr },
  { X86::VUNPCKHPSZ256rm, X86::VUNPCKHPSYrm },
  { X86::VUNPCKHPSZ256rr, X86::VUNPCKHPSYrr },
  { X86::VUNPCKLPDZ128rm, X86::VUNPCKLPDrm },
  { X86::VUNPCKLPDZ128rr, X86::VUNPCKLPDrr },
  { X86::VUNPCKLPDZ256rm, X86::VUNPCKLPDYrm },
  { X86::VUNPCKLPDZ256rr, X86::VUNPCKLPDYrr },
  { X86::VUNPCKLPSZ128rm, X86::VUNPCKLPSrm },
  { X86::VUNPCKLPSZ128rr, X86::VUNPCKLPSrr },
  { X86::VUNPCKLPSZ256rm, X86::VUNPCKLPSYrm },
  { X86::VUNPCKLPSZ256rr, X86::VUNPCKLPSYrr },
  { X86::VXORPDZ128rm, X86::VXORPDrm },
  { X86::VXORPDZ128rr, X86::VXORPDrr },
  { X86::VXORPDZ256rm, X86::VXORPDYrm },
  { X86::VXORPDZ256rr, X86::VXORPDYrr },
  { X86::VXORPSZ128rm, X86::VXORPSrm },
  { X86::VXORPSZ128rr, X86::VXORPSrr },
  { X86::VXORPSZ256rm, X86::VXORPSYrm },
  { X86::VXORPSZ256rr, X86::VXORPSYrr },
  { X86::WRMSRNSir_EVEX, X86::WRMSRNSir },
  { X86::WRSSD_EVEX, X86::WRSSD },
  { X86::WRSSQ_EVEX, X86::WRSSQ },
  { X86::WRUSSD_EVEX, X86::WRUSSD },
  { X86::WRUSSQ_EVEX, X86::WRUSSQ },
};

#endif // GET_X86_COMPRESS_EVEX_TABLE


#ifdef GET_X86_COMPRESS_EVEX_TABLE
static bool checkPredicate(unsigned Opc, const X86Subtarget *Subtarget) {
  switch (Opc) {
  default: return true;
  case X86::VPMADD52HUQrm:
  case X86::VPMADD52HUQrr:
  case X86::VPMADD52HUQYrm:
  case X86::VPMADD52HUQYrr:
  case X86::VPMADD52LUQrm:
  case X86::VPMADD52LUQrr:
  case X86::VPMADD52LUQYrm:
  case X86::VPMADD52LUQYrr:
    return Subtarget->hasAVXIFMA();
  case X86::VCVTNEPS2BF16rm:
  case X86::VCVTNEPS2BF16rr:
  case X86::VCVTNEPS2BF16Yrm:
  case X86::VCVTNEPS2BF16Yrr:
    return Subtarget->hasAVXNECONVERT();
  case X86::VPDPBUSDSrm:
  case X86::VPDPBUSDSrr:
  case X86::VPDPBUSDSYrm:
  case X86::VPDPBUSDSYrr:
  case X86::VPDPBUSDrm:
  case X86::VPDPBUSDrr:
  case X86::VPDPBUSDYrm:
  case X86::VPDPBUSDYrr:
  case X86::VPDPWSSDSrm:
  case X86::VPDPWSSDSrr:
  case X86::VPDPWSSDSYrm:
  case X86::VPDPWSSDSYrr:
  case X86::VPDPWSSDrm:
  case X86::VPDPWSSDrr:
  case X86::VPDPWSSDYrm:
  case X86::VPDPWSSDYrr:
    return Subtarget->hasAVXVNNI();
  case X86::VPDPWSUDSrm:
  case X86::VPDPWSUDSrr:
  case X86::VPDPWSUDSYrm:
  case X86::VPDPWSUDSYrr:
  case X86::VPDPWSUDrm:
  case X86::VPDPWSUDrr:
  case X86::VPDPWSUDYrm:
  case X86::VPDPWSUDYrr:
  case X86::VPDPWUSDSrm:
  case X86::VPDPWUSDSrr:
  case X86::VPDPWUSDSYrm:
  case X86::VPDPWUSDSYrr:
  case X86::VPDPWUSDrm:
  case X86::VPDPWUSDrr:
  case X86::VPDPWUSDYrm:
  case X86::VPDPWUSDYrr:
  case X86::VPDPWUUDSrm:
  case X86::VPDPWUUDSrr:
  case X86::VPDPWUUDSYrm:
  case X86::VPDPWUUDSYrr:
  case X86::VPDPWUUDrm:
  case X86::VPDPWUUDrr:
  case X86::VPDPWUUDYrm:
  case X86::VPDPWUUDYrr:
    return Subtarget->hasAVXVNNIINT16();
  case X86::VPDPBSSDSrm:
  case X86::VPDPBSSDSrr:
  case X86::VPDPBSSDSYrm:
  case X86::VPDPBSSDSYrr:
  case X86::VPDPBSSDrm:
  case X86::VPDPBSSDrr:
  case X86::VPDPBSSDYrm:
  case X86::VPDPBSSDYrr:
  case X86::VPDPBSUDSrm:
  case X86::VPDPBSUDSrr:
  case X86::VPDPBSUDSYrm:
  case X86::VPDPBSUDSYrr:
  case X86::VPDPBSUDrm:
  case X86::VPDPBSUDrr:
  case X86::VPDPBSUDYrm:
  case X86::VPDPBSUDYrr:
  case X86::VPDPBUUDSrm:
  case X86::VPDPBUUDSrr:
  case X86::VPDPBUUDSYrm:
  case X86::VPDPBUUDSYrr:
  case X86::VPDPBUUDrm:
  case X86::VPDPBUUDrr:
  case X86::VPDPBUUDYrm:
  case X86::VPDPBUUDYrr:
    return Subtarget->hasAVXVNNIINT8();
  }
}

#endif // GET_X86_COMPRESS_EVEX_TABLE


#ifdef GET_X86_NF_TRANSFORM_TABLE
static const X86TableEntry X86NFTransformTable[] = {
  { X86::ADD16mi8, X86::ADD16mi8_NF },
  { X86::ADD16mi8_ND, X86::ADD16mi8_NF_ND },
  { X86::ADD16mi, X86::ADD16mi_NF },
  { X86::ADD16mi_ND, X86::ADD16mi_NF_ND },
  { X86::ADD16mr, X86::ADD16mr_NF },
  { X86::ADD16mr_ND, X86::ADD16mr_NF_ND },
  { X86::ADD16ri8, X86::ADD16ri8_NF },
  { X86::ADD16ri8_ND, X86::ADD16ri8_NF_ND },
  { X86::ADD16ri, X86::ADD16ri_NF },
  { X86::ADD16ri_ND, X86::ADD16ri_NF_ND },
  { X86::ADD16rm, X86::ADD16rm_NF },
  { X86::ADD16rm_ND, X86::ADD16rm_NF_ND },
  { X86::ADD16rr, X86::ADD16rr_NF },
  { X86::ADD16rr_ND, X86::ADD16rr_NF_ND },
  { X86::ADD32mi8, X86::ADD32mi8_NF },
  { X86::ADD32mi8_ND, X86::ADD32mi8_NF_ND },
  { X86::ADD32mi, X86::ADD32mi_NF },
  { X86::ADD32mi_ND, X86::ADD32mi_NF_ND },
  { X86::ADD32mr, X86::ADD32mr_NF },
  { X86::ADD32mr_ND, X86::ADD32mr_NF_ND },
  { X86::ADD32ri8, X86::ADD32ri8_NF },
  { X86::ADD32ri8_ND, X86::ADD32ri8_NF_ND },
  { X86::ADD32ri, X86::ADD32ri_NF },
  { X86::ADD32ri_ND, X86::ADD32ri_NF_ND },
  { X86::ADD32rm, X86::ADD32rm_NF },
  { X86::ADD32rm_ND, X86::ADD32rm_NF_ND },
  { X86::ADD32rr, X86::ADD32rr_NF },
  { X86::ADD32rr_ND, X86::ADD32rr_NF_ND },
  { X86::ADD64mi32, X86::ADD64mi32_NF },
  { X86::ADD64mi32_ND, X86::ADD64mi32_NF_ND },
  { X86::ADD64mi8, X86::ADD64mi8_NF },
  { X86::ADD64mi8_ND, X86::ADD64mi8_NF_ND },
  { X86::ADD64mr, X86::ADD64mr_NF },
  { X86::ADD64mr_ND, X86::ADD64mr_NF_ND },
  { X86::ADD64ri32, X86::ADD64ri32_NF },
  { X86::ADD64ri32_ND, X86::ADD64ri32_NF_ND },
  { X86::ADD64ri8, X86::ADD64ri8_NF },
  { X86::ADD64ri8_ND, X86::ADD64ri8_NF_ND },
  { X86::ADD64rm, X86::ADD64rm_NF },
  { X86::ADD64rm_ND, X86::ADD64rm_NF_ND },
  { X86::ADD64rr, X86::ADD64rr_NF },
  { X86::ADD64rr_ND, X86::ADD64rr_NF_ND },
  { X86::ADD8mi, X86::ADD8mi_NF },
  { X86::ADD8mi_ND, X86::ADD8mi_NF_ND },
  { X86::ADD8mr, X86::ADD8mr_NF },
  { X86::ADD8mr_ND, X86::ADD8mr_NF_ND },
  { X86::ADD8ri, X86::ADD8ri_NF },
  { X86::ADD8ri_ND, X86::ADD8ri_NF_ND },
  { X86::ADD8rm, X86::ADD8rm_NF },
  { X86::ADD8rm_ND, X86::ADD8rm_NF_ND },
  { X86::ADD8rr, X86::ADD8rr_NF },
  { X86::ADD8rr_ND, X86::ADD8rr_NF_ND },
  { X86::AND16mi8, X86::AND16mi8_NF },
  { X86::AND16mi8_ND, X86::AND16mi8_NF_ND },
  { X86::AND16mi, X86::AND16mi_NF },
  { X86::AND16mi_ND, X86::AND16mi_NF_ND },
  { X86::AND16mr, X86::AND16mr_NF },
  { X86::AND16mr_ND, X86::AND16mr_NF_ND },
  { X86::AND16ri8, X86::AND16ri8_NF },
  { X86::AND16ri8_ND, X86::AND16ri8_NF_ND },
  { X86::AND16ri, X86::AND16ri_NF },
  { X86::AND16ri_ND, X86::AND16ri_NF_ND },
  { X86::AND16rm, X86::AND16rm_NF },
  { X86::AND16rm_ND, X86::AND16rm_NF_ND },
  { X86::AND16rr, X86::AND16rr_NF },
  { X86::AND16rr_ND, X86::AND16rr_NF_ND },
  { X86::AND32mi8, X86::AND32mi8_NF },
  { X86::AND32mi8_ND, X86::AND32mi8_NF_ND },
  { X86::AND32mi, X86::AND32mi_NF },
  { X86::AND32mi_ND, X86::AND32mi_NF_ND },
  { X86::AND32mr, X86::AND32mr_NF },
  { X86::AND32mr_ND, X86::AND32mr_NF_ND },
  { X86::AND32ri8, X86::AND32ri8_NF },
  { X86::AND32ri8_ND, X86::AND32ri8_NF_ND },
  { X86::AND32ri, X86::AND32ri_NF },
  { X86::AND32ri_ND, X86::AND32ri_NF_ND },
  { X86::AND32rm, X86::AND32rm_NF },
  { X86::AND32rm_ND, X86::AND32rm_NF_ND },
  { X86::AND32rr, X86::AND32rr_NF },
  { X86::AND32rr_ND, X86::AND32rr_NF_ND },
  { X86::AND64mi32, X86::AND64mi32_NF },
  { X86::AND64mi32_ND, X86::AND64mi32_NF_ND },
  { X86::AND64mi8, X86::AND64mi8_NF },
  { X86::AND64mi8_ND, X86::AND64mi8_NF_ND },
  { X86::AND64mr, X86::AND64mr_NF },
  { X86::AND64mr_ND, X86::AND64mr_NF_ND },
  { X86::AND64ri32, X86::AND64ri32_NF },
  { X86::AND64ri32_ND, X86::AND64ri32_NF_ND },
  { X86::AND64ri8, X86::AND64ri8_NF },
  { X86::AND64ri8_ND, X86::AND64ri8_NF_ND },
  { X86::AND64rm, X86::AND64rm_NF },
  { X86::AND64rm_ND, X86::AND64rm_NF_ND },
  { X86::AND64rr, X86::AND64rr_NF },
  { X86::AND64rr_ND, X86::AND64rr_NF_ND },
  { X86::AND8mi, X86::AND8mi_NF },
  { X86::AND8mi_ND, X86::AND8mi_NF_ND },
  { X86::AND8mr, X86::AND8mr_NF },
  { X86::AND8mr_ND, X86::AND8mr_NF_ND },
  { X86::AND8ri, X86::AND8ri_NF },
  { X86::AND8ri_ND, X86::AND8ri_NF_ND },
  { X86::AND8rm, X86::AND8rm_NF },
  { X86::AND8rm_ND, X86::AND8rm_NF_ND },
  { X86::AND8rr, X86::AND8rr_NF },
  { X86::AND8rr_ND, X86::AND8rr_NF_ND },
  { X86::ANDN32rm, X86::ANDN32rm_NF },
  { X86::ANDN32rr, X86::ANDN32rr_NF },
  { X86::ANDN64rm, X86::ANDN64rm_NF },
  { X86::ANDN64rr, X86::ANDN64rr_NF },
  { X86::BEXTR32rm, X86::BEXTR32rm_NF },
  { X86::BEXTR32rr, X86::BEXTR32rr_NF },
  { X86::BEXTR64rm, X86::BEXTR64rm_NF },
  { X86::BEXTR64rr, X86::BEXTR64rr_NF },
  { X86::BLSI32rm, X86::BLSI32rm_NF },
  { X86::BLSI32rr, X86::BLSI32rr_NF },
  { X86::BLSI64rm, X86::BLSI64rm_NF },
  { X86::BLSI64rr, X86::BLSI64rr_NF },
  { X86::BLSMSK32rm, X86::BLSMSK32rm_NF },
  { X86::BLSMSK32rr, X86::BLSMSK32rr_NF },
  { X86::BLSMSK64rm, X86::BLSMSK64rm_NF },
  { X86::BLSMSK64rr, X86::BLSMSK64rr_NF },
  { X86::BLSR32rm, X86::BLSR32rm_NF },
  { X86::BLSR32rr, X86::BLSR32rr_NF },
  { X86::BLSR64rm, X86::BLSR64rm_NF },
  { X86::BLSR64rr, X86::BLSR64rr_NF },
  { X86::BZHI32rm, X86::BZHI32rm_NF },
  { X86::BZHI32rr, X86::BZHI32rr_NF },
  { X86::BZHI64rm, X86::BZHI64rm_NF },
  { X86::BZHI64rr, X86::BZHI64rr_NF },
  { X86::DEC16m, X86::DEC16m_NF },
  { X86::DEC16m_ND, X86::DEC16m_NF_ND },
  { X86::DEC16r, X86::DEC16r_NF },
  { X86::DEC16r_ND, X86::DEC16r_NF_ND },
  { X86::DEC32m, X86::DEC32m_NF },
  { X86::DEC32m_ND, X86::DEC32m_NF_ND },
  { X86::DEC32r, X86::DEC32r_NF },
  { X86::DEC32r_ND, X86::DEC32r_NF_ND },
  { X86::DEC64m, X86::DEC64m_NF },
  { X86::DEC64m_ND, X86::DEC64m_NF_ND },
  { X86::DEC64r, X86::DEC64r_NF },
  { X86::DEC64r_ND, X86::DEC64r_NF_ND },
  { X86::DEC8m, X86::DEC8m_NF },
  { X86::DEC8m_ND, X86::DEC8m_NF_ND },
  { X86::DEC8r, X86::DEC8r_NF },
  { X86::DEC8r_ND, X86::DEC8r_NF_ND },
  { X86::DIV16m, X86::DIV16m_NF },
  { X86::DIV16r, X86::DIV16r_NF },
  { X86::DIV32m, X86::DIV32m_NF },
  { X86::DIV32r, X86::DIV32r_NF },
  { X86::DIV64m, X86::DIV64m_NF },
  { X86::DIV64r, X86::DIV64r_NF },
  { X86::DIV8m, X86::DIV8m_NF },
  { X86::DIV8r, X86::DIV8r_NF },
  { X86::IDIV16m, X86::IDIV16m_NF },
  { X86::IDIV16r, X86::IDIV16r_NF },
  { X86::IDIV32m, X86::IDIV32m_NF },
  { X86::IDIV32r, X86::IDIV32r_NF },
  { X86::IDIV64m, X86::IDIV64m_NF },
  { X86::IDIV64r, X86::IDIV64r_NF },
  { X86::IDIV8m, X86::IDIV8m_NF },
  { X86::IDIV8r, X86::IDIV8r_NF },
  { X86::IMUL16m, X86::IMUL16m_NF },
  { X86::IMUL16r, X86::IMUL16r_NF },
  { X86::IMUL16rm, X86::IMUL16rm_NF },
  { X86::IMUL16rm_ND, X86::IMUL16rm_NF_ND },
  { X86::IMUL16rmi8, X86::IMUL16rmi8_NF },
  { X86::IMUL16rmi, X86::IMUL16rmi_NF },
  { X86::IMUL16rr, X86::IMUL16rr_NF },
  { X86::IMUL16rr_ND, X86::IMUL16rr_NF_ND },
  { X86::IMUL16rri8, X86::IMUL16rri8_NF },
  { X86::IMUL16rri, X86::IMUL16rri_NF },
  { X86::IMUL32m, X86::IMUL32m_NF },
  { X86::IMUL32r, X86::IMUL32r_NF },
  { X86::IMUL32rm, X86::IMUL32rm_NF },
  { X86::IMUL32rm_ND, X86::IMUL32rm_NF_ND },
  { X86::IMUL32rmi8, X86::IMUL32rmi8_NF },
  { X86::IMUL32rmi, X86::IMUL32rmi_NF },
  { X86::IMUL32rr, X86::IMUL32rr_NF },
  { X86::IMUL32rr_ND, X86::IMUL32rr_NF_ND },
  { X86::IMUL32rri8, X86::IMUL32rri8_NF },
  { X86::IMUL32rri, X86::IMUL32rri_NF },
  { X86::IMUL64m, X86::IMUL64m_NF },
  { X86::IMUL64r, X86::IMUL64r_NF },
  { X86::IMUL64rm, X86::IMUL64rm_NF },
  { X86::IMUL64rm_ND, X86::IMUL64rm_NF_ND },
  { X86::IMUL64rmi32, X86::IMUL64rmi32_NF },
  { X86::IMUL64rmi8, X86::IMUL64rmi8_NF },
  { X86::IMUL64rr, X86::IMUL64rr_NF },
  { X86::IMUL64rr_ND, X86::IMUL64rr_NF_ND },
  { X86::IMUL64rri32, X86::IMUL64rri32_NF },
  { X86::IMUL64rri8, X86::IMUL64rri8_NF },
  { X86::IMUL8m, X86::IMUL8m_NF },
  { X86::IMUL8r, X86::IMUL8r_NF },
  { X86::INC16m, X86::INC16m_NF },
  { X86::INC16m_ND, X86::INC16m_NF_ND },
  { X86::INC16r, X86::INC16r_NF },
  { X86::INC16r_ND, X86::INC16r_NF_ND },
  { X86::INC32m, X86::INC32m_NF },
  { X86::INC32m_ND, X86::INC32m_NF_ND },
  { X86::INC32r, X86::INC32r_NF },
  { X86::INC32r_ND, X86::INC32r_NF_ND },
  { X86::INC64m, X86::INC64m_NF },
  { X86::INC64m_ND, X86::INC64m_NF_ND },
  { X86::INC64r, X86::INC64r_NF },
  { X86::INC64r_ND, X86::INC64r_NF_ND },
  { X86::INC8m, X86::INC8m_NF },
  { X86::INC8m_ND, X86::INC8m_NF_ND },
  { X86::INC8r, X86::INC8r_NF },
  { X86::INC8r_ND, X86::INC8r_NF_ND },
  { X86::LZCNT16rm, X86::LZCNT16rm_NF },
  { X86::LZCNT16rr, X86::LZCNT16rr_NF },
  { X86::LZCNT32rm, X86::LZCNT32rm_NF },
  { X86::LZCNT32rr, X86::LZCNT32rr_NF },
  { X86::LZCNT64rm, X86::LZCNT64rm_NF },
  { X86::LZCNT64rr, X86::LZCNT64rr_NF },
  { X86::MUL16m, X86::MUL16m_NF },
  { X86::MUL16r, X86::MUL16r_NF },
  { X86::MUL32m, X86::MUL32m_NF },
  { X86::MUL32r, X86::MUL32r_NF },
  { X86::MUL64m, X86::MUL64m_NF },
  { X86::MUL64r, X86::MUL64r_NF },
  { X86::MUL8m, X86::MUL8m_NF },
  { X86::MUL8r, X86::MUL8r_NF },
  { X86::NEG16m, X86::NEG16m_NF },
  { X86::NEG16m_ND, X86::NEG16m_NF_ND },
  { X86::NEG16r, X86::NEG16r_NF },
  { X86::NEG16r_ND, X86::NEG16r_NF_ND },
  { X86::NEG32m, X86::NEG32m_NF },
  { X86::NEG32m_ND, X86::NEG32m_NF_ND },
  { X86::NEG32r, X86::NEG32r_NF },
  { X86::NEG32r_ND, X86::NEG32r_NF_ND },
  { X86::NEG64m, X86::NEG64m_NF },
  { X86::NEG64m_ND, X86::NEG64m_NF_ND },
  { X86::NEG64r, X86::NEG64r_NF },
  { X86::NEG64r_ND, X86::NEG64r_NF_ND },
  { X86::NEG8m, X86::NEG8m_NF },
  { X86::NEG8m_ND, X86::NEG8m_NF_ND },
  { X86::NEG8r, X86::NEG8r_NF },
  { X86::NEG8r_ND, X86::NEG8r_NF_ND },
  { X86::OR16mi8, X86::OR16mi8_NF },
  { X86::OR16mi8_ND, X86::OR16mi8_NF_ND },
  { X86::OR16mi, X86::OR16mi_NF },
  { X86::OR16mi_ND, X86::OR16mi_NF_ND },
  { X86::OR16mr, X86::OR16mr_NF },
  { X86::OR16mr_ND, X86::OR16mr_NF_ND },
  { X86::OR16ri8, X86::OR16ri8_NF },
  { X86::OR16ri8_ND, X86::OR16ri8_NF_ND },
  { X86::OR16ri, X86::OR16ri_NF },
  { X86::OR16ri_ND, X86::OR16ri_NF_ND },
  { X86::OR16rm, X86::OR16rm_NF },
  { X86::OR16rm_ND, X86::OR16rm_NF_ND },
  { X86::OR16rr, X86::OR16rr_NF },
  { X86::OR16rr_ND, X86::OR16rr_NF_ND },
  { X86::OR32mi8, X86::OR32mi8_NF },
  { X86::OR32mi8_ND, X86::OR32mi8_NF_ND },
  { X86::OR32mi, X86::OR32mi_NF },
  { X86::OR32mi_ND, X86::OR32mi_NF_ND },
  { X86::OR32mr, X86::OR32mr_NF },
  { X86::OR32mr_ND, X86::OR32mr_NF_ND },
  { X86::OR32ri8, X86::OR32ri8_NF },
  { X86::OR32ri8_ND, X86::OR32ri8_NF_ND },
  { X86::OR32ri, X86::OR32ri_NF },
  { X86::OR32ri_ND, X86::OR32ri_NF_ND },
  { X86::OR32rm, X86::OR32rm_NF },
  { X86::OR32rm_ND, X86::OR32rm_NF_ND },
  { X86::OR32rr, X86::OR32rr_NF },
  { X86::OR32rr_ND, X86::OR32rr_NF_ND },
  { X86::OR64mi32, X86::OR64mi32_NF },
  { X86::OR64mi32_ND, X86::OR64mi32_NF_ND },
  { X86::OR64mi8, X86::OR64mi8_NF },
  { X86::OR64mi8_ND, X86::OR64mi8_NF_ND },
  { X86::OR64mr, X86::OR64mr_NF },
  { X86::OR64mr_ND, X86::OR64mr_NF_ND },
  { X86::OR64ri32, X86::OR64ri32_NF },
  { X86::OR64ri32_ND, X86::OR64ri32_NF_ND },
  { X86::OR64ri8, X86::OR64ri8_NF },
  { X86::OR64ri8_ND, X86::OR64ri8_NF_ND },
  { X86::OR64rm, X86::OR64rm_NF },
  { X86::OR64rm_ND, X86::OR64rm_NF_ND },
  { X86::OR64rr, X86::OR64rr_NF },
  { X86::OR64rr_ND, X86::OR64rr_NF_ND },
  { X86::OR8mi, X86::OR8mi_NF },
  { X86::OR8mi_ND, X86::OR8mi_NF_ND },
  { X86::OR8mr, X86::OR8mr_NF },
  { X86::OR8mr_ND, X86::OR8mr_NF_ND },
  { X86::OR8ri, X86::OR8ri_NF },
  { X86::OR8ri_ND, X86::OR8ri_NF_ND },
  { X86::OR8rm, X86::OR8rm_NF },
  { X86::OR8rm_ND, X86::OR8rm_NF_ND },
  { X86::OR8rr, X86::OR8rr_NF },
  { X86::OR8rr_ND, X86::OR8rr_NF_ND },
  { X86::POPCNT16rm, X86::POPCNT16rm_NF },
  { X86::POPCNT16rr, X86::POPCNT16rr_NF },
  { X86::POPCNT32rm, X86::POPCNT32rm_NF },
  { X86::POPCNT32rr, X86::POPCNT32rr_NF },
  { X86::POPCNT64rm, X86::POPCNT64rm_NF },
  { X86::POPCNT64rr, X86::POPCNT64rr_NF },
  { X86::ROL16m1, X86::ROL16m1_NF },
  { X86::ROL16m1_ND, X86::ROL16m1_NF_ND },
  { X86::ROL16mCL, X86::ROL16mCL_NF },
  { X86::ROL16mCL_ND, X86::ROL16mCL_NF_ND },
  { X86::ROL16mi, X86::ROL16mi_NF },
  { X86::ROL16mi_ND, X86::ROL16mi_NF_ND },
  { X86::ROL16r1, X86::ROL16r1_NF },
  { X86::ROL16r1_ND, X86::ROL16r1_NF_ND },
  { X86::ROL16rCL, X86::ROL16rCL_NF },
  { X86::ROL16rCL_ND, X86::ROL16rCL_NF_ND },
  { X86::ROL16ri, X86::ROL16ri_NF },
  { X86::ROL16ri_ND, X86::ROL16ri_NF_ND },
  { X86::ROL32m1, X86::ROL32m1_NF },
  { X86::ROL32m1_ND, X86::ROL32m1_NF_ND },
  { X86::ROL32mCL, X86::ROL32mCL_NF },
  { X86::ROL32mCL_ND, X86::ROL32mCL_NF_ND },
  { X86::ROL32mi, X86::ROL32mi_NF },
  { X86::ROL32mi_ND, X86::ROL32mi_NF_ND },
  { X86::ROL32r1, X86::ROL32r1_NF },
  { X86::ROL32r1_ND, X86::ROL32r1_NF_ND },
  { X86::ROL32rCL, X86::ROL32rCL_NF },
  { X86::ROL32rCL_ND, X86::ROL32rCL_NF_ND },
  { X86::ROL32ri, X86::ROL32ri_NF },
  { X86::ROL32ri_ND, X86::ROL32ri_NF_ND },
  { X86::ROL64m1, X86::ROL64m1_NF },
  { X86::ROL64m1_ND, X86::ROL64m1_NF_ND },
  { X86::ROL64mCL, X86::ROL64mCL_NF },
  { X86::ROL64mCL_ND, X86::ROL64mCL_NF_ND },
  { X86::ROL64mi, X86::ROL64mi_NF },
  { X86::ROL64mi_ND, X86::ROL64mi_NF_ND },
  { X86::ROL64r1, X86::ROL64r1_NF },
  { X86::ROL64r1_ND, X86::ROL64r1_NF_ND },
  { X86::ROL64rCL, X86::ROL64rCL_NF },
  { X86::ROL64rCL_ND, X86::ROL64rCL_NF_ND },
  { X86::ROL64ri, X86::ROL64ri_NF },
  { X86::ROL64ri_ND, X86::ROL64ri_NF_ND },
  { X86::ROL8m1, X86::ROL8m1_NF },
  { X86::ROL8m1_ND, X86::ROL8m1_NF_ND },
  { X86::ROL8mCL, X86::ROL8mCL_NF },
  { X86::ROL8mCL_ND, X86::ROL8mCL_NF_ND },
  { X86::ROL8mi, X86::ROL8mi_NF },
  { X86::ROL8mi_ND, X86::ROL8mi_NF_ND },
  { X86::ROL8r1, X86::ROL8r1_NF },
  { X86::ROL8r1_ND, X86::ROL8r1_NF_ND },
  { X86::ROL8rCL, X86::ROL8rCL_NF },
  { X86::ROL8rCL_ND, X86::ROL8rCL_NF_ND },
  { X86::ROL8ri, X86::ROL8ri_NF },
  { X86::ROL8ri_ND, X86::ROL8ri_NF_ND },
  { X86::ROR16m1, X86::ROR16m1_NF },
  { X86::ROR16m1_ND, X86::ROR16m1_NF_ND },
  { X86::ROR16mCL, X86::ROR16mCL_NF },
  { X86::ROR16mCL_ND, X86::ROR16mCL_NF_ND },
  { X86::ROR16mi, X86::ROR16mi_NF },
  { X86::ROR16mi_ND, X86::ROR16mi_NF_ND },
  { X86::ROR16r1, X86::ROR16r1_NF },
  { X86::ROR16r1_ND, X86::ROR16r1_NF_ND },
  { X86::ROR16rCL, X86::ROR16rCL_NF },
  { X86::ROR16rCL_ND, X86::ROR16rCL_NF_ND },
  { X86::ROR16ri, X86::ROR16ri_NF },
  { X86::ROR16ri_ND, X86::ROR16ri_NF_ND },
  { X86::ROR32m1, X86::ROR32m1_NF },
  { X86::ROR32m1_ND, X86::ROR32m1_NF_ND },
  { X86::ROR32mCL, X86::ROR32mCL_NF },
  { X86::ROR32mCL_ND, X86::ROR32mCL_NF_ND },
  { X86::ROR32mi, X86::ROR32mi_NF },
  { X86::ROR32mi_ND, X86::ROR32mi_NF_ND },
  { X86::ROR32r1, X86::ROR32r1_NF },
  { X86::ROR32r1_ND, X86::ROR32r1_NF_ND },
  { X86::ROR32rCL, X86::ROR32rCL_NF },
  { X86::ROR32rCL_ND, X86::ROR32rCL_NF_ND },
  { X86::ROR32ri, X86::ROR32ri_NF },
  { X86::ROR32ri_ND, X86::ROR32ri_NF_ND },
  { X86::ROR64m1, X86::ROR64m1_NF },
  { X86::ROR64m1_ND, X86::ROR64m1_NF_ND },
  { X86::ROR64mCL, X86::ROR64mCL_NF },
  { X86::ROR64mCL_ND, X86::ROR64mCL_NF_ND },
  { X86::ROR64mi, X86::ROR64mi_NF },
  { X86::ROR64mi_ND, X86::ROR64mi_NF_ND },
  { X86::ROR64r1, X86::ROR64r1_NF },
  { X86::ROR64r1_ND, X86::ROR64r1_NF_ND },
  { X86::ROR64rCL, X86::ROR64rCL_NF },
  { X86::ROR64rCL_ND, X86::ROR64rCL_NF_ND },
  { X86::ROR64ri, X86::ROR64ri_NF },
  { X86::ROR64ri_ND, X86::ROR64ri_NF_ND },
  { X86::ROR8m1, X86::ROR8m1_NF },
  { X86::ROR8m1_ND, X86::ROR8m1_NF_ND },
  { X86::ROR8mCL, X86::ROR8mCL_NF },
  { X86::ROR8mCL_ND, X86::ROR8mCL_NF_ND },
  { X86::ROR8mi, X86::ROR8mi_NF },
  { X86::ROR8mi_ND, X86::ROR8mi_NF_ND },
  { X86::ROR8r1, X86::ROR8r1_NF },
  { X86::ROR8r1_ND, X86::ROR8r1_NF_ND },
  { X86::ROR8rCL, X86::ROR8rCL_NF },
  { X86::ROR8rCL_ND, X86::ROR8rCL_NF_ND },
  { X86::ROR8ri, X86::ROR8ri_NF },
  { X86::ROR8ri_ND, X86::ROR8ri_NF_ND },
  { X86::SAR16m1, X86::SAR16m1_NF },
  { X86::SAR16m1_ND, X86::SAR16m1_NF_ND },
  { X86::SAR16mCL, X86::SAR16mCL_NF },
  { X86::SAR16mCL_ND, X86::SAR16mCL_NF_ND },
  { X86::SAR16mi, X86::SAR16mi_NF },
  { X86::SAR16mi_ND, X86::SAR16mi_NF_ND },
  { X86::SAR16r1, X86::SAR16r1_NF },
  { X86::SAR16r1_ND, X86::SAR16r1_NF_ND },
  { X86::SAR16rCL, X86::SAR16rCL_NF },
  { X86::SAR16rCL_ND, X86::SAR16rCL_NF_ND },
  { X86::SAR16ri, X86::SAR16ri_NF },
  { X86::SAR16ri_ND, X86::SAR16ri_NF_ND },
  { X86::SAR32m1, X86::SAR32m1_NF },
  { X86::SAR32m1_ND, X86::SAR32m1_NF_ND },
  { X86::SAR32mCL, X86::SAR32mCL_NF },
  { X86::SAR32mCL_ND, X86::SAR32mCL_NF_ND },
  { X86::SAR32mi, X86::SAR32mi_NF },
  { X86::SAR32mi_ND, X86::SAR32mi_NF_ND },
  { X86::SAR32r1, X86::SAR32r1_NF },
  { X86::SAR32r1_ND, X86::SAR32r1_NF_ND },
  { X86::SAR32rCL, X86::SAR32rCL_NF },
  { X86::SAR32rCL_ND, X86::SAR32rCL_NF_ND },
  { X86::SAR32ri, X86::SAR32ri_NF },
  { X86::SAR32ri_ND, X86::SAR32ri_NF_ND },
  { X86::SAR64m1, X86::SAR64m1_NF },
  { X86::SAR64m1_ND, X86::SAR64m1_NF_ND },
  { X86::SAR64mCL, X86::SAR64mCL_NF },
  { X86::SAR64mCL_ND, X86::SAR64mCL_NF_ND },
  { X86::SAR64mi, X86::SAR64mi_NF },
  { X86::SAR64mi_ND, X86::SAR64mi_NF_ND },
  { X86::SAR64r1, X86::SAR64r1_NF },
  { X86::SAR64r1_ND, X86::SAR64r1_NF_ND },
  { X86::SAR64rCL, X86::SAR64rCL_NF },
  { X86::SAR64rCL_ND, X86::SAR64rCL_NF_ND },
  { X86::SAR64ri, X86::SAR64ri_NF },
  { X86::SAR64ri_ND, X86::SAR64ri_NF_ND },
  { X86::SAR8m1, X86::SAR8m1_NF },
  { X86::SAR8m1_ND, X86::SAR8m1_NF_ND },
  { X86::SAR8mCL, X86::SAR8mCL_NF },
  { X86::SAR8mCL_ND, X86::SAR8mCL_NF_ND },
  { X86::SAR8mi, X86::SAR8mi_NF },
  { X86::SAR8mi_ND, X86::SAR8mi_NF_ND },
  { X86::SAR8r1, X86::SAR8r1_NF },
  { X86::SAR8r1_ND, X86::SAR8r1_NF_ND },
  { X86::SAR8rCL, X86::SAR8rCL_NF },
  { X86::SAR8rCL_ND, X86::SAR8rCL_NF_ND },
  { X86::SAR8ri, X86::SAR8ri_NF },
  { X86::SAR8ri_ND, X86::SAR8ri_NF_ND },
  { X86::SHL16m1, X86::SHL16m1_NF },
  { X86::SHL16m1_ND, X86::SHL16m1_NF_ND },
  { X86::SHL16mCL, X86::SHL16mCL_NF },
  { X86::SHL16mCL_ND, X86::SHL16mCL_NF_ND },
  { X86::SHL16mi, X86::SHL16mi_NF },
  { X86::SHL16mi_ND, X86::SHL16mi_NF_ND },
  { X86::SHL16r1, X86::SHL16r1_NF },
  { X86::SHL16r1_ND, X86::SHL16r1_NF_ND },
  { X86::SHL16rCL, X86::SHL16rCL_NF },
  { X86::SHL16rCL_ND, X86::SHL16rCL_NF_ND },
  { X86::SHL16ri, X86::SHL16ri_NF },
  { X86::SHL16ri_ND, X86::SHL16ri_NF_ND },
  { X86::SHL32m1, X86::SHL32m1_NF },
  { X86::SHL32m1_ND, X86::SHL32m1_NF_ND },
  { X86::SHL32mCL, X86::SHL32mCL_NF },
  { X86::SHL32mCL_ND, X86::SHL32mCL_NF_ND },
  { X86::SHL32mi, X86::SHL32mi_NF },
  { X86::SHL32mi_ND, X86::SHL32mi_NF_ND },
  { X86::SHL32r1, X86::SHL32r1_NF },
  { X86::SHL32r1_ND, X86::SHL32r1_NF_ND },
  { X86::SHL32rCL, X86::SHL32rCL_NF },
  { X86::SHL32rCL_ND, X86::SHL32rCL_NF_ND },
  { X86::SHL32ri, X86::SHL32ri_NF },
  { X86::SHL32ri_ND, X86::SHL32ri_NF_ND },
  { X86::SHL64m1, X86::SHL64m1_NF },
  { X86::SHL64m1_ND, X86::SHL64m1_NF_ND },
  { X86::SHL64mCL, X86::SHL64mCL_NF },
  { X86::SHL64mCL_ND, X86::SHL64mCL_NF_ND },
  { X86::SHL64mi, X86::SHL64mi_NF },
  { X86::SHL64mi_ND, X86::SHL64mi_NF_ND },
  { X86::SHL64r1, X86::SHL64r1_NF },
  { X86::SHL64r1_ND, X86::SHL64r1_NF_ND },
  { X86::SHL64rCL, X86::SHL64rCL_NF },
  { X86::SHL64rCL_ND, X86::SHL64rCL_NF_ND },
  { X86::SHL64ri, X86::SHL64ri_NF },
  { X86::SHL64ri_ND, X86::SHL64ri_NF_ND },
  { X86::SHL8m1, X86::SHL8m1_NF },
  { X86::SHL8m1_ND, X86::SHL8m1_NF_ND },
  { X86::SHL8mCL, X86::SHL8mCL_NF },
  { X86::SHL8mCL_ND, X86::SHL8mCL_NF_ND },
  { X86::SHL8mi, X86::SHL8mi_NF },
  { X86::SHL8mi_ND, X86::SHL8mi_NF_ND },
  { X86::SHL8r1, X86::SHL8r1_NF },
  { X86::SHL8r1_ND, X86::SHL8r1_NF_ND },
  { X86::SHL8rCL, X86::SHL8rCL_NF },
  { X86::SHL8rCL_ND, X86::SHL8rCL_NF_ND },
  { X86::SHL8ri, X86::SHL8ri_NF },
  { X86::SHL8ri_ND, X86::SHL8ri_NF_ND },
  { X86::SHLD16mrCL, X86::SHLD16mrCL_NF },
  { X86::SHLD16mrCL_ND, X86::SHLD16mrCL_NF_ND },
  { X86::SHLD16mri8, X86::SHLD16mri8_NF },
  { X86::SHLD16mri8_ND, X86::SHLD16mri8_NF_ND },
  { X86::SHLD16rrCL, X86::SHLD16rrCL_NF },
  { X86::SHLD16rrCL_ND, X86::SHLD16rrCL_NF_ND },
  { X86::SHLD16rri8, X86::SHLD16rri8_NF },
  { X86::SHLD16rri8_ND, X86::SHLD16rri8_NF_ND },
  { X86::SHLD32mrCL, X86::SHLD32mrCL_NF },
  { X86::SHLD32mrCL_ND, X86::SHLD32mrCL_NF_ND },
  { X86::SHLD32mri8, X86::SHLD32mri8_NF },
  { X86::SHLD32mri8_ND, X86::SHLD32mri8_NF_ND },
  { X86::SHLD32rrCL, X86::SHLD32rrCL_NF },
  { X86::SHLD32rrCL_ND, X86::SHLD32rrCL_NF_ND },
  { X86::SHLD32rri8, X86::SHLD32rri8_NF },
  { X86::SHLD32rri8_ND, X86::SHLD32rri8_NF_ND },
  { X86::SHLD64mrCL, X86::SHLD64mrCL_NF },
  { X86::SHLD64mrCL_ND, X86::SHLD64mrCL_NF_ND },
  { X86::SHLD64mri8, X86::SHLD64mri8_NF },
  { X86::SHLD64mri8_ND, X86::SHLD64mri8_NF_ND },
  { X86::SHLD64rrCL, X86::SHLD64rrCL_NF },
  { X86::SHLD64rrCL_ND, X86::SHLD64rrCL_NF_ND },
  { X86::SHLD64rri8, X86::SHLD64rri8_NF },
  { X86::SHLD64rri8_ND, X86::SHLD64rri8_NF_ND },
  { X86::SHR16m1, X86::SHR16m1_NF },
  { X86::SHR16m1_ND, X86::SHR16m1_NF_ND },
  { X86::SHR16mCL, X86::SHR16mCL_NF },
  { X86::SHR16mCL_ND, X86::SHR16mCL_NF_ND },
  { X86::SHR16mi, X86::SHR16mi_NF },
  { X86::SHR16mi_ND, X86::SHR16mi_NF_ND },
  { X86::SHR16r1, X86::SHR16r1_NF },
  { X86::SHR16r1_ND, X86::SHR16r1_NF_ND },
  { X86::SHR16rCL, X86::SHR16rCL_NF },
  { X86::SHR16rCL_ND, X86::SHR16rCL_NF_ND },
  { X86::SHR16ri, X86::SHR16ri_NF },
  { X86::SHR16ri_ND, X86::SHR16ri_NF_ND },
  { X86::SHR32m1, X86::SHR32m1_NF },
  { X86::SHR32m1_ND, X86::SHR32m1_NF_ND },
  { X86::SHR32mCL, X86::SHR32mCL_NF },
  { X86::SHR32mCL_ND, X86::SHR32mCL_NF_ND },
  { X86::SHR32mi, X86::SHR32mi_NF },
  { X86::SHR32mi_ND, X86::SHR32mi_NF_ND },
  { X86::SHR32r1, X86::SHR32r1_NF },
  { X86::SHR32r1_ND, X86::SHR32r1_NF_ND },
  { X86::SHR32rCL, X86::SHR32rCL_NF },
  { X86::SHR32rCL_ND, X86::SHR32rCL_NF_ND },
  { X86::SHR32ri, X86::SHR32ri_NF },
  { X86::SHR32ri_ND, X86::SHR32ri_NF_ND },
  { X86::SHR64m1, X86::SHR64m1_NF },
  { X86::SHR64m1_ND, X86::SHR64m1_NF_ND },
  { X86::SHR64mCL, X86::SHR64mCL_NF },
  { X86::SHR64mCL_ND, X86::SHR64mCL_NF_ND },
  { X86::SHR64mi, X86::SHR64mi_NF },
  { X86::SHR64mi_ND, X86::SHR64mi_NF_ND },
  { X86::SHR64r1, X86::SHR64r1_NF },
  { X86::SHR64r1_ND, X86::SHR64r1_NF_ND },
  { X86::SHR64rCL, X86::SHR64rCL_NF },
  { X86::SHR64rCL_ND, X86::SHR64rCL_NF_ND },
  { X86::SHR64ri, X86::SHR64ri_NF },
  { X86::SHR64ri_ND, X86::SHR64ri_NF_ND },
  { X86::SHR8m1, X86::SHR8m1_NF },
  { X86::SHR8m1_ND, X86::SHR8m1_NF_ND },
  { X86::SHR8mCL, X86::SHR8mCL_NF },
  { X86::SHR8mCL_ND, X86::SHR8mCL_NF_ND },
  { X86::SHR8mi, X86::SHR8mi_NF },
  { X86::SHR8mi_ND, X86::SHR8mi_NF_ND },
  { X86::SHR8r1, X86::SHR8r1_NF },
  { X86::SHR8r1_ND, X86::SHR8r1_NF_ND },
  { X86::SHR8rCL, X86::SHR8rCL_NF },
  { X86::SHR8rCL_ND, X86::SHR8rCL_NF_ND },
  { X86::SHR8ri, X86::SHR8ri_NF },
  { X86::SHR8ri_ND, X86::SHR8ri_NF_ND },
  { X86::SHRD16mrCL, X86::SHRD16mrCL_NF },
  { X86::SHRD16mrCL_ND, X86::SHRD16mrCL_NF_ND },
  { X86::SHRD16mri8, X86::SHRD16mri8_NF },
  { X86::SHRD16mri8_ND, X86::SHRD16mri8_NF_ND },
  { X86::SHRD16rrCL, X86::SHRD16rrCL_NF },
  { X86::SHRD16rrCL_ND, X86::SHRD16rrCL_NF_ND },
  { X86::SHRD16rri8, X86::SHRD16rri8_NF },
  { X86::SHRD16rri8_ND, X86::SHRD16rri8_NF_ND },
  { X86::SHRD32mrCL, X86::SHRD32mrCL_NF },
  { X86::SHRD32mrCL_ND, X86::SHRD32mrCL_NF_ND },
  { X86::SHRD32mri8, X86::SHRD32mri8_NF },
  { X86::SHRD32mri8_ND, X86::SHRD32mri8_NF_ND },
  { X86::SHRD32rrCL, X86::SHRD32rrCL_NF },
  { X86::SHRD32rrCL_ND, X86::SHRD32rrCL_NF_ND },
  { X86::SHRD32rri8, X86::SHRD32rri8_NF },
  { X86::SHRD32rri8_ND, X86::SHRD32rri8_NF_ND },
  { X86::SHRD64mrCL, X86::SHRD64mrCL_NF },
  { X86::SHRD64mrCL_ND, X86::SHRD64mrCL_NF_ND },
  { X86::SHRD64mri8, X86::SHRD64mri8_NF },
  { X86::SHRD64mri8_ND, X86::SHRD64mri8_NF_ND },
  { X86::SHRD64rrCL, X86::SHRD64rrCL_NF },
  { X86::SHRD64rrCL_ND, X86::SHRD64rrCL_NF_ND },
  { X86::SHRD64rri8, X86::SHRD64rri8_NF },
  { X86::SHRD64rri8_ND, X86::SHRD64rri8_NF_ND },
  { X86::SUB16mi8, X86::SUB16mi8_NF },
  { X86::SUB16mi8_ND, X86::SUB16mi8_NF_ND },
  { X86::SUB16mi, X86::SUB16mi_NF },
  { X86::SUB16mi_ND, X86::SUB16mi_NF_ND },
  { X86::SUB16mr, X86::SUB16mr_NF },
  { X86::SUB16mr_ND, X86::SUB16mr_NF_ND },
  { X86::SUB16ri8, X86::SUB16ri8_NF },
  { X86::SUB16ri8_ND, X86::SUB16ri8_NF_ND },
  { X86::SUB16ri, X86::SUB16ri_NF },
  { X86::SUB16ri_ND, X86::SUB16ri_NF_ND },
  { X86::SUB16rm, X86::SUB16rm_NF },
  { X86::SUB16rm_ND, X86::SUB16rm_NF_ND },
  { X86::SUB16rr, X86::SUB16rr_NF },
  { X86::SUB16rr_ND, X86::SUB16rr_NF_ND },
  { X86::SUB32mi8, X86::SUB32mi8_NF },
  { X86::SUB32mi8_ND, X86::SUB32mi8_NF_ND },
  { X86::SUB32mi, X86::SUB32mi_NF },
  { X86::SUB32mi_ND, X86::SUB32mi_NF_ND },
  { X86::SUB32mr, X86::SUB32mr_NF },
  { X86::SUB32mr_ND, X86::SUB32mr_NF_ND },
  { X86::SUB32ri8, X86::SUB32ri8_NF },
  { X86::SUB32ri8_ND, X86::SUB32ri8_NF_ND },
  { X86::SUB32ri, X86::SUB32ri_NF },
  { X86::SUB32ri_ND, X86::SUB32ri_NF_ND },
  { X86::SUB32rm, X86::SUB32rm_NF },
  { X86::SUB32rm_ND, X86::SUB32rm_NF_ND },
  { X86::SUB32rr, X86::SUB32rr_NF },
  { X86::SUB32rr_ND, X86::SUB32rr_NF_ND },
  { X86::SUB64mi32, X86::SUB64mi32_NF },
  { X86::SUB64mi32_ND, X86::SUB64mi32_NF_ND },
  { X86::SUB64mi8, X86::SUB64mi8_NF },
  { X86::SUB64mi8_ND, X86::SUB64mi8_NF_ND },
  { X86::SUB64mr, X86::SUB64mr_NF },
  { X86::SUB64mr_ND, X86::SUB64mr_NF_ND },
  { X86::SUB64ri32, X86::SUB64ri32_NF },
  { X86::SUB64ri32_ND, X86::SUB64ri32_NF_ND },
  { X86::SUB64ri8, X86::SUB64ri8_NF },
  { X86::SUB64ri8_ND, X86::SUB64ri8_NF_ND },
  { X86::SUB64rm, X86::SUB64rm_NF },
  { X86::SUB64rm_ND, X86::SUB64rm_NF_ND },
  { X86::SUB64rr, X86::SUB64rr_NF },
  { X86::SUB64rr_ND, X86::SUB64rr_NF_ND },
  { X86::SUB8mi, X86::SUB8mi_NF },
  { X86::SUB8mi_ND, X86::SUB8mi_NF_ND },
  { X86::SUB8mr, X86::SUB8mr_NF },
  { X86::SUB8mr_ND, X86::SUB8mr_NF_ND },
  { X86::SUB8ri, X86::SUB8ri_NF },
  { X86::SUB8ri_ND, X86::SUB8ri_NF_ND },
  { X86::SUB8rm, X86::SUB8rm_NF },
  { X86::SUB8rm_ND, X86::SUB8rm_NF_ND },
  { X86::SUB8rr, X86::SUB8rr_NF },
  { X86::SUB8rr_ND, X86::SUB8rr_NF_ND },
  { X86::TZCNT16rm, X86::TZCNT16rm_NF },
  { X86::TZCNT16rr, X86::TZCNT16rr_NF },
  { X86::TZCNT32rm, X86::TZCNT32rm_NF },
  { X86::TZCNT32rr, X86::TZCNT32rr_NF },
  { X86::TZCNT64rm, X86::TZCNT64rm_NF },
  { X86::TZCNT64rr, X86::TZCNT64rr_NF },
  { X86::XOR16mi8, X86::XOR16mi8_NF },
  { X86::XOR16mi8_ND, X86::XOR16mi8_NF_ND },
  { X86::XOR16mi, X86::XOR16mi_NF },
  { X86::XOR16mi_ND, X86::XOR16mi_NF_ND },
  { X86::XOR16mr, X86::XOR16mr_NF },
  { X86::XOR16mr_ND, X86::XOR16mr_NF_ND },
  { X86::XOR16ri8, X86::XOR16ri8_NF },
  { X86::XOR16ri8_ND, X86::XOR16ri8_NF_ND },
  { X86::XOR16ri, X86::XOR16ri_NF },
  { X86::XOR16ri_ND, X86::XOR16ri_NF_ND },
  { X86::XOR16rm, X86::XOR16rm_NF },
  { X86::XOR16rm_ND, X86::XOR16rm_NF_ND },
  { X86::XOR16rr, X86::XOR16rr_NF },
  { X86::XOR16rr_ND, X86::XOR16rr_NF_ND },
  { X86::XOR32mi8, X86::XOR32mi8_NF },
  { X86::XOR32mi8_ND, X86::XOR32mi8_NF_ND },
  { X86::XOR32mi, X86::XOR32mi_NF },
  { X86::XOR32mi_ND, X86::XOR32mi_NF_ND },
  { X86::XOR32mr, X86::XOR32mr_NF },
  { X86::XOR32mr_ND, X86::XOR32mr_NF_ND },
  { X86::XOR32ri8, X86::XOR32ri8_NF },
  { X86::XOR32ri8_ND, X86::XOR32ri8_NF_ND },
  { X86::XOR32ri, X86::XOR32ri_NF },
  { X86::XOR32ri_ND, X86::XOR32ri_NF_ND },
  { X86::XOR32rm, X86::XOR32rm_NF },
  { X86::XOR32rm_ND, X86::XOR32rm_NF_ND },
  { X86::XOR32rr, X86::XOR32rr_NF },
  { X86::XOR32rr_ND, X86::XOR32rr_NF_ND },
  { X86::XOR64mi32, X86::XOR64mi32_NF },
  { X86::XOR64mi32_ND, X86::XOR64mi32_NF_ND },
  { X86::XOR64mi8, X86::XOR64mi8_NF },
  { X86::XOR64mi8_ND, X86::XOR64mi8_NF_ND },
  { X86::XOR64mr, X86::XOR64mr_NF },
  { X86::XOR64mr_ND, X86::XOR64mr_NF_ND },
  { X86::XOR64ri32, X86::XOR64ri32_NF },
  { X86::XOR64ri32_ND, X86::XOR64ri32_NF_ND },
  { X86::XOR64ri8, X86::XOR64ri8_NF },
  { X86::XOR64ri8_ND, X86::XOR64ri8_NF_ND },
  { X86::XOR64rm, X86::XOR64rm_NF },
  { X86::XOR64rm_ND, X86::XOR64rm_NF_ND },
  { X86::XOR64rr, X86::XOR64rr_NF },
  { X86::XOR64rr_ND, X86::XOR64rr_NF_ND },
  { X86::XOR8mi, X86::XOR8mi_NF },
  { X86::XOR8mi_ND, X86::XOR8mi_NF_ND },
  { X86::XOR8mr, X86::XOR8mr_NF },
  { X86::XOR8mr_ND, X86::XOR8mr_NF_ND },
  { X86::XOR8ri, X86::XOR8ri_NF },
  { X86::XOR8ri_ND, X86::XOR8ri_NF_ND },
  { X86::XOR8rm, X86::XOR8rm_NF },
  { X86::XOR8rm_ND, X86::XOR8rm_NF_ND },
  { X86::XOR8rr, X86::XOR8rr_NF },
  { X86::XOR8rr_ND, X86::XOR8rr_NF_ND },
};

#endif // GET_X86_NF_TRANSFORM_TABLE


#ifdef GET_X86_ND2NONND_TABLE
static const X86TableEntry X86ND2NonNDTable[] = {
  { X86::ADC16ri8_ND, X86::ADC16ri8 },
  { X86::ADC16ri_ND, X86::ADC16ri },
  { X86::ADC16rm_ND, X86::ADC16rm },
  { X86::ADC16rr_ND, X86::ADC16rr },
  { X86::ADC32ri8_ND, X86::ADC32ri8 },
  { X86::ADC32ri_ND, X86::ADC32ri },
  { X86::ADC32rm_ND, X86::ADC32rm },
  { X86::ADC32rr_ND, X86::ADC32rr },
  { X86::ADC64ri32_ND, X86::ADC64ri32 },
  { X86::ADC64ri8_ND, X86::ADC64ri8 },
  { X86::ADC64rm_ND, X86::ADC64rm },
  { X86::ADC64rr_ND, X86::ADC64rr },
  { X86::ADC8ri_ND, X86::ADC8ri },
  { X86::ADC8rm_ND, X86::ADC8rm },
  { X86::ADC8rr_ND, X86::ADC8rr },
  { X86::ADCX32rm_ND, X86::ADCX32rm },
  { X86::ADCX32rr_ND, X86::ADCX32rr },
  { X86::ADCX64rm_ND, X86::ADCX64rm },
  { X86::ADCX64rr_ND, X86::ADCX64rr },
  { X86::ADD16ri8_ND, X86::ADD16ri8 },
  { X86::ADD16ri8_NF_ND, X86::ADD16ri8_NF },
  { X86::ADD16ri_ND, X86::ADD16ri },
  { X86::ADD16ri_NF_ND, X86::ADD16ri_NF },
  { X86::ADD16rm_ND, X86::ADD16rm },
  { X86::ADD16rm_NF_ND, X86::ADD16rm_NF },
  { X86::ADD16rr_ND, X86::ADD16rr },
  { X86::ADD16rr_NF_ND, X86::ADD16rr_NF },
  { X86::ADD32ri8_ND, X86::ADD32ri8 },
  { X86::ADD32ri8_NF_ND, X86::ADD32ri8_NF },
  { X86::ADD32ri_ND, X86::ADD32ri },
  { X86::ADD32ri_NF_ND, X86::ADD32ri_NF },
  { X86::ADD32rm_ND, X86::ADD32rm },
  { X86::ADD32rm_NF_ND, X86::ADD32rm_NF },
  { X86::ADD32rr_ND, X86::ADD32rr },
  { X86::ADD32rr_NF_ND, X86::ADD32rr_NF },
  { X86::ADD64ri32_ND, X86::ADD64ri32 },
  { X86::ADD64ri32_NF_ND, X86::ADD64ri32_NF },
  { X86::ADD64ri8_ND, X86::ADD64ri8 },
  { X86::ADD64ri8_NF_ND, X86::ADD64ri8_NF },
  { X86::ADD64rm_ND, X86::ADD64rm },
  { X86::ADD64rm_NF_ND, X86::ADD64rm_NF },
  { X86::ADD64rr_ND, X86::ADD64rr },
  { X86::ADD64rr_NF_ND, X86::ADD64rr_NF },
  { X86::ADD8ri_ND, X86::ADD8ri },
  { X86::ADD8ri_NF_ND, X86::ADD8ri_NF },
  { X86::ADD8rm_ND, X86::ADD8rm },
  { X86::ADD8rm_NF_ND, X86::ADD8rm_NF },
  { X86::ADD8rr_ND, X86::ADD8rr },
  { X86::ADD8rr_NF_ND, X86::ADD8rr_NF },
  { X86::ADOX32rm_ND, X86::ADOX32rm },
  { X86::ADOX32rr_ND, X86::ADOX32rr },
  { X86::ADOX64rm_ND, X86::ADOX64rm },
  { X86::ADOX64rr_ND, X86::ADOX64rr },
  { X86::AND16ri8_ND, X86::AND16ri8 },
  { X86::AND16ri8_NF_ND, X86::AND16ri8_NF },
  { X86::AND16ri_ND, X86::AND16ri },
  { X86::AND16ri_NF_ND, X86::AND16ri_NF },
  { X86::AND16rm_ND, X86::AND16rm },
  { X86::AND16rm_NF_ND, X86::AND16rm_NF },
  { X86::AND16rr_ND, X86::AND16rr },
  { X86::AND16rr_NF_ND, X86::AND16rr_NF },
  { X86::AND32ri8_ND, X86::AND32ri8 },
  { X86::AND32ri8_NF_ND, X86::AND32ri8_NF },
  { X86::AND32ri_ND, X86::AND32ri },
  { X86::AND32ri_NF_ND, X86::AND32ri_NF },
  { X86::AND32rm_ND, X86::AND32rm },
  { X86::AND32rm_NF_ND, X86::AND32rm_NF },
  { X86::AND32rr_ND, X86::AND32rr },
  { X86::AND32rr_NF_ND, X86::AND32rr_NF },
  { X86::AND64ri32_ND, X86::AND64ri32 },
  { X86::AND64ri32_NF_ND, X86::AND64ri32_NF },
  { X86::AND64ri8_ND, X86::AND64ri8 },
  { X86::AND64ri8_NF_ND, X86::AND64ri8_NF },
  { X86::AND64rm_ND, X86::AND64rm },
  { X86::AND64rm_NF_ND, X86::AND64rm_NF },
  { X86::AND64rr_ND, X86::AND64rr },
  { X86::AND64rr_NF_ND, X86::AND64rr_NF },
  { X86::AND8ri_ND, X86::AND8ri },
  { X86::AND8ri_NF_ND, X86::AND8ri_NF },
  { X86::AND8rm_ND, X86::AND8rm },
  { X86::AND8rm_NF_ND, X86::AND8rm_NF },
  { X86::AND8rr_ND, X86::AND8rr },
  { X86::AND8rr_NF_ND, X86::AND8rr_NF },
  { X86::CMOV16rm_ND, X86::CMOV16rm },
  { X86::CMOV16rr_ND, X86::CMOV16rr },
  { X86::CMOV32rm_ND, X86::CMOV32rm },
  { X86::CMOV32rr_ND, X86::CMOV32rr },
  { X86::CMOV64rm_ND, X86::CMOV64rm },
  { X86::CMOV64rr_ND, X86::CMOV64rr },
  { X86::DEC16r_ND, X86::DEC16r },
  { X86::DEC16r_NF_ND, X86::DEC16r_NF },
  { X86::DEC32r_ND, X86::DEC32r },
  { X86::DEC32r_NF_ND, X86::DEC32r_NF },
  { X86::DEC64r_ND, X86::DEC64r },
  { X86::DEC64r_NF_ND, X86::DEC64r_NF },
  { X86::DEC8r_ND, X86::DEC8r },
  { X86::DEC8r_NF_ND, X86::DEC8r_NF },
  { X86::IMUL16rm_ND, X86::IMUL16rm },
  { X86::IMUL16rm_NF_ND, X86::IMUL16rm_NF },
  { X86::IMUL16rr_ND, X86::IMUL16rr },
  { X86::IMUL16rr_NF_ND, X86::IMUL16rr_NF },
  { X86::IMUL32rm_ND, X86::IMUL32rm },
  { X86::IMUL32rm_NF_ND, X86::IMUL32rm_NF },
  { X86::IMUL32rr_ND, X86::IMUL32rr },
  { X86::IMUL32rr_NF_ND, X86::IMUL32rr_NF },
  { X86::IMUL64rm_ND, X86::IMUL64rm },
  { X86::IMUL64rm_NF_ND, X86::IMUL64rm_NF },
  { X86::IMUL64rr_ND, X86::IMUL64rr },
  { X86::IMUL64rr_NF_ND, X86::IMUL64rr_NF },
  { X86::INC16r_ND, X86::INC16r },
  { X86::INC16r_NF_ND, X86::INC16r_NF },
  { X86::INC32r_ND, X86::INC32r },
  { X86::INC32r_NF_ND, X86::INC32r_NF },
  { X86::INC64r_ND, X86::INC64r },
  { X86::INC64r_NF_ND, X86::INC64r_NF },
  { X86::INC8r_ND, X86::INC8r },
  { X86::INC8r_NF_ND, X86::INC8r_NF },
  { X86::MOVBE32rr, X86::BSWAP32r },
  { X86::MOVBE64rr, X86::BSWAP64r },
  { X86::NEG16r_ND, X86::NEG16r },
  { X86::NEG16r_NF_ND, X86::NEG16r_NF },
  { X86::NEG32r_ND, X86::NEG32r },
  { X86::NEG32r_NF_ND, X86::NEG32r_NF },
  { X86::NEG64r_ND, X86::NEG64r },
  { X86::NEG64r_NF_ND, X86::NEG64r_NF },
  { X86::NEG8r_ND, X86::NEG8r },
  { X86::NEG8r_NF_ND, X86::NEG8r_NF },
  { X86::NOT16r_ND, X86::NOT16r },
  { X86::NOT32r_ND, X86::NOT32r },
  { X86::NOT64r_ND, X86::NOT64r },
  { X86::NOT8r_ND, X86::NOT8r },
  { X86::OR16ri8_ND, X86::OR16ri8 },
  { X86::OR16ri8_NF_ND, X86::OR16ri8_NF },
  { X86::OR16ri_ND, X86::OR16ri },
  { X86::OR16ri_NF_ND, X86::OR16ri_NF },
  { X86::OR16rm_ND, X86::OR16rm },
  { X86::OR16rm_NF_ND, X86::OR16rm_NF },
  { X86::OR16rr_ND, X86::OR16rr },
  { X86::OR16rr_NF_ND, X86::OR16rr_NF },
  { X86::OR32ri8_ND, X86::OR32ri8 },
  { X86::OR32ri8_NF_ND, X86::OR32ri8_NF },
  { X86::OR32ri_ND, X86::OR32ri },
  { X86::OR32ri_NF_ND, X86::OR32ri_NF },
  { X86::OR32rm_ND, X86::OR32rm },
  { X86::OR32rm_NF_ND, X86::OR32rm_NF },
  { X86::OR32rr_ND, X86::OR32rr },
  { X86::OR32rr_NF_ND, X86::OR32rr_NF },
  { X86::OR64ri32_ND, X86::OR64ri32 },
  { X86::OR64ri32_NF_ND, X86::OR64ri32_NF },
  { X86::OR64ri8_ND, X86::OR64ri8 },
  { X86::OR64ri8_NF_ND, X86::OR64ri8_NF },
  { X86::OR64rm_ND, X86::OR64rm },
  { X86::OR64rm_NF_ND, X86::OR64rm_NF },
  { X86::OR64rr_ND, X86::OR64rr },
  { X86::OR64rr_NF_ND, X86::OR64rr_NF },
  { X86::OR8ri_ND, X86::OR8ri },
  { X86::OR8ri_NF_ND, X86::OR8ri_NF },
  { X86::OR8rm_ND, X86::OR8rm },
  { X86::OR8rm_NF_ND, X86::OR8rm_NF },
  { X86::OR8rr_ND, X86::OR8rr },
  { X86::OR8rr_NF_ND, X86::OR8rr_NF },
  { X86::RCL16r1_ND, X86::RCL16r1 },
  { X86::RCL16rCL_ND, X86::RCL16rCL },
  { X86::RCL16ri_ND, X86::RCL16ri },
  { X86::RCL32r1_ND, X86::RCL32r1 },
  { X86::RCL32rCL_ND, X86::RCL32rCL },
  { X86::RCL32ri_ND, X86::RCL32ri },
  { X86::RCL64r1_ND, X86::RCL64r1 },
  { X86::RCL64rCL_ND, X86::RCL64rCL },
  { X86::RCL64ri_ND, X86::RCL64ri },
  { X86::RCL8r1_ND, X86::RCL8r1 },
  { X86::RCL8rCL_ND, X86::RCL8rCL },
  { X86::RCL8ri_ND, X86::RCL8ri },
  { X86::RCR16r1_ND, X86::RCR16r1 },
  { X86::RCR16rCL_ND, X86::RCR16rCL },
  { X86::RCR16ri_ND, X86::RCR16ri },
  { X86::RCR32r1_ND, X86::RCR32r1 },
  { X86::RCR32rCL_ND, X86::RCR32rCL },
  { X86::RCR32ri_ND, X86::RCR32ri },
  { X86::RCR64r1_ND, X86::RCR64r1 },
  { X86::RCR64rCL_ND, X86::RCR64rCL },
  { X86::RCR64ri_ND, X86::RCR64ri },
  { X86::RCR8r1_ND, X86::RCR8r1 },
  { X86::RCR8rCL_ND, X86::RCR8rCL },
  { X86::RCR8ri_ND, X86::RCR8ri },
  { X86::ROL16r1_ND, X86::ROL16r1 },
  { X86::ROL16r1_NF_ND, X86::ROL16r1_NF },
  { X86::ROL16rCL_ND, X86::ROL16rCL },
  { X86::ROL16rCL_NF_ND, X86::ROL16rCL_NF },
  { X86::ROL16ri_ND, X86::ROL16ri },
  { X86::ROL16ri_NF_ND, X86::ROL16ri_NF },
  { X86::ROL32r1_ND, X86::ROL32r1 },
  { X86::ROL32r1_NF_ND, X86::ROL32r1_NF },
  { X86::ROL32rCL_ND, X86::ROL32rCL },
  { X86::ROL32rCL_NF_ND, X86::ROL32rCL_NF },
  { X86::ROL32ri_ND, X86::ROL32ri },
  { X86::ROL32ri_NF_ND, X86::ROL32ri_NF },
  { X86::ROL64r1_ND, X86::ROL64r1 },
  { X86::ROL64r1_NF_ND, X86::ROL64r1_NF },
  { X86::ROL64rCL_ND, X86::ROL64rCL },
  { X86::ROL64rCL_NF_ND, X86::ROL64rCL_NF },
  { X86::ROL64ri_ND, X86::ROL64ri },
  { X86::ROL64ri_NF_ND, X86::ROL64ri_NF },
  { X86::ROL8r1_ND, X86::ROL8r1 },
  { X86::ROL8r1_NF_ND, X86::ROL8r1_NF },
  { X86::ROL8rCL_ND, X86::ROL8rCL },
  { X86::ROL8rCL_NF_ND, X86::ROL8rCL_NF },
  { X86::ROL8ri_ND, X86::ROL8ri },
  { X86::ROL8ri_NF_ND, X86::ROL8ri_NF },
  { X86::ROR16r1_ND, X86::ROR16r1 },
  { X86::ROR16r1_NF_ND, X86::ROR16r1_NF },
  { X86::ROR16rCL_ND, X86::ROR16rCL },
  { X86::ROR16rCL_NF_ND, X86::ROR16rCL_NF },
  { X86::ROR16ri_ND, X86::ROR16ri },
  { X86::ROR16ri_NF_ND, X86::ROR16ri_NF },
  { X86::ROR32r1_ND, X86::ROR32r1 },
  { X86::ROR32r1_NF_ND, X86::ROR32r1_NF },
  { X86::ROR32rCL_ND, X86::ROR32rCL },
  { X86::ROR32rCL_NF_ND, X86::ROR32rCL_NF },
  { X86::ROR32ri_ND, X86::ROR32ri },
  { X86::ROR32ri_NF_ND, X86::ROR32ri_NF },
  { X86::ROR64r1_ND, X86::ROR64r1 },
  { X86::ROR64r1_NF_ND, X86::ROR64r1_NF },
  { X86::ROR64rCL_ND, X86::ROR64rCL },
  { X86::ROR64rCL_NF_ND, X86::ROR64rCL_NF },
  { X86::ROR64ri_ND, X86::ROR64ri },
  { X86::ROR64ri_NF_ND, X86::ROR64ri_NF },
  { X86::ROR8r1_ND, X86::ROR8r1 },
  { X86::ROR8r1_NF_ND, X86::ROR8r1_NF },
  { X86::ROR8rCL_ND, X86::ROR8rCL },
  { X86::ROR8rCL_NF_ND, X86::ROR8rCL_NF },
  { X86::ROR8ri_ND, X86::ROR8ri },
  { X86::ROR8ri_NF_ND, X86::ROR8ri_NF },
  { X86::SAR16r1_ND, X86::SAR16r1 },
  { X86::SAR16r1_NF_ND, X86::SAR16r1_NF },
  { X86::SAR16rCL_ND, X86::SAR16rCL },
  { X86::SAR16rCL_NF_ND, X86::SAR16rCL_NF },
  { X86::SAR16ri_ND, X86::SAR16ri },
  { X86::SAR16ri_NF_ND, X86::SAR16ri_NF },
  { X86::SAR32r1_ND, X86::SAR32r1 },
  { X86::SAR32r1_NF_ND, X86::SAR32r1_NF },
  { X86::SAR32rCL_ND, X86::SAR32rCL },
  { X86::SAR32rCL_NF_ND, X86::SAR32rCL_NF },
  { X86::SAR32ri_ND, X86::SAR32ri },
  { X86::SAR32ri_NF_ND, X86::SAR32ri_NF },
  { X86::SAR64r1_ND, X86::SAR64r1 },
  { X86::SAR64r1_NF_ND, X86::SAR64r1_NF },
  { X86::SAR64rCL_ND, X86::SAR64rCL },
  { X86::SAR64rCL_NF_ND, X86::SAR64rCL_NF },
  { X86::SAR64ri_ND, X86::SAR64ri },
  { X86::SAR64ri_NF_ND, X86::SAR64ri_NF },
  { X86::SAR8r1_ND, X86::SAR8r1 },
  { X86::SAR8r1_NF_ND, X86::SAR8r1_NF },
  { X86::SAR8rCL_ND, X86::SAR8rCL },
  { X86::SAR8rCL_NF_ND, X86::SAR8rCL_NF },
  { X86::SAR8ri_ND, X86::SAR8ri },
  { X86::SAR8ri_NF_ND, X86::SAR8ri_NF },
  { X86::SBB16ri8_ND, X86::SBB16ri8 },
  { X86::SBB16ri_ND, X86::SBB16ri },
  { X86::SBB16rm_ND, X86::SBB16rm },
  { X86::SBB16rr_ND, X86::SBB16rr },
  { X86::SBB32ri8_ND, X86::SBB32ri8 },
  { X86::SBB32ri_ND, X86::SBB32ri },
  { X86::SBB32rm_ND, X86::SBB32rm },
  { X86::SBB32rr_ND, X86::SBB32rr },
  { X86::SBB64ri32_ND, X86::SBB64ri32 },
  { X86::SBB64ri8_ND, X86::SBB64ri8 },
  { X86::SBB64rm_ND, X86::SBB64rm },
  { X86::SBB64rr_ND, X86::SBB64rr },
  { X86::SBB8ri_ND, X86::SBB8ri },
  { X86::SBB8rm_ND, X86::SBB8rm },
  { X86::SBB8rr_ND, X86::SBB8rr },
  { X86::SHL16r1_ND, X86::SHL16r1 },
  { X86::SHL16r1_NF_ND, X86::SHL16r1_NF },
  { X86::SHL16rCL_ND, X86::SHL16rCL },
  { X86::SHL16rCL_NF_ND, X86::SHL16rCL_NF },
  { X86::SHL16ri_ND, X86::SHL16ri },
  { X86::SHL16ri_NF_ND, X86::SHL16ri_NF },
  { X86::SHL32r1_ND, X86::SHL32r1 },
  { X86::SHL32r1_NF_ND, X86::SHL32r1_NF },
  { X86::SHL32rCL_ND, X86::SHL32rCL },
  { X86::SHL32rCL_NF_ND, X86::SHL32rCL_NF },
  { X86::SHL32ri_ND, X86::SHL32ri },
  { X86::SHL32ri_NF_ND, X86::SHL32ri_NF },
  { X86::SHL64r1_ND, X86::SHL64r1 },
  { X86::SHL64r1_NF_ND, X86::SHL64r1_NF },
  { X86::SHL64rCL_ND, X86::SHL64rCL },
  { X86::SHL64rCL_NF_ND, X86::SHL64rCL_NF },
  { X86::SHL64ri_ND, X86::SHL64ri },
  { X86::SHL64ri_NF_ND, X86::SHL64ri_NF },
  { X86::SHL8r1_ND, X86::SHL8r1 },
  { X86::SHL8r1_NF_ND, X86::SHL8r1_NF },
  { X86::SHL8rCL_ND, X86::SHL8rCL },
  { X86::SHL8rCL_NF_ND, X86::SHL8rCL_NF },
  { X86::SHL8ri_ND, X86::SHL8ri },
  { X86::SHL8ri_NF_ND, X86::SHL8ri_NF },
  { X86::SHLD16rrCL_ND, X86::SHLD16rrCL },
  { X86::SHLD16rrCL_NF_ND, X86::SHLD16rrCL_NF },
  { X86::SHLD16rri8_ND, X86::SHLD16rri8 },
  { X86::SHLD16rri8_NF_ND, X86::SHLD16rri8_NF },
  { X86::SHLD32rrCL_ND, X86::SHLD32rrCL },
  { X86::SHLD32rrCL_NF_ND, X86::SHLD32rrCL_NF },
  { X86::SHLD32rri8_ND, X86::SHLD32rri8 },
  { X86::SHLD32rri8_NF_ND, X86::SHLD32rri8_NF },
  { X86::SHLD64rrCL_ND, X86::SHLD64rrCL },
  { X86::SHLD64rrCL_NF_ND, X86::SHLD64rrCL_NF },
  { X86::SHLD64rri8_ND, X86::SHLD64rri8 },
  { X86::SHLD64rri8_NF_ND, X86::SHLD64rri8_NF },
  { X86::SHR16r1_ND, X86::SHR16r1 },
  { X86::SHR16r1_NF_ND, X86::SHR16r1_NF },
  { X86::SHR16rCL_ND, X86::SHR16rCL },
  { X86::SHR16rCL_NF_ND, X86::SHR16rCL_NF },
  { X86::SHR16ri_ND, X86::SHR16ri },
  { X86::SHR16ri_NF_ND, X86::SHR16ri_NF },
  { X86::SHR32r1_ND, X86::SHR32r1 },
  { X86::SHR32r1_NF_ND, X86::SHR32r1_NF },
  { X86::SHR32rCL_ND, X86::SHR32rCL },
  { X86::SHR32rCL_NF_ND, X86::SHR32rCL_NF },
  { X86::SHR32ri_ND, X86::SHR32ri },
  { X86::SHR32ri_NF_ND, X86::SHR32ri_NF },
  { X86::SHR64r1_ND, X86::SHR64r1 },
  { X86::SHR64r1_NF_ND, X86::SHR64r1_NF },
  { X86::SHR64rCL_ND, X86::SHR64rCL },
  { X86::SHR64rCL_NF_ND, X86::SHR64rCL_NF },
  { X86::SHR64ri_ND, X86::SHR64ri },
  { X86::SHR64ri_NF_ND, X86::SHR64ri_NF },
  { X86::SHR8r1_ND, X86::SHR8r1 },
  { X86::SHR8r1_NF_ND, X86::SHR8r1_NF },
  { X86::SHR8rCL_ND, X86::SHR8rCL },
  { X86::SHR8rCL_NF_ND, X86::SHR8rCL_NF },
  { X86::SHR8ri_ND, X86::SHR8ri },
  { X86::SHR8ri_NF_ND, X86::SHR8ri_NF },
  { X86::SHRD16rrCL_ND, X86::SHRD16rrCL },
  { X86::SHRD16rrCL_NF_ND, X86::SHRD16rrCL_NF },
  { X86::SHRD16rri8_ND, X86::SHRD16rri8 },
  { X86::SHRD16rri8_NF_ND, X86::SHRD16rri8_NF },
  { X86::SHRD32rrCL_ND, X86::SHRD32rrCL },
  { X86::SHRD32rrCL_NF_ND, X86::SHRD32rrCL_NF },
  { X86::SHRD32rri8_ND, X86::SHRD32rri8 },
  { X86::SHRD32rri8_NF_ND, X86::SHRD32rri8_NF },
  { X86::SHRD64rrCL_ND, X86::SHRD64rrCL },
  { X86::SHRD64rrCL_NF_ND, X86::SHRD64rrCL_NF },
  { X86::SHRD64rri8_ND, X86::SHRD64rri8 },
  { X86::SHRD64rri8_NF_ND, X86::SHRD64rri8_NF },
  { X86::SUB16ri8_ND, X86::SUB16ri8 },
  { X86::SUB16ri8_NF_ND, X86::SUB16ri8_NF },
  { X86::SUB16ri_ND, X86::SUB16ri },
  { X86::SUB16ri_NF_ND, X86::SUB16ri_NF },
  { X86::SUB16rm_ND, X86::SUB16rm },
  { X86::SUB16rm_NF_ND, X86::SUB16rm_NF },
  { X86::SUB16rr_ND, X86::SUB16rr },
  { X86::SUB16rr_NF_ND, X86::SUB16rr_NF },
  { X86::SUB32ri8_ND, X86::SUB32ri8 },
  { X86::SUB32ri8_NF_ND, X86::SUB32ri8_NF },
  { X86::SUB32ri_ND, X86::SUB32ri },
  { X86::SUB32ri_NF_ND, X86::SUB32ri_NF },
  { X86::SUB32rm_ND, X86::SUB32rm },
  { X86::SUB32rm_NF_ND, X86::SUB32rm_NF },
  { X86::SUB32rr_ND, X86::SUB32rr },
  { X86::SUB32rr_NF_ND, X86::SUB32rr_NF },
  { X86::SUB64ri32_ND, X86::SUB64ri32 },
  { X86::SUB64ri32_NF_ND, X86::SUB64ri32_NF },
  { X86::SUB64ri8_ND, X86::SUB64ri8 },
  { X86::SUB64ri8_NF_ND, X86::SUB64ri8_NF },
  { X86::SUB64rm_ND, X86::SUB64rm },
  { X86::SUB64rm_NF_ND, X86::SUB64rm_NF },
  { X86::SUB64rr_ND, X86::SUB64rr },
  { X86::SUB64rr_NF_ND, X86::SUB64rr_NF },
  { X86::SUB8ri_ND, X86::SUB8ri },
  { X86::SUB8ri_NF_ND, X86::SUB8ri_NF },
  { X86::SUB8rm_ND, X86::SUB8rm },
  { X86::SUB8rm_NF_ND, X86::SUB8rm_NF },
  { X86::SUB8rr_ND, X86::SUB8rr },
  { X86::SUB8rr_NF_ND, X86::SUB8rr_NF },
  { X86::XOR16ri8_ND, X86::XOR16ri8 },
  { X86::XOR16ri8_NF_ND, X86::XOR16ri8_NF },
  { X86::XOR16ri_ND, X86::XOR16ri },
  { X86::XOR16ri_NF_ND, X86::XOR16ri_NF },
  { X86::XOR16rm_ND, X86::XOR16rm },
  { X86::XOR16rm_NF_ND, X86::XOR16rm_NF },
  { X86::XOR16rr_ND, X86::XOR16rr },
  { X86::XOR16rr_NF_ND, X86::XOR16rr_NF },
  { X86::XOR32ri8_ND, X86::XOR32ri8 },
  { X86::XOR32ri8_NF_ND, X86::XOR32ri8_NF },
  { X86::XOR32ri_ND, X86::XOR32ri },
  { X86::XOR32ri_NF_ND, X86::XOR32ri_NF },
  { X86::XOR32rm_ND, X86::XOR32rm },
  { X86::XOR32rm_NF_ND, X86::XOR32rm_NF },
  { X86::XOR32rr_ND, X86::XOR32rr },
  { X86::XOR32rr_NF_ND, X86::XOR32rr_NF },
  { X86::XOR64ri32_ND, X86::XOR64ri32 },
  { X86::XOR64ri32_NF_ND, X86::XOR64ri32_NF },
  { X86::XOR64ri8_ND, X86::XOR64ri8 },
  { X86::XOR64ri8_NF_ND, X86::XOR64ri8_NF },
  { X86::XOR64rm_ND, X86::XOR64rm },
  { X86::XOR64rm_NF_ND, X86::XOR64rm_NF },
  { X86::XOR64rr_ND, X86::XOR64rr },
  { X86::XOR64rr_NF_ND, X86::XOR64rr_NF },
  { X86::XOR8ri_ND, X86::XOR8ri },
  { X86::XOR8ri_NF_ND, X86::XOR8ri_NF },
  { X86::XOR8rm_ND, X86::XOR8rm },
  { X86::XOR8rm_NF_ND, X86::XOR8rm_NF },
  { X86::XOR8rr_ND, X86::XOR8rr },
  { X86::XOR8rr_NF_ND, X86::XOR8rr_NF },
};

#endif // GET_X86_ND2NONND_TABLE


#ifdef GET_X86_SSE2AVX_TABLE
static const X86TableEntry X86SSE2AVXTable[] = {
  { X86::ADDPDrm, X86::VADDPDrm },
  { X86::ADDPDrr, X86::VADDPDrr },
  { X86::ADDPSrm, X86::VADDPSrm },
  { X86::ADDPSrr, X86::VADDPSrr },
  { X86::ADDSDrm, X86::VADDSDrm },
  { X86::ADDSDrm_Int, X86::VADDSDrm_Int },
  { X86::ADDSDrr, X86::VADDSDrr },
  { X86::ADDSDrr_Int, X86::VADDSDrr_Int },
  { X86::ADDSSrm, X86::VADDSSrm },
  { X86::ADDSSrm_Int, X86::VADDSSrm_Int },
  { X86::ADDSSrr, X86::VADDSSrr },
  { X86::ADDSSrr_Int, X86::VADDSSrr_Int },
  { X86::ADDSUBPDrm, X86::VADDSUBPDrm },
  { X86::ADDSUBPDrr, X86::VADDSUBPDrr },
  { X86::ADDSUBPSrm, X86::VADDSUBPSrm },
  { X86::ADDSUBPSrr, X86::VADDSUBPSrr },
  { X86::AESDECLASTrm, X86::VAESDECLASTrm },
  { X86::AESDECLASTrr, X86::VAESDECLASTrr },
  { X86::AESDECrm, X86::VAESDECrm },
  { X86::AESDECrr, X86::VAESDECrr },
  { X86::AESENCLASTrm, X86::VAESENCLASTrm },
  { X86::AESENCLASTrr, X86::VAESENCLASTrr },
  { X86::AESENCrm, X86::VAESENCrm },
  { X86::AESENCrr, X86::VAESENCrr },
  { X86::AESIMCrm, X86::VAESIMCrm },
  { X86::AESIMCrr, X86::VAESIMCrr },
  { X86::AESKEYGENASSIST128rm, X86::VAESKEYGENASSIST128rm },
  { X86::AESKEYGENASSIST128rr, X86::VAESKEYGENASSIST128rr },
  { X86::ANDNPDrm, X86::VANDNPDrm },
  { X86::ANDNPDrr, X86::VANDNPDrr },
  { X86::ANDNPSrm, X86::VANDNPSrm },
  { X86::ANDNPSrr, X86::VANDNPSrr },
  { X86::ANDPDrm, X86::VANDPDrm },
  { X86::ANDPDrr, X86::VANDPDrr },
  { X86::ANDPSrm, X86::VANDPSrm },
  { X86::ANDPSrr, X86::VANDPSrr },
  { X86::BLENDPDrmi, X86::VBLENDPDrmi },
  { X86::BLENDPDrri, X86::VBLENDPDrri },
  { X86::BLENDPSrmi, X86::VBLENDPSrmi },
  { X86::BLENDPSrri, X86::VBLENDPSrri },
  { X86::BLENDVPDrm0, X86::VBLENDVPDrmr },
  { X86::BLENDVPDrr0, X86::VBLENDVPDrrr },
  { X86::BLENDVPSrm0, X86::VBLENDVPSrmr },
  { X86::BLENDVPSrr0, X86::VBLENDVPSrrr },
  { X86::CMPPDrmi, X86::VCMPPDrmi },
  { X86::CMPPDrri, X86::VCMPPDrri },
  { X86::CMPPSrmi, X86::VCMPPSrmi },
  { X86::CMPPSrri, X86::VCMPPSrri },
  { X86::CMPSDrmi, X86::VCMPSDrmi },
  { X86::CMPSDrmi_Int, X86::VCMPSDrmi_Int },
  { X86::CMPSDrri, X86::VCMPSDrri },
  { X86::CMPSDrri_Int, X86::VCMPSDrri_Int },
  { X86::CMPSSrmi, X86::VCMPSSrmi },
  { X86::CMPSSrmi_Int, X86::VCMPSSrmi_Int },
  { X86::CMPSSrri, X86::VCMPSSrri },
  { X86::CMPSSrri_Int, X86::VCMPSSrri_Int },
  { X86::COMISDrm, X86::VCOMISDrm },
  { X86::COMISDrm_Int, X86::VCOMISDrm_Int },
  { X86::COMISDrr, X86::VCOMISDrr },
  { X86::COMISDrr_Int, X86::VCOMISDrr_Int },
  { X86::COMISSrm, X86::VCOMISSrm },
  { X86::COMISSrm_Int, X86::VCOMISSrm_Int },
  { X86::COMISSrr, X86::VCOMISSrr },
  { X86::COMISSrr_Int, X86::VCOMISSrr_Int },
  { X86::CVTDQ2PDrm, X86::VCVTDQ2PDrm },
  { X86::CVTDQ2PDrr, X86::VCVTDQ2PDrr },
  { X86::CVTDQ2PSrm, X86::VCVTDQ2PSrm },
  { X86::CVTDQ2PSrr, X86::VCVTDQ2PSrr },
  { X86::CVTPD2DQrm, X86::VCVTPD2DQrm },
  { X86::CVTPD2DQrr, X86::VCVTPD2DQrr },
  { X86::CVTPD2PSrm, X86::VCVTPD2PSrm },
  { X86::CVTPD2PSrr, X86::VCVTPD2PSrr },
  { X86::CVTPS2DQrm, X86::VCVTPS2DQrm },
  { X86::CVTPS2DQrr, X86::VCVTPS2DQrr },
  { X86::CVTPS2PDrm, X86::VCVTPS2PDrm },
  { X86::CVTPS2PDrr, X86::VCVTPS2PDrr },
  { X86::CVTSD2SI64rm, X86::VCVTSD2SI64rm },
  { X86::CVTSD2SI64rm_Int, X86::VCVTSD2SI64rm_Int },
  { X86::CVTSD2SI64rr, X86::VCVTSD2SI64rr },
  { X86::CVTSD2SI64rr_Int, X86::VCVTSD2SI64rr_Int },
  { X86::CVTSD2SIrm, X86::VCVTSD2SIrm },
  { X86::CVTSD2SIrm_Int, X86::VCVTSD2SIrm_Int },
  { X86::CVTSD2SIrr, X86::VCVTSD2SIrr },
  { X86::CVTSD2SIrr_Int, X86::VCVTSD2SIrr_Int },
  { X86::CVTSD2SSrm, X86::VCVTSD2SSrm },
  { X86::CVTSD2SSrm_Int, X86::VCVTSD2SSrm_Int },
  { X86::CVTSD2SSrr, X86::VCVTSD2SSrr },
  { X86::CVTSD2SSrr_Int, X86::VCVTSD2SSrr_Int },
  { X86::CVTSI2SDrm, X86::VCVTSI2SDrm },
  { X86::CVTSI2SDrm_Int, X86::VCVTSI2SDrm_Int },
  { X86::CVTSI2SDrr, X86::VCVTSI2SDrr },
  { X86::CVTSI2SDrr_Int, X86::VCVTSI2SDrr_Int },
  { X86::CVTSI2SSrm, X86::VCVTSI2SSrm },
  { X86::CVTSI2SSrm_Int, X86::VCVTSI2SSrm_Int },
  { X86::CVTSI2SSrr, X86::VCVTSI2SSrr },
  { X86::CVTSI2SSrr_Int, X86::VCVTSI2SSrr_Int },
  { X86::CVTSI642SDrm, X86::VCVTSI642SDrm },
  { X86::CVTSI642SDrm_Int, X86::VCVTSI642SDrm_Int },
  { X86::CVTSI642SDrr, X86::VCVTSI642SDrr },
  { X86::CVTSI642SDrr_Int, X86::VCVTSI642SDrr_Int },
  { X86::CVTSI642SSrm, X86::VCVTSI642SSrm },
  { X86::CVTSI642SSrm_Int, X86::VCVTSI642SSrm_Int },
  { X86::CVTSI642SSrr, X86::VCVTSI642SSrr },
  { X86::CVTSI642SSrr_Int, X86::VCVTSI642SSrr_Int },
  { X86::CVTSS2SDrm, X86::VCVTSS2SDrm },
  { X86::CVTSS2SDrm_Int, X86::VCVTSS2SDrm_Int },
  { X86::CVTSS2SDrr, X86::VCVTSS2SDrr },
  { X86::CVTSS2SDrr_Int, X86::VCVTSS2SDrr_Int },
  { X86::CVTSS2SI64rm, X86::VCVTSS2SI64rm },
  { X86::CVTSS2SI64rm_Int, X86::VCVTSS2SI64rm_Int },
  { X86::CVTSS2SI64rr, X86::VCVTSS2SI64rr },
  { X86::CVTSS2SI64rr_Int, X86::VCVTSS2SI64rr_Int },
  { X86::CVTSS2SIrm, X86::VCVTSS2SIrm },
  { X86::CVTSS2SIrm_Int, X86::VCVTSS2SIrm_Int },
  { X86::CVTSS2SIrr, X86::VCVTSS2SIrr },
  { X86::CVTSS2SIrr_Int, X86::VCVTSS2SIrr_Int },
  { X86::CVTTPD2DQrm, X86::VCVTTPD2DQrm },
  { X86::CVTTPD2DQrr, X86::VCVTTPD2DQrr },
  { X86::CVTTPS2DQrm, X86::VCVTTPS2DQrm },
  { X86::CVTTPS2DQrr, X86::VCVTTPS2DQrr },
  { X86::CVTTSD2SI64rm, X86::VCVTTSD2SI64rm },
  { X86::CVTTSD2SI64rm_Int, X86::VCVTTSD2SI64rm_Int },
  { X86::CVTTSD2SI64rr, X86::VCVTTSD2SI64rr },
  { X86::CVTTSD2SI64rr_Int, X86::VCVTTSD2SI64rr_Int },
  { X86::CVTTSD2SIrm, X86::VCVTTSD2SIrm },
  { X86::CVTTSD2SIrm_Int, X86::VCVTTSD2SIrm_Int },
  { X86::CVTTSD2SIrr, X86::VCVTTSD2SIrr },
  { X86::CVTTSD2SIrr_Int, X86::VCVTTSD2SIrr_Int },
  { X86::CVTTSS2SI64rm, X86::VCVTTSS2SI64rm },
  { X86::CVTTSS2SI64rm_Int, X86::VCVTTSS2SI64rm_Int },
  { X86::CVTTSS2SI64rr, X86::VCVTTSS2SI64rr },
  { X86::CVTTSS2SI64rr_Int, X86::VCVTTSS2SI64rr_Int },
  { X86::CVTTSS2SIrm, X86::VCVTTSS2SIrm },
  { X86::CVTTSS2SIrm_Int, X86::VCVTTSS2SIrm_Int },
  { X86::CVTTSS2SIrr, X86::VCVTTSS2SIrr },
  { X86::CVTTSS2SIrr_Int, X86::VCVTTSS2SIrr_Int },
  { X86::DIVPDrm, X86::VDIVPDrm },
  { X86::DIVPDrr, X86::VDIVPDrr },
  { X86::DIVPSrm, X86::VDIVPSrm },
  { X86::DIVPSrr, X86::VDIVPSrr },
  { X86::DIVSDrm, X86::VDIVSDrm },
  { X86::DIVSDrm_Int, X86::VDIVSDrm_Int },
  { X86::DIVSDrr, X86::VDIVSDrr },
  { X86::DIVSDrr_Int, X86::VDIVSDrr_Int },
  { X86::DIVSSrm, X86::VDIVSSrm },
  { X86::DIVSSrm_Int, X86::VDIVSSrm_Int },
  { X86::DIVSSrr, X86::VDIVSSrr },
  { X86::DIVSSrr_Int, X86::VDIVSSrr_Int },
  { X86::DPPDrmi, X86::VDPPDrmi },
  { X86::DPPDrri, X86::VDPPDrri },
  { X86::DPPSrmi, X86::VDPPSrmi },
  { X86::DPPSrri, X86::VDPPSrri },
  { X86::EXTRACTPSmri, X86::VEXTRACTPSmri },
  { X86::EXTRACTPSrri, X86::VEXTRACTPSrri },
  { X86::GF2P8AFFINEINVQBrmi, X86::VGF2P8AFFINEINVQBrmi },
  { X86::GF2P8AFFINEINVQBrri, X86::VGF2P8AFFINEINVQBrri },
  { X86::GF2P8AFFINEQBrmi, X86::VGF2P8AFFINEQBrmi },
  { X86::GF2P8AFFINEQBrri, X86::VGF2P8AFFINEQBrri },
  { X86::GF2P8MULBrm, X86::VGF2P8MULBrm },
  { X86::GF2P8MULBrr, X86::VGF2P8MULBrr },
  { X86::HADDPDrm, X86::VHADDPDrm },
  { X86::HADDPDrr, X86::VHADDPDrr },
  { X86::HADDPSrm, X86::VHADDPSrm },
  { X86::HADDPSrr, X86::VHADDPSrr },
  { X86::HSUBPDrm, X86::VHSUBPDrm },
  { X86::HSUBPDrr, X86::VHSUBPDrr },
  { X86::HSUBPSrm, X86::VHSUBPSrm },
  { X86::HSUBPSrr, X86::VHSUBPSrr },
  { X86::INSERTPSrmi, X86::VINSERTPSrmi },
  { X86::INSERTPSrri, X86::VINSERTPSrri },
  { X86::LDDQUrm, X86::VLDDQUrm },
  { X86::LDMXCSR, X86::VLDMXCSR },
  { X86::MASKMOVDQU, X86::VMASKMOVDQU },
  { X86::MASKMOVDQU64, X86::VMASKMOVDQU64 },
  { X86::MAXCPDrm, X86::VMAXCPDrm },
  { X86::MAXCPDrr, X86::VMAXCPDrr },
  { X86::MAXCPSrm, X86::VMAXCPSrm },
  { X86::MAXCPSrr, X86::VMAXCPSrr },
  { X86::MAXCSDrm, X86::VMAXCSDrm },
  { X86::MAXCSDrr, X86::VMAXCSDrr },
  { X86::MAXCSSrm, X86::VMAXCSSrm },
  { X86::MAXCSSrr, X86::VMAXCSSrr },
  { X86::MAXPDrm, X86::VMAXPDrm },
  { X86::MAXPDrr, X86::VMAXPDrr },
  { X86::MAXPSrm, X86::VMAXPSrm },
  { X86::MAXPSrr, X86::VMAXPSrr },
  { X86::MAXSDrm, X86::VMAXSDrm },
  { X86::MAXSDrm_Int, X86::VMAXSDrm_Int },
  { X86::MAXSDrr, X86::VMAXSDrr },
  { X86::MAXSDrr_Int, X86::VMAXSDrr_Int },
  { X86::MAXSSrm, X86::VMAXSSrm },
  { X86::MAXSSrm_Int, X86::VMAXSSrm_Int },
  { X86::MAXSSrr, X86::VMAXSSrr },
  { X86::MAXSSrr_Int, X86::VMAXSSrr_Int },
  { X86::MINCPDrm, X86::VMINCPDrm },
  { X86::MINCPDrr, X86::VMINCPDrr },
  { X86::MINCPSrm, X86::VMINCPSrm },
  { X86::MINCPSrr, X86::VMINCPSrr },
  { X86::MINCSDrm, X86::VMINCSDrm },
  { X86::MINCSDrr, X86::VMINCSDrr },
  { X86::MINCSSrm, X86::VMINCSSrm },
  { X86::MINCSSrr, X86::VMINCSSrr },
  { X86::MINPDrm, X86::VMINPDrm },
  { X86::MINPDrr, X86::VMINPDrr },
  { X86::MINPSrm, X86::VMINPSrm },
  { X86::MINPSrr, X86::VMINPSrr },
  { X86::MINSDrm, X86::VMINSDrm },
  { X86::MINSDrm_Int, X86::VMINSDrm_Int },
  { X86::MINSDrr, X86::VMINSDrr },
  { X86::MINSDrr_Int, X86::VMINSDrr_Int },
  { X86::MINSSrm, X86::VMINSSrm },
  { X86::MINSSrm_Int, X86::VMINSSrm_Int },
  { X86::MINSSrr, X86::VMINSSrr },
  { X86::MINSSrr_Int, X86::VMINSSrr_Int },
  { X86::MOV64toPQIrm, X86::VMOV64toPQIrm },
  { X86::MOV64toPQIrr, X86::VMOV64toPQIrr },
  { X86::MOV64toSDrr, X86::VMOV64toSDrr },
  { X86::MOVAPDmr, X86::VMOVAPDmr },
  { X86::MOVAPDrm, X86::VMOVAPDrm },
  { X86::MOVAPDrr, X86::VMOVAPDrr },
  { X86::MOVAPSmr, X86::VMOVAPSmr },
  { X86::MOVAPSrm, X86::VMOVAPSrm },
  { X86::MOVAPSrr, X86::VMOVAPSrr },
  { X86::MOVDDUPrm, X86::VMOVDDUPrm },
  { X86::MOVDDUPrr, X86::VMOVDDUPrr },
  { X86::MOVDI2PDIrm, X86::VMOVDI2PDIrm },
  { X86::MOVDI2PDIrr, X86::VMOVDI2PDIrr },
  { X86::MOVDI2SSrr, X86::VMOVDI2SSrr },
  { X86::MOVDQAmr, X86::VMOVDQAmr },
  { X86::MOVDQArm, X86::VMOVDQArm },
  { X86::MOVDQArr, X86::VMOVDQArr },
  { X86::MOVDQUmr, X86::VMOVDQUmr },
  { X86::MOVDQUrm, X86::VMOVDQUrm },
  { X86::MOVDQUrr, X86::VMOVDQUrr },
  { X86::MOVHLPSrr, X86::VMOVHLPSrr },
  { X86::MOVHPDmr, X86::VMOVHPDmr },
  { X86::MOVHPDrm, X86::VMOVHPDrm },
  { X86::MOVHPSmr, X86::VMOVHPSmr },
  { X86::MOVHPSrm, X86::VMOVHPSrm },
  { X86::MOVLHPSrr, X86::VMOVLHPSrr },
  { X86::MOVLPDmr, X86::VMOVLPDmr },
  { X86::MOVLPDrm, X86::VMOVLPDrm },
  { X86::MOVLPSmr, X86::VMOVLPSmr },
  { X86::MOVLPSrm, X86::VMOVLPSrm },
  { X86::MOVMSKPDrr, X86::VMOVMSKPDrr },
  { X86::MOVMSKPSrr, X86::VMOVMSKPSrr },
  { X86::MOVNTDQArm, X86::VMOVNTDQArm },
  { X86::MOVNTDQmr, X86::VMOVNTDQmr },
  { X86::MOVNTPDmr, X86::VMOVNTPDmr },
  { X86::MOVNTPSmr, X86::VMOVNTPSmr },
  { X86::MOVPDI2DImr, X86::VMOVPDI2DImr },
  { X86::MOVPDI2DIrr, X86::VMOVPDI2DIrr },
  { X86::MOVPQI2QImr, X86::VMOVPQI2QImr },
  { X86::MOVPQI2QIrr, X86::VMOVPQI2QIrr },
  { X86::MOVPQIto64mr, X86::VMOVPQIto64mr },
  { X86::MOVPQIto64rr, X86::VMOVPQIto64rr },
  { X86::MOVQI2PQIrm, X86::VMOVQI2PQIrm },
  { X86::MOVSDmr, X86::VMOVSDmr },
  { X86::MOVSDrm, X86::VMOVSDrm },
  { X86::MOVSDrm_alt, X86::VMOVSDrm_alt },
  { X86::MOVSDrr, X86::VMOVSDrr },
  { X86::MOVSDto64rr, X86::VMOVSDto64rr },
  { X86::MOVSHDUPrm, X86::VMOVSHDUPrm },
  { X86::MOVSHDUPrr, X86::VMOVSHDUPrr },
  { X86::MOVSLDUPrm, X86::VMOVSLDUPrm },
  { X86::MOVSLDUPrr, X86::VMOVSLDUPrr },
  { X86::MOVSS2DIrr, X86::VMOVSS2DIrr },
  { X86::MOVSSmr, X86::VMOVSSmr },
  { X86::MOVSSrm, X86::VMOVSSrm },
  { X86::MOVSSrm_alt, X86::VMOVSSrm_alt },
  { X86::MOVSSrr, X86::VMOVSSrr },
  { X86::MOVUPDmr, X86::VMOVUPDmr },
  { X86::MOVUPDrm, X86::VMOVUPDrm },
  { X86::MOVUPDrr, X86::VMOVUPDrr },
  { X86::MOVUPSmr, X86::VMOVUPSmr },
  { X86::MOVUPSrm, X86::VMOVUPSrm },
  { X86::MOVUPSrr, X86::VMOVUPSrr },
  { X86::MOVZPQILo2PQIrr, X86::VMOVZPQILo2PQIrr },
  { X86::MPSADBWrmi, X86::VMPSADBWrmi },
  { X86::MPSADBWrri, X86::VMPSADBWrri },
  { X86::MULPDrm, X86::VMULPDrm },
  { X86::MULPDrr, X86::VMULPDrr },
  { X86::MULPSrm, X86::VMULPSrm },
  { X86::MULPSrr, X86::VMULPSrr },
  { X86::MULSDrm, X86::VMULSDrm },
  { X86::MULSDrm_Int, X86::VMULSDrm_Int },
  { X86::MULSDrr, X86::VMULSDrr },
  { X86::MULSDrr_Int, X86::VMULSDrr_Int },
  { X86::MULSSrm, X86::VMULSSrm },
  { X86::MULSSrm_Int, X86::VMULSSrm_Int },
  { X86::MULSSrr, X86::VMULSSrr },
  { X86::MULSSrr_Int, X86::VMULSSrr_Int },
  { X86::ORPDrm, X86::VORPDrm },
  { X86::ORPDrr, X86::VORPDrr },
  { X86::ORPSrm, X86::VORPSrm },
  { X86::ORPSrr, X86::VORPSrr },
  { X86::PABSBrm, X86::VPABSBrm },
  { X86::PABSBrr, X86::VPABSBrr },
  { X86::PABSDrm, X86::VPABSDrm },
  { X86::PABSDrr, X86::VPABSDrr },
  { X86::PABSWrm, X86::VPABSWrm },
  { X86::PABSWrr, X86::VPABSWrr },
  { X86::PACKSSDWrm, X86::VPACKSSDWrm },
  { X86::PACKSSDWrr, X86::VPACKSSDWrr },
  { X86::PACKSSWBrm, X86::VPACKSSWBrm },
  { X86::PACKSSWBrr, X86::VPACKSSWBrr },
  { X86::PACKUSDWrm, X86::VPACKUSDWrm },
  { X86::PACKUSDWrr, X86::VPACKUSDWrr },
  { X86::PACKUSWBrm, X86::VPACKUSWBrm },
  { X86::PACKUSWBrr, X86::VPACKUSWBrr },
  { X86::PADDBrm, X86::VPADDBrm },
  { X86::PADDBrr, X86::VPADDBrr },
  { X86::PADDDrm, X86::VPADDDrm },
  { X86::PADDDrr, X86::VPADDDrr },
  { X86::PADDQrm, X86::VPADDQrm },
  { X86::PADDQrr, X86::VPADDQrr },
  { X86::PADDSBrm, X86::VPADDSBrm },
  { X86::PADDSBrr, X86::VPADDSBrr },
  { X86::PADDSWrm, X86::VPADDSWrm },
  { X86::PADDSWrr, X86::VPADDSWrr },
  { X86::PADDUSBrm, X86::VPADDUSBrm },
  { X86::PADDUSBrr, X86::VPADDUSBrr },
  { X86::PADDUSWrm, X86::VPADDUSWrm },
  { X86::PADDUSWrr, X86::VPADDUSWrr },
  { X86::PADDWrm, X86::VPADDWrm },
  { X86::PADDWrr, X86::VPADDWrr },
  { X86::PALIGNRrmi, X86::VPALIGNRrmi },
  { X86::PALIGNRrri, X86::VPALIGNRrri },
  { X86::PANDNrm, X86::VPANDNrm },
  { X86::PANDNrr, X86::VPANDNrr },
  { X86::PANDrm, X86::VPANDrm },
  { X86::PANDrr, X86::VPANDrr },
  { X86::PAVGBrm, X86::VPAVGBrm },
  { X86::PAVGBrr, X86::VPAVGBrr },
  { X86::PAVGWrm, X86::VPAVGWrm },
  { X86::PAVGWrr, X86::VPAVGWrr },
  { X86::PBLENDVBrm0, X86::VPBLENDVBrmr },
  { X86::PBLENDVBrr0, X86::VPBLENDVBrrr },
  { X86::PBLENDWrmi, X86::VPBLENDWrmi },
  { X86::PBLENDWrri, X86::VPBLENDWrri },
  { X86::PCLMULQDQrmi, X86::VPCLMULQDQrmi },
  { X86::PCLMULQDQrri, X86::VPCLMULQDQrri },
  { X86::PCMPEQBrm, X86::VPCMPEQBrm },
  { X86::PCMPEQBrr, X86::VPCMPEQBrr },
  { X86::PCMPEQDrm, X86::VPCMPEQDrm },
  { X86::PCMPEQDrr, X86::VPCMPEQDrr },
  { X86::PCMPEQQrm, X86::VPCMPEQQrm },
  { X86::PCMPEQQrr, X86::VPCMPEQQrr },
  { X86::PCMPEQWrm, X86::VPCMPEQWrm },
  { X86::PCMPEQWrr, X86::VPCMPEQWrr },
  { X86::PCMPESTRIrmi, X86::VPCMPESTRIrmi },
  { X86::PCMPESTRIrri, X86::VPCMPESTRIrri },
  { X86::PCMPESTRMrmi, X86::VPCMPESTRMrmi },
  { X86::PCMPESTRMrri, X86::VPCMPESTRMrri },
  { X86::PCMPGTBrm, X86::VPCMPGTBrm },
  { X86::PCMPGTBrr, X86::VPCMPGTBrr },
  { X86::PCMPGTDrm, X86::VPCMPGTDrm },
  { X86::PCMPGTDrr, X86::VPCMPGTDrr },
  { X86::PCMPGTQrm, X86::VPCMPGTQrm },
  { X86::PCMPGTQrr, X86::VPCMPGTQrr },
  { X86::PCMPGTWrm, X86::VPCMPGTWrm },
  { X86::PCMPGTWrr, X86::VPCMPGTWrr },
  { X86::PCMPISTRIrmi, X86::VPCMPISTRIrmi },
  { X86::PCMPISTRIrri, X86::VPCMPISTRIrri },
  { X86::PCMPISTRMrmi, X86::VPCMPISTRMrmi },
  { X86::PCMPISTRMrri, X86::VPCMPISTRMrri },
  { X86::PEXTRBmri, X86::VPEXTRBmri },
  { X86::PEXTRBrri, X86::VPEXTRBrri },
  { X86::PEXTRDmri, X86::VPEXTRDmri },
  { X86::PEXTRDrri, X86::VPEXTRDrri },
  { X86::PEXTRQmri, X86::VPEXTRQmri },
  { X86::PEXTRQrri, X86::VPEXTRQrri },
  { X86::PEXTRWmri, X86::VPEXTRWmri },
  { X86::PEXTRWrri, X86::VPEXTRWrri },
  { X86::PHADDDrm, X86::VPHADDDrm },
  { X86::PHADDDrr, X86::VPHADDDrr },
  { X86::PHADDSWrm, X86::VPHADDSWrm },
  { X86::PHADDSWrr, X86::VPHADDSWrr },
  { X86::PHADDWrm, X86::VPHADDWrm },
  { X86::PHADDWrr, X86::VPHADDWrr },
  { X86::PHMINPOSUWrm, X86::VPHMINPOSUWrm },
  { X86::PHMINPOSUWrr, X86::VPHMINPOSUWrr },
  { X86::PHSUBDrm, X86::VPHSUBDrm },
  { X86::PHSUBDrr, X86::VPHSUBDrr },
  { X86::PHSUBSWrm, X86::VPHSUBSWrm },
  { X86::PHSUBSWrr, X86::VPHSUBSWrr },
  { X86::PHSUBWrm, X86::VPHSUBWrm },
  { X86::PHSUBWrr, X86::VPHSUBWrr },
  { X86::PINSRBrmi, X86::VPINSRBrmi },
  { X86::PINSRBrri, X86::VPINSRBrri },
  { X86::PINSRDrmi, X86::VPINSRDrmi },
  { X86::PINSRDrri, X86::VPINSRDrri },
  { X86::PINSRQrmi, X86::VPINSRQrmi },
  { X86::PINSRQrri, X86::VPINSRQrri },
  { X86::PINSRWrmi, X86::VPINSRWrmi },
  { X86::PINSRWrri, X86::VPINSRWrri },
  { X86::PMADDUBSWrm, X86::VPMADDUBSWrm },
  { X86::PMADDUBSWrr, X86::VPMADDUBSWrr },
  { X86::PMADDWDrm, X86::VPMADDWDrm },
  { X86::PMADDWDrr, X86::VPMADDWDrr },
  { X86::PMAXSBrm, X86::VPMAXSBrm },
  { X86::PMAXSBrr, X86::VPMAXSBrr },
  { X86::PMAXSDrm, X86::VPMAXSDrm },
  { X86::PMAXSDrr, X86::VPMAXSDrr },
  { X86::PMAXSWrm, X86::VPMAXSWrm },
  { X86::PMAXSWrr, X86::VPMAXSWrr },
  { X86::PMAXUBrm, X86::VPMAXUBrm },
  { X86::PMAXUBrr, X86::VPMAXUBrr },
  { X86::PMAXUDrm, X86::VPMAXUDrm },
  { X86::PMAXUDrr, X86::VPMAXUDrr },
  { X86::PMAXUWrm, X86::VPMAXUWrm },
  { X86::PMAXUWrr, X86::VPMAXUWrr },
  { X86::PMINSBrm, X86::VPMINSBrm },
  { X86::PMINSBrr, X86::VPMINSBrr },
  { X86::PMINSDrm, X86::VPMINSDrm },
  { X86::PMINSDrr, X86::VPMINSDrr },
  { X86::PMINSWrm, X86::VPMINSWrm },
  { X86::PMINSWrr, X86::VPMINSWrr },
  { X86::PMINUBrm, X86::VPMINUBrm },
  { X86::PMINUBrr, X86::VPMINUBrr },
  { X86::PMINUDrm, X86::VPMINUDrm },
  { X86::PMINUDrr, X86::VPMINUDrr },
  { X86::PMINUWrm, X86::VPMINUWrm },
  { X86::PMINUWrr, X86::VPMINUWrr },
  { X86::PMOVMSKBrr, X86::VPMOVMSKBrr },
  { X86::PMOVSXBDrm, X86::VPMOVSXBDrm },
  { X86::PMOVSXBDrr, X86::VPMOVSXBDrr },
  { X86::PMOVSXBQrm, X86::VPMOVSXBQrm },
  { X86::PMOVSXBQrr, X86::VPMOVSXBQrr },
  { X86::PMOVSXBWrm, X86::VPMOVSXBWrm },
  { X86::PMOVSXBWrr, X86::VPMOVSXBWrr },
  { X86::PMOVSXDQrm, X86::VPMOVSXDQrm },
  { X86::PMOVSXDQrr, X86::VPMOVSXDQrr },
  { X86::PMOVSXWDrm, X86::VPMOVSXWDrm },
  { X86::PMOVSXWDrr, X86::VPMOVSXWDrr },
  { X86::PMOVSXWQrm, X86::VPMOVSXWQrm },
  { X86::PMOVSXWQrr, X86::VPMOVSXWQrr },
  { X86::PMOVZXBDrm, X86::VPMOVZXBDrm },
  { X86::PMOVZXBDrr, X86::VPMOVZXBDrr },
  { X86::PMOVZXBQrm, X86::VPMOVZXBQrm },
  { X86::PMOVZXBQrr, X86::VPMOVZXBQrr },
  { X86::PMOVZXBWrm, X86::VPMOVZXBWrm },
  { X86::PMOVZXBWrr, X86::VPMOVZXBWrr },
  { X86::PMOVZXDQrm, X86::VPMOVZXDQrm },
  { X86::PMOVZXDQrr, X86::VPMOVZXDQrr },
  { X86::PMOVZXWDrm, X86::VPMOVZXWDrm },
  { X86::PMOVZXWDrr, X86::VPMOVZXWDrr },
  { X86::PMOVZXWQrm, X86::VPMOVZXWQrm },
  { X86::PMOVZXWQrr, X86::VPMOVZXWQrr },
  { X86::PMULDQrm, X86::VPMULDQrm },
  { X86::PMULDQrr, X86::VPMULDQrr },
  { X86::PMULHRSWrm, X86::VPMULHRSWrm },
  { X86::PMULHRSWrr, X86::VPMULHRSWrr },
  { X86::PMULHUWrm, X86::VPMULHUWrm },
  { X86::PMULHUWrr, X86::VPMULHUWrr },
  { X86::PMULHWrm, X86::VPMULHWrm },
  { X86::PMULHWrr, X86::VPMULHWrr },
  { X86::PMULLDrm, X86::VPMULLDrm },
  { X86::PMULLDrr, X86::VPMULLDrr },
  { X86::PMULLWrm, X86::VPMULLWrm },
  { X86::PMULLWrr, X86::VPMULLWrr },
  { X86::PMULUDQrm, X86::VPMULUDQrm },
  { X86::PMULUDQrr, X86::VPMULUDQrr },
  { X86::PORrm, X86::VPORrm },
  { X86::PORrr, X86::VPORrr },
  { X86::PSADBWrm, X86::VPSADBWrm },
  { X86::PSADBWrr, X86::VPSADBWrr },
  { X86::PSHUFBrm, X86::VPSHUFBrm },
  { X86::PSHUFBrr, X86::VPSHUFBrr },
  { X86::PSHUFDmi, X86::VPSHUFDmi },
  { X86::PSHUFDri, X86::VPSHUFDri },
  { X86::PSHUFHWmi, X86::VPSHUFHWmi },
  { X86::PSHUFHWri, X86::VPSHUFHWri },
  { X86::PSHUFLWmi, X86::VPSHUFLWmi },
  { X86::PSHUFLWri, X86::VPSHUFLWri },
  { X86::PSIGNBrm, X86::VPSIGNBrm },
  { X86::PSIGNBrr, X86::VPSIGNBrr },
  { X86::PSIGNDrm, X86::VPSIGNDrm },
  { X86::PSIGNDrr, X86::VPSIGNDrr },
  { X86::PSIGNWrm, X86::VPSIGNWrm },
  { X86::PSIGNWrr, X86::VPSIGNWrr },
  { X86::PSLLDQri, X86::VPSLLDQri },
  { X86::PSLLDri, X86::VPSLLDri },
  { X86::PSLLDrm, X86::VPSLLDrm },
  { X86::PSLLDrr, X86::VPSLLDrr },
  { X86::PSLLQri, X86::VPSLLQri },
  { X86::PSLLQrm, X86::VPSLLQrm },
  { X86::PSLLQrr, X86::VPSLLQrr },
  { X86::PSLLWri, X86::VPSLLWri },
  { X86::PSLLWrm, X86::VPSLLWrm },
  { X86::PSLLWrr, X86::VPSLLWrr },
  { X86::PSRADri, X86::VPSRADri },
  { X86::PSRADrm, X86::VPSRADrm },
  { X86::PSRADrr, X86::VPSRADrr },
  { X86::PSRAWri, X86::VPSRAWri },
  { X86::PSRAWrm, X86::VPSRAWrm },
  { X86::PSRAWrr, X86::VPSRAWrr },
  { X86::PSRLDQri, X86::VPSRLDQri },
  { X86::PSRLDri, X86::VPSRLDri },
  { X86::PSRLDrm, X86::VPSRLDrm },
  { X86::PSRLDrr, X86::VPSRLDrr },
  { X86::PSRLQri, X86::VPSRLQri },
  { X86::PSRLQrm, X86::VPSRLQrm },
  { X86::PSRLQrr, X86::VPSRLQrr },
  { X86::PSRLWri, X86::VPSRLWri },
  { X86::PSRLWrm, X86::VPSRLWrm },
  { X86::PSRLWrr, X86::VPSRLWrr },
  { X86::PSUBBrm, X86::VPSUBBrm },
  { X86::PSUBBrr, X86::VPSUBBrr },
  { X86::PSUBDrm, X86::VPSUBDrm },
  { X86::PSUBDrr, X86::VPSUBDrr },
  { X86::PSUBQrm, X86::VPSUBQrm },
  { X86::PSUBQrr, X86::VPSUBQrr },
  { X86::PSUBSBrm, X86::VPSUBSBrm },
  { X86::PSUBSBrr, X86::VPSUBSBrr },
  { X86::PSUBSWrm, X86::VPSUBSWrm },
  { X86::PSUBSWrr, X86::VPSUBSWrr },
  { X86::PSUBUSBrm, X86::VPSUBUSBrm },
  { X86::PSUBUSBrr, X86::VPSUBUSBrr },
  { X86::PSUBUSWrm, X86::VPSUBUSWrm },
  { X86::PSUBUSWrr, X86::VPSUBUSWrr },
  { X86::PSUBWrm, X86::VPSUBWrm },
  { X86::PSUBWrr, X86::VPSUBWrr },
  { X86::PTESTrm, X86::VPTESTrm },
  { X86::PTESTrr, X86::VPTESTrr },
  { X86::PUNPCKHBWrm, X86::VPUNPCKHBWrm },
  { X86::PUNPCKHBWrr, X86::VPUNPCKHBWrr },
  { X86::PUNPCKHDQrm, X86::VPUNPCKHDQrm },
  { X86::PUNPCKHDQrr, X86::VPUNPCKHDQrr },
  { X86::PUNPCKHQDQrm, X86::VPUNPCKHQDQrm },
  { X86::PUNPCKHQDQrr, X86::VPUNPCKHQDQrr },
  { X86::PUNPCKHWDrm, X86::VPUNPCKHWDrm },
  { X86::PUNPCKHWDrr, X86::VPUNPCKHWDrr },
  { X86::PUNPCKLBWrm, X86::VPUNPCKLBWrm },
  { X86::PUNPCKLBWrr, X86::VPUNPCKLBWrr },
  { X86::PUNPCKLDQrm, X86::VPUNPCKLDQrm },
  { X86::PUNPCKLDQrr, X86::VPUNPCKLDQrr },
  { X86::PUNPCKLQDQrm, X86::VPUNPCKLQDQrm },
  { X86::PUNPCKLQDQrr, X86::VPUNPCKLQDQrr },
  { X86::PUNPCKLWDrm, X86::VPUNPCKLWDrm },
  { X86::PUNPCKLWDrr, X86::VPUNPCKLWDrr },
  { X86::PXORrm, X86::VPXORrm },
  { X86::PXORrr, X86::VPXORrr },
  { X86::RCPPSm, X86::VRCPPSm },
  { X86::RCPPSr, X86::VRCPPSr },
  { X86::RCPSSm, X86::VRCPSSm },
  { X86::RCPSSm_Int, X86::VRCPSSm_Int },
  { X86::RCPSSr, X86::VRCPSSr },
  { X86::RCPSSr_Int, X86::VRCPSSr_Int },
  { X86::ROUNDPDmi, X86::VROUNDPDmi },
  { X86::ROUNDPDri, X86::VROUNDPDri },
  { X86::ROUNDPSmi, X86::VROUNDPSmi },
  { X86::ROUNDPSri, X86::VROUNDPSri },
  { X86::ROUNDSDmi, X86::VROUNDSDmi },
  { X86::ROUNDSDmi_Int, X86::VROUNDSDmi_Int },
  { X86::ROUNDSDri, X86::VROUNDSDri },
  { X86::ROUNDSDri_Int, X86::VROUNDSDri_Int },
  { X86::ROUNDSSmi, X86::VROUNDSSmi },
  { X86::ROUNDSSmi_Int, X86::VROUNDSSmi_Int },
  { X86::ROUNDSSri, X86::VROUNDSSri },
  { X86::ROUNDSSri_Int, X86::VROUNDSSri_Int },
  { X86::RSQRTPSm, X86::VRSQRTPSm },
  { X86::RSQRTPSr, X86::VRSQRTPSr },
  { X86::RSQRTSSm, X86::VRSQRTSSm },
  { X86::RSQRTSSm_Int, X86::VRSQRTSSm_Int },
  { X86::RSQRTSSr, X86::VRSQRTSSr },
  { X86::RSQRTSSr_Int, X86::VRSQRTSSr_Int },
  { X86::SHUFPDrmi, X86::VSHUFPDrmi },
  { X86::SHUFPDrri, X86::VSHUFPDrri },
  { X86::SHUFPSrmi, X86::VSHUFPSrmi },
  { X86::SHUFPSrri, X86::VSHUFPSrri },
  { X86::SQRTPDm, X86::VSQRTPDm },
  { X86::SQRTPDr, X86::VSQRTPDr },
  { X86::SQRTPSm, X86::VSQRTPSm },
  { X86::SQRTPSr, X86::VSQRTPSr },
  { X86::SQRTSDm, X86::VSQRTSDm },
  { X86::SQRTSDm_Int, X86::VSQRTSDm_Int },
  { X86::SQRTSDr, X86::VSQRTSDr },
  { X86::SQRTSDr_Int, X86::VSQRTSDr_Int },
  { X86::SQRTSSm, X86::VSQRTSSm },
  { X86::SQRTSSm_Int, X86::VSQRTSSm_Int },
  { X86::SQRTSSr, X86::VSQRTSSr },
  { X86::SQRTSSr_Int, X86::VSQRTSSr_Int },
  { X86::STMXCSR, X86::VSTMXCSR },
  { X86::SUBPDrm, X86::VSUBPDrm },
  { X86::SUBPDrr, X86::VSUBPDrr },
  { X86::SUBPSrm, X86::VSUBPSrm },
  { X86::SUBPSrr, X86::VSUBPSrr },
  { X86::SUBSDrm, X86::VSUBSDrm },
  { X86::SUBSDrm_Int, X86::VSUBSDrm_Int },
  { X86::SUBSDrr, X86::VSUBSDrr },
  { X86::SUBSDrr_Int, X86::VSUBSDrr_Int },
  { X86::SUBSSrm, X86::VSUBSSrm },
  { X86::SUBSSrm_Int, X86::VSUBSSrm_Int },
  { X86::SUBSSrr, X86::VSUBSSrr },
  { X86::SUBSSrr_Int, X86::VSUBSSrr_Int },
  { X86::UCOMISDrm, X86::VUCOMISDrm },
  { X86::UCOMISDrm_Int, X86::VUCOMISDrm_Int },
  { X86::UCOMISDrr, X86::VUCOMISDrr },
  { X86::UCOMISDrr_Int, X86::VUCOMISDrr_Int },
  { X86::UCOMISSrm, X86::VUCOMISSrm },
  { X86::UCOMISSrm_Int, X86::VUCOMISSrm_Int },
  { X86::UCOMISSrr, X86::VUCOMISSrr },
  { X86::UCOMISSrr_Int, X86::VUCOMISSrr_Int },
  { X86::UNPCKHPDrm, X86::VUNPCKHPDrm },
  { X86::UNPCKHPDrr, X86::VUNPCKHPDrr },
  { X86::UNPCKHPSrm, X86::VUNPCKHPSrm },
  { X86::UNPCKHPSrr, X86::VUNPCKHPSrr },
  { X86::UNPCKLPDrm, X86::VUNPCKLPDrm },
  { X86::UNPCKLPDrr, X86::VUNPCKLPDrr },
  { X86::UNPCKLPSrm, X86::VUNPCKLPSrm },
  { X86::UNPCKLPSrr, X86::VUNPCKLPSrr },
  { X86::XORPDrm, X86::VXORPDrm },
  { X86::XORPDrr, X86::VXORPDrr },
  { X86::XORPSrm, X86::VXORPSrm },
  { X86::XORPSrr, X86::VXORPSrr },
};

#endif // GET_X86_SSE2AVX_TABLE

