; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i64_stride5_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd 64(%rdi), %xmm0
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    movapd 16(%rdi), %xmm2
; SSE-NEXT:    movapd 32(%rdi), %xmm3
; SSE-NEXT:    movapd 48(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm3, %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm1[0],xmm5[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm4[0]
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm5, (%rsi)
; SSE-NEXT:    movapd %xmm1, (%rdx)
; SSE-NEXT:    movapd %xmm4, (%rcx)
; SSE-NEXT:    movapd %xmm2, (%r8)
; SSE-NEXT:    movapd %xmm0, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm1[0,1,2,3],xmm3[4,5,6,7]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm5[4,5,6,7]
; AVX-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX-NEXT:    vmovdqa %xmm3, (%rcx)
; AVX-NEXT:    vmovdqa %xmm1, (%r8)
; AVX-NEXT:    vmovdqa %xmm2, (%r9)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0,1],xmm2[2,3]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3]
; AVX2-NEXT:    vmovdqa %xmm5, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-NEXT:    vextractf128 $1, %ymm0, (%rcx)
; AVX2-NEXT:    vmovdqa %xmm3, (%r8)
; AVX2-NEXT:    vmovdqa %xmm2, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0,1],xmm2[2,3]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3]
; AVX2-FP-NEXT:    vmovdqa %xmm5, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-FP-NEXT:    vextractf128 $1, %ymm0, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %xmm3, (%r8)
; AVX2-FP-NEXT:    vmovdqa %xmm2, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0,1],xmm2[2,3]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3]
; AVX2-FCP-NEXT:    vmovdqa %xmm5, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-FCP-NEXT:    vextractf128 $1, %ymm0, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %xmm3, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %xmm2, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vmovaps (%rdi), %ymm2
; AVX512-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512-FCP-NEXT:    vmovaps (%rdi), %ymm2
; AVX512-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512-FCP-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-FCP-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512-FCP-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512DQ-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512DQ-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm2
; AVX512DQ-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512DQ-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512DQ-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512DQ-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512DQ-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512DQ-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512BW-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512BW-NEXT:    vmovaps (%rdi), %ymm2
; AVX512BW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512BW-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512BW-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512BW-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512BW-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512BW-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512BW-FCP-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512DQ-BW-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm1[2,3]
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],mem[2,3],ymm2[4,5],mem[6,7]
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vextractf128 $1, %ymm2, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm5, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm1, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <10 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <10 x i64> %wide.vec, <10 x i64> poison, <2 x i32> <i32 0, i32 5>
  %strided.vec1 = shufflevector <10 x i64> %wide.vec, <10 x i64> poison, <2 x i32> <i32 1, i32 6>
  %strided.vec2 = shufflevector <10 x i64> %wide.vec, <10 x i64> poison, <2 x i32> <i32 2, i32 7>
  %strided.vec3 = shufflevector <10 x i64> %wide.vec, <10 x i64> poison, <2 x i32> <i32 3, i32 8>
  %strided.vec4 = shufflevector <10 x i64> %wide.vec, <10 x i64> poison, <2 x i32> <i32 4, i32 9>
  store <2 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <2 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <2 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <2 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i64_stride5_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd 144(%rdi), %xmm1
; SSE-NEXT:    movapd 64(%rdi), %xmm0
; SSE-NEXT:    movapd 96(%rdi), %xmm2
; SSE-NEXT:    movapd 128(%rdi), %xmm3
; SSE-NEXT:    movapd (%rdi), %xmm4
; SSE-NEXT:    movapd 16(%rdi), %xmm5
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rdi), %xmm7
; SSE-NEXT:    movapd 80(%rdi), %xmm8
; SSE-NEXT:    movapd 112(%rdi), %xmm9
; SSE-NEXT:    movapd %xmm9, %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm8[0],xmm10[1]
; SSE-NEXT:    movapd %xmm6, %xmm11
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm4[0],xmm11[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm3[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm7[0]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm5[0],xmm7[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm0[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm6[0],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm9[0],xmm1[1]
; SSE-NEXT:    movapd %xmm10, 16(%rsi)
; SSE-NEXT:    movapd %xmm11, (%rsi)
; SSE-NEXT:    movapd %xmm8, 16(%rdx)
; SSE-NEXT:    movapd %xmm4, (%rdx)
; SSE-NEXT:    movapd %xmm3, 16(%rcx)
; SSE-NEXT:    movapd %xmm7, (%rcx)
; SSE-NEXT:    movapd %xmm2, 16(%r8)
; SSE-NEXT:    movapd %xmm5, (%r8)
; SSE-NEXT:    movapd %xmm1, 16(%r9)
; SSE-NEXT:    movapd %xmm0, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd 128(%rdi), %ymm0
; AVX-NEXT:    vmovapd 96(%rdi), %ymm1
; AVX-NEXT:    vmovapd 64(%rdi), %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm2[0,1,2],ymm1[3]
; AVX-NEXT:    vmovapd (%rdi), %xmm4
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm5
; AVX-NEXT:    vmovapd 32(%rdi), %xmm6
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX-NEXT:    vblendpd {{.*#+}} xmm8 = xmm4[0],xmm6[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm8[0,1],ymm3[2,3]
; AVX-NEXT:    vmovaps 128(%rdi), %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm9
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm9[0],ymm2[3],ymm9[2]
; AVX-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX-NEXT:    vblendps {{.*#+}} xmm8 = xmm4[0,1],xmm8[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX-NEXT:    vpblendw {{.*#+}} xmm7 = xmm5[0,1,2,3],xmm7[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm0[0],ymm4[3],ymm0[2]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm6[0],xmm8[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovapd %ymm3, (%rsi)
; AVX-NEXT:    vmovapd %ymm2, (%rdx)
; AVX-NEXT:    vmovaps %ymm7, (%rcx)
; AVX-NEXT:    vmovapd %ymm4, (%r8)
; AVX-NEXT:    vmovapd %ymm0, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX2-NEXT:    vpblendd {{.*#+}} xmm9 = xmm5[0,1],xmm6[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm9[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm5
; AVX2-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm5[2,3]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm7 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm6[0,1],xmm8[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm5[0,1],xmm6[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm9[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm5[2,3]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm6[0,1],xmm8[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm5
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm5[0,1],xmm6[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm9[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm5[2,3]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm6[0,1],xmm8[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX512-NEXT:    vpbroadcastq %xmm4, %ymm5
; AVX512-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX512-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [2,7,12,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [11,0,5,0]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512-NEXT:    vpbroadcastq 144(%rdi), %ymm6
; AVX512-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [12,1,6,0]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX512-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm5, (%r8)
; AVX512-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,1,2,4]
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX512-FCP-NEXT:    vpermi2q %ymm5, %ymm3, %ymm4
; AVX512-FCP-NEXT:    vinserti128 $1, 128(%rdi), %ymm0, %ymm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vpbroadcastq 144(%rdi), %ymm7
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [12,1,6,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX512-FCP-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX512DQ-NEXT:    vpbroadcastq %xmm4, %ymm5
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [2,7,12,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [11,0,5,0]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-NEXT:    vpbroadcastq 144(%rdi), %ymm6
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [12,1,6,0]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512DQ-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX512DQ-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512DQ-NEXT:    vmovdqa %ymm5, (%r8)
; AVX512DQ-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,1,2,4]
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX512DQ-FCP-NEXT:    vpermi2q %ymm5, %ymm3, %ymm4
; AVX512DQ-FCP-NEXT:    vinserti128 $1, 128(%rdi), %ymm0, %ymm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vpbroadcastq 144(%rdi), %ymm7
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [12,1,6,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX512BW-NEXT:    vpbroadcastq %xmm4, %ymm5
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX512BW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [2,7,12,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [11,0,5,0]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512BW-NEXT:    vpbroadcastq 144(%rdi), %ymm6
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [12,1,6,0]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX512BW-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512BW-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX512BW-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512BW-NEXT:    vmovdqa %ymm5, (%r8)
; AVX512BW-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,1,2,4]
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX512BW-FCP-NEXT:    vpermi2q %ymm5, %ymm3, %ymm4
; AVX512BW-FCP-NEXT:    vinserti128 $1, 128(%rdi), %ymm0, %ymm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vpbroadcastq 144(%rdi), %ymm7
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [12,1,6,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX512BW-FCP-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX512DQ-BW-NEXT:    vpbroadcastq %xmm4, %ymm5
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [2,7,12,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm5 = [11,0,5,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm5
; AVX512DQ-BW-NEXT:    vpbroadcastq 144(%rdi), %ymm6
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [12,1,6,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-BW-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm4, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm5, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,6,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,1,2,4]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %ymm5, %ymm3, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, 128(%rdi), %ymm0, %ymm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpbroadcastq 144(%rdi), %ymm7
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [12,1,6,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm2, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <20 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <20 x i64> %wide.vec, <20 x i64> poison, <4 x i32> <i32 0, i32 5, i32 10, i32 15>
  %strided.vec1 = shufflevector <20 x i64> %wide.vec, <20 x i64> poison, <4 x i32> <i32 1, i32 6, i32 11, i32 16>
  %strided.vec2 = shufflevector <20 x i64> %wide.vec, <20 x i64> poison, <4 x i32> <i32 2, i32 7, i32 12, i32 17>
  %strided.vec3 = shufflevector <20 x i64> %wide.vec, <20 x i64> poison, <4 x i32> <i32 3, i32 8, i32 13, i32 18>
  %strided.vec4 = shufflevector <20 x i64> %wide.vec, <20 x i64> poison, <4 x i32> <i32 4, i32 9, i32 14, i32 19>
  store <4 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <4 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <4 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <4 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i64_stride5_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movapd 304(%rdi), %xmm2
; SSE-NEXT:    movapd 64(%rdi), %xmm1
; SSE-NEXT:    movapd 224(%rdi), %xmm0
; SSE-NEXT:    movapd 256(%rdi), %xmm4
; SSE-NEXT:    movapd 176(%rdi), %xmm3
; SSE-NEXT:    movapd 288(%rdi), %xmm7
; SSE-NEXT:    movapd 208(%rdi), %xmm6
; SSE-NEXT:    movapd (%rdi), %xmm9
; SSE-NEXT:    movapd 16(%rdi), %xmm5
; SSE-NEXT:    movapd 32(%rdi), %xmm14
; SSE-NEXT:    movapd 48(%rdi), %xmm8
; SSE-NEXT:    movapd 240(%rdi), %xmm11
; SSE-NEXT:    movapd 272(%rdi), %xmm13
; SSE-NEXT:    movapd 160(%rdi), %xmm10
; SSE-NEXT:    movapd 192(%rdi), %xmm15
; SSE-NEXT:    movapd %xmm15, %xmm12
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm10[0],xmm12[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm6[0]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm3[0],xmm6[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm0[0]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm15[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm14, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm9[0],xmm15[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm8[0]
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm5[0],xmm8[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm13, %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm11[0],xmm14[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm7[0]
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm4[0],xmm7[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm2[0]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm13[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm13
; SSE-NEXT:    movapd 112(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm4, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm13[0],xmm2[1]
; SSE-NEXT:    movapd 128(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm0[0]
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd 144(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm3[0]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm4[0],xmm3[1]
; SSE-NEXT:    movapd %xmm2, 16(%rsi)
; SSE-NEXT:    movapd %xmm14, 48(%rsi)
; SSE-NEXT:    movapd %xmm15, (%rsi)
; SSE-NEXT:    movapd %xmm12, 32(%rsi)
; SSE-NEXT:    movapd %xmm13, 16(%rdx)
; SSE-NEXT:    movapd %xmm11, 48(%rdx)
; SSE-NEXT:    movapd %xmm9, (%rdx)
; SSE-NEXT:    movapd %xmm10, 32(%rdx)
; SSE-NEXT:    movapd %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm7, 48(%rcx)
; SSE-NEXT:    movapd %xmm8, (%rcx)
; SSE-NEXT:    movapd %xmm6, 32(%rcx)
; SSE-NEXT:    movapd %xmm1, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movapd %xmm5, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movapd %xmm3, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd 128(%rdi), %ymm1
; AVX-NEXT:    vmovapd 256(%rdi), %ymm0
; AVX-NEXT:    vmovapd 224(%rdi), %ymm9
; AVX-NEXT:    vmovapd 96(%rdi), %ymm2
; AVX-NEXT:    vmovapd 64(%rdi), %ymm7
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm7[0,1,2],ymm2[3]
; AVX-NEXT:    vmovapd (%rdi), %xmm10
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX-NEXT:    vmovapd 32(%rdi), %xmm4
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX-NEXT:    vblendpd {{.*#+}} xmm5 = xmm10[0],xmm4[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm9[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd %ymm0, %ymm3
; AVX-NEXT:    vmovapd 192(%rdi), %xmm5
; AVX-NEXT:    vmovapd 160(%rdi), %xmm12
; AVX-NEXT:    vblendpd {{.*#+}} xmm13 = xmm12[0],xmm5[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm13[0,1],ymm6[2,3]
; AVX-NEXT:    vmovaps 128(%rdi), %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm14
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm14[0],ymm7[3],ymm14[2]
; AVX-NEXT:    vpalignr {{.*#+}} xmm10 = xmm10[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3]
; AVX-NEXT:    vmovaps 288(%rdi), %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm10
; AVX-NEXT:    vshufpd {{.*#+}} ymm9 = ymm9[0],ymm10[0],ymm9[3],ymm10[2]
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm15
; AVX-NEXT:    vpalignr {{.*#+}} xmm10 = xmm12[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,3]
; AVX-NEXT:    vmovaps 96(%rdi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} xmm10 = xmm12[0,1],xmm13[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX-NEXT:    vpblendw {{.*#+}} xmm11 = xmm8[0,1,2,3],xmm11[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX-NEXT:    vmovaps 256(%rdi), %xmm11
; AVX-NEXT:    vblendps {{.*#+}} xmm13 = xmm11[0,1],xmm14[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX-NEXT:    vmovdqa 176(%rdi), %xmm14
; AVX-NEXT:    vpblendw {{.*#+}} xmm15 = xmm14[0,1,2,3],xmm15[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX-NEXT:    vshufpd {{.*#+}} ymm12 = ymm12[0],ymm1[0],ymm12[3],ymm1[2]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm15
; AVX-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1],ymm12[2,3]
; AVX-NEXT:    vmovapd 288(%rdi), %ymm12
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX-NEXT:    vshufpd {{.*#+}} ymm11 = ymm11[0],ymm12[0],ymm11[3],ymm12[2]
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX-NEXT:    vpalignr {{.*#+}} xmm14 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm11 = ymm14[0,1],ymm11[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3]
; AVX-NEXT:    vblendpd {{.*#+}} xmm2 = xmm4[0],xmm15[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1,2],ymm12[3]
; AVX-NEXT:    vblendpd {{.*#+}} xmm0 = xmm5[0],xmm0[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3]
; AVX-NEXT:    vmovapd %ymm6, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm2, (%rsi)
; AVX-NEXT:    vmovapd %ymm9, 32(%rdx)
; AVX-NEXT:    vmovapd %ymm7, (%rdx)
; AVX-NEXT:    vmovaps %ymm13, 32(%rcx)
; AVX-NEXT:    vmovaps %ymm10, (%rcx)
; AVX-NEXT:    vmovapd %ymm11, 32(%r8)
; AVX-NEXT:    vmovapd %ymm8, (%r8)
; AVX-NEXT:    vmovapd %ymm0, 32(%r9)
; AVX-NEXT:    vmovapd %ymm1, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa 160(%rdi), %ymm9
; AVX2-NEXT:    vmovdqa (%rdi), %ymm11
; AVX2-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 256(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 224(%rdi), %ymm12
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm5
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm5[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm12[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovdqa 192(%rdi), %xmm6
; AVX2-NEXT:    vmovdqa 160(%rdi), %xmm15
; AVX2-NEXT:    vpblendd {{.*#+}} xmm10 = xmm15[0,1],xmm6[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm10[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm10
; AVX2-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-NEXT:    vpalignr {{.*#+}} xmm13 = xmm15[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm12 = ymm12[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3],ymm12[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],mem[2,3],ymm11[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX2-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm11 = ymm11[2,3],ymm13[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],mem[2,3],ymm9[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 256(%rdi), %xmm13
; AVX2-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm9[2,3],ymm13[2,3]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm14 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vmovdqa 224(%rdi), %xmm14
; AVX2-NEXT:    vpalignr {{.*#+}} ymm15 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,3]
; AVX2-NEXT:    vpalignr {{.*#+}} xmm4 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm3 = xmm5[0,1],xmm10[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm6[0,1],xmm14[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqa %ymm7, 32(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm12, 32(%rdx)
; AVX2-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm9, 32(%rcx)
; AVX2-NEXT:    vmovdqa %ymm11, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm4, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm13, (%r8)
; AVX2-NEXT:    vmovdqa %ymm0, 32(%r9)
; AVX2-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %ymm9
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm11
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %ymm12
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm5
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm5[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm12[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovdqa 192(%rdi), %xmm6
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %xmm15
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm10 = xmm15[0,1],xmm6[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm10[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm10
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm13 = xmm15[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm12 = ymm12[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],mem[2,3],ymm11[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm11 = ymm11[2,3],ymm13[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],mem[2,3],ymm9[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %xmm13
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm9[2,3],ymm13[2,3]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm14 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %xmm14
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm15 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,3]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm4 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm3 = xmm5[0,1],xmm10[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm6[0,1],xmm14[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa %ymm7, 32(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm12, 32(%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 32(%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm11, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm13, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, 32(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %ymm9
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %ymm12
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm5
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm14
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm5[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm12[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovdqa 192(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %xmm15
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm10 = xmm15[0,1],xmm6[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm10[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm10
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm13 = xmm15[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm12 = ymm12[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm12[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1],mem[2,3],ymm11[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm11 = ymm11[2,3],ymm13[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1],mem[2,3],ymm9[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm9[2,3],ymm13[2,3]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm14 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm14[0,1,0,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %xmm14
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm15 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,0,3]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm3 = xmm5[0,1],xmm10[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm6[0,1],xmm14[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa %ymm7, 32(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, 32(%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 32(%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm13, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 32(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512-NEXT:    movb $7, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512-NEXT:    movb $56, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512-FCP-NEXT:    movb $7, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512-FCP-NEXT:    movb $56, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512DQ-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512DQ-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-NEXT:    movb $7, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-NEXT:    movb $56, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512DQ-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512DQ-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    movb $7, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    movb $56, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512BW-NEXT:    movb $7, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512BW-NEXT:    movb $56, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512BW-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    movb $7, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    movb $56, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    movb $7, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    movb $56, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm4, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm4 = zmm4[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [1,6,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    movb $7, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    movb $56, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [11,0,5,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <40 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <40 x i64> %wide.vec, <40 x i64> poison, <8 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35>
  %strided.vec1 = shufflevector <40 x i64> %wide.vec, <40 x i64> poison, <8 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36>
  %strided.vec2 = shufflevector <40 x i64> %wide.vec, <40 x i64> poison, <8 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37>
  %strided.vec3 = shufflevector <40 x i64> %wide.vec, <40 x i64> poison, <8 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38>
  %strided.vec4 = shufflevector <40 x i64> %wide.vec, <40 x i64> poison, <8 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39>
  store <8 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <8 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <8 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <8 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i64_stride5_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $280, %rsp # imm = 0x118
; SSE-NEXT:    movapd 224(%rdi), %xmm3
; SSE-NEXT:    movapd 144(%rdi), %xmm2
; SSE-NEXT:    movapd 64(%rdi), %xmm1
; SSE-NEXT:    movapd 176(%rdi), %xmm4
; SSE-NEXT:    movapd 96(%rdi), %xmm5
; SSE-NEXT:    movapd 208(%rdi), %xmm7
; SSE-NEXT:    movapd 128(%rdi), %xmm8
; SSE-NEXT:    movapd (%rdi), %xmm10
; SSE-NEXT:    movapd 16(%rdi), %xmm6
; SSE-NEXT:    movapd 32(%rdi), %xmm14
; SSE-NEXT:    movapd 48(%rdi), %xmm9
; SSE-NEXT:    movapd 160(%rdi), %xmm11
; SSE-NEXT:    movapd 192(%rdi), %xmm13
; SSE-NEXT:    movapd 80(%rdi), %xmm12
; SSE-NEXT:    movapd 112(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm14, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm10[0],xmm15[1]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm9[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm6[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm1[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm12[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm8[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm5[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm2[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm13, %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm11[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm7[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm4[0],xmm7[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm3[0]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm13[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm15
; SSE-NEXT:    movapd 352(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm15[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm15 = xmm15[1],xmm1[0]
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm11
; SSE-NEXT:    movapd 432(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm11[0],xmm13[1]
; SSE-NEXT:    movapd 448(%rdi), %xmm12
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm12[0]
; SSE-NEXT:    movapd 416(%rdi), %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm14[0],xmm12[1]
; SSE-NEXT:    movapd 464(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm14 = xmm14[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm4
; SSE-NEXT:    movapd 512(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm4[0],xmm6[1]
; SSE-NEXT:    movapd 528(%rdi), %xmm7
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm7[0]
; SSE-NEXT:    movapd 496(%rdi), %xmm9
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm9[0],xmm7[1]
; SSE-NEXT:    movapd 544(%rdi), %xmm10
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm10[0]
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm0[0],xmm10[1]
; SSE-NEXT:    movapd 560(%rdi), %xmm0
; SSE-NEXT:    movapd 592(%rdi), %xmm5
; SSE-NEXT:    movapd %xmm5, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE-NEXT:    movapd 608(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm1[0]
; SSE-NEXT:    movapd 576(%rdi), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; SSE-NEXT:    movapd 624(%rdi), %xmm8
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm8[0]
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm5[0],xmm8[1]
; SSE-NEXT:    movapd %xmm6, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 32(%rsi)
; SSE-NEXT:    movapd %xmm2, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movapd %xmm13, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movapd %xmm4, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movapd %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movapd %xmm15, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movapd %xmm11, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movapd %xmm7, 96(%rcx)
; SSE-NEXT:    movapd %xmm1, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movapd %xmm12, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm3, 112(%r8)
; SSE-NEXT:    movapd %xmm9, 96(%r8)
; SSE-NEXT:    movapd %xmm14, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm8, 112(%r9)
; SSE-NEXT:    movapd %xmm10, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    addq $280, %rsp # imm = 0x118
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $360, %rsp # imm = 0x168
; AVX-NEXT:    vmovapd 96(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 64(%rdi), %ymm5
; AVX-NEXT:    vmovapd 576(%rdi), %ymm7
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 544(%rdi), %ymm1
; AVX-NEXT:    vmovapd 256(%rdi), %ymm2
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 224(%rdi), %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1,2],ymm2[3]
; AVX-NEXT:    vmovapd 192(%rdi), %xmm6
; AVX-NEXT:    vmovapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 160(%rdi), %xmm4
; AVX-NEXT:    vblendpd {{.*#+}} xmm6 = xmm4[0],xmm6[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm1[0,1,2],ymm7[3]
; AVX-NEXT:    vmovapd 512(%rdi), %xmm6
; AVX-NEXT:    vmovapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 480(%rdi), %xmm11
; AVX-NEXT:    vblendpd {{.*#+}} xmm8 = xmm11[0],xmm6[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm8[0,1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm9 = ymm5[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd (%rdi), %xmm2
; AVX-NEXT:    vmovapd 32(%rdi), %xmm0
; AVX-NEXT:    vmovapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} xmm10 = xmm2[0],xmm0[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm10[0,1],ymm9[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 416(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 384(%rdi), %ymm14
; AVX-NEXT:    vblendpd {{.*#+}} ymm15 = ymm14[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 352(%rdi), %xmm6
; AVX-NEXT:    vmovapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 320(%rdi), %xmm0
; AVX-NEXT:    vblendpd {{.*#+}} xmm13 = xmm0[0],xmm6[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm13[0,1],ymm15[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rdi), %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm15
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm15[0],ymm3[3],ymm15[2]
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm15
; AVX-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 608(%rdi), %xmm3
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm4
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[3],ymm4[2]
; AVX-NEXT:    vmovdqa 528(%rdi), %xmm4
; AVX-NEXT:    vpalignr {{.*#+}} xmm11 = xmm11[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm11[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm6
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm11
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm11[0],ymm5[3],ymm11[2]
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm11
; AVX-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1],ymm5[2,3]
; AVX-NEXT:    vmovupd %ymm1, (%rsp) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rdi), %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm5
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm14[0],ymm5[0],ymm14[3],ymm5[2]
; AVX-NEXT:    vmovdqa 368(%rdi), %xmm14
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm13 = xmm0[0,1],xmm13[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX-NEXT:    vmovdqa 176(%rdi), %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm15 = xmm9[0,1,2,3],xmm15[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 576(%rdi), %xmm5
; AVX-NEXT:    vblendps {{.*#+}} xmm3 = xmm5[0,1],xmm3[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vmovdqa 496(%rdi), %xmm7
; AVX-NEXT:    vpblendw {{.*#+}} xmm4 = xmm7[0,1,2,3],xmm4[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovaps 96(%rdi), %xmm4
; AVX-NEXT:    vblendps {{.*#+}} xmm3 = xmm4[0,1],xmm6[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm10
; AVX-NEXT:    vpblendw {{.*#+}} xmm11 = xmm10[0,1,2,3],xmm11[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm11[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovaps 416(%rdi), %xmm6
; AVX-NEXT:    vblendps {{.*#+}} xmm2 = xmm6[0,1],xmm2[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vmovdqa 336(%rdi), %xmm8
; AVX-NEXT:    vpblendw {{.*#+}} xmm14 = xmm8[0,1,2,3],xmm14[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm14[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 288(%rdi), %ymm14
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm14[0],ymm0[3],ymm14[2]
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm3
; AVX-NEXT:    vpalignr {{.*#+}} xmm9 = xmm9[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm12 = ymm9[0,1],ymm0[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 608(%rdi), %ymm5
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm5[0],ymm0[3],ymm5[2]
; AVX-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm9 = ymm7[0,1],ymm0[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 128(%rdi), %ymm4
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[3],ymm4[2]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX-NEXT:    vpalignr {{.*#+}} xmm10 = xmm10[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm10[0,1],ymm0[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX-NEXT:    vmovapd 448(%rdi), %ymm10
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm10[0],ymm6[3],ymm10[2]
; AVX-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm8[0,1],ymm6[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm8 # 32-byte Folded Reload
; AVX-NEXT:    # ymm8 = mem[0,1,2],ymm14[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = mem[0,1,2,3],xmm3[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm8[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX-NEXT:    # ymm5 = mem[0,1,2],ymm5[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = mem[0,1,2,3],xmm2[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm5[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = mem[0,1,2],ymm4[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2,3],xmm1[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm4[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm4 # 32-byte Folded Reload
; AVX-NEXT:    # ymm4 = mem[0,1,2],ymm10[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[0,1,2,3],xmm0[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm4[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, (%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX-NEXT:    vmovups (%rsp), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, (%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rdx)
; AVX-NEXT:    vmovaps %ymm11, 64(%rcx)
; AVX-NEXT:    vmovaps %ymm13, (%rcx)
; AVX-NEXT:    vmovaps %ymm15, 96(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX-NEXT:    vmovapd %ymm6, 64(%r8)
; AVX-NEXT:    vmovapd %ymm7, (%r8)
; AVX-NEXT:    vmovapd %ymm9, 96(%r8)
; AVX-NEXT:    vmovapd %ymm12, 32(%r8)
; AVX-NEXT:    vmovapd %ymm0, 64(%r9)
; AVX-NEXT:    vmovapd %ymm1, (%r9)
; AVX-NEXT:    vmovapd %ymm2, 96(%r9)
; AVX-NEXT:    vmovapd %ymm3, 32(%r9)
; AVX-NEXT:    addq $360, %rsp # imm = 0x168
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm14
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa 576(%rdi), %ymm12
; AVX2-NEXT:    vmovdqa 544(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 256(%rdi), %ymm11
; AVX2-NEXT:    vmovdqa 224(%rdi), %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm2[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 160(%rdi), %xmm5
; AVX2-NEXT:    vpblendd {{.*#+}} xmm8 = xmm5[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-NEXT:    vmovdqa 512(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 480(%rdi), %xmm8
; AVX2-NEXT:    vpblendd {{.*#+}} xmm9 = xmm8[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm14[6,7]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} xmm9 = xmm10[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 416(%rdi), %ymm9
; AVX2-NEXT:    vmovdqa 384(%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm13 = ymm3[0,1,2,3,4,5],ymm9[6,7]
; AVX2-NEXT:    vmovdqa 352(%rdi), %xmm6
; AVX2-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX2-NEXT:    vpblendd {{.*#+}} xmm15 = xmm0[0,1],xmm6[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 288(%rdi), %ymm15
; AVX2-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 528(%rdi), %xmm2
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = xmm8[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 608(%rdi), %ymm8
; AVX2-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = xmm10[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-NEXT:    vpalignr {{.*#+}} ymm4 = ymm4[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm4[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 368(%rdi), %xmm4
; AVX2-NEXT:    vpalignr {{.*#+}} xmm4 = xmm0[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 448(%rdi), %ymm6
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 256(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 480(%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 576(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 320(%rdi), %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-NEXT:    vmovdqa 416(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm12[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm14[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm13[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm13 = ymm9[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,3]
; AVX2-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm10 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm15[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm11[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5],ymm8[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm14[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 64(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, (%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 96(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 32(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 64(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, (%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 32(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 64(%rcx)
; AVX2-NEXT:    vmovups (%rsp), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, (%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm6, 32(%rcx)
; AVX2-NEXT:    vmovdqa %ymm10, 64(%r8)
; AVX2-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-NEXT:    vmovdqa %ymm5, 96(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm3, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-NEXT:    vmovdqa %ymm2, 96(%r9)
; AVX2-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm14
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovdqa 576(%rdi), %ymm12
; AVX2-FP-NEXT:    vmovdqa 544(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %ymm11
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %ymm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm2[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %xmm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm8 = xmm5[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FP-NEXT:    vmovdqa 512(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 480(%rdi), %xmm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm8[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm10[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 416(%rdi), %ymm9
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm3[0,1,2,3,4,5],ymm9[6,7]
; AVX2-FP-NEXT:    vmovdqa 352(%rdi), %xmm6
; AVX2-FP-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm15 = xmm0[0,1],xmm6[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %ymm15
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 528(%rdi), %xmm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm8[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 608(%rdi), %ymm8
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm10[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm4 = ymm4[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm4[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 368(%rdi), %xmm4
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm0[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 448(%rdi), %ymm6
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 480(%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 576(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 320(%rdi), %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovdqa 416(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm12[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm14[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm13[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm13 = ymm9[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm10 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm15[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm14[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 64(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, (%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 32(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 64(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, (%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 32(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 64(%rcx)
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, (%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm6, 32(%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm10, 64(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 96(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm3, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm2, 96(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FP-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm14
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovdqa 576(%rdi), %ymm12
; AVX2-FCP-NEXT:    vmovdqa 544(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm2[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vmovdqa 192(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm8 = xmm5[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FCP-NEXT:    vmovdqa 512(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 480(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm8[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm10[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 416(%rdi), %ymm9
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm3[0,1,2,3,4,5],ymm9[6,7]
; AVX2-FCP-NEXT:    vmovdqa 352(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm15 = xmm0[0,1],xmm6[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 208(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %ymm15
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 528(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm8[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 608(%rdi), %ymm8
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm10[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm4 = ymm4[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm4[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 368(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm0[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 448(%rdi), %ymm6
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 480(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 576(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 320(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],mem[2,3],ymm3[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovdqa 416(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm3[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm12[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm14[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm13[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm13 = ymm9[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm10 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm15[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm14[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 64(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, (%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 96(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 32(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 64(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, (%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 32(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 64(%rcx)
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, (%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm6, 32(%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 64(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, 96(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm3, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 64(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, 96(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FCP-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512-NEXT:    movb $7, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512-NEXT:    movb $56, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512-FCP-NEXT:    movb $7, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512-FCP-NEXT:    movb $56, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512DQ-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512DQ-NEXT:    movb $7, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512DQ-NEXT:    movb $56, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512DQ-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512DQ-FCP-NEXT:    movb $7, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512DQ-FCP-NEXT:    movb $56, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512BW-NEXT:    movb $7, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512BW-NEXT:    movb $56, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512BW-FCP-NEXT:    movb $7, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512BW-FCP-NEXT:    movb $56, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512DQ-BW-NEXT:    movb $7, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512DQ-BW-NEXT:    movb $56, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm12 = [0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm13[0,1,2,3],zmm8[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm13 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm13, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm7, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm12[0,1,2,3],zmm14[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm15 = [1,6,11,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm15, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm13
; AVX512DQ-BW-FCP-NEXT:    movb $7, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm13 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm17 = [2,7,12,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm17, %zmm18
; AVX512DQ-BW-FCP-NEXT:    movb $56, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm18 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm3, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm19 = [11,0,5,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm19, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm20 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm16 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm16, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm5, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm0, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm7, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm9, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm9, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <80 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <80 x i64> %wide.vec, <80 x i64> poison, <16 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75>
  %strided.vec1 = shufflevector <80 x i64> %wide.vec, <80 x i64> poison, <16 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76>
  %strided.vec2 = shufflevector <80 x i64> %wide.vec, <80 x i64> poison, <16 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77>
  %strided.vec3 = shufflevector <80 x i64> %wide.vec, <80 x i64> poison, <16 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78>
  %strided.vec4 = shufflevector <80 x i64> %wide.vec, <80 x i64> poison, <16 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79>
  store <16 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <16 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <16 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <16 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i64_stride5_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $920, %rsp # imm = 0x398
; SSE-NEXT:    movapd 224(%rdi), %xmm5
; SSE-NEXT:    movapd 144(%rdi), %xmm4
; SSE-NEXT:    movapd 64(%rdi), %xmm3
; SSE-NEXT:    movapd 176(%rdi), %xmm7
; SSE-NEXT:    movapd 96(%rdi), %xmm6
; SSE-NEXT:    movapd 208(%rdi), %xmm9
; SSE-NEXT:    movapd 128(%rdi), %xmm10
; SSE-NEXT:    movapd (%rdi), %xmm12
; SSE-NEXT:    movapd 16(%rdi), %xmm8
; SSE-NEXT:    movapd 32(%rdi), %xmm1
; SSE-NEXT:    movapd 48(%rdi), %xmm11
; SSE-NEXT:    movapd 160(%rdi), %xmm13
; SSE-NEXT:    movapd 192(%rdi), %xmm0
; SSE-NEXT:    movapd 80(%rdi), %xmm14
; SSE-NEXT:    movapd 112(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm12[0],xmm15[1]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm11[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm8[0],xmm11[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm3[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm1[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm2, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm14 = xmm14[1],xmm10[0]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm6[0],xmm10[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm4[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm13[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm9[0]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm7[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm5[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm0[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm2
; SSE-NEXT:    movapd 352(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm2
; SSE-NEXT:    movapd 432(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm2
; SSE-NEXT:    movapd 512(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 496(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 560(%rdi), %xmm2
; SSE-NEXT:    movapd 592(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 608(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 576(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 624(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 640(%rdi), %xmm2
; SSE-NEXT:    movapd 672(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 688(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 656(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 704(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 720(%rdi), %xmm2
; SSE-NEXT:    movapd 752(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 768(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 736(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 784(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 800(%rdi), %xmm2
; SSE-NEXT:    movapd 832(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 848(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 816(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 864(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 880(%rdi), %xmm2
; SSE-NEXT:    movapd 912(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 928(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 896(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 944(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 960(%rdi), %xmm10
; SSE-NEXT:    movapd 992(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm10[0],xmm14[1]
; SSE-NEXT:    movapd 1008(%rdi), %xmm15
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm15[0]
; SSE-NEXT:    movapd 976(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm2[0],xmm15[1]
; SSE-NEXT:    movapd 1024(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1040(%rdi), %xmm8
; SSE-NEXT:    movapd 1072(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm9
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm8[0],xmm9[1]
; SSE-NEXT:    movapd 1088(%rdi), %xmm11
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm11[0]
; SSE-NEXT:    movapd 1056(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm2[0],xmm11[1]
; SSE-NEXT:    movapd 1104(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 1120(%rdi), %xmm5
; SSE-NEXT:    movapd 1152(%rdi), %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm5[0],xmm3[1]
; SSE-NEXT:    movapd 1168(%rdi), %xmm6
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm6[0]
; SSE-NEXT:    movapd 1136(%rdi), %xmm12
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm12[0],xmm6[1]
; SSE-NEXT:    movapd 1184(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1200(%rdi), %xmm0
; SSE-NEXT:    movapd 1232(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm2, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd 1248(%rdi), %xmm4
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm4[0]
; SSE-NEXT:    movapd 1216(%rdi), %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm7[0],xmm4[1]
; SSE-NEXT:    movapd 1264(%rdi), %xmm13
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm13[0]
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm2[0],xmm13[1]
; SSE-NEXT:    movapd %xmm3, 224(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 160(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rsi)
; SSE-NEXT:    movapd %xmm1, 240(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 176(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rsi)
; SSE-NEXT:    movapd %xmm14, 192(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 128(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movapd %xmm9, 208(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 144(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rsi)
; SSE-NEXT:    movapd %xmm5, 224(%rdx)
; SSE-NEXT:    movapd %xmm0, 240(%rdx)
; SSE-NEXT:    movapd %xmm10, 192(%rdx)
; SSE-NEXT:    movapd %xmm8, 208(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movapd %xmm4, 240(%rcx)
; SSE-NEXT:    movapd %xmm6, 224(%rcx)
; SSE-NEXT:    movapd %xmm11, 208(%rcx)
; SSE-NEXT:    movapd %xmm15, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movapd %xmm7, 240(%r8)
; SSE-NEXT:    movapd %xmm12, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm13, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    addq $920, %rsp # imm = 0x398
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $1368, %rsp # imm = 0x558
; AVX-NEXT:    vmovapd 896(%rdi), %ymm3
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 864(%rdi), %ymm7
; AVX-NEXT:    vmovapd 576(%rdi), %ymm4
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 544(%rdi), %ymm2
; AVX-NEXT:    vmovapd 256(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 224(%rdi), %ymm5
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm5[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 192(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 160(%rdi), %xmm9
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm9[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1,2],ymm4[3]
; AVX-NEXT:    vmovapd 512(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 480(%rdi), %xmm6
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm6[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0,1,2],ymm3[3]
; AVX-NEXT:    vmovapd 832(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 800(%rdi), %xmm10
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm10[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1216(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1184(%rdi), %ymm8
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm8[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 1152(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 1120(%rdi), %xmm11
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm11[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 96(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 64(%rdi), %ymm4
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd (%rdi), %xmm13
; AVX-NEXT:    vmovapd 32(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm13[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 384(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rdi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm12[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 736(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 704(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 672(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 640(%rdi), %xmm14
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm14[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1056(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1024(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 992(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 960(%rdi), %xmm15
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm15[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm5[0],ymm0[0],ymm5[3],ymm0[2]
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm5
; AVX-NEXT:    vpalignr {{.*#+}} xmm3 = xmm9[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 608(%rdi), %xmm9
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[3],ymm0[2]
; AVX-NEXT:    vmovdqa 528(%rdi), %xmm2
; AVX-NEXT:    vpalignr {{.*#+}} xmm3 = xmm6[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 928(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm7[0],ymm0[0],ymm7[3],ymm0[2]
; AVX-NEXT:    vmovdqa 848(%rdi), %xmm3
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm10[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1248(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm6
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm8[0],ymm6[0],ymm8[3],ymm6[2]
; AVX-NEXT:    vmovdqa 1168(%rdi), %xmm7
; AVX-NEXT:    vpalignr {{.*#+}} xmm8 = xmm11[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm8[0,1],ymm6[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm6
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm6[0],ymm4[3],ymm6[2]
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rdi), %xmm10
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm4
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm6[0],ymm4[0],ymm6[3],ymm4[2]
; AVX-NEXT:    vmovdqa 368(%rdi), %xmm11
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm12[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 768(%rdi), %xmm12
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm4
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm6[0],ymm4[0],ymm6[3],ymm4[2]
; AVX-NEXT:    vmovdqa 688(%rdi), %xmm13
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm14[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1088(%rdi), %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm4
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm0[0],ymm4[0],ymm0[3],ymm4[2]
; AVX-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm15[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rdi), %xmm4
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1],xmm1[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovdqa 176(%rdi), %xmm15
; AVX-NEXT:    vpblendw {{.*#+}} xmm5 = xmm15[0,1,2,3],xmm5[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 576(%rdi), %xmm5
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm5[0,1],xmm9[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovdqa 496(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 896(%rdi), %xmm6
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm6[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovdqa 816(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm3[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1216(%rdi), %xmm3
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm3[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 1136(%rdi), %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm9[0,1,2,3],xmm7[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm8[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm10[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 336(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm11[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 736(%rdi), %xmm2
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0,1],xmm12[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 656(%rdi), %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm12[0,1,2,3],xmm13[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1056(%rdi), %xmm0
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm14[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm7
; AVX-NEXT:    vmovaps 976(%rdi), %xmm1
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm8 # 16-byte Folded Reload
; AVX-NEXT:    # xmm8 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX-NEXT:    vmovapd 288(%rdi), %ymm13
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm13[0],ymm4[3],ymm13[2]
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm10
; AVX-NEXT:    vpalignr {{.*#+}} xmm8 = xmm15[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm8[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm4
; AVX-NEXT:    vmovapd 608(%rdi), %ymm14
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm4[0],ymm14[0],ymm4[3],ymm14[2]
; AVX-NEXT:    vmovdqa 544(%rdi), %xmm11
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm8 # 16-byte Folded Reload
; AVX-NEXT:    # xmm8 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm8[0,1],ymm5[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm5
; AVX-NEXT:    vmovapd 928(%rdi), %ymm4
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm4[0],ymm5[3],ymm4[2]
; AVX-NEXT:    vmovdqa 864(%rdi), %xmm8
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm6[0,1],ymm5[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vmovapd 1248(%rdi), %ymm4
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[3],ymm4[2]
; AVX-NEXT:    vmovdqa 1184(%rdi), %xmm15
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm9[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 1088(%rdi), %ymm7
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm7[0],ymm0[3],ymm7[2]
; AVX-NEXT:    vmovdqa 1024(%rdi), %xmm9
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 768(%rdi), %ymm5
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[3],ymm5[2]
; AVX-NEXT:    vmovdqa 704(%rdi), %xmm4
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm12[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 448(%rdi), %ymm3
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[3],ymm3[2]
; AVX-NEXT:    vmovdqa 384(%rdi), %xmm2
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 128(%rdi), %ymm12
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm12[0],ymm1[3],ymm12[2]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = mem[0,1,2],ymm12[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = mem[0,1,2,3],xmm0[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm13[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2,3],xmm10[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm12 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm3[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2,3],xmm2[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm10 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm14[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2,3],xmm11[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm5[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = mem[0,1,2,3],xmm4[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm2[0,1],ymm0[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = mem[0,1,2,3],xmm8[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm11 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm7[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = mem[0,1,2,3],xmm9[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm0[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = mem[0,1,2,3],xmm15[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 192(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 128(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, (%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 224(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 160(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 192(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 128(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, (%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 224(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 160(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 192(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 128(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, (%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 224(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 160(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX-NEXT:    vmovapd %ymm6, (%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 64(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 128(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 192(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 224(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 160(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 96(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm4, 32(%r8)
; AVX-NEXT:    vmovaps %ymm0, 224(%r9)
; AVX-NEXT:    vmovapd %ymm2, 192(%r9)
; AVX-NEXT:    vmovaps %ymm11, 160(%r9)
; AVX-NEXT:    vmovapd %ymm3, 128(%r9)
; AVX-NEXT:    vmovapd %ymm1, 96(%r9)
; AVX-NEXT:    vmovapd %ymm10, 64(%r9)
; AVX-NEXT:    vmovapd %ymm12, 32(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    addq $1368, %rsp # imm = 0x558
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $1464, %rsp # imm = 0x5B8
; AVX2-NEXT:    vmovdqa 896(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 864(%rdi), %ymm4
; AVX2-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 576(%rdi), %ymm3
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 544(%rdi), %ymm6
; AVX2-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 256(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 224(%rdi), %ymm5
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX2-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 160(%rdi), %xmm14
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vmovdqa 512(%rdi), %xmm2
; AVX2-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 480(%rdi), %xmm10
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm10[0,1],xmm2[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovdqa 832(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 800(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm4[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1216(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1184(%rdi), %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 1152(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 1120(%rdi), %xmm12
; AVX2-NEXT:    vpblendd {{.*#+}} xmm3 = xmm12[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 384(%rdi), %ymm6
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 320(%rdi), %xmm15
; AVX2-NEXT:    vpblendd {{.*#+}} xmm7 = xmm15[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 704(%rdi), %ymm7
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm7[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 672(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 640(%rdi), %xmm3
; AVX2-NEXT:    vpblendd {{.*#+}} xmm9 = xmm3[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1024(%rdi), %ymm8
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 992(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 960(%rdi), %xmm9
; AVX2-NEXT:    vpblendd {{.*#+}} xmm11 = xmm9[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 288(%rdi), %ymm1
; AVX2-NEXT:    vpalignr {{.*#+}} ymm5 = ymm5[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm5[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm1, %ymm14
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm10[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 608(%rdi), %ymm1
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm1, %ymm11
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 928(%rdi), %ymm1
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm1, %ymm10
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm12[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1248(%rdi), %ymm1
; AVX2-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm12
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm15[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 448(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} ymm2 = ymm6[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm1 = ymm7[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm7[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm1 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 544(%rdi), %xmm6
; AVX2-NEXT:    vpalignr {{.*#+}} xmm2 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 864(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1184(%rdi), %xmm14
; AVX2-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm13[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1024(%rdi), %xmm11
; AVX2-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm10[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 704(%rdi), %xmm9
; AVX2-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpalignr {{.*#+}} ymm7 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-NEXT:    vmovdqa 384(%rdi), %xmm5
; AVX2-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vpalignr {{.*#+}} ymm7 = ymm1[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm15[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-NEXT:    vpblendd $3, (%rsp), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm15 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm9[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm11[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm14[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-NEXT:    vmovdqa %ymm7, (%r8)
; AVX2-NEXT:    vmovdqa %ymm8, 64(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm0, 224(%r9)
; AVX2-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-NEXT:    vmovaps %ymm2, 160(%r9)
; AVX2-NEXT:    vmovdqa %ymm6, 128(%r9)
; AVX2-NEXT:    vmovdqa %ymm15, 96(%r9)
; AVX2-NEXT:    vmovdqa %ymm5, 64(%r9)
; AVX2-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-NEXT:    vmovdqa %ymm12, (%r9)
; AVX2-NEXT:    addq $1464, %rsp # imm = 0x5B8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $1464, %rsp # imm = 0x5B8
; AVX2-FP-NEXT:    vmovdqa 896(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 864(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 576(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 544(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %ymm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %xmm14
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vmovdqa 512(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 480(%rdi), %xmm10
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm10[0,1],xmm2[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovdqa 832(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 800(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm4[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1216(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1184(%rdi), %ymm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 1152(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1120(%rdi), %xmm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm3 = xmm12[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %ymm6
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 320(%rdi), %xmm15
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm7 = xmm15[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 704(%rdi), %ymm7
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm7[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 672(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 640(%rdi), %xmm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm3[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1024(%rdi), %ymm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 992(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 960(%rdi), %xmm9
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm11 = xmm9[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %ymm1
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm5 = ymm5[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm5[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm14
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm10[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 608(%rdi), %ymm1
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm11
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 928(%rdi), %ymm1
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm10
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm12[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1248(%rdi), %ymm1
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm12
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm15[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 448(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm6[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm7[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm7[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 544(%rdi), %xmm6
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm2 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 864(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1184(%rdi), %xmm14
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm0 = ymm13[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1024(%rdi), %xmm11
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm0 = ymm10[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 704(%rdi), %xmm9
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %xmm5
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm1[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm15[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FP-NEXT:    vpblendd $3, (%rsp), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm15 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm9[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm11[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm14[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm7, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm8, 64(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, 224(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm2, 160(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 128(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm15, 96(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 64(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm12, (%r9)
; AVX2-FP-NEXT:    addq $1464, %rsp # imm = 0x5B8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $1464, %rsp # imm = 0x5B8
; AVX2-FCP-NEXT:    vmovdqa 896(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 864(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 576(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 544(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %ymm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %xmm14
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovdqa 512(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 480(%rdi), %xmm10
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm10[0,1],xmm2[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovdqa 832(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 800(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm2 = xmm4[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1216(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1184(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 1152(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1120(%rdi), %xmm12
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm3 = xmm12[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm13
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm13[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %ymm6
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 320(%rdi), %xmm15
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm7 = xmm15[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 704(%rdi), %ymm7
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm7[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 672(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 640(%rdi), %xmm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm9 = xmm3[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1024(%rdi), %ymm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 992(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 960(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm11 = xmm9[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm5 = ymm5[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm5[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm14
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm10[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 608(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm11
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 928(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm10
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm12[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1248(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm12
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm15[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 448(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm6[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm7[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm7[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm8[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 544(%rdi), %xmm6
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm2 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 864(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1184(%rdi), %xmm14
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm0 = ymm13[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1024(%rdi), %xmm11
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm0 = ymm10[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 704(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm3[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm7 = ymm1[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm15[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, (%rsp), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm15 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm9[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-FCP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm11[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm14[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, 64(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 224(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 160(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm6, 128(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm15, 96(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, 64(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 32(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, (%r9)
; AVX2-FCP-NEXT:    addq $1464, %rsp # imm = 0x5B8
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512-NEXT:    movb $7, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512-NEXT:    movb $56, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512-FCP-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512-FCP-NEXT:    movb $7, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512-FCP-NEXT:    movb $56, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512DQ-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512DQ-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512DQ-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512DQ-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512DQ-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512DQ-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512DQ-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512DQ-NEXT:    movb $7, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512DQ-NEXT:    movb $56, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512DQ-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512DQ-FCP-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512DQ-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512DQ-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512DQ-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512DQ-FCP-NEXT:    movb $7, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512DQ-FCP-NEXT:    movb $56, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512DQ-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512BW-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512BW-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512BW-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512BW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512BW-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512BW-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512BW-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512BW-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512BW-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512BW-NEXT:    movb $7, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512BW-NEXT:    movb $56, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512BW-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512BW-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512BW-FCP-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512BW-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512BW-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512BW-FCP-NEXT:    movb $7, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512BW-FCP-NEXT:    movb $56, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512BW-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-BW-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512DQ-BW-NEXT:    movb $7, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512DQ-BW-NEXT:    movb $56, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512DQ-BW-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm11, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm24 = [0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm11, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm24, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm11, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm11, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm28 = [1,6,11,0]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm15, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm15, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm13 = [2,7,12,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm23, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm23, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm0, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm29, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm21, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm13, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm31 = [11,0,5,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm31, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm11, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm24, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm28, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm13, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm31, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm11, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm24, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm28, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm13, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm31, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm2, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm11, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm11, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm12 = zmm0[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm10 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm10 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm6 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm24, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm24, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm24, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm24, %zmm6
; AVX512DQ-BW-FCP-NEXT:    movb $7, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm30 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm22 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm28, %zmm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm15
; AVX512DQ-BW-FCP-NEXT:    movb $56, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm21 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm13 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm31 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm7, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm7, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm7, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm7, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 192(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 128(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 192(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 128(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 192(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 128(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <160 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <160 x i64> %wide.vec, <160 x i64> poison, <32 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75, i32 80, i32 85, i32 90, i32 95, i32 100, i32 105, i32 110, i32 115, i32 120, i32 125, i32 130, i32 135, i32 140, i32 145, i32 150, i32 155>
  %strided.vec1 = shufflevector <160 x i64> %wide.vec, <160 x i64> poison, <32 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76, i32 81, i32 86, i32 91, i32 96, i32 101, i32 106, i32 111, i32 116, i32 121, i32 126, i32 131, i32 136, i32 141, i32 146, i32 151, i32 156>
  %strided.vec2 = shufflevector <160 x i64> %wide.vec, <160 x i64> poison, <32 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77, i32 82, i32 87, i32 92, i32 97, i32 102, i32 107, i32 112, i32 117, i32 122, i32 127, i32 132, i32 137, i32 142, i32 147, i32 152, i32 157>
  %strided.vec3 = shufflevector <160 x i64> %wide.vec, <160 x i64> poison, <32 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78, i32 83, i32 88, i32 93, i32 98, i32 103, i32 108, i32 113, i32 118, i32 123, i32 128, i32 133, i32 138, i32 143, i32 148, i32 153, i32 158>
  %strided.vec4 = shufflevector <160 x i64> %wide.vec, <160 x i64> poison, <32 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79, i32 84, i32 89, i32 94, i32 99, i32 104, i32 109, i32 114, i32 119, i32 124, i32 129, i32 134, i32 139, i32 144, i32 149, i32 154, i32 159>
  store <32 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <32 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <32 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <32 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i64_stride5_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i64_stride5_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $2216, %rsp # imm = 0x8A8
; SSE-NEXT:    movapd 224(%rdi), %xmm5
; SSE-NEXT:    movapd 144(%rdi), %xmm4
; SSE-NEXT:    movapd 64(%rdi), %xmm3
; SSE-NEXT:    movapd 176(%rdi), %xmm7
; SSE-NEXT:    movapd 96(%rdi), %xmm6
; SSE-NEXT:    movapd 208(%rdi), %xmm10
; SSE-NEXT:    movapd 128(%rdi), %xmm9
; SSE-NEXT:    movapd (%rdi), %xmm12
; SSE-NEXT:    movapd 16(%rdi), %xmm8
; SSE-NEXT:    movapd 32(%rdi), %xmm0
; SSE-NEXT:    movapd 48(%rdi), %xmm11
; SSE-NEXT:    movapd 160(%rdi), %xmm13
; SSE-NEXT:    movapd 192(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rdi), %xmm14
; SSE-NEXT:    movapd 112(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm0, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm12[0],xmm15[1]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm11[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm8[0],xmm11[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm3[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm0[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm2, %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm14[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm14 = xmm14[1],xmm9[0]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm6[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm4[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm13[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm10[0]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm7[0],xmm10[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm5[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm1[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm2
; SSE-NEXT:    movapd 352(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm2
; SSE-NEXT:    movapd 432(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm2
; SSE-NEXT:    movapd 512(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 496(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 560(%rdi), %xmm2
; SSE-NEXT:    movapd 592(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 608(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 576(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 624(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 640(%rdi), %xmm2
; SSE-NEXT:    movapd 672(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 688(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 656(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 704(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 720(%rdi), %xmm2
; SSE-NEXT:    movapd 752(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 768(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 736(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 784(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 800(%rdi), %xmm2
; SSE-NEXT:    movapd 832(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 848(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 816(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 864(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 880(%rdi), %xmm2
; SSE-NEXT:    movapd 912(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 928(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 896(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 944(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 960(%rdi), %xmm2
; SSE-NEXT:    movapd 992(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1008(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 976(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1024(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1040(%rdi), %xmm2
; SSE-NEXT:    movapd 1072(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1088(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1056(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1104(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1120(%rdi), %xmm2
; SSE-NEXT:    movapd 1152(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1168(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1136(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1184(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1200(%rdi), %xmm2
; SSE-NEXT:    movapd 1232(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1248(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1216(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1264(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1280(%rdi), %xmm2
; SSE-NEXT:    movapd 1312(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1328(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1296(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1344(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1360(%rdi), %xmm2
; SSE-NEXT:    movapd 1392(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1408(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1376(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1424(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1440(%rdi), %xmm2
; SSE-NEXT:    movapd 1472(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1488(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1456(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1504(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1520(%rdi), %xmm2
; SSE-NEXT:    movapd 1552(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1568(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1536(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1584(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1600(%rdi), %xmm2
; SSE-NEXT:    movapd 1632(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1648(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1616(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1664(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1680(%rdi), %xmm2
; SSE-NEXT:    movapd 1712(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1728(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1696(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1744(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1760(%rdi), %xmm2
; SSE-NEXT:    movapd 1792(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1808(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1776(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1824(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1840(%rdi), %xmm2
; SSE-NEXT:    movapd 1872(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1888(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1856(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1904(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1920(%rdi), %xmm2
; SSE-NEXT:    movapd 1952(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1968(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1936(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1984(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2000(%rdi), %xmm2
; SSE-NEXT:    movapd 2032(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2048(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 2016(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2064(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2080(%rdi), %xmm2
; SSE-NEXT:    movapd 2112(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2128(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2096(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2144(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2160(%rdi), %xmm14
; SSE-NEXT:    movapd 2192(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm11
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm14[0],xmm11[1]
; SSE-NEXT:    movapd 2208(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm14 = xmm14[1],xmm1[0]
; SSE-NEXT:    movapd 2176(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2224(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2240(%rdi), %xmm12
; SSE-NEXT:    movapd 2272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm8
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm12[0],xmm8[1]
; SSE-NEXT:    movapd 2288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm1[0]
; SSE-NEXT:    movapd 2256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2320(%rdi), %xmm9
; SSE-NEXT:    movapd 2352(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm9[0],xmm6[1]
; SSE-NEXT:    movapd 2368(%rdi), %xmm15
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm15[0]
; SSE-NEXT:    movapd 2336(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm2[0],xmm15[1]
; SSE-NEXT:    movapd 2384(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2400(%rdi), %xmm7
; SSE-NEXT:    movapd 2432(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm4
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm7[0],xmm4[1]
; SSE-NEXT:    movapd 2448(%rdi), %xmm13
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm13[0]
; SSE-NEXT:    movapd 2416(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm2[0],xmm13[1]
; SSE-NEXT:    movapd 2464(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2480(%rdi), %xmm5
; SSE-NEXT:    movapd 2512(%rdi), %xmm3
; SSE-NEXT:    movapd %xmm3, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm5[0],xmm2[1]
; SSE-NEXT:    movapd 2528(%rdi), %xmm10
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm10[0]
; SSE-NEXT:    movapd 2496(%rdi), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm0[0],xmm10[1]
; SSE-NEXT:    movapd 2544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm1[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; SSE-NEXT:    movapd %xmm2, 496(%rsi)
; SSE-NEXT:    movapd %xmm4, 480(%rsi)
; SSE-NEXT:    movapd %xmm6, 464(%rsi)
; SSE-NEXT:    movapd %xmm8, 448(%rsi)
; SSE-NEXT:    movapd %xmm11, 432(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rsi)
; SSE-NEXT:    movapd %xmm5, 496(%rdx)
; SSE-NEXT:    movapd %xmm7, 480(%rdx)
; SSE-NEXT:    movapd %xmm9, 464(%rdx)
; SSE-NEXT:    movapd %xmm12, 448(%rdx)
; SSE-NEXT:    movapd %xmm14, 432(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rdx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movapd %xmm10, 496(%rcx)
; SSE-NEXT:    movapd %xmm13, 480(%rcx)
; SSE-NEXT:    movapd %xmm15, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm1, 496(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    addq $2216, %rsp # imm = 0x8A8
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i64_stride5_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $3256, %rsp # imm = 0xCB8
; AVX-NEXT:    vmovapd 896(%rdi), %ymm2
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 864(%rdi), %ymm4
; AVX-NEXT:    vmovapd 576(%rdi), %ymm3
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 544(%rdi), %ymm5
; AVX-NEXT:    vmovapd 256(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 224(%rdi), %ymm7
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 192(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 160(%rdi), %xmm11
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm11[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm5[0,1,2],ymm3[3]
; AVX-NEXT:    vmovapd 512(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 480(%rdi), %xmm8
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm8[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1,2],ymm2[3]
; AVX-NEXT:    vmovapd 832(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 800(%rdi), %xmm3
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm3[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1216(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1184(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 1152(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 1120(%rdi), %xmm9
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm9[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1536(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1504(%rdi), %ymm6
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 1472(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 1440(%rdi), %xmm12
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm12[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1856(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 1824(%rdi), %ymm10
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm10[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 1792(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 1760(%rdi), %xmm13
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm13[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 2176(%rdi), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 2144(%rdi), %ymm14
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm14[0,1,2],ymm0[3]
; AVX-NEXT:    vmovapd 2112(%rdi), %xmm1
; AVX-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovapd 2080(%rdi), %xmm15
; AVX-NEXT:    vblendpd {{.*#+}} xmm1 = xmm15[0],xmm1[1]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2496(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2464(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 2432(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 2400(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps (%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 384(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 736(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 704(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 672(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 640(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1056(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1024(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 992(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 960(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1376(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1344(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 1312(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 1280(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1696(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1664(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 1632(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 1600(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2016(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1984(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 1952(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 1920(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2336(%rdi), %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2304(%rdi), %ymm1
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps 2272(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 2240(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm1 = xmm0[0,1],xmm1[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm7[0],ymm0[0],ymm7[3],ymm0[2]
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm11[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 608(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm5[0],ymm0[0],ymm5[3],ymm0[2]
; AVX-NEXT:    vmovdqa 528(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm8[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 928(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm4[0],ymm0[0],ymm4[3],ymm0[2]
; AVX-NEXT:    vmovdqa 848(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm3[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1248(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1168(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm9[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1568(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm6[0],ymm0[0],ymm6[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1488(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm12[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1888(%rdi), %xmm11
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm10[0],ymm0[0],ymm10[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1808(%rdi), %xmm12
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm13[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2208(%rdi), %xmm13
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm14[0],ymm0[0],ymm14[3],ymm0[2]
; AVX-NEXT:    vmovdqa 2128(%rdi), %xmm14
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm15[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2528(%rdi), %xmm15
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 2448(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 368(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 768(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 688(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1088(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1008(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1408(%rdi), %xmm8
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1328(%rdi), %xmm10
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1728(%rdi), %xmm6
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1648(%rdi), %xmm7
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2048(%rdi), %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX-NEXT:    vmovdqa 1968(%rdi), %xmm5
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2368(%rdi), %xmm2
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX-NEXT:    vmovdqa 2288(%rdi), %xmm3
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm9[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 176(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 576(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 496(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 896(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 816(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1216(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 1136(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1536(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 1456(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm0[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1856(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm11[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 1776(%rdi), %xmm9
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3],xmm12[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2176(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm13[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 2096(%rdi), %xmm9
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2,3],xmm14[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2496(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm15[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 2416(%rdi), %xmm15
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm15[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2336(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 2256(%rdi), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 2016(%rdi), %xmm0
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm4[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 1936(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm5[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1696(%rdi), %xmm12
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm12[0,1],xmm6[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX-NEXT:    vmovdqa 1616(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm7[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1376(%rdi), %xmm2
; AVX-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0,1],xmm8[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX-NEXT:    vmovdqa 1296(%rdi), %xmm0
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm0[0,1,2,3],xmm10[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 1056(%rdi), %xmm3
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm3[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm4
; AVX-NEXT:    vmovaps 976(%rdi), %xmm1
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = xmm1[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 736(%rdi), %xmm5
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = xmm5[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm6
; AVX-NEXT:    vmovaps 656(%rdi), %xmm4
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = xmm4[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rdi), %xmm6
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = xmm6[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX-NEXT:    vmovaps 336(%rdi), %xmm8
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm8[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm7
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm7[0,1],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm9
; AVX-NEXT:    vmovaps 16(%rdi), %xmm10
; AVX-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm11 # 16-byte Folded Reload
; AVX-NEXT:    # xmm11 = xmm10[0,1],mem[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm9 = ymm11[0,1,2,3],ymm9[4,5,6,7]
; AVX-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX-NEXT:    vmovapd 128(%rdi), %ymm9
; AVX-NEXT:    vmovupd %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm9[0],ymm7[3],ymm9[2]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm9
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm9 = xmm10[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3]
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 288(%rdi), %ymm9
; AVX-NEXT:    vmovupd %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm9[0],ymm7[3],ymm9[2]
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm9
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,3]
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX-NEXT:    vmovapd 448(%rdi), %ymm7
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[0],ymm6[3],ymm7[2]
; AVX-NEXT:    vmovdqa 384(%rdi), %xmm7
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm7 = xmm8[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm6 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 608(%rdi), %ymm7
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[0],ymm6[3],ymm7[2]
; AVX-NEXT:    vmovdqa 544(%rdi), %xmm7
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX-NEXT:    vmovapd 768(%rdi), %ymm6
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[3],ymm6[2]
; AVX-NEXT:    vmovdqa 704(%rdi), %xmm6
; AVX-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm4 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 928(%rdi), %ymm5
; AVX-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[3],ymm5[2]
; AVX-NEXT:    vmovdqa 864(%rdi), %xmm5
; AVX-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vmovapd 1088(%rdi), %ymm4
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[3],ymm4[2]
; AVX-NEXT:    vmovdqa 1024(%rdi), %xmm4
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 1248(%rdi), %ymm3
; AVX-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[3],ymm3[2]
; AVX-NEXT:    vmovdqa 1184(%rdi), %xmm3
; AVX-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 1408(%rdi), %ymm2
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[3],ymm2[2]
; AVX-NEXT:    vmovdqa 1344(%rdi), %xmm2
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 1568(%rdi), %ymm14
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm14[0],ymm0[3],ymm14[2]
; AVX-NEXT:    vmovdqa 1504(%rdi), %xmm13
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm0
; AVX-NEXT:    vmovapd 1728(%rdi), %ymm12
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm12[0],ymm0[3],ymm12[2]
; AVX-NEXT:    vmovdqa 1664(%rdi), %xmm11
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 1888(%rdi), %ymm10
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm10[0],ymm0[3],ymm10[2]
; AVX-NEXT:    vmovdqa 1824(%rdi), %xmm9
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 2048(%rdi), %ymm8
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm8[0],ymm0[3],ymm8[2]
; AVX-NEXT:    vmovdqa 1984(%rdi), %xmm7
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 2208(%rdi), %ymm6
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm6[0],ymm0[3],ymm6[2]
; AVX-NEXT:    vmovdqa 2144(%rdi), %xmm5
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 2368(%rdi), %ymm4
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[3],ymm4[2]
; AVX-NEXT:    vmovdqa 2304(%rdi), %xmm3
; AVX-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX-NEXT:    vmovapd 2528(%rdi), %ymm2
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[3],ymm2[2]
; AVX-NEXT:    vmovdqa 2464(%rdi), %xmm1
; AVX-NEXT:    vpalignr {{.*#+}} xmm15 = xmm15[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm14[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX-NEXT:    # xmm13 = mem[0,1,2,3],xmm13[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm13 = ymm13[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm12[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm11 # 16-byte Folded Reload
; AVX-NEXT:    # xmm11 = mem[0,1,2,3],xmm11[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm10[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = mem[0,1,2,3],xmm9[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm8[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = mem[0,1,2,3],xmm7[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm6[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = mem[0,1,2,3],xmm5[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm4[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = mem[0,1,2,3],xmm3[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm0[2,3]
; AVX-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[0,1,2],ymm2[3]
; AVX-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = mem[0,1,2,3],xmm1[4,5,6,7]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 448(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 384(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 320(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 256(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 480(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 416(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 352(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 288(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 448(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 384(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 320(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 256(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 416(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 288(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 256(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 320(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 384(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 448(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 480(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 416(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 352(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 288(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 480(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 448(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 416(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 384(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 320(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 288(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 256(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 64(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%r8)
; AVX-NEXT:    vmovapd %ymm0, 480(%r9)
; AVX-NEXT:    vmovapd %ymm3, 448(%r9)
; AVX-NEXT:    vmovapd %ymm5, 416(%r9)
; AVX-NEXT:    vmovapd %ymm7, 384(%r9)
; AVX-NEXT:    vmovapd %ymm9, 352(%r9)
; AVX-NEXT:    vmovapd %ymm11, 320(%r9)
; AVX-NEXT:    vmovapd %ymm13, 288(%r9)
; AVX-NEXT:    vmovaps %ymm15, 256(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 192(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    addq $3256, %rsp # imm = 0xCB8
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i64_stride5_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $3240, %rsp # imm = 0xCA8
; AVX2-NEXT:    vmovaps 896(%rdi), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 864(%rdi), %ymm4
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 576(%rdi), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 544(%rdi), %ymm5
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm6
; AVX2-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm6[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vmovaps 512(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 480(%rdi), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vmovaps 832(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 800(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1216(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1184(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 1152(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 1120(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1536(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1504(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 1472(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 1440(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1856(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1824(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 1792(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 1760(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 2176(%rdi), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 2144(%rdi), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovaps 2112(%rdi), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 2080(%rdi), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2496(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2464(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 2432(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 2400(%rdi), %xmm13
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm13[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm14
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm14[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 320(%rdi), %xmm8
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm8[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 704(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 672(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 640(%rdi), %xmm7
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm7[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX2-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 992(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 960(%rdi), %xmm5
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1376(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1344(%rdi), %ymm12
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 1312(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 1280(%rdi), %xmm4
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm4[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1696(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1664(%rdi), %ymm11
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 1632(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 1600(%rdi), %xmm3
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2016(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1984(%rdi), %ymm10
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 1952(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 1920(%rdi), %xmm9
; AVX2-NEXT:    vpblendd {{.*#+}} xmm6 = xmm9[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2336(%rdi), %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2304(%rdi), %ymm6
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovdqa 2272(%rdi), %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovdqa 2240(%rdi), %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm15 = xmm1[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 288(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 608(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 928(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1248(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, (%rsp), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1488(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1568(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1808(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1888(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2128(%rdi), %xmm0
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 2208(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2448(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 2528(%rdi), %ymm2
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm8[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm13
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm7[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm5[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1328(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1408(%rdi), %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm4 = ymm12[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm5
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1648(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 1728(%rdi), %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm4
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 1968(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 2048(%rdi), %ymm3
; AVX2-NEXT:    vpalignr {{.*#+}} ymm2 = ymm10[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 2288(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm0 = xmm1[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 2368(%rdi), %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm1 = ymm6[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vmovdqa %ymm2, %ymm14
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1440(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1536(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1760(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1856(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 2080(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 2176(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 2400(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 2496(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 2240(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 2336(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1920(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 2016(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1600(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1696(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 1280(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1376(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 224(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 384(%rdi), %xmm13
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 544(%rdi), %xmm11
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 704(%rdi), %xmm12
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 864(%rdi), %xmm10
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1024(%rdi), %xmm9
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1184(%rdi), %xmm8
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1344(%rdi), %xmm7
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1504(%rdi), %xmm6
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1664(%rdi), %xmm5
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1824(%rdi), %xmm4
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 1984(%rdi), %xmm3
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 2144(%rdi), %xmm2
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 2304(%rdi), %xmm1
; AVX2-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    vpermq {{.*#+}} ymm15 = ymm0[0,1,0,3]
; AVX2-NEXT:    vmovdqa 2464(%rdi), %xmm0
; AVX2-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm13 = mem[0,1],xmm13[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm13 = mem[0,1,2,3,4,5],ymm13[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm11 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm11 = mem[0,1],xmm11[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm13[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm12 = mem[0,1],xmm12[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm10 = mem[0,1],xmm10[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm11 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm9 = mem[0,1],xmm9[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm8 = mem[0,1],xmm8[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm14 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm8 = mem[0,1,2,3,4,5],ymm8[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm7 = mem[0,1],xmm7[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm10 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm13 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu (%rsp), %ymm5 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm3 = mem[0,1],xmm3[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm3 = mem[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm5 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 448(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 384(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 320(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 256(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 480(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 416(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 352(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 288(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 448(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 384(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 320(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 256(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 416(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 288(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 256(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 320(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 384(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 448(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 480(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 416(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 352(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 288(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 480(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 448(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 416(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 384(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 320(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 288(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 256(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 64(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm1, (%r8)
; AVX2-NEXT:    vmovdqa %ymm0, 480(%r9)
; AVX2-NEXT:    vmovdqa %ymm2, 448(%r9)
; AVX2-NEXT:    vmovdqa %ymm5, 416(%r9)
; AVX2-NEXT:    vmovdqa %ymm7, 384(%r9)
; AVX2-NEXT:    vmovdqa %ymm4, 352(%r9)
; AVX2-NEXT:    vmovdqa %ymm13, 320(%r9)
; AVX2-NEXT:    vmovdqa %ymm6, 288(%r9)
; AVX2-NEXT:    vmovdqa %ymm10, 256(%r9)
; AVX2-NEXT:    vmovdqa %ymm14, 224(%r9)
; AVX2-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-NEXT:    vmovdqa %ymm11, 160(%r9)
; AVX2-NEXT:    vmovdqa %ymm12, 128(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-NEXT:    vmovaps %ymm15, 32(%r9)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-NEXT:    addq $3240, %rsp # imm = 0xCA8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i64_stride5_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $3240, %rsp # imm = 0xCA8
; AVX2-FP-NEXT:    vmovaps 896(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 864(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 576(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 544(%rdi), %ymm5
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm6
; AVX2-FP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm6[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vmovaps 512(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vmovaps 832(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 800(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1216(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1184(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 1152(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 1120(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1536(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1504(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 1472(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 1440(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1856(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1824(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 1792(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 1760(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 2176(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 2144(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovaps 2112(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 2080(%rdi), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2496(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2464(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 2432(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2400(%rdi), %xmm13
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm13[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm14
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm14[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 320(%rdi), %xmm8
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm8[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 704(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 672(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 640(%rdi), %xmm7
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm7[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 992(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 960(%rdi), %xmm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1376(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1344(%rdi), %ymm12
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 1312(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1280(%rdi), %xmm4
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm4[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1696(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1664(%rdi), %ymm11
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 1632(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1600(%rdi), %xmm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2016(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1984(%rdi), %ymm10
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 1952(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1920(%rdi), %xmm9
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm9[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2336(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2304(%rdi), %ymm6
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovdqa 2272(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2240(%rdi), %xmm1
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm15 = xmm1[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 608(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 928(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1248(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, (%rsp), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1488(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1568(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1808(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1888(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2128(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 2208(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2448(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 2528(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm8[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm8 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm13
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm7[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm5[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm5 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1328(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1408(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm4 = ymm12[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm5
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1648(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 1728(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm4
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 1968(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 2048(%rdi), %ymm3
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm10[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 2288(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm1[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 2368(%rdi), %ymm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm6[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vmovdqa %ymm2, %ymm14
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1440(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1536(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1760(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1856(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 2080(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 2176(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 2400(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 2496(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 2240(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 2336(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1920(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 2016(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1600(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1696(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 1280(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1376(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 384(%rdi), %xmm13
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 544(%rdi), %xmm11
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 704(%rdi), %xmm12
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 864(%rdi), %xmm10
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1024(%rdi), %xmm9
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1184(%rdi), %xmm8
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1344(%rdi), %xmm7
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1504(%rdi), %xmm6
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1664(%rdi), %xmm5
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu (%rsp), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1824(%rdi), %xmm4
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 1984(%rdi), %xmm3
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 2144(%rdi), %xmm2
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 2304(%rdi), %xmm1
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm15 = ymm0[0,1,0,3]
; AVX2-FP-NEXT:    vmovdqa 2464(%rdi), %xmm0
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm13 = mem[0,1],xmm13[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm13 = mem[0,1,2,3,4,5],ymm13[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm11 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm11 = mem[0,1],xmm11[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm12 = mem[0,1],xmm12[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm10 = mem[0,1],xmm10[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm9 = mem[0,1],xmm9[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm8 = mem[0,1],xmm8[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm14 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm8 = mem[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm7 = mem[0,1],xmm7[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu (%rsp), %ymm5 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm3 = mem[0,1],xmm3[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 448(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 384(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 320(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 256(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 480(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 416(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 352(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 288(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 448(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 384(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 320(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 256(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 416(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 288(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 256(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 320(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 384(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 448(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 480(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 416(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 352(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 288(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 480(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 448(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 416(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 384(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 320(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 288(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 256(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm1, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, 480(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm2, 448(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm5, 416(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm7, 384(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm4, 352(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm13, 320(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm6, 288(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm10, 256(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm14, 224(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm11, 160(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm12, 128(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FP-NEXT:    vmovaps %ymm15, 32(%r9)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FP-NEXT:    addq $3240, %rsp # imm = 0xCA8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i64_stride5_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $3240, %rsp # imm = 0xCA8
; AVX2-FCP-NEXT:    vmovaps 896(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 864(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 576(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 544(%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm6[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovaps 512(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vmovaps 832(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 800(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1216(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1184(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 1152(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1120(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1536(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1504(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 1472(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1440(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1856(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1824(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 1792(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1760(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2176(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2144(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovaps 2112(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2080(%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2496(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2464(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 2432(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2400(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm13[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm14
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm14[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 352(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 320(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm8[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 704(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 672(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 640(%rdi), %xmm7
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm7[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 992(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 960(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1376(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1344(%rdi), %ymm12
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 1312(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1280(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm4[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1696(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1664(%rdi), %ymm11
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 1632(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1600(%rdi), %xmm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2016(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1984(%rdi), %ymm10
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 1952(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1920(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm6 = xmm9[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2336(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2304(%rdi), %ymm6
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovdqa 2272(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2240(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm15 = xmm1[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 208(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 528(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 608(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 848(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 928(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1168(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1248(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, (%rsp), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1488(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1568(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1808(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1888(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2128(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 2208(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2448(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm13[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 2528(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 48(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm15
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm13[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 368(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm8[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm8 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm13
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 688(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm7[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm8
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1008(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm5[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1088(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1328(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm4[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1408(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm4 = ymm12[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm5
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1648(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 1728(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm4
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 1968(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 2048(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm2 = ymm10[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 2288(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm0 = xmm1[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 2368(%rdi), %ymm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} ymm1 = ymm6[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vmovdqa %ymm2, %ymm14
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 576(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 800(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 896(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1120(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1216(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1440(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1536(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1760(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1856(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2080(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 2176(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2400(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 2496(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 2240(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 2336(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1920(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 2016(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1600(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1696(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 1280(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1376(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 960(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 1056(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 640(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 736(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],mem[2,3],ymm0[4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 384(%rdi), %xmm13
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 544(%rdi), %xmm11
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 704(%rdi), %xmm12
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 864(%rdi), %xmm10
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1024(%rdi), %xmm9
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1184(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1344(%rdi), %xmm7
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1504(%rdi), %xmm6
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1664(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu (%rsp), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1824(%rdi), %xmm4
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 1984(%rdi), %xmm3
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 2144(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 2304(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm0[0,1,0,3]
; AVX2-FCP-NEXT:    vmovdqa 2464(%rdi), %xmm0
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FCP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX2-FCP-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm14 = mem[0,1,2,3,4,5],ymm14[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm13 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm13 = mem[0,1],xmm13[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm13 = mem[0,1,2,3,4,5],ymm13[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm11 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm11 = mem[0,1],xmm11[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm13[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm12 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm12 = mem[0,1],xmm12[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm12 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm11 = mem[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm10 = mem[0,1],xmm10[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm9 = mem[0,1],xmm9[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = mem[0,1,2,3,4,5],ymm10[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm8 = mem[0,1],xmm8[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm14 = ymm8[0,1,2,3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm8 = mem[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm7 = mem[0,1],xmm7[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm7[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm6 = mem[0,1],xmm6[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = mem[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm5 = mem[0,1],xmm5[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm13 = ymm5[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu (%rsp), %ymm5 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm4 = mem[0,1],xmm4[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm3 = mem[0,1],xmm3[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm1 = mem[0,1],xmm1[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendd $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 448(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 384(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 320(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 256(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 480(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 416(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 352(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 288(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 448(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 384(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 320(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 256(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 416(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 288(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 256(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 320(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 384(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 448(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 480(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 416(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 352(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 288(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 480(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 448(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 416(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 384(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 320(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 288(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 256(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 480(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, 448(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm5, 416(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, 384(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, 352(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm13, 320(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm6, 288(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 256(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm14, 224(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm9, 192(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, 160(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, 128(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%r9)
; AVX2-FCP-NEXT:    vmovaps %ymm15, 32(%r9)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%r9)
; AVX2-FCP-NEXT:    addq $3240, %rsp # imm = 0xCA8
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride5_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    movb $7, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    movb $56, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i64_stride5_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512-FCP-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    movb $7, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    movb $56, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512-FCP-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512-FCP-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i64_stride5_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512DQ-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512DQ-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512DQ-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512DQ-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512DQ-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512DQ-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512DQ-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512DQ-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512DQ-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    movb $7, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512DQ-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512DQ-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    movb $56, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512DQ-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512DQ-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i64_stride5_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512DQ-FCP-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512DQ-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512DQ-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512DQ-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    movb $7, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    movb $56, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512DQ-FCP-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride5_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512BW-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512BW-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512BW-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512BW-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512BW-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512BW-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512BW-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512BW-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512BW-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512BW-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    movb $7, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    movb $56, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512BW-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512BW-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i64_stride5_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512BW-FCP-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512BW-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    movb $7, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    movb $56, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512BW-FCP-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512BW-FCP-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i64_stride5_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512DQ-BW-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512DQ-BW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    movb $7, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    movb $56, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512DQ-BW-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512DQ-BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512DQ-BW-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i64_stride5_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $3336, %rsp # imm = 0xD08
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1792(%rdi), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1408(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1088(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1152(%rdi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 768(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 832(%rdi), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 512(%rdi), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [12,1,6,0,12,1,6,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm16, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm16, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm16, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm16, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [5,10,15,0,5,10,15,0]
; AVX512DQ-BW-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm12, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm12, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm12, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm12, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm12, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [6,11,0,1,6,11,0,1]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm13, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm13, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm13, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm13, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [7,12,0,2,7,12,0,2]
; AVX512DQ-BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm14, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,5,0,11,0,5,0,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm14, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm6, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm14, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm6, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1472(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2048(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm13, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm14, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2368(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2432(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm31, %zmm3, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm29 = [1,6,11,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm31, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm6 = [2,7,12,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm31, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm7 = [11,0,5,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm3, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1024(%rdi), %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 960(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm3, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm21, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 704(%rdi), %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 640(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm20, %zmm3, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm20, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm20, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1664(%rdi), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1600(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm3, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm6, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1344(%rdi), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1280(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm3, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm6, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm7, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1920(%rdi), %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm3, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2304(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2240(%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm29, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm9, %zmm6, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm5, %zmm0, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm15, %zmm7, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm5, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm16, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm15, %zmm16, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm0 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm0 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm11, %zmm11 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm11 = zmm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm10, %zmm10 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm10 = zmm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm14[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm13, %zmm1 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm1 = zmm13[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm2[0,1,2,3],zmm18[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm3[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm15, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 576(%rdi), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 896(%rdi), %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm15, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm11, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1216(%rdi), %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm15, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1536(%rdi), %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm15, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 1856(%rdi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2176(%rdi), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm15, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 2496(%rdi), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    movb $7, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, %zmm26 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm29 = [0,1,2,3,4,5,6,12]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm29, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm29, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm29, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm29, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm29, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm29, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    movb $56, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm26 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm30 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,5,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm1, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm1, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm1, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm1, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,5,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm2, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm2, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm2, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm2, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm2, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm3, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm3, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm20 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm3, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm25 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm3, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm16, %zmm3, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm3, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm19, %zmm3, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 448(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 384(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 320(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 256(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 192(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups (%rsp), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 128(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 448(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 256(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 320(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 128(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 192(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 384(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 448(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 256(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, 320(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, 192(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm2, 64(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, 384(%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 448(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm28, 256(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 320(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, 64(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, 384(%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 384(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 448(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 256(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 320(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 128(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, 192(%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, 64(%r9)
; AVX512DQ-BW-FCP-NEXT:    addq $3336, %rsp # imm = 0xD08
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <320 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <320 x i64> %wide.vec, <320 x i64> poison, <64 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75, i32 80, i32 85, i32 90, i32 95, i32 100, i32 105, i32 110, i32 115, i32 120, i32 125, i32 130, i32 135, i32 140, i32 145, i32 150, i32 155, i32 160, i32 165, i32 170, i32 175, i32 180, i32 185, i32 190, i32 195, i32 200, i32 205, i32 210, i32 215, i32 220, i32 225, i32 230, i32 235, i32 240, i32 245, i32 250, i32 255, i32 260, i32 265, i32 270, i32 275, i32 280, i32 285, i32 290, i32 295, i32 300, i32 305, i32 310, i32 315>
  %strided.vec1 = shufflevector <320 x i64> %wide.vec, <320 x i64> poison, <64 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76, i32 81, i32 86, i32 91, i32 96, i32 101, i32 106, i32 111, i32 116, i32 121, i32 126, i32 131, i32 136, i32 141, i32 146, i32 151, i32 156, i32 161, i32 166, i32 171, i32 176, i32 181, i32 186, i32 191, i32 196, i32 201, i32 206, i32 211, i32 216, i32 221, i32 226, i32 231, i32 236, i32 241, i32 246, i32 251, i32 256, i32 261, i32 266, i32 271, i32 276, i32 281, i32 286, i32 291, i32 296, i32 301, i32 306, i32 311, i32 316>
  %strided.vec2 = shufflevector <320 x i64> %wide.vec, <320 x i64> poison, <64 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77, i32 82, i32 87, i32 92, i32 97, i32 102, i32 107, i32 112, i32 117, i32 122, i32 127, i32 132, i32 137, i32 142, i32 147, i32 152, i32 157, i32 162, i32 167, i32 172, i32 177, i32 182, i32 187, i32 192, i32 197, i32 202, i32 207, i32 212, i32 217, i32 222, i32 227, i32 232, i32 237, i32 242, i32 247, i32 252, i32 257, i32 262, i32 267, i32 272, i32 277, i32 282, i32 287, i32 292, i32 297, i32 302, i32 307, i32 312, i32 317>
  %strided.vec3 = shufflevector <320 x i64> %wide.vec, <320 x i64> poison, <64 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78, i32 83, i32 88, i32 93, i32 98, i32 103, i32 108, i32 113, i32 118, i32 123, i32 128, i32 133, i32 138, i32 143, i32 148, i32 153, i32 158, i32 163, i32 168, i32 173, i32 178, i32 183, i32 188, i32 193, i32 198, i32 203, i32 208, i32 213, i32 218, i32 223, i32 228, i32 233, i32 238, i32 243, i32 248, i32 253, i32 258, i32 263, i32 268, i32 273, i32 278, i32 283, i32 288, i32 293, i32 298, i32 303, i32 308, i32 313, i32 318>
  %strided.vec4 = shufflevector <320 x i64> %wide.vec, <320 x i64> poison, <64 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79, i32 84, i32 89, i32 94, i32 99, i32 104, i32 109, i32 114, i32 119, i32 124, i32 129, i32 134, i32 139, i32 144, i32 149, i32 154, i32 159, i32 164, i32 169, i32 174, i32 179, i32 184, i32 189, i32 194, i32 199, i32 204, i32 209, i32 214, i32 219, i32 224, i32 229, i32 234, i32 239, i32 244, i32 249, i32 254, i32 259, i32 264, i32 269, i32 274, i32 279, i32 284, i32 289, i32 294, i32 299, i32 304, i32 309, i32 314, i32 319>
  store <64 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <64 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <64 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <64 x i64> %strided.vec4, ptr %out.vec4, align 64
  ret void
}
