; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i32_stride2_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,3,2,3]
; SSE-NEXT:    movq %xmm1, (%rsi)
; SSE-NEXT:    movq %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX-NEXT:    vmovlps %xmm1, (%rsi)
; AVX-NEXT:    vmovlps %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX2-NEXT:    vmovlps %xmm1, (%rsi)
; AVX2-NEXT:    vmovlps %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX2-FP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX2-FP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX2-FCP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX2-FCP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512-FCP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512-FCP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512DQ-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512DQ-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512DQ-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512DQ-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512DQ-FCP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512BW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512BW-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512BW-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512BW-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512BW-FCP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512BW-FCP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512DQ-BW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512DQ-BW-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512DQ-BW-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,2,2,3]
; AVX512DQ-BW-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovlps %xmm1, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovlps %xmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <4 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <4 x i32> %wide.vec, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec1 = shufflevector <4 x i32> %wide.vec, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  store <2 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i32_stride2_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[0,2],xmm1[0,2]
; AVX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; AVX-NEXT:    vmovaps %xmm2, (%rsi)
; AVX-NEXT:    vmovaps %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX2-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[0,2],xmm1[0,2]
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; AVX2-NEXT:    vmovaps %xmm2, (%rsi)
; AVX2-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[0,2],xmm1[0,2]
; AVX2-FP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; AVX2-FP-NEXT:    vmovaps %xmm2, (%rsi)
; AVX2-FP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[0,2],xmm1[0,2]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; AVX2-FCP-NEXT:    vmovaps %xmm2, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovaps (%rdi), %xmm1
; AVX512-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovaps (%rdi), %xmm1
; AVX512-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512-FCP-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512-FCP-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm1
; AVX512DQ-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512DQ-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512DQ-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512DQ-FCP-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovaps (%rdi), %xmm1
; AVX512BW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512BW-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512BW-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %xmm1
; AVX512BW-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512BW-FCP-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512BW-FCP-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %xmm1
; AVX512DQ-BW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512DQ-BW-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512DQ-BW-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,3],mem[1,3]
; AVX512DQ-BW-FCP-NEXT:    vpmovqd %ymm0, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovaps %xmm1, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <8 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <8 x i32> %wide.vec, <8 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %strided.vec1 = shufflevector <8 x i32> %wide.vec, <8 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  store <4 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i32_stride2_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm3[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; SSE-NEXT:    movaps %xmm5, (%rsi)
; SSE-NEXT:    movaps %xmm4, 16(%rsi)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm2, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 32(%rdi), %ymm0, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX-NEXT:    vmovaps %ymm2, (%rsi)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovaps (%rdi), %ymm1
; AVX512-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],mem[1,3],ymm1[5,7],mem[5,7]
; AVX512-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX512-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512-NEXT:    vmovaps %ymm1, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [1,3,5,7,9,11,13,15]
; AVX512-FCP-NEXT:    vpermi2d 32(%rdi), %ymm1, %ymm2
; AVX512-FCP-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm1
; AVX512DQ-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],mem[1,3],ymm1[5,7],mem[5,7]
; AVX512DQ-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX512DQ-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512DQ-NEXT:    vmovaps %ymm1, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [1,3,5,7,9,11,13,15]
; AVX512DQ-FCP-NEXT:    vpermi2d 32(%rdi), %ymm1, %ymm2
; AVX512DQ-FCP-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovaps (%rdi), %ymm1
; AVX512BW-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],mem[1,3],ymm1[5,7],mem[5,7]
; AVX512BW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX512BW-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512BW-NEXT:    vmovaps %ymm1, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [1,3,5,7,9,11,13,15]
; AVX512BW-FCP-NEXT:    vpermi2d 32(%rdi), %ymm1, %ymm2
; AVX512BW-FCP-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %ymm1
; AVX512DQ-BW-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],mem[1,3],ymm1[5,7],mem[5,7]
; AVX512DQ-BW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX512DQ-BW-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512DQ-BW-NEXT:    vmovaps %ymm1, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm2 = [1,3,5,7,9,11,13,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d 32(%rdi), %ymm1, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpmovqd %zmm0, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <16 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <16 x i32> %wide.vec, <16 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %strided.vec1 = shufflevector <16 x i32> %wide.vec, <16 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  store <8 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i32_stride2_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm3
; SSE-NEXT:    movaps 80(%rdi), %xmm4
; SSE-NEXT:    movaps 64(%rdi), %xmm5
; SSE-NEXT:    movaps 112(%rdi), %xmm6
; SSE-NEXT:    movaps 96(%rdi), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm6[0,2]
; SSE-NEXT:    movaps %xmm5, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm4[0,2]
; SSE-NEXT:    movaps %xmm2, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm0, %xmm11
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,3],xmm6[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,3],xmm4[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm3[1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; SSE-NEXT:    movaps %xmm9, 32(%rsi)
; SSE-NEXT:    movaps %xmm8, 48(%rsi)
; SSE-NEXT:    movaps %xmm11, (%rsi)
; SSE-NEXT:    movaps %xmm10, 16(%rsi)
; SSE-NEXT:    movaps %xmm5, 32(%rdx)
; SSE-NEXT:    movaps %xmm7, 48(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm2, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 96(%rdi), %ymm1, %ymm1
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm1[0,2],ymm2[0,2],ymm1[4,6],ymm2[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 32(%rdi), %ymm0, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[0,2],ymm4[0,2],ymm0[4,6],ymm4[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm2[1,3],ymm1[5,7],ymm2[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm4[1,3],ymm0[5,7],ymm4[5,7]
; AVX-NEXT:    vmovaps %ymm5, (%rsi)
; AVX-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <32 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <32 x i32> %wide.vec, <32 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %strided.vec1 = shufflevector <32 x i32> %wide.vec, <32 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  store <16 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i32_stride2_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm0
; SSE-NEXT:    movaps 208(%rdi), %xmm11
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rdi), %xmm10
; SSE-NEXT:    movaps 224(%rdi), %xmm4
; SSE-NEXT:    movaps 144(%rdi), %xmm14
; SSE-NEXT:    movaps 128(%rdi), %xmm3
; SSE-NEXT:    movaps 176(%rdi), %xmm12
; SSE-NEXT:    movaps 160(%rdi), %xmm6
; SSE-NEXT:    movaps 80(%rdi), %xmm13
; SSE-NEXT:    movaps 64(%rdi), %xmm5
; SSE-NEXT:    movaps 112(%rdi), %xmm15
; SSE-NEXT:    movaps 96(%rdi), %xmm7
; SSE-NEXT:    movaps %xmm5, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm13[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,3],xmm13[1,3]
; SSE-NEXT:    movaps %xmm7, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,2],xmm15[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,3],xmm15[1,3]
; SSE-NEXT:    movaps %xmm3, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,2],xmm14[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,3],xmm14[1,3]
; SSE-NEXT:    movaps %xmm6, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,3],xmm12[1,3]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm11[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm11[1,3]
; SSE-NEXT:    movaps %xmm4, %xmm11
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm10[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,3],xmm10[1,3]
; SSE-NEXT:    movaps %xmm1, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm8[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,3],xmm8[1,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm8
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm8[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm8[1,3]
; SSE-NEXT:    movaps %xmm12, 96(%rsi)
; SSE-NEXT:    movaps %xmm11, 112(%rsi)
; SSE-NEXT:    movaps %xmm15, 64(%rsi)
; SSE-NEXT:    movaps %xmm14, 80(%rsi)
; SSE-NEXT:    movaps %xmm9, 32(%rsi)
; SSE-NEXT:    movaps %xmm13, 48(%rsi)
; SSE-NEXT:    movaps %xmm10, (%rsi)
; SSE-NEXT:    movaps %xmm1, 16(%rsi)
; SSE-NEXT:    movaps %xmm4, 112(%rdx)
; SSE-NEXT:    movaps %xmm2, 96(%rdx)
; SSE-NEXT:    movaps %xmm6, 80(%rdx)
; SSE-NEXT:    movaps %xmm3, 64(%rdx)
; SSE-NEXT:    movaps %xmm7, 48(%rdx)
; SSE-NEXT:    movaps %xmm5, 32(%rdx)
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %ymm0
; AVX-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX-NEXT:    vmovaps 128(%rdi), %ymm2
; AVX-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm3[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 224(%rdi), %ymm3, %ymm3
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm3[0,2],ymm4[0,2],ymm3[4,6],ymm4[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm1[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 96(%rdi), %ymm1, %ymm1
; AVX-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[0,2],ymm6[0,2],ymm1[4,6],ymm6[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm0[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 32(%rdi), %ymm0, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm0[0,2],ymm8[0,2],ymm0[4,6],ymm8[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm2[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 160(%rdi), %ymm2, %ymm2
; AVX-NEXT:    vshufps {{.*#+}} ymm11 = ymm2[0,2],ymm10[0,2],ymm2[4,6],ymm10[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm6[1,3],ymm1[5,7],ymm6[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[1,3],ymm4[1,3],ymm3[5,7],ymm4[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm8[1,3],ymm0[5,7],ymm8[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm10[1,3],ymm2[5,7],ymm10[5,7]
; AVX-NEXT:    vmovaps %ymm11, 64(%rsi)
; AVX-NEXT:    vmovaps %ymm9, (%rsi)
; AVX-NEXT:    vmovaps %ymm7, 32(%rsi)
; AVX-NEXT:    vmovaps %ymm5, 96(%rsi)
; AVX-NEXT:    vmovaps %ymm2, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm4
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm5
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm6
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm7
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm7[0,2],ymm6[0,2],ymm7[4,6],ymm6[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm5[0,2],ymm4[0,2],ymm5[4,6],ymm4[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[1,3],ymm6[1,3],ymm7[5,7],ymm6[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[1,3],ymm4[1,3],ymm5[5,7],ymm4[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm9, 64(%rsi)
; AVX2-NEXT:    vmovaps %ymm11, (%rsi)
; AVX2-NEXT:    vmovaps %ymm8, 96(%rsi)
; AVX2-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm5
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm7
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm7[0,2],ymm6[0,2],ymm7[4,6],ymm6[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm5[0,2],ymm4[0,2],ymm5[4,6],ymm4[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[1,3],ymm6[1,3],ymm7[5,7],ymm6[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[1,3],ymm4[1,3],ymm5[5,7],ymm4[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm9, 64(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm11, (%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm8, 96(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm7
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm7[0,2],ymm6[0,2],ymm7[4,6],ymm6[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm5[0,2],ymm4[0,2],ymm5[4,6],ymm4[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[1,3],ymm6[1,3],ymm7[5,7],ymm6[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[1,3],ymm4[1,3],ymm5[5,7],ymm4[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[1,3],ymm3[1,3],ymm2[5,7],ymm3[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm9, 64(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm11, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 96(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 64(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <64 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <64 x i32> %wide.vec, <64 x i32> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62>
  %strided.vec1 = shufflevector <64 x i32> %wide.vec, <64 x i32> poison, <32 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63>
  store <32 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i32_stride2_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i32_stride2_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movaps 208(%rdi), %xmm11
; SSE-NEXT:    movaps 192(%rdi), %xmm6
; SSE-NEXT:    movaps 80(%rdi), %xmm1
; SSE-NEXT:    movaps 64(%rdi), %xmm5
; SSE-NEXT:    movaps 240(%rdi), %xmm14
; SSE-NEXT:    movaps 224(%rdi), %xmm8
; SSE-NEXT:    movaps 112(%rdi), %xmm3
; SSE-NEXT:    movaps 96(%rdi), %xmm7
; SSE-NEXT:    movaps 272(%rdi), %xmm12
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rdi), %xmm9
; SSE-NEXT:    movaps 304(%rdi), %xmm0
; SSE-NEXT:    movaps 288(%rdi), %xmm13
; SSE-NEXT:    movaps 176(%rdi), %xmm4
; SSE-NEXT:    movaps 160(%rdi), %xmm10
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,2],xmm3[0,2]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,3],xmm3[1,3]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm1[0,2]
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,3],xmm1[1,3]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm4[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,3],xmm4[1,3]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,3],xmm2[1,3]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm14[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,3],xmm14[1,3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm11[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,3],xmm11[1,3]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,3],xmm0[1,3]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdi), %xmm0
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm12[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm12[1,3]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdi), %xmm0
; SSE-NEXT:    movaps 352(%rdi), %xmm15
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[1,3],xmm0[1,3]
; SSE-NEXT:    movaps 336(%rdi), %xmm0
; SSE-NEXT:    movaps 320(%rdi), %xmm13
; SSE-NEXT:    movaps %xmm13, %xmm11
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,3],xmm0[1,3]
; SSE-NEXT:    movaps 432(%rdi), %xmm0
; SSE-NEXT:    movaps 416(%rdi), %xmm12
; SSE-NEXT:    movaps %xmm12, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,3],xmm0[1,3]
; SSE-NEXT:    movaps 400(%rdi), %xmm0
; SSE-NEXT:    movaps 384(%rdi), %xmm9
; SSE-NEXT:    movaps %xmm9, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,3],xmm0[1,3]
; SSE-NEXT:    movaps 496(%rdi), %xmm0
; SSE-NEXT:    movaps 480(%rdi), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,3],xmm0[1,3]
; SSE-NEXT:    movaps 464(%rdi), %xmm1
; SSE-NEXT:    movaps 448(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,3],xmm1[1,3]
; SSE-NEXT:    movaps 32(%rdi), %xmm8
; SSE-NEXT:    movaps 48(%rdi), %xmm1
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,3],xmm1[1,3]
; SSE-NEXT:    movaps (%rdi), %xmm4
; SSE-NEXT:    movaps 16(%rdi), %xmm0
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,3],xmm0[1,3]
; SSE-NEXT:    movaps %xmm2, 224(%rsi)
; SSE-NEXT:    movaps %xmm11, 160(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rsi)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rsi)
; SSE-NEXT:    movaps %xmm6, 240(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rsi)
; SSE-NEXT:    movaps %xmm10, 192(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rsi)
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movaps %xmm14, 208(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rsi)
; SSE-NEXT:    movaps %xmm5, 16(%rsi)
; SSE-NEXT:    movaps %xmm3, 224(%rdx)
; SSE-NEXT:    movaps %xmm7, 240(%rdx)
; SSE-NEXT:    movaps %xmm9, 192(%rdx)
; SSE-NEXT:    movaps %xmm12, 208(%rdx)
; SSE-NEXT:    movaps %xmm13, 160(%rdx)
; SSE-NEXT:    movaps %xmm15, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps %xmm4, (%rdx)
; SSE-NEXT:    movaps %xmm8, 16(%rdx)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i32_stride2_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps 384(%rdi), %ymm4
; AVX-NEXT:    vmovaps 256(%rdi), %ymm6
; AVX-NEXT:    vmovaps 320(%rdi), %ymm5
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX-NEXT:    vmovaps 128(%rdi), %ymm9
; AVX-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm0[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 480(%rdi), %ymm0, %ymm10
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm10[0,2],ymm8[0,2],ymm10[4,6],ymm8[4,6]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm2[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 96(%rdi), %ymm2, %ymm11
; AVX-NEXT:    vshufps {{.*#+}} ymm2 = ymm11[0,2],ymm7[0,2],ymm11[4,6],ymm7[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm3[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 224(%rdi), %ymm3, %ymm13
; AVX-NEXT:    vshufps {{.*#+}} ymm3 = ymm13[0,2],ymm12[0,2],ymm13[4,6],ymm12[4,6]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm5[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 352(%rdi), %ymm5, %ymm15
; AVX-NEXT:    vshufps {{.*#+}} ymm5 = ymm15[0,2],ymm14[0,2],ymm15[4,6],ymm14[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm7 = ymm11[1,3],ymm7[1,3],ymm11[5,7],ymm7[5,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm9[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 160(%rdi), %ymm9, %ymm9
; AVX-NEXT:    vshufps {{.*#+}} ymm12 = ymm13[1,3],ymm12[1,3],ymm13[5,7],ymm12[5,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm6[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 288(%rdi), %ymm6, %ymm6
; AVX-NEXT:    vshufps {{.*#+}} ymm14 = ymm15[1,3],ymm14[1,3],ymm15[5,7],ymm14[5,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm4[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 416(%rdi), %ymm4, %ymm4
; AVX-NEXT:    vshufps {{.*#+}} ymm8 = ymm10[1,3],ymm8[1,3],ymm10[5,7],ymm8[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm10 = ymm4[0,2],ymm15[0,2],ymm4[4,6],ymm15[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[1,3],ymm15[1,3],ymm4[5,7],ymm15[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm15 = ymm6[0,2],ymm13[0,2],ymm6[4,6],ymm13[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm6 = ymm6[1,3],ymm13[1,3],ymm6[5,7],ymm13[5,7]
; AVX-NEXT:    vshufps {{.*#+}} ymm13 = ymm9[0,2],ymm11[0,2],ymm9[4,6],ymm11[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[1,3],ymm11[1,3],ymm9[5,7],ymm11[5,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm1[2,3],mem[2,3]
; AVX-NEXT:    vinsertf128 $1, 32(%rdi), %ymm1, %ymm1
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm11[0,2],ymm1[4,6],ymm11[4,6]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm11[1,3],ymm1[5,7],ymm11[5,7]
; AVX-NEXT:    vmovaps %ymm10, 192(%rsi)
; AVX-NEXT:    vmovaps %ymm15, 128(%rsi)
; AVX-NEXT:    vmovaps %ymm13, 64(%rsi)
; AVX-NEXT:    vmovaps %ymm0, (%rsi)
; AVX-NEXT:    vmovaps %ymm5, 160(%rsi)
; AVX-NEXT:    vmovaps %ymm3, 96(%rsi)
; AVX-NEXT:    vmovaps %ymm2, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rsi)
; AVX-NEXT:    vmovaps %ymm1, (%rdx)
; AVX-NEXT:    vmovaps %ymm9, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm6, 128(%rdx)
; AVX-NEXT:    vmovaps %ymm4, 192(%rdx)
; AVX-NEXT:    vmovaps %ymm8, 224(%rdx)
; AVX-NEXT:    vmovaps %ymm14, 160(%rdx)
; AVX-NEXT:    vmovaps %ymm12, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm7, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i32_stride2_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm4
; AVX2-NEXT:    vmovaps 416(%rdi), %ymm10
; AVX2-NEXT:    vmovaps 384(%rdi), %ymm12
; AVX2-NEXT:    vmovaps 288(%rdi), %ymm8
; AVX2-NEXT:    vmovaps 256(%rdi), %ymm11
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm7
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm9
; AVX2-NEXT:    vmovaps 480(%rdi), %ymm6
; AVX2-NEXT:    vmovaps 448(%rdi), %ymm14
; AVX2-NEXT:    vmovaps 352(%rdi), %ymm5
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm15
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm13
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[0,2],ymm2[0,2],ymm13[4,6],ymm2[4,6]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[1,3],ymm2[1,3],ymm13[5,7],ymm2[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm13 = ymm15[0,2],ymm5[0,2],ymm15[4,6],ymm5[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm15[1,3],ymm5[1,3],ymm15[5,7],ymm5[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm15 = ymm14[0,2],ymm6[0,2],ymm14[4,6],ymm6[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm6 = ymm14[1,3],ymm6[1,3],ymm14[5,7],ymm6[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm14 = ymm12[0,2],ymm10[0,2],ymm12[4,6],ymm10[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm12[1,3],ymm10[1,3],ymm12[5,7],ymm10[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm12 = ymm11[0,2],ymm8[0,2],ymm11[4,6],ymm8[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm8 = ymm11[1,3],ymm8[1,3],ymm11[5,7],ymm8[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[0,2],ymm7[0,2],ymm9[4,6],ymm7[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[1,3],ymm7[1,3],ymm9[5,7],ymm7[5,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm3[0,2],ymm4[0,2],ymm3[4,6],ymm4[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[1,3],ymm4[1,3],ymm3[5,7],ymm4[5,7]
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm4[0,2],ymm1[4,6],ymm4[4,6]
; AVX2-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm4[1,3],ymm1[5,7],ymm4[5,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm4, 192(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm12[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm4, 128(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm11[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, (%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm15[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 224(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm13[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 160(%rsi)
; AVX2-NEXT:    vpermpd $216, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 96(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm9[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 32(%rsi)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm1[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm7[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm8[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm10[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm6[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm5[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm2[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm3[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i32_stride2_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %ymm10
; AVX2-FP-NEXT:    vmovaps 384(%rdi), %ymm12
; AVX2-FP-NEXT:    vmovaps 288(%rdi), %ymm8
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %ymm11
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm7
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm9
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovaps 448(%rdi), %ymm14
; AVX2-FP-NEXT:    vmovaps 352(%rdi), %ymm5
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %ymm15
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm13
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[0,2],ymm2[0,2],ymm13[4,6],ymm2[4,6]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[1,3],ymm2[1,3],ymm13[5,7],ymm2[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm13 = ymm15[0,2],ymm5[0,2],ymm15[4,6],ymm5[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm15[1,3],ymm5[1,3],ymm15[5,7],ymm5[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm15 = ymm14[0,2],ymm6[0,2],ymm14[4,6],ymm6[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm6 = ymm14[1,3],ymm6[1,3],ymm14[5,7],ymm6[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm14 = ymm12[0,2],ymm10[0,2],ymm12[4,6],ymm10[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm12[1,3],ymm10[1,3],ymm12[5,7],ymm10[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm12 = ymm11[0,2],ymm8[0,2],ymm11[4,6],ymm8[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm8 = ymm11[1,3],ymm8[1,3],ymm11[5,7],ymm8[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[0,2],ymm7[0,2],ymm9[4,6],ymm7[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[1,3],ymm7[1,3],ymm9[5,7],ymm7[5,7]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm3[0,2],ymm4[0,2],ymm3[4,6],ymm4[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[1,3],ymm4[1,3],ymm3[5,7],ymm4[5,7]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm4[0,2],ymm1[4,6],ymm4[4,6]
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm4[1,3],ymm1[5,7],ymm4[5,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm4, 192(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm12[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm4, 128(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm11[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm15[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm13[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rsi)
; AVX2-FP-NEXT:    vpermpd $216, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm9[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rsi)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm1[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm7[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm8[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm10[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm6[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm5[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm3[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i32_stride2_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %ymm10
; AVX2-FCP-NEXT:    vmovaps 384(%rdi), %ymm12
; AVX2-FCP-NEXT:    vmovaps 288(%rdi), %ymm8
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm7
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm9
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 448(%rdi), %ymm14
; AVX2-FCP-NEXT:    vmovaps 352(%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %ymm15
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm13
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm13[0,2],ymm2[0,2],ymm13[4,6],ymm2[4,6]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm13[1,3],ymm2[1,3],ymm13[5,7],ymm2[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm13 = ymm15[0,2],ymm5[0,2],ymm15[4,6],ymm5[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm15[1,3],ymm5[1,3],ymm15[5,7],ymm5[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm15 = ymm14[0,2],ymm6[0,2],ymm14[4,6],ymm6[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm6 = ymm14[1,3],ymm6[1,3],ymm14[5,7],ymm6[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm14 = ymm12[0,2],ymm10[0,2],ymm12[4,6],ymm10[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm12[1,3],ymm10[1,3],ymm12[5,7],ymm10[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm12 = ymm11[0,2],ymm8[0,2],ymm11[4,6],ymm8[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm8 = ymm11[1,3],ymm8[1,3],ymm11[5,7],ymm8[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm9[0,2],ymm7[0,2],ymm9[4,6],ymm7[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[1,3],ymm7[1,3],ymm9[5,7],ymm7[5,7]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm3[0,2],ymm4[0,2],ymm3[4,6],ymm4[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm3 = ymm3[1,3],ymm4[1,3],ymm3[5,7],ymm4[5,7]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,2],ymm4[0,2],ymm1[4,6],ymm4[4,6]
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[1,3],ymm4[1,3],ymm1[5,7],ymm4[5,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm14[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm4, 192(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm12[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm4, 128(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm11[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm4, 64(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm15[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm13[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rsi)
; AVX2-FCP-NEXT:    vpermpd $216, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm9[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rsi)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm1[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm7[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm8[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm10[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm6[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm5[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rdx)
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm3[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i32_stride2_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i32_stride2_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i32_stride2_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512DQ-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i32_stride2_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i32_stride2_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i32_stride2_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i32_stride2_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i32_stride2_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm8, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm12 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm12, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm12, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm12, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm1, %zmm12, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 192(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 128(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 128(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 192(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <128 x i32>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <128 x i32> %wide.vec, <128 x i32> poison, <64 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126>
  %strided.vec1 = shufflevector <128 x i32> %wide.vec, <128 x i32> poison, <64 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  store <64 x i32> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i32> %strided.vec1, ptr %out.vec1, align 64
  ret void
}
