; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=armv7-none-linux-gnueabi | FileCheck %s --check-prefixes=CHECK,CHECK-V7
; RUN: llc < %s -mtriple=armv8-none-linux-gnueabi | FileCheck %s -check-prefixes=CHECK,CHECK-V8


define i32 @f(i32 %a, i32 %b) nounwind ssp {
; CHECK-LABEL: f:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r0, r0, r1
; CHECK-NEXT:    movle r0, #0
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %a, %b
  %sub = sub nsw i32 %a, %b
  %sub. = select i1 %cmp, i32 %sub, i32 0
  ret i32 %sub.
}

define i32 @g(i32 %a, i32 %b) nounwind ssp {
; CHECK-LABEL: g:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r0, r1, r0
; CHECK-NEXT:    movle r0, #0
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp slt i32 %a, %b
  %sub = sub nsw i32 %b, %a
  %sub. = select i1 %cmp, i32 %sub, i32 0
  ret i32 %sub.
}

define i32 @h(i32 %a, i32 %b) nounwind ssp {
; CHECK-LABEL: h:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r0, r0, #3
; CHECK-NEXT:    movle r0, r1
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %a, 3
  %sub = sub nsw i32 %a, 3
  %sub. = select i1 %cmp, i32 %sub, i32 %b
  ret i32 %sub.
}

; rdar://11725965
define i32 @i(i32 %a, i32 %b) nounwind readnone ssp {
; CHECK-LABEL: i:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r0, r1, r0
; CHECK-NEXT:    movls r0, #0
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp ult i32 %a, %b
  %sub = sub i32 %b, %a
  %sub. = select i1 %cmp, i32 %sub, i32 0
  ret i32 %sub.
}

; If CPSR is live-out, we can't remove cmp if there exists
; a swapped sub.
define i32 @j(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: j:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r1, r0, r1
; CHECK-NEXT:    movlt r0, r1
; CHECK-NEXT:    movne r0, r1
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp eq i32 %b, %a
  %sub = sub nsw i32 %a, %b
  br i1 %cmp, label %if.then, label %if.else

if.then:
  %cmp2 = icmp sgt i32 %b, %a
  %sel = select i1 %cmp2, i32 %sub, i32 %a
  ret i32 %sel

if.else:
  ret i32 %sub
}

; If the sub/rsb instruction is predicated, we can't use the flags.
; <rdar://problem/12263428>
; Test case from MultiSource/Benchmarks/Ptrdist/bc/number.s
define i32 @bc_raise(i1 %cond) nounwind ssp {
; CHECK-LABEL: bc_raise:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    mov r1, #1
; CHECK-NEXT:    tst r0, #1
; CHECK-NEXT:    bic r1, r1, r0
; CHECK-NEXT:    mov r0, #23
; CHECK-NEXT:    rsbeq r1, r1, #0
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    movweq r0, #17
; CHECK-NEXT:    bx lr
entry:
  %val.2.i = select i1 %cond, i32 0, i32 1
  %sub.i = sub nsw i32 0, %val.2.i
  %retval.0.i = select i1 %cond, i32 %val.2.i, i32 %sub.i
  %cmp1 = icmp eq i32 %retval.0.i, 0
  br i1 %cmp1, label %land.lhs.true, label %if.end11

land.lhs.true:                                    ; preds = %num2long.exit
  ret i32 17

if.end11:                                         ; preds = %num2long.exit
  ret i32 23
}

; When considering the producer of cmp's src as the subsuming instruction,
; only consider that when the comparison is to 0.
define i32 @cmp_src_nonzero(i32 %a, i32 %b, i32 %x, i32 %y) {
; CHECK-LABEL: cmp_src_nonzero:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sub r0, r0, r1
; CHECK-NEXT:    cmp r0, #17
; CHECK-NEXT:    movne r2, r3
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    bx lr
entry:
  %sub = sub i32 %a, %b
  %cmp = icmp eq i32 %sub, 17
  %ret = select i1 %cmp, i32 %x, i32 %y
  ret i32 %ret
}

define float @float_sel(i32 %a, i32 %b, float %x, float %y) {
; CHECK-V7-LABEL: float_sel:
; CHECK-V7:       @ %bb.0: @ %entry
; CHECK-V7-NEXT:    vmov s2, r2
; CHECK-V7-NEXT:    subs r0, r0, r1
; CHECK-V7-NEXT:    vmov s0, r3
; CHECK-V7-NEXT:    vmoveq.f32 s0, s2
; CHECK-V7-NEXT:    vmov r0, s0
; CHECK-V7-NEXT:    bx lr
;
; CHECK-V8-LABEL: float_sel:
; CHECK-V8:       @ %bb.0: @ %entry
; CHECK-V8-NEXT:    vmov s0, r3
; CHECK-V8-NEXT:    subs r0, r0, r1
; CHECK-V8-NEXT:    vmov s2, r2
; CHECK-V8-NEXT:    vseleq.f32 s0, s2, s0
; CHECK-V8-NEXT:    vmov r0, s0
; CHECK-V8-NEXT:    bx lr
entry:
  %sub = sub i32 %a, %b
  %cmp = icmp eq i32 %sub, 0
  %ret = select i1 %cmp, float %x, float %y
  ret float %ret
}

define double @double_sel(i32 %a, i32 %b, double %x, double %y) {
; CHECK-V7-LABEL: double_sel:
; CHECK-V7:       @ %bb.0: @ %entry
; CHECK-V7-NEXT:    vmov d17, r2, r3
; CHECK-V7-NEXT:    vldr d16, [sp]
; CHECK-V7-NEXT:    subs r0, r0, r1
; CHECK-V7-NEXT:    vmoveq.f64 d16, d17
; CHECK-V7-NEXT:    vmov r0, r1, d16
; CHECK-V7-NEXT:    bx lr
;
; CHECK-V8-LABEL: double_sel:
; CHECK-V8:       @ %bb.0: @ %entry
; CHECK-V8-NEXT:    vldr d16, [sp]
; CHECK-V8-NEXT:    vmov d17, r2, r3
; CHECK-V8-NEXT:    subs r0, r0, r1
; CHECK-V8-NEXT:    vseleq.f64 d16, d17, d16
; CHECK-V8-NEXT:    vmov r0, r1, d16
; CHECK-V8-NEXT:    bx lr
entry:
  %sub = sub i32 %a, %b
  %cmp = icmp eq i32 %sub, 0
  %ret = select i1 %cmp, double %x, double %y
  ret double %ret
}

@t = common global i32 0
define double @double_sub(i32 %a, i32 %b, double %x, double %y) {
; CHECK-V7-LABEL: double_sub:
; CHECK-V7:       @ %bb.0: @ %entry
; CHECK-V7-NEXT:    vmov d17, r2, r3
; CHECK-V7-NEXT:    cmp r0, r1
; CHECK-V7-NEXT:    vldr d16, [sp]
; CHECK-V7-NEXT:    sub r0, r0, r1
; CHECK-V7-NEXT:    vmovgt.f64 d16, d17
; CHECK-V7-NEXT:    movw r1, :lower16:t
; CHECK-V7-NEXT:    movt r1, :upper16:t
; CHECK-V7-NEXT:    str r0, [r1]
; CHECK-V7-NEXT:    vmov r2, r3, d16
; CHECK-V7-NEXT:    mov r0, r2
; CHECK-V7-NEXT:    mov r1, r3
; CHECK-V7-NEXT:    bx lr
;
; CHECK-V8-LABEL: double_sub:
; CHECK-V8:       @ %bb.0: @ %entry
; CHECK-V8-NEXT:    vldr d16, [sp]
; CHECK-V8-NEXT:    cmp r0, r1
; CHECK-V8-NEXT:    vmov d17, r2, r3
; CHECK-V8-NEXT:    sub r0, r0, r1
; CHECK-V8-NEXT:    vselgt.f64 d16, d17, d16
; CHECK-V8-NEXT:    movw r1, :lower16:t
; CHECK-V8-NEXT:    vmov r2, r3, d16
; CHECK-V8-NEXT:    movt r1, :upper16:t
; CHECK-V8-NEXT:    str r0, [r1]
; CHECK-V8-NEXT:    mov r0, r2
; CHECK-V8-NEXT:    mov r1, r3
; CHECK-V8-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %a, %b
  %sub = sub i32 %a, %b
  store i32 %sub, ptr @t
  %ret = select i1 %cmp, double %x, double %y
  ret double %ret
}

define double @double_sub_swap(i32 %a, i32 %b, double %x, double %y) {
; CHECK-V7-LABEL: double_sub_swap:
; CHECK-V7:       @ %bb.0: @ %entry
; CHECK-V7-NEXT:    vmov d17, r2, r3
; CHECK-V7-NEXT:    cmp r1, r0
; CHECK-V7-NEXT:    vldr d16, [sp]
; CHECK-V7-NEXT:    sub r0, r1, r0
; CHECK-V7-NEXT:    vmovlt.f64 d16, d17
; CHECK-V7-NEXT:    movw r1, :lower16:t
; CHECK-V7-NEXT:    movt r1, :upper16:t
; CHECK-V7-NEXT:    str r0, [r1]
; CHECK-V7-NEXT:    vmov r2, r3, d16
; CHECK-V7-NEXT:    mov r0, r2
; CHECK-V7-NEXT:    mov r1, r3
; CHECK-V7-NEXT:    bx lr
;
; CHECK-V8-LABEL: double_sub_swap:
; CHECK-V8:       @ %bb.0: @ %entry
; CHECK-V8-NEXT:    vldr d16, [sp]
; CHECK-V8-NEXT:    cmp r1, r0
; CHECK-V8-NEXT:    vmov d17, r2, r3
; CHECK-V8-NEXT:    sub r0, r1, r0
; CHECK-V8-NEXT:    vselge.f64 d16, d16, d17
; CHECK-V8-NEXT:    movw r1, :lower16:t
; CHECK-V8-NEXT:    vmov r2, r3, d16
; CHECK-V8-NEXT:    movt r1, :upper16:t
; CHECK-V8-NEXT:    str r0, [r1]
; CHECK-V8-NEXT:    mov r0, r2
; CHECK-V8-NEXT:    mov r1, r3
; CHECK-V8-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %a, %b
  %sub = sub i32 %b, %a
  %ret = select i1 %cmp, double %x, double %y
  store i32 %sub, ptr @t
  ret double %ret
}

declare void @abort()
declare void @exit(i32)

; If the comparison uses the V bit (signed overflow/underflow), we can't
; omit the comparison.
define i32 @cmp_slt0(i32 %a, i32 %b, i32 %x, i32 %y) {
; CHECK-LABEL: cmp_slt0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    movw r0, :lower16:t
; CHECK-NEXT:    movt r0, :upper16:t
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    sub r0, r0, #17
; CHECK-NEXT:    cmn r0, #1
; CHECK-NEXT:    ble .LBB11_2
; CHECK-NEXT:  @ %bb.1: @ %if.else
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    bl exit
; CHECK-NEXT:  .LBB11_2: @ %if.then
; CHECK-NEXT:    bl abort
entry:
  %load = load i32, ptr @t, align 4
  %sub = sub i32 %load, 17
  %cmp = icmp slt i32 %sub, 0
  br i1 %cmp, label %if.then, label %if.else

if.then:
  call void @abort()
  unreachable

if.else:
  call void @exit(i32 0)
  unreachable
}

; Same for the C bit. (Note the ult X, 0 is trivially
; false, so the DAG combiner may or may not optimize it).
define i32 @cmp_ult0(i32 %a, i32 %b, i32 %x, i32 %y) {
; CHECK-LABEL: cmp_ult0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    movw r0, :lower16:t
; CHECK-NEXT:    movt r0, :upper16:t
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    sub r0, r0, #17
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    bhs .LBB12_2
; CHECK-NEXT:  @ %bb.1: @ %if.then
; CHECK-NEXT:    bl abort
; CHECK-NEXT:  .LBB12_2: @ %if.else
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    bl exit
entry:
  %load = load i32, ptr @t, align 4
  %sub = sub i32 %load, 17
  %cmp = icmp ult i32 %sub, 0
  br i1 %cmp, label %if.then, label %if.else

if.then:
  call void @abort()
  unreachable

if.else:
  call void @exit(i32 0)
  unreachable
}

