; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -mtriple=r600 -mcpu=redwood < %s | FileCheck -check-prefix=EG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

; Tests whether a load chain of 8 constants gets vectorized into a wider load.
define amdgpu_kernel void @constant_load_v8f32(ptr addrspace(4) noalias nocapture readonly %weights, ptr addrspace(1) noalias nocapture %out_ptr) {
; GFX6-LABEL: constant_load_v8f32:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x9
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s16, s[10:11], 0x0
; GFX6-NEXT:    s_load_dwordx8 s[0:7], s[8:9], 0x0
; GFX6-NEXT:    s_mov_b32 s15, 0xf000
; GFX6-NEXT:    s_mov_b32 s14, -1
; GFX6-NEXT:    s_mov_b32 s12, s10
; GFX6-NEXT:    s_mov_b32 s13, s11
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s16
; GFX6-NEXT:    v_add_f32_e32 v0, s0, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s1, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s3, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s5, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s6, v0
; GFX6-NEXT:    v_add_f32_e32 v0, s7, v0
; GFX6-NEXT:    buffer_store_dword v0, off, s[12:15], 0
; GFX6-NEXT:    s_endpgm
;
; EG-LABEL: constant_load_v8f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 2 @6
; EG-NEXT:    ALU 9, @14, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T2.XYZW, T1.X, 0, #1
; EG-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; EG-NEXT:     VTX_READ_128 T1.XYZW, T1.X, 16, #1
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].Y,
; EG-NEXT:    ALU clause starting at 14:
; EG-NEXT:     ADD * T0.W, T2.X, T0.X,
; EG-NEXT:     ADD * T0.W, T2.Y, PV.W,
; EG-NEXT:     ADD * T0.W, T2.Z, PV.W,
; EG-NEXT:     ADD * T0.W, T2.W, PV.W,
; EG-NEXT:     ADD * T0.W, T1.X, PV.W,
; EG-NEXT:     ADD * T0.W, T1.Y, PV.W,
; EG-NEXT:     ADD * T0.W, T1.Z, PV.W,
; EG-NEXT:     ADD T0.X, T1.W, PV.W,
; EG-NEXT:     LSHR * T1.X, KC0[2].Z, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
;
; GFX12-LABEL: constant_load_v8f32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[8:11], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b32 s12, s[10:11], 0x0
; GFX12-NEXT:    s_load_b256 s[0:7], s[8:9], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_add_f32 s0, s0, s12
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_3) | instskip(NEXT) | instid1(SALU_CYCLE_3)
; GFX12-NEXT:    s_add_f32 s0, s1, s0
; GFX12-NEXT:    s_add_f32 s0, s2, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_3) | instskip(NEXT) | instid1(SALU_CYCLE_3)
; GFX12-NEXT:    s_add_f32 s0, s3, s0
; GFX12-NEXT:    s_add_f32 s0, s4, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_3) | instskip(NEXT) | instid1(SALU_CYCLE_3)
; GFX12-NEXT:    s_add_f32 s0, s5, s0
; GFX12-NEXT:    s_add_f32 s0, s6, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_3) | instskip(NEXT) | instid1(SALU_CYCLE_3)
; GFX12-NEXT:    s_add_f32 s0, s7, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX12-NEXT:    global_store_b32 v0, v1, s[10:11]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %out_ptr.promoted = load float, ptr addrspace(1) %out_ptr, align 4
  %tmp = load float, ptr addrspace(4) %weights, align 4
  %add = fadd float %tmp, %out_ptr.promoted
  %arrayidx.1 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 1
  %tmp1 = load float, ptr addrspace(4) %arrayidx.1, align 4
  %add.1 = fadd float %tmp1, %add
  %arrayidx.2 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 2
  %tmp2 = load float, ptr addrspace(4) %arrayidx.2, align 4
  %add.2 = fadd float %tmp2, %add.1
  %arrayidx.3 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 3
  %tmp3 = load float, ptr addrspace(4) %arrayidx.3, align 4
  %add.3 = fadd float %tmp3, %add.2
  %arrayidx.4 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 4
  %tmp4 = load float, ptr addrspace(4) %arrayidx.4, align 4
  %add.4 = fadd float %tmp4, %add.3
  %arrayidx.5 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 5
  %tmp5 = load float, ptr addrspace(4) %arrayidx.5, align 4
  %add.5 = fadd float %tmp5, %add.4
  %arrayidx.6 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 6
  %tmp6 = load float, ptr addrspace(4) %arrayidx.6, align 4
  %add.6 = fadd float %tmp6, %add.5
  %arrayidx.7 = getelementptr inbounds float, ptr addrspace(4) %weights, i64 7
  %tmp7 = load float, ptr addrspace(4) %arrayidx.7, align 4
  %add.7 = fadd float %tmp7, %add.6
  store float %add.7, ptr addrspace(1) %out_ptr, align 4
  ret void
}
