; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<scalar-evolution>' -scalar-evolution-classify-expressions=0 -disable-output %s 2>&1 | FileCheck %s

; %i and %i + 1 can overflow.
define void @test1(i64 %x, ptr %a, ptr %b) {
; CHECK-LABEL: 'test1'
; CHECK-NEXT:  Determining loop execution counts for: @test1
; CHECK-NEXT:  Loop %header: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for header: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %header: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %header: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:    symbolic max exit count for header: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %header: Predicated symbolic max backedge-taken count is (-1 + (1 umax %x))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%header> Added Flags: <nusw>
;
entry:
  br label %header

header:
  %conv11 = phi i64 [ 0, %entry ], [ %conv, %latch ]
  %i.010 = phi i32 [ 0, %entry ], [ %add, %latch ]
  %add = add i32 %i.010, 1
  %idxprom = zext i32 %add to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %ld = load i32, ptr %arrayidx, align 4
  %uncountable.c = icmp eq i32 %ld, 10
  br i1 %uncountable.c, label %exit, label %latch

latch:
  %add2 = add nsw i32 %ld, 1
  %arrayidx4 = getelementptr inbounds i32, ptr %b, i64 %conv11
  store i32 %add2, ptr %arrayidx4, align 4
  %conv = zext i32 %add to i64
  %cmp = icmp ult i64 %conv, %x
  br i1 %cmp, label %header, label %exit

exit:
  ret void
}

; %i can overflow.
;
; We need to check that i doesn't wrap, but we don't need a run-time alias
; check. We also need an extra no-wrap check to get the backedge taken count.
define void @test2(i64 %x, ptr %a) {
; CHECK-LABEL: 'test2'
; CHECK-NEXT:  Determining loop execution counts for: @test2
; CHECK-NEXT:  Loop %header: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for header: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %header: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %header: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:    symbolic max exit count for header: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for latch: ***COULDNOTCOMPUTE***
; CHECK-NEXT:  Loop %header: Predicated symbolic max backedge-taken count is (-1 + (1 umax %x))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%header> Added Flags: <nusw>
;
entry:
  br label %header

header:
  %conv11 = phi i64 [ 0, %entry ], [ %conv, %latch ]
  %i.010 = phi i32  [ 0, %entry ], [ %inc, %latch ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %conv11
  %ld = load i32, ptr %arrayidx, align 4
  %uncountable.c = icmp eq i32 %ld, 10
  br i1 %uncountable.c, label %exit, label %latch

latch:
  %add = add nsw i32 %ld, 1
  store i32 %add, ptr %arrayidx, align 4
  %inc = add i32 %i.010, 1
  %conv = zext i32 %inc to i64
  %cmp = icmp ult i64 %conv, %x
  br i1 %cmp, label %header, label %exit

exit:
  ret void
}
