; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

; ===== Legal Scalars =====
define void @store_i8(i8 %a, ptr %ptr){
; CHECK-LABEL: store_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    strb w0, [x1]
; CHECK-NEXT:    ret
    store i8 %a, ptr %ptr
    ret void
}

define void @store_i16(i16 %a, ptr %ptr){
; CHECK-LABEL: store_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    strh w0, [x1]
; CHECK-NEXT:    ret
    store i16 %a, ptr %ptr
    ret void
}

define void @store_i32(i32 %a, ptr %ptr){
; CHECK-LABEL: store_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
    store i32 %a, ptr %ptr
    ret void
}

define void @store_i64(i64 %a, ptr %ptr){
; CHECK-LABEL: store_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x0, [x1]
; CHECK-NEXT:    ret
    store i64 %a, ptr %ptr
    ret void
}

; ===== Legal Vector Types =====

define void @store_v8i8(<8 x i8> %a, ptr %ptr){
; CHECK-LABEL: store_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
    store <8 x i8> %a, ptr %ptr
    ret void
}

define void @store_v16i8(<16 x i8> %a, ptr %ptr){
; CHECK-LABEL: store_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
    store <16 x i8> %a, ptr %ptr
    ret void
}

define void @store_v4i16(<4 x i16> %a, ptr %ptr){
; CHECK-LABEL: store_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
    store <4 x i16> %a, ptr %ptr
    ret void
}

define void @store_v8i16(<8 x i16> %a, ptr %ptr){
; CHECK-LABEL: store_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
    store <8 x i16> %a, ptr %ptr
    ret void
}

define void @store_v2i32(<2 x i32> %a, ptr %ptr){
; CHECK-LABEL: store_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
    store <2 x i32> %a, ptr %ptr
    ret void
}

define void @store_v4i32(<4 x i32> %a, ptr %ptr){
; CHECK-LABEL: store_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
    store <4 x i32> %a, ptr %ptr
    ret void
}

define void @store_v2i64(<2 x i64> %a, ptr %ptr){
; CHECK-LABEL: store_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
    store <2 x i64> %a, ptr %ptr
    ret void
}

; ===== Smaller/Larger Width Vectors with Legal Element Sizes =====

define void @store_v2i8(<2 x i8> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v2i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov w8, v0.s[1]
; CHECK-SD-NEXT:    fmov w9, s0
; CHECK-SD-NEXT:    strb w9, [x0]
; CHECK-SD-NEXT:    strb w8, [x0, #1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v2i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str b0, [x0]
; CHECK-GI-NEXT:    str b1, [x0, #1]
; CHECK-GI-NEXT:    ret
    store <2 x i8> %a, ptr %ptr
    ret void
}

define void @store_v4i8(i32 %a, ptr %ptr) {
; CHECK-LABEL: store_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str w0, [x1]
; CHECK-NEXT:    ret
    %c = bitcast i32 %a to <4 x i8>
    store <4 x i8> %c, ptr %ptr
    ret void
}

define void @store_v32i8(<32 x i8> %a, ptr %ptr){
; CHECK-LABEL: store_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
    store <32 x i8> %a, ptr %ptr
    ret void
}

define void @store_v2i16(<2 x i16> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v2i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    mov w8, v0.s[1]
; CHECK-SD-NEXT:    fmov w9, s0
; CHECK-SD-NEXT:    strh w9, [x0]
; CHECK-SD-NEXT:    strh w8, [x0, #2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v2i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    str h1, [x0, #2]
; CHECK-GI-NEXT:    ret
    store <2 x i16> %a, ptr %ptr
    ret void
}

define void @store_v16i16(<16 x i16> %a, ptr %ptr){
; CHECK-LABEL: store_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
    store <16 x i16> %a, ptr %ptr
    ret void
}

define void @store_v1i32(<1 x i32> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v1i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v1i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    str s0, [x0]
; CHECK-GI-NEXT:    ret
    store <1 x i32> %a, ptr %ptr
    ret void
}

define void @store_v8i32(<8 x i32> %a, ptr %ptr){
; CHECK-LABEL: store_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
    store <8 x i32> %a, ptr %ptr
    ret void
}

define void @store_v4i64(<4 x i64> %a, ptr %ptr){
; CHECK-LABEL: store_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
    store <4 x i64> %a, ptr %ptr
    ret void
}

; ===== Vectors with Non-Pow 2 Widths =====

define void @store_v3i8(<3 x i8> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v3i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    xtn v0.8b, v0.8h
; CHECK-SD-NEXT:    str s0, [sp, #12]
; CHECK-SD-NEXT:    ldrh w8, [sp, #12]
; CHECK-SD-NEXT:    strb w2, [x3, #2]
; CHECK-SD-NEXT:    strh w8, [x3]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v3i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    strb w0, [x3]
; CHECK-GI-NEXT:    strb w1, [x3, #1]
; CHECK-GI-NEXT:    strb w2, [x3, #2]
; CHECK-GI-NEXT:    ret
    store <3 x i8> %a, ptr %ptr
    ret void
}

define void @store_v7i8(<7 x i8> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v7i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add x8, x0, #6
; CHECK-SD-NEXT:    add x9, x0, #4
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    st1 { v0.b }[6], [x8]
; CHECK-SD-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v7i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add x8, x0, #1
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    add x9, x0, #2
; CHECK-GI-NEXT:    st1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    st1 { v0.b }[1], [x8]
; CHECK-GI-NEXT:    add x8, x0, #3
; CHECK-GI-NEXT:    st1 { v0.b }[3], [x8]
; CHECK-GI-NEXT:    add x8, x0, #4
; CHECK-GI-NEXT:    st1 { v0.b }[4], [x8]
; CHECK-GI-NEXT:    add x8, x0, #5
; CHECK-GI-NEXT:    st1 { v0.b }[5], [x8]
; CHECK-GI-NEXT:    add x8, x0, #6
; CHECK-GI-NEXT:    st1 { v0.b }[2], [x9]
; CHECK-GI-NEXT:    st1 { v0.b }[6], [x8]
; CHECK-GI-NEXT:    ret
    store <7 x i8> %a, ptr %ptr
    ret void
}

define void @store_v3i16(<3 x i16> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v3i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add x8, x0, #4
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    st1 { v0.h }[2], [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v3i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    ret
    store <3 x i16> %a, ptr %ptr
    ret void
}

define void @store_v7i16(<7 x i16> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v7i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add x8, x0, #12
; CHECK-SD-NEXT:    add x9, x0, #8
; CHECK-SD-NEXT:    str d0, [x0]
; CHECK-SD-NEXT:    st1 { v0.h }[6], [x8]
; CHECK-SD-NEXT:    st1 { v0.s }[2], [x9]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v7i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    add x8, x0, #6
; CHECK-GI-NEXT:    st1 { v0.h }[3], [x8]
; CHECK-GI-NEXT:    add x8, x0, #8
; CHECK-GI-NEXT:    st1 { v0.h }[4], [x8]
; CHECK-GI-NEXT:    add x8, x0, #10
; CHECK-GI-NEXT:    st1 { v0.h }[5], [x8]
; CHECK-GI-NEXT:    add x8, x0, #12
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    st1 { v0.h }[6], [x8]
; CHECK-GI-NEXT:    ret
    store <7 x i16> %a, ptr %ptr
    ret void
}

define void @store_v3i32(<3 x i32> %a, ptr %ptr){
; CHECK-SD-LABEL: store_v3i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add x8, x0, #8
; CHECK-SD-NEXT:    str d0, [x0]
; CHECK-SD-NEXT:    st1 { v0.s }[2], [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: store_v3i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add x8, x0, #4
; CHECK-GI-NEXT:    add x9, x0, #8
; CHECK-GI-NEXT:    str s0, [x0]
; CHECK-GI-NEXT:    st1 { v0.s }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.s }[2], [x9]
; CHECK-GI-NEXT:    ret
    store <3 x i32> %a, ptr %ptr
    ret void
}
