; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple powerpc-ibm-aix-xcoff -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK
; RUN: llc -mtriple powerpc64-ibm-aix-xcoff -verify-machineinstrs < %s | FileCheck %s --check-prefix=CHECK-64

; RUN: llc -filetype=obj -mtriple powerpc-ibm-aix-xcoff -verify-machineinstrs < %s -o %t32.o
; RUN: llvm-objdump -t --symbol-description %t32.o | FileCheck %s --check-prefix=OBJ32

; RUN: llc -filetype=obj -mtriple powerpc64-ibm-aix-xcoff -verify-machineinstrs < %s -o %t64.o
; RUN: llvm-objdump -t --symbol-description %t64.o | FileCheck %s --check-prefix=OBJ64

@a1 = common global i32 0, align 4 #0
@a2 = global i32 0, align 4 #0
@a3 = common global i32 0, align 4
@a4 = global i32 0, align 4

define void @set(i32 noundef %_a) {
; CHECK-LABEL: set:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    la 4, a2[TD](2)
; CHECK-NEXT:    lwz 5, L..C0(2) # @a4
; CHECK-NEXT:    stw 3, 0(4)
; CHECK-NEXT:    la 4, a1[TD](2)
; CHECK-NEXT:    stw 3, 0(4)
; CHECK-NEXT:    lwz 4, L..C1(2) # @a3
; CHECK-NEXT:    stw 3, 0(5)
; CHECK-NEXT:    stw 3, 0(4)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: set:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    la 4, a2[TD](2)
; CHECK-64-NEXT:    ld 5, L..C0(2) # @a4
; CHECK-64-NEXT:    stw 3, 0(4)
; CHECK-64-NEXT:    la 4, a1[TD](2)
; CHECK-64-NEXT:    stw 3, 0(4)
; CHECK-64-NEXT:    ld 4, L..C1(2) # @a3
; CHECK-64-NEXT:    stw 3, 0(5)
; CHECK-64-NEXT:    stw 3, 0(4)
; CHECK-64-NEXT:    blr
entry:
store i32 %_a, ptr @a2, align 4
store i32 %_a, ptr @a1, align 4
store i32 %_a, ptr @a4, align 4
store i32 %_a, ptr @a3, align 4
ret void
}

define i32 @get1() {
; CHECK-LABEL: get1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    la 3, a2[TD](2)
; CHECK-NEXT:    lwz 3, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: get1:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    la 3, a2[TD](2)
; CHECK-64-NEXT:    lwz 3, 0(3)
; CHECK-64-NEXT:    blr
entry:
%0 = load i32, ptr @a2, align 4
ret i32 %0
}

define i32 @get2() {
; CHECK-LABEL: get2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    la 3, a1[TD](2)
; CHECK-NEXT:    lwz 3, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: get2:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    la 3, a1[TD](2)
; CHECK-64-NEXT:    lwz 3, 0(3)
; CHECK-64-NEXT:    blr
entry:
%0 = load i32, ptr @a1, align 4
ret i32 %0
}

define i32 @get3() {
; CHECK-LABEL: get3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C0(2) # @a4
; CHECK-NEXT:    lwz 3, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: get3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C0(2) # @a4
; CHECK-64-NEXT:    lwz 3, 0(3)
; CHECK-64-NEXT:    blr
entry:
%0 = load i32, ptr @a4, align 4
ret i32 %0
}

define i32 @get4() {
; CHECK-LABEL: get4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C1(2) # @a3
; CHECK-NEXT:    lwz 3, 0(3)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: get4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C1(2) # @a3
; CHECK-64-NEXT:    lwz 3, 0(3)
; CHECK-64-NEXT:    blr
entry:
%0 = load i32, ptr @a3, align 4
ret i32 %0
}

define nonnull ptr @escape1() {
; CHECK-LABEL: escape1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    la 3, a2[TD](2)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: escape1:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    la 3, a2[TD](2)
; CHECK-64-NEXT:    blr
entry:
ret ptr @a2
}

define nonnull ptr @escape2() {
; CHECK-LABEL: escape2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    la 3, a1[TD](2)
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: escape2:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    la 3, a1[TD](2)
; CHECK-64-NEXT:    blr
entry:
ret ptr @a1
}

define nonnull ptr @escape3() {
; CHECK-LABEL: escape3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C0(2) # @a4
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: escape3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C0(2) # @a4
; CHECK-64-NEXT:    blr
entry:
ret ptr @a4
}

define nonnull ptr @escape4() {
; CHECK-LABEL: escape4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C1(2) # @a3
; CHECK-NEXT:    blr
;
; CHECK-64-LABEL: escape4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    ld 3, L..C1(2) # @a3
; CHECK-64-NEXT:    blr
entry:
ret ptr @a3
}

attributes #0 = { "toc-data" }

; CHECK: .comm a3[RW],4,2 # @a3
; CHECK-NEXT: .csect a4[RW],2
; CHECK-NEXT: .globl a4[RW] # @a4
; CHECK-NEXT: .align 2
; CHECK-NEXT: .vbyte 4, 0 # 0x0
; CHECK-NEXT: .toc
; CHECK-LABEL: L..C0:
; CHECK-NEXT: .tc a4[TC],a4[RW]
; CHECK-LABEL: L..C1:
; CHECK-NEXT: .tc a3[TC],a3[RW]
; CHECK-NEXT: .csect a2[TD],2
; CHECK-NEXT: .globl a2[TD] # @a2
; CHECK-NEXT: .align 2
; CHECK-NEXT: .vbyte 4, 0 # 0x0
; CHECK-NEXT: .comm a1[TD],4,2 # @a1

; OBJ32:       {{([[:xdigit:]]{8})}} g     O .data  00000004 (idx: {{[0-9]+}}) a4[RW]
; OBJ32-LABEL: {{([[:xdigit:]]{8})}} l       .data  00000000 (idx: {{[0-9]+}}) TOC[TC0]
; OBJ32-NEXT:  {{([[:xdigit:]]{8})}} l     O .data  00000004 (idx: {{[0-9]+}}) a4[TC]
; OBJ32-NEXT:  {{([[:xdigit:]]{8})}} l     O .data  00000004 (idx: {{[0-9]+}}) a3[TC]
; OBJ32-NEXT:  {{([[:xdigit:]]{8})}} g     O .data  00000004 (idx: {{[0-9]+}}) a2[TD]
; OBJ32-NEXT:  {{([[:xdigit:]]{8})}} g     O *COM*  00000004 (idx: {{[0-9]+}}) a1[TD]
; OBJ32-NEXT:  {{([[:xdigit:]]{8})}} g     O *COM*  00000004 (idx: {{[0-9]+}}) a3[RW]

; OBJ64:       {{([[:xdigit:]]{16})}} g     O .data  0000000000000004 (idx: {{[0-9]+}}) a4[RW]
; OBJ64-LABEL: {{([[:xdigit:]]{16})}} l       .data  0000000000000000 (idx: {{[0-9]+}}) TOC[TC0]
; OBJ64-NEXT:  {{([[:xdigit:]]{16})}} l     O .data  0000000000000008 (idx: {{[0-9]+}}) a4[TC]
; OBJ64-NEXT:  {{([[:xdigit:]]{16})}} l     O .data  0000000000000008 (idx: {{[0-9]+}}) a3[TC]
; OBJ64-NEXT:  {{([[:xdigit:]]{16})}} g     O .data  0000000000000004 (idx: {{[0-9]+}}) a2[TD]
; OBJ64-NEXT:  {{([[:xdigit:]]{16})}} g     O *COM*  0000000000000004 (idx: {{[0-9]+}}) a1[TD]
; OBJ64-NEXT:  {{([[:xdigit:]]{16})}} g     O *COM*  0000000000000004 (idx: {{[0-9]+}}) a3[RW]
