; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign -verify-machineinstrs < %s | FileCheck --check-prefixes=SI %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=VI-FLUSH %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math=ieee -denormal-fp-math-f32=preserve-sign -verify-machineinstrs < %s | FileCheck --check-prefixes=SI %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=ieee -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=VI-DENORM %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX10-FLUSH %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX10-DENORM %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=preserve-sign -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX11-FLUSH %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1100 -denormal-fp-math=ieee -denormal-fp-math-f32=preserve-sign -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX11-DENORM %s

declare half @llvm.fmuladd.f16(half %a, half %b, half %c)
declare <2 x half> @llvm.fmuladd.v2f16(<2 x half> %a, <2 x half> %b, <2 x half> %c)

define amdgpu_kernel void @fmuladd_f16(
; SI-LABEL: fmuladd_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s7
; SI-NEXT:    s_mov_b32 s6, s10
; SI-NEXT:    s_mov_b32 s7, s11
; SI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0
; SI-NEXT:    buffer_load_ushort v1, off, s[16:19], 0
; SI-NEXT:    buffer_load_ushort v2, off, s[4:7], 0
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SI-NEXT:    buffer_store_short v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: fmuladd_f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-FLUSH-NEXT:    s_mov_b32 s11, 0xf000
; VI-FLUSH-NEXT:    s_mov_b32 s10, -1
; VI-FLUSH-NEXT:    s_mov_b32 s14, s10
; VI-FLUSH-NEXT:    s_mov_b32 s15, s11
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s12, s2
; VI-FLUSH-NEXT:    s_mov_b32 s13, s3
; VI-FLUSH-NEXT:    s_mov_b32 s16, s4
; VI-FLUSH-NEXT:    s_mov_b32 s17, s5
; VI-FLUSH-NEXT:    s_mov_b32 s18, s10
; VI-FLUSH-NEXT:    s_mov_b32 s19, s11
; VI-FLUSH-NEXT:    s_mov_b32 s4, s6
; VI-FLUSH-NEXT:    s_mov_b32 s5, s7
; VI-FLUSH-NEXT:    s_mov_b32 s6, s10
; VI-FLUSH-NEXT:    s_mov_b32 s7, s11
; VI-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0
; VI-FLUSH-NEXT:    buffer_load_ushort v1, off, s[16:19], 0
; VI-FLUSH-NEXT:    buffer_load_ushort v2, off, s[4:7], 0
; VI-FLUSH-NEXT:    s_mov_b32 s8, s0
; VI-FLUSH-NEXT:    s_mov_b32 s9, s1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_e32 v2, v0, v1
; VI-FLUSH-NEXT:    buffer_store_short v2, off, s[8:11], 0
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-DENORM-NEXT:    s_mov_b32 s11, 0xf000
; VI-DENORM-NEXT:    s_mov_b32 s10, -1
; VI-DENORM-NEXT:    s_mov_b32 s14, s10
; VI-DENORM-NEXT:    s_mov_b32 s15, s11
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s12, s2
; VI-DENORM-NEXT:    s_mov_b32 s13, s3
; VI-DENORM-NEXT:    s_mov_b32 s16, s4
; VI-DENORM-NEXT:    s_mov_b32 s17, s5
; VI-DENORM-NEXT:    s_mov_b32 s18, s10
; VI-DENORM-NEXT:    s_mov_b32 s19, s11
; VI-DENORM-NEXT:    s_mov_b32 s4, s6
; VI-DENORM-NEXT:    s_mov_b32 s5, s7
; VI-DENORM-NEXT:    s_mov_b32 s6, s10
; VI-DENORM-NEXT:    s_mov_b32 s7, s11
; VI-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0
; VI-DENORM-NEXT:    buffer_load_ushort v1, off, s[16:19], 0
; VI-DENORM-NEXT:    buffer_load_ushort v2, off, s[4:7], 0
; VI-DENORM-NEXT:    s_mov_b32 s8, s0
; VI-DENORM-NEXT:    s_mov_b32 s9, s1
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_fma_f16 v0, v0, v1, v2
; VI-DENORM-NEXT:    buffer_store_short v0, off, s[8:11], 0
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX10-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX10-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX10-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX10-FLUSH-NEXT:    s_mov_b32 s18, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s19, s11
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s12, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s13, s3
; GFX10-FLUSH-NEXT:    s_mov_b32 s16, s4
; GFX10-FLUSH-NEXT:    s_mov_b32 s17, s5
; GFX10-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0
; GFX10-FLUSH-NEXT:    buffer_load_ushort v1, off, s[16:19], 0
; GFX10-FLUSH-NEXT:    s_mov_b32 s4, s6
; GFX10-FLUSH-NEXT:    s_mov_b32 s5, s7
; GFX10-FLUSH-NEXT:    s_mov_b32 s6, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s7, s11
; GFX10-FLUSH-NEXT:    s_mov_b32 s8, s0
; GFX10-FLUSH-NEXT:    buffer_load_ushort v2, off, s[4:7], 0
; GFX10-FLUSH-NEXT:    s_mov_b32 s9, s1
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX10-FLUSH-NEXT:    buffer_store_short v0, off, s[8:11], 0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX10-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX10-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX10-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX10-DENORM-NEXT:    s_mov_b32 s18, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s19, s11
; GFX10-DENORM-NEXT:    s_mov_b32 s22, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s23, s11
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s12, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s13, s3
; GFX10-DENORM-NEXT:    s_mov_b32 s16, s4
; GFX10-DENORM-NEXT:    s_mov_b32 s17, s5
; GFX10-DENORM-NEXT:    s_mov_b32 s20, s6
; GFX10-DENORM-NEXT:    s_mov_b32 s21, s7
; GFX10-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0
; GFX10-DENORM-NEXT:    buffer_load_ushort v1, off, s[16:19], 0
; GFX10-DENORM-NEXT:    buffer_load_ushort v2, off, s[20:23], 0
; GFX10-DENORM-NEXT:    s_mov_b32 s8, s0
; GFX10-DENORM-NEXT:    s_mov_b32 s9, s1
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX10-DENORM-NEXT:    buffer_store_short v2, off, s[8:11], 0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX11-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX11-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s18, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s19, s11
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s12, s2
; GFX11-FLUSH-NEXT:    s_mov_b32 s13, s3
; GFX11-FLUSH-NEXT:    s_mov_b32 s16, s4
; GFX11-FLUSH-NEXT:    s_mov_b32 s17, s5
; GFX11-FLUSH-NEXT:    buffer_load_u16 v0, off, s[12:15], 0
; GFX11-FLUSH-NEXT:    buffer_load_u16 v1, off, s[16:19], 0
; GFX11-FLUSH-NEXT:    s_mov_b32 s4, s6
; GFX11-FLUSH-NEXT:    s_mov_b32 s5, s7
; GFX11-FLUSH-NEXT:    s_mov_b32 s6, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s7, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s8, s0
; GFX11-FLUSH-NEXT:    buffer_load_u16 v2, off, s[4:7], 0
; GFX11-FLUSH-NEXT:    s_mov_b32 s9, s1
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-FLUSH-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX11-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX11-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s18, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s19, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s22, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s23, s11
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s12, s2
; GFX11-DENORM-NEXT:    s_mov_b32 s13, s3
; GFX11-DENORM-NEXT:    s_mov_b32 s16, s4
; GFX11-DENORM-NEXT:    s_mov_b32 s17, s5
; GFX11-DENORM-NEXT:    s_mov_b32 s20, s6
; GFX11-DENORM-NEXT:    s_mov_b32 s21, s7
; GFX11-DENORM-NEXT:    buffer_load_u16 v0, off, s[12:15], 0
; GFX11-DENORM-NEXT:    buffer_load_u16 v1, off, s[16:19], 0
; GFX11-DENORM-NEXT:    buffer_load_u16 v2, off, s[20:23], 0
; GFX11-DENORM-NEXT:    s_mov_b32 s8, s0
; GFX11-DENORM-NEXT:    s_mov_b32 s9, s1
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v2, v0, v1
; GFX11-DENORM-NEXT:    buffer_store_b16 v2, off, s[8:11], 0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a,
    ptr addrspace(1) %b,
    ptr addrspace(1) %c) {
  %a.val = load half, ptr addrspace(1) %a
  %b.val = load half, ptr addrspace(1) %b
  %c.val = load half, ptr addrspace(1) %c
  %r.val = call half @llvm.fmuladd.f16(half %a.val, half %b.val, half %c.val)
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fmuladd_f16_imm_a(
; SI-LABEL: fmuladd_f16_imm_a:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s14, s2
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s6
; SI-NEXT:    s_mov_b32 s13, s7
; SI-NEXT:    s_mov_b32 s15, s3
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_madmk_f32 v0, v0, 0x40400000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: fmuladd_f16_imm_a:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-FLUSH-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-FLUSH-NEXT:    s_mov_b32 s3, 0xf000
; VI-FLUSH-NEXT:    s_mov_b32 s2, -1
; VI-FLUSH-NEXT:    s_mov_b32 s14, s2
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s12, s6
; VI-FLUSH-NEXT:    s_mov_b32 s13, s7
; VI-FLUSH-NEXT:    s_mov_b32 s15, s3
; VI-FLUSH-NEXT:    s_mov_b32 s10, s2
; VI-FLUSH-NEXT:    s_mov_b32 s11, s3
; VI-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s0, s4
; VI-FLUSH-NEXT:    s_mov_b32 s1, s5
; VI-FLUSH-NEXT:    v_madmk_f16 v0, v0, 0x4200, v1
; VI-FLUSH-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_f16_imm_a:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-DENORM-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-DENORM-NEXT:    s_mov_b32 s3, 0xf000
; VI-DENORM-NEXT:    s_mov_b32 s2, -1
; VI-DENORM-NEXT:    s_mov_b32 s14, s2
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s12, s6
; VI-DENORM-NEXT:    s_mov_b32 s13, s7
; VI-DENORM-NEXT:    s_mov_b32 s15, s3
; VI-DENORM-NEXT:    s_mov_b32 s10, s2
; VI-DENORM-NEXT:    s_mov_b32 s11, s3
; VI-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s0, s4
; VI-DENORM-NEXT:    s_movk_i32 s4, 0x4200
; VI-DENORM-NEXT:    s_mov_b32 s1, s5
; VI-DENORM-NEXT:    v_fma_f16 v0, v0, s4, v1
; VI-DENORM-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_f16_imm_a:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_clause 0x1
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; GFX10-FLUSH-NEXT:    s_mov_b32 s2, -1
; GFX10-FLUSH-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-FLUSH-NEXT:    s_mov_b32 s14, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s15, s3
; GFX10-FLUSH-NEXT:    s_mov_b32 s10, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s11, s3
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s12, s6
; GFX10-FLUSH-NEXT:    s_mov_b32 s13, s7
; GFX10-FLUSH-NEXT:    s_mov_b32 s0, s4
; GFX10-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s1, s5
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v0, 0x4200, v0
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_f16_imm_a:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_clause 0x1
; GFX10-DENORM-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; GFX10-DENORM-NEXT:    s_mov_b32 s2, -1
; GFX10-DENORM-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-DENORM-NEXT:    s_mov_b32 s14, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s15, s3
; GFX10-DENORM-NEXT:    s_mov_b32 s10, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s11, s3
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s12, s6
; GFX10-DENORM-NEXT:    s_mov_b32 s13, s7
; GFX10-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s0, s4
; GFX10-DENORM-NEXT:    s_mov_b32 s1, s5
; GFX10-DENORM-NEXT:    v_fmamk_f16 v0, v0, 0x4200, v1
; GFX10-DENORM-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_f16_imm_a:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_clause 0x1
; GFX11-FLUSH-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX11-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s2, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s3, s11
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s12, s6
; GFX11-FLUSH-NEXT:    s_mov_b32 s13, s7
; GFX11-FLUSH-NEXT:    s_mov_b32 s8, s4
; GFX11-FLUSH-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s9, s5
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v0, 0x4200, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-FLUSH-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_f16_imm_a:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_clause 0x1
; GFX11-DENORM-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX11-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s2, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s3, s11
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s12, s6
; GFX11-DENORM-NEXT:    s_mov_b32 s13, s7
; GFX11-DENORM-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s8, s4
; GFX11-DENORM-NEXT:    s_mov_b32 s9, s5
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v1, 0x4200, v0
; GFX11-DENORM-NEXT:    buffer_store_b16 v1, off, s[8:11], 0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %b,
    ptr addrspace(1) %c) {
  %b.val = load volatile half, ptr addrspace(1) %b
  %c.val = load volatile half, ptr addrspace(1) %c
  %r.val = call half @llvm.fmuladd.f16(half 3.0, half %b.val, half %c.val)
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fmuladd_f16_imm_b(
; SI-LABEL: fmuladd_f16_imm_b:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_mov_b32 s14, s2
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s6
; SI-NEXT:    s_mov_b32 s13, s7
; SI-NEXT:    s_mov_b32 s15, s3
; SI-NEXT:    s_mov_b32 s10, s2
; SI-NEXT:    s_mov_b32 s11, s3
; SI-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s0, s4
; SI-NEXT:    s_mov_b32 s1, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_madmk_f32 v0, v0, 0x40400000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: fmuladd_f16_imm_b:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-FLUSH-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-FLUSH-NEXT:    s_mov_b32 s3, 0xf000
; VI-FLUSH-NEXT:    s_mov_b32 s2, -1
; VI-FLUSH-NEXT:    s_mov_b32 s14, s2
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s12, s6
; VI-FLUSH-NEXT:    s_mov_b32 s13, s7
; VI-FLUSH-NEXT:    s_mov_b32 s15, s3
; VI-FLUSH-NEXT:    s_mov_b32 s10, s2
; VI-FLUSH-NEXT:    s_mov_b32 s11, s3
; VI-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s0, s4
; VI-FLUSH-NEXT:    s_mov_b32 s1, s5
; VI-FLUSH-NEXT:    v_madmk_f16 v0, v0, 0x4200, v1
; VI-FLUSH-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_f16_imm_b:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-DENORM-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; VI-DENORM-NEXT:    s_mov_b32 s3, 0xf000
; VI-DENORM-NEXT:    s_mov_b32 s2, -1
; VI-DENORM-NEXT:    s_mov_b32 s14, s2
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s12, s6
; VI-DENORM-NEXT:    s_mov_b32 s13, s7
; VI-DENORM-NEXT:    s_mov_b32 s15, s3
; VI-DENORM-NEXT:    s_mov_b32 s10, s2
; VI-DENORM-NEXT:    s_mov_b32 s11, s3
; VI-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s0, s4
; VI-DENORM-NEXT:    s_movk_i32 s4, 0x4200
; VI-DENORM-NEXT:    s_mov_b32 s1, s5
; VI-DENORM-NEXT:    v_fma_f16 v0, v0, s4, v1
; VI-DENORM-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_f16_imm_b:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_clause 0x1
; GFX10-FLUSH-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-FLUSH-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; GFX10-FLUSH-NEXT:    s_mov_b32 s2, -1
; GFX10-FLUSH-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-FLUSH-NEXT:    s_mov_b32 s14, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s15, s3
; GFX10-FLUSH-NEXT:    s_mov_b32 s10, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s11, s3
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s12, s6
; GFX10-FLUSH-NEXT:    s_mov_b32 s13, s7
; GFX10-FLUSH-NEXT:    s_mov_b32 s0, s4
; GFX10-FLUSH-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc dlc
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s1, s5
; GFX10-FLUSH-NEXT:    v_mul_f16_e32 v0, 0x4200, v0
; GFX10-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_f16_imm_b:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_clause 0x1
; GFX10-DENORM-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DENORM-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x34
; GFX10-DENORM-NEXT:    s_mov_b32 s2, -1
; GFX10-DENORM-NEXT:    s_mov_b32 s3, 0x31016000
; GFX10-DENORM-NEXT:    s_mov_b32 s14, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s15, s3
; GFX10-DENORM-NEXT:    s_mov_b32 s10, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s11, s3
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s12, s6
; GFX10-DENORM-NEXT:    s_mov_b32 s13, s7
; GFX10-DENORM-NEXT:    buffer_load_ushort v0, off, s[12:15], 0 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    buffer_load_ushort v1, off, s[8:11], 0 glc dlc
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s0, s4
; GFX10-DENORM-NEXT:    s_mov_b32 s1, s5
; GFX10-DENORM-NEXT:    v_fmamk_f16 v0, v0, 0x4200, v1
; GFX10-DENORM-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_f16_imm_b:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_clause 0x1
; GFX11-FLUSH-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-FLUSH-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX11-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s2, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s3, s11
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s12, s6
; GFX11-FLUSH-NEXT:    s_mov_b32 s13, s7
; GFX11-FLUSH-NEXT:    s_mov_b32 s8, s4
; GFX11-FLUSH-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s9, s5
; GFX11-FLUSH-NEXT:    v_mul_f16_e32 v0, 0x4200, v0
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-FLUSH-NEXT:    buffer_store_b16 v0, off, s[8:11], 0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_f16_imm_b:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_clause 0x1
; GFX11-DENORM-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-DENORM-NEXT:    s_load_b64 s[0:1], s[0:1], 0x34
; GFX11-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX11-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s2, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s3, s11
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s12, s6
; GFX11-DENORM-NEXT:    s_mov_b32 s13, s7
; GFX11-DENORM-NEXT:    buffer_load_u16 v0, off, s[12:15], 0 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    buffer_load_u16 v1, off, s[0:3], 0 glc dlc
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s8, s4
; GFX11-DENORM-NEXT:    s_mov_b32 s9, s5
; GFX11-DENORM-NEXT:    v_fmac_f16_e32 v1, 0x4200, v0
; GFX11-DENORM-NEXT:    buffer_store_b16 v1, off, s[8:11], 0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a,
    ptr addrspace(1) %c) {
  %a.val = load volatile half, ptr addrspace(1) %a
  %c.val = load volatile half, ptr addrspace(1) %c
  %r.val = call half @llvm.fmuladd.f16(half %a.val, half 3.0, half %c.val)
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fmuladd_v2f16(
; SI-LABEL: fmuladd_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s11, 0xf000
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s14, s10
; SI-NEXT:    s_mov_b32 s15, s11
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s16, s4
; SI-NEXT:    s_mov_b32 s17, s5
; SI-NEXT:    s_mov_b32 s18, s10
; SI-NEXT:    s_mov_b32 s19, s11
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s7
; SI-NEXT:    s_mov_b32 s6, s10
; SI-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s7, s11
; SI-NEXT:    buffer_load_dword v1, off, s[16:19], 0
; SI-NEXT:    buffer_load_dword v2, off, s[4:7], 0
; SI-NEXT:    s_mov_b32 s8, s0
; SI-NEXT:    s_mov_b32 s9, s1
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_mac_f32_e32 v5, v0, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v5
; SI-NEXT:    v_mac_f32_e32 v2, v3, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; SI-NEXT:    s_endpgm
;
; VI-FLUSH-LABEL: fmuladd_v2f16:
; VI-FLUSH:       ; %bb.0:
; VI-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-FLUSH-NEXT:    s_mov_b32 s11, 0xf000
; VI-FLUSH-NEXT:    s_mov_b32 s10, -1
; VI-FLUSH-NEXT:    s_mov_b32 s14, s10
; VI-FLUSH-NEXT:    s_mov_b32 s15, s11
; VI-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; VI-FLUSH-NEXT:    s_mov_b32 s12, s2
; VI-FLUSH-NEXT:    s_mov_b32 s13, s3
; VI-FLUSH-NEXT:    s_mov_b32 s16, s4
; VI-FLUSH-NEXT:    s_mov_b32 s17, s5
; VI-FLUSH-NEXT:    s_mov_b32 s18, s10
; VI-FLUSH-NEXT:    s_mov_b32 s19, s11
; VI-FLUSH-NEXT:    s_mov_b32 s4, s6
; VI-FLUSH-NEXT:    s_mov_b32 s5, s7
; VI-FLUSH-NEXT:    s_mov_b32 s6, s10
; VI-FLUSH-NEXT:    s_mov_b32 s7, s11
; VI-FLUSH-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; VI-FLUSH-NEXT:    buffer_load_dword v1, off, s[4:7], 0
; VI-FLUSH-NEXT:    buffer_load_dword v2, off, s[16:19], 0
; VI-FLUSH-NEXT:    s_mov_b32 s8, s0
; VI-FLUSH-NEXT:    s_mov_b32 s9, s1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; VI-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; VI-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; VI-FLUSH-NEXT:    v_mac_f16_sdwa v3, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; VI-FLUSH-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; VI-FLUSH-NEXT:    v_mac_f16_e32 v1, v0, v2
; VI-FLUSH-NEXT:    v_or_b32_e32 v0, v1, v3
; VI-FLUSH-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; VI-FLUSH-NEXT:    s_endpgm
;
; VI-DENORM-LABEL: fmuladd_v2f16:
; VI-DENORM:       ; %bb.0:
; VI-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; VI-DENORM-NEXT:    s_mov_b32 s11, 0xf000
; VI-DENORM-NEXT:    s_mov_b32 s10, -1
; VI-DENORM-NEXT:    s_mov_b32 s14, s10
; VI-DENORM-NEXT:    s_mov_b32 s15, s11
; VI-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; VI-DENORM-NEXT:    s_mov_b32 s16, s4
; VI-DENORM-NEXT:    s_mov_b32 s17, s5
; VI-DENORM-NEXT:    s_mov_b32 s4, s6
; VI-DENORM-NEXT:    s_mov_b32 s5, s7
; VI-DENORM-NEXT:    s_mov_b32 s6, s10
; VI-DENORM-NEXT:    s_mov_b32 s7, s11
; VI-DENORM-NEXT:    s_mov_b32 s12, s2
; VI-DENORM-NEXT:    s_mov_b32 s13, s3
; VI-DENORM-NEXT:    s_mov_b32 s18, s10
; VI-DENORM-NEXT:    s_mov_b32 s19, s11
; VI-DENORM-NEXT:    buffer_load_dword v0, off, s[4:7], 0
; VI-DENORM-NEXT:    buffer_load_dword v1, off, s[16:19], 0
; VI-DENORM-NEXT:    buffer_load_dword v2, off, s[12:15], 0
; VI-DENORM-NEXT:    s_mov_b32 s8, s0
; VI-DENORM-NEXT:    s_mov_b32 s9, s1
; VI-DENORM-NEXT:    s_waitcnt vmcnt(2)
; VI-DENORM-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; VI-DENORM-NEXT:    s_waitcnt vmcnt(1)
; VI-DENORM-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; VI-DENORM-NEXT:    s_waitcnt vmcnt(0)
; VI-DENORM-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; VI-DENORM-NEXT:    v_fma_f16 v3, v5, v4, v3
; VI-DENORM-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; VI-DENORM-NEXT:    v_fma_f16 v0, v2, v1, v0
; VI-DENORM-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-DENORM-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; VI-DENORM-NEXT:    s_endpgm
;
; GFX10-FLUSH-LABEL: fmuladd_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX10-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX10-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX10-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX10-FLUSH-NEXT:    s_mov_b32 s18, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s19, s11
; GFX10-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-FLUSH-NEXT:    s_mov_b32 s12, s2
; GFX10-FLUSH-NEXT:    s_mov_b32 s13, s3
; GFX10-FLUSH-NEXT:    s_mov_b32 s16, s4
; GFX10-FLUSH-NEXT:    s_mov_b32 s17, s5
; GFX10-FLUSH-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; GFX10-FLUSH-NEXT:    buffer_load_dword v1, off, s[16:19], 0
; GFX10-FLUSH-NEXT:    s_mov_b32 s4, s6
; GFX10-FLUSH-NEXT:    s_mov_b32 s5, s7
; GFX10-FLUSH-NEXT:    s_mov_b32 s6, s10
; GFX10-FLUSH-NEXT:    s_mov_b32 s7, s11
; GFX10-FLUSH-NEXT:    s_mov_b32 s8, s0
; GFX10-FLUSH-NEXT:    buffer_load_dword v2, off, s[4:7], 0
; GFX10-FLUSH-NEXT:    s_mov_b32 s9, s1
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX10-FLUSH-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX10-FLUSH-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX10-FLUSH-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX10-FLUSH-NEXT:    s_endpgm
;
; GFX10-DENORM-LABEL: fmuladd_v2f16:
; GFX10-DENORM:       ; %bb.0:
; GFX10-DENORM-NEXT:    s_load_dwordx8 s[0:7], s[0:1], 0x24
; GFX10-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX10-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX10-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX10-DENORM-NEXT:    s_mov_b32 s18, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s19, s11
; GFX10-DENORM-NEXT:    s_mov_b32 s22, s10
; GFX10-DENORM-NEXT:    s_mov_b32 s23, s11
; GFX10-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DENORM-NEXT:    s_mov_b32 s12, s2
; GFX10-DENORM-NEXT:    s_mov_b32 s13, s3
; GFX10-DENORM-NEXT:    s_mov_b32 s16, s4
; GFX10-DENORM-NEXT:    s_mov_b32 s17, s5
; GFX10-DENORM-NEXT:    s_mov_b32 s20, s6
; GFX10-DENORM-NEXT:    s_mov_b32 s21, s7
; GFX10-DENORM-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; GFX10-DENORM-NEXT:    buffer_load_dword v1, off, s[16:19], 0
; GFX10-DENORM-NEXT:    buffer_load_dword v2, off, s[20:23], 0
; GFX10-DENORM-NEXT:    s_mov_b32 s8, s0
; GFX10-DENORM-NEXT:    s_mov_b32 s9, s1
; GFX10-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DENORM-NEXT:    v_pk_fma_f16 v0, v0, v1, v2
; GFX10-DENORM-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX10-DENORM-NEXT:    s_endpgm
;
; GFX11-FLUSH-LABEL: fmuladd_v2f16:
; GFX11-FLUSH:       ; %bb.0:
; GFX11-FLUSH-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX11-FLUSH-NEXT:    s_mov_b32 s10, -1
; GFX11-FLUSH-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-FLUSH-NEXT:    s_mov_b32 s14, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s15, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s18, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s19, s11
; GFX11-FLUSH-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FLUSH-NEXT:    s_mov_b32 s12, s2
; GFX11-FLUSH-NEXT:    s_mov_b32 s13, s3
; GFX11-FLUSH-NEXT:    s_mov_b32 s16, s4
; GFX11-FLUSH-NEXT:    s_mov_b32 s17, s5
; GFX11-FLUSH-NEXT:    buffer_load_b32 v0, off, s[12:15], 0
; GFX11-FLUSH-NEXT:    buffer_load_b32 v1, off, s[16:19], 0
; GFX11-FLUSH-NEXT:    s_mov_b32 s4, s6
; GFX11-FLUSH-NEXT:    s_mov_b32 s5, s7
; GFX11-FLUSH-NEXT:    s_mov_b32 s6, s10
; GFX11-FLUSH-NEXT:    s_mov_b32 s7, s11
; GFX11-FLUSH-NEXT:    s_mov_b32 s8, s0
; GFX11-FLUSH-NEXT:    buffer_load_b32 v2, off, s[4:7], 0
; GFX11-FLUSH-NEXT:    s_mov_b32 s9, s1
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FLUSH-NEXT:    v_pk_mul_f16 v0, v0, v1
; GFX11-FLUSH-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FLUSH-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FLUSH-NEXT:    v_pk_add_f16 v0, v0, v2
; GFX11-FLUSH-NEXT:    buffer_store_b32 v0, off, s[8:11], 0
; GFX11-FLUSH-NEXT:    s_nop 0
; GFX11-FLUSH-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-FLUSH-NEXT:    s_endpgm
;
; GFX11-DENORM-LABEL: fmuladd_v2f16:
; GFX11-DENORM:       ; %bb.0:
; GFX11-DENORM-NEXT:    s_load_b256 s[0:7], s[0:1], 0x24
; GFX11-DENORM-NEXT:    s_mov_b32 s10, -1
; GFX11-DENORM-NEXT:    s_mov_b32 s11, 0x31016000
; GFX11-DENORM-NEXT:    s_mov_b32 s14, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s15, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s18, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s19, s11
; GFX11-DENORM-NEXT:    s_mov_b32 s22, s10
; GFX11-DENORM-NEXT:    s_mov_b32 s23, s11
; GFX11-DENORM-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DENORM-NEXT:    s_mov_b32 s12, s2
; GFX11-DENORM-NEXT:    s_mov_b32 s13, s3
; GFX11-DENORM-NEXT:    s_mov_b32 s16, s4
; GFX11-DENORM-NEXT:    s_mov_b32 s17, s5
; GFX11-DENORM-NEXT:    s_mov_b32 s20, s6
; GFX11-DENORM-NEXT:    s_mov_b32 s21, s7
; GFX11-DENORM-NEXT:    buffer_load_b32 v0, off, s[12:15], 0
; GFX11-DENORM-NEXT:    buffer_load_b32 v1, off, s[16:19], 0
; GFX11-DENORM-NEXT:    buffer_load_b32 v2, off, s[20:23], 0
; GFX11-DENORM-NEXT:    s_mov_b32 s8, s0
; GFX11-DENORM-NEXT:    s_mov_b32 s9, s1
; GFX11-DENORM-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DENORM-NEXT:    v_pk_fma_f16 v0, v0, v1, v2
; GFX11-DENORM-NEXT:    buffer_store_b32 v0, off, s[8:11], 0
; GFX11-DENORM-NEXT:    s_nop 0
; GFX11-DENORM-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-DENORM-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a,
    ptr addrspace(1) %b,
    ptr addrspace(1) %c) {
  %a.val = load <2 x half>, ptr addrspace(1) %a
  %b.val = load <2 x half>, ptr addrspace(1) %b
  %c.val = load <2 x half>, ptr addrspace(1) %c
  %r.val = call <2 x half> @llvm.fmuladd.v2f16(<2 x half> %a.val, <2 x half> %b.val, <2 x half> %c.val)
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}
