; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=loop-vectorize,instsimplify -force-vector-interleave=1 -force-vector-width=2 -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define void @cond_call(ptr readonly %src, ptr noalias %dest, i64 %N) {
; CHECK-LABEL: @cond_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[FOR_LOOP:%.*]] ]
; CHECK-NEXT:    [[LD_ADDR:%.*]] = getelementptr inbounds i64, ptr [[SRC:%.*]], i64 [[IV]]
; CHECK-NEXT:    [[LD_VALUE:%.*]] = load i64, ptr [[LD_ADDR]], align 8
; CHECK-NEXT:    [[IFCOND:%.*]] = icmp ult i64 [[LD_VALUE]], 5
; CHECK-NEXT:    br i1 [[IFCOND]], label [[IF_THEN:%.*]], label [[FOR_LOOP]]
; CHECK:       if.then:
; CHECK-NEXT:    [[FOO_RET:%.*]] = call i64 @foo(i64 [[LD_VALUE]])
; CHECK-NEXT:    br label [[FOR_LOOP]]
; CHECK:       for.loop:
; CHECK-NEXT:    [[ST_VALUE:%.*]] = phi i64 [ [[LD_VALUE]], [[FOR_BODY]] ], [ [[FOO_RET]], [[IF_THEN]] ]
; CHECK-NEXT:    [[ST_ADDR:%.*]] = getelementptr inbounds i64, ptr [[DEST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[ST_VALUE]], ptr [[ST_ADDR]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[LOOPCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[LOOPCOND]], label [[END:%.*]], label [[FOR_BODY]]
; CHECK:       end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %for.loop ]
  %ld.addr = getelementptr inbounds i64, ptr %src, i64 %iv
  %ld.value = load i64, ptr %ld.addr, align 8
  %ifcond = icmp ult i64 %ld.value, 5
  br i1 %ifcond, label %if.then, label %for.loop

if.then:
  %foo.ret = call i64 @foo(i64 %ld.value)
  br label %for.loop

for.loop:
  %st.value = phi i64 [ %ld.value, %for.body ], [ %foo.ret, %if.then ]
  %st.addr = getelementptr inbounds i64, ptr %dest, i64 %iv
  store i64 %st.value, ptr %st.addr, align 8
  %iv.next = add nsw nuw i64 %iv, 1
  %loopcond = icmp eq i64 %iv.next, %N
  br i1 %loopcond, label %end, label %for.body

end:
  ret void
}

declare i64 @foo(i64)
declare <4 x i64> @vector_foo(<4 x i64>)

; We need a vector variant in order to allow for vectorization at present, but
; we want to test scalarization of conditional calls. If we provide a variant
; with a different number of lanes than the VF we force via
; "-force-vector-width=2", then it should pass the legality checks but
; scalarize. TODO: Remove the requirement to have a variant.
attributes #0 = { readonly nounwind "vector-function-abi-variant"="_ZGV_LLVM_M4v_foo(vector_foo)" }
