; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve -mattr=+vpu | FileCheck %s

; This would assert because VE specified that all setcc
; nodes (even with vector operands) return a scalar value.

define <4 x i8> @udiv_by_minus_one(<4 x i8> %x) {
; CHECK-LABEL: udiv_by_minus_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (56)0
; CHECK-NEXT:    and %s1, %s1, (56)0
; CHECK-NEXT:    and %s2, %s2, (56)0
; CHECK-NEXT:    and %s3, %s3, (56)0
; CHECK-NEXT:    divu.w %s3, %s3, (56)0
; CHECK-NEXT:    divu.w %s2, %s2, (56)0
; CHECK-NEXT:    divu.w %s1, %s1, (56)0
; CHECK-NEXT:    divu.w %s0, %s0, (56)0
; CHECK-NEXT:    b.l.t (, %s10)
  %r = udiv <4 x i8> %x, <i8 255, i8 255, i8 255, i8 255>
  ret <4 x i8> %r
}

define <4 x i8> @urem_by_minus_one(<4 x i8> %x) {
; CHECK-LABEL: urem_by_minus_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (56)0
; CHECK-NEXT:    and %s1, %s1, (56)0
; CHECK-NEXT:    and %s2, %s2, (56)0
; CHECK-NEXT:    and %s3, %s3, (56)0
; CHECK-NEXT:    divu.w %s4, %s3, (56)0
; CHECK-NEXT:    muls.w.sx %s4, %s4, (56)0
; CHECK-NEXT:    subs.w.sx %s3, %s3, %s4
; CHECK-NEXT:    divu.w %s4, %s2, (56)0
; CHECK-NEXT:    muls.w.sx %s4, %s4, (56)0
; CHECK-NEXT:    subs.w.sx %s2, %s2, %s4
; CHECK-NEXT:    divu.w %s4, %s1, (56)0
; CHECK-NEXT:    muls.w.sx %s4, %s4, (56)0
; CHECK-NEXT:    subs.w.sx %s1, %s1, %s4
; CHECK-NEXT:    divu.w %s4, %s0, (56)0
; CHECK-NEXT:    muls.w.sx %s4, %s4, (56)0
; CHECK-NEXT:    subs.w.sx %s0, %s0, %s4
; CHECK-NEXT:    b.l.t (, %s10)
  %r = urem <4 x i8> %x, <i8 255, i8 255, i8 255, i8 255>
  ret <4 x i8> %r
}
