; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -amdgpu-load-store-vectorizer=0 -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -amdgpu-load-store-vectorizer=0 -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG %s
; RUN: llc -global-isel=1 -amdgpu-load-store-vectorizer=0 -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL %s

declare i32 @llvm.amdgcn.permlane16(i32, i32, i32, i32, i1, i1)
declare i32 @llvm.amdgcn.permlanex16(i32, i32, i32, i32, i1, i1)
declare i32 @llvm.amdgcn.workitem.id.x()
declare i32 @llvm.amdgcn.workitem.id.y()

define amdgpu_kernel void @v_permlane16_b32_vss(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_vss:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s7, s2
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vss:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s7, s0
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vii(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlane16_b32_vii:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlane16_b32 v0, v0, 1, 2
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vii:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, 1, 2
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 1, i32 2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

; FIXME-GFX10PLUS: It is allowed to have both immediates as literals
define amdgpu_kernel void @v_permlane16_b32_vll(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlane16_b32_vll:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    s_movk_i32 s0, 0x1234
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s0, 0xc1d1
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vll:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-NEXT:    s_movk_i32 s2, 0x1234
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, 0xc1d1
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 4660, i32 49617, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vvv(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlane16_b32_vvv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    s_mov_b32 null, 0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s0, s1
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlane16_b32_vvv:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-SDAG-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s3, v1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v1, v1, s3, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlane16_b32_vvv:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s3, v1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    v_permlane16_b32 v0, v0, s3, s4
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %tidy = call i32 @llvm.amdgcn.workitem.id.y()
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %tidx, i32 %tidy, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vvs(ptr addrspace(1) %out, i32 %src0, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_b32_vvs:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-SDAG-NEXT:    v_permlane16_b32 v1, v1, s2, s3
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlane16_b32_vvs:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    v_permlane16_b32 v0, v0, s4, s3
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlane16_b32_vvs:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v1, v1, s2, s3
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlane16_b32_vvs:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane16_b32 v0, v0, s4, s3
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %tidx, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vsv(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX10-SDAG-LABEL: v_permlane16_b32_vsv:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s2, v1
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-SDAG-NEXT:    v_permlane16_b32 v0, v0, s3, s2
; GFX10-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlane16_b32_vsv:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    v_permlane16_b32 v0, v0, s3, s4
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlane16_b32_vsv:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    v_permlane16_b32 v1, v1, s3, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlane16_b32_vsv:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    v_permlane16_b32 v0, v0, s3, s4
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidy = call i32 @llvm.amdgcn.workitem.id.y()
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %src1, i32 %tidy, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vss_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_vss_fi:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s7, s2 op_sel:[1,0]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vss_fi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s7, s0 op_sel:[1,0]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vss_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_vss_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s7, s2 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vss_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s7, s0 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_vss_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_vss_fi_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s7, s2 op_sel:[1,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_vss_fi_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s7, s0 op_sel:[1,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlane16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vss(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_vss:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s7, s2
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vss:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s7, s0
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vii(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlanex16_b32_vii:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, 1, 2
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vii:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, 1, 2
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 1, i32 2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

; FIXME-GFX10PLUS: It is allowed to have both immediates as literals
define amdgpu_kernel void @v_permlanex16_b32_vll(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlanex16_b32_vll:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    s_movk_i32 s0, 0x1234
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s0, 0xc1d1
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vll:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-NEXT:    s_movk_i32 s2, 0x1234
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, 0xc1d1
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 4660, i32 49617, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vvv(ptr addrspace(1) %out, i32 %src0) {
; GFX10-LABEL: v_permlanex16_b32_vvv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX10-NEXT:    s_mov_b32 null, 0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s0, s1
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlanex16_b32_vvv:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-SDAG-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s3, v1
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v1, v1, s3, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlanex16_b32_vvv:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s3, v1
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    v_permlanex16_b32 v0, v0, s3, s4
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %tidy = call i32 @llvm.amdgcn.workitem.id.y()
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %tidx, i32 %tidy, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vvs(ptr addrspace(1) %out, i32 %src0, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_b32_vvs:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v1, v1, s2, s3
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlanex16_b32_vvs:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    v_permlanex16_b32 v0, v0, s4, s3
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlanex16_b32_vvs:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v1, v1, s2, s3
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlanex16_b32_vvs:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlanex16_b32 v0, v0, s4, s3
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %tidx, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vsv(ptr addrspace(1) %out, i32 %src0, i32 %src1) {
; GFX10-SDAG-LABEL: v_permlanex16_b32_vsv:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s2, v1
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v0, v0, s3, s2
; GFX10-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlanex16_b32_vsv:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-GISEL-NEXT:    v_permlanex16_b32 v0, v0, s3, s4
; GFX10-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlanex16_b32_vsv:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v1, v1, s3, s2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlanex16_b32_vsv:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 10, 10
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-GISEL-NEXT:    v_permlanex16_b32 v0, v0, s3, s4
; GFX11-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidy = call i32 @llvm.amdgcn.workitem.id.y()
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %src1, i32 %tidy, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vss_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_vss_fi:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s7, s2 op_sel:[1,0]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vss_fi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s7, s0 op_sel:[1,0]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vss_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_vss_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s7, s2 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vss_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s7, s0 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_vss_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_vss_fi_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x34
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s7, s2 op_sel:[1,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_vss_fi_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s7, s0 op_sel:[1,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %src0, i32 %src0, i32 %src1, i32 %src2, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_tid_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_tid_tid:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s2, s3
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_tid_tid:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, s3
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16(i32 %tidx, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_undef_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_undef_tid:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s2, s3
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_undef_tid:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, s3
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_i_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlane16_b32_i_tid:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_clause 0x1
; GFX10-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_permlane16_b32 v1, v0, s2, s3
; GFX10-SDAG-NEXT:    global_store_dword v2, v1, s[4:5]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlane16_b32_i_tid:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_clause 0x1
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_permlane16_b32 v1, v0, s2, s3
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlane16_b32_i_tid:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0x3039 :: v_dual_mov_b32 v2, 0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane16_b32 v1, v0, s2, s3
; GFX11-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlane16_b32_i_tid:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlane16_b32 v1, v0, s2, s3
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlane16(i32 12345, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_i_tid_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_i_tid_fi:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[1,0]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_i_tid_fi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[1,0]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_i_tid_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_i_tid_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_i_tid_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlane16_b32_i_tid_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlane16_b32_i_tid_fi_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[1,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlane16_b32_i_tid_fi_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlane16_b32 v0, v0, s2, s3 op_sel:[1,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlane16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_tid_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_tid_tid:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s2, s3
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_tid_tid:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, s3
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %tidx, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_undef_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_undef_tid:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s2, s3
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_undef_tid:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, s3
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_i_tid(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-SDAG-LABEL: v_permlanex16_b32_i_tid:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_clause 0x1
; GFX10-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_permlanex16_b32 v1, v0, s2, s3
; GFX10-SDAG-NEXT:    global_store_dword v2, v1, s[4:5]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_permlanex16_b32_i_tid:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_clause 0x1
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_permlanex16_b32 v1, v0, s2, s3
; GFX10-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[4:5]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_permlanex16_b32_i_tid:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0x3039 :: v_dual_mov_b32 v2, 0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlanex16_b32 v1, v0, s2, s3
; GFX11-SDAG-NEXT:    global_store_b32 v2, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_permlanex16_b32_i_tid:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_clause 0x1
; GFX11-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-GISEL-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v1, 0x3039
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_permlanex16_b32 v1, v0, s2, s3
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-GISEL-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %v = call i32 @llvm.amdgcn.permlanex16(i32 12345, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_i_tid_fi(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_i_tid_fi:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[1,0]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_i_tid_fi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[1,0]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 true, i1 false)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_i_tid_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_i_tid_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_i_tid_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 false, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_permlanex16_b32_i_tid_fi_bc(ptr addrspace(1) %out, i32 %src0, i32 %src1, i32 %src2) {
; GFX10-LABEL: v_permlanex16_b32_i_tid_fi_bc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x30
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[1,1]
; GFX10-NEXT:    global_store_dword v1, v0, s[4:5]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_permlanex16_b32_i_tid_fi_bc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x30
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_permlanex16_b32 v0, v0, s2, s3 op_sel:[1,1]
; GFX11-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tidx = call i32 @llvm.amdgcn.workitem.id.x()
  %undef = freeze i32 poison
  %v = call i32 @llvm.amdgcn.permlanex16(i32 %undef, i32 %tidx, i32 %src1, i32 %src2, i1 true, i1 true)
  store i32 %v, ptr addrspace(1) %out
  ret void
}
