; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -loop-load-elim -S < %s | \
; RUN:     FileCheck %s -check-prefix=DEFAULT

; RUN: opt -loop-load-elim -S -enable-mem-access-versioning=0 < %s | \
; RUN:     FileCheck %s -check-prefix=NO-VERSION

; RUN: opt -loop-load-elim -S -loop-load-elimination-scev-check-threshold=1 < %s | \
; RUN:     FileCheck %s -check-prefix=THRESHOLD

; Forwarding in the presence of symbolic strides:
;
;   for (unsigned i = 0; i < 100; i++)
;     A[i + 1] = A[Stride * i] + B[i];

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"

define void @f(i32* noalias nocapture %A, i32* noalias nocapture readonly %B, i64 %N,
;
;
;
;
;
; DEFAULT-LABEL: @f(
; DEFAULT-NEXT:  for.body.lver.check:
; DEFAULT-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE:%.*]], 1
; DEFAULT-NEXT:    br i1 [[IDENT_CHECK]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH:%.*]]
; DEFAULT:       for.body.ph.lver.orig:
; DEFAULT-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; DEFAULT:       for.body.lver.orig:
; DEFAULT-NEXT:    [[INDVARS_IV_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[INDVARS_IV_NEXT_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; DEFAULT-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_LVER_ORIG]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDX_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_1_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX2_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ADD_LVER_ORIG:%.*]] = add i32 [[LOAD_1_LVER_ORIG]], [[LOAD_LVER_ORIG]]
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT_LVER_ORIG]] = add nuw nsw i64 [[INDVARS_IV_LVER_ORIG]], 1
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[INDVARS_IV_NEXT_LVER_ORIG]]
; DEFAULT-NEXT:    store i32 [[ADD_LVER_ORIG]], i32* [[ARRAYIDX_NEXT_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[N:%.*]]
; DEFAULT-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; DEFAULT:       for.body.ph:
; DEFAULT-NEXT:    [[LOAD_INITIAL:%.*]] = load i32, i32* [[A]], align 4
; DEFAULT-NEXT:    br label [[FOR_BODY:%.*]]
; DEFAULT:       for.body:
; DEFAULT-NEXT:    [[STORE_FORWARDED:%.*]] = phi i32 [ [[LOAD_INITIAL]], [[FOR_BODY_PH]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL]]
; DEFAULT-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B]], i64 [[INDVARS_IV]]
; DEFAULT-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; DEFAULT-NEXT:    [[ADD]] = add i32 [[LOAD_1]], [[STORE_FORWARDED]]
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[INDVARS_IV_NEXT]]
; DEFAULT-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; DEFAULT-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N]]
; DEFAULT-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT1:%.*]], label [[FOR_BODY]]
; DEFAULT:       for.end.loopexit:
; DEFAULT-NEXT:    br label [[FOR_END:%.*]]
; DEFAULT:       for.end.loopexit1:
; DEFAULT-NEXT:    br label [[FOR_END]]
; DEFAULT:       for.end:
; DEFAULT-NEXT:    ret void
;
; NO-VERSION-LABEL: @f(
; NO-VERSION-NEXT:  entry:
; NO-VERSION-NEXT:    br label [[FOR_BODY:%.*]]
; NO-VERSION:       for.body:
; NO-VERSION-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; NO-VERSION-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE:%.*]]
; NO-VERSION-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL]]
; NO-VERSION-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; NO-VERSION-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV]]
; NO-VERSION-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; NO-VERSION-NEXT:    [[ADD:%.*]] = add i32 [[LOAD_1]], [[LOAD]]
; NO-VERSION-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; NO-VERSION-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[INDVARS_IV_NEXT]]
; NO-VERSION-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; NO-VERSION-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; NO-VERSION-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; NO-VERSION:       for.end:
; NO-VERSION-NEXT:    ret void
;
; THRESHOLD-LABEL: @f(
; THRESHOLD-NEXT:  for.body.lver.check:
; THRESHOLD-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE:%.*]], 1
; THRESHOLD-NEXT:    br i1 [[IDENT_CHECK]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH:%.*]]
; THRESHOLD:       for.body.ph.lver.orig:
; THRESHOLD-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; THRESHOLD:       for.body.lver.orig:
; THRESHOLD-NEXT:    [[INDVARS_IV_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[INDVARS_IV_NEXT_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; THRESHOLD-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_LVER_ORIG]], [[STRIDE]]
; THRESHOLD-NEXT:    [[ARRAYIDX_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL_LVER_ORIG]]
; THRESHOLD-NEXT:    [[LOAD_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[ARRAYIDX2_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV_LVER_ORIG]]
; THRESHOLD-NEXT:    [[LOAD_1_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX2_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[ADD_LVER_ORIG:%.*]] = add i32 [[LOAD_1_LVER_ORIG]], [[LOAD_LVER_ORIG]]
; THRESHOLD-NEXT:    [[INDVARS_IV_NEXT_LVER_ORIG]] = add nuw nsw i64 [[INDVARS_IV_LVER_ORIG]], 1
; THRESHOLD-NEXT:    [[ARRAYIDX_NEXT_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[INDVARS_IV_NEXT_LVER_ORIG]]
; THRESHOLD-NEXT:    store i32 [[ADD_LVER_ORIG]], i32* [[ARRAYIDX_NEXT_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[N:%.*]]
; THRESHOLD-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; THRESHOLD:       for.body.ph:
; THRESHOLD-NEXT:    [[LOAD_INITIAL:%.*]] = load i32, i32* [[A]], align 4
; THRESHOLD-NEXT:    br label [[FOR_BODY:%.*]]
; THRESHOLD:       for.body:
; THRESHOLD-NEXT:    [[STORE_FORWARDED:%.*]] = phi i32 [ [[LOAD_INITIAL]], [[FOR_BODY_PH]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; THRESHOLD-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; THRESHOLD-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE]]
; THRESHOLD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL]]
; THRESHOLD-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; THRESHOLD-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B]], i64 [[INDVARS_IV]]
; THRESHOLD-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; THRESHOLD-NEXT:    [[ADD]] = add i32 [[LOAD_1]], [[STORE_FORWARDED]]
; THRESHOLD-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; THRESHOLD-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[INDVARS_IV_NEXT]]
; THRESHOLD-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; THRESHOLD-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N]]
; THRESHOLD-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT1:%.*]], label [[FOR_BODY]]
; THRESHOLD:       for.end.loopexit:
; THRESHOLD-NEXT:    br label [[FOR_END:%.*]]
; THRESHOLD:       for.end.loopexit1:
; THRESHOLD-NEXT:    br label [[FOR_END]]
; THRESHOLD:       for.end:
; THRESHOLD-NEXT:    ret void
;
  i64 %stride) {


entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %mul = mul i64 %indvars.iv, %stride
  %arrayidx = getelementptr inbounds i32, i32* %A, i64 %mul
  %load = load i32, i32* %arrayidx, align 4
  %arrayidx2 = getelementptr inbounds i32, i32* %B, i64 %indvars.iv
  %load_1 = load i32, i32* %arrayidx2, align 4
  %add = add i32 %load_1, %load
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %arrayidx_next = getelementptr inbounds i32, i32* %A, i64 %indvars.iv.next
  store i32 %add, i32* %arrayidx_next, align 4
  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; Similar to @f(), but with a struct type.
define void @f_struct({ i32, i8 } * noalias nocapture %A, { i32, i8 }* noalias nocapture readonly %B, i64 %N,
;
;
;
;
;
; DEFAULT-LABEL: @f_struct(
; DEFAULT-NEXT:  for.body.lver.check:
; DEFAULT-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE:%.*]], 1
; DEFAULT-NEXT:    br i1 [[IDENT_CHECK]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH:%.*]]
; DEFAULT:       for.body.ph.lver.orig:
; DEFAULT-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; DEFAULT:       for.body.lver.orig:
; DEFAULT-NEXT:    [[INDVARS_IV_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[INDVARS_IV_NEXT_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; DEFAULT-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_LVER_ORIG]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDX_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A:%.*]], i64 [[MUL_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_LVER_ORIG:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[B:%.*]], i64 [[INDVARS_IV_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_1_LVER_ORIG:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX2_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[V1_LVER_ORIG:%.*]] = extractvalue { i32, i8 } [[LOAD_LVER_ORIG]], 0
; DEFAULT-NEXT:    [[V2_LVER_ORIG:%.*]] = extractvalue { i32, i8 } [[LOAD_1_LVER_ORIG]], 0
; DEFAULT-NEXT:    [[ADD_LVER_ORIG:%.*]] = add i32 [[V1_LVER_ORIG]], [[V2_LVER_ORIG]]
; DEFAULT-NEXT:    [[INS_LVER_ORIG:%.*]] = insertvalue { i32, i8 } undef, i32 [[ADD_LVER_ORIG]], 0
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT_LVER_ORIG]] = add nuw nsw i64 [[INDVARS_IV_LVER_ORIG]], 1
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[INDVARS_IV_NEXT_LVER_ORIG]]
; DEFAULT-NEXT:    store { i32, i8 } [[INS_LVER_ORIG]], { i32, i8 }* [[ARRAYIDX_NEXT_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[N:%.*]]
; DEFAULT-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; DEFAULT:       for.body.ph:
; DEFAULT-NEXT:    [[LOAD_INITIAL:%.*]] = load { i32, i8 }, { i32, i8 }* [[A]], align 4
; DEFAULT-NEXT:    br label [[FOR_BODY:%.*]]
; DEFAULT:       for.body:
; DEFAULT-NEXT:    [[STORE_FORWARDED:%.*]] = phi { i32, i8 } [ [[LOAD_INITIAL]], [[FOR_BODY_PH]] ], [ [[INS:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[MUL]]
; DEFAULT-NEXT:    [[LOAD:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[B]], i64 [[INDVARS_IV]]
; DEFAULT-NEXT:    [[LOAD_1:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX2]], align 4
; DEFAULT-NEXT:    [[V1:%.*]] = extractvalue { i32, i8 } [[STORE_FORWARDED]], 0
; DEFAULT-NEXT:    [[V2:%.*]] = extractvalue { i32, i8 } [[LOAD_1]], 0
; DEFAULT-NEXT:    [[ADD:%.*]] = add i32 [[V1]], [[V2]]
; DEFAULT-NEXT:    [[INS]] = insertvalue { i32, i8 } undef, i32 [[ADD]], 0
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[INDVARS_IV_NEXT]]
; DEFAULT-NEXT:    store { i32, i8 } [[INS]], { i32, i8 }* [[ARRAYIDX_NEXT]], align 4
; DEFAULT-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N]]
; DEFAULT-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT1:%.*]], label [[FOR_BODY]]
; DEFAULT:       for.end.loopexit:
; DEFAULT-NEXT:    br label [[FOR_END:%.*]]
; DEFAULT:       for.end.loopexit1:
; DEFAULT-NEXT:    br label [[FOR_END]]
; DEFAULT:       for.end:
; DEFAULT-NEXT:    ret void
;
; NO-VERSION-LABEL: @f_struct(
; NO-VERSION-NEXT:  entry:
; NO-VERSION-NEXT:    br label [[FOR_BODY:%.*]]
; NO-VERSION:       for.body:
; NO-VERSION-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; NO-VERSION-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE:%.*]]
; NO-VERSION-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A:%.*]], i64 [[MUL]]
; NO-VERSION-NEXT:    [[LOAD:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX]], align 4
; NO-VERSION-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[B:%.*]], i64 [[INDVARS_IV]]
; NO-VERSION-NEXT:    [[LOAD_1:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX2]], align 4
; NO-VERSION-NEXT:    [[V1:%.*]] = extractvalue { i32, i8 } [[LOAD]], 0
; NO-VERSION-NEXT:    [[V2:%.*]] = extractvalue { i32, i8 } [[LOAD_1]], 0
; NO-VERSION-NEXT:    [[ADD:%.*]] = add i32 [[V1]], [[V2]]
; NO-VERSION-NEXT:    [[INS:%.*]] = insertvalue { i32, i8 } undef, i32 [[ADD]], 0
; NO-VERSION-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; NO-VERSION-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[INDVARS_IV_NEXT]]
; NO-VERSION-NEXT:    store { i32, i8 } [[INS]], { i32, i8 }* [[ARRAYIDX_NEXT]], align 4
; NO-VERSION-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; NO-VERSION-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; NO-VERSION:       for.end:
; NO-VERSION-NEXT:    ret void
;
; THRESHOLD-LABEL: @f_struct(
; THRESHOLD-NEXT:  for.body.lver.check:
; THRESHOLD-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE:%.*]], 1
; THRESHOLD-NEXT:    br i1 [[IDENT_CHECK]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH:%.*]]
; THRESHOLD:       for.body.ph.lver.orig:
; THRESHOLD-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; THRESHOLD:       for.body.lver.orig:
; THRESHOLD-NEXT:    [[INDVARS_IV_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[INDVARS_IV_NEXT_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; THRESHOLD-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_LVER_ORIG]], [[STRIDE]]
; THRESHOLD-NEXT:    [[ARRAYIDX_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A:%.*]], i64 [[MUL_LVER_ORIG]]
; THRESHOLD-NEXT:    [[LOAD_LVER_ORIG:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[ARRAYIDX2_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[B:%.*]], i64 [[INDVARS_IV_LVER_ORIG]]
; THRESHOLD-NEXT:    [[LOAD_1_LVER_ORIG:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX2_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[V1_LVER_ORIG:%.*]] = extractvalue { i32, i8 } [[LOAD_LVER_ORIG]], 0
; THRESHOLD-NEXT:    [[V2_LVER_ORIG:%.*]] = extractvalue { i32, i8 } [[LOAD_1_LVER_ORIG]], 0
; THRESHOLD-NEXT:    [[ADD_LVER_ORIG:%.*]] = add i32 [[V1_LVER_ORIG]], [[V2_LVER_ORIG]]
; THRESHOLD-NEXT:    [[INS_LVER_ORIG:%.*]] = insertvalue { i32, i8 } undef, i32 [[ADD_LVER_ORIG]], 0
; THRESHOLD-NEXT:    [[INDVARS_IV_NEXT_LVER_ORIG]] = add nuw nsw i64 [[INDVARS_IV_LVER_ORIG]], 1
; THRESHOLD-NEXT:    [[ARRAYIDX_NEXT_LVER_ORIG:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[INDVARS_IV_NEXT_LVER_ORIG]]
; THRESHOLD-NEXT:    store { i32, i8 } [[INS_LVER_ORIG]], { i32, i8 }* [[ARRAYIDX_NEXT_LVER_ORIG]], align 4
; THRESHOLD-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[N:%.*]]
; THRESHOLD-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; THRESHOLD:       for.body.ph:
; THRESHOLD-NEXT:    [[LOAD_INITIAL:%.*]] = load { i32, i8 }, { i32, i8 }* [[A]], align 4
; THRESHOLD-NEXT:    br label [[FOR_BODY:%.*]]
; THRESHOLD:       for.body:
; THRESHOLD-NEXT:    [[STORE_FORWARDED:%.*]] = phi { i32, i8 } [ [[LOAD_INITIAL]], [[FOR_BODY_PH]] ], [ [[INS:%.*]], [[FOR_BODY]] ]
; THRESHOLD-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; THRESHOLD-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE]]
; THRESHOLD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[MUL]]
; THRESHOLD-NEXT:    [[LOAD:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX]], align 4
; THRESHOLD-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[B]], i64 [[INDVARS_IV]]
; THRESHOLD-NEXT:    [[LOAD_1:%.*]] = load { i32, i8 }, { i32, i8 }* [[ARRAYIDX2]], align 4
; THRESHOLD-NEXT:    [[V1:%.*]] = extractvalue { i32, i8 } [[STORE_FORWARDED]], 0
; THRESHOLD-NEXT:    [[V2:%.*]] = extractvalue { i32, i8 } [[LOAD_1]], 0
; THRESHOLD-NEXT:    [[ADD:%.*]] = add i32 [[V1]], [[V2]]
; THRESHOLD-NEXT:    [[INS]] = insertvalue { i32, i8 } undef, i32 [[ADD]], 0
; THRESHOLD-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; THRESHOLD-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds { i32, i8 }, { i32, i8 }* [[A]], i64 [[INDVARS_IV_NEXT]]
; THRESHOLD-NEXT:    store { i32, i8 } [[INS]], { i32, i8 }* [[ARRAYIDX_NEXT]], align 4
; THRESHOLD-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N]]
; THRESHOLD-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT1:%.*]], label [[FOR_BODY]]
; THRESHOLD:       for.end.loopexit:
; THRESHOLD-NEXT:    br label [[FOR_END:%.*]]
; THRESHOLD:       for.end.loopexit1:
; THRESHOLD-NEXT:    br label [[FOR_END]]
; THRESHOLD:       for.end:
; THRESHOLD-NEXT:    ret void
;
  i64 %stride) {


entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %mul = mul i64 %indvars.iv, %stride
  %arrayidx = getelementptr inbounds { i32, i8 }, { i32, i8 }* %A, i64 %mul
  %load = load { i32, i8 }, { i32, i8 }* %arrayidx, align 4
  %arrayidx2 = getelementptr inbounds { i32, i8 }, { i32, i8 }* %B, i64 %indvars.iv
  %load_1 = load { i32, i8 }, { i32, i8 }* %arrayidx2, align 4


  %v1 = extractvalue { i32, i8 } %load, 0
  %v2 = extractvalue { i32, i8} %load_1, 0
  %add = add i32 %v1, %v2
  %ins = insertvalue { i32, i8 } undef, i32 %add, 0
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %arrayidx_next = getelementptr inbounds { i32, i8 }, { i32, i8 }* %A, i64 %indvars.iv.next
  store { i32, i8 } %ins, { i32, i8 }* %arrayidx_next, align 4
  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

; With two symbolic strides:
;
;   for (unsigned i = 0; i < 100; i++)
;     A[Stride2 * (i + 1)] = A[Stride1 * i] + B[i];

define void @two_strides(i32* noalias nocapture %A, i32* noalias nocapture readonly %B, i64 %N,
;
;
;
;
;
;
; DEFAULT-LABEL: @two_strides(
; DEFAULT-NEXT:  for.body.lver.check:
; DEFAULT-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE_2:%.*]], 1
; DEFAULT-NEXT:    [[IDENT_CHECK1:%.*]] = icmp ne i64 [[STRIDE_1:%.*]], 1
; DEFAULT-NEXT:    [[TMP0:%.*]] = or i1 [[IDENT_CHECK]], [[IDENT_CHECK1]]
; DEFAULT-NEXT:    br i1 [[TMP0]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH:%.*]]
; DEFAULT:       for.body.ph.lver.orig:
; DEFAULT-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; DEFAULT:       for.body.lver.orig:
; DEFAULT-NEXT:    [[INDVARS_IV_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[INDVARS_IV_NEXT_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; DEFAULT-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_LVER_ORIG]], [[STRIDE_1]]
; DEFAULT-NEXT:    [[ARRAYIDX_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOAD_1_LVER_ORIG:%.*]] = load i32, i32* [[ARRAYIDX2_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ADD_LVER_ORIG:%.*]] = add i32 [[LOAD_1_LVER_ORIG]], [[LOAD_LVER_ORIG]]
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT_LVER_ORIG]] = add nuw nsw i64 [[INDVARS_IV_LVER_ORIG]], 1
; DEFAULT-NEXT:    [[MUL_2_LVER_ORIG:%.*]] = mul i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[STRIDE_2]]
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT_LVER_ORIG:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL_2_LVER_ORIG]]
; DEFAULT-NEXT:    store i32 [[ADD_LVER_ORIG]], i32* [[ARRAYIDX_NEXT_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT_LVER_ORIG]], [[N:%.*]]
; DEFAULT-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; DEFAULT:       for.body.ph:
; DEFAULT-NEXT:    [[LOAD_INITIAL:%.*]] = load i32, i32* [[A]], align 4
; DEFAULT-NEXT:    br label [[FOR_BODY:%.*]]
; DEFAULT:       for.body:
; DEFAULT-NEXT:    [[STORE_FORWARDED:%.*]] = phi i32 [ [[LOAD_INITIAL]], [[FOR_BODY_PH]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE_1]]
; DEFAULT-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL]]
; DEFAULT-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; DEFAULT-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B]], i64 [[INDVARS_IV]]
; DEFAULT-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; DEFAULT-NEXT:    [[ADD]] = add i32 [[LOAD_1]], [[STORE_FORWARDED]]
; DEFAULT-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; DEFAULT-NEXT:    [[MUL_2:%.*]] = mul i64 [[INDVARS_IV_NEXT]], [[STRIDE_2]]
; DEFAULT-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL_2]]
; DEFAULT-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; DEFAULT-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N]]
; DEFAULT-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT2:%.*]], label [[FOR_BODY]]
; DEFAULT:       for.end.loopexit:
; DEFAULT-NEXT:    br label [[FOR_END:%.*]]
; DEFAULT:       for.end.loopexit2:
; DEFAULT-NEXT:    br label [[FOR_END]]
; DEFAULT:       for.end:
; DEFAULT-NEXT:    ret void
;
; NO-VERSION-LABEL: @two_strides(
; NO-VERSION-NEXT:  entry:
; NO-VERSION-NEXT:    br label [[FOR_BODY:%.*]]
; NO-VERSION:       for.body:
; NO-VERSION-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; NO-VERSION-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE_1:%.*]]
; NO-VERSION-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL]]
; NO-VERSION-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; NO-VERSION-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV]]
; NO-VERSION-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; NO-VERSION-NEXT:    [[ADD:%.*]] = add i32 [[LOAD_1]], [[LOAD]]
; NO-VERSION-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; NO-VERSION-NEXT:    [[MUL_2:%.*]] = mul i64 [[INDVARS_IV_NEXT]], [[STRIDE_2:%.*]]
; NO-VERSION-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL_2]]
; NO-VERSION-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; NO-VERSION-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; NO-VERSION-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; NO-VERSION:       for.end:
; NO-VERSION-NEXT:    ret void
;
; THRESHOLD-LABEL: @two_strides(
; THRESHOLD-NEXT:  entry:
; THRESHOLD-NEXT:    br label [[FOR_BODY:%.*]]
; THRESHOLD:       for.body:
; THRESHOLD-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ]
; THRESHOLD-NEXT:    [[MUL:%.*]] = mul i64 [[INDVARS_IV]], [[STRIDE_1:%.*]]
; THRESHOLD-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[MUL]]
; THRESHOLD-NEXT:    [[LOAD:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
; THRESHOLD-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV]]
; THRESHOLD-NEXT:    [[LOAD_1:%.*]] = load i32, i32* [[ARRAYIDX2]], align 4
; THRESHOLD-NEXT:    [[ADD:%.*]] = add i32 [[LOAD_1]], [[LOAD]]
; THRESHOLD-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; THRESHOLD-NEXT:    [[MUL_2:%.*]] = mul i64 [[INDVARS_IV_NEXT]], [[STRIDE_2:%.*]]
; THRESHOLD-NEXT:    [[ARRAYIDX_NEXT:%.*]] = getelementptr inbounds i32, i32* [[A]], i64 [[MUL_2]]
; THRESHOLD-NEXT:    store i32 [[ADD]], i32* [[ARRAYIDX_NEXT]], align 4
; THRESHOLD-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV_NEXT]], [[N:%.*]]
; THRESHOLD-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; THRESHOLD:       for.end:
; THRESHOLD-NEXT:    ret void
;
  i64 %stride.1, i64 %stride.2) {


entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %mul = mul i64 %indvars.iv, %stride.1
  %arrayidx = getelementptr inbounds i32, i32* %A, i64 %mul
  %load = load i32, i32* %arrayidx, align 4
  %arrayidx2 = getelementptr inbounds i32, i32* %B, i64 %indvars.iv
  %load_1 = load i32, i32* %arrayidx2, align 4
  %add = add i32 %load_1, %load
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %mul.2 = mul i64 %indvars.iv.next, %stride.2
  %arrayidx_next = getelementptr inbounds i32, i32* %A, i64 %mul.2
  store i32 %add, i32* %arrayidx_next, align 4
  %exitcond = icmp eq i64 %indvars.iv.next, %N
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}
