; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK

define <2 x i32> @and_extract_zext_idx0(<4 x i16> %vec) nounwind {
; CHECK-LABEL: and_extract_zext_idx0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 0)
  %and = and <2 x i32> %extract, <i32 65535, i32 65535>
  ret <2 x i32> %and
}

define <4 x i16> @and_extract_sext_idx0(<8 x i8> %vec) nounwind {
; CHECK-LABEL: and_extract_sext_idx0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 0)
  %and = and <4 x i16> %extract, <i16 255, i16 255, i16 255, i16 255>
  ret <4 x i16> %and
}

define <2 x i32> @and_extract_zext_idx2(<4 x i16> %vec) nounwind {
; CHECK-LABEL: and_extract_zext_idx2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %zext = zext <4 x i16> %vec to <4 x i32>
  %extract = call <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32> %zext, i64 2)
  %and = and <2 x i32> %extract, <i32 65535, i32 65535>
  ret <2 x i32> %and
}

define <4 x i16> @and_extract_sext_idx4(<8 x i8> %vec) nounwind {
; CHECK-LABEL: and_extract_sext_idx4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %sext = sext <8 x i8> %vec to <8 x i16>
  %extract = call <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16> %sext, i64 4)
  %and = and <4 x i16> %extract, <i16 255, i16 255, i16 255, i16 255>
  ret <4 x i16> %and
}

declare <2 x i32> @llvm.vector.extract.v2i32.v4i32(<4 x i32>, i64)
declare <4 x i16> @llvm.vector.extract.v4i16.v8i16(<8 x i16>, i64)
