; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-apple-darwin            -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-ISEL
; RUN: llc -mtriple=aarch64-apple-darwin -fast-isel -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-FAST

; Test that we use the correct register class.
define i32 @mul_add_imm(i32 %a, i32 %b) {
; CHECK-LABEL: mul_add_imm:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    orr w8, wzr, #0x4
; CHECK-NEXT:    madd w0, w0, w1, w8
; CHECK-NEXT:    ret
  %1 = mul i32 %a, %b
  %2 = add i32 %1, 4
  ret i32 %2
}

define i32 @mul_sub_imm1(i32 %a, i32 %b) {
; CHECK-LABEL: mul_sub_imm1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w8, #4
; CHECK-NEXT:    msub w0, w0, w1, w8
; CHECK-NEXT:    ret
  %1 = mul i32 %a, %b
  %2 = sub i32 4, %1
  ret i32 %2
}

; bugpoint reduced test case. This only tests that we pass the MI verifier.
define void @mul_add_imm2() {
; CHECK-ISEL-LABEL: mul_add_imm2:
; CHECK-ISEL:       ; %bb.0: ; %entry
; CHECK-ISEL-NEXT:    mov w8, #1
; CHECK-ISEL-NEXT:  LBB2_1: ; %for.body8
; CHECK-ISEL-NEXT:    ; =>This Inner Loop Header: Depth=1
; CHECK-ISEL-NEXT:    cbnz w8, LBB2_1
; CHECK-ISEL-NEXT:  ; %bb.2: ; %for.end20
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: mul_add_imm2:
; CHECK-FAST:       ; %bb.0: ; %entry
; CHECK-FAST-NEXT:    mov x8, #-3
; CHECK-FAST-NEXT:    orr x9, xzr, #0xfffffffffffffffd
; CHECK-FAST-NEXT:    madd x8, x8, x8, x9
; CHECK-FAST-NEXT:    mov x9, #45968
; CHECK-FAST-NEXT:    movk x9, #48484, lsl #16
; CHECK-FAST-NEXT:    movk x9, #323, lsl #32
; CHECK-FAST-NEXT:  LBB2_1: ; %for.body8
; CHECK-FAST-NEXT:    ; =>This Inner Loop Header: Depth=1
; CHECK-FAST-NEXT:    cmp x8, x9
; CHECK-FAST-NEXT:    b.lt LBB2_1
; CHECK-FAST-NEXT:  ; %bb.2: ; %for.end20
; CHECK-FAST-NEXT:    ret
entry:
  br label %for.body
for.body:
  br i1 undef, label %for.body, label %for.body8
for.body8:
  %0 = mul i64 undef, -3
  %mul1971 = add i64 %0, -3
  %cmp7 = icmp slt i64 %mul1971, 1390451930000
  br i1 %cmp7, label %for.body8, label %for.end20
for.end20:
  ret void
}

define i32 @add1_mul_val1(i32 %a, i32 %b) {
; CHECK-ISEL-LABEL: add1_mul_val1:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    madd w0, w1, w0, w1
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: add1_mul_val1:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    add w8, w0, #1
; CHECK-FAST-NEXT:    mul w0, w8, w1
; CHECK-FAST-NEXT:    ret
  %1 = add i32 %a, 1
  %2 = mul i32 %1, %b
  ret i32 %2
}

define i32 @add1_mul_val2(i32 %a, i32 %b) {
; CHECK-ISEL-LABEL: add1_mul_val2:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    madd w0, w0, w1, w0
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: add1_mul_val2:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    add w8, w1, #1
; CHECK-FAST-NEXT:    mul w0, w0, w8
; CHECK-FAST-NEXT:    ret
  %1 = add i32 %b, 1
  %2 = mul i32 %a, %1
  ret i32 %2
}

define i64 @add1_mul_val3(i64 %a, i64 %b) {
; CHECK-ISEL-LABEL: add1_mul_val3:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    madd x0, x0, x1, x0
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: add1_mul_val3:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    add x8, x1, #1
; CHECK-FAST-NEXT:    mul x0, x0, x8
; CHECK-FAST-NEXT:    ret
  %1 = add i64 %b, 1
  %2 = mul i64 %a, %1
  ret i64 %2
}

define i64 @add1_mul_val4(i64 %a, i64 %b, i64 %c) {
; CHECK-ISEL-LABEL: add1_mul_val4:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    add x8, x0, x2
; CHECK-ISEL-NEXT:    madd x0, x8, x1, x8
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: add1_mul_val4:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    add x8, x1, #1
; CHECK-FAST-NEXT:    add x9, x0, x2
; CHECK-FAST-NEXT:    mul x0, x9, x8
; CHECK-FAST-NEXT:    ret
  %1 = add i64 %a, %c
  %2 = add i64 %b, 1
  %3 = mul i64 %1, %2
  ret i64 %3
}

define i32 @sub1_mul_val1(i32 %a, i32 %b) {
; CHECK-ISEL-LABEL: sub1_mul_val1:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    msub w0, w1, w0, w1
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: sub1_mul_val1:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    mov w8, #1
; CHECK-FAST-NEXT:    sub w8, w8, w0
; CHECK-FAST-NEXT:    mul w0, w8, w1
; CHECK-FAST-NEXT:    ret
  %1 = sub i32 1, %a
  %2 = mul i32 %1, %b
  ret i32 %2
}

define i32 @sub1_mul_val2(i32 %a, i32 %b) {
; CHECK-ISEL-LABEL: sub1_mul_val2:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    msub w0, w0, w1, w0
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: sub1_mul_val2:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    mov w8, #1
; CHECK-FAST-NEXT:    sub w8, w8, w1
; CHECK-FAST-NEXT:    mul w0, w0, w8
; CHECK-FAST-NEXT:    ret
  %1 = sub i32 1, %b
  %2 = mul i32 %a, %1
  ret i32 %2
}

define i64 @sub1_mul_val3(i64 %a, i64 %b) {
; CHECK-ISEL-LABEL: sub1_mul_val3:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    msub x0, x0, x1, x0
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: sub1_mul_val3:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    mov x8, #1
; CHECK-FAST-NEXT:    sub x8, x8, x1
; CHECK-FAST-NEXT:    mul x0, x0, x8
; CHECK-FAST-NEXT:    ret
  %1 = sub i64 1, %b
  %2 = mul i64 %a, %1
  ret i64 %2
}

define i64 @sub1_mul_val4(i64 %a, i64 %b) {
; CHECK-ISEL-LABEL: sub1_mul_val4:
; CHECK-ISEL:       ; %bb.0:
; CHECK-ISEL-NEXT:    sub x8, x0, #1
; CHECK-ISEL-NEXT:    msub x0, x8, x1, x8
; CHECK-ISEL-NEXT:    ret
;
; CHECK-FAST-LABEL: sub1_mul_val4:
; CHECK-FAST:       ; %bb.0:
; CHECK-FAST-NEXT:    mov x8, #1
; CHECK-FAST-NEXT:    sub x9, x0, #1
; CHECK-FAST-NEXT:    sub x8, x8, x1
; CHECK-FAST-NEXT:    mul x0, x9, x8
; CHECK-FAST-NEXT:    ret
  %1 = sub i64 %a, 1
  %2 = sub i64 1, %b
  %3 = mul i64 %1, %2
  ret i64 %3
}

