// RUN: llvm-mc -arch=amdgcn -show-encoding -mcpu=gfx1200 %s | FileCheck --check-prefix=GFX12 %s

//===----------------------------------------------------------------------===//
// ENC_SMEM.
//===----------------------------------------------------------------------===//

s_prefetch_inst s[12:13], 16, s4, 2
// GFX12: s_prefetch_inst s[12:13], 0x10, s4, 2   ; encoding: [0x86,0x80,0x04,0xf4,0x10,0x00,0x00,0x08]

s_prefetch_inst s[14:15], 0, m0, 7
// GFX12: s_prefetch_inst s[14:15], 0x0, m0, 7    ; encoding: [0xc7,0x81,0x04,0xf4,0x00,0x00,0x00,0xfa]

s_prefetch_inst s[14:15], 0x7fffff, m0, 7
// GFX12: s_prefetch_inst s[14:15], 0x7fffff, m0, 7 ; encoding: [0xc7,0x81,0x04,0xf4,0xff,0xff,0x7f,0xfa]

s_prefetch_inst s[14:15], -1, m0, 7
// GFX12: s_prefetch_inst s[14:15], -0x1, m0, 7   ; encoding: [0xc7,0x81,0x04,0xf4,0xff,0xff,0xff,0xfa]

s_prefetch_inst s[14:15], 100, m0, 31
// GFX12: s_prefetch_inst s[14:15], 0x64, m0, 31  ; encoding: [0xc7,0x87,0x04,0xf4,0x64,0x00,0x00,0xfa]

s_prefetch_inst_pc_rel 100, s10, 7
// GFX12: s_prefetch_inst_pc_rel 0x64, s10, 7   ; encoding: [0xc0,0xa1,0x04,0xf4,0x64,0x00,0x00,0x14]

s_prefetch_data s[18:19], 100, s10, 7
// GFX12: s_prefetch_data s[18:19], 0x64, s10, 7  ; encoding: [0xc9,0xc1,0x04,0xf4,0x64,0x00,0x00,0x14]

s_prefetch_data_pc_rel 100, s10, 7
// GFX12: s_prefetch_data_pc_rel 0x64, s10, 7   ; encoding: [0xc0,0x01,0x05,0xf4,0x64,0x00,0x00,0x14]

s_buffer_prefetch_data s[20:23], 100, s10, 7
// GFX12: s_buffer_prefetch_data s[20:23], 0x64, s10, 7 ; encoding: [0xca,0xe1,0x04,0xf4,0x64,0x00,0x00,0x14]

s_buffer_prefetch_data s[20:23], 100, null, 7
// GFX12: s_buffer_prefetch_data s[20:23], 0x64, null, 7 ; encoding: [0xca,0xe1,0x04,0xf4,0x64,0x00,0x00,0xf8]

s_load_i8 s5, s[2:3], s0
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s101, s[2:3], s0
// GFX12: encoding: [0x41,0x19,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 vcc_lo, s[2:3], s0
// GFX12: encoding: [0x81,0x1a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 vcc_hi, s[2:3], s0
// GFX12: encoding: [0xc1,0x1a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[4:5], s0
// GFX12: encoding: [0x42,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[100:101], s0
// GFX12: encoding: [0x72,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, vcc, s0
// GFX12: encoding: [0x75,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s101
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0xca]

s_load_i8 s5, s[2:3], vcc_lo
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0xd4]

s_load_i8 s5, s[2:3], vcc_hi
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0xd6]

s_load_i8 s5, s[2:3], m0
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0xfa]

s_load_i8 s5, s[2:3], 0x0
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0xf8]

s_load_i8 s5, s[2:3], s7 offset:0x12345
// GFX12: encoding: [0x41,0x01,0x01,0xf4,0x45,0x23,0x01,0x0e]

s_load_u8 s5, s[2:3], s0
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0
// GFX12: encoding: [0x41,0x39,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 vcc_lo, s[2:3], s0
// GFX12: encoding: [0x81,0x3a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 vcc_hi, s[2:3], s0
// GFX12: encoding: [0xc1,0x3a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s5, s[4:5], s0
// GFX12: encoding: [0x42,0x21,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s5, s[100:101], s0
// GFX12: encoding: [0x72,0x21,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s5, vcc, s0
// GFX12: encoding: [0x75,0x21,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s5, s[2:3], s101
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0xca]

s_load_u8 s5, s[2:3], vcc_lo
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0xd4]

s_load_u8 s5, s[2:3], vcc_hi
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0xd6]

s_load_u8 s5, s[2:3], m0
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0xfa]

s_load_u8 s5, s[2:3], 0x0
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x00,0x00,0x00,0xf8]

s_load_u8 s5, s[2:3], s7 offset:0x12345
// GFX12: encoding: [0x41,0x21,0x01,0xf4,0x45,0x23,0x01,0x0e]

s_buffer_load_i8 s5, s[4:7], s0
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 s101, s[4:7], s0
// GFX12: encoding: [0x42,0x19,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0
// GFX12: encoding: [0x82,0x1a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_hi, s[4:7], s0
// GFX12: encoding: [0xc2,0x1a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 s5, s[8:11], s0
// GFX12: encoding: [0x44,0x01,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 s5, s[96:99], s0
// GFX12: encoding: [0x70,0x01,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 s5, s[4:7], s101
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_i8 s5, s[4:7], vcc_lo
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_i8 s5, s[4:7], vcc_hi
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_i8 s5, s[4:7], m0
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_i8 s5, s[4:7], 0x0
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_i8 s5, s[4:7], s0 offset:0x12345
// GFX12: encoding: [0x42,0x01,0x03,0xf4,0x45,0x23,0x01,0x00]

s_buffer_load_u8 s5, s[4:7], s0
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s101, s[4:7], s0
// GFX12: encoding: [0x42,0x39,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 vcc_lo, s[4:7], s0
// GFX12: encoding: [0x82,0x3a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 vcc_hi, s[4:7], s0
// GFX12: encoding: [0xc2,0x3a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0
// GFX12: encoding: [0x44,0x21,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[96:99], s0
// GFX12: encoding: [0x70,0x21,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[4:7], s101
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_u8 s5, s[4:7], vcc_lo
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_u8 s5, s[4:7], vcc_hi
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_u8 s5, s[4:7], m0
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_u8 s5, s[4:7], 0x0
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_u8 s5, s[4:7], s0 offset:0x12345
// GFX12: encoding: [0x42,0x21,0x03,0xf4,0x45,0x23,0x01,0x00]

s_load_i16 s5, s[2:3], s0
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s101, s[2:3], s0
// GFX12: encoding: [0x41,0x59,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 vcc_lo, s[2:3], s0
// GFX12: encoding: [0x81,0x5a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 vcc_hi, s[2:3], s0
// GFX12: encoding: [0xc1,0x5a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[4:5], s0
// GFX12: encoding: [0x42,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0
// GFX12: encoding: [0x72,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, vcc, s0
// GFX12: encoding: [0x75,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[2:3], s101
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0xca]

s_load_i16 s5, s[2:3], vcc_lo
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0xd4]

s_load_i16 s5, s[2:3], vcc_hi
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0xd6]

s_load_i16 s5, s[2:3], m0
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0xfa]

s_load_i16 s5, s[2:3], 0x0
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0xf8]

s_load_i16 s5, s[2:3], s7 offset:0x12345
// GFX12: encoding: [0x41,0x41,0x01,0xf4,0x45,0x23,0x01,0x0e]

s_load_u16 s5, s[2:3], s0
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s101, s[2:3], s0
// GFX12: encoding: [0x41,0x79,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 vcc_lo, s[2:3], s0
// GFX12: encoding: [0x81,0x7a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 vcc_hi, s[2:3], s0
// GFX12: encoding: [0xc1,0x7a,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, s[4:5], s0
// GFX12: encoding: [0x42,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, s[100:101], s0
// GFX12: encoding: [0x72,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0
// GFX12: encoding: [0x75,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, s[2:3], s101
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0xca]

s_load_u16 s5, s[2:3], vcc_lo
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0xd4]

s_load_u16 s5, s[2:3], vcc_hi
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0xd6]

s_load_u16 s5, s[2:3], m0
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0xfa]

s_load_u16 s5, s[2:3], 0x0
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x00,0x00,0x00,0xf8]

s_load_u16 s5, s[2:3], s7 offset:0x12345
// GFX12: encoding: [0x41,0x61,0x01,0xf4,0x45,0x23,0x01,0x0e]

s_buffer_load_i16 s5, s[4:7], s0
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 s101, s[4:7], s0
// GFX12: encoding: [0x42,0x59,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_lo, s[4:7], s0
// GFX12: encoding: [0x82,0x5a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0
// GFX12: encoding: [0xc2,0x5a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 s5, s[8:11], s0
// GFX12: encoding: [0x44,0x41,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 s5, s[96:99], s0
// GFX12: encoding: [0x70,0x41,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 s5, s[4:7], s101
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_i16 s5, s[4:7], vcc_lo
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_i16 s5, s[4:7], vcc_hi
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_i16 s5, s[4:7], m0
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_i16 s5, s[4:7], 0x0
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_i16 s5, s[4:7], s0 offset:0x12345
// GFX12: encoding: [0x42,0x41,0x03,0xf4,0x45,0x23,0x01,0x00]

s_buffer_load_u16 s5, s[4:7], s0
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s101, s[4:7], s0
// GFX12: encoding: [0x42,0x79,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 vcc_lo, s[4:7], s0
// GFX12: encoding: [0x82,0x7a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 vcc_hi, s[4:7], s0
// GFX12: encoding: [0xc2,0x7a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[8:11], s0
// GFX12: encoding: [0x44,0x61,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0
// GFX12: encoding: [0x70,0x61,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[4:7], s101
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_u16 s5, s[4:7], vcc_lo
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_u16 s5, s[4:7], vcc_hi
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_u16 s5, s[4:7], m0
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_u16 s5, s[4:7], 0x0
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_u16 s5, s[4:7], s0 offset:0x12345
// GFX12: encoding: [0x42,0x61,0x03,0xf4,0x45,0x23,0x01,0x00]

s_load_b32 s5, s[2:3], s0
// GFX12: s_load_b32 s5, s[2:3], s0 offset:0x0    ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s101, s[2:3], s0
// GFX12: s_load_b32 s101, s[2:3], s0 offset:0x0  ; encoding: [0x41,0x19,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 vcc_lo, s[2:3], s0
// GFX12: s_load_b32 vcc_lo, s[2:3], s0 offset:0x0 ; encoding: [0x81,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 vcc_hi, s[2:3], s0
// GFX12: s_load_b32 vcc_hi, s[2:3], s0 offset:0x0 ; encoding: [0xc1,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0    ; encoding: [0x42,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[100:101], s0
// GFX12: s_load_b32 s5, s[100:101], s0 offset:0x0 ; encoding: [0x72,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, vcc, s0
// GFX12: s_load_b32 s5, vcc, s0 offset:0x0       ; encoding: [0x75,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[2:3], s101
// GFX12: s_load_b32 s5, s[2:3], s101 offset:0x0  ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b32 s5, s[2:3], vcc_lo
// GFX12: s_load_b32 s5, s[2:3], vcc_lo offset:0x0 ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b32 s5, s[2:3], vcc_hi
// GFX12: s_load_b32 s5, s[2:3], vcc_hi offset:0x0 ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b32 s5, s[2:3], m0
// GFX12: s_load_b32 s5, s[2:3], m0 offset:0x0    ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b32 s5, s[2:3], 0x0
// GFX12: s_load_b32 s5, s[2:3], 0x0              ; encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_b32 s5, s[2:3], s7 offset:0x12345
// GFX12: s_load_b32 s5, s[2:3], s7 offset:0x12345 ; encoding: [0x41,0x01,0x00,0xf4,0x45,0x23,0x01,0x0e]

s_load_b64 s[10:11], s[2:3], s0
// GFX12: s_load_b64 s[10:11], s[2:3], s0 offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[12:13], s[2:3], s0
// GFX12: s_load_b64 s[12:13], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x23,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[100:101], s[2:3], s0
// GFX12: s_load_b64 s[100:101], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x39,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 vcc, s[2:3], s0
// GFX12: s_load_b64 vcc, s[2:3], s0 offset:0x0   ; encoding: [0x81,0x3a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[10:11], s[4:5], s0
// GFX12: s_load_b64 s[10:11], s[4:5], s0 offset:0x0 ; encoding: [0x82,0x22,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[10:11], s[100:101], s0
// GFX12: s_load_b64 s[10:11], s[100:101], s0 offset:0x0 ; encoding: [0xb2,0x22,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[10:11], vcc, s0
// GFX12: s_load_b64 s[10:11], vcc, s0 offset:0x0 ; encoding: [0xb5,0x22,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b64 s[10:11], s[2:3], s101
// GFX12: s_load_b64 s[10:11], s[2:3], s101 offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b64 s[10:11], s[2:3], vcc_lo
// GFX12: s_load_b64 s[10:11], s[2:3], vcc_lo offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b64 s[10:11], s[2:3], vcc_hi
// GFX12: s_load_b64 s[10:11], s[2:3], vcc_hi offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b64 s[10:11], s[2:3], m0
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], 0x0
// GFX12: s_load_b64 s[10:11], s[2:3], 0x0        ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_b96 s[20:22], s[2:3], s0
// GFX12: s_load_b96 s[20:22], s[2:3], s0 offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[24:26], s[2:3], s0
// GFX12: s_load_b96 s[24:26], s[2:3], s0 offset:0x0 ; encoding: [0x01,0xa6,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[96:98], s[2:3], s0
// GFX12: s_load_b96 s[96:98], s[2:3], s0 offset:0x0 ; encoding: [0x01,0xb8,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[20:22], s[4:5], s0
// GFX12: s_load_b96 s[20:22], s[4:5], s0 offset:0x0 ; encoding: [0x02,0xa5,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[20:22], s[100:101], s0
// GFX12: s_load_b96 s[20:22], s[100:101], s0 offset:0x0 ; encoding: [0x32,0xa5,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[20:22], vcc, s0
// GFX12: s_load_b96 s[20:22], vcc, s0 offset:0x0 ; encoding: [0x35,0xa5,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b96 s[20:22], s[2:3], s101
// GFX12: s_load_b96 s[20:22], s[2:3], s101 offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b96 s[20:22], s[2:3], vcc_lo
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_hi
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_hi offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b96 s[20:22], s[2:3], m0
// GFX12: s_load_b96 s[20:22], s[2:3], m0 offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b96 s[20:22], s[2:3], 0x0
// GFX12: s_load_b96 s[20:22], s[2:3], 0x0       ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_b128 s[20:23], s[2:3], s0
// GFX12: s_load_b128 s[20:23], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[24:27], s[2:3], s0
// GFX12: s_load_b128 s[24:27], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x46,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[96:99], s[2:3], s0
// GFX12: s_load_b128 s[96:99], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x58,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[20:23], s[4:5], s0
// GFX12: s_load_b128 s[20:23], s[4:5], s0 offset:0x0 ; encoding: [0x02,0x45,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[20:23], s[100:101], s0
// GFX12: s_load_b128 s[20:23], s[100:101], s0 offset:0x0 ; encoding: [0x32,0x45,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[20:23], vcc, s0
// GFX12: s_load_b128 s[20:23], vcc, s0 offset:0x0 ; encoding: [0x35,0x45,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b128 s[20:23], s[2:3], s101
// GFX12: s_load_b128 s[20:23], s[2:3], s101 offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b128 s[20:23], s[2:3], vcc_lo
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_hi
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_hi offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b128 s[20:23], s[2:3], m0
// GFX12: s_load_b128 s[20:23], s[2:3], m0 offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b128 s[20:23], s[2:3], 0x0
// GFX12: s_load_b128 s[20:23], s[2:3], 0x0       ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_b256 s[20:27], s[2:3], s0
// GFX12: s_load_b256 s[20:27], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[24:31], s[2:3], s0
// GFX12: s_load_b256 s[24:31], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x66,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x77,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[20:27], s[4:5], s0
// GFX12: s_load_b256 s[20:27], s[4:5], s0 offset:0x0 ; encoding: [0x02,0x65,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[20:27], s[100:101], s0
// GFX12: s_load_b256 s[20:27], s[100:101], s0 offset:0x0 ; encoding: [0x32,0x65,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[20:27], vcc, s0
// GFX12: s_load_b256 s[20:27], vcc, s0 offset:0x0 ; encoding: [0x35,0x65,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[20:27], s[2:3], s101
// GFX12: s_load_b256 s[20:27], s[2:3], s101 offset:0x0 ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b256 s[20:27], s[2:3], vcc_lo
// GFX12: s_load_b256 s[20:27], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b256 s[20:27], s[2:3], vcc_hi
// GFX12: s_load_b256 s[20:27], s[2:3], vcc_hi offset:0x0 ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b256 s[20:27], s[2:3], m0
// GFX12: s_load_b256 s[20:27], s[2:3], m0 offset:0x0 ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b256 s[20:27], s[2:3], 0x0
// GFX12: s_load_b256 s[20:27], s[2:3], 0x0       ; encoding: [0x01,0x65,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_b512 s[20:35], s[2:3], s0
// GFX12: s_load_b512 s[20:35], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[24:39], s[2:3], s0
// GFX12: s_load_b512 s[24:39], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x86,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[84:99], s[2:3], s0
// GFX12: s_load_b512 s[84:99], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x95,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 ; encoding: [0x02,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[100:101], s0
// GFX12: s_load_b512 s[20:35], s[100:101], s0 offset:0x0 ; encoding: [0x32,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], vcc, s0
// GFX12: s_load_b512 s[20:35], vcc, s0 offset:0x0 ; encoding: [0x35,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[2:3], s101
// GFX12: s_load_b512 s[20:35], s[2:3], s101 offset:0x0 ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_b512 s[20:35], s[2:3], vcc_lo
// GFX12: s_load_b512 s[20:35], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b512 s[20:35], s[2:3], vcc_hi
// GFX12: s_load_b512 s[20:35], s[2:3], vcc_hi offset:0x0 ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_b512 s[20:35], s[2:3], m0
// GFX12: s_load_b512 s[20:35], s[2:3], m0 offset:0x0 ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b512 s[20:35], s[2:3], 0x0
// GFX12: s_load_b512 s[20:35], s[2:3], 0x0       ; encoding: [0x01,0x85,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b32 s5, s[4:7], s0
// GFX12: s_buffer_load_b32 s5, s[4:7], s0 offset:0x0 ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s101, s[4:7], s0
// GFX12: s_buffer_load_b32 s101, s[4:7], s0 offset:0x0 ; encoding: [0x42,0x19,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 vcc_lo, s[4:7], s0
// GFX12: s_buffer_load_b32 vcc_lo, s[4:7], s0 offset:0x0 ; encoding: [0x82,0x1a,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 vcc_hi, s[4:7], s0
// GFX12: s_buffer_load_b32 vcc_hi, s[4:7], s0 offset:0x0 ; encoding: [0xc2,0x1a,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[8:11], s0
// GFX12: s_buffer_load_b32 s5, s[8:11], s0 offset:0x0 ; encoding: [0x44,0x01,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 ; encoding: [0x70,0x01,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[4:7], s101
// GFX12: s_buffer_load_b32 s5, s[4:7], s101 offset:0x0 ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b32 s5, s[4:7], vcc_lo
// GFX12: s_buffer_load_b32 s5, s[4:7], vcc_lo offset:0x0 ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b32 s5, s[4:7], vcc_hi
// GFX12: s_buffer_load_b32 s5, s[4:7], vcc_hi offset:0x0 ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b32 s5, s[4:7], m0
// GFX12: s_buffer_load_b32 s5, s[4:7], m0 offset:0x0 ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b32 s5, s[4:7], 0x0
// GFX12: s_buffer_load_b32 s5, s[4:7], 0x0       ; encoding: [0x42,0x01,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b64 s[10:11], s[4:7], s0
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[12:13], s[4:7], s0
// GFX12: s_buffer_load_b64 s[12:13], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x23,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[100:101], s[4:7], s0
// GFX12: s_buffer_load_b64 s[100:101], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x39,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 vcc, s[4:7], s0
// GFX12: s_buffer_load_b64 vcc, s[4:7], s0 offset:0x0 ; encoding: [0x82,0x3a,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[8:11], s0
// GFX12: s_buffer_load_b64 s[10:11], s[8:11], s0 offset:0x0 ; encoding: [0x84,0x22,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[96:99], s0
// GFX12: s_buffer_load_b64 s[10:11], s[96:99], s0 offset:0x0 ; encoding: [0xb0,0x22,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s101
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s101 offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b64 s[10:11], s[4:7], vcc_lo
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], vcc_lo offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b64 s[10:11], s[4:7], vcc_hi
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], vcc_hi offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b64 s[10:11], s[4:7], m0
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], m0 offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b64 s[10:11], s[4:7], 0x0
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], 0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b96 s[20:22], s[4:7], s0
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], s0 offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[24:26], s[4:7], s0
// GFX12: s_buffer_load_b96 s[24:26], s[4:7], s0 offset:0x0 ; encoding: [0x02,0xa6,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[96:98], s[4:7], s0
// GFX12: s_buffer_load_b96 s[96:98], s[4:7], s0 offset:0x0 ; encoding: [0x02,0xb8,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[20:22], s[8:11], s0
// GFX12: s_buffer_load_b96 s[20:22], s[8:11], s0 offset:0x0 ; encoding: [0x04,0xa5,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[20:22], s[96:99], s0
// GFX12: s_buffer_load_b96 s[20:22], s[96:99], s0 offset:0x0 ; encoding: [0x30,0xa5,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[20:22], s[4:7], s101
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], s101 offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_hi
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_hi offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b96 s[20:22], s[4:7], m0
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], m0 offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b96 s[20:22], s[4:7], 0x0
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], 0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b128 s[20:23], s[4:7], s0
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b128 s[24:27], s[4:7], s0
// GFX12: s_buffer_load_b128 s[24:27], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x46,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b128 s[96:99], s[4:7], s0
// GFX12: s_buffer_load_b128 s[96:99], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x58,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b128 s[20:23], s[8:11], s0
// GFX12: s_buffer_load_b128 s[20:23], s[8:11], s0 offset:0x0 ; encoding: [0x04,0x45,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b128 s[20:23], s[96:99], s0
// GFX12: s_buffer_load_b128 s[20:23], s[96:99], s0 offset:0x0 ; encoding: [0x30,0x45,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b128 s[20:23], s[4:7], s101
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], s101 offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_hi
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_hi offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b128 s[20:23], s[4:7], m0
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], m0 offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b128 s[20:23], s[4:7], 0x0
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], 0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b256 s[20:27], s[4:7], s0
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[24:31], s[4:7], s0
// GFX12: s_buffer_load_b256 s[24:31], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x66,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[92:99], s[4:7], s0
// GFX12: s_buffer_load_b256 s[92:99], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x77,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 ; encoding: [0x04,0x65,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[96:99], s0
// GFX12: s_buffer_load_b256 s[20:27], s[96:99], s0 offset:0x0 ; encoding: [0x30,0x65,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[4:7], s101
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], s101 offset:0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b256 s[20:27], s[4:7], vcc_lo
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b256 s[20:27], s[4:7], vcc_hi
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], vcc_hi offset:0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b256 s[20:27], s[4:7], m0
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], m0 offset:0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b256 s[20:27], s[4:7], 0x0
// GFX12: s_buffer_load_b256 s[20:27], s[4:7], 0x0 ; encoding: [0x02,0x65,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_b512 s[20:35], s[4:7], s0
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[24:39], s[4:7], s0
// GFX12: s_buffer_load_b512 s[24:39], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x86,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[84:99], s[4:7], s0
// GFX12: s_buffer_load_b512 s[84:99], s[4:7], s0 offset:0x0 ; encoding: [0x02,0x95,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[8:11], s0
// GFX12: s_buffer_load_b512 s[20:35], s[8:11], s0 offset:0x0 ; encoding: [0x04,0x85,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 ; encoding: [0x30,0x85,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[4:7], s101
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], s101 offset:0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_b512 s[20:35], s[4:7], vcc_lo
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b512 s[20:35], s[4:7], vcc_hi
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], vcc_hi offset:0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_b512 s[20:35], s[4:7], m0
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], m0 offset:0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_b512 s[20:35], s[4:7], 0x0
// GFX12: s_buffer_load_b512 s[20:35], s[4:7], 0x0 ; encoding: [0x02,0x85,0x02,0xf4,0x00,0x00,0x00,0xf8]

s_dcache_inv
// GFX12: s_dcache_inv                            ; encoding: [0x00,0x20,0x04,0xf4,0x00,0x00,0x00,0x00]

s_atc_probe 7, s[4:5], s2
// GFX12: encoding: [0xc2,0x41,0x04,0xf4,0x00,0x00,0x00,0x04]

s_atc_probe 7, s[4:5], 0x64
// GFX12: encoding: [0xc2,0x41,0x04,0xf4,0x64,0x00,0x00,0xf8]

s_atc_probe 7, s[4:5], s9 offset:0x64
// GFX12: encoding: [0xc2,0x41,0x04,0xf4,0x64,0x00,0x00,0x12]

s_atc_probe_buffer 7, s[8:11], s2
// GFX12: encoding: [0xc4,0x61,0x04,0xf4,0x00,0x00,0x00,0x04]

s_atc_probe_buffer 7, s[8:11], 0x64
// GFX12: encoding: [0xc4,0x61,0x04,0xf4,0x64,0x00,0x00,0xf8]

s_atc_probe_buffer 7, s[8:11], s9 offset:0x64
// GFX12: encoding: [0xc4,0x61,0x04,0xf4,0x64,0x00,0x00,0x12]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 ; encoding: [0x42,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x42,0x01,0x80,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x42,0x01,0x00,0xf5,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x42,0x01,0x80,0xf5,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0    ; encoding: [0x42,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x42,0x01,0x40,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x42,0x01,0x60,0xf4,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x42,0x01,0x20,0xf5,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x42,0x01,0xa0,0xf5,0x00,0x00,0x00,0x00]

s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b32 s5, s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x42,0x01,0x60,0xf5,0x00,0x00,0x00,0x00]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x81,0x22,0x80,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x81,0x22,0x00,0xf5,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x81,0x22,0x80,0xf5,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 ; encoding: [0x81,0x22,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_SE ; encoding: [0x81,0x22,0x20,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x81,0x22,0x40,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x81,0x22,0x60,0xf4,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x81,0x22,0x20,0xf5,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x81,0x22,0xa0,0xf5,0x00,0x00,0x00,0xfa]

s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b64 s[10:11], s[2:3], m0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x81,0x22,0x60,0xf5,0x00,0x00,0x00,0xfa]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_NT ; encoding: [0x01,0xa5,0x80,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT ; encoding: [0x01,0xa5,0x00,0xf5,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU ; encoding: [0x01,0xa5,0x80,0xf5,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0xa5,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SE ; encoding: [0x01,0xa5,0x20,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_DEV ; encoding: [0x01,0xa5,0x40,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SYS ; encoding: [0x01,0xa5,0x60,0xf4,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x01,0xa5,0x20,0xf5,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x01,0xa5,0xa0,0xf5,0x00,0x00,0x00,0xd4]

s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b96 s[20:22], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x01,0xa5,0x60,0xf5,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_NT ; encoding: [0x01,0x45,0x80,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT ; encoding: [0x01,0x45,0x00,0xf5,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU ; encoding: [0x01,0x45,0x80,0xf5,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 ; encoding: [0x01,0x45,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SE ; encoding: [0x01,0x45,0x20,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_DEV ; encoding: [0x01,0x45,0x40,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 scope:SCOPE_SYS ; encoding: [0x01,0x45,0x60,0xf4,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x01,0x45,0x20,0xf5,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x01,0x45,0xa0,0xf5,0x00,0x00,0x00,0xd4]

s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b128 s[20:23], s[2:3], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x01,0x45,0x60,0xf5,0x00,0x00,0x00,0xd4]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x77,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x01,0x77,0x80,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x01,0x77,0x00,0xf5,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x01,0x77,0x80,0xf5,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 ; encoding: [0x01,0x77,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x01,0x77,0x20,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x01,0x77,0x40,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x01,0x77,0x60,0xf4,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x01,0x77,0x20,0xf5,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x01,0x77,0xa0,0xf5,0x00,0x00,0x00,0x00]

s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b256 s[92:99], s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x01,0x77,0x60,0xf5,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 ; encoding: [0x02,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x02,0x85,0x80,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x02,0x85,0x00,0xf5,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x02,0x85,0x80,0xf5,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 ; encoding: [0x02,0x85,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x02,0x85,0x20,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x02,0x85,0x40,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x02,0x85,0x60,0xf4,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x02,0x85,0x20,0xf5,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x02,0x85,0xa0,0xf5,0x00,0x00,0x00,0x00]

s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_b512 s[20:35], s[4:5], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x02,0x85,0x60,0xf5,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0     ; encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x41,0x01,0x81,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x41,0x01,0x01,0xf5,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x41,0x01,0x81,0xf5,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0     ; encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x41,0x01,0x21,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x41,0x01,0x41,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x41,0x01,0x61,0xf4,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x41,0x01,0x21,0xf5,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x41,0x01,0xa1,0xf5,0x00,0x00,0x00,0x00]

s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_i8 s5, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x41,0x01,0x61,0xf5,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0   ; encoding: [0x41,0x39,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x41,0x39,0x81,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x41,0x39,0x01,0xf5,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x41,0x39,0x81,0xf5,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0   ; encoding: [0x41,0x39,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x41,0x39,0x21,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x41,0x39,0x41,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x41,0x39,0x61,0xf4,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x41,0x39,0x21,0xf5,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x41,0x39,0xa1,0xf5,0x00,0x00,0x00,0x00]

s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_u8 s101, s[2:3], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x41,0x39,0x61,0xf5,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 ; encoding: [0x72,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x72,0x41,0x81,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x72,0x41,0x01,0xf5,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x72,0x41,0x81,0xf5,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 ; encoding: [0x72,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x72,0x41,0x21,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x72,0x41,0x41,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x72,0x41,0x61,0xf4,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x72,0x41,0x21,0xf5,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x72,0x41,0xa1,0xf5,0x00,0x00,0x00,0x00]

s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_i16 s5, s[100:101], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x72,0x41,0x61,0xf5,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0       ; encoding: [0x75,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x75,0x61,0x81,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x75,0x61,0x01,0xf5,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x75,0x61,0x81,0xf5,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0       ; encoding: [0x75,0x61,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x75,0x61,0x21,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x75,0x61,0x41,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x75,0x61,0x61,0xf4,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x75,0x61,0x21,0xf5,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x75,0x61,0xa1,0xf5,0x00,0x00,0x00,0x00]

s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_load_u16 s5, vcc, s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x75,0x61,0x61,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 ; encoding: [0x70,0x01,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x70,0x01,0x82,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x70,0x01,0x02,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x70,0x01,0x82,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 ; encoding: [0x70,0x01,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x70,0x01,0x22,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x70,0x01,0x42,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x70,0x01,0x62,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x70,0x01,0x22,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x70,0x01,0xa2,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b32 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x70,0x01,0x62,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x82,0x22,0x82,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x82,0x22,0x02,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x82,0x22,0x82,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 ; encoding: [0x82,0x22,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x82,0x22,0x22,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x82,0x22,0x42,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x82,0x22,0x62,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x82,0x22,0x22,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x82,0x22,0xa2,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b64 s[10:11], s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x82,0x22,0x62,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_NT ; encoding: [0x02,0xa5,0x82,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT ; encoding: [0x02,0xa5,0x02,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU ; encoding: [0x02,0xa5,0x82,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0xa5,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SE ; encoding: [0x02,0xa5,0x22,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_DEV ; encoding: [0x02,0xa5,0x42,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SYS ; encoding: [0x02,0xa5,0x62,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x02,0xa5,0x22,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x02,0xa5,0xa2,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b96 s[20:22], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x02,0xa5,0x62,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_NT ; encoding: [0x02,0x45,0x82,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT ; encoding: [0x02,0x45,0x02,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU ; encoding: [0x02,0x45,0x82,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 ; encoding: [0x02,0x45,0x02,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SE ; encoding: [0x02,0x45,0x22,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_DEV ; encoding: [0x02,0x45,0x42,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 scope:SCOPE_SYS ; encoding: [0x02,0x45,0x62,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x02,0x45,0x22,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x02,0x45,0xa2,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b128 s[20:23], s[4:7], vcc_lo offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x02,0x45,0x62,0xf5,0x00,0x00,0x00,0xd4]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 ; encoding: [0x04,0x65,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x04,0x65,0x82,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x04,0x65,0x02,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x04,0x65,0x82,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 ; encoding: [0x04,0x65,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x04,0x65,0x22,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x04,0x65,0x42,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x04,0x65,0x62,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x04,0x65,0x22,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x04,0x65,0xa2,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b256 s[20:27], s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x04,0x65,0x62,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 ; encoding: [0x30,0x85,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x30,0x85,0x82,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x30,0x85,0x02,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x30,0x85,0x82,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 ; encoding: [0x30,0x85,0x02,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x30,0x85,0x22,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x30,0x85,0x42,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x30,0x85,0x62,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x30,0x85,0x22,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x30,0x85,0xa2,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_b512 s[20:35], s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x30,0x85,0x62,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 ; encoding: [0x82,0x1a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x82,0x1a,0x83,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x82,0x1a,0x03,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x82,0x1a,0x83,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 ; encoding: [0x82,0x1a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x82,0x1a,0x23,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x82,0x1a,0x43,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x82,0x1a,0x63,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x82,0x1a,0x23,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x82,0x1a,0xa3,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_i8 vcc_lo, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x82,0x1a,0x63,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 ; encoding: [0x44,0x21,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x44,0x21,0x83,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x44,0x21,0x03,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x44,0x21,0x83,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 ; encoding: [0x44,0x21,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x44,0x21,0x23,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x44,0x21,0x43,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x44,0x21,0x63,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x44,0x21,0x23,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x44,0x21,0xa3,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_u8 s5, s[8:11], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x44,0x21,0x63,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 ; encoding: [0xc2,0x5a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0xc2,0x5a,0x83,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0xc2,0x5a,0x03,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0xc2,0x5a,0x83,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 ; encoding: [0xc2,0x5a,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0xc2,0x5a,0x23,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0xc2,0x5a,0x43,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0xc2,0x5a,0x63,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0xc2,0x5a,0x23,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0xc2,0x5a,0xa3,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_i16 vcc_hi, s[4:7], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0xc2,0x5a,0x63,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_RT
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 ; encoding: [0x70,0x61,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_NT
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_NT ; encoding: [0x70,0x61,0x83,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT ; encoding: [0x70,0x61,0x03,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU ; encoding: [0x70,0x61,0x83,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_CU
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 ; encoding: [0x70,0x61,0x03,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SE
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SE ; encoding: [0x70,0x61,0x23,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_DEV
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_DEV ; encoding: [0x70,0x61,0x43,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SYS
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 scope:SCOPE_SYS ; encoding: [0x70,0x61,0x63,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SE ; encoding: [0x70,0x61,0x23,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_LU scope:SCOPE_SE ; encoding: [0x70,0x61,0xa3,0xf5,0x00,0x00,0x00,0x00]

s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS
// GFX12: s_buffer_load_u16 s5, s[96:99], s0 offset:0x0 th:TH_LOAD_HT scope:SCOPE_SYS ; encoding: [0x70,0x61,0x63,0xf5,0x00,0x00,0x00,0x00]
