; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+fast-unaligned-access -target-abi=ilp32 \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+fast-unaligned-access -target-abi=lp64 \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

define void @constant_forward_stride(ptr %s, ptr %d) {
; CHECK-LABEL: constant_forward_stride:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 16
  %2 = getelementptr inbounds i8, ptr %s, i64 32
  %3 = getelementptr inbounds i8, ptr %s, i64 48
  %4 = load <2 x i8>, ptr %s, align 1
  %5 = load <2 x i8>, ptr %1, align 1
  %6 = load <2 x i8>, ptr %2, align 1
  %7 = load <2 x i8>, ptr %3, align 1
  %8 = shufflevector <2 x i8> %4, <2 x i8> %5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %9 = shufflevector <2 x i8> %6, <2 x i8> %7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %10 = shufflevector <4 x i8> %8, <4 x i8> %9, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %10, ptr %d, align 1
  ret void
}

define void @constant_forward_stride2(ptr %s, ptr %d) {
; CHECK-LABEL: constant_forward_stride2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, -48
; CHECK-NEXT:    li a2, 16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 -16
  %2 = getelementptr inbounds i8, ptr %s, i64 -32
  %3 = getelementptr inbounds i8, ptr %s, i64 -48
  %4 = load <2 x i8>, ptr %3, align 1
  %5 = load <2 x i8>, ptr %2, align 1
  %6 = load <2 x i8>, ptr %1, align 1
  %7 = load <2 x i8>, ptr %s, align 1
  %8 = shufflevector <2 x i8> %4, <2 x i8> %5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %9 = shufflevector <2 x i8> %6, <2 x i8> %7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %10 = shufflevector <4 x i8> %8, <4 x i8> %9, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %10, ptr %d, align 1
  ret void
}

define void @constant_forward_stride3(ptr %s, ptr %d) {
; CHECK-LABEL: constant_forward_stride3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 16
  %2 = getelementptr inbounds i8, ptr %s, i64 32
  %3 = getelementptr inbounds i8, ptr %s, i64 48
  %4 = getelementptr inbounds i8, ptr %1, i64 0
  %5 = getelementptr inbounds i8, ptr %2, i64 0
  %6 = getelementptr inbounds i8, ptr %3, i64 0
  %7 = load <2 x i8>, ptr %s, align 1
  %8 = load <2 x i8>, ptr %4, align 1
  %9 = load <2 x i8>, ptr %5, align 1
  %10 = load <2 x i8>, ptr %6, align 1
  %11 = shufflevector <2 x i8> %7, <2 x i8> %8, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %12 = shufflevector <2 x i8> %9, <2 x i8> %10, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %13 = shufflevector <4 x i8> %11, <4 x i8> %12, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %13, ptr %d, align 1
  ret void
}

define void @constant_back_stride(ptr %s, ptr %d) {
; CHECK-LABEL: constant_back_stride:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, -16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 -16
  %2 = getelementptr inbounds i8, ptr %s, i64 -32
  %3 = getelementptr inbounds i8, ptr %s, i64 -48
  %4 = load <2 x i8>, ptr %s, align 1
  %5 = load <2 x i8>, ptr %1, align 1
  %6 = load <2 x i8>, ptr %2, align 1
  %7 = load <2 x i8>, ptr %3, align 1
  %8 = shufflevector <2 x i8> %4, <2 x i8> %5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %9 = shufflevector <2 x i8> %6, <2 x i8> %7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %10 = shufflevector <4 x i8> %8, <4 x i8> %9, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %10, ptr %d, align 1
  ret void
}

define void @constant_back_stride2(ptr %s, ptr %d) {
; CHECK-LABEL: constant_back_stride2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a0, a0, 48
; CHECK-NEXT:    li a2, -16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 16
  %2 = getelementptr inbounds i8, ptr %s, i64 32
  %3 = getelementptr inbounds i8, ptr %s, i64 48
  %4 = load <2 x i8>, ptr %3, align 1
  %5 = load <2 x i8>, ptr %2, align 1
  %6 = load <2 x i8>, ptr %1, align 1
  %7 = load <2 x i8>, ptr %s, align 1
  %8 = shufflevector <2 x i8> %4, <2 x i8> %5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %9 = shufflevector <2 x i8> %6, <2 x i8> %7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %10 = shufflevector <4 x i8> %8, <4 x i8> %9, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %10, ptr %d, align 1
  ret void
}

define void @constant_back_stride3(ptr %s, ptr %d) {
; CHECK-LABEL: constant_back_stride3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, -16
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vlse16.v v8, (a0), a2
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 -16
  %2 = getelementptr inbounds i8, ptr %s, i64 -32
  %3 = getelementptr inbounds i8, ptr %s, i64 -48
  %4 = getelementptr inbounds i8, ptr %1, i64 0
  %5 = getelementptr inbounds i8, ptr %2, i64 0
  %6 = getelementptr inbounds i8, ptr %3, i64 0
  %7 = load <2 x i8>, ptr %s, align 1
  %8 = load <2 x i8>, ptr %4, align 1
  %9 = load <2 x i8>, ptr %5, align 1
  %10 = load <2 x i8>, ptr %6, align 1
  %11 = shufflevector <2 x i8> %7, <2 x i8> %8, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %12 = shufflevector <2 x i8> %9, <2 x i8> %10, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %13 = shufflevector <4 x i8> %11, <4 x i8> %12, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i8> %13, ptr %d, align 1
  ret void
}

define void @constant_zero_stride(ptr %s, ptr %d) {
; CHECK-LABEL: constant_zero_stride:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vslideup.vi v9, v8, 2
; CHECK-NEXT:    vse8.v v9, (a1)
; CHECK-NEXT:    ret
  %1 = getelementptr inbounds i8, ptr %s, i64 0
  %2 = load <2 x i8>, ptr %s, align 1
  %3 = load <2 x i8>, ptr %1, align 1
  %4 = shufflevector <2 x i8> %2, <2 x i8> %3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  store <4 x i8> %4, ptr %d, align 1
  ret void
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
