; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GISEL %s

define float @v_exp2_f32(float %src)  {
; GCN-LABEL: v_exp2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f32_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %exp2 = call float @llvm.amdgcn.exp2.f32(float %src)
  ret float %exp2
}

define float @v_fabs_exp2_f32(float %src)  {
; GCN-LABEL: v_fabs_exp2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f32_e64 v0, |v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call float @llvm.fabs.f32(float %src)
  %exp2 = call float @llvm.amdgcn.exp2.f32(float %fabs.src)
  ret float %exp2
}

define float @v_fneg_fabs_exp2_f32(float %src)  {
; GCN-LABEL: v_fneg_fabs_exp2_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f32_e64 v0, -|v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call float @llvm.fabs.f32(float %src)
  %neg.fabs.src = fneg float %fabs.src
  %exp2 = call float @llvm.amdgcn.exp2.f32(float %neg.fabs.src)
  ret float %exp2
}

define half @v_exp2_f16(half %src)  {
; GCN-LABEL: v_exp2_f16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f16_e32 v0, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %exp2 = call half @llvm.amdgcn.exp2.f16(half %src)
  ret half %exp2
}

define half @v_fabs_exp2_f16(half %src)  {
; GCN-LABEL: v_fabs_exp2_f16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f16_e64 v0, |v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call half @llvm.fabs.f16(half %src)
  %exp2 = call half @llvm.amdgcn.exp2.f16(half %fabs.src)
  ret half %exp2
}

define half @v_fneg_fabs_exp2_f16(half %src)  {
; GCN-LABEL: v_fneg_fabs_exp2_f16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_exp_f16_e64 v0, -|v0|
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %fabs.src = call half @llvm.fabs.f16(half %src)
  %neg.fabs.src = fneg half %fabs.src
  %exp2 = call half @llvm.amdgcn.exp2.f16(half %neg.fabs.src)
  ret half %exp2
}

declare half @llvm.amdgcn.exp2.f16(half) #0
declare float @llvm.amdgcn.exp2.f32(float) #0
declare float @llvm.fabs.f32(float) #0
declare half @llvm.fabs.f16(half) #0

attributes #0 = { nounwind readnone speculatable willreturn }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GISEL: {{.*}}
; SDAG: {{.*}}
