# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=alderlake -instruction-tables < %s | FileCheck %s

xgetbv

xrstor  (%rax)

xrstors (%rax)

xsave   (%rax)

xsetbv

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  23     4     5.00                  U     xgetbv
# CHECK-NEXT:  31     37    8.00    *      *      U     xrstor	(%rax)
# CHECK-NEXT:  31     37    8.00    *      *      U     xrstors	(%rax)
# CHECK-NEXT:  140    42    33.50   *      *      U     xsave	(%rax)
# CHECK-NEXT:  54     5     10.80   *      *      U     xsetbv

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ADLPPort00
# CHECK-NEXT: [1]   - ADLPPort01
# CHECK-NEXT: [2]   - ADLPPort02
# CHECK-NEXT: [3]   - ADLPPort03
# CHECK-NEXT: [4]   - ADLPPort04
# CHECK-NEXT: [5]   - ADLPPort05
# CHECK-NEXT: [6]   - ADLPPort06
# CHECK-NEXT: [7]   - ADLPPort07
# CHECK-NEXT: [8]   - ADLPPort08
# CHECK-NEXT: [9]   - ADLPPort09
# CHECK-NEXT: [10]  - ADLPPort10
# CHECK-NEXT: [11]  - ADLPPort11
# CHECK-NEXT: [12]  - ADLPPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 72.00  71.67  2.33   2.33   0.50   53.83  67.17  0.50   0.50   0.50   6.33   1.33    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT: 6.40   6.40    -      -      -     2.40   6.40    -      -      -     1.40    -      -     xgetbv
# CHECK-NEXT: 5.25   6.25   0.50   0.50    -     5.25   13.25   -      -      -      -      -      -     xrstor	(%rax)
# CHECK-NEXT: 5.25   6.25   0.50   0.50    -     5.25   13.25   -      -      -      -      -      -     xrstors	(%rax)
# CHECK-NEXT: 41.50  38.50  1.33   1.33   0.50   32.00  22.00  0.50   0.50   0.50    -     1.33    -     xsave	(%rax)
# CHECK-NEXT: 13.60  14.27   -      -      -     8.93   12.27   -      -      -     4.93    -      -     xsetbv
