; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx940 -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,FORCESC0SC1 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx941 -verify-machineinstrs < %s | FileCheck --check-prefixes=GCN,FORCESC0SC1 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx942 -verify-machineinstrs -mattr=-forcestoresc1 < %s | FileCheck --check-prefixes=GCN,NOSC0SC1 %s

define amdgpu_kernel void @store_global(ptr addrspace(1) %ptr) {
; FORCESC0SC1-LABEL: store_global:
; FORCESC0SC1:       ; %bb.0: ; %entry
; FORCESC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v0, 0
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v1, 1.0
; FORCESC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; FORCESC0SC1-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; FORCESC0SC1-NEXT:    s_endpgm
;
; NOSC0SC1-LABEL: store_global:
; NOSC0SC1:       ; %bb.0: ; %entry
; NOSC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; NOSC0SC1-NEXT:    v_mov_b32_e32 v0, 0
; NOSC0SC1-NEXT:    v_mov_b32_e32 v1, 1.0
; NOSC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; NOSC0SC1-NEXT:    global_store_dword v0, v1, s[0:1]
; NOSC0SC1-NEXT:    s_endpgm
entry:
  store float 1.000000e+00, ptr addrspace(1) %ptr, align 4
  ret void
}

define amdgpu_kernel void @store_flat(ptr addrspace(0) %ptr) {
; FORCESC0SC1-LABEL: store_flat:
; FORCESC0SC1:       ; %bb.0: ; %entry
; FORCESC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v2, 1.0
; FORCESC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; FORCESC0SC1-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; FORCESC0SC1-NEXT:    flat_store_dword v[0:1], v2 sc0 sc1
; FORCESC0SC1-NEXT:    s_endpgm
;
; NOSC0SC1-LABEL: store_flat:
; NOSC0SC1:       ; %bb.0: ; %entry
; NOSC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; NOSC0SC1-NEXT:    v_mov_b32_e32 v2, 1.0
; NOSC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; NOSC0SC1-NEXT:    v_mov_b64_e32 v[0:1], s[0:1]
; NOSC0SC1-NEXT:    flat_store_dword v[0:1], v2
; NOSC0SC1-NEXT:    s_endpgm
entry:
  store float 1.000000e+00, ptr addrspace(0) %ptr, align 4
  ret void
}

define amdgpu_kernel void @store_lds(ptr addrspace(3) %ptr) {
; GCN-LABEL: store_lds:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s0, s[0:1], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, s0
; GCN-NEXT:    ds_write_b32 v1, v0
; GCN-NEXT:    s_endpgm
entry:
  store float 1.000000e+00, ptr addrspace(3) %ptr, align 4
  ret void
}

define amdgpu_kernel void @store_scratch(ptr addrspace(5) %ptr) {
; FORCESC0SC1-LABEL: store_scratch:
; FORCESC0SC1:       ; %bb.0: ; %entry
; FORCESC0SC1-NEXT:    s_load_dword s0, s[0:1], 0x24
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v0, 1.0
; FORCESC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; FORCESC0SC1-NEXT:    scratch_store_dword off, v0, s0 sc0 sc1
; FORCESC0SC1-NEXT:    s_endpgm
;
; NOSC0SC1-LABEL: store_scratch:
; NOSC0SC1:       ; %bb.0: ; %entry
; NOSC0SC1-NEXT:    s_load_dword s0, s[0:1], 0x24
; NOSC0SC1-NEXT:    v_mov_b32_e32 v0, 1.0
; NOSC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; NOSC0SC1-NEXT:    scratch_store_dword off, v0, s0
; NOSC0SC1-NEXT:    s_endpgm
entry:
  store float 1.000000e+00, ptr addrspace(5) %ptr, align 4
  ret void
}

define amdgpu_ps void @store_buffer(<4 x i32> inreg %rsrc, float %data, i32 %index) {
; FORCESC0SC1-LABEL: store_buffer:
; FORCESC0SC1:       ; %bb.0: ; %main_body
; FORCESC0SC1-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 idxen sc0 sc1
; FORCESC0SC1-NEXT:    s_endpgm
;
; NOSC0SC1-LABEL: store_buffer:
; NOSC0SC1:       ; %bb.0: ; %main_body
; NOSC0SC1-NEXT:    buffer_store_dword v0, v1, s[0:3], 0 idxen
; NOSC0SC1-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.buffer.store.f32(float %data, <4 x i32> %rsrc, i32 %index, i32 0, i1 0, i1 0)
  ret void
}

define amdgpu_kernel void @store_global_atomic(ptr addrspace(1) %ptr) {
; FORCESC0SC1-LABEL: store_global_atomic:
; FORCESC0SC1:       ; %bb.0: ; %entry
; FORCESC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v0, 0
; FORCESC0SC1-NEXT:    v_mov_b32_e32 v1, 1.0
; FORCESC0SC1-NEXT:    buffer_wbl2 sc1
; FORCESC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; FORCESC0SC1-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; FORCESC0SC1-NEXT:    s_endpgm
;
; NOSC0SC1-LABEL: store_global_atomic:
; NOSC0SC1:       ; %bb.0: ; %entry
; NOSC0SC1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; NOSC0SC1-NEXT:    v_mov_b32_e32 v0, 0
; NOSC0SC1-NEXT:    v_mov_b32_e32 v1, 1.0
; NOSC0SC1-NEXT:    buffer_wbl2 sc1
; NOSC0SC1-NEXT:    s_waitcnt lgkmcnt(0)
; NOSC0SC1-NEXT:    global_store_dword v0, v1, s[0:1] sc1
; NOSC0SC1-NEXT:    s_endpgm
entry:
  store atomic float 1.000000e+00, ptr addrspace(1) %ptr syncscope("agent-one-as") seq_cst, align 4
  ret void
}

define amdgpu_kernel void @store_global_atomic_system(ptr addrspace(1) %ptr) {
; GCN-LABEL: store_global_atomic_system:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    v_mov_b32_e32 v1, 1.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GCN-NEXT:    s_endpgm
  store atomic float 1.000000e+00, ptr addrspace(1) %ptr monotonic, align 4
  ret void
}


declare void @llvm.amdgcn.buffer.store.f32(float, <4 x i32>, i32, i32, i1, i1)
