///////////////////////////////////////////////////////////////////////////////
//
// Thread.cc 
// ---------
// Thread class implementation
//                                                
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// IMPLEMENTATION MODULE
//
// Class: Thread
//
// Description: All operations on POSIX threads
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "Thread.h"
#include "Exception.h"

#include <pthread.h>
static pthread_mutex_t mu = PTHREAD_MUTEX_INITIALIZER;

void* Thread::task(void* pThis)
{
   void* res = ((Thread*)pThis)->job( ((Thread*)pThis)->getArg() );
   return res;
}

Thread::Thread()
{   
}

Thread::~Thread()
{
}

unsigned long long Thread::start(void *arg)
{
    _arg = arg;
    pthread_t tid;
    pthread_create(&tid, NULL, Thread::task,
		   (void *)this);
    _tid = (unsigned long long)tid;

    return _tid;

}

void Thread::cancel()
{   
    pthread_cancel((pthread_t)_tid);
}

void Thread::join(unsigned long long tid)
{    
    pthread_join((pthread_t)tid, NULL); 
}

void Thread::P()
{
  if ( pthread_mutex_lock(&mu) != 0 )
    throw Exception(EXLOC, "pthread_mutex_lock system error");
}

void Thread::V()
{
  if ( pthread_mutex_unlock(&mu) != 0 )
    throw Exception(EXLOC, "pthread_mutex_unlock system error");
}
