///////////////////////////////////////////////////////////////////////////////
// 
// GraphTest.cc - Testing the GraphT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2006 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// Description: Testing the GraphT class
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/GraphT.h"
#include "../src/Chain.h"

#include <stdlib.h>
#include <unistd.h>

ostream& operator << (ostream& s, GraphT<Chain>& x)
{

     Chain* pElement = x.First();
  
     s << "{";
     
     while (pElement)
     {      
	  s << *pElement ;

	  s << "(";
	  SetT<Chain> depList = x.getDependencies(*pElement);
	  Chain *pDep = depList.First();
	  while ( pDep )
	  {
	      s << *pDep;
	      
	      pDep = depList.Next();

	      if ( pDep )
		  s << ",";	      
	  }
	  s << ")";
	  pElement = x.Next(); 
	  if (pElement)
	       s << ",";
     }
     s << "}";
     
     return s;
  
}

typedef GraphT<Chain> ChainGraph;

int main(int argc, char **argv)
{

    int numCheck = 3;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
	
	GraphT<Chain> chainGraph;
	
	chainGraph.Insert(Chain("Hugo"));
	chainGraph.Insert(Chain("Martha"));
	chainGraph.Insert(Chain("Walter"));
	chainGraph.Insert(Chain("Iwan"));
	chainGraph.Insert(Chain("Jule"));
	
	chainGraph.Size();

	cout << "ok " << checkCount << " - basic graph add" << endl;
	checkCount++;

	
	chainGraph.addDependency(Chain("Walter"), Chain("Hugo"));
	chainGraph.addDependency(Chain("Hugo"), Chain("Iwan"));
	chainGraph.addDependency(Chain("Iwan"), Chain("Jule"));	

	chainGraph.addDependency(Chain("Walter"), Chain("Martha"));

	chainGraph.addDependency(Chain("Hugo"), Chain("Martha"));

	// cout << "Graph = " << chainGraph << endl;
	

	cout << "ok " << checkCount << " - basic dependency add" << endl;
	checkCount++;



	chainGraph.Remove(Chain("Walter"));
	// cout << "Graph = " << chainGraph << endl;
	
	cout << "ok " << checkCount << " - basic graph remove" << endl;
	checkCount++;

    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;
    
}



