/*
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_INTRAX8HUF_H
#define AVCODEC_INTRAX8HUF_H

#include <inttypes.h>

static const uint8_t x8_orient_lowquant_table[4][12][2] = {
    { /* Orient lowquant table 0 */
        {  0, 1 }, {  1, 3 }, {  2, 3 }, {  3, 4 }, {  4, 4 }, {  5, 6 },
        {  7, 6 }, {  6, 5 }, {  8, 6 }, {  9, 6 }, { 10, 6 }, { 11, 6 },
    },
    { /* Orient lowquant table 1 */
        {  0, 5 }, {  1, 5 }, {  2, 5 }, {  6, 5 }, {  5, 4 }, {  8, 4 },
        {  3, 2 }, {  4, 2 }, {  7, 3 }, {  9, 4 }, { 10, 5 }, { 11, 5 },
    },
    { /* Orient lowquant table 2 */
        {  0, 2 }, {  1, 2 }, {  2, 3 }, {  3, 3 }, {  4, 3 }, {  5, 6 },
        {  6, 6 }, {  7, 5 }, {  8, 6 }, {  9, 6 }, { 10, 6 }, { 11, 6 },
    },
    { /* Orient lowquant table 3 */
        {  0, 3 }, {  1, 4 }, {  2, 4 }, {  3, 2 }, {  4, 2 }, {  5, 5 },
        {  6, 5 }, {  7, 4 }, {  8, 5 }, {  9, 5 }, { 10, 5 }, { 11, 5 },
    },
};

static const uint8_t x8_orient_highquant_table[2][12][2] = {
    { /* Orient highquant table 0 */
        {  0, 2 }, {  1, 2 }, {  2, 3 }, {  3, 3 }, {  4, 3 }, {  5, 6 },
        {  7, 6 }, {  6, 5 }, {  8, 6 }, {  9, 6 }, { 10, 6 }, { 11, 6 },
    },
    { /* Orient highquant table 1 */
        {  0, 1 }, {  1, 2 }, {  2, 3 }, {  3, 5 }, {  4, 5 }, {  5, 7 },
        {  7, 7 }, {  6, 6 }, {  8, 7 }, {  9, 7 }, { 10, 7 }, { 11, 7 },
    },
};
#define MAX_OR_VLC_BITS 7

static const uint8_t x8_dc_quant_table[2][8][34][2] = {
    {
        { /* DC highquant table 0 */
            {  0,  5 }, {  3,  5 }, {  1,  4 }, {  2,  4 }, {  4,  5 },
            {  6,  5 }, {  5,  4 }, {  7,  5 }, {  8,  7 }, {  9,  7 },
            { 10, 12 }, { 11, 12 }, { 12, 12 }, { 13, 12 }, { 14, 12 },
            { 15, 12 }, { 16, 12 }, { 25, 12 }, { 26, 12 }, { 27, 12 },
            { 28, 12 }, { 29, 12 }, { 30, 12 }, { 31, 12 }, { 32, 12 },
            { 33, 12 }, { 24,  8 }, { 23,  7 }, { 17,  3 }, { 18,  2 },
            { 19,  3 }, { 20,  4 }, { 21,  5 }, { 22,  5 },
        },
        { /* DC highquant table 1 */
            {  0,  3 }, {  1,  3 }, {  2,  3 }, {  3,  4 }, {  4,  4 },
            {  5,  3 }, {  6,  4 }, {  7,  4 }, {  8,  6 }, {  9,  7 },
            { 10,  7 }, { 11, 11 }, { 12, 11 }, { 13, 11 }, { 14, 11 },
            { 15, 11 }, { 16, 11 }, { 25, 11 }, { 27, 11 }, { 28, 11 },
            { 29, 11 }, { 30, 11 }, { 31, 11 }, { 32, 10 }, { 33, 10 },
            { 23,  7 }, { 17,  6 }, { 18,  4 }, { 19,  5 }, { 20,  5 },
            { 21,  6 }, { 24,  7 }, { 26,  7 }, { 22,  5 },
        },
        { /* DC highquant table 2 */
            {  0,  7 }, {  1,  7 }, {  2,  6 }, {  3,  7 }, {  5,  7 },
            {  4,  6 }, {  6,  8 }, {  7,  8 }, {  8, 13 }, {  9, 13 },
            { 10, 13 }, { 11, 13 }, { 12, 13 }, { 13, 13 }, { 14, 13 },
            { 15, 13 }, { 16, 12 }, { 23, 12 }, { 24, 12 }, { 25, 12 },
            { 26, 12 }, { 27, 12 }, { 28, 12 }, { 29, 12 }, { 30, 12 },
            { 31, 12 }, { 32, 12 }, { 33, 12 }, { 22,  8 }, { 21,  6 },
            { 20,  5 }, { 19,  3 }, { 18,  2 }, { 17,  1 },
        },
        { /* DC highquant table 3 */
            {  0,  4 }, {  3,  4 }, {  1,  3 }, {  2,  3 }, {  4,  4 },
            {  8,  5 }, {  9,  5 }, {  5,  3 }, {  6,  3 }, {  7,  3 },
            { 10,  7 }, { 11, 11 }, { 12, 11 }, { 13, 11 }, { 14, 11 },
            { 15, 11 }, { 16, 11 }, { 25, 11 }, { 26, 11 }, { 27, 11 },
            { 29, 11 }, { 30, 11 }, { 31, 11 }, { 32, 10 }, { 33, 10 },
            { 18,  7 }, { 21,  7 }, { 17,  5 }, { 19,  6 }, { 20,  6 },
            { 22,  7 }, { 23,  7 }, { 24,  7 }, { 28,  7 },
        },
        { /* DC highquant table 4 */
            {  0,  8 }, {  4,  9 }, {  6,  9 }, {  1,  7 }, {  2,  7 },
            {  3,  7 }, {  5,  8 }, {  7, 14 }, {  8, 14 }, {  9, 14 },
            { 10, 14 }, { 11, 14 }, { 12, 14 }, { 13, 14 }, { 14, 14 },
            { 15, 13 }, { 16, 13 }, { 24, 13 }, { 25, 13 }, { 26, 13 },
            { 27, 13 }, { 28, 13 }, { 29, 13 }, { 30, 13 }, { 31, 13 },
            { 32, 13 }, { 33, 13 }, { 23,  9 }, { 22,  7 }, { 21,  6 },
            { 20,  4 }, { 19,  3 }, { 17,  2 }, { 18,  1 },
        },
        { /* DC highquant table 5 */
            {  0,  7 }, {  1,  7 }, {  2,  6 }, {  3,  6 }, {  4,  6 },
            {  5,  6 }, {  6,  6 }, {  7,  6 }, {  8,  6 }, {  9,  6 },
            { 10,  6 }, { 11,  6 }, { 12,  6 }, { 13,  6 }, { 14,  6 },
            { 15,  6 }, { 16,  6 }, { 17,  6 }, { 18,  6 }, { 19,  6 },
            { 20,  6 }, { 21,  6 }, { 22,  6 }, { 23,  6 }, { 24,  6 },
            { 25,  6 }, { 26,  6 }, { 28,  6 }, { 29,  6 }, { 30,  6 },
            { 31,  6 }, { 32,  6 }, { 33,  6 }, { 27,  1 },
        },
        { /* DC highquant table 6 */
            {  0,  5 }, {  2,  5 }, {  1,  4 }, {  3,  5 }, {  4,  6 },
            {  6,  6 }, {  5,  5 }, {  7,  6 }, {  8,  8 }, {  9,  8 },
            { 10, 13 }, { 11, 13 }, { 12, 13 }, { 13, 13 }, { 14, 13 },
            { 15, 13 }, { 16, 13 }, { 25, 13 }, { 26, 13 }, { 27, 13 },
            { 28, 13 }, { 29, 13 }, { 30, 13 }, { 31, 13 }, { 32, 13 },
            { 33, 13 }, { 24,  9 }, { 23,  8 }, { 17,  2 }, { 18,  2 },
            { 19,  3 }, { 20,  4 }, { 21,  5 }, { 22,  5 },
        },
        { /* DC highquant table 7 */
            {  0,  7 }, {  1,  7 }, {  2,  7 }, {  3,  7 }, {  4,  7 },
            {  5,  7 }, {  6,  7 }, {  7,  7 }, {  8,  7 }, {  9,  7 },
            { 10,  7 }, { 11,  7 }, { 12,  7 }, { 13,  7 }, { 14,  7 },
            { 15,  7 }, { 16,  7 }, { 19,  7 }, { 20,  7 }, { 21,  7 },
            { 22,  7 }, { 23,  7 }, { 24,  7 }, { 25,  7 }, { 26,  7 },
            { 27,  7 }, { 28,  7 }, { 29,  7 }, { 30,  7 }, { 31,  7 },
            { 32,  7 }, { 33,  7 }, { 18,  2 }, { 17,  1 },
        },
    },
    {
        { /* DC lowquant table 0 */
            {  0,  5 }, {  2,  5 }, {  1,  4 }, {  3,  5 }, {  4,  5 },
            {  5,  5 }, {  6,  6 }, {  7,  6 }, {  8,  8 }, {  9,  8 },
            { 10, 13 }, { 11, 13 }, { 12, 13 }, { 13, 13 }, { 14, 13 },
            { 15, 13 }, { 16, 13 }, { 25, 13 }, { 26, 13 }, { 27, 13 },
            { 28, 13 }, { 29, 13 }, { 30, 13 }, { 31, 13 }, { 32, 13 },
            { 33, 13 }, { 24,  9 }, { 23,  8 }, { 22,  6 }, { 21,  5 },
            { 20,  4 }, { 19,  3 }, { 17,  2 }, { 18,  2 },
        },
        { /* DC lowquant table 1 */
            {  0,  4 }, {  3,  4 }, {  1,  3 }, {  2,  3 }, {  4,  4 },
            {  6,  4 }, {  5,  3 }, {  7,  3 }, {  8,  4 }, {  9,  4 },
            { 10,  5 }, { 11,  6 }, { 12,  9 }, { 13,  9 }, { 14, 13 },
            { 15, 13 }, { 16, 13 }, { 25, 13 }, { 26, 13 }, { 27, 13 },
            { 28, 12 }, { 29, 12 }, { 31, 12 }, { 32, 12 }, { 33, 12 },
            { 21,  9 }, { 20,  7 }, { 17,  6 }, { 18,  6 }, { 19,  6 },
            { 22,  7 }, { 23,  8 }, { 24,  9 }, { 30,  9 },
        },
        { /* DC lowquant table 2 */
            {  0,  4 }, {  3,  4 }, {  1,  3 }, {  2,  3 }, {  4,  4 },
            {  5,  4 }, {  6,  4 }, {  7,  4 }, {  8,  6 }, {  9,  6 },
            { 10,  7 }, { 11,  7 }, { 12, 12 }, { 13, 12 }, { 14, 12 },
            { 15, 12 }, { 16, 12 }, { 25, 12 }, { 26, 12 }, { 27, 12 },
            { 28, 12 }, { 29, 12 }, { 30, 12 }, { 31, 12 }, { 32, 11 },
            { 33, 11 }, { 24,  8 }, { 23,  7 }, { 17,  4 }, { 18,  3 },
            { 19,  4 }, { 20,  5 }, { 21,  6 }, { 22,  6 },
        },
        { /* DC lowquant table 3 */
            {  0,  4 }, {  6,  4 }, {  2,  3 }, {  1,  2 }, {  3,  3 },
            {  4,  3 }, {  5,  3 }, {  7,  4 }, {  8,  6 }, {  9,  6 },
            { 10,  7 }, { 11,  8 }, { 12, 14 }, { 13, 14 }, { 14, 14 },
            { 15, 14 }, { 16, 13 }, { 21, 13 }, { 22, 13 }, { 23, 13 },
            { 24, 13 }, { 25, 13 }, { 26, 13 }, { 27, 13 }, { 28, 13 },
            { 29, 13 }, { 30, 13 }, { 31, 13 }, { 32, 13 }, { 33, 13 },
            { 17,  9 }, { 18,  7 }, { 19,  8 }, { 20,  8 },
        },
        { /* DC lowquant table 4 */
            {  0,  7 }, {  1,  7 }, {  2,  7 }, {  3,  7 }, {  4,  7 },
            {  5,  7 }, {  6,  7 }, {  7,  7 }, {  8,  7 }, {  9,  7 },
            { 10,  7 }, { 11,  7 }, { 12,  7 }, { 13,  7 }, { 14,  7 },
            { 15,  7 }, { 16,  7 }, { 19,  7 }, { 20,  7 }, { 21,  7 },
            { 22,  7 }, { 23,  7 }, { 24,  7 }, { 25,  7 }, { 26,  7 },
            { 27,  7 }, { 28,  7 }, { 29,  7 }, { 30,  7 }, { 31,  7 },
            { 32,  7 }, { 33,  7 }, { 18,  2 }, { 17,  1 },
        },
        { /* DC lowquant table 5 */
            {  0,  5 }, {  2,  5 }, {  1,  4 }, {  3,  6 }, {  4,  6 },
            {  5,  6 }, {  6,  7 }, {  8,  7 }, {  7,  6 }, {  9,  6 },
            { 10,  8 }, { 12,  8 }, { 11,  7 }, { 13, 13 }, { 14, 13 },
            { 15, 13 }, { 16, 13 }, { 23, 13 }, { 24, 13 }, { 25, 13 },
            { 26, 13 }, { 27, 13 }, { 28, 13 }, { 29, 13 }, { 30, 13 },
            { 31, 13 }, { 32, 13 }, { 33, 12 }, { 22,  9 }, { 21,  8 },
            { 20,  7 }, { 17,  3 }, { 19,  3 }, { 18,  1 },
        },
        { /* DC lowquant table 6 */
            {  0,  4 }, {  4,  4 }, {  2,  3 }, {  1,  2 }, {  3,  3 },
            {  5,  4 }, {  6,  5 }, {  7,  6 }, {  8,  7 }, {  9,  7 },
            { 10,  8 }, { 11, 14 }, { 12, 14 }, { 15, 14 }, { 16, 14 },
            { 23, 14 }, { 24, 14 }, { 25, 14 }, { 26, 14 }, { 27, 14 },
            { 28, 14 }, { 29, 14 }, { 30, 14 }, { 31, 14 }, { 32, 14 },
            { 33, 13 }, { 13, 10 }, { 14,  9 }, { 21,  8 }, { 22,  8 },
            { 20,  6 }, { 19,  5 }, { 17,  4 }, { 18,  3 },
        },
        { /* DC lowquant table 7 */
            {  0,  6 }, {  1,  6 }, {  2,  6 }, {  3,  7 }, {  4,  7 },
            {  5,  6 }, {  6,  6 }, {  7,  6 }, {  8,  7 }, {  9,  8 },
            { 10,  8 }, { 11,  9 }, { 12, 10 }, { 13, 14 }, { 14, 14 },
            { 15, 14 }, { 16, 14 }, { 24, 14 }, { 25, 14 }, { 26, 14 },
            { 27, 14 }, { 28, 14 }, { 29, 14 }, { 30, 14 }, { 31, 14 },
            { 32, 13 }, { 33, 13 }, { 23,  8 }, { 22,  7 }, { 21,  6 },
            { 20,  5 }, { 19,  4 }, { 18,  2 }, { 17,  1 },
        },
    },
};
#define MAX_DC_VLC_BITS 14

static const uint8_t x8_ac_quant_table[2][2][8][77][2] = {
    {
        {
            { /* AC highquant table group 0, table 0 */
                {  0,  3 }, {  1,  4 }, {  2,  6 }, {  3,  6 }, {  4,  7 },
                {  6, 15 }, {  8, 15 }, { 10, 15 }, { 12, 15 }, { 13, 15 },
                { 14, 15 }, { 15, 14 }, { 34, 14 }, { 45, 14 }, { 46, 14 },
                { 47, 14 }, { 49, 14 }, { 50, 14 }, { 51, 14 }, { 52, 14 },
                { 53, 14 }, { 54, 14 }, { 55, 14 }, { 56, 14 }, { 57, 14 },
                { 58, 14 }, { 60, 14 }, { 61, 14 }, { 62, 14 }, { 63, 14 },
                { 64, 14 }, { 65, 14 }, { 67, 14 }, { 69, 14 }, { 70, 14 },
                { 71, 14 }, { 72, 14 }, { 74, 14 }, { 75, 14 }, { 76, 14 },
                {  9,  9 }, {  7,  8 }, {  5,  6 }, { 11,  9 }, { 18,  9 },
                { 19,  9 }, { 22,  9 }, { 20,  7 }, { 17,  6 }, { 16,  5 },
                { 21,  7 }, { 29,  8 }, { 33,  8 }, { 28,  6 }, { 27,  5 },
                { 24,  3 }, { 23,  2 }, { 25,  4 }, { 26,  4 }, { 30,  7 },
                { 32,  7 }, { 31,  6 }, { 35,  7 }, { 36,  7 }, { 37,  7 },
                { 38,  9 }, { 41,  9 }, { 42,  8 }, { 39,  5 }, { 40,  6 },
                { 43,  9 }, { 44,  9 }, { 48,  8 }, { 59,  9 }, { 66,  9 },
                { 68,  9 }, { 73,  9 },
            },
            { /* AC highquant table group 0, table 1 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  6 }, {  7,  6 }, {  8,  7 }, {  9,  8 },
                { 10,  8 }, { 11,  8 }, { 12,  8 }, { 13, 14 }, { 44, 14 },
                { 47, 14 }, { 50, 14 }, { 51, 14 }, { 54, 14 }, { 55, 14 },
                { 56, 14 }, { 63, 14 }, { 64, 14 }, { 67, 14 }, { 68, 14 },
                { 69, 14 }, { 70, 14 }, { 72, 14 }, { 76, 14 }, { 14, 10 },
                { 15, 10 }, { 45, 10 }, { 32,  8 }, { 16,  4 }, { 17,  5 },
                { 18,  6 }, { 19,  7 }, { 31,  7 }, { 20,  5 }, { 21,  6 },
                { 26,  6 }, { 22,  5 }, { 24,  5 }, { 23,  4 }, { 25,  5 },
                { 27,  6 }, { 28,  6 }, { 29,  6 }, { 30,  6 }, { 33,  8 },
                { 38,  8 }, { 34,  7 }, { 35,  7 }, { 36,  7 }, { 37,  7 },
                { 39,  7 }, { 40,  7 }, { 41,  8 }, { 42,  8 }, { 43,  8 },
                { 46,  9 }, { 49,  9 }, { 53,  8 }, { 58,  8 }, { 57,  6 },
                { 48,  5 }, { 52,  5 }, { 59,  7 }, { 60,  8 }, { 61,  9 },
                { 66,  9 }, { 62,  8 }, { 65,  8 }, { 71,  9 }, { 75,  9 },
                { 74,  8 }, { 73,  5 },
            },
            { /* AC highquant table group 0, table 2 */
                {  0,  4 }, {  1,  5 }, {  2, 12 }, {  3, 12 }, {  4, 12 },
                {  5, 12 }, {  6, 12 }, {  7, 12 }, {  8, 12 }, {  9, 12 },
                { 10, 12 }, { 11, 12 }, { 12, 11 }, { 13, 11 }, { 14, 11 },
                { 15, 11 }, { 16, 11 }, { 17, 11 }, { 18, 11 }, { 19, 11 },
                { 20, 11 }, { 21, 11 }, { 22, 11 }, { 28, 11 }, { 29, 11 },
                { 30, 11 }, { 31, 11 }, { 32, 11 }, { 33, 11 }, { 34, 11 },
                { 35, 11 }, { 36, 11 }, { 37, 11 }, { 38, 11 }, { 40, 11 },
                { 41, 11 }, { 42, 11 }, { 43, 11 }, { 44, 11 }, { 45, 11 },
                { 46, 11 }, { 47, 11 }, { 48, 11 }, { 49, 11 }, { 50, 11 },
                { 51, 11 }, { 52, 11 }, { 53, 11 }, { 54, 11 }, { 55, 11 },
                { 56, 11 }, { 57, 11 }, { 58, 11 }, { 59, 11 }, { 60, 11 },
                { 61, 11 }, { 62, 11 }, { 63, 11 }, { 64, 11 }, { 65, 11 },
                { 66, 11 }, { 67, 11 }, { 68, 11 }, { 69, 11 }, { 70, 11 },
                { 71, 11 }, { 72, 11 }, { 73, 11 }, { 74, 11 }, { 75, 11 },
                { 76, 11 }, { 25,  5 }, { 26,  5 }, { 27,  5 }, { 39,  5 },
                { 24,  2 }, { 23,  1 },
            },
            { /* AC highquant table group 0, table 3 */
                {  0,  8 }, {  1,  8 }, {  2,  8 }, {  3,  8 }, {  4,  8 },
                {  5,  8 }, {  6,  8 }, {  7,  8 }, {  8,  8 }, {  9,  8 },
                { 10,  8 }, { 11,  8 }, { 12,  8 }, { 13,  8 }, { 14,  8 },
                { 15,  8 }, { 16,  8 }, { 17,  8 }, { 18,  8 }, { 19,  8 },
                { 20,  8 }, { 21,  8 }, { 22,  8 }, { 24,  8 }, { 25,  7 },
                { 26,  7 }, { 27,  7 }, { 28,  7 }, { 29,  7 }, { 30,  7 },
                { 31,  7 }, { 32,  7 }, { 33,  7 }, { 34,  7 }, { 35,  7 },
                { 36,  7 }, { 37,  7 }, { 38,  7 }, { 39,  7 }, { 40,  7 },
                { 41,  7 }, { 42,  7 }, { 43,  7 }, { 44,  7 }, { 45,  7 },
                { 46,  7 }, { 47,  7 }, { 48,  7 }, { 49,  7 }, { 50,  7 },
                { 51,  7 }, { 52,  7 }, { 53,  7 }, { 54,  7 }, { 55,  7 },
                { 56,  7 }, { 57,  7 }, { 58,  7 }, { 59,  7 }, { 60,  7 },
                { 61,  7 }, { 62,  7 }, { 63,  7 }, { 64,  7 }, { 65,  7 },
                { 66,  7 }, { 67,  7 }, { 68,  7 }, { 69,  7 }, { 70,  7 },
                { 71,  7 }, { 72,  7 }, { 73,  7 }, { 74,  7 }, { 75,  7 },
                { 76,  7 }, { 23,  1 },
            },
            { /* AC highquant table group 0, table 4 */
                {  0,  9 }, {  1,  9 }, {  2,  9 }, {  3,  9 }, {  4,  9 },
                {  5,  9 }, {  6,  9 }, {  7,  9 }, {  8,  9 }, {  9,  9 },
                { 10,  9 }, { 11,  9 }, { 12,  9 }, { 13,  9 }, { 14,  9 },
                { 15,  9 }, { 16,  9 }, { 17,  9 }, { 18,  9 }, { 19,  9 },
                { 20,  9 }, { 21,  9 }, { 22,  8 }, { 25,  8 }, { 26,  8 },
                { 27,  8 }, { 28,  8 }, { 29,  8 }, { 30,  8 }, { 31,  8 },
                { 32,  8 }, { 33,  8 }, { 34,  8 }, { 35,  8 }, { 36,  8 },
                { 37,  8 }, { 38,  8 }, { 39,  8 }, { 40,  8 }, { 41,  8 },
                { 42,  8 }, { 43,  8 }, { 44,  8 }, { 45,  8 }, { 46,  8 },
                { 47,  8 }, { 48,  8 }, { 49,  8 }, { 50,  8 }, { 51,  8 },
                { 52,  8 }, { 53,  8 }, { 54,  8 }, { 55,  8 }, { 56,  8 },
                { 57,  8 }, { 58,  8 }, { 59,  8 }, { 60,  8 }, { 61,  8 },
                { 62,  8 }, { 63,  8 }, { 64,  8 }, { 65,  8 }, { 66,  8 },
                { 67,  8 }, { 68,  8 }, { 69,  8 }, { 70,  8 }, { 71,  8 },
                { 72,  8 }, { 73,  8 }, { 74,  8 }, { 75,  8 }, { 76,  8 },
                { 23,  2 }, { 24,  1 },
            },
            { /* AC highquant table group 0, table 5 */
                {  0, 10 }, {  1, 10 }, {  2, 10 }, {  3, 10 }, {  4, 10 },
                {  5, 10 }, {  6, 10 }, {  7, 10 }, {  8, 10 }, {  9, 10 },
                { 10, 10 }, { 11, 10 }, { 12, 10 }, { 13, 10 }, { 14, 10 },
                { 15, 10 }, { 16, 10 }, { 17, 10 }, { 18, 10 }, { 19, 10 },
                { 20,  9 }, { 21,  9 }, { 22,  9 }, { 25,  9 }, { 26,  9 },
                { 28,  9 }, { 29,  9 }, { 30,  9 }, { 31,  9 }, { 32,  9 },
                { 33,  9 }, { 34,  9 }, { 35,  9 }, { 36,  9 }, { 37,  9 },
                { 38,  9 }, { 39,  9 }, { 40,  9 }, { 41,  9 }, { 42,  9 },
                { 43,  9 }, { 44,  9 }, { 45,  9 }, { 46,  9 }, { 47,  9 },
                { 48,  9 }, { 49,  9 }, { 50,  9 }, { 51,  9 }, { 52,  9 },
                { 53,  9 }, { 54,  9 }, { 55,  9 }, { 56,  9 }, { 57,  9 },
                { 58,  9 }, { 59,  9 }, { 60,  9 }, { 61,  9 }, { 62,  9 },
                { 63,  9 }, { 64,  9 }, { 65,  9 }, { 66,  9 }, { 67,  9 },
                { 68,  9 }, { 69,  9 }, { 70,  9 }, { 71,  9 }, { 72,  9 },
                { 73,  9 }, { 74,  9 }, { 75,  9 }, { 76,  9 }, { 24,  3 },
                { 27,  2 }, { 23,  1 },
            },
            { /* AC highquant table group 0, table 6 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  7 }, {  7,  8 }, {  8,  8 }, {  9,  8 },
                { 10,  9 }, { 11,  9 }, { 12, 10 }, { 14, 10 }, { 13,  9 },
                { 15, 15 }, { 42, 15 }, { 46, 15 }, { 50, 15 }, { 51, 15 },
                { 55, 15 }, { 56, 14 }, { 59, 14 }, { 61, 14 }, { 62, 14 },
                { 63, 14 }, { 64, 14 }, { 68, 14 }, { 69, 14 }, { 70, 14 },
                { 71, 14 }, { 72, 14 }, { 75, 14 }, { 76, 14 }, { 43, 10 },
                { 37,  9 }, { 17,  5 }, { 18,  6 }, { 19,  6 }, { 16,  3 },
                { 20,  4 }, { 21,  7 }, { 24,  7 }, { 25,  7 }, { 26,  7 },
                { 22,  5 }, { 23,  5 }, { 27,  8 }, { 30,  8 }, { 28,  7 },
                { 29,  7 }, { 31,  8 }, { 32,  8 }, { 33,  8 }, { 34,  8 },
                { 35,  8 }, { 36,  8 }, { 38,  8 }, { 39,  8 }, { 40,  8 },
                { 41,  9 }, { 44, 10 }, { 45, 10 }, { 47, 10 }, { 54, 10 },
                { 49,  9 }, { 58,  8 }, { 60, 10 }, { 66, 10 }, { 67, 10 },
                { 74, 10 }, { 65,  8 }, { 48,  6 }, { 52,  4 }, { 53,  6 },
                { 57,  6 }, { 73,  5 },
            },
            { /* AC highquant table group 0, table 7 */
                {  0,  3 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  8 }, {  9, 13 }, { 12, 13 }, { 13, 13 }, { 14, 13 },
                { 42, 13 }, { 45, 13 }, { 46, 13 }, { 47, 13 }, { 50, 13 },
                { 51, 13 }, { 53, 13 }, { 54, 13 }, { 55, 13 }, { 56, 13 },
                { 58, 13 }, { 61, 13 }, { 62, 13 }, { 63, 13 }, { 64, 13 },
                { 66, 13 }, { 67, 13 }, { 68, 13 }, { 69, 13 }, { 70, 13 },
                { 72, 12 }, { 74, 12 }, { 75, 12 }, { 76, 12 }, {  6,  7 },
                {  7,  6 }, {  8,  7 }, { 10,  8 }, { 11,  8 }, { 15,  8 },
                { 31,  8 }, { 18,  7 }, { 19,  6 }, { 17,  5 }, { 16,  4 },
                { 20,  6 }, { 21,  7 }, { 36,  8 }, { 37,  8 }, { 22,  6 },
                { 27,  6 }, { 23,  3 }, { 24,  5 }, { 25,  5 }, { 26,  4 },
                { 28,  6 }, { 29,  6 }, { 30,  5 }, { 32,  6 }, { 33,  6 },
                { 34,  6 }, { 35,  6 }, { 38,  7 }, { 40,  7 }, { 41,  7 },
                { 43,  7 }, { 39,  5 }, { 44,  8 }, { 52,  8 }, { 48,  7 },
                { 49,  7 }, { 57,  8 }, { 60,  8 }, { 59,  7 }, { 65,  8 },
                { 71,  8 }, { 73,  6 },
            },
        },
        {
            { /* AC highquant table group 1, table 0 */
                {  0,  3 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  5 },
                {  5,  5 }, {  6,  6 }, {  7,  7 }, {  9,  7 }, {  8,  6 },
                { 10,  8 }, { 13,  8 }, { 11,  7 }, { 12,  7 }, { 14,  8 },
                { 15,  9 }, { 41,  9 }, { 17,  6 }, { 18,  6 }, { 19,  7 },
                { 21,  8 }, { 42,  9 }, { 43,  9 }, { 16,  4 }, { 20,  5 },
                { 22,  6 }, { 26,  6 }, { 23,  4 }, { 24,  4 }, { 25,  5 },
                { 27,  6 }, { 28,  6 }, { 29,  6 }, { 30,  7 }, { 31,  7 },
                { 32,  7 }, { 33,  7 }, { 34,  7 }, { 35,  7 }, { 36,  7 },
                { 37,  7 }, { 38,  7 }, { 39,  7 }, { 40,  7 }, { 44, 11 },
                { 54, 14 }, { 55, 14 }, { 56, 14 }, { 64, 14 }, { 69, 14 },
                { 70, 14 }, { 72, 14 }, { 76, 14 }, { 53, 10 }, { 45,  9 },
                { 47,  8 }, { 46,  6 }, { 48,  5 }, { 49,  7 }, { 50,  9 },
                { 51,  9 }, { 58, 10 }, { 67, 10 }, { 61,  9 }, { 52,  7 },
                { 57,  7 }, { 59,  7 }, { 60,  8 }, { 62,  8 }, { 63,  7 },
                { 65,  7 }, { 66,  7 }, { 68, 10 }, { 71, 10 }, { 74,  9 },
                { 75,  8 }, { 73,  6 },
            },
            { /* AC highquant table group 1, table 1 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  7 }, {  6,  7 }, {  7,  7 }, {  8,  8 }, {  9,  9 },
                { 10,  9 }, { 11,  9 }, { 12,  9 }, { 13, 15 }, { 42, 15 },
                { 44, 15 }, { 45, 15 }, { 46, 15 }, { 47, 15 }, { 50, 15 },
                { 51, 15 }, { 56, 15 }, { 61, 15 }, { 62, 15 }, { 63, 15 },
                { 64, 15 }, { 66, 15 }, { 67, 14 }, { 15, 11 }, { 14, 10 },
                { 30,  9 }, { 19,  7 }, { 17,  5 }, { 18,  6 }, { 23,  6 },
                { 16,  3 }, { 20,  4 }, { 21,  5 }, { 24,  7 }, { 25,  7 },
                { 26,  8 }, { 27,  8 }, { 28,  7 }, { 22,  4 }, { 29,  8 },
                { 31,  8 }, { 32,  9 }, { 33,  9 }, { 34,  9 }, { 35,  9 },
                { 36, 10 }, { 37, 11 }, { 38, 11 }, { 39,  9 }, { 40,  9 },
                { 41, 11 }, { 55, 11 }, { 43, 10 }, { 49,  8 }, { 54,  8 },
                { 48,  6 }, { 53,  7 }, { 58,  8 }, { 59, 11 }, { 68, 14 },
                { 69, 14 }, { 70, 14 }, { 71, 14 }, { 72, 14 }, { 74, 14 },
                { 75, 14 }, { 76, 14 }, { 60, 10 }, { 65,  9 }, { 52,  4 },
                { 57,  5 }, { 73,  5 },
            },
            { /* AC highquant table group 1, table 2 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  7 }, {  7,  7 }, {  6,  6 }, {  8,  9 }, {  9,  9 },
                { 10,  8 }, { 11, 15 }, { 13, 15 }, { 14, 15 }, { 15, 15 },
                { 46, 15 }, { 47, 15 }, { 50, 15 }, { 51, 15 }, { 54, 14 },
                { 55, 14 }, { 56, 14 }, { 62, 14 }, { 63, 14 }, { 64, 14 },
                { 66, 14 }, { 67, 14 }, { 69, 14 }, { 70, 14 }, { 72, 14 },
                { 76, 14 }, { 34, 10 }, { 12,  9 }, { 31,  8 }, { 17,  5 },
                { 16,  3 }, { 18,  7 }, { 19,  7 }, { 21,  6 }, { 22,  5 },
                { 20,  4 }, { 23,  4 }, { 24,  4 }, { 25,  5 }, { 26,  6 },
                { 27,  6 }, { 28,  6 }, { 29,  6 }, { 30,  7 }, { 32,  7 },
                { 33,  8 }, { 35,  8 }, { 36,  9 }, { 37, 10 }, { 38, 10 },
                { 41,  9 }, { 42,  9 }, { 39,  6 }, { 40,  7 }, { 43,  8 },
                { 44, 10 }, { 60, 10 }, { 45,  9 }, { 48,  7 }, { 49,  9 },
                { 58,  9 }, { 53,  8 }, { 57,  6 }, { 52,  5 }, { 59,  9 },
                { 61, 10 }, { 68, 10 }, { 65,  8 }, { 71,  9 }, { 75,  9 },
                { 74,  8 }, { 73,  6 },
            },
            { /* AC highquant table group 1, table 3 */
                {  0,  3 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  7 }, {  7,  7 }, {  8,  6 }, {  9,  6 },
                { 10,  7 }, { 11,  7 }, { 12,  9 }, { 13,  9 }, { 15,  8 },
                { 14,  7 }, { 17,  6 }, { 16,  5 }, { 18,  9 }, { 42,  9 },
                { 32,  8 }, { 19,  7 }, { 20,  6 }, { 21,  7 }, { 22,  7 },
                { 27,  6 }, { 25,  5 }, { 23,  3 }, { 24,  3 }, { 26,  5 },
                { 28,  6 }, { 29,  6 }, { 30,  7 }, { 31,  7 }, { 33,  8 },
                { 34,  8 }, { 35,  8 }, { 41,  8 }, { 36,  7 }, { 38,  7 },
                { 37,  6 }, { 39,  7 }, { 43, 14 }, { 44, 14 }, { 45, 14 },
                { 50, 14 }, { 51, 14 }, { 53, 14 }, { 54, 13 }, { 55, 13 },
                { 56, 13 }, { 58, 13 }, { 64, 13 }, { 67, 13 }, { 68, 13 },
                { 69, 13 }, { 70, 13 }, { 71, 13 }, { 72, 13 }, { 74, 13 },
                { 76, 13 }, { 47,  9 }, { 49,  8 }, { 40,  6 }, { 46,  7 },
                { 48,  7 }, { 52,  8 }, { 57,  8 }, { 60,  7 }, { 59,  6 },
                { 61,  9 }, { 75,  9 }, { 73,  8 }, { 63,  7 }, { 62,  6 },
                { 65,  7 }, { 66,  7 },
            },
            { /* AC highquant table group 1, table 4 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  7 }, {  7,  7 }, {  8,  7 }, {  9,  8 },
                { 10,  9 }, { 11,  9 }, { 12, 10 }, { 13, 10 }, { 14, 10 },
                { 15, 15 }, { 50, 15 }, { 51, 15 }, { 54, 15 }, { 55, 15 },
                { 56, 15 }, { 61, 15 }, { 64, 15 }, { 45, 12 }, { 47, 12 },
                { 58, 12 }, { 32,  8 }, { 19,  7 }, { 18,  6 }, { 17,  5 },
                { 16,  3 }, { 20,  4 }, { 21,  6 }, { 22,  6 }, { 24,  5 },
                { 23,  4 }, { 25,  6 }, { 26,  6 }, { 27,  6 }, { 28,  7 },
                { 29,  7 }, { 30,  7 }, { 31,  7 }, { 33,  8 }, { 34,  8 },
                { 35,  8 }, { 36,  8 }, { 37,  8 }, { 38, 10 }, { 43, 10 },
                { 41,  9 }, { 39,  7 }, { 40,  8 }, { 42,  9 }, { 44, 10 },
                { 46, 10 }, { 49,  8 }, { 53,  9 }, { 59, 10 }, { 60, 10 },
                { 48,  6 }, { 52,  6 }, { 57,  7 }, { 62, 12 }, { 67, 15 },
                { 69, 15 }, { 70, 15 }, { 71, 15 }, { 72, 14 }, { 76, 14 },
                { 63, 11 }, { 68, 12 }, { 74, 12 }, { 75, 11 }, { 66,  9 },
                { 65,  8 }, { 73,  6 },
            },
            { /* AC highquant table group 1, table 5 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  5 },
                {  5,  6 }, {  6,  7 }, {  7,  8 }, {  8, 11 }, { 10, 11 },
                { 11, 10 }, {  9,  9 }, { 12, 11 }, { 13, 15 }, { 14, 15 },
                { 15, 15 }, { 47, 15 }, { 49, 15 }, { 50, 15 }, { 51, 15 },
                { 54, 15 }, { 55, 14 }, { 56, 14 }, { 58, 14 }, { 63, 14 },
                { 38, 11 }, { 53, 11 }, { 37,  9 }, { 32,  8 }, { 19,  7 },
                { 18,  6 }, { 16,  4 }, { 17,  5 }, { 20,  5 }, { 21,  7 },
                { 31,  7 }, { 22,  6 }, { 25,  5 }, { 24,  4 }, { 23,  3 },
                { 26,  5 }, { 27,  5 }, { 28,  5 }, { 29,  6 }, { 30,  6 },
                { 33,  8 }, { 34,  8 }, { 35,  7 }, { 36,  8 }, { 41,  8 },
                { 40,  7 }, { 39,  5 }, { 42,  8 }, { 44, 10 }, { 60, 10 },
                { 45,  9 }, { 43,  7 }, { 46,  9 }, { 59,  9 }, { 61, 10 },
                { 64, 14 }, { 67, 14 }, { 68, 14 }, { 69, 14 }, { 70, 14 },
                { 72, 14 }, { 75, 14 }, { 76, 14 }, { 66, 11 }, { 62,  9 },
                { 48,  7 }, { 52,  7 }, { 57,  7 }, { 65,  8 }, { 71,  9 },
                { 74,  9 }, { 73,  7 },
            },
            { /* AC highquant table group 1, table 6 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  5 },
                {  5,  5 }, {  6,  5 }, {  7,  6 }, {  8,  7 }, { 10,  7 },
                {  9,  5 }, { 11, 13 }, { 13, 13 }, { 15, 13 }, { 29, 13 },
                { 32, 13 }, { 33, 13 }, { 34, 12 }, { 37, 12 }, { 38, 12 },
                { 40, 12 }, { 41, 12 }, { 42, 12 }, { 43, 12 }, { 44, 12 },
                { 45, 12 }, { 50, 12 }, { 53, 12 }, { 54, 12 }, { 55, 12 },
                { 56, 12 }, { 58, 12 }, { 60, 12 }, { 61, 12 }, { 62, 12 },
                { 63, 12 }, { 64, 12 }, { 66, 12 }, { 67, 12 }, { 68, 12 },
                { 69, 12 }, { 70, 12 }, { 71, 12 }, { 72, 12 }, { 74, 12 },
                { 76, 12 }, { 12,  7 }, { 14,  7 }, { 18,  7 }, { 17,  6 },
                { 19,  7 }, { 21,  7 }, { 16,  4 }, { 20,  5 }, { 22,  5 },
                { 23,  6 }, { 24,  6 }, { 25,  7 }, { 27,  7 }, { 26,  6 },
                { 28,  7 }, { 30,  7 }, { 31,  7 }, { 35,  7 }, { 36,  7 },
                { 39,  7 }, { 47,  6 }, { 46,  5 }, { 49,  5 }, { 48,  4 },
                { 51,  7 }, { 75,  7 }, { 57,  6 }, { 52,  5 }, { 59,  6 },
                { 65,  6 }, { 73,  5 },
            },
            { /* AC highquant table group 1, table 7 */
                {  0,  3 }, {  1,  4 }, {  2,  5 }, {  3,  6 }, {  4,  6 },
                {  5,  8 }, {  6,  8 }, {  7,  8 }, {  8, 11 }, {  9, 15 },
                { 10, 15 }, { 11, 15 }, { 12, 15 }, { 13, 15 }, { 14, 15 },
                { 15, 15 }, { 38, 15 }, { 46, 15 }, { 47, 15 }, { 50, 15 },
                { 51, 15 }, { 53, 15 }, { 54, 15 }, { 55, 15 }, { 56, 15 },
                { 37, 11 }, { 58, 15 }, { 61, 15 }, { 62, 15 }, { 63, 15 },
                { 64, 15 }, { 66, 15 }, { 67, 15 }, { 68, 15 }, { 69, 15 },
                { 70, 15 }, { 72, 14 }, { 75, 14 }, { 76, 14 }, { 19,  9 },
                { 17,  6 }, { 18,  7 }, { 21,  8 }, { 22,  8 }, { 28,  6 },
                { 16,  4 }, { 20,  5 }, { 25,  5 }, { 26,  5 }, { 27,  5 },
                { 23,  2 }, { 24,  3 }, { 29,  6 }, { 30,  8 }, { 31,  8 },
                { 32,  9 }, { 36,  9 }, { 33,  8 }, { 34,  7 }, { 35,  8 },
                { 41,  8 }, { 40,  7 }, { 42,  9 }, { 44,  9 }, { 43,  8 },
                { 39,  5 }, { 45,  9 }, { 49, 10 }, { 71, 10 }, { 48,  8 },
                { 52,  8 }, { 57,  9 }, { 60,  9 }, { 59,  8 }, { 65,  9 },
                { 74,  9 }, { 73,  7 },
            },
        },
    },
    {
        {
            { /* AC lowquant table group 0, table 0 */
                {  0,  2 }, {  1,  3 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  7 }, {  6,  7 }, {  7,  7 }, {  8,  9 }, { 12, 10 },
                { 13, 10 }, {  9,  8 }, { 10,  8 }, { 11,  8 }, { 14, 10 },
                { 15, 10 }, { 18,  9 }, { 19, 10 }, { 41, 10 }, { 40,  9 },
                { 17,  7 }, { 21,  7 }, { 20,  6 }, { 16,  4 }, { 22,  7 },
                { 32,  7 }, { 28,  6 }, { 25,  5 }, { 23,  4 }, { 24,  4 },
                { 26,  5 }, { 27,  5 }, { 29,  6 }, { 30,  6 }, { 31,  6 },
                { 33,  7 }, { 34,  7 }, { 35,  7 }, { 36,  7 }, { 37,  7 },
                { 38,  7 }, { 39,  8 }, { 42, 14 }, { 43, 14 }, { 44, 14 },
                { 45, 14 }, { 47, 14 }, { 49, 14 }, { 50, 14 }, { 51, 14 },
                { 53, 14 }, { 54, 14 }, { 55, 14 }, { 56, 14 }, { 58, 14 },
                { 63, 14 }, { 64, 14 }, { 65, 14 }, { 46, 10 }, { 48,  9 },
                { 52,  8 }, { 57, 10 }, { 66, 14 }, { 67, 14 }, { 68, 14 },
                { 69, 14 }, { 70, 14 }, { 71, 14 }, { 72, 13 }, { 73, 13 },
                { 74, 13 }, { 75, 13 }, { 76, 13 }, { 62,  9 }, { 59,  7 },
                { 60,  8 }, { 61,  8 },
            },
            { /* AC lowquant table group 0, table 1 */
                {  0,  3 }, {  1,  5 }, {  2,  7 }, {  5,  8 }, {  6,  8 },
                {  3,  6 }, {  4,  6 }, {  7,  8 }, {  8, 14 }, {  9, 14 },
                { 11, 14 }, { 12, 14 }, { 13, 14 }, { 14, 14 }, { 15, 14 },
                { 18, 14 }, { 20, 14 }, { 21, 14 }, { 22, 14 }, { 41, 14 },
                { 45, 14 }, { 46, 14 }, { 47, 14 }, { 49, 14 }, { 50, 14 },
                { 51, 14 }, { 52, 13 }, { 53, 13 }, { 54, 13 }, { 55, 13 },
                { 56, 13 }, { 57, 13 }, { 58, 13 }, { 60, 13 }, { 61, 13 },
                { 62, 13 }, { 63, 13 }, { 64, 13 }, { 66, 13 }, { 67, 13 },
                { 68, 13 }, { 69, 13 }, { 70, 13 }, { 71, 13 }, { 72, 13 },
                { 73, 13 }, { 74, 13 }, { 75, 13 }, { 76, 13 }, { 10,  7 },
                { 16,  6 }, { 17,  8 }, { 19,  8 }, { 30,  7 }, { 23,  2 },
                { 24,  3 }, { 25,  5 }, { 29,  6 }, { 31,  7 }, { 32,  7 },
                { 26,  4 }, { 27,  4 }, { 28,  4 }, { 33,  7 }, { 34,  8 },
                { 40,  8 }, { 35,  7 }, { 42,  8 }, { 43,  8 }, { 36,  6 },
                { 37,  6 }, { 38,  6 }, { 39,  6 }, { 44,  8 }, { 48,  8 },
                { 65,  7 }, { 59,  6 },
            },
            { /* AC lowquant table group 0, table 2 */
                {  0,  2 }, {  1,  3 }, {  2,  3 }, {  3,  4 }, {  4,  5 },
                {  5,  5 }, {  6,  6 }, {  7,  6 }, {  8,  7 }, {  9,  7 },
                { 10,  7 }, { 11,  8 }, { 12,  8 }, { 13,  8 }, { 14,  9 },
                { 15, 10 }, { 39, 16 }, { 40, 16 }, { 41, 15 }, { 43, 15 },
                { 44, 15 }, { 45, 15 }, { 50, 15 }, { 51, 15 }, { 53, 15 },
                { 42, 12 }, { 49, 12 }, { 54, 15 }, { 55, 15 }, { 56, 15 },
                { 58, 15 }, { 64, 15 }, { 65, 15 }, { 66, 15 }, { 67, 15 },
                { 18,  8 }, { 19,  9 }, { 21,  9 }, { 17,  6 }, { 20,  6 },
                { 22,  8 }, { 38,  8 }, { 27,  7 }, { 16,  4 }, { 23,  5 },
                { 24,  6 }, { 25,  6 }, { 26,  6 }, { 28,  7 }, { 29,  7 },
                { 30,  7 }, { 31,  7 }, { 32,  7 }, { 33,  7 }, { 34,  7 },
                { 35,  7 }, { 36,  7 }, { 37,  7 }, { 46,  8 }, { 47, 10 },
                { 62, 11 }, { 63, 12 }, { 68, 15 }, { 69, 15 }, { 70, 15 },
                { 71, 15 }, { 72, 15 }, { 74, 15 }, { 75, 15 }, { 76, 15 },
                { 48,  9 }, { 52,  8 }, { 57,  9 }, { 73,  9 }, { 59,  7 },
                { 60,  8 }, { 61,  8 },
            },
            { /* AC lowquant table group 0, table 3 */
                {  0,  2 }, {  1,  3 }, {  2,  4 }, {  3,  5 }, {  4,  5 },
                {  5,  6 }, {  6,  6 }, {  7,  7 }, {  8,  7 }, {  9,  8 },
                { 10,  8 }, { 11,  9 }, { 12,  9 }, { 13,  9 }, { 14, 10 },
                { 15, 10 }, { 17,  5 }, { 18,  7 }, { 19,  7 }, { 21,  7 },
                { 24,  7 }, { 16,  3 }, { 20,  4 }, { 22,  5 }, { 23,  6 },
                { 25,  7 }, { 26,  7 }, { 27,  8 }, { 28,  8 }, { 29,  8 },
                { 30,  8 }, { 31,  8 }, { 32,  8 }, { 33,  9 }, { 37,  9 },
                { 34,  8 }, { 35,  8 }, { 36,  8 }, { 38, 11 }, { 40, 11 },
                { 39, 10 }, { 41, 15 }, { 43, 15 }, { 44, 15 }, { 45, 15 },
                { 50, 15 }, { 51, 15 }, { 64, 15 }, { 66, 15 }, { 49, 12 },
                { 47, 11 }, { 42, 10 }, { 46,  9 }, { 55, 10 }, { 56, 11 },
                { 63, 12 }, { 67, 15 }, { 68, 15 }, { 69, 15 }, { 70, 15 },
                { 71, 15 }, { 72, 15 }, { 74, 14 }, { 48,  7 }, { 53,  7 },
                { 52,  5 }, { 54,  8 }, { 58, 10 }, { 61, 10 }, { 62, 10 },
                { 65, 11 }, { 75, 12 }, { 76, 12 }, { 57,  7 }, { 59,  8 },
                { 60,  8 }, { 73,  7 },
            },
            { /* AC lowquant table group 0, table 4 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  6 }, {  7,  7 }, {  9,  7 }, {  8,  6 },
                { 10,  8 }, { 11,  8 }, { 12,  8 }, { 13,  9 }, { 14,  9 },
                { 15,  8 }, { 37,  8 }, { 31,  7 }, { 18,  6 }, { 17,  5 },
                { 16,  4 }, { 19,  6 }, { 21,  6 }, { 22,  5 }, { 20,  4 },
                { 23,  5 }, { 24,  6 }, { 25,  6 }, { 26,  6 }, { 27,  6 },
                { 28,  6 }, { 29,  6 }, { 30,  6 }, { 32,  7 }, { 33,  7 },
                { 34,  7 }, { 35,  7 }, { 36,  7 }, { 38, 11 }, { 50, 15 },
                { 51, 15 }, { 55, 15 }, { 56, 15 }, { 64, 15 }, { 69, 15 },
                { 70, 14 }, { 71, 14 }, { 72, 14 }, { 75, 14 }, { 76, 14 },
                { 45, 10 }, { 42,  9 }, { 41,  8 }, { 39,  7 }, { 40,  7 },
                { 43,  9 }, { 44,  9 }, { 46,  9 }, { 47, 10 }, { 58, 10 },
                { 49,  8 }, { 54,  9 }, { 62, 10 }, { 66, 10 }, { 48,  6 },
                { 53,  7 }, { 59,  7 }, { 52,  4 }, { 57,  6 }, { 60,  8 },
                { 61,  8 }, { 63,  9 }, { 65,  9 }, { 67, 10 }, { 68, 10 },
                { 74,  9 }, { 73,  5 },
            },
            { /* AC lowquant table group 0, table 5 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  7 }, {  7,  8 }, {  8,  8 }, {  9,  8 },
                { 10,  9 }, { 11, 11 }, { 14, 11 }, { 13, 10 }, { 12,  8 },
                { 15, 15 }, { 42, 15 }, { 50, 15 }, { 51, 15 }, { 62, 15 },
                { 64, 15 }, { 67, 15 }, { 68, 15 }, { 69, 14 }, { 70, 14 },
                { 71, 14 }, { 72, 14 }, { 38, 11 }, { 40, 10 }, { 33,  9 },
                { 17,  5 }, { 18,  6 }, { 19,  7 }, { 24,  7 }, { 16,  3 },
                { 20,  4 }, { 21,  6 }, { 23,  6 }, { 22,  5 }, { 25,  8 },
                { 27,  8 }, { 26,  7 }, { 28,  7 }, { 29,  8 }, { 31,  8 },
                { 30,  7 }, { 32,  8 }, { 34,  9 }, { 35,  9 }, { 36,  9 },
                { 37,  9 }, { 39,  9 }, { 41, 11 }, { 44, 11 }, { 43, 10 },
                { 45, 11 }, { 47, 11 }, { 46, 10 }, { 56,  9 }, { 49,  8 },
                { 48,  6 }, { 54,  7 }, { 55,  7 }, { 53,  5 }, { 52,  4 },
                { 57,  6 }, { 58,  8 }, { 59,  8 }, { 60, 10 }, { 61, 11 },
                { 75, 11 }, { 63, 10 }, { 65, 10 }, { 66, 10 }, { 74, 10 },
                { 76,  9 }, { 73,  5 },
            },
            { /* AC lowquant table group 0, table 6 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  6 }, {  4,  6 },
                {  5,  8 }, {  6,  9 }, {  7, 10 }, {  8, 10 }, {  9,  9 },
                { 10, 15 }, { 11, 15 }, { 13, 15 }, { 15, 15 }, { 37, 15 },
                { 46, 15 }, { 47, 15 }, { 49, 15 }, { 50, 15 }, { 51, 15 },
                { 53, 15 }, { 54, 15 }, { 55, 15 }, { 56, 15 }, { 58, 15 },
                { 60, 15 }, { 61, 15 }, { 62, 15 }, { 63, 15 }, { 64, 15 },
                { 67, 15 }, { 68, 15 }, { 69, 15 }, { 70, 15 }, { 71, 15 },
                { 72, 15 }, { 74, 14 }, { 75, 14 }, { 76, 14 }, { 12, 10 },
                { 14, 10 }, { 36, 10 }, { 21,  9 }, { 18,  8 }, { 19,  8 },
                { 22,  8 }, { 32,  8 }, { 17,  5 }, { 16,  4 }, { 20,  5 },
                { 26,  5 }, { 25,  4 }, { 23,  3 }, { 24,  3 }, { 27,  6 },
                { 28,  6 }, { 29,  7 }, { 30,  7 }, { 31,  7 }, { 33,  8 },
                { 34,  9 }, { 38,  9 }, { 35,  8 }, { 41,  9 }, { 42, 10 },
                { 45, 10 }, { 43,  8 }, { 44,  8 }, { 39,  6 }, { 40,  6 },
                { 48,  9 }, { 57,  9 }, { 52,  8 }, { 59,  9 }, { 65, 10 },
                { 66, 10 }, { 73,  8 },
            },
            { /* AC lowquant table group 0, table 7 */
                {  0,  4 }, {  1, 11 }, {  2, 11 }, {  3, 11 }, {  4, 11 },
                {  5, 11 }, {  6, 11 }, {  7, 11 }, {  8, 11 }, {  9, 11 },
                { 10, 11 }, { 11, 11 }, { 12, 11 }, { 13, 11 }, { 14, 11 },
                { 15, 11 }, { 16, 11 }, { 17, 10 }, { 18, 10 }, { 19, 10 },
                { 20, 10 }, { 21, 10 }, { 22, 10 }, { 25, 10 }, { 28, 10 },
                { 29, 10 }, { 30, 10 }, { 31, 10 }, { 32, 10 }, { 33, 10 },
                { 34, 10 }, { 35, 10 }, { 36, 10 }, { 37, 10 }, { 38, 10 },
                { 39, 10 }, { 40, 10 }, { 41, 10 }, { 42, 10 }, { 43, 10 },
                { 44, 10 }, { 45, 10 }, { 46, 10 }, { 47, 10 }, { 48, 10 },
                { 49, 10 }, { 50, 10 }, { 51, 10 }, { 52, 10 }, { 53, 10 },
                { 54, 10 }, { 55, 10 }, { 56, 10 }, { 57, 10 }, { 58, 10 },
                { 59, 10 }, { 60, 10 }, { 61, 10 }, { 62, 10 }, { 63, 10 },
                { 64, 10 }, { 65, 10 }, { 66, 10 }, { 67, 10 }, { 68, 10 },
                { 69, 10 }, { 70, 10 }, { 71, 10 }, { 72, 10 }, { 73, 10 },
                { 74, 10 }, { 75, 10 }, { 76, 10 }, { 26,  4 }, { 27,  4 },
                { 24,  2 }, { 23,  1 },
            },
        },
        {
            { /* AC lowquant table group 1, table 0 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  7 }, {  7,  8 }, {  8,  8 }, {  6,  6 }, {  9,  9 },
                { 10, 10 }, { 14, 15 }, { 47, 15 }, { 49, 14 }, { 50, 14 },
                { 51, 14 }, { 54, 14 }, { 55, 14 }, { 56, 14 }, { 58, 14 },
                { 15, 11 }, { 11,  9 }, { 12,  9 }, { 13,  9 }, { 37,  9 },
                { 32,  8 }, { 17,  5 }, { 16,  4 }, { 18,  6 }, { 19,  7 },
                { 21,  7 }, { 20,  5 }, { 22,  5 }, { 25,  5 }, { 24,  4 },
                { 23,  3 }, { 26,  5 }, { 27,  5 }, { 28,  5 }, { 29,  6 },
                { 30,  6 }, { 31,  7 }, { 33,  8 }, { 34,  8 }, { 35,  8 },
                { 36,  8 }, { 38, 10 }, { 44, 11 }, { 46, 11 }, { 45, 10 },
                { 53, 10 }, { 41,  8 }, { 39,  6 }, { 40,  7 }, { 42,  8 },
                { 43,  8 }, { 48,  7 }, { 57,  7 }, { 52,  6 }, { 59,  8 },
                { 60,  9 }, { 61, 11 }, { 63, 11 }, { 62, 10 }, { 64, 14 },
                { 67, 14 }, { 68, 14 }, { 69, 14 }, { 70, 14 }, { 71, 14 },
                { 72, 14 }, { 76, 14 }, { 75, 11 }, { 66, 10 }, { 74,  9 },
                { 65,  8 }, { 73,  6 },
            },
            { /* AC lowquant table group 1, table 1 */
                {  0,  2 }, {  1,  3 }, {  2,  4 }, {  3,  5 }, {  4,  6 },
                {  5,  6 }, {  6,  7 }, {  7,  8 }, {  8,  8 }, {  9,  8 },
                { 10,  9 }, { 11,  9 }, { 12, 11 }, { 13, 11 }, { 14, 11 },
                { 15, 11 }, { 24,  9 }, { 23,  8 }, { 17,  5 }, { 18,  6 },
                { 19,  7 }, { 25, 10 }, { 27, 10 }, { 26,  9 }, { 28, 10 },
                { 29, 12 }, { 35, 12 }, { 34, 11 }, { 30, 10 }, { 31, 10 },
                { 21,  6 }, { 32, 10 }, { 33, 10 }, { 36, 10 }, { 37, 12 },
                { 38, 12 }, { 39, 15 }, { 40, 15 }, { 41, 15 }, { 42, 15 },
                { 43, 14 }, { 44, 14 }, { 45, 14 }, { 51, 14 }, { 61, 14 },
                { 64, 14 }, { 46, 11 }, { 47, 11 }, { 49, 10 }, { 50, 12 },
                { 63, 12 }, { 59, 11 }, { 56, 10 }, { 48,  8 }, { 55,  8 },
                { 16,  3 }, { 20,  4 }, { 22,  4 }, { 52,  4 }, { 53,  6 },
                { 54,  7 }, { 58,  8 }, { 60, 10 }, { 62, 11 }, { 65, 14 },
                { 66, 14 }, { 67, 14 }, { 68, 14 }, { 69, 14 }, { 70, 14 },
                { 71, 14 }, { 72, 14 }, { 74, 11 }, { 75, 11 }, { 76, 10 },
                { 57,  6 }, { 73,  6 },
            },
            { /* AC lowquant table group 1, table 2 */
                {  0,  3 }, {  1,  4 }, {  2,  5 }, {  3,  6 }, {  4,  7 },
                {  5,  8 }, {  6,  8 }, {  7,  8 }, {  8, 10 }, { 10, 10 },
                {  9,  9 }, { 11, 10 }, { 12, 16 }, { 15, 16 }, { 38, 16 },
                { 44, 16 }, { 46, 15 }, { 47, 15 }, { 50, 15 }, { 51, 15 },
                { 59, 15 }, { 60, 15 }, { 61, 15 }, { 62, 15 }, { 64, 15 },
                { 68, 15 }, { 69, 15 }, { 70, 15 }, { 71, 15 }, { 72, 15 },
                { 37, 11 }, { 13, 10 }, { 14, 10 }, { 19,  8 }, { 18,  6 },
                { 17,  5 }, { 21,  5 }, { 23,  7 }, { 24,  9 }, { 25,  9 },
                { 26,  9 }, { 27,  9 }, { 28,  9 }, { 29, 10 }, { 30, 10 },
                { 31, 10 }, { 32, 10 }, { 33, 10 }, { 34, 10 }, { 35,  9 },
                { 36, 10 }, { 39, 10 }, { 40, 11 }, { 42, 11 }, { 41, 10 },
                { 43, 10 }, { 45, 11 }, { 63, 11 }, { 16,  3 }, { 20,  3 },
                { 22,  4 }, { 48,  7 }, { 49,  9 }, { 65, 11 }, { 66, 11 },
                { 67, 11 }, { 74, 11 }, { 56,  8 }, { 54,  6 }, { 55,  6 },
                { 58,  7 }, { 75,  8 }, { 76,  8 }, { 52,  3 }, { 53,  4 },
                { 57,  5 }, { 73,  5 },
            },
            { /* AC lowquant table group 1, table 3 */
                {  0,  2 }, {  1,  3 }, {  2,  4 }, {  3,  4 }, {  4,  5 },
                {  5,  5 }, {  6,  6 }, {  7,  6 }, {  8,  6 }, {  9,  6 },
                { 10,  7 }, { 11,  7 }, { 12,  8 }, { 13,  8 }, { 14,  8 },
                { 15,  9 }, { 19,  9 }, { 17,  6 }, { 18,  7 }, { 21,  8 },
                { 36,  8 }, { 16,  4 }, { 20,  6 }, { 22,  7 }, { 28,  7 },
                { 23,  6 }, { 24,  6 }, { 25,  6 }, { 26,  6 }, { 27,  6 },
                { 29,  7 }, { 30,  7 }, { 31,  7 }, { 32,  7 }, { 33,  7 },
                { 34,  7 }, { 35,  7 }, { 37,  8 }, { 38,  9 }, { 39, 11 },
                { 41, 15 }, { 42, 15 }, { 43, 15 }, { 44, 15 }, { 45, 15 },
                { 51, 15 }, { 54, 15 }, { 55, 15 }, { 49, 12 }, { 40, 10 },
                { 46,  7 }, { 47,  8 }, { 48,  8 }, { 50,  9 }, { 53,  9 },
                { 56, 15 }, { 67, 15 }, { 68, 15 }, { 69, 15 }, { 70, 14 },
                { 71, 14 }, { 72, 14 }, { 74, 14 }, { 75, 14 }, { 76, 14 },
                { 58, 11 }, { 65, 11 }, { 66, 11 }, { 64,  9 }, { 52,  7 },
                { 57,  8 }, { 61,  8 }, { 60,  7 }, { 59,  6 }, { 62,  8 },
                { 73,  8 }, { 63,  7 },
            },
            { /* AC lowquant table group 1, table 4 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  6 }, {  4,  6 },
                {  5,  7 }, {  6,  7 }, {  7,  8 }, {  8,  8 }, {  9,  8 },
                { 10,  9 }, { 11,  9 }, { 12, 10 }, { 13, 10 }, { 14, 14 },
                { 69, 14 }, { 70, 14 }, { 72, 14 }, { 15, 12 }, { 44, 11 },
                { 37, 10 }, { 29,  8 }, { 19,  7 }, { 18,  6 }, { 17,  5 },
                { 21,  6 }, { 24,  6 }, { 16,  3 }, { 20,  4 }, { 22,  5 },
                { 23,  5 }, { 25,  6 }, { 26,  6 }, { 27,  7 }, { 28,  7 },
                { 30,  7 }, { 31,  8 }, { 32,  8 }, { 33,  8 }, { 34,  8 },
                { 35,  8 }, { 36,  9 }, { 38, 10 }, { 43, 10 }, { 39,  7 },
                { 40,  8 }, { 41,  9 }, { 42,  9 }, { 45,  9 }, { 46,  9 },
                { 47, 10 }, { 50, 12 }, { 51, 12 }, { 62, 11 }, { 56,  9 },
                { 48,  7 }, { 49,  8 }, { 54,  8 }, { 55,  8 }, { 58,  8 },
                { 52,  4 }, { 53,  6 }, { 57,  6 }, { 59,  9 }, { 60, 10 },
                { 61, 10 }, { 63, 10 }, { 64, 11 }, { 67, 11 }, { 65,  9 },
                { 66,  9 }, { 68, 11 }, { 71, 11 }, { 76, 10 }, { 74,  9 },
                { 75,  9 }, { 73,  6 },
            },
            { /* AC lowquant table group 1, table 5 */
                {  0,  2 }, {  1,  3 }, {  2,  4 }, {  3,  5 }, {  4,  5 },
                {  5,  6 }, {  6,  6 }, {  7,  7 }, {  8,  7 }, {  9,  7 },
                { 10,  8 }, { 11,  8 }, { 12,  8 }, { 13,  9 }, { 14, 10 },
                { 39, 11 }, { 40, 12 }, { 41, 12 }, { 15,  9 }, { 37,  9 },
                { 19,  8 }, { 18,  7 }, { 21,  7 }, { 17,  5 }, { 16,  3 },
                { 20,  5 }, { 22,  6 }, { 24,  6 }, { 23,  5 }, { 25,  7 },
                { 26,  7 }, { 27,  7 }, { 28,  8 }, { 29,  8 }, { 30,  7 },
                { 31,  8 }, { 32,  8 }, { 33,  8 }, { 34,  8 }, { 35,  8 },
                { 36,  8 }, { 38,  9 }, { 42, 15 }, { 44, 15 }, { 45, 15 },
                { 56, 15 }, { 43, 13 }, { 51, 13 }, { 66, 13 }, { 58, 11 },
                { 49, 10 }, { 46,  8 }, { 47,  9 }, { 50,  9 }, { 48,  8 },
                { 53,  7 }, { 54,  9 }, { 55,  9 }, { 59,  8 }, { 52,  5 },
                { 57,  7 }, { 60,  8 }, { 61,  8 }, { 62,  9 }, { 64, 11 },
                { 65, 12 }, { 67, 15 }, { 68, 15 }, { 69, 15 }, { 70, 15 },
                { 71, 15 }, { 72, 15 }, { 74, 14 }, { 75, 11 }, { 76, 11 },
                { 63,  8 }, { 73,  7 },
            },
            { /* AC lowquant table group 1, table 6 */
                {  0,  3 }, {  1,  4 }, {  2,  4 }, {  3,  5 }, {  4,  5 },
                {  5,  6 }, {  6,  6 }, {  7,  7 }, {  8,  8 }, {  9,  8 },
                { 10,  8 }, { 11,  9 }, { 12,  9 }, { 13,  9 }, { 14, 11 },
                { 15, 12 }, { 45, 12 }, { 38, 10 }, { 33,  8 }, { 16,  3 },
                { 17,  5 }, { 18,  6 }, { 19,  7 }, { 27,  7 }, { 20,  4 },
                { 21,  6 }, { 25,  6 }, { 22,  5 }, { 23,  4 }, { 24,  5 },
                { 26,  6 }, { 28,  7 }, { 29,  7 }, { 30,  7 }, { 31,  7 },
                { 32,  7 }, { 34,  8 }, { 35,  8 }, { 36,  9 }, { 41,  9 },
                { 37,  8 }, { 39,  7 }, { 40,  8 }, { 42, 11 }, { 47, 15 },
                { 50, 15 }, { 51, 15 }, { 56, 15 }, { 64, 15 }, { 67, 15 },
                { 68, 15 }, { 69, 15 }, { 70, 14 }, { 71, 14 }, { 72, 14 },
                { 76, 14 }, { 44, 10 }, { 43,  9 }, { 46,  9 }, { 54,  9 },
                { 55, 11 }, { 63, 11 }, { 61, 10 }, { 58,  9 }, { 48,  6 },
                { 49,  7 }, { 53,  7 }, { 52,  5 }, { 57,  6 }, { 59,  8 },
                { 60,  9 }, { 62, 10 }, { 74, 10 }, { 65,  8 }, { 66,  9 },
                { 75,  9 }, { 73,  5 },
            },
            { /* AC lowquant table group 1, table 7 */
                {  0,  2 }, {  1,  4 }, {  2,  5 }, {  3,  6 }, {  4,  7 },
                {  5,  7 }, {  6,  8 }, {  7,  8 }, {  8,  9 }, {  9,  9 },
                { 10,  9 }, { 11, 10 }, { 12, 15 }, { 13, 15 }, { 14, 15 },
                { 15, 15 }, { 32, 15 }, { 36, 15 }, { 38, 15 }, { 41, 15 },
                { 42, 15 }, { 45, 15 }, { 47, 15 }, { 50, 15 }, { 51, 15 },
                { 61, 15 }, { 62, 14 }, { 34, 11 }, { 18,  6 }, { 17,  5 },
                { 19,  7 }, { 23,  8 }, { 24,  8 }, { 21,  6 }, { 25,  9 },
                { 26, 10 }, { 28, 10 }, { 27,  9 }, { 29,  9 }, { 30, 10 },
                { 31, 10 }, { 33, 10 }, { 35, 11 }, { 40, 11 }, { 37, 10 },
                { 43, 11 }, { 44, 11 }, { 39,  9 }, { 46, 11 }, { 60, 11 },
                { 49, 10 }, { 56,  9 }, { 59,  9 }, { 63, 14 }, { 64, 14 },
                { 67, 14 }, { 68, 14 }, { 69, 14 }, { 70, 14 }, { 71, 14 },
                { 72, 14 }, { 74, 11 }, { 76, 10 }, { 48,  7 }, { 16,  3 },
                { 20,  4 }, { 22,  4 }, { 52,  3 }, { 53,  5 }, { 54,  7 },
                { 55,  7 }, { 58,  7 }, { 65,  9 }, { 66,  9 }, { 75,  8 },
                { 57,  5 }, { 73,  5 },
            },
        },
    },
};
#define MAX_AC_VLC_BITS 16

#endif /* AVCODEC_INTRAX8HUF_H */
