#include "expresscpp/impl/utils.hpp"

#include "boost/lexical_cast.hpp"
#include "boost/uuid/uuid_io.hpp"
#include "expresscpp/console.hpp"

namespace expresscpp {

std::string boostUUIDToString(const boost::uuids::uuid& uuid) {
  return boost::lexical_cast<std::string>(uuid);
}

std::string getFileName(const std::string& s) {
  char sep = '/';

#ifdef _WIN32
  sep = '\\';
#endif

  size_t i = s.rfind(sep, s.length());
  if (i != std::string::npos) {
    return (s.substr(i + 1, s.length() - i));
  }

  return ("");
}

boost::beast::string_view mime_type(boost::beast::string_view path) {
  using boost::beast::iequals;
  auto const ext = [&path] {
    auto const pos = path.rfind(".");
    if (pos == boost::beast::string_view::npos) return boost::beast::string_view{};
    return path.substr(pos);
  }();
  if (iequals(ext, ".htm")) {
    return "text/html";
  }
  if (iequals(ext, ".html")) {
    return "text/html";
  }
  if (iequals(ext, ".php")) {
    return "text/html";
  }
  if (iequals(ext, ".css")) {
    return "text/css";
  }
  if (iequals(ext, ".txt")) {
    return "text/plain";
  }
  if (iequals(ext, ".js")) {
    return "application/javascript";
  }
  if (iequals(ext, ".xml")) {
    return "application/xml";
  }
  if (iequals(ext, ".swf")) {
    return "application/x-shockwave-flash";
  }
  if (iequals(ext, ".flv")) {
    return "video/x-flv";
  }
  if (iequals(ext, ".png")) {
    return "image/png";
  }
  if (iequals(ext, ".jpe")) {
    return "image/jpeg";
  }
  if (iequals(ext, ".jpeg")) {
    return "image/jpeg";
  }
  if (iequals(ext, ".jpg")) {
    return "image/jpeg";
  }
  if (iequals(ext, ".gif")) {
    return "image/gif";
  }
  if (iequals(ext, ".bmp")) {
    return "image/bmp";
  }
  if (iequals(ext, ".ico")) {
    return "image/vnd.microsoft.icon";
  }
  if (iequals(ext, ".tiff")) {
    return "image/tiff";
  }
  if (iequals(ext, ".tif")) {
    return "image/tiff";
  }
  if (iequals(ext, ".svg")) {
    return "image/svg+xml";
  }
  if (iequals(ext, ".svgz")) {
    return "image/svg+xml";
  }
  if (iequals(ext, ".json")) {
    return "application/json";
  }

  return "application/text";
}

}  // namespace expresscpp
