#ifndef _PARSETABLEENTRY_H_INCLUDED_
#define _PARSETABLEENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// ParseTableEntry.h
// -----------------
// Dragon parse table entry interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: ParseTableEntry
// 
// Description: 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

class ParseTableEntry {
    
public:

    enum Action { SHIFT, REDUCE, JUMP, ACCEPT };

    ParseTableEntry();
    ParseTableEntry(unsigned long state, const Chain& token, 
		    Action action, unsigned long arg = 0);
    
    unsigned long getState();
    const Chain& getToken();
    Action getAction();
    unsigned long getArg();
    
    ParseTableEntry& operator = (const ParseTableEntry& e);
    bool operator == (const ParseTableEntry& e);
    
private:
    
    unsigned long _state;
    Chain _token; 
    Action _action;
    unsigned long _arg;
    
};

#endif





