///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Trans.cc
// ------------
// dragon LR1 trans implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LR1Trans
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include "LR1Trans.h"


LR1Trans::LR1Trans()
{
}

LR1Trans::LR1Trans(int sid, int tid, const Chain& token)
{
    _sid = sid;
    _tid = tid;
    _token = (Chain)token;
}

LR1Trans::~LR1Trans()
{
}

int LR1Trans::getSid() const
{
    return _sid;
}

int LR1Trans::getTid() const
{
    return _tid;
}

const Chain& LR1Trans::getToken() const
{
    return _token;
}

LR1Trans& LR1Trans::operator = (const LR1Trans& t)
{
    _sid = t._sid;
    _tid = t._tid;
    _token = (Chain)t._token;    
    return (*this);
}
	
bool LR1Trans::operator == (const LR1Trans& t) const
{
    if (_sid == t._sid && _tid == t._tid && (Chain)_token == (Chain)t._token)
    {
	return true;
    }
    return false;
    
}







