#ifndef _FSMTRANSITION_H_INCLUDED_
#define _FSMTRANSITION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// FSMTransition.h
// ---------------
// Dragon final state machine transition interface definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: FSMTransition
// 
// Description: state transition description of the dragon FSM 
//
//////////////////////////////////////////////////////////////////////////////

class FSMTransition {

 public:

  FSMTransition();
  FSMTransition(const FSMTransition& x);
  FSMTransition(unsigned long source, char sign);
  FSMTransition(unsigned long source, unsigned long target, char sign);
  ~FSMTransition();
  void setSource(unsigned long source);
  void setTarget(unsigned long target);
  char Sign();
  unsigned long Source();
  unsigned long Target();
  FSMTransition operator = (const FSMTransition& x);
  bool operator < (FSMTransition x);
  bool operator > (FSMTransition x);
  bool operator == (FSMTransition x);

 private:
 
  unsigned long _source;
  unsigned long _target;  
  char _sign;
};


#endif







