package main

import "fmt"
import "os"
import "G7"

type MyAction struct {
   feed string
   i int
   tl []string
   isReserved bool
   reservedToken G7.Token
}
 
func ( ma *MyAction ) A1() {
        fmt.Printf("Action A1 called ...\n")
	fmt.Printf("TL Size = %d\n", len(ma.tl))
}
 
func ( ma *MyAction ) a2() {
        fmt.Printf("Action A3 called ...\n")
}
 
func ( ma *MyAction ) A3( ) {
        fmt.Printf("Action A3 called ...\n")

	fmt.Printf("TL Size = %d\n", len(ma.tl))
	for i, t := range ma.tl {
	   fmt.Printf("At pos %d, Token=%s\n", i, t)
	}
}

func ( ma *MyAction ) SetTokenList( tl []string ) {
        ma.tl = tl
}

func ( ma *MyAction ) NextChar() byte {
 
   if ma.i < len(ma.feed) {
      fmt.Printf("Next Char = %c\n", ma.feed[ma.i])

      c := ma.feed[ma.i]

      if c == '\'' {
      	 fmt.Println("Reading string")
         ma.i++
	 c := ma.feed[ma.i]
         for c != '\'' && c != 0 {
            fmt.Printf("Next String Char = %c\n", ma.feed[ma.i])
            ma.isReserved = true
            ma.reservedToken = G7.Token_RES1
	    ma.i++
	    c = ma.feed[ma.i]
	 }
	 ma.i++
	 c = ma.feed[ma.i]
	 return c
      } else {
         ma.i++
      }
      
      return c 
   }
   return 0
}
 
func ( ma *MyAction ) BackChar() {
     fmt.Println("BackChar called")
     ma.i--
}

func ( ma *MyAction ) IsReserved() bool {
 
     return ma.isReserved
}

func ( ma *MyAction ) GetAndResetReserved() G7.Token {

     ma.isReserved = false
     return ma.reservedToken
}

func main() {
   if len(os.Args) < 2 {
      fmt.Printf("Argument missing\n")
   } else {
 
      fmt.Printf("Testing parser with %s %d\n", os.Args[1], len(os.Args))
 
      ma :=  MyAction { i: 0, feed: os.Args[1], isReserved: false }
      p := G7.NewParser( &ma ) // { feed: os.Args[1] } ) )
      if p.Parse() {
         fmt.Println("Parse OK")
      } else {
         fmt.Printf("Parse Failed : %s\n", p.Error)
      }
   }
}
 
